unit DREMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, Menus, StdCtrls, Buttons, ObjEdit, ObjInsp, DB, DBTables,
  ObjIntf, ObjCPal, ObjLib, ObjStart, DCLIntf, ObjPkg;

{Note: Fake delphi IDE: TAppBuilder}

type
  TAppBuilder = class(TForm)
    Panel1: TPanel;
    Splitter1: TSplitter;
    Panel2: TPanel;
    MainMenu1: TMainMenu;
    FileMenu: TMenuItem;
    FileNewFormItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileClosedFilesItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    FileSaveAllItem: TMenuItem;
    FileCloseItem: TMenuItem;
    FileCloseAllItem: TMenuItem;
    FileExitItem: TMenuItem;
    EditMenu: TMenuItem;
    EditUndoItem: TMenuItem;
    EditRedoItem: TMenuItem;
    N15: TMenuItem;
    EditCutItem: TMenuItem;
    EditCopyItem: TMenuItem;
    EditPasteItem: TMenuItem;
    EditDeleteItem: TMenuItem;
    EditSelectAll: TMenuItem;
    N14: TMenuItem;
    EditAlignGridItem: TMenuItem;
    EditFrontItem: TMenuItem;
    EditBackItem: TMenuItem;
    EditAlignItem: TMenuItem;
    EditSizeItem: TMenuItem;
    EditScaleItem: TMenuItem;
    EditTabOrderItem: TMenuItem;
    CreationOrderItem: TMenuItem;
    ViewsMenu: TMenuItem;
    ViewObjectInspector: TMenuItem;
    ViewBrowserItem: TMenuItem;
    N1: TMenuItem;
    ViewSpeedBarItem: TMenuItem;
    ViewPaletteItem: TMenuItem;
    ViewSwapSourceFormItem: TMenuItem;
    ToolsMenu: TMenuItem;
    ToolsOptionsItem: TMenuItem;
    ToolsToolsItem: TMenuItem;
    HelpMenu: TMenuItem;
    HelpContentsItem: TMenuItem;
    HelpWhatsNew: TMenuItem;
    N13: TMenuItem;
    HelpAboutItem: TMenuItem;
    PaletteMenu: TPopupMenu;
    ShowPaletteHints: TMenuItem;
    Hide2: TMenuItem;
    PaletteHelpItem: TMenuItem;
    N9: TMenuItem;
    Configure2: TMenuItem;
    SpeedbarMenu: TPopupMenu;
    ShowSpeedHints: TMenuItem;
    Hide1: TMenuItem;
    SpeedbarHelpItem: TMenuItem;
    N12: TMenuItem;
    Configure1: TMenuItem;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    PrinterSetupDialog: TPrinterSetupDialog;
    SaveFileDialog: TSaveDialog;
    OpenFileDialog: TOpenDialog;
    btnOpenReport: TSpeedButton;
    btnSaveReport: TSpeedButton;
    AdvSpeedButton1: TSpeedButton;
    btnNew: TSpeedButton;
    AdvSpeedButton2: TSpeedButton;
    PackageDialog: TOpenDialog;
    CompPal: TComponentPalette;
    btnRun: TSpeedButton;
    btnEdit: TSpeedButton;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileNewFormItemClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btnNewClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure btnOpenReportClick(Sender: TObject);
    procedure btnSaveReportClick(Sender: TObject);
    procedure AdvSpeedButton1Click(Sender: TObject);
    procedure ViewObjectInspectorClick(Sender: TObject);
    procedure AdvSpeedButton2Click(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure btnRunClick(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure FileSaveAllItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FileCloseAllItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure EditCutItemClick(Sender: TObject);
    procedure EditCopyItemClick(Sender: TObject);
    procedure EditPasteItemClick(Sender: TObject);
    procedure EditDeleteItemClick(Sender: TObject);
  private
    FEditors: TStringList;
    FDPLPath: String;
    FOldForm: TCustomForm;
    FOldEditor: TObjectEditor;
    FFormClass: TFormClass;
    procedure Resized;
    procedure Open;
    procedure OpenFile(AFileName: String);
    function New: TObjectEditor;
    function NewByFileName(AFileName: String): TObjectEditor;
    function Save: Boolean;
    function SaveAs: String;
    function SaveAll(APrompt: Boolean): Boolean;
    procedure CloseEditor;
    procedure CloseAll;
    procedure DoEditorDestroy(Sender: TObject);
  private
    procedure WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
  public
    { Public declarations }
  end;

  TTestForm = class(TForm)
  public
    destructor Destroy; override;
  end;

var
  AppBuilder: TAppBuilder;

implementation

uses Registry, IniFiles, ObjAPal;

{$R *.DFM}

destructor TTestForm.Destroy;
begin
  inherited;
end;

procedure TAppBuilder.WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo);
begin
  inherited;
  with Message.MinMaxInfo^ do
  begin
    ptMaxSize.y := Height;
    ptMaxTrackSize.y := Height;
  end;
end;

procedure TAppBuilder.FormCreate(Sender: TObject);
var
  Ini: TIniFile;

  procedure InitFormClass;
  var
    AName: String;
  begin
    AName := Ini.ReadString('Form', 'FormClass', '');
    if AName <> '' then
      FFormClass := TFormClass(FindClass(AName))
    else
      FFormClass := TTestForm;
  end;

  procedure LoadPackages;
  const
    DelphiMacro = '$(DELPHI)';
  var
    Packages: TStringList;
    I, J: Integer;
    Reg: TRegistry;
    APath, S: String;
  begin
    Packages := TStringList.Create;
    try
      Ini.ReadSection('Packages', Packages);
      if Packages.Count = 0 then
      begin
        Reg := TRegistry.Create;
        try
          Reg.RootKey := HKEY_CURRENT_USER;
          if Reg.OpenKey('\Software\Borland\Delphi\4.0\Known Packages', False) then
          begin
            Reg.GetValueNames(Packages);
          end;
          Reg.CloseKey;
          Reg.RootKey := HKEY_LOCAL_MACHINE;
          Reg.OpenKey('\Software\Borland\Delphi\4.0', False);
          APath := Reg.ReadString('RootDir');
        finally
          Reg.Free;
        end;
      end;
      for I := 0 to Packages.Count-1 do
      begin
        S := Packages[I];
        J := Pos(DelphiMacro, S);
        if J > 0 then
        begin
          Delete(S, J, Length(DelphiMacro));
          Insert(APath, S, J);
          Packages[I] := S;
        end;
      end;
      for I := 0 to Packages.Count-1 do
      try
        LoadPackageEx(Packages[I]);
      except
        MessageDlg(Exception(ExceptObject).Message, mtError, [mbOK], 0);
      end;
    finally
      Packages.Free;
    end;
  end;

  procedure RemoveHideComponents;
  var
    AList: TStringList;
    I: Integer;
    APage, AComponents: String;
  begin
    AList := TStringList.Create;
    try
      Ini.ReadSectionValues('Hide Components', AList);
      for I := 0 to AList.Count-1 do
      begin
        APage := AList.Names[I];
        AComponents := Trim(AList.Values[APage]);
        if CompareText(AComponents, 'ALL') <> 0 then
          UnRegisterComponents(APage, AComponents)
        else
          RemoveComponentPage(APage);
      end;
    finally
      AList.Free;
    end;
  end;

  procedure OpenParamForm;
  var
    AName: String;
  begin
    AName := ParamStr(1);
    if AName <> '' then
    begin
      if FileExists(AName) then
        OpenFile(AName)
      else
        NewByFileName(AName);
      OpenFileDialog.InitialDir := ExtractFilePath(AName);
    end;
  end;

begin
  FEditors := TStringList.Create;
  Ini := TIniFile.Create(ChangeFileExt(Application.ExeName, '.INI'));
  try
    InitFormClass;
    LoadPackages;
    RemoveHideComponents;
  finally
    Ini.Free;
  end;

  CompPal.RefreshTabs;

  Left := 0;
  Top := 0;
  Width := Screen.Width;

  with ObjectInspector do
  begin
    Left := 0;
    Top := Self.Top + Self.Height;
  end;
  ObjectInspector.Show;
  OpenParamForm;
end;

procedure TAppBuilder.FormDestroy(Sender: TObject);
begin
  FEditors.Free;
  FEditors := nil;
end;

procedure TAppBuilder.FileNewFormItemClick(Sender: TObject);
begin
  New;
end;

procedure TAppBuilder.FormResize(Sender: TObject);
begin
  Resized;
end;

procedure TAppBuilder.Resized;
begin
end;

procedure TAppBuilder.btnNewClick(Sender: TObject);
begin
  New;
end;

function TAppBuilder.New: TObjectEditor;
begin
  Result := NewByFileName('');
end;

function TAppBuilder.NewByFileName(AFileName: String): TObjectEditor;
var
  AForm: TForm;
begin
  AForm := FFormClass.CreateNew(Application);
  AForm.SetBounds(ObjectInspector.Width, Top + Height, 500, 400);
  AForm.Name := GetUniqueName(Application, GetBaseName(AForm.ClassType));
  ShowWindow(AForm.Handle, SW_SHOW);
  Result := EditControlEx(AForm, ObjectInspector);
  Result.DefaultRealTime := True;
  Result.OnDestroy := DoEditorDestroy;
  FEditors.AddObject(AFileName, Result);
end;

function TAppBuilder.Save: Boolean;
var
  AEditor: TObjectEditor;
  I: Integer;
  AName: String;
begin
  AEditor := GetActivateEditor;
  Result := True;
  if AEditor <> nil then
  begin
    I := FEditors.IndexOfObject(AEditor);
    AName := FEditors[I];
    if AName <> '' then
    begin
      AEditor.SaveDFMToFile(AName);
      AEditor.ClearModify;
    end else
      Result := SaveAs <> '';
  end;
end;

function TAppBuilder.SaveAs: String;
var
  AEditor: TObjectEditor;
  I: Integer;
begin
  Result := '';
  AEditor := GetActivateEditor;
  if AEditor <> nil then
  begin
    I := FEditors.IndexOfObject(AEditor);
    SaveFileDialog.FileName := FEditors[I];
    if SaveFileDialog.Execute then
    begin
      Result := SaveFileDialog.FileName;
      AEditor.SaveDFMToFile(Result);
      FEditors[I] := Result;
      AEditor.ClearModify;
    end;
  end;
end;

function TAppBuilder.SaveAll(APrompt: Boolean): Boolean;
var
  I: Integer;
  AEditor: TObjectEditor;

  function Prompt(AName: String): Integer;
  begin
    if AName = '' then AName := 'New Report "' + AEditor.Form.Name + '"';
    Result := MessageDlg(AName + ' has been modified, save ?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
  end;

  function DoSave: Boolean;
  begin
    AEditor.Form.BringToFront;
    Result := Save;
  end;

begin
  Result := False;
  for I := 0 to FEditors.Count-1 do
  begin
    AEditor := FEditors.Objects[I] as TObjectEditor;
    if AEditor.IsModified then
    begin
      if APrompt then
        case Prompt(FEditors[I]) of
          mrYes: if not DoSave then Exit;
          mrNo:;
          mrCancel: Exit;
        end
      else
        if not DoSave then Exit;
    end;
  end;
  Result := True;
end;

procedure TAppBuilder.CloseEditor;
var
  AEditor: TObjectEditor;
begin
  AEditor := GetActivateEditor;
  if AEditor <> nil then
  begin
    if AEditor.IsModified then
      if not Save then Exit;
    AEditor.Form.Release;
  end;
end;

procedure TAppBuilder.CloseAll;
var
  AEditor: TObjectEditor;
  I: Integer;
begin
  if SaveAll(True) then
  begin
    for I := FEditors.Count-1 downto 0 do
    begin
      AEditor := FEditors.Objects[I] as TObjectEditor;
      AEditor.ClearModify;
      AEditor.Form.BringToFront;
      AEditor.Form.Release;
    end;
  end;
end;

procedure TAppBuilder.DoEditorDestroy(Sender: TObject);
var
  AIndex: Integer;
begin
  if FEditors <> nil then
  begin
    AIndex := FEditors.IndexOfObject(Sender);
    if AIndex <> -1 then FEditors.Delete(AIndex);
  end;
end;

procedure TAppBuilder.FileSaveItemClick(Sender: TObject);
begin
  Save;
end;

procedure TAppBuilder.FileOpenItemClick(Sender: TObject);
begin
  Open;
end;

procedure TAppBuilder.Open;
begin
  if OpenFileDialog.Execute then
    OpenFile(OpenFileDialog.FileName);
end;

procedure TAppBuilder.OpenFile(AFileName: String);
var
  AEditor: TObjectEditor;
begin
  if Uppercase(ExtractFileExt(AFileName)) = '.PAS' then
    ChangeFileExt(AFileName, '.DFM');
  AEditor := NewByFileName(AFileName);
  if (AEditor <> nil) then
    AEditor.LoadDFMFromFile(AFileName);
end;

procedure TAppBuilder.btnOpenReportClick(Sender: TObject);
begin
  Open;
end;

procedure TAppBuilder.btnSaveReportClick(Sender: TObject);
begin
  Save;
end;

procedure TAppBuilder.AdvSpeedButton1Click(Sender: TObject);
begin
  ShowAlignPalette;
end;

procedure TAppBuilder.ViewObjectInspectorClick(Sender: TObject);
begin
  ObjectInspector.Visible := not ObjectInspector.Visible;
end;

procedure TAppBuilder.AdvSpeedButton2Click(Sender: TObject);
begin
  PackageDialog.InitialDir := FDPLPath;
  if PackageDialog.Execute then
  begin
    LoadPackageEx(PackageDialog.FileName);
    CompPal.RefreshTabs;
  end;
end;

procedure TAppBuilder.btnEditClick(Sender: TObject);
begin
  if (FOldForm <> nil) and (FOldEditor <> nil) then
  begin
    FOldEditor.AutoFree := True;
    FOldEditor.EditControl(FOldForm);
    FOldEditor := nil;
    FOldForm := nil;
  end;
end;

procedure TAppBuilder.btnRunClick(Sender: TObject);
var
  AEditor: TObjectEditor;
begin
  if FOldForm = nil then
  begin
    AEditor := GetActivateEditor;
    if AEditor <> nil then
    begin
      FOldEditor := AEditor;
      FOldForm := AEditor.Form;
      AEditor.AutoFree := False;
      AEditor.EditControl(nil);
    end;
  end;
end;

procedure TAppBuilder.FileNewItemClick(Sender: TObject);
begin
  New;
end;

procedure TAppBuilder.FileSaveAsItemClick(Sender: TObject);
begin
  SaveAs;
end;

procedure TAppBuilder.FileSaveAllItemClick(Sender: TObject);
begin
  SaveAll(False);
end;

procedure TAppBuilder.FileCloseItemClick(Sender: TObject);
begin
  CloseEditor;
end;

procedure TAppBuilder.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if not SaveAll(True) then
    Action := caNone;
end;

procedure TAppBuilder.FileCloseAllItemClick(Sender: TObject);
begin
  CloseAll;
end;

procedure TAppBuilder.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TAppBuilder.EditCutItemClick(Sender: TObject);
var
  AEditor: TObjectEditor;
begin
  AEditor := GetActivateEditor;
  if AEditor <> nil then
    AEditor.CutComponents;
end;

procedure TAppBuilder.EditCopyItemClick(Sender: TObject);
var
  AEditor: TObjectEditor;
begin
  AEditor := GetActivateEditor;
  if AEditor <> nil then
    AEditor.CopyComponents;
end;

procedure TAppBuilder.EditPasteItemClick(Sender: TObject);
var
  AEditor: TObjectEditor;
begin
  AEditor := GetActivateEditor;
  if AEditor <> nil then
    AEditor.PasteComponents;
end;

procedure TAppBuilder.EditDeleteItemClick(Sender: TObject);
var
  AEditor: TObjectEditor;
begin
  AEditor := GetActivateEditor;
  if AEditor <> nil then
    AEditor.DeleteComponents;
end;

initialization
begin
  {Init IDE envirment for runtime design}
  ObjInitialize(TObjectInspector, TObjectEditor, nil, nil, nil);
end;

end.

