(*
1. for Record type, if you want edit it in inspector, you should
define this record as object and need not one line code. because
inspector auto show subproperties in object (not record).
otherwise, you need wirte more code.

type
  TTestRec = record
    Name: String;
    FType: TFieldType;
    Value: String;
  end;

  TTestRec = class(TPersistent)
  public
    FName: String;
    FType: TFieldType;
    FValue: String;
  published
    property Name: String read FName write FName;
    property FldType: TFieldType read FType write FType;
    property Value: String read FValue write FValue;
  end;

2.For array, need write some code, because delphi not support array property,
  So, must do it in my inspector. So, I modify my source to arround it.

  ***********************************************************
  NOTE: you should not compile this demo with old objinsp.dcu

*)

unit Demo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ObjInsp, DB, DsgnIntf;

type
  PTestArray = ^TTestArray;
  TTestLong = Longint;
  TTestArray = array [0..9] of Integer;

  TArrayProperty = class(TIntegerProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetProperties(Proc: TGetPropEditProc); override;
    function GetValue: String; override;
    procedure SetValue(const Value: String); override;
  end;

  TArrayElementProperty = class(TIntegerProperty)
  private
    FParentProp: TPropertyEditor;
    FArray: PTestArray;
    FIndex: Integer;
  public
    constructor Create(AParent: TPropertyEditor; PArray: PTestArray; AIndex: Integer);
    function GetValue: String; override;
    procedure SetValue(const Value: String); override;
    function GetName: String; override;
  end;

  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    FInspector: TObjectInspector;
    FTestArray: TTestArray;
    function GetTestArray: TTestLong;
    procedure SetTestArray(Value: TTestLong);
    procedure DoFilter(Sender: TPersistent; Prop: TPropertyEditor;
      var AText: String; var AllowShow: Boolean);
  public
    procedure RefreshLabel;
  published
    property TestArray: TTestLong read GetTestArray write SetTestArray;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{Array Property}

function TArrayProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paReadOnly, paSubProperties];
end;

procedure TArrayProperty.GetProperties(Proc: TGetPropEditProc);
var
  I: Integer;
  P: PTestArray;
begin
  P := Pointer(GetOrdValue);
  for I := Low(TTestArray) to High(TTestArray) do
    Proc(TArrayElementProperty.Create(Self, P, I));
end;

function TArrayProperty.GetValue: String;
begin
  Result := '[Array]';
end;

procedure TArrayProperty.SetValue(const Value: String);
begin
  SetOrdValue(GetOrdValue);
end;

{Array Element Property}

constructor TArrayElementProperty.Create(AParent: TPropertyEditor; PArray: PTestArray; AIndex: Integer);
begin
  {$IFDEF VER100}
  inherited Create;
  {$ELSE}
  inherited Create(Designer, 1);
  {$ENDIF}
  FArray := PArray;
  FIndex := AIndex;
  FParentProp := AParent;
end;

function TArrayElementProperty.GetValue: String;
begin
  Result := IntToStr(FArray[FIndex]);
end;

procedure TArrayElementProperty.SetValue(const Value: String);
begin
  FArray[FIndex] := StrToInt(Value);
  FParentProp.SetValue('');
end;

function TArrayElementProperty.GetName: String;
begin
  Result := Format('[%d]', [FIndex]);
end;

function TForm1.GetTestArray: TTestLong;
begin
  Result := TTestLong(@FTestArray);
end;

procedure TForm1.SetTestArray(Value: TTestLong);
begin
  RefreshLabel;
end;

procedure TForm1.RefreshLabel;
var
  S: String;
  I: Integer;
begin
  S := IntToStr(FTestArray[0]);
  for I := 1 to 9 do
    S := S + ', '+IntToStr(FTestArray[I]);
  Label2.Caption := S;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FInspector := TObjectInspector.Create(nil);
  FInspector.OnFilter := DoFilter;
  FInspector.Options := [oioProperties];
  FInspector.Show;
  FInspector.EditObjectProperties(Self);
  RefreshLabel;
end;

{Filter other property}
{NOTE: Delphi4 public PropertyEditor.Create, So, subproperties will confirmed}

procedure TForm1.DoFilter(Sender: TPersistent; Prop: TPropertyEditor;
  var AText: String; var AllowShow: Boolean);
begin
  if (Prop is TArrayProperty) then
    AText := 'Array Demo'
  else if (Prop is TArrayElementProperty) then
    {Need not process}
  else
    AllowShow := False;
end;

initialization
begin
  RegisterPropertyEditor(TypeInfo(TTestLong), TForm1, 'TestArray', TArrayProperty);
end;

end.
