unit Multiply1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MtxVec, Math387, Basic2, StdCtrls, ExtCtrls, ComCtrls, TeEngine, Series,
  TeeProcs, Chart;

{ "Regular" 2D arrays}
type    TDelphi2DArray = Array of Array of TSample;

type
  TMult1 = class(TBasicForm2)
    TrackBar1: TTrackBar;
    Label1: TLabel;
    StaticText1: TStaticText;
    Button4: TButton;
    RadioGroup1: TRadioGroup;
    Chart1: TChart;
    Series1: TLineSeries;
    Series2: TLineSeries;
    procedure FormCreate(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    DA,DB,DC : TDelphi2DArray; {"regular" arrays }
    A,B,C : TMtx;             {MtxVec arrays}
    MtxDim : Integer;
    procedure MulDelphi(ADim: Integer);
    procedure GenerateData(ADim : Integer);
    procedure bthHelpClick(Sender: TObject);
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Mult1: TMult1;

implementation

{$R *.DFM}

const MULHELP = 5340;

procedure TMult1.bthHelpClick(Sender: TObject);
begin
     Application.HelpContext(MULHELP);
end;

procedure TMult1.MulDelphi(ADim: Integer);
var i,j,k : Integer;
begin
  for i := 0 to ADim-1 do
     for j := 0 to ADim-1 do
        for k := 0 to ADim-1 do
             DC[i,j] := DC[i,j]+ DA[i,k]*DB[k,j];
end;


procedure TMult1.GenerateData(ADim: Integer);
var i,j : Integer;
begin
     { resize matrices }
     A.Size(ADim,ADim);
     B.Size(A);
     { resize 2D arrays}
     SetLength(DA,ADim,ADim);
     SetLength(DB,ADim,ADim);
     SetLength(DC,ADim,ADim);
     { fill sample data }
     Randomize;
     for i := 0 to ADim-1 do
         for j := 0 to ADim-1 do
         begin
              DA[i,j] := random(10);
              DB[i,j] := random(10);
              A.Values[i,j] := DA[i,j];
              B.Values[i,j] := DB[i,j];
         end;
end;

procedure TMult1.FormCreate(Sender: TObject);
begin
  inherited;
  With RichEdit1.Lines do
  begin
    Clear;
    Add('Matrix multiplication performance gives you '
      + 'an impression of the performance of MtxVec. You '
      + 'will be able to experience these performance '
      + 'gains with all MtxVec packages, when dealing '
      + 'with vectors or matrices. If you have a multi-CPU '
      + 'machine you might even want to try enabling SMP '
      + '(check the readme file for more info).');
  end;
  A := TMtx.Create;
  B := TMtx.Create;
  C := TMtx.Create;
  TrackBar1Change(TrackBar1);
  with TButton(Self.Owner.FindComponent('btnHelp')) do
  begin
       OnClick := bthHelpClick;
       Enabled := true;
  end;
end;

procedure TMult1.TrackBar1Change(Sender: TObject);
begin
  MtxDim := TTrackBar(Sender).Position;
  StaticText1.Caption := IntToStr(MtxDim);
end;

procedure TMult1.Button4Click(Sender: TObject);
var i,j: integer;
    Adim : Integer;
begin
  GenerateData(MtxDim);
  i := 2;
  Screen.Cursor := crHourGlass;
  Series1.Clear;
  Series2.Clear;
  repeat
        ADim := i;
        GenerateData(ADim);
        TimeCheck := GetTickCount;
        if MtxDim <= 30 then
             for j := 0 to 999 do MulDelphi(ADim)
        else if MtxDim <= 60 then
             for j := 0 to 99 do MulDelphi(ADim)
        else MulDelphi(ADim);
        Series1.AddXY(i,GetTickCount-TimeCheck,'',clTeeColor);

        TimeCheck := GetTickCount;
        if MtxDim <= 30 then
           for j := 0 to 999 do C.Mul(A,B)
        else if MtxDim <= 60 then
           for j := 0 to 99 do C.Mul(A,B)
        else C.Mul(A,B);
        Series2.AddXY(i,GetTickCount-TimeCheck,'',clTeeColor);

        if i<50 then i := i+2 else i:= i+25;
  until i >= MtxDim;
  Screen.Cursor := crDefault;
end;

procedure TMult1.RadioGroup1Click(Sender: TObject);
begin
  Case TRadioGroup(Sender).ItemIndex of
     0 : TrackBar1.Position := 25;
     1 : TrackBar1.Position := 60;
     2 : TrackBar1.Position := 400;
  end;
  TrackBar1Change(TrackBar1);
end;

procedure TMult1.FormDestroy(Sender: TObject);
begin
  A.Destroy;
  B.Destroy;
  C.Destroy;
  TButton(Self.Owner.FindComponent('btnHelp')).OnClick := nil;
  inherited;
end;

initialization
   RegisterClass(TMult1);
end.
