unit IntroMemoryMan;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Basic3, StdCtrls, ComCtrls;

type
  TIntroMemMan = class(TBasicForm3)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  IntroMemMan: TIntroMemMan;

implementation

{$R *.DFM}

procedure TIntroMemMan.FormCreate(Sender: TObject);
begin
  inherited;
  With RichEdit1.Lines, RichEdit1 do
  begin
    Clear;
    DefAttributes.Style := [fsBold];

    SelAttributes.Size := 12;
    SelAttributes.Color := RGB(51,51,153);
    Add('Enhanced memory handling:');
    Add('');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Built in dynamic memory allocation makes it easier for the user');
    Add('Object cache with object precreation speeds up Create and Destroy');
    Add('Memory preallocation gives you instant access to new memory');
    Add('Joining several calls to GetMem/FreeMem to one, '
      + 'increases overall performance'+#10+#13);
    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');

    SelAttributes.Size := 14;
    SelAttributes.Color := RGB(51,51,153);
    Add('Array access options:');
    Add('');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Default arrays allow cleaner syntax');
    Add('Array pointers give you more speed');
    Add('Single memory block matrices allow '
      + 'even faster matrix operations'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
  end;

  TButton(Self.Owner.FindComponent('btnHelp')).Enabled := false;
end;

initialization
   RegisterClass(TIntroMemMan);

end.
