unit IntroMatrices;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Basic3, StdCtrls, ComCtrls;

type
  TIntroMtx = class(TBasicForm3)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  IntroMtx: TIntroMtx;

implementation

{$R *.DFM}

procedure TIntroMtx.FormCreate(Sender: TObject);
begin
  inherited;
  With RichEdit1.Lines, RichEdit1 do
  begin
    Clear;
    DefAttributes.Style := [fsBold];
    SelAttributes.Size := 12;

    SelAttributes.Color := RGB(51,51,153);
    Add('Matrix operations have never been easier:');
    Add('');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Least squares solution to a system of linear equations');
    Add('Refining solution of linear systems and error estimate');
    Add('Singular value decomposition and solution of a system of equations');
    Add('Eigenvalues and eigenvectors');
    Add('Toeplitz systems of linear equations');
    Add('Complete support for complex numbers');
    Add('2D FFT');
    Add('Complete matrix arithmetics');
    Add('Support for sparse matrices'+#10+#13);
    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
  end;
  TButton(Self.Owner.FindComponent('btnHelp')).Enabled := false;
end;

initialization
   RegisterClass(TIntroMtx);


end.
