unit IntroExport;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Basic3, StdCtrls, ComCtrls;

type
  TIntroExpImp = class(TBasicForm3)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  IntroExpImp: TIntroExpImp;

implementation

{$R *.DFM}

procedure TIntroExpImp.FormCreate(Sender: TObject);
begin
  inherited;
  With RichEdit1.Lines, RichEdit1 do
  begin
    Clear;
    DefAttributes.Style := [fsBold];
    SelAttributes.Size := 12;
    SelAttributes.Color := RGB(51,51,153);
    Add('Quick and easy Export/Import to screen, file, '
      + 'database... text or binary.');
    Add('');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Values to string, Strings to values (real and complex)');
    Add('Read/Write stream');
    Add('Read/Write file');
    Add('Read/Write string grid'+#10+#13);
    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');

    SelAttributes.Size := 14;
    SelAttributes.Color := RGB(51,51,153);
    Add('Ready to use Matrix Viewer and charting tools:');
    Add('');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Use ViewValues to display the contents of the matrix or vector');
    Add('Edit data on the fly');
    Add('Draw data while viewing');
    Add('Save/Load from file');
    Add('Use DrawValues and DrawIt for immediate data display'+#10+#13);
    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
  end;
  TButton(Self.Owner.FindComponent('btnHelp')).Enabled := false;
end;

initialization
   RegisterClass(TIntroExpImp);

end.
