unit Intro;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TIntroduction = class(TForm)
    RichEdit1: TRichEdit;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Introduction: TIntroduction;

implementation

{$R *.DFM}

procedure TIntroduction.FormCreate(Sender: TObject);
begin
  With RichEdit1.Lines, RichEdit1 do
  begin
    Clear;
    SelAttributes.Color := RGB(51,51,153);
    SelAttributes.Size := 14;
    Add('Welcome to MtxVec, an object oriented library '
      + 'for Delphi Pascal and C++ Builder.');
    Add('');
    Paragraph.Numbering := nsBullet;
    Paragraph.FirstIndent := 10;
    Add('MtxVec is the first object oriented numerical '
      + 'library available for Delphi and CBuilder users.');
    Add('The library offers top performance not seen '
      + 'in competitive products.');
    Add('It features the highest Performance/"Time to '
      + 'implement" ratio of any numerical software '
      + 'available today for personal computers.');
    Add('Reduces prototyping cost.');
    Add('Speeds time to market.'+#10+#13);
    Paragraph.Numbering := nsNone;
    Paragraph.FirstIndent := 0;
    Add('');
    SelAttributes.Style := [fsItalic];
    Add('"MtxVec was created to help shorten the '
      + 'development time of commercial scientific '
      + 'applications."');
    Add('');
    Add('Navigate through the demo application, to learn '
      + 'more about MtxVec and experience it''s unmatched '
      + 'performance and ease of use.');
  end;
  TButton(Self.Owner.FindComponent('btnHelp')).Enabled := false;
end;

initialization
  RegisterClass(TIntroduction);
end.
