unit GetMemComp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Basic2, StdCtrls, ComCtrls, ExtCtrls, MtxVec,Math387, TeeProcs, TeEngine,
  Chart, Series, Buttons;

type
  TGetMemC = class(TBasicForm2)
    TrackBar1: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TBitBtn;
    Chart1: TChart;
    Series1: TLineSeries;
    Series2: TLineSeries;
    Series3: TLineSeries;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure bthHelpClick(Sender: TObject);
  private
    vec1: TVec;
    wm1,wm2,wm3,wm4: PSArray;
    da1,da2,da3,da4: Array of TSample;
    Len : Integer;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  GetMemC: TGetMemC;

implementation

{$R *.DFM}
const SLICEITEHELP = 10230;

procedure TGetMemC.bthHelpClick(Sender: TObject);
begin
     Application.HelpContext(SLICEITEHELP);
end;

procedure TGetMemC.FormCreate(Sender: TObject);
begin
  inherited;
  SetVecCacheSize(1,2000); // 1 preloaded vector with 2000 elements allocated 
  try
     RichEdit1.Lines.LoadFromFile('Texts\GetMemTXT.rtf');
  except
  end;
  TrackBar1Change(TrackBar1);
  with TButton(Self.Owner.FindComponent('btnHelp')) do
  begin
       OnClick := bthHelpClick;
       Enabled := true;
  end;
end;

procedure TGetMemC.FormDestroy(Sender: TObject);
begin
  TButton(Self.Owner.FindComponent('btnHelp')).OnClick := nil;
  inherited;
end;

procedure TGetMemC.Button1Click(Sender: TObject);
var LenD4 : Integer;
    i     : Integer;
    j     : Integer;
begin
  { GetMem / FreeMem }
  j := 4;
  Series1.Clear;
  Series2.Clear;
  Series3.Clear;
  Screen.Cursor := crHourGlass;
  while j <= Len do
  begin
       LenD4 := j div 4;
       TimeCheck := GetTickCount;
       { GetMem/FreeMem }
       for i := 0 to 10000 do
       begin
            GetMem(wm1,LenD4*SizeOf(TSample));
            GetMem(wm2,LenD4*SizeOf(TSample));
            GetMem(wm3,LenD4*SizeOf(TSample));
            GetMem(wm4,LenD4*SizeOf(TSample));
            FreeMem(wm1,LenD4*SizeOf(TSample));
            FreeMem(wm2,LenD4*SizeOf(TSample));
            FreeMem(wm3,LenD4*SizeOf(TSample));
            FreeMem(wm4,LenD4*SizeOf(TSample));
       end;
       TimeElapsed := GetTickCount - TimeCheck;
       Series1.AddXY(j,TimeElapsed,'',clTeeColor);

       TimeCheck := GetTickCount;
       { Size / SliceIt }
       for i := 0 to 10000 do
       begin
            CreateIt(vec1);
            vec1.SliceIt(LenD4,LenD4,LenD4,LenD4,
               wm1,wm2,wm3,wm4);
            FreeIt(Vec1);
       end;
       TimeElapsed := GetTickCount - TimeCheck;
       Series2.AddXY(j,TimeElapsed,'',clTeeColor);

       TimeCheck := GetTickCount;
       { SetLength  }
       for i := 0 to 10000 do
       begin
            SetLength(da1,LenD4);
            SetLength(da2,LenD4);
            SetLength(da3,LenD4);
            SetLength(da4,LenD4);
            da1 := nil;
            da2 := nil;
            da3 := nil;
            da4 := nil;
       end;
       TimeElapsed := GetTickCount - TimeCheck;
       Series3.AddXY(j,TimeElapsed,'',clTeeColor);

       j := j+40;
  end;
  Screen.Cursor := crDefault;
end;

procedure TGetMemC.TrackBar1Change(Sender: TObject);
begin
  Len := TTrackBar(Sender).Position;
  Label2.Caption := IntToStr(Len);
end;

initialization
   RegisterClass(TGetMemC);

end.
