unit DirichletTest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Basic2, StdCtrls, ComCtrls, ExtCtrls, TeeProcs, TeEngine, Chart, MtxVecTee,
  MtxVec, Math387;

type
  TfrmDirichlet = class(TBasicForm2)
    Chart1: TChart;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    procedure RadioGroup2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Chart1GetAxisLabel(Sender: TChartAxis; Series: TChartSeries;
      ValueIndex: Integer; var LabelText: String);
  private
    { Private declarations }
    GridSer: TMtxGridSeries;
    Data: TMtx;
    CVal: TCplx;
    procedure Generate;
  public
    { Public declarations }
  end;

var
  frmDirichlet: TfrmDirichlet;

implementation
{$R *.DFM}

Uses Probabilities;

{ TfrmDirichlet }

procedure TfrmDirichlet.Generate;
var i,j: Integer;
begin
  Screen.Cursor := crHourGlass;
  try
    Data.Size(81,81,false);
    for i := 0 to 80 do
      for j := 0 to 80 do
      begin
        case (RadioGroup1.ItemIndex) of
          0 : CVal := RiemannZeta(Cplx((i-40)*0.2,(j-40)*0.2));
          1 : CVal := DirichletEta(Cplx((i-40)*0.2,(j-40)*0.2));
          2 : CVal := DirichletLambda(Cplx((i-40)*0.2,(j-40)*0.2));
        end;
        case (RadioGroup2.ItemIndex) of
          0 : Data.Values[i,j] := CVal.Re;
          1 : Data.Values[i,j] := CVal.Im;
          2 : Data.Values[i,j] := CAbs(CVal);
        end;
      end;
    GridSer.Matrix := Data;
  finally
    Screen.Cursor := crDefault;
  end;
end;


procedure TfrmDirichlet.RadioGroup2Click(Sender: TObject);
begin
  Generate;
end;

procedure TfrmDirichlet.RadioGroup1Click(Sender: TObject);
begin
  Generate;
end;

procedure TfrmDirichlet.FormCreate(Sender: TObject);
begin
  inherited;
  With RichEdit1.Lines do
  begin
    Clear;
    Add('Several new special functions have been added to MtxVec '
      + 'Probabilities unit. MtxVec now supports Riemann Zeta, Dirichlet Eta '
      + 'and Dirichlet Lambda functions in complex plane.');
    Add('');
    Add('');
  end;

  Data := TMtx.Create;
  GridSer := TMtxGridSeries.Create(Chart1);
  GridSer.BottomColor := clGreen;
  GridSer.TopColor := clYellow;
  GridSer.ParentChart := Chart1;
  Generate;
end;

procedure TfrmDirichlet.FormDestroy(Sender: TObject);
begin
  Data.Destroy;
  inherited;
end;

procedure TfrmDirichlet.Chart1GetAxisLabel(Sender: TChartAxis;
  Series: TChartSeries; ValueIndex: Integer; var LabelText: String);
var tmp: TSample;
begin
  if (Sender = Chart1.LeftAxis) or (Sender = Chart1.BottomAxis) then
  begin
    tmp := StrToFloat(LabelText);
    tmp := (tmp - 40)*0.2;
    LabelText := FloatToStr(tmp);
  end;
end;

initialization
  RegisterClass(TfrmDirichlet);

end.
