unit CopyCompare;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Basic2, StdCtrls, ComCtrls, ExtCtrls, TeEngine, Series, TeeProcs, Chart,
  MtxVec, Math387, Buttons;

type
  TCopyComp = class(TBasicForm2)
    Label1: TLabel;
    TrackBar1: TTrackBar;
    Label2: TLabel;
    Button1: TBitBtn;
    Chart1: TChart;
    Series1: TBarSeries;
    Series2: TBarSeries;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    Dim : Integer;
    A,B : TMtx;
    procedure bthHelpClick(Sender: TObject);
  public
    { Public declarations }
  end;

var
  CopyComp: TCopyComp;

implementation

{$R *.DFM}

const CopyHELP = 4370;

procedure TCopyComp.bthHelpClick(Sender: TObject);
begin
     Application.HelpContext(CopyHELP);
end;


procedure CopyMtxVec(A,B: TMtx);
begin
     B.Copy(A);
end;

procedure CopyDelphi(A,B: TMtx);
var i,j : Integer;
    ap,bp: T2DSampleArray;
begin
     B.Size(A);
     ap := a.Values;
     bp := b.Values;
     for i := 0 to A.Rows -1 do
        for j := 0 to A.Cols -1 do bp[i,j] := ap[i,j];
     ap := nil;
     bp := nil;
end;

procedure TranspMtxVec(A,B: TMtx);
begin
     B.Transp(A);
end;

procedure TranspDelphi(A,B: TMtx);
var i,j: Integer;
    ap,bp: T2DSampleArray;
begin
     B.Size(A);
     ap := a.Values;
     bp := b.Values;
     for i := 0 to A.Rows -1 do
      for j := 0 to A.Cols-1 do bp[j,i] := ap[i,j];
     ap := nil;
     bp := nil;
end;

procedure TCopyComp.FormCreate(Sender: TObject);
begin
  inherited;
  SetMtxCacheSize(0,0);
  try
     RichEdit1.Lines.LoadFromFile('Texts\CopyCompTXT.rtf');
  except
  end;

  with TButton(Self.Owner.FindComponent('btnHelp')) do
  begin
       OnClick := bthHelpClick;
       Enabled := true;
  end;
  A := TMtx.Create;
  B := TMtx.Create;
  A.ConditionCheck := false;
  B.ConditionCheck := false;
  TrackBar1Change(TrackBar1);
end;

procedure TCopyComp.FormDestroy(Sender: TObject);
begin
  TButton(Self.Owner.FindComponent('btnHelp')).OnClick := nil;
  A.Destroy;
  B.Destroy;
  inherited;
end;

procedure TCopyComp.TrackBar1Change(Sender: TObject);
begin
  Dim := TTrackBar(Sender).Position;
  Label2.Caption := IntToStr(Dim);
end;

procedure TCopyComp.Button1Click(Sender: TObject);
var i : Integer;
    MaxIter : Integer;
begin
  { Setup chart}
  Series1.Clear;
  Series2.Clear;
  A.Size(Dim,Dim,false);
  if dim < 15 then MaxIter := 50000
  else if Dim < 30 then MaxIter := 5000
  else if Dim < 50 then MaxIter := 2000
  else if Dim < 80 then MaxIter := 1000
  else if Dim < 200 then MaxIter := 500
  else if Dim < 500 then MaxIter := 50
  else MaxIter := 1;
  Chart1.LeftAxis.Title.Caption := 'time [ms] ('+IntToStr(MaxIter)+' executions)';
  Screen.Cursor := crHourGlass;
  { Delphi Copy }
  TimeCheck := GetTickCount;
  for i := 1 to MaxIter do CopyDelphi(A,B);
  TimeElapsed := GetTickCount - TimeCheck;
  Series1.AddXY(0,TimeElapsed,'Copy operation',clTeeColor);
  { MtxVec Copy }
  TimeCheck := GetTickCount;
  for i := 1 to MaxIter do CopyMtxVec(A,B);
  TimeElapsed := GetTickCount - TimeCheck;
  Series2.AddXY(0,TimeElapsed,'',clTeeColor);

  { Delphi Transp }
  TimeCheck := GetTickCount;
  for i :=1 to MaxIter do TranspDelphi(A,B);
  TimeElapsed := GetTickCount - TimeCheck;
  Series1.AddXY(1,TimeElapsed,'Transp operation',clTeeColor);
  { MtxVec Transp }
  TimeCheck := GetTickCount;
  for i := 1 to MaxIter do TranspMtxVec(A,B);
  TimeElapsed := GetTickCount - TimeCheck;
  Series2.AddXY(1,TimeElapsed,'',clTeeColor);

  Screen.Cursor := crDefault;

end;

initialization
   RegisterClass(TCopyComp);

end.
