unit Changes15;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Basic3, StdCtrls, ComCtrls;

type
  TfrmChanges15 = class(TBasicForm3)
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmChanges15: TfrmChanges15;

implementation

{$R *.dfm}

procedure TfrmChanges15.FormCreate(Sender: TObject);
begin
  inherited;
  With RichEdit1.Lines, RichEdit1 do
  begin
    SelAttributes.Size := 14;
    SelAttributes.Color := RGB(51,51,153);
    Add('Version 1.5: List of new features');

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('MtxVec.pas and Math387.pas :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Eig returns left and right eigenvectors in columns');
    Add('SVD returns left singular vectors and right singular  '
      + 'vectors in columns. SVD requires U and V to be both  assigned (<> nil) '
      + 'and computes the singular vectors using divide and conquer algorithm.');
    Add('Most Math387 routines rewritten in assembler (much faster)');
    Add('New TMtx.MtxSqrt routine allows computation of a square root of the '
      + 'matrix by using eigenvalue decomposition (all matrix types supported).');
    Add('New TMtx.MtxFunction method allows computation of any matrix function '
      + '(Power of the matrix, square root of the matrix, log of the matrix,..) '
      + 'via eigenvalue decomposition');
    Add('Added support for sparse matrices');
    Add('SetRoundToTrunc speeds up the computation of the Trunc  function');
    Add('Added SetSubRange and SetSubIndex to TVec to allow multiple views '
      + 'of selected number of elements  (subvectors) and simplify indexing');
    Add('Added TMtx.SaveToMatrixMarketFile routine, supporting MatrixMarket '
      + 'file format');
    Add('StringsToValues now accepts blanks as delimiters');
    Add('Added TMtx.PixelDownSample method');
    Add('Added TVec.BlockInit and TVec.BlockNext to simplify development '
      + 'of block processing enabled algorithms'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('Sparse.pas :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Introduces TSparseMtx class capable of handling real and complex '
      + 'sparse matrices');
    Add('Encapsulates UMF Pack v 3.2, one of the fastest direct sparse '
      + 'matrix solvers and interfacing MKL 5.1 BLAS III');
    Add('Features iterative sparse solvers (cg, bcg, gmres, ..)');
    Add('Compute inverse of the sparse matrix');
    Add('Many conversion routines to convert to and form different matrix '
      + 'formats (triplet, banded, dense, Harwell Boeing)');
    Add('Load and save MatrixMarket file format');
    Add('Very fast banded matrix solvers already available in TMtx');
    Add('Add, subtract, multiply routines for sparse/sparse and dense/'
      + 'sparse matrices');
    Add('PixelDownSample routine to allow fast display of the non-zero '
      + 'pattern of the matrices of huge sizes.  (1000 000 x 1000 000 elements)');
    Add('Complete set of standard math routines known from TVec and TMtx. '
      + '(Log, Power, Sin, Cos, etc...)'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('MtxParseExpr.pas :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Evalute expressions containing real and/or complex numbers');
    Add('Unlimited number of user defined variables');
    Add('Unlimited number of user defined functions');
    Add('Each function can have up to 6 parameters');
    Add('Maintain a list of parsed expressions');
    Add('New TMtxExpression object');
    Add('New TMtxFunctionEvaluator component'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('MtxVecTee.pas :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Added NAN and Inf checks to DrawValues method');
    Add('Added support for pixelDownsample for matrices');
    Add('New TMtxGridSeries for displaying matrices. '
      + 'Works with any TeeChart version'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('MtxVecEdit.pas :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Chart menu items are now automatically added/removed '
      + 'if you compile/install MtxVecTee1X.dpk package');
    Add('New TMtxViewDialog component holding the state of the '
      + 'dialog displayed via ViewValues. (allows  setting and '
      + 'storing the parameters for the dialog)'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('Probabilities.pas :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Most procedures taking vector parameters have been completely '
      + 'rewritten and take advantage of block processing design combined '
      + 'with optimized vector processing. (big speed gains)'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('MtxVecTools, MtxVecDBTools and MtxVecComCtrls.pas, MtxBaseComp :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('Added new TMtxProgressDialog component (a TThread component) '
      + 'designed to simplify threading of numerical algorithms, display '
      + 'progress bar and allow interruption of the processing');
    Add('TMtxFloatEdit component has been enhanced. Ctrl+DlbClick will bring '
      + 'up settings for increment and number format');
    Add('Added a feature to store those settings in the registry');
    Add('ViewValues and DrawIt display settings are preserved between calls');
    Add('New TMtxComponent featuring generic SaveToStream, LoadFromStream and '
      + 'Assign procedure for all derived classes. (MtxBaseComp.pas).'+#10#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
    Add('');
    SelAttributes.Style := [fsUnderline];
    Add('Miscellaneous :');
    Paragraph.FirstIndent := 10;
    Paragraph.Numbering := nsBullet;
    Add('All TeeChart units placed in separate package. Now you can recompile '
      + 'this package with any Teechart version');
    Add('All Optimization routines now work fine with C++ Builder 5 and 6');
    Add('Added support for C++ Builder 6');
    Add('Improved compatibility for P4');
    Add('Updated Intel Math Kernel Libraries');
    Add('Code optimization all around'+#10+#13);

    Paragraph.FirstIndent := 0;
    Paragraph.Numbering := nsNone;
  end;
  TButton(Self.Owner.FindComponent('btnHelp')).Enabled := false;
end;

initialization
  RegisterClass(tfrmChanges15);

end.
