unit MtxGridSerEdit;

interface
{$I BdsppDefs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, MtxVecTee, StdCtrls,ComCtrls, ExtCtrls;

type
  TMtxGridSeriesEditor = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    ComboBox1: TComboBox;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Edit1: TEdit;
    UpDown1: TUpDown;
    Shape1: TShape;
    Shape2: TShape;
    procedure FormShow(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure UpDown1Changing(Sender: TObject; var AllowChange: Boolean);
    procedure Shape1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Shape2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Edit1Change(Sender: TObject);
  private
    { Private declarations }
    TheSeries: TMtxGridSeries;
  public
    { Public declarations }
  end;

var
  MtxGridSeriesEditor: TMtxGridSeriesEditor;

implementation

Uses {$IFDEF TEE5}TeCanvas{$ELSE}PenDlg{$ENDIF};

{$R *.dfm}

procedure TMtxGridSeriesEditor.FormShow(Sender: TObject);
begin
  TheSeries := TMtxGridSeries(Tag);
  Edit1.Text := IntToStr(TheSeries.PaletteSteps);
  ComboBox1.ItemIndex := Ord(TheSeries.PaletteStyle);
  Shape1.Brush.Color := TheSeries.BottomColor;
  Shape2.Brush.Color := TheSeries.TopColor;
  GroupBox2.Visible := TheSeries.PaletteStyle <> palCustom;
end;

procedure TMtxGridSeriesEditor.ComboBox1Change(Sender: TObject);
begin
  if Showing then
  begin
    TheSeries.PaletteStyle := TGridPaletteStyle(ComboBox1.ItemIndex);
    GroupBox2.Visible := TheSeries.PaletteStyle <> palCustom;
  end;
end;

procedure TMtxGridSeriesEditor.UpDown1Changing(Sender: TObject;
  var AllowChange: Boolean);
begin
  if Showing then TheSeries.PaletteSteps := UpDown1.Position;
end;

procedure TMtxGridSeriesEditor.Shape1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) and Showing then
  begin
    TheSeries.BottomColor := EditColor(Self,TheSeries.BottomColor);
    Shape1.Brush.Color := TheSeries.BottomColor;
    Shape2.Brush.Color := TheSeries.TopColor;
  end;
end;

procedure TMtxGridSeriesEditor.Shape2MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbLeft) and Showing then
  begin
    TheSeries.TopColor := EditColor(Self,TheSeries.TopColor);
    Shape1.Brush.Color := TheSeries.BottomColor;
    Shape2.Brush.Color := TheSeries.TopColor;
  end;
end;

procedure TMtxGridSeriesEditor.Edit1Change(Sender: TObject);
begin
  if Showing then TheSeries.PaletteSteps := UpDown1.Position;
end;

initialization
  RegisterClass(TMtxGridSeriesEditor);

end.
