unit Demo_;

interface

uses
  Windows, Messages, Classes, Graphics, Controls, Forms,
  Menus, ExtCtrls, ComCtrls, StdCtrls, SysUtils, VidGrab, MoSensor;

type
  TForm1 = class(TForm)
    Edit3: TEdit;
    Button3: TButton;
    CheckBox2: TCheckBox;
    Timer1: TTimer;
    VideoGrabber1: TVideoGrabber;
    ComboBox1: TComboBox;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    Memo2: TMemo;
    UpDown1: TUpDown;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox3: TGroupBox;
    Edit2: TEdit;
    UpDown2: TUpDown;
    Label6: TLabel;
    Label8: TLabel;
    Shape2: TShape;
    Label3: TLabel;
    Edit1: TEdit;
    Shape1: TShape;
    Label4: TLabel;
    Memo1: TMemo;
    Label5: TLabel;
    Memo3: TMemo;
    MotionSensor1: TMotionSensor;
    procedure FormCreate(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure Button3Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure VideoGrabber1FrameCaptureCompleted(Sender: TObject;
      MemoryBitmap: TBitmap; DestType: TFrameCaptureDest; FileName: String;
      Success: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure UpDown2Click(Sender: TObject; Button: TUDBtnType);
    procedure Edit3Change(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   Edit3.Text := MotionSensor1.Matrix;
   CheckBox2.Checked := MotionSensor1.ReduceVideoNoise;
   CheckBox1.Checked := MotionSensor1.CompareRed;
   CheckBox3.Checked := MotionSensor1.CompareGreen;
   CheckBox4.Checked := MotionSensor1.CompareBlue;
   CheckBox5.Checked := MotionSensor1.CompareMonochrome;
   upDown2.Position := Timer1.Interval;
   Memo2.Text := MotionSensor1.SquareSpacedMatrix;

   ComboBox1.Items.Text := VideoGrabber1.VideoDevices;
   if ComboBox1.Items.Count > 0 then begin
      ComboBox1.ItemIndex := VideoGrabber1.VideoDevice;
   end;
end;

procedure TForm1.VideoGrabber1FrameCaptureCompleted(Sender: TObject;
  MemoryBitmap: TBitmap; DestType: TFrameCaptureDest; FileName: String;
  Success: Boolean);
var
   MotionResult: integer;
   i, j: integer;
begin
   MotionResult := MotionSensor1.Compare (MemoryBitmap);
   Memo1.Text := '';
   Memo3.Text := '';
   case MotionResult of

      S_NO_MOTION_DETECTED: begin
         Edit1.Text := '-';
         Shape1.Brush.Color := clLime;
      end;

      S_MOTION_DETECTED: begin
         Shape1.Brush.Color := clRed;
         Edit1.Text := FloatToStr (MotionSensor1.GlobalMotionRatio);
         for j := 0 to MATRIXSIZE - 1 do begin
            for i := 0 to MATRIXSIZE - 1 do begin
               if MotionSensor1.CellMotionRatio (i, j) > 0 then begin
                  Memo1.Lines.Add (Format ('%02u %02u -> %2f', [i, j, MotionSensor1.CellMotionRatio (i, j)]));
               end;
            end;
         end;
      end;

      E_SIZES_DIFFER: begin
         Edit1.Text := '#';
      end;

      E_SETTINGS_CHANGED: begin
         Shape1.Brush.Color := clBlue;
         Edit1.Text := 'setting changed';
      end;

   end;
   Memo3.Text := MotionSensor1.SquareSpacedMatrixMotion;
end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
   if Button = btNext then begin
      MotionSensor1.ChangeGlobalSensitivity (1);
   end
   else begin
      MotionSensor1.ChangeGlobalSensitivity (-1);
   end;
   Edit3.Text := MotionSensor1.Matrix;
end;

procedure TForm1.UpDown2Click(Sender: TObject; Button: TUDBtnType);
begin
   Timer1.Interval := upDown2.Position;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   MotionSensor1.ShowMatrixDialog;
   Edit3.Text := MotionSensor1.Matrix;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
   MotionSensor1.ReduceVideoNoise := CheckBox2.Checked;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
   VideoGrabber1.CaptureFrameTo (fc_TBitmap, '');
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
   VideoGrabber1.VideoDevice := ComboBox1.ItemIndex;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   MotionSensor1.CompareRed := CheckBox1.Checked;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
   MotionSensor1.CompareGreen := CheckBox3.Checked;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
   MotionSensor1.CompareBlue := CheckBox4.Checked;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
   MotionSensor1.CompareMonochrome := CheckBox5.Checked;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
   MotionSensor1.Matrix := Edit3.Text;
   if MotionSensor1.IsMatrixValid then begin
      Shape2.Brush.Color := clLime;
      Label8.Caption := 'matrix is valid';
   end
   else begin
      Shape2.Brush.Color := clRed;
      Label8.Caption := 'INVALID MATRIX!';
   end;
   Memo2.Text := MotionSensor1.SquareSpacedMatrix;
end;

end.
