//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Demo_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "MoSensor"
#pragma link "VidGrab"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
   Edit3->Text = MotionSensor1->Matrix;
   CheckBox2->Checked = MotionSensor1->ReduceVideoNoise;
   CheckBox1->Checked = MotionSensor1->CompareRed;
   CheckBox3->Checked = MotionSensor1->CompareGreen;
   CheckBox4->Checked = MotionSensor1->CompareBlue;
   CheckBox5->Checked = MotionSensor1->CompareMonochrome;
   UpDown2->Position = Timer1->Interval;
   Memo2->Text = MotionSensor1->SquareSpacedMatrix;

   ComboBox1->Items->Text = VideoGrabber1->VideoDevices;
   if (ComboBox1->Items->Count > 0) {
      ComboBox1->ItemIndex = VideoGrabber1->VideoDevice;
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::VideoGrabber1FrameCaptureCompleted(TObject *Sender,
      Pointer MemoryBitmap, TFrameCaptureDest DestType,
      AnsiString FileName, bool Success)
{
   int MotionResult;
   int i, j;

   MotionResult = MotionSensor1->Compare ((Graphics::TBitmap*) MemoryBitmap);
   Memo1->Text = "";
   Memo3->Text = "";
   switch (MotionResult) {

      case S_NO_MOTION_DETECTED:
         Edit1->Text = "-";
         Shape1->Brush->Color = clLime;
      break;

      case S_MOTION_DETECTED:
         Shape1->Brush->Color = clRed;
         Edit1->Text = FloatToStr (MotionSensor1->GlobalMotionRatio);
         for (j = 0; j < MATRIXSIZE; j++) {
            for (i = 0; i < MATRIXSIZE; i++) {
               if (MotionSensor1->CellMotionRatio (i, j) > 0) {
                  TVarRec v[] = {i, j, MotionSensor1->CellMotionRatio (i, j)};
                  Memo1->Lines->Add (Format ("%02u %02u -> %2f", v, (ARRAYSIZE(v) - 1)));
               }
            }
         }
      break;

      case E_SIZES_DIFFER:
         Edit1->Text = "#";
      break;

      case E_SETTINGS_CHANGED:
         Shape1->Brush->Color = clBlue;
         Edit1->Text = "setting changed";
      break;
   }

   Memo3->Text = MotionSensor1->SquareSpacedMatrixMotion;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
   if (Button == btNext) {
      MotionSensor1->ChangeGlobalSensitivity (1);
   }
   else {
      MotionSensor1->ChangeGlobalSensitivity (-1);
   }
   Edit3->Text = MotionSensor1->Matrix;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown2Click(TObject *Sender, TUDBtnType Button)
{
   Timer1->Interval = UpDown2->Position;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
{
   MotionSensor1->ShowMatrixDialog();
   Edit3->Text = MotionSensor1->Matrix;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox2Click(TObject *Sender)
{
   MotionSensor1->ReduceVideoNoise = CheckBox2->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
   VideoGrabber1->CaptureFrameTo (fc_TBitmap, "");
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
   VideoGrabber1->VideoDevice = ComboBox1->ItemIndex;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
   MotionSensor1->CompareRed = CheckBox1->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox3Click(TObject *Sender)
{
   MotionSensor1->CompareGreen = CheckBox3->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox4Click(TObject *Sender)
{
   MotionSensor1->CompareBlue = CheckBox4->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox5Click(TObject *Sender)
{
   MotionSensor1->CompareMonochrome = CheckBox5->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Edit3Change(TObject *Sender)
{
   MotionSensor1->Matrix = Edit3->Text;
   if (MotionSensor1->IsMatrixValid) {
      Shape2->Brush->Color = clLime;
      Label8->Caption = "matrix is valid";
   }
   else {
      Shape2->Brush->Color = clRed;
      Label8->Caption = "INVALID MATRIX!";
   }
   Memo2->Text = MotionSensor1->SquareSpacedMatrix;
}
//---------------------------------------------------------------------------
