unit LayersReg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolWin, Channels, Layers, DsgnIntf, ExtDlgs, ImgList;

type
  TChannelEdit = class(TForm)
    Image: TImageLayer;
    ToolBar: TToolBar;
    SBOpen: TToolButton;
    SBSave: TToolButton;
    SBClear: TToolButton;
    ToolImages: TImageList;
    ToolButton1: TToolButton;
    SBFilter: TToolButton;
    Button: TButtonLayer;
    SBColor: TToolButton;
    OpenChannel: TOpenPictureDialog;
    SaveChannel: TSavePictureDialog;
    ColorSelect: TColorDialog;
    procedure SBOpenClick(Sender: TObject);
    procedure SBSaveClick(Sender: TObject);
    procedure SBClearClick(Sender: TObject);
    procedure SBFilterClick(Sender: TObject);
    procedure SBColorClick(Sender: TObject);
  private
    FChannel: TChannel;
    procedure SetChannel(AChannel: TChannel);
    procedure UpdateChannel;
  public
    property Channel: TChannel read FChannel write SetChannel;
    { Public declarations }
  end;

  TChannelProperty = class(TClassProperty)
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: String; override;
    procedure Edit; override;
  end;

  procedure Register;

implementation

{$R *.DFM}

function TChannelProperty.GetAttributes: TPropertyAttributes;
begin
  Result := (inherited GetAttributes + [paDialog]) - [paSubProperties];
end;

function TChannelProperty.GetValue: String;
var C: TChannel;
begin
  C := TChannel(GetOrdValue);
  if (C = Nil) then Result := '()' else
  if C.Active then FmtStr(Result, '(%d x %d)', [C.Size.X, C.Size.Y])
  else Result := '(None)';
end;

procedure TChannelProperty.Edit;
var CE: TChannelEdit;
begin
  CE := TChannelEdit.Create(Nil);
  try
    CE.Channel := TChannel(GetOrdValue);
    CE.ShowModal;
  finally
    CE.Free;
  end;
end;

procedure Register;
begin
  RegisterComponents('Layers', [TLayer, TImageLayer, TButtonLayer]);
  RegisterPropertyEditor(TypeInfo(TChannel), Nil, '', TChannelProperty);
end;

procedure TChannelEdit.SBOpenClick(Sender: TObject);
begin
  if OpenChannel.Execute then
  begin
    Channel.LoadFromFile(OpenChannel.FileName);
    UpdateChannel;
  end;
end;

procedure TChannelEdit.SBSaveClick(Sender: TObject);
begin
  if SaveChannel.Execute then Channel.SaveToFile(SaveChannel.FileName);
end;

procedure TChannelEdit.SBClearClick(Sender: TObject);
begin
  Channel.Active := False;
  UpdateChannel;
end;

procedure TChannelEdit.UpdateChannel;
begin
  Image.Visible := Channel.Mode = cmAlphaChannel;
  SBColor.Visible := Image.Visible;
  SBFilter.Visible := Image.Visible;
  Button.Visible := Channel.Mode = cmColorChannel;
  if Channel.Mode = cmAlphaChannel
  then Image.Mask := Channel
  else Button.Glyph := Channel;
  SBSave.Enabled := Channel.Active;
  SBClear.Enabled := Channel.Active;
  SBFilter.Down := Image.Color = clNone;
  if not SBFilter.Down then ColorSelect.Color := Image.Color;
end;

procedure TChannelEdit.SBFilterClick(Sender: TObject);
begin
  if SBFilter.Down
  then Image.Color := clNone
  else Image.Color := ColorSelect.Color;
end;

procedure TChannelEdit.SetChannel(AChannel: TChannel);
begin
  FChannel := AChannel;
  UpdateChannel;
end;

procedure TChannelEdit.SBColorClick(Sender: TObject);
begin
  if ColorSelect.Execute then
  begin
    SBFilter.Down := False;
    Image.Color := ColorSelect.Color;
  end;  
end;

end.
