unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, JDBSelectEdit, StdCtrls, Mask, DBCtrls, JDBStdPack,
  ComCtrls, ExtCtrls, Buttons, JBitBtn, JPanel, JRadioGroup, JGroupBox,
  JComboBox, JListBox, JRadioButon, JCheckBox, JMemo, JEdit, JLabel, JPack;

type
  TMainForm = class(TForm)
    ord_tbl: TTable;
    emp_tbl: TTable;
    ord_src: TDataSource;
    emp_src: TDataSource;
    ord_tblOrderNo: TFloatField;
    ord_tblCustNo: TFloatField;
    ord_tblSaleDate: TDateTimeField;
    ord_tblShipDate: TDateTimeField;
    ord_tblEmpNo: TIntegerField;
    ord_tblShipToContact: TStringField;
    ord_tblShipToAddr1: TStringField;
    ord_tblShipToAddr2: TStringField;
    ord_tblShipToCity: TStringField;
    ord_tblShipToState: TStringField;
    ord_tblShipToZip: TStringField;
    ord_tblShipToCountry: TStringField;
    ord_tblShipToPhone: TStringField;
    ord_tblShipVIA: TStringField;
    ord_tblPO: TStringField;
    ord_tblTerms: TStringField;
    ord_tblPaymentMethod: TStringField;
    ord_tblItemsTotal: TCurrencyField;
    ord_tblTaxRate: TFloatField;
    ord_tblFreight: TCurrencyField;
    ord_tblAmountPaid: TCurrencyField;
    emp_tblEmpNo: TIntegerField;
    emp_tblLastName: TStringField;
    emp_tblFirstName: TStringField;
    emp_tblPhoneExt: TStringField;
    emp_tblHireDate: TDateTimeField;
    emp_tblSalary: TFloatField;
    cus_tbl: TTable;
    cus_src: TDataSource;
    cus_tblCustNo: TFloatField;
    cus_tblCompany: TStringField;
    cus_tblAddr1: TStringField;
    cus_tblAddr2: TStringField;
    cus_tblCity: TStringField;
    cus_tblState: TStringField;
    cus_tblZip: TStringField;
    cus_tblCountry: TStringField;
    cus_tblPhone: TStringField;
    cus_tblFAX: TStringField;
    cus_tblTaxRate: TFloatField;
    cus_tblContact: TStringField;
    cus_tblLastInvoiceDate: TDateTimeField;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    ordedt: TJDBSelectEdit;
    DBNavigator1: TDBNavigator;
    cuscompanyedt: TEdit;
    custedt: TJDBSelectEdit;
    empnamedt: TEdit;
    sales: TGroupBox;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    Label14: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    saledate: TJDBEdit;
    shipdate: TJDBEdit;
    contact: TJDBEdit;
    via: TJDBComboBox;
    shiptophone: TJDBEdit;
    country: TJDBEdit;
    shpgrp: TGroupBox;
    Label11: TLabel;
    Label10: TLabel;
    Label9: TLabel;
    Label8: TLabel;
    Label7: TLabel;
    a1: TJDBEdit;
    a2: TJDBEdit;
    city: TJDBEdit;
    state: TJDBEdit;
    zip: TJDBEdit;
    Label15: TLabel;
    po: TJDBEdit;
    terms: TJDBComboBox;
    Label16: TLabel;
    Label17: TLabel;
    pm: TJDBComboBox;
    it: TJDBEdit;
    Label18: TLabel;
    Label19: TLabel;
    taxrate: TJDBEdit;
    RichEdit1: TRichEdit;
    empedt: TJDBSelectEdit;
    JLabel1: TJLabel;
    JEdit1: TJEdit;
    JMemo1: TJMemo;
    JCheckBox1: TJCheckBox;
    JRadioButton1: TJRadioButton;
    JListBox1: TJListBox;
    JComboBox1: TJComboBox;
    JGroupBox1: TJGroupBox;
    JRadioGroup1: TJRadioGroup;
    JPanel1: TJPanel;
    JBitBtn1: TJBitBtn;
    JBitBtn3: TJBitBtn;
    JEdit2: TJEdit;
    JEdit3: TJEdit;
    JEdit4: TJEdit;
    JEdit5: TJEdit;
    JEdit6: TJEdit;
    JComboBox2: TJComboBox;
    JPanel2: TJPanel;
    procedure ord_tblCustNoChange(Sender: TField);
    procedure empedtTextChanged(Sender: TObject);
    procedure custedtTextChanged(Sender: TObject);
    procedure custedtExit(Sender: TObject);
    procedure empedtExit(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ord_tblCustNoChange(Sender: TField);
begin
   cuscompanyedt.Text:=cus_tblcompany.asstring;
end;

procedure TMainForm.empedtTextChanged(Sender: TObject);
begin
   if emp_tbl.state<>dsinactive then
      if emp_tbl.locate('empno',ord_tblempno.value,[]) then
         empnamedt.Text:=emp_tblLastname.Asstring+', '+emp_tblFirstname.Asstring;
end;

procedure TMainForm.custedtTextChanged(Sender: TObject);
begin
   if cus_tbl.state<>dsinactive then
      if cus_tbl.locate('custno',ord_tblcustno.value,[]) then
         cuscompanyedt.Text:=cus_tblcompany.Asstring;
end;

procedure TMainForm.custedtExit(Sender: TObject);
begin
   if cus_tbl.state<>dsinactive then
      if Not cus_tbl.locate('custno',ord_tblcustno.value,[]) then
         raise Exception.Create('You must specify a valid value')
      else
         cuscompanyedt.Text:=cus_tblcompany.Asstring;
end;

procedure TMainForm.empedtExit(Sender: TObject);
begin
   if cus_tbl.state<>dsinactive then
      if Not emp_tbl.locate('empno',ord_tblempno.value,[]) then
         raise Exception.Create('You must specify a valid value')
      else
         empnamedt.Text:=emp_tblLastname.Asstring+', '+emp_tblFirstname.Asstring;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
   custedttextchanged(Self);
   empedttextchanged(Self);
end;

end.
