unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Scope, StdCtrls, ExtCtrls, Buttons, ComCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Timer1: TTimer;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    Panel3: TPanel;
    cbxFullGrid: TCheckBox;
    edtCaption: TEdit;
    Label1: TLabel;
    GroupBox1: TGroupBox;
    rbtSlide: TRadioButton;
    rbtJump: TRadioButton;
    GroupBox2: TGroupBox;
    rbtLeft: TRadioButton;
    rbtTop: TRadioButton;
    dlgColor: TColorDialog;
    btnBackground: TButton;
    btnIndicatorBackground: TButton;
    btnAxisColor: TButton;
    btnGridColor: TButton;
    btnGraphicColor: TButton;
    SpeedButton2: TSpeedButton;
    dlgFont: TFontDialog;
    btnFont: TButton;
    btnGridFont: TButton;
    cbxMode: TComboBox;
    Label2: TLabel;
    StatusBar1: TStatusBar;
    Scope: TScope;
    SpeedButton3: TSpeedButton;
    Panel4: TPanel;
    cbxAutoScale: TCheckBox;
    Button3: TButton;
    ComboBox1: TComboBox;
    Label3: TLabel;
    cbxWidth: TComboBox;
    procedure Timer1Timer(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure cbxFullGridClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rbtSlideClick(Sender: TObject);
    procedure rbtLeftClick(Sender: TObject);
    procedure edtCaptionChange(Sender: TObject);
    procedure btnBackgroundClick(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure btnFontClick(Sender: TObject);
    procedure btnGridFontClick(Sender: TObject);
    procedure cbxModeChange(Sender: TObject);
    procedure ScopeMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SpeedButton3Click(Sender: TObject);
    procedure cbxAutoScaleClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure cbxWidthChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  StartX : Double = 0.0;
  StartY : Double = 0.0;

var
  Form1: TForm1;
  Created : Boolean = False;

implementation

{$R *.DFM}

procedure TForm1.Timer1Timer(Sender: TObject);
var
  P : TDPoint;
  Step : Double;
  I : TIndicator;
begin
  I := Scope.Indicator;
  Step := {0.07}1/I.Scale[1];
//  Step := 0.1;
  StartX := StartX + Step;
//  StartY := 2+Random(100)/100;
  StartY := StartY + (Random(11)-5);
//  StartY := 4+Random(100)/100;
//  if Abs(StartY) >= 50 then StartY := 50;

  P[1] := StartX;
  P[2] := StartY;
  if Scope.Indicator.Orientation = doLeftToRight then begin
    Scope.Indicator.AddPoint(DPoint(StartX, StartY))
  end
  else begin
    Scope.Indicator.AddPoint(DPoint(StartY, StartX));
  end;
  Scope.Refresh;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  Timer1.Enabled := SpeedButton1.Down;
  if SpeedButton1.Down then
    SpeedButton1.Caption := 'STOP'
  else
    SpeedButton1.Caption := 'START';
end;

procedure TForm1.cbxFullGridClick(Sender: TObject);
begin
  Scope.Indicator.FullGrid := cbxFullGrid.Checked;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  edtCaption.Text := Scope.Indicator.Caption;
  cbxFullGrid.Checked := Scope.Indicator.FullGrid;
  cbxAutoScale.Checked := Scope.Indicator.AutoScale;
  rbtSlide.Checked := Scope.Indicator.Slide;
  rbtJump.Checked := not Scope.Indicator.Slide;

  rbtLeft.Checked := False;
  rbtTop.Checked := False;
  case Scope.Indicator.Orientation of
    doLeftToRight : rbtLeft.Checked := True;
    doTopToBottom : rbtTop.Checked := True;
  end;
  cbxMode.ItemIndex := Byte(Scope.Indicator.MouseMode);
  ComboBox1.ItemIndex := Byte(Scope.Indicator.DrawType);
  cbxWidth.Text := IntToStr(Scope.Indicator.GraphicWidth);

  Created := True;
end;

procedure TForm1.rbtSlideClick(Sender: TObject);
begin
  Scope.Indicator.Slide := rbtSlide.Checked;
end;

procedure TForm1.rbtLeftClick(Sender: TObject);
begin
  if Created then begin
    if rbtLeft.Checked then
      Scope.Indicator.Orientation := doLeftToRight
    else
      Scope.Indicator.Orientation := doTopToBottom;
  end;
end;

procedure TForm1.edtCaptionChange(Sender: TObject);
begin
  Scope.Indicator.Caption := edtCaption.Text;
end;

procedure TForm1.btnBackgroundClick(Sender: TObject);
begin
  case TButton(Sender).Tag of
    1 : dlgColor.Color := Scope.Background;
    2 : dlgColor.Color := Scope.Indicator.Background;
    3 : dlgColor.Color := Scope.Indicator.AxisColor;
    4 : dlgColor.Color := Scope.Indicator.GridColor;
    5 : dlgColor.Color := Scope.Indicator.GraphicColor;
    6 : dlgColor.Color := Scope.Indicator.MarkColor;
  end;
  if dlgColor.Execute then begin
    case TButton(Sender).Tag of
      1 : Scope.Background := dlgColor.Color;
      2 : Scope.Indicator.Background := dlgColor.Color;
      3 : Scope.Indicator.AxisColor := dlgColor.Color;
      4 : Scope.Indicator.GridColor := dlgColor.Color;
      5 : Scope.Indicator.GraphicColor := dlgColor.Color;
      6 : Scope.Indicator.MarkColor := dlgColor.Color;
    end;
  end;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  Timer1Timer(Self);
end;

procedure TForm1.btnFontClick(Sender: TObject);
begin
  dlgFont.Font := Scope.Indicator.Font;
  if dlgFont.Execute then
    Scope.Indicator.Font := dlgFont.Font;
end;

procedure TForm1.btnGridFontClick(Sender: TObject);
begin
  dlgFont.Font := Scope.Indicator.GridFont;
  if dlgFont.Execute then
    Scope.Indicator.GridFont := dlgFont.Font;
end;

procedure TForm1.cbxModeChange(Sender: TObject);
begin
  Scope.Indicator.MouseMode := TMouseMode(cbxMode.ItemIndex);
end;

procedure TForm1.ScopeMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  p : TDPoint;
  pi : TPoint;
begin
  pi := Scope.Indicator.ScopeToIndicator(Point(X, Y));
  p := Scope.Indicator.ScreenToWorld(Point(X, Y));
  StatusBar1.Panels[0].Text := Format('Xi = %d', [pi.X]);
  StatusBar1.Panels[2].Text := Format('Yi = %d', [pi.Y]);
  StatusBar1.Panels[4].Text := Format('Xw = %9.2f', [p[1]]);
  StatusBar1.Panels[6].Text := Format('Yw = %9.2f', [p[2]]);
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  Scope.Indicator.AddMark(StartX, FloatToStrF(StartX, ffGeneral, 9, 1));
  Scope.Draw;
end;

procedure TForm1.cbxAutoScaleClick(Sender: TObject);
begin
  Scope.Indicator.AutoScale := cbxAutoScale.Checked;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  Scope.Indicator.DrawType := TDrawType(ComboBox1.ItemIndex);
end;

procedure TForm1.cbxWidthChange(Sender: TObject);
begin
  Scope.Indicator.GraphicWidth := StrToInt(cbxWidth.Text);
end;

end.
