unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, DBTables, ImageEn, DBImageEn, ExtCtrls, Grids, DBGrids,
  ComCtrls, Mask, DBCtrls, ImageEnView, ImageEnProc, ImageEnIO,
  IEOpenSaveDlg;

type
  TMainForm = class(TForm)
    DBGrid1: TDBGrid;
    Panel2: TPanel;
    Table1: TTable;
    DataSource1: TDataSource;
    New: TButton;
    Del: TButton;
    Button1: TButton;
    Button4: TButton;
    ImageEnProc1: TImageEnProc;
    ImageEnIO1: TImageEnIO;
    Panel1: TPanel;
    Panel3: TPanel;
    Zoom: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Bevel1: TBevel;
    Button2: TButton;
    Button3: TButton;
    TrackBar1: TTrackBar;
    DBEdit1: TDBEdit;
    ComboBox1: TComboBox;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    ImageEnDBView1: TImageEnDBView;
    OpenImageEnDialog1: TOpenImageEnDialog;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure NewClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DelClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Table1AfterScroll(DataSet: TDataSet);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses GifLZW,TifLZW;

{$R *.DFM}

// Import...
procedure TMainForm.Button2Click(Sender: TObject);
begin
	if OpenImageEnDialog1.Execute then
   	ImageEnIO1.LoadFromFile(OpenImageEnDialog1.filename);
end;

// Effects...
procedure TMainForm.Button3Click(Sender: TObject);
begin
	ImageEnProc1.DoPreviews(ppeEffects);
end;

// Color adjust...
procedure TMainForm.Button7Click(Sender: TObject);
begin
	ImageEnProc1.DoPreviews(ppeColorAdjust);
end;

// zoom
procedure TMainForm.TrackBar1Change(Sender: TObject);
begin
	ImageEnDBView1.Zoom:=TrackBar1.Position;
end;

// New
procedure TMainForm.NewClick(Sender: TObject);
begin
	Table1.Append;
   ImageEnDBView1.DataFieldImageFormat:=ifJpeg;
   ComboBox1.ItemIndex:=0;
end;

// Post
procedure TMainForm.Button1Click(Sender: TObject);
begin
	if Table1.State<>dsBrowse then
		Table1.Post;
end;

// Del/Cancel
procedure TMainForm.DelClick(Sender: TObject);
begin
	if (Table1.State=dsEdit) or (Table1.State=dsInsert) then
   	Table1.Cancel
   else
	   Table1.Delete;
end;

// Modify
procedure TMainForm.Button4Click(Sender: TObject);
begin
	Table1.Edit;
end;

//
procedure TMainForm.FormActivate(Sender: TObject);
begin
   DefGIF_LZWDECOMPFUNC:=GIFLZWDecompress;
   DefGIF_LZWCOMPFUNC:=GIFLZWCompress;
   DefTIFF_LZWDECOMPFUNC:=TIFFLZWDecompress;
   DefTIFF_LZWCOMPFUNC:=TIFFLZWCompress;
	Table1.DatabaseName:=ExtractFilePath(application.exename);
   Table1.Open;
end;

// change combobox - store format
procedure TMainForm.ComboBox1Change(Sender: TObject);
begin
	case ComboBox1.ItemIndex of
      0: // BMP
			ImageEnDBView1.DataFieldImageFormat:=ifBitmap;
   	1:	// JPEG
			ImageEnDBView1.DataFieldImageFormat:=ifJpeg;
      2: // GIF
			ImageEnDBView1.DataFieldImageFormat:=ifGif;
      3: // PCX
      	ImageEnDBView1.DataFieldImageFormat:=ifPCX;
      4: // TIFF
      	ImageEnDBView1.DataFieldImageFormat:=ifTIFF;
      5: // PNG
      	ImageEnDBView1.DataFieldImageFormat:=ifPNG;
      6: // UNKNOW
      	ImageEnDBView1.DataFieldImageFormat:=ifUnknown;
   end;
end;

// update combobox - store format
procedure TMainForm.Table1AfterScroll(DataSet: TDataSet);
begin
	ComboBox1.ItemIndex:=ord(ImageEnDBView1.LoadedFieldImageFormat);
end;

// Copy
procedure TMainForm.Button5Click(Sender: TObject);
begin
	ImageEnProc1.SelCopyToClip;
end;

// Paste
procedure TMainForm.Button6Click(Sender: TObject);
begin
	ImageEnProc1.PasteFromClipboard;
end;

// Store paramters
procedure TMainForm.Button8Click(Sender: TObject);
begin
	ImageEnDBView1.DoIOPreview;
end;



end.
