unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ImageEnView, VideoCap, ExtCtrls, Buttons, ImageEnProc, Menus,
  ImageEnIO, ComCtrls, IEOpenSaveDlg;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    CheckBox1: TCheckBox;
    Button1: TButton;
    ImageEnProc1: TImageEnProc;
    ImageEnProc2: TImageEnProc;
    Button2: TButton;
    GroupBox2: TGroupBox;
    SpeedButton3: TSpeedButton;
    CheckBox2: TCheckBox;
    SpeedButton4: TSpeedButton;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    Button7: TButton;
    Button6: TButton;
    Button5: TButton;
    SpeedButton5: TSpeedButton;
    Button11: TButton;
    ImageEnIO1: TImageEnIO;
    Button12: TButton;
    ImageEnVideoView1: TImageEnVideoView;
    ImageEnVideoView2: TImageEnVideoView;
    Label5: TLabel;
    Label6: TLabel;
    ComboBox1: TComboBox;
    Label7: TLabel;
    GroupBox3: TGroupBox;
    SpeedButton6: TSpeedButton;
    Button8: TButton;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    UpDown1: TUpDown;
    SaveImageEnDialog1: TSaveImageEnDialog;
    Label4: TLabel;
    procedure SpeedButton2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure ImageEnVideoView1MouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
	 procedure ImageEnVideoView1VideoFrame(Sender: TObject; Bitmap: TBitmap);
    procedure DisplayVideoSize;
  end;

var
  Form1: TForm1;

implementation

uses Unit2, giflzw, tiflzw;

{$R *.DFM}

// Input-A ON
procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
	ImageEnVideoView1.ShowVideo:=SpeedButton2.Down;
	Button1.enabled:=not SpeedButton2.Down;
   Button2.enabled:=not SpeedButton2.Down;
	SpeedButton3.enabled:=not SpeedButton2.Down;
   Button12.enabled:=not SpeedButton2.Down;
end;

// Input-B ON
procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
	ImageEnVideoView2.ShowVideo:=SpeedButton3.Down;
	Button3.enabled:=not SpeedButton3.Down;
   Button4.enabled:=not SpeedButton3.Down;
	SpeedButton2.enabled:=not SpeedButton3.Down;
   Button12.enabled:=not SpeedButton3.Down;
end;

// overlay (A)
procedure TForm1.CheckBox1Click(Sender: TObject);
begin
	if checkbox1.checked then
		ImageEnVideoView1.DisplayMode:=dmOverlay
   else
		ImageEnVideoView1.DisplayMode:=dmPreview;
end;

// overlay (B)
procedure TForm1.CheckBox2Click(Sender: TObject);
begin
	if checkbox2.checked then
		ImageEnVideoView2.DisplayMode:=dmOverlay
   else
		ImageEnVideoView2.DisplayMode:=dmPreview;
end;

// freeze (A)
procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
	ImageEnVideoView1.Frozen:=SpeedButton1.Down;
end;

// freeze (B)
procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
	ImageEnVideoView2.Frozen:=SpeedButton4.Down;
end;

// Color adjust (A)
procedure TForm1.Button1Click(Sender: TObject);
begin
	ImageEnProc1.DoPreviews(ppeColorAdjust);
end;

// Effects (A)
procedure TForm1.Button2Click(Sender: TObject);
begin
	ImageEnProc1.DoPreviews(ppeEffects);
end;

// Color adjust (B)
procedure TForm1.Button3Click(Sender: TObject);
begin
	ImageEnProc2.DoPreviews(ppeColorAdjust);
end;

// effects (B)
procedure TForm1.Button4Click(Sender: TObject);
begin
	ImageEnProc2.DoPreviews(ppeEffects);
end;

// Configure source
procedure TForm1.Button5Click(Sender: TObject);
begin
	if not ImageEnVideoView1.DoConfigureSource then
		MessageDlg('Configure Source dialog not available',mtInformation,[mbOK],0)
   else
   	DisplayVideoSize;
end;

// Configure Format
procedure TForm1.Button6Click(Sender: TObject);
begin
   if not ImageEnVideoView1.DoConfigureFormat then
	   MessageDlg('Configure Format dialog not available',mtInformation,[mbOK],0)
   else
   	DisplayVideoSize;
end;

// Configure display
procedure TForm1.Button7Click(Sender: TObject);
begin
   if not ImageEnVideoView1.DoConfigureDisplay then
	   MessageDlg('Configure Display dialog not available',mtInformation,[mbOK],0)
   else
   	DisplayVideoSize;
end;

// Frames to B
procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
	if SpeedButton5.Down then
		ImageEnVideoView1.OnVideoFrame:=ImageEnVideoView1VideoFrame
   else
   	ImageEnVideoView1.OnVideoFrame:=nil;
end;

// Frames to B - OnVideoFrame
procedure TForm1.ImageEnVideoView1VideoFrame(Sender: TObject; Bitmap: TBitmap);
begin
	ImageEnVideoView2.assign(Bitmap);
   case ComboBox1.ItemIndex of
   	1: ImageEnProc2.ConvertToBWOrdered;
      2: ImageEnProc2.ConvertToBWThreshold(-1);
      3: ImageEnProc2.COnvertToGray;
   end;
end;

// Save as...
procedure TForm1.Button11Click(Sender: TObject);
begin
	if SaveImageEnDialog1.Execute then
   	ImageEnIO1.SaveToFile(SaveImageEnDialog1.filename);
end;

// Input -C
procedure TForm1.Button12Click(Sender: TObject);
begin
	Form2.ImageEnVideoView1.ShowVideo:=true;
	Form2.ShowModal;
   Form2.ImageEnVideoView1.ShowVideo:=false;
end;

//
procedure TForm1.DisplayVideoSize;
var
	r:TRect;
begin
	r:=ImageEnVideoView1.GetVideoSize;
	Label6.caption:=inttostr(r.right+1)+'x'+inttostr(r.bottom+1);
end;

//
procedure TForm1.FormActivate(Sender: TObject);
begin
   DefGIF_LZWDECOMPFUNC:=GIFLZWDecompress;
   DefGIF_LZWCOMPFUNC:=GIFLZWCompress;
   DefTIFF_LZWDECOMPFUNC:=TIFFLZWDecompress;
   DefTIFF_LZWCOMPFUNC:=TIFFLZWCompress;
	DisplayVideoSize;
   ComboBox1.ItemIndex:=0;
   Edit1.Text:=ImageEnVideoView1.RecFileName;
   UpDown1.Position:=ImageEnVideoView1.RecFrameRate;
end;

// record
procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
	if SpeedButton6.Down then begin
   	ImageEnVideoView1.RecFileName:=Edit1.Text;
      ImageEnVideoView1.RecFrameRate:=UpDown1.Position;
		ImageEnVideoView1.StartRecord
   end else
   	ImageEnVideoView1.StopRecord;
end;

// Compression
procedure TForm1.Button8Click(Sender: TObject);
begin
	ImageEnVideoView1.DoConfigureCompression;
end;

procedure TForm1.ImageEnVideoView1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
	label4.caption:=inttostr(x)+' '+inttostr(y);
end;



end.
