{-------------------------------------------------------------------------
                                                       / >>>>>>>>> /-----
              Copyright (C) 1998-2003 Hger + Busch   / <<<<<<<<< /
 ----------------------------------------------------/ >>>>>>>>> /
        Ingenieurbuero fuer Kommunikationslsungen

 Project     : hbTAPI
 Version     : 1.6.1
 File        : hbTapi.pas
 Description : Helper functions to convert TAPI constants into
               string values.
 -------------------------------------------------------------------------
 History: [-] Fixed [+] Added [*] Improved
}
unit hbTapiUtils;

interface
uses Windows, Classes, Tapi;

{ CallState }
function  LineCallStateToStr      (CallState : DWORD) : string;
function  LineCallStateToStrDE    (CallState : DWORD) : string;
procedure LineCallStatesToStrList (CallStates: DWORD; List: TStrings);
function  LineCallStateModeToStr  (CallState, StateMode: DWORD): string;

{ CallInfo }
function  LineCallInfoToStr       (CallInfo: DWORD): String;

{ CallReason }
function  LineCallReasonToStr     (CallReason: DWORD): String;

{ CallOrigin }
function  LineCallOriginToStr     (CallOrigin: DWORD) : String;

{ CallPrivilege }
function  StrToLineCallPrivilege  (CallPrivilege: String) : DWORD;
function  LineCallPrivilegesToStr (CallPrivileges: DWORD; Spacer: String = ' ') : string;

{ MediaMode }
function  LineMediaModeToStr      (MediaMode : DWORD): String;
function  LineMediaModesToStr     (MediaModes: DWORD; Spacer: String= ' ') : String;
procedure LineMediaModesToStrList (MediaModes: DWORD; List: TStrings);
function  StrToLineMediaMode      (MediaMode : String; Default: DWORD=0) : DWORD;

{ BearerModer }
function  LineBearerModeToStr     (BearerMode : DWORD ): String;
function  StrToLineBearerMode     (BearerMode : String): DWORD;
function  LineBearerModesToStr    (BearerModes: DWORD ): String;
procedure LineBearerModesToStrList(BearerModes: DWORD; List: TStrings );

{ AddressState }
function LineAddrStateToStr       (AddressState: DWORD) : string;

{ AddressMode }
function  StrToLineAddressMode     (AddressMode : String): DWORD;
function  LineAddressModeToStr     (AddressMode : DWORD): String;
procedure LineAddressModesToStrList(AddressModes: DWORD; List: TStrings );

{ DisconnectMode }
function  LineDiscModeToStr       (DiscMode  : DWORD ) : String;
procedure LineDiscModesToStrList  (DiscModes : DWORD; List : TStrings );

{ DigitMode }
function  LineDigitModeToStr      (DigitMode: DWORD) : String;
procedure LineDigitModesToStrList (DigitMode: DWORD; List : TStrings );
function  StrToLineDigitMode      (DigitMode: String; Default: DWORD=0): DWORD;

{ PhonePrivileges }
function  PhonePrivilegesToStr(const Value : DWORD; Spacer: String) : string;

{ PhoneLampMode }
function  PhoneLampModeToStr      (LampMode: DWORD): String;
function  PhoneButtonStateToStr   (ButtonState: DWORD): String;
function  PhoneButtonModeToStr    (ButtonMode: DWORD): String;
function  PhoneButtonFunctionToStr(ButonFunction: DWORD): String;

{ TAPI }
function  MessageIDToStr       (MessageID: DWORD ) : String;
function  LineErrToStr(LineError: DWORD) : String;


implementation
uses SysUtils;

function OrStr( s1, s2 : String; Spacer: String = ' ') : String;
begin
  if s1 <> '' then
    result := s1 + Spacer + s2
  else
    result := s2;
end;

{ ============================================================================ }
{ L I N E C A L L S T A T E }
{ ============================================================================ }

{*****************************************************************************}
function LineCallStateToStr (CallState : DWORD) : string;
{*****************************************************************************}
begin
  case CallState of
    LINECALLSTATE_IDLE                 : Result:='IDLE';
    LINECALLSTATE_OFFERING             : Result:='OFFERING';
    LINECALLSTATE_ACCEPTED             : Result:='ACCEPTED';
    LINECALLSTATE_DIALTONE             : Result:='DIALTONE';
    LINECALLSTATE_DIALING              : Result:='DIALING';
    LINECALLSTATE_RINGBACK             : Result:='RINGBACK';
    LINECALLSTATE_BUSY                 : Result:='BUSY';
    LINECALLSTATE_SPECIALINFO          : Result:='SPECIALINFO';
    LINECALLSTATE_CONNECTED            : Result:='CONNECTED';
    LINECALLSTATE_PROCEEDING           : Result:='PROCEEDING';
    LINECALLSTATE_ONHOLD               : Result:='ONHOLD';
    LINECALLSTATE_CONFERENCED          : Result:='CONFERENCED';
    LINECALLSTATE_ONHOLDPENDCONF       : Result:='ONHOLDPENDCONF';
    LINECALLSTATE_ONHOLDPENDTRANSFER   : Result:='ONHOLDPENDTRANSFER';
    LINECALLSTATE_DISCONNECTED         : Result:='DISCONNECTED'
  else
    Result:= Format('$%x', [CallState]);
  end;
end;

{*****************************************************************************}
function LineCallStateToStrDE(CallState : DWORD) : string;
{*****************************************************************************}
begin
  case CallState of
    LINECALLSTATE_IDLE                 : Result:='Ruhe';
    LINECALLSTATE_OFFERING             : Result:='Anruf';
    LINECALLSTATE_ACCEPTED             : Result:='Angenommen';
    LINECALLSTATE_DIALTONE             : Result:='Whlton';
    LINECALLSTATE_DIALING              : Result:='Wahl';
    LINECALLSTATE_RINGBACK             : Result:='Rufton';
    LINECALLSTATE_BUSY                 : Result:='Besetzt';
    LINECALLSTATE_SPECIALINFO          : Result:='Spezialmeldung';
    LINECALLSTATE_CONNECTED            : Result:='Gesprch';
    LINECALLSTATE_PROCEEDING           : Result:='Rufton';
    LINECALLSTATE_ONHOLD               : Result:='Gehalten';
    LINECALLSTATE_CONFERENCED          : Result:='Konferenz';
    LINECALLSTATE_ONHOLDPENDCONF       : Result:='Warten auf Konferenz';
    LINECALLSTATE_ONHOLDPENDTRANSFER   : Result:='Warten auf Transfer';
    LINECALLSTATE_DISCONNECTED         : Result:='Getrennt';
    LINECALLSTATE_UNKNOWN              : Result:='Unbekannt'
  else
    Result:= Format('$%x', [CallState]);
  end;
end;

{*****************************************************************************}
procedure LineCallStatesToStrList(CallStates: DWORD; List: TStrings);
{*****************************************************************************}
begin
  List.clear;
  if (LINECALLSTATE_IDLE               and CallStates) > 0 then List.add('IDLE');
  if (LINECALLSTATE_OFFERING           and CallStates) > 0 then List.add('OFFERING');
  if (LINECALLSTATE_ACCEPTED           and CallStates) > 0 then List.add('ACCEPTED');
  if (LINECALLSTATE_DIALTONE           and CallStates) > 0 then List.add('DIALTONE');
  if (LINECALLSTATE_DIALING            and CallStates) > 0 then List.add('DIALING');
  if (LINECALLSTATE_RINGBACK           and CallStates) > 0 then List.add('RINGBACK');
  if (LINECALLSTATE_BUSY               and CallStates) > 0 then List.add('BUSY');
  if (LINECALLSTATE_SPECIALINFO        and CallStates) > 0 then List.add('SPECIALINFO');
  if (LINECALLSTATE_CONNECTED          and CallStates) > 0 then List.add('CONNECTED');
  if (LINECALLSTATE_PROCEEDING         and CallStates) > 0 then List.add('PROCEEDING');
  if (LINECALLSTATE_ONHOLD             and CallStates) > 0 then List.add('ONHOLD');
  if (LINECALLSTATE_CONFERENCED        and CallStates) > 0 then List.add('CONFERENCED');
  if (LINECALLSTATE_ONHOLDPENDCONF     and CallStates) > 0 then List.add('ONHOLDPENDCONF');
  if (LINECALLSTATE_ONHOLDPENDTRANSFER and CallStates) > 0 then List.add('ONHOLDPENDTRANSFER');
  if (LINECALLSTATE_DISCONNECTED       and CallStates) > 0 then List.add('DISCONNECTED');
end;

{*****************************************************************************}
function LineCallStateModeToStr(CallState, StateMode: DWORD) : string;
{*****************************************************************************}
begin
  Result:='';
  case CallState of
    LINECALLSTATE_BUSY :
      case StateMode of
        LINEBUSYMODE_STATION :
          Result:='STATION';
        LINEBUSYMODE_TRUNK :
          Result:='TRUNK';
        LINEBUSYMODE_UNKNOWN :
          Result:='UNKNOWN';
        LINEBUSYMODE_UNAVAIL :
          Result:='UNAVAIL';
      end;
    LINECALLSTATE_CONNECTED :
      case StateMode of
        LINECONNECTEDMODE_ACTIVE :
          Result := 'ACTIVE';
        LINECONNECTEDMODE_ACTIVEHELD :
          Result := 'ACTIVEHELD';
        LINECONNECTEDMODE_CONFIRMED :
          Result := 'CONFIRMED';
        LINECONNECTEDMODE_INACTIVE :
          Result := 'INACTIVE';
        LINECONNECTEDMODE_INACTIVEHELD :
          Result := 'INACTIVEHELD';
      end;
    LINECALLSTATE_DIALTONE :
      case StateMode of
        LINEDIALTONEMODE_NORMAL :
          Result:='NORMAL';
        LINEDIALTONEMODE_SPECIAL :
          Result:='SPECIAL';
        LINEDIALTONEMODE_INTERNAL :
          Result:='INTERNAL';
        LINEDIALTONEMODE_EXTERNAL :
          Result:='EXTERNAL';
        LINEDIALTONEMODE_UNKNOWN :
          Result:='UNKNOWN';
        LINEDIALTONEMODE_UNAVAIL :
          Result:='UNAVAIL';
      end;
    LINECALLSTATE_OFFERING :
      case StateMode of
        LINEOFFERINGMODE_ACTIVE :
          Result := 'ACTIVE';
        LINEOFFERINGMODE_INACTIVE :
          Result := 'INACTIVE';
      end;
    LINECALLSTATE_SPECIALINFO :
      case StateMode of
        LINESPECIALINFO_CUSTIRREG :
          Result := 'CUSTIRREG';
        LINESPECIALINFO_NOCIRCUIT :
          Result := 'NOCIRCUIT';
        LINESPECIALINFO_REORDER :
          Result := 'REORDER';
        LINESPECIALINFO_UNAVAIL :
          Result := 'UNAVAIL';
        LINESPECIALINFO_UNKNOWN :
          Result := 'UNKNOWN';
      end;
    LINECALLSTATE_DISCONNECTED :
      case StateMode of
        LINEDISCONNECTMODE_NORMAL :
          Result:='NORMAL';
        LINEDISCONNECTMODE_UNKNOWN :
          Result:='UNKNOWN';
        LINEDISCONNECTMODE_REJECT :
          Result:='REJECT';
        LINEDISCONNECTMODE_PICKUP :
          Result:='PICKUP';
        LINEDISCONNECTMODE_FORWARDED :
          Result:='FORWARDED';
        LINEDISCONNECTMODE_BUSY :
          Result:='BUSY';
        LINEDISCONNECTMODE_NOANSWER :
          Result:='NOANSWER';
        LINEDISCONNECTMODE_BADADDRESS :
          Result:='BADADDRESS';
        LINEDISCONNECTMODE_UNREACHABLE :
          Result:='UNREACHABLE';
        LINEDISCONNECTMODE_CONGESTION :
          Result:='CONGESTION';
        LINEDISCONNECTMODE_INCOMPATIBLE :
          Result:='INCOMPATIBLE';
        LINEDISCONNECTMODE_UNAVAIL :
          Result:='UNAVAIL'
      end;
  end;
end;

{ ============================================================================ }
{ L I N E C A L L O R I G I N }
{ ============================================================================ }

{*****************************************************************************}
function LineCallOriginToStr( CallOrigin : DWORD ) : String;
{*****************************************************************************}
begin
  result := '';
  if CallOrigin and LINECALLORIGIN_OUTBOUND   > 0 then result := OrStr(result, 'OUTBOUND');
  if CallOrigin and LINECALLORIGIN_INTERNAL   > 0 then result := OrStr(result, 'INTERNAL');
  if CallOrigin and LINECALLORIGIN_EXTERNAL   > 0 then result := OrStr(result, 'EXTERNAL');
  if CallOrigin and LINECALLORIGIN_UNKNOWN    > 0 then result := OrStr(result, 'UNKNOWN');
  if CallOrigin and LINECALLORIGIN_UNAVAIL    > 0 then result := OrStr(result, 'UNAVAIL');
  if CallOrigin and LINECALLORIGIN_CONFERENCE > 0 then result := OrStr(result, 'CONFERENCE');
  if CallOrigin and LINECALLORIGIN_INBOUND    > 0 then result := OrStr(result, 'INBOUND');
end;

{ ============================================================================ }
{ L I N E C A L L I N F O }
{ ============================================================================ }

{*****************************************************************************}
function LineCallInfoToStr(CallInfo: DWORD): String;
{*****************************************************************************}
begin
  case CallInfo of
    LINECALLINFOSTATE_OTHER                 : result := 'OTHER';
    LINECALLINFOSTATE_DEVSPECIFIC           : result := 'DEVSPECIFIC';
    LINECALLINFOSTATE_BEARERMODE            : result := 'BEARERMODE';
    LINECALLINFOSTATE_RATE                  : result := 'RATE';
    LINECALLINFOSTATE_MEDIAMODE             : result := 'MEDIAMODE';
    LINECALLINFOSTATE_APPSPECIFIC           : result := 'APPSPECIFIC';
    LINECALLINFOSTATE_CALLID                : result := 'CALLID';
    LINECALLINFOSTATE_RELATEDCALLID         : result := 'RELATEDCALLID';
    LINECALLINFOSTATE_ORIGIN                : result := 'ORIGIN';
    LINECALLINFOSTATE_REASON                : result := 'REASON';
    LINECALLINFOSTATE_COMPLETIONID          : result := 'COMPLETIONID';
    LINECALLINFOSTATE_NUMOWNERINCR          : result := 'NUMOWNERINCR';
    LINECALLINFOSTATE_NUMOWNERDECR          : result := 'NUMOWNERDECR';
    LINECALLINFOSTATE_NUMMONITORS           : result := 'NUMMONITORS';
    LINECALLINFOSTATE_TRUNK                 : result := 'TRUNK';
    LINECALLINFOSTATE_CALLERID              : result := 'CALLERID';
    LINECALLINFOSTATE_CALLEDID              : result := 'CALLEDID';
    LINECALLINFOSTATE_CONNECTEDID           : result := 'CONNECTEDID';
    LINECALLINFOSTATE_REDIRECTIONID         : result := 'REDIRECTIONID';
    LINECALLINFOSTATE_REDIRECTINGID         : result := 'REDIRECTINGID';
    LINECALLINFOSTATE_DISPLAY               : result := 'DISPLAY';
    LINECALLINFOSTATE_USERUSERINFO          : result := 'USERUSERINFO';
    LINECALLINFOSTATE_HIGHLEVELCOMP         : result := 'HIGHLEVELCOMP';
    LINECALLINFOSTATE_LOWLEVELCOMP          : result := 'LOWLEVELCOMP';
    LINECALLINFOSTATE_CHARGINGINFO          : result := 'CHARGINGINFO';
    LINECALLINFOSTATE_TERMINAL              : result := 'TERMINAL';
    LINECALLINFOSTATE_DIALPARAMS            : result := 'DIALPARAMS';
    LINECALLINFOSTATE_MONITORMODES          : result := 'MONITORMODES';
    LINECALLINFOSTATE_TREATMENT             : result := 'TREATMENT';     // TAPI v2.0
    LINECALLINFOSTATE_QOS                   : result := 'QOS';     // TAPI v2.0
    LINECALLINFOSTATE_CALLDATA              : result := 'CALLDATA';     // TAPI v2.0
  else
    Result := IntToHex(CallInfo,4);
  end;
end;

{ ============================================================================ }
{ L I N E C A L L R E A S O N }
{ ============================================================================ }

{*****************************************************************************}
function LineCallReasonToStr(CallReason: DWORD): String;
{*****************************************************************************}
begin
  case CallReason of
    LINECALLREASON_DIRECT                   : result := 'DIRECT';
    LINECALLREASON_FWDBUSY                  : result := 'FWDBUSY';
    LINECALLREASON_FWDNOANSWER              : result := 'FWDNOANSWER';
    LINECALLREASON_FWDUNCOND                : result := 'FWDUNCOND';
    LINECALLREASON_PICKUP                   : result := 'PICKUP';
    LINECALLREASON_UNPARK                   : result := 'UNPARK';
    LINECALLREASON_REDIRECT                 : result := 'REDIRECT';
    LINECALLREASON_CALLCOMPLETION           : result := 'CALLCOMPLETION';
    LINECALLREASON_TRANSFER                 : result := 'TRANSFER';
    LINECALLREASON_REMINDER                 : result := 'REMINDER';
    LINECALLREASON_UNKNOWN                  : result := 'UNKNOWN';
    LINECALLREASON_UNAVAIL                  : result := 'UNAVAIL';
    LINECALLREASON_INTRUDE                  : result := 'INTRUDE';      // TAPI v1.4
    LINECALLREASON_PARKED                   : result := 'PARKED';       // TAPI v1.4
    LINECALLREASON_CAMPEDON                 : result := 'CAMPEDON';     // TAPI v2.0
    LINECALLREASON_ROUTEREQUEST             : result := 'ROUTEREQUEST'; // TAPI v2.0
  else
    Result := IntToHex(CallReason,4);
  end;
end;

{ ============================================================================ }
{ L I N E C A L L P R I V I L E G E }
{ ============================================================================ }

{*****************************************************************************}
function StrToLineCallPrivilege(CallPrivilege: String): DWORD;
{*****************************************************************************}
begin
  if      CallPrivilege = 'NONE'     then result := LINECALLPRIVILEGE_NONE
  else if CallPrivilege = 'MONITOR'  then result := LINECALLPRIVILEGE_MONITOR
  else if CallPrivilege = 'OWNER'    then result := LINECALLPRIVILEGE_OWNER
  else result := LINECALLPRIVILEGE_NONE;
end;

{*****************************************************************************}
function LineCallPrivilegesToStr(CallPrivileges: DWORD; Spacer: String) : string;
{*****************************************************************************}
begin
  result := '';
  if (CallPrivileges and LINECALLPRIVILEGE_OWNER)   > 0 then result := OrStr(result, 'OWNER',   Spacer);
  if (CallPrivileges and LINECALLPRIVILEGE_MONITOR) > 0 then result := Orstr(result, 'MONITOR', Spacer);
  if (CallPrivileges and LINECALLPRIVILEGE_NONE)    > 0 then result := Orstr(result, 'NONE',    Spacer);
end;

{ ============================================================================ }
{ L I N E A D D R E S S S T A T E }
{ ============================================================================ }

{*****************************************************************************}
function LineAddrStateToStr(AddressState: DWORD) : string;
{*****************************************************************************}
begin
  Result:='';
  case AddressState of
    LINEADDRESSSTATE_CAPSCHANGE   : result := 'CAPSCHANGE';
    LINEADDRESSSTATE_DEVSPECIFIC  : result := 'DEVSPECIFIC';
    LINEADDRESSSTATE_FORWARD      : result := 'FORWARD';
    LINEADDRESSSTATE_INUSEMANY    : result := 'INUSEMANY';
    LINEADDRESSSTATE_INUSEONE     : result := 'INUSEONE';
    LINEADDRESSSTATE_INUSEZERO    : result := 'INUSEZERO';
    LINEADDRESSSTATE_NUMCALLS     : result := 'NUMCALLS';
    LINEADDRESSSTATE_OTHER        : result := 'OTHER';
    LINEADDRESSSTATE_TERMINALS    : result := 'TERMINALS';
  end;
  if Result = '' then
    Result := IntToHex(AddressState,4);
end;

{ ============================================================================ }
{ L I N E M E D I A M O D E }
{ ============================================================================ }

{*****************************************************************************}
function LineMediaModeToStr(MediaMode: DWORD): String;
{*****************************************************************************}
begin
  case MediaMode of
    LINEMEDIAMODE_UNKNOWN          : result := 'UNKNOWN';
    LINEMEDIAMODE_INTERACTIVEVOICE : result := 'INTERACTIVEVOICE';
    LINEMEDIAMODE_AUTOMATEDVOICE   : result := 'AUTOMATEDVOICE';
    LINEMEDIAMODE_DATAMODEM        : result := 'DATAMODEM';
    LINEMEDIAMODE_G3FAX            : result := 'G3FAX';
    LINEMEDIAMODE_TDD              : result := 'TDD';
    LINEMEDIAMODE_G4FAX            : result := 'G4FAX';
    LINEMEDIAMODE_DIGITALDATA      : result := 'DIGITALDATA';
    LINEMEDIAMODE_TELETEX          : result := 'TELETEX';
    LINEMEDIAMODE_VIDEOTEX         : result := 'VIDEOTEX';
    LINEMEDIAMODE_TELEX            : result := 'TELEX';
    LINEMEDIAMODE_MIXED            : result := 'MIXED';
    LINEMEDIAMODE_ADSI             : result := 'ADSI';
    LINEMEDIAMODE_VOICEVIEW        : result := 'VOICEVIEW';
  else
    result := Format('$%x', [MediaMode]);
  end;
end;

{*****************************************************************************}
function LineMediaModesToStr(MediaModes: DWORD; Spacer: String) : String;
{*****************************************************************************}
begin
  result := '';
  if (MediaModes and LINEMEDIAMODE_INTERACTIVEVOICE) > 0 then result := OrStr(result, 'INTERACTIVEVOICE', Spacer);
  if (MediaModes and LINEMEDIAMODE_AUTOMATEDVOICE)   > 0 then result := OrStr(result, 'AUTOMATEDVOICE', Spacer);
  if (MediaModes and LINEMEDIAMODE_DATAMODEM)        > 0 then result := OrStr(result, 'DATAMODEM', Spacer);
  if (MediaModes and LINEMEDIAMODE_G3FAX)            > 0 then result := OrStr(result, 'G3FAX', Spacer);
  if (MediaModes and LINEMEDIAMODE_TDD)              > 0 then result := OrStr(result, 'TDD', Spacer);
  if (MediaModes and LINEMEDIAMODE_G4FAX)            > 0 then result := OrStr(result, 'G4FAX', Spacer);
  if (MediaModes and LINEMEDIAMODE_DIGITALDATA)      > 0 then result := OrStr(result, 'DIGITALDATA', Spacer);
  if (MediaModes and LINEMEDIAMODE_TELETEX)          > 0 then result := OrStr(result, 'TELETEX', Spacer);
  if (MediaModes and LINEMEDIAMODE_VIDEOTEX)         > 0 then result := OrStr(result, 'VIDEOTEX', Spacer);
  if (MediaModes and LINEMEDIAMODE_TELEX)            > 0 then result := OrStr(result, 'TELEX', Spacer);
  if (MediaModes and LINEMEDIAMODE_MIXED)            > 0 then result := OrStr(result, 'MIXED', Spacer);
  if (MediaModes and LINEMEDIAMODE_ADSI)             > 0 then result := OrStr(result, 'ADSI', Spacer);
  if (MediaModes and LINEMEDIAMODE_VOICEVIEW)        > 0 then result := OrStr(result, 'VOICEVIEW', Spacer);
  if (MediaModes and LINEMEDIAMODE_UNKNOWN)          > 0 then result := OrStr(result, 'UNKNOWN', Spacer);
  if (MediaModes and LINEMEDIAMODE_VIDEO)            > 0 then result := OrStr(result, 'VIDEO', Spacer);   // TAPI v2.1
end;

{*****************************************************************************}
procedure LineMediaModesToStrList (MediaModes : DWORD; List : TStrings );
{*****************************************************************************}
begin
  List.clear;
  if (LINEMEDIAMODE_UNKNOWN          and MediaModes) > 0 then List.add( 'UNKNOWN');
  if (LINEMEDIAMODE_INTERACTIVEVOICE and MediaModes) > 0 then List.add( 'INTERACTIVEVOICE');
  if (LINEMEDIAMODE_AUTOMATEDVOICE   and MediaModes) > 0 then List.add( 'AUTOMATEDVOICE');
  if (LINEMEDIAMODE_DATAMODEM        and MediaModes) > 0 then List.add( 'DATAMODEM');
  if (LINEMEDIAMODE_G3FAX            and MediaModes) > 0 then List.add( 'G3FAX');
  if (LINEMEDIAMODE_TDD              and MediaModes) > 0 then List.add( 'TDD');
  if (LINEMEDIAMODE_G4FAX            and MediaModes) > 0 then List.add( 'G4FAX');
  if (LINEMEDIAMODE_DIGITALDATA      and MediaModes) > 0 then List.add( 'DIGITALDATA');
  if (LINEMEDIAMODE_TELETEX          and MediaModes) > 0 then List.add( 'TELETEX');
  if (LINEMEDIAMODE_VIDEOTEX         and MediaModes) > 0 then List.add( 'VIDEOTEX');
  if (LINEMEDIAMODE_TELEX            and MediaModes) > 0 then List.add( 'TELEX');
  if (LINEMEDIAMODE_MIXED            and MediaModes) > 0 then List.add( 'MIXED');
  if (LINEMEDIAMODE_ADSI             and MediaModes) > 0 then List.add( 'ADSI');
  if (LINEMEDIAMODE_VOICEVIEW        and MediaModes) > 0 then List.add( 'VOICEVIEW');
end;

{*****************************************************************************}
function StrToLineMediaMode(MediaMode: String; Default: DWORD): DWORD;
{*****************************************************************************}
begin
  if      MediaMode = 'UNKNOWN'           then result  := LINEMEDIAMODE_UNKNOWN
  else if MediaMode = 'INTERACTIVEVOICE'  then result  := LINEMEDIAMODE_INTERACTIVEVOICE
  else if MediaMode = 'AUTOMATEDVOICE'    then result  := LINEMEDIAMODE_AUTOMATEDVOICE
  else if MediaMode = 'DATAMODEM'         then result  := LINEMEDIAMODE_DATAMODEM
  else if MediaMode = 'G3FAX'             then result  := LINEMEDIAMODE_G3FAX
  else if MediaMode = 'TDD'               then result  := LINEMEDIAMODE_TDD
  else if MediaMode = 'G4FAX'             then result  := LINEMEDIAMODE_G4FAX
  else if MediaMode = 'DIGITALDATA'       then result  := LINEMEDIAMODE_DIGITALDATA
  else if MediaMode = 'TELETEX'           then result  := LINEMEDIAMODE_TELETEX
  else if MediaMode = 'VIDEOTEX'          then result  := LINEMEDIAMODE_VIDEOTEX
  else if MediaMode = 'TELEX'             then result  := LINEMEDIAMODE_TELEX
  else if MediaMode = 'MIXED'             then result  := LINEMEDIAMODE_MIXED
  else if MediaMode = 'ADSI'              then result  := LINEMEDIAMODE_ADSI
  else if MediaMode = 'VOICEVIEW'         then result  := LINEMEDIAMODE_VOICEVIEW
  else if MediaMode = 'VIDEO'             then result  := LINEMEDIAMODE_VIDEO
  else result  := Default;
end;

{ ============================================================================ }
{ L I N E B E A R E R M O D E }
{ ============================================================================ }

{*****************************************************************************}
function StrToLineBearerMode(BearerMode: string) : DWORD;
{*****************************************************************************}
begin
  if      BearerMode = 'VOICE'              then result  := LINEBEARERMODE_VOICE
  else if BearerMode = 'SPEECH'             then result  := LINEBEARERMODE_SPEECH
  else if BearerMode = 'MULTIUSE'           then result  := LINEBEARERMODE_MULTIUSE
  else if BearerMode = 'DATA'               then result  := LINEBEARERMODE_DATA
  else if BearerMode = 'ALTSPEECHDATA'      then result  := LINEBEARERMODE_ALTSPEECHDATA
  else if BearerMode = 'NONCALLSIGNALING'   then result  := LINEBEARERMODE_NONCALLSIGNALING
  else if BearerMode = 'PASSTHROUGH'        then result  := LINEBEARERMODE_PASSTHROUGH
  else result := 0;
end;

{*****************************************************************************}
function LineBearerModeToStr(BearerMode: DWORD) : String;
{*****************************************************************************}
begin
  case BearerMode of
    LINEBEARERMODE_VOICE              : result := 'VOICE';
    LINEBEARERMODE_SPEECH             : result := 'SPEECH';
    LINEBEARERMODE_MULTIUSE           : result := 'MULTIUSE';
    LINEBEARERMODE_DATA               : result := 'DATA';
    LINEBEARERMODE_ALTSPEECHDATA      : result := 'ALTSPEECHDATA';
    LINEBEARERMODE_NONCALLSIGNALING   : result := 'NONCALLSIGNALING';
    LINEBEARERMODE_PASSTHROUGH        : result := 'PASSTHROUGH';
  else
    result := Format('$%x', [BearerMode]);
  end;
end;

{*****************************************************************************}
procedure LineBearerModesToStrList(BearerModes: DWORD; List: TStrings );
{*****************************************************************************}
begin
  List.clear;
  if (LINEBEARERMODE_VOICE            and BearerModes) > 0 then List.add('VOICE');
  if (LINEBEARERMODE_SPEECH           and BearerModes) > 0 then List.add('SPEECH');
  if (LINEBEARERMODE_MULTIUSE         and BearerModes) > 0 then List.add('MULTIUSE');
  if (LINEBEARERMODE_DATA             and BearerModes) > 0 then List.add('DATA');
  if (LINEBEARERMODE_ALTSPEECHDATA    and BearerModes) > 0 then List.add('ALTSPEECHDATA');
  if (LINEBEARERMODE_NONCALLSIGNALING and BearerModes) > 0 then List.add('NONCALLSIGNALING');
  if (LINEBEARERMODE_PASSTHROUGH      and BearerModes) > 0 then List.add('PASSTHROUGH');
end;

{*****************************************************************************}
function LineBearerModesToStr(BearerModes: DWORD) : String;
{*****************************************************************************}
begin
  Result := '';
  if (LINEBEARERMODE_VOICE            and BearerModes) > 0 then Result := OrStr(Result, 'VOICE');
  if (LINEBEARERMODE_SPEECH           and BearerModes) > 0 then Result := OrStr(Result, 'SPEECH');
  if (LINEBEARERMODE_MULTIUSE         and BearerModes) > 0 then Result := OrStr(Result, 'MULTIUSE');
  if (LINEBEARERMODE_DATA             and BearerModes) > 0 then Result := OrStr(Result, 'DATA');
  if (LINEBEARERMODE_ALTSPEECHDATA    and BearerModes) > 0 then Result := OrStr(Result, 'ALTSPEECHDATA');
  if (LINEBEARERMODE_NONCALLSIGNALING and BearerModes) > 0 then Result := OrStr(Result, 'NONCALLSIGNALING');
  if (LINEBEARERMODE_PASSTHROUGH      and BearerModes) > 0 then Result := OrStr(Result, 'PASSTHROUGH');
end;

{ ============================================================================ }
{ L I N E A D D R E S S M O D E }
{ ============================================================================ }

{*****************************************************************************}
procedure LineAddressModesToStrList(AddressModes: DWORD; List : TStrings );
{*****************************************************************************}
begin
  List.clear;
  if (LINEADDRESSMODE_ADDRESSID       and AddressModes) > 0 then List.add('ADDRESSID');
  if (LINEADDRESSMODE_DIALABLEADDR    and AddressModes) > 0 then List.add('DIALABLEADDR');
end;

{*****************************************************************************}
function StrToLineAddressMode(AddressMode: String) : DWORD;
{*****************************************************************************}
begin
  if      AddressMode = 'ADDRESSID'    then result  := LINEADDRESSMODE_ADDRESSID
  else if AddressMode = 'DIALABLEADDR' then result  := LINEADDRESSMODE_DIALABLEADDR
  else result := 0;
end;

{*****************************************************************************}
function LineAddressModeToStr(AddressMode: DWORD ) : String;
{*****************************************************************************}
begin
  case AddressMode of
    LINEADDRESSMODE_ADDRESSID         : result := 'ADDRESSID';
    LINEADDRESSMODE_DIALABLEADDR      : result := 'DIALABLEADDR';
  else
    result := Format('$%x', [AddressMode]);
  end;
end;

{ ============================================================================ }
{ L I N E D I S C O N N E C T M O D E }
{ ============================================================================ }

{*****************************************************************************}
function LineDiscModeToStr(DiscMode: DWORD) : String;
{*****************************************************************************}
begin
  case DiscMode of
    LINEDISCONNECTMODE_NORMAL           :      Result := 'NORMAL';
    LINEDISCONNECTMODE_UNKNOWN          :      Result := 'UNKNOWN';
    LINEDISCONNECTMODE_REJECT           :      Result := 'REJECT';
    LINEDISCONNECTMODE_PICKUP           :      Result := 'PICKUP';
    LINEDISCONNECTMODE_FORWARDED        :      Result := 'FORWARDED';
    LINEDISCONNECTMODE_BUSY             :      Result := 'BUSY';
    LINEDISCONNECTMODE_NOANSWER         :      Result := 'NOANSWER';
    LINEDISCONNECTMODE_BADADDRESS       :      Result := 'BADADDRESS';
    LINEDISCONNECTMODE_UNREACHABLE      :      Result := 'UNREACHABLE';
    LINEDISCONNECTMODE_CONGESTION       :      Result := 'CONGESTION';
    LINEDISCONNECTMODE_INCOMPATIBLE     :      Result := 'INCOMPATIBLE';
    LINEDISCONNECTMODE_UNAVAIL          :      Result := 'UNAVAIL';
    LINEDISCONNECTMODE_NODIALTONE       :      Result := 'NODIALTONE';
    LINEDISCONNECTMODE_NUMBERCHANGED    :      Result := 'NUMBERCHANGED';
    LINEDISCONNECTMODE_OUTOFORDER       :      Result := 'OUTOFORDER';
    LINEDISCONNECTMODE_TEMPFAILURE      :      Result := 'TEMPFAILURE';
    LINEDISCONNECTMODE_QOSUNAVAIL       :      Result := 'QOSUNAVAIL';
    LINEDISCONNECTMODE_BLOCKED          :      Result := 'BLOCKED';
    LINEDISCONNECTMODE_DONOTDISTURB     :      Result := 'DONOTDISTURB';
    LINEDISCONNECTMODE_CANCELLED        :      Result := 'CANCELLED';
  else
    Result := IntToHex(DiscMode,4);
  end;
end;

{*****************************************************************************}
procedure LineDiscModesToStrList(DiscModes : DWORD; List: TStrings );
{*****************************************************************************}
begin
  List.clear;
  if (LINEDISCONNECTMODE_NORMAL        and DiscModes)  > 0 then List.add('NORMAL');
  if (LINEDISCONNECTMODE_UNKNOWN       and DiscModes)  > 0 then List.add('UNKNOWN');
  if (LINEDISCONNECTMODE_REJECT        and DiscModes)  > 0 then List.add('REJECT');
  if (LINEDISCONNECTMODE_PICKUP        and DiscModes)  > 0 then List.add('PICKUP');
  if (LINEDISCONNECTMODE_FORWARDED     and DiscModes)  > 0 then List.add('FORWARDED');
  if (LINEDISCONNECTMODE_BUSY          and DiscModes)  > 0 then List.add('BUSY');
  if (LINEDISCONNECTMODE_NOANSWER      and DiscModes)  > 0 then List.add('NOANSWER');
  if (LINEDISCONNECTMODE_BADADDRESS    and DiscModes)  > 0 then List.add('BADADDRESS');
  if (LINEDISCONNECTMODE_UNREACHABLE   and DiscModes)  > 0 then List.add('UNREACHABLE');
  if (LINEDISCONNECTMODE_CONGESTION    and DiscModes)  > 0 then List.add('CONGESTION');
  if (LINEDISCONNECTMODE_INCOMPATIBLE  and DiscModes)  > 0 then List.add('INCOMPATIBLE');
  if (LINEDISCONNECTMODE_UNAVAIL       and DiscModes)  > 0 then List.add('UNAVAIL');
  if (LINEDISCONNECTMODE_NODIALTONE    and DiscModes)  > 0 then List.add('NODIALTONE');
  if (LINEDISCONNECTMODE_NUMBERCHANGED and DiscModes)  > 0 then List.add('NUMBERCHANGED');
  if (LINEDISCONNECTMODE_OUTOFORDER    and DiscModes)  > 0 then List.add('OUTOFORDER');
  if (LINEDISCONNECTMODE_TEMPFAILURE   and DiscModes)  > 0 then List.add('TEMPFAILURE');
  if (LINEDISCONNECTMODE_QOSUNAVAIL    and DiscModes)  > 0 then List.add('QOSUNAVAIL');
  if (LINEDISCONNECTMODE_BLOCKED       and DiscModes)  > 0 then List.add('BLOCKED');
  if (LINEDISCONNECTMODE_DONOTDISTURB  and DiscModes)  > 0 then List.add('DONOTDISTURB');
  if (LINEDISCONNECTMODE_CANCELLED     and DiscModes)  > 0 then List.add('CANCELLED');
end;



{ ============================================================================ }
{ L i n e D i g i t M o d e }
{ ============================================================================ }

{*****************************************************************************}
function LineDigitModeToStr(DigitMode: DWORD): String;
{*****************************************************************************}
begin
  case DigitMode of
    LINEDIGITMODE_DTMF    : result := 'DTMF';
    LINEDIGITMODE_DTMFEND : result := 'DTMFEND';
    LINEDIGITMODE_PULSE   : result := 'PULSE';
  else
    result := Format('$%x',[DigitMode]);
  end;
end;

{*****************************************************************************}
procedure LineDigitModesToStrList(DigitMode: DWORD; List: TStrings);
{*****************************************************************************}
begin
  List.Clear;
  if (DigitMode and LINEDIGITMODE_DTMF   ) > 0 then List.Add('DTMF');
  if (DigitMode and LINEDIGITMODE_DTMFEND) > 0 then List.Add('DTMFEND');
  if (DigitMode and LINEDIGITMODE_PULSE  ) > 0 then List.Add('PULSE');
end;

{*****************************************************************************}
function StrToLineDigitMode(DigitMode: String; Default: DWORD=0): DWORD;
{*****************************************************************************}
begin
  if      DigitMode = 'DTMF'    then result  := LINEDIGITMODE_DTMF
  else if DigitMode = 'DTMFEND' then result  := LINEDIGITMODE_DTMFEND
  else if DigitMode = 'PULSE'   then result  := LINEDIGITMODE_PULSE
  else result := Default;
end;

{ ============================================================================ }
{ P H O N E P R I V I L E G E S }
{ ============================================================================ }

{*****************************************************************************}
function PhonePrivilegesToStr(const Value : DWORD; Spacer: String) : string;
{*****************************************************************************}
begin
  result := '';
  if (value and PHONEPRIVILEGE_OWNER)   > 0 then result := OrStr(result, 'OWNER',   Spacer);
  if (value and PHONEPRIVILEGE_MONITOR) > 0 then result := Orstr(result, 'MONITOR', Spacer);
end;

{ ============================================================================ }
{ P H O N E L A M P M O D E }
{ ============================================================================ }

{*****************************************************************************}
function PhoneLampModeToStr(LampMode: DWORD): String;
{*****************************************************************************}
begin
  case LampMode of
    PHONELAMPMODE_DUMMY                     : result := 'DUMMY';
    PHONELAMPMODE_OFF                       : result := 'OFF';
    PHONELAMPMODE_STEADY                    : result := 'STEADY';
    PHONELAMPMODE_WINK                      : result := 'WINK';
    PHONELAMPMODE_FLASH                     : result := 'FLASH';
    PHONELAMPMODE_FLUTTER                   : result := 'FLUTTER';
    PHONELAMPMODE_BROKENFLUTTER             : result := 'BROKENFLUTTER';
    PHONELAMPMODE_UNKNOWN                   : result := 'UNKNOWN';
  else
    result := Format('$%x', [LampMode]);
  end;
end;

{ ============================================================================ }
{ P H O N E B U T T O N S T A T E }
{ ============================================================================ }

{*****************************************************************************}
function PhoneButtonStateToStr(ButtonState: DWORD): String;
{*****************************************************************************}
begin
  case ButtonState of
    PHONEBUTTONSTATE_UP                     : result := 'UP';
    PHONEBUTTONSTATE_DOWN                   : result := 'DOWN';
    PHONEBUTTONSTATE_UNKNOWN                : result := 'UNKNOWN';
    PHONEBUTTONSTATE_UNAVAIL                : result := 'UNAVAIL';
  else
    result := Format('$%x', [ButtonState]);
  end;
end;

{ ============================================================================ }
{ P H O N E B U T T O N M O D E }
{ ============================================================================ }

{*****************************************************************************}
function PhoneButtonModeToStr(ButtonMode: DWORD): String;
{*****************************************************************************}
begin
  case ButtonMode of
    PHONEBUTTONMODE_DUMMY                   : result := 'DUMMY';
    PHONEBUTTONMODE_CALL                    : result := 'CALL';
    PHONEBUTTONMODE_FEATURE                 : result := 'FEATURE';
    PHONEBUTTONMODE_KEYPAD                  : result := 'KEYPAD';
    PHONEBUTTONMODE_LOCAL                   : result := 'LOCAL';
    PHONEBUTTONMODE_DISPLAY                 : result := 'DISPLAY';
  else
    result := Format('$%x', [ButtonMode]);
  end;
end;

{ ============================================================================ }
{ P H O N E B U T T O N F U N C T I O N }
{ ============================================================================ }

{*****************************************************************************}
function PhoneButtonFunctionToStr(ButonFunction: DWORD): String;
{*****************************************************************************}
begin
  case ButonFunction of
    PHONEBUTTONFUNCTION_UNKNOWN             : result := 'UNKNOWN';
    PHONEBUTTONFUNCTION_CONFERENCE          : result := 'CONFERENCE';
    PHONEBUTTONFUNCTION_TRANSFER            : result := 'TRANSFER';
    PHONEBUTTONFUNCTION_DROP                : result := 'DROP';
    PHONEBUTTONFUNCTION_HOLD                : result := 'HOLD';
    PHONEBUTTONFUNCTION_RECALL              : result := 'RECALL';
    PHONEBUTTONFUNCTION_DISCONNECT          : result := 'DISCONNECT';
    PHONEBUTTONFUNCTION_CONNECT             : result := 'CONNECT';
    PHONEBUTTONFUNCTION_MSGWAITON           : result := 'MSGWAITON';
    PHONEBUTTONFUNCTION_MSGWAITOFF          : result := 'MSGWAITOFF';
    PHONEBUTTONFUNCTION_SELECTRING          : result := 'SELECTRING';
    PHONEBUTTONFUNCTION_ABBREVDIAL          : result := 'ABBREVDIAL';
    PHONEBUTTONFUNCTION_FORWARD             : result := 'FORWARD';
    PHONEBUTTONFUNCTION_PICKUP              : result := 'PICKUP';
    PHONEBUTTONFUNCTION_RINGAGAIN           : result := 'RINGAGAIN';
    PHONEBUTTONFUNCTION_PARK                : result := 'PARK';
    PHONEBUTTONFUNCTION_REJECT              : result := 'REJECT';
    PHONEBUTTONFUNCTION_REDIRECT            : result := 'REDIRECT';
    PHONEBUTTONFUNCTION_MUTE                : result := 'MUTE';
    PHONEBUTTONFUNCTION_VOLUMEUP            : result := 'VOLUMEUP';
    PHONEBUTTONFUNCTION_VOLUMEDOWN          : result := 'VOLUMEDOWN';
    PHONEBUTTONFUNCTION_SPEAKERON           : result := 'SPEAKERON';
    PHONEBUTTONFUNCTION_SPEAKEROFF          : result := 'SPEAKEROFF';
    PHONEBUTTONFUNCTION_FLASH               : result := 'FLASH';
    PHONEBUTTONFUNCTION_DATAON              : result := 'DATAON';
    PHONEBUTTONFUNCTION_DATAOFF             : result := 'DATAOFF';
    PHONEBUTTONFUNCTION_DONOTDISTURB        : result := 'DONOTDISTURB';
    PHONEBUTTONFUNCTION_INTERCOM            : result := 'INTERCOM';
    PHONEBUTTONFUNCTION_BRIDGEDAPP          : result := 'BRIDGEDAPP';
    PHONEBUTTONFUNCTION_BUSY                : result := 'BUSY';
    PHONEBUTTONFUNCTION_CALLAPP             : result := 'CALLAPP';
    PHONEBUTTONFUNCTION_DATETIME            : result := 'DATETIME';
    PHONEBUTTONFUNCTION_DIRECTORY           : result := 'DIRECTORY';
    PHONEBUTTONFUNCTION_COVER               : result := 'COVER';
    PHONEBUTTONFUNCTION_CALLID              : result := 'CALLID';
    PHONEBUTTONFUNCTION_LASTNUM             : result := 'LASTNUM';
    PHONEBUTTONFUNCTION_NIGHTSRV            : result := 'NIGHTSRV';
    PHONEBUTTONFUNCTION_SENDCALLS           : result := 'SENDCALLS';
    PHONEBUTTONFUNCTION_MSGINDICATOR        : result := 'MSGINDICATOR';
    PHONEBUTTONFUNCTION_REPDIAL             : result := 'REPDIAL';
    PHONEBUTTONFUNCTION_SETREPDIAL          : result := 'SETREPDIAL';
    PHONEBUTTONFUNCTION_SYSTEMSPEED         : result := 'SYSTEMSPEED';
    PHONEBUTTONFUNCTION_STATIONSPEED        : result := 'STATIONSPEED';
    PHONEBUTTONFUNCTION_CAMPON              : result := 'CAMPON';
    PHONEBUTTONFUNCTION_SAVEREPEAT          : result := 'SAVEREPEAT';
    PHONEBUTTONFUNCTION_QUEUECALL           : result := 'QUEUECALL';
    PHONEBUTTONFUNCTION_NONE                : result := 'NONE';
  else
    result := Format('$%x', [ButonFunction]);
  end;
end;

{ ============================================================================ }
{ L I N E _ M E S S A G E S                                                    }
{ ============================================================================ }

{*****************************************************************************}
function MessageIDToStr(MessageID: DWORD) : String;
{*****************************************************************************}
begin
  case MessageID of
    LINE_ADDRESSSTATE        : result := 'LINE_ADDRESSSTATE';
    LINE_CALLINFO            : result := 'LINE_CALLINFO';
    LINE_CALLSTATE           : result := 'LINE_CALLSTATE';
    LINE_CLOSE               : result := 'LINE_CLOSE';
    LINE_DEVSPECIFIC         : result := 'LINE_DEVSPECIFIC';
    LINE_DEVSPECIFICFEATURE  : result := 'LINE_DEVSPECIFICFEATURE';
    LINE_GATHERDIGITS        : result := 'LINE_GATHERDIGITS';
    LINE_GENERATE            : result := 'LINE_GENERATE';
    LINE_LINEDEVSTATE        : result := 'LINE_LINEDEVSTATE';
    LINE_MONITORDIGITS       : result := 'LINE_MONITORDIGITS';
    LINE_MONITORMEDIA        : result := 'LINE_MONITORMEDIA';
    LINE_MONITORTONE         : result := 'LINE_MONITORTONE';
    LINE_REPLY               : result := 'LINE_REPLY';
    LINE_REQUEST             : result := 'LINE_REQUEST';
    PHONE_BUTTON             : result := 'PHONE_BUTTON';
    PHONE_CLOSE              : result := 'PHONE_CLOSE';
    PHONE_DEVSPECIFIC        : result := 'PHONE_DEVSPECIFIC';
    PHONE_REPLY              : result := 'PHONE_REPLY';
    PHONE_STATE              : result := 'PHONE_STATE';
    LINE_CREATE              : result := 'LINE_CREATE';
    PHONE_CREATE             : result := 'PHONE_CREATE';

    LINE_AGENTSPECIFIC       : result := 'LINE_AGENTSPECIFIC';
    LINE_AGENTSTATUS         : result := 'LINE_AGENTSTATUS';
    LINE_APPNEWCALL          : result := 'LINE_APPNEWCALL';
    LINE_PROXYREQUEST        : result := 'LINE_PROXYREQUEST';
    LINE_REMOVE              : result := 'LINE_REMOVE';
    PHONE_REMOVE             : result := 'PHONE_REMOVE';
  else
    result := Format('x%x', [MessageID]);
  end;
end;

{ ============================================================================ }
{ L I N E E R R _                                                              }
{ ============================================================================ }

{*****************************************************************************}
function LineErrToStr(LineError: DWORD) : String;
{*****************************************************************************}
begin
  case LineError of
    LINEERR_ALLOCATED                   : result := 'ALLOCATED';
    LINEERR_BADDEVICEID                 : result := 'BADDEVICEID';
    LINEERR_BEARERMODEUNAVAIL           : result := 'BEARERMODEUNAVAIL';
    LINEERR_CALLUNAVAIL                 : result := 'CALLUNAVAIL';
    LINEERR_COMPLETIONOVERRUN           : result := 'COMPLETIONOVERRUN';
    LINEERR_CONFERENCEFULL              : result := 'CONFERENCEFULL';
    LINEERR_DIALBILLING                 : result := 'DIALBILLING';
    LINEERR_DIALDIALTONE                : result := 'DIALDIALTONE';
    LINEERR_DIALPROMPT                  : result := 'DIALPROMPT';
    LINEERR_DIALQUIET                   : result := 'DIALQUIET';
    LINEERR_INCOMPATIBLEAPIVERSION      : result := 'INCOMPATIBLEAPIVERSION';
    LINEERR_INCOMPATIBLEEXTVERSION      : result := 'INCOMPATIBLEEXTVERSION';
    LINEERR_INIFILECORRUPT              : result := 'INIFILECORRUPT';
    LINEERR_INUSE                       : result := 'INUSE';
    LINEERR_INVALADDRESS                : result := 'INVALADDRESS';
    LINEERR_INVALADDRESSID              : result := 'INVALADDRESSID';
    LINEERR_INVALADDRESSMODE            : result := 'INVALADDRESSMODE';
    LINEERR_INVALADDRESSSTATE           : result := 'INVALADDRESSSTATE';
    LINEERR_INVALAPPHANDLE              : result := 'INVALAPPHANDLE';
    LINEERR_INVALAPPNAME                : result := 'INVALAPPNAME';
    LINEERR_INVALBEARERMODE             : result := 'INVALBEARERMODE';
    LINEERR_INVALCALLCOMPLMODE          : result := 'INVALCALLCOMPLMODE';
    LINEERR_INVALCALLHANDLE             : result := 'INVALCALLHANDLE';
    LINEERR_INVALCALLPARAMS             : result := 'INVALCALLPARAMS';
    LINEERR_INVALCALLPRIVILEGE          : result := 'INVALCALLPRIVILEGE';
    LINEERR_INVALCALLSELECT             : result := 'INVALCALLSELECT';
    LINEERR_INVALCALLSTATE              : result := 'INVALCALLSTATE';
    LINEERR_INVALCALLSTATELIST          : result := 'INVALCALLSTATELIST';
    LINEERR_INVALCARD                   : result := 'INVALCARD';
    LINEERR_INVALCOMPLETIONID           : result := 'INVALCOMPLETIONID';
    LINEERR_INVALCONFCALLHANDLE         : result := 'INVALCONFCALLHANDLE';
    LINEERR_INVALCONSULTCALLHANDLE      : result := 'INVALCONSULTCALLHANDLE';
    LINEERR_INVALCOUNTRYCODE            : result := 'INVALCOUNTRYCODE';
    LINEERR_INVALDEVICECLASS            : result := 'INVALDEVICECLASS';
    LINEERR_INVALDEVICEHANDLE           : result := 'INVALDEVICEHANDLE';
    LINEERR_INVALDIALPARAMS             : result := 'INVALDIALPARAMS';
    LINEERR_INVALDIGITLIST              : result := 'INVALDIGITLIST';
    LINEERR_INVALDIGITMODE              : result := 'INVALDIGITMODE';
    LINEERR_INVALDIGITS                 : result := 'INVALDIGITS';
    LINEERR_INVALEXTVERSION             : result := 'INVALEXTVERSION';
    LINEERR_INVALGROUPID                : result := 'INVALGROUPID';
    LINEERR_INVALLINEHANDLE             : result := 'INVALLINEHANDLE';
    LINEERR_INVALLINESTATE              : result := 'INVALLINESTATE';
    LINEERR_INVALLOCATION               : result := 'INVALLOCATION';
    LINEERR_INVALMEDIALIST              : result := 'INVALMEDIALIST';
    LINEERR_INVALMEDIAMODE              : result := 'INVALMEDIAMODE';
    LINEERR_INVALMESSAGEID              : result := 'INVALMESSAGEID';
    LINEERR_INVALPARAM                  : result := 'INVALPARAM';
    LINEERR_INVALPARKID                 : result := 'INVALPARKID';
    LINEERR_INVALPARKMODE               : result := 'INVALPARKMODE';
    LINEERR_INVALPOINTER                : result := 'INVALPOINTER';
    LINEERR_INVALPRIVSELECT             : result := 'INVALPRIVSELECT';
    LINEERR_INVALRATE                   : result := 'INVALRATE';
    LINEERR_INVALREQUESTMODE            : result := 'INVALREQUESTMODE';
    LINEERR_INVALTERMINALID             : result := 'INVALTERMINALID';
    LINEERR_INVALTERMINALMODE           : result := 'INVALTERMINALMODE';
    LINEERR_INVALTIMEOUT                : result := 'INVALTIMEOUT';
    LINEERR_INVALTONE                   : result := 'INVALTONE';
    LINEERR_INVALTONELIST               : result := 'INVALTONELIST';
    LINEERR_INVALTONEMODE               : result := 'INVALTONEMODE';
    LINEERR_INVALTRANSFERMODE           : result := 'INVALTRANSFERMODE';
    LINEERR_LINEMAPPERFAILED            : result := 'LINEMAPPERFAILED';
    LINEERR_NOCONFERENCE                : result := 'NOCONFERENCE';
    LINEERR_NODEVICE                    : result := 'NODEVICE';
    LINEERR_NODRIVER                    : result := 'NODRIVER';
    LINEERR_NOMEM                       : result := 'NOMEM';
    LINEERR_NOREQUEST                   : result := 'NOREQUEST';
    LINEERR_NOTOWNER                    : result := 'NOTOWNER';
    LINEERR_NOTREGISTERED               : result := 'NOTREGISTERED';
    LINEERR_OPERATIONFAILED             : result := 'OPERATIONFAILED';
    LINEERR_OPERATIONUNAVAIL            : result := 'OPERATIONUNAVAIL';
    LINEERR_RATEUNAVAIL                 : result := 'RATEUNAVAIL';
    LINEERR_RESOURCEUNAVAIL             : result := 'RESOURCEUNAVAIL';
    LINEERR_REQUESTOVERRUN              : result := 'REQUESTOVERRUN';
    LINEERR_STRUCTURETOOSMALL           : result := 'STRUCTURETOOSMALL';
    LINEERR_TARGETNOTFOUND              : result := 'TARGETNOTFOUND';
    LINEERR_TARGETSELF                  : result := 'TARGETSELF';
    LINEERR_UNINITIALIZED               : result := 'UNINITIALIZED';
    LINEERR_USERUSERINFOTOOBIG          : result := 'USERUSERINFOTOOBIG';
    LINEERR_REINIT                      : result := 'REINIT';
    LINEERR_ADDRESSBLOCKED              : result := 'ADDRESSBLOCKED';
    LINEERR_BILLINGREJECTED             : result := 'BILLINGREJECTED';
    LINEERR_INVALFEATURE                : result := 'INVALFEATURE';
    LINEERR_NOMULTIPLEINSTANCE          : result := 'NOMULTIPLEINSTANCE';
  else
    result := Format('$%x', [LineError]);
  end;
end;


end.

