{******************************************************************}
{                                                                  }
{       Borland Delphi Runtime Library                             }
{       Telephony API interface unit                               }
{                                                                  }
{ Portions created by Microsoft are                                }
{ Copyright (C) 1995-1999 Microsoft Corporation.                   }
{ All Rights Reserved.                                             }
{                                                                  }
{ The original file is: tapi.h, released  March 1999.              }
{ The original Pascal code is: Tapi.pas, released 28 Dec 1999.     }
{ The initial developer of the Pascal code is Marcel van Brakel    }
{ (brakelm@chello.nl).                                             }
{ 								   }
{ Portions created by Marcel van Brakel are			   }
{ Copyright (C) 1999-2000 Marcel van Brakel.   			   }
{                                                                  }
{ Contributor(s): Alan C. Moore (ACMDOC@aol.com)                   }
{                 Rudy Velthuis (rvelthuis@gmx.de)                 }
{                                                                  }
{ Obtained through:                                                }
{ Joint Endeavour of Delphi Innovators (Project JEDI)              }
{                                                                  }
{ You may retrieve the latest version of this file at the Project  }
{ JEDI home page, located at http://delphi-jedi.org                }
{                                                                  }
{ The contents of this file are used with permission, subject to   }
{ the Mozilla Public License Version 1.1 (the "License"); you may  }
{ not use this file except in compliance with the License. You may }
{ obtain a copy of the License at                                  }
{ http://www.mozilla.org/NPL/NPL-1_1Final.html                     }
{                                                                  }
{ Software distributed under the License is distributed on an      }
{ "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or   }
{ implied. See the License for the specific language governing     }
{ rights and limitations under the License.                        }
{                                                                  }
{******************************************************************}

unit Tapi;

{$WEAKPACKAGEUNIT}

interface

{$HPPEMIT '//  -- TAPI VERSION INFO -- TAPI VERSION INFO --'}
{$HPPEMIT '//  -- TAPI VERSION INFO -- TAPI VERSION INFO --'}
{$HPPEMIT '//  -- TAPI VERSION INFO -- TAPI VERSION INFO --'}
{$HPPEMIT '//'}
{$HPPEMIT '// To build  a TAPI 1.4 application put a define as below in your'}
{$HPPEMIT '// source file before you include TAPI.H:'}
{$HPPEMIT '//'}
{$HPPEMIT '// #define TAPI_CURRENT_VERSION 0x00010004'}
{$HPPEMIT '//'}
{$HPPEMIT '//'}
{$HPPEMIT '#ifndef TAPI_CURRENT_VERSION'}
{$HPPEMIT '#define TAPI_CURRENT_VERSION 0x00020002'}
{$HPPEMIT '#endif'}

{$HPPEMIT '#include <windows.h>'}

{$HPPEMIT '#pragma pack(1)'}

uses
  Windows, Messages;

// The  Telephony  API  is jointly copyrighted by Intel and Microsoft.  You are
// granted  a royalty free worldwide, unlimited license to make copies, and use
// the   API/SPI  for  making  applications/drivers  that  interface  with  the
// specification provided that this paragraph and the Intel/Microsoft copyright
// statement is maintained as is in the text and source code files.
//
// Copyright 1995-97 Microsoft, all rights reserved.
// Portions copyright 1992, 1993 Intel/Microsoft, all rights reserved.

{$INCLUDE TAPI.INC}

{$IFNDEF _WIN64}
type
  DWORD_PTR = DWORD;
{$ENDIF}

// TAPI type definitions

type
  PHCALL = ^HCALL;
  HCALL = DWORD;
  {$EXTERNALSYM HCALL}

{$IFDEF TAPI30}
  PHCALLHUB = ^HCALLHUB;
  HCALLHUB = DWORD;
  {$EXTERNALSYM HCALLHUB}
{$ENDIF}

  PHLINE = ^HLINE;
  HLINE = DWORD;
  {$EXTERNALSYM HLINE}

  PHPHONE = ^HPHONE;
  HPHONE = DWORD;
  {$EXTERNALSYM HPHONE}

  PHLINEAPP = ^HLINEAPP;
  HLINEAPP = DWORD;
  {$EXTERNALSYM HLINEAPP}

  PHPHONEAPP = ^HPHONEAPP;
  HPHONEAPP = DWORD;
  {$EXTERNALSYM HPHONEAPP}

{$IFDEF TAPI20}
  PHAGENTSESSION = ^HAGENTSESSION;                              // TAPI v2.2
  HAGENTSESSION = DWORD;                                        // TAPI v2.2
  {$EXTERNALSYM HAGENTSESSION}

  PHAGENT = ^HAGENT;                                            // TAPI v2.2
  HAGENT = DWORD;                                               // TAPI v2.2
  {$EXTERNALSYM HAGENT}
{$ENDIF}

{$IFDEF TAPI30}
  PHPRIVATECHANNEL = ^HPRIVATECHANNEL;                          // TAPI v3.0
  HPRIVATECHANNEL = DWORD;                                      // TAPI v3.0
  {$EXTERNALSYM HPRIVATECHANNEL}
{$ENDIF}

  LPHICON = ^HICON;
  {$EXTERNALSYM LPHICON}
  PHICON = LPHICON;
  
  TLineCallback = procedure(hDevice, dwMessage: DWORD; dwInstance, dwParam1,
    dwParam2, dwParam3: DWORD_PTR) stdcall;
  LINECALLBACK = TLineCallback;
  {$EXTERNALSYM LINECALLBACK}

  TPhoneCallback = procedure(hDevice, dwMessage: DWORD; dwInstance, dwParam1,
    dwParam2, dwParam3: DWORD_PTR) stdcall;
  PHONECALLBACK = TPhoneCallback;
  {$EXTERNALSYM PHONECALLBACK}

// Messages for Phones and Lines

const
  LINE_ADDRESSSTATE                       = 0;
  {$EXTERNALSYM LINE_ADDRESSSTATE}
  LINE_CALLINFO                           = 1;
  {$EXTERNALSYM LINE_CALLINFO}
  LINE_CALLSTATE                          = 2;
  {$EXTERNALSYM LINE_CALLSTATE}
  LINE_CLOSE                              = 3;
  {$EXTERNALSYM LINE_CLOSE}
  LINE_DEVSPECIFIC                        = 4;
  {$EXTERNALSYM LINE_DEVSPECIFIC}
  LINE_DEVSPECIFICFEATURE                 = 5;
  {$EXTERNALSYM LINE_DEVSPECIFICFEATURE}
  LINE_GATHERDIGITS                       = 6;
  {$EXTERNALSYM LINE_GATHERDIGITS}
  LINE_GENERATE                           = 7;
  {$EXTERNALSYM LINE_GENERATE}
  LINE_LINEDEVSTATE                       = 8;
  {$EXTERNALSYM LINE_LINEDEVSTATE}
  LINE_MONITORDIGITS                      = 9;
  {$EXTERNALSYM LINE_MONITORDIGITS}
  LINE_MONITORMEDIA                       = 10;
  {$EXTERNALSYM LINE_MONITORMEDIA}
  LINE_MONITORTONE                        = 11;
  {$EXTERNALSYM LINE_MONITORTONE}
  LINE_REPLY                              = 12;
  {$EXTERNALSYM LINE_REPLY}
  LINE_REQUEST                            = 13;
  {$EXTERNALSYM LINE_REQUEST}
  PHONE_BUTTON                            = 14;
  {$EXTERNALSYM PHONE_BUTTON}
  PHONE_CLOSE                             = 15;
  {$EXTERNALSYM PHONE_CLOSE}
  PHONE_DEVSPECIFIC                       = 16;
  {$EXTERNALSYM PHONE_DEVSPECIFIC}
  PHONE_REPLY                             = 17;
  {$EXTERNALSYM PHONE_REPLY}
  PHONE_STATE                             = 18;
  {$EXTERNALSYM PHONE_STATE}
  LINE_CREATE                             = 19;            // TAPI v1.4
  {$EXTERNALSYM LINE_CREATE}
  PHONE_CREATE                            = 20;            // TAPI v1.4
  {$EXTERNALSYM PHONE_CREATE}

{$IFDEF TAPI20}
  LINE_AGENTSPECIFIC                      = 21;            // TAPI v2.0
  {$EXTERNALSYM LINE_AGENTSPECIFIC}
  LINE_AGENTSTATUS                        = 22;            // TAPI v2.0
  {$EXTERNALSYM LINE_AGENTSTATUS}
  LINE_APPNEWCALL                         = 23;            // TAPI v2.0
  {$EXTERNALSYM LINE_APPNEWCALL}
  LINE_PROXYREQUEST                       = 24;            // TAPI v2.0
  {$EXTERNALSYM LINE_PROXYREQUEST}
  LINE_REMOVE                             = 25;            // TAPI v2.0
  {$EXTERNALSYM LINE_REMOVE}
  PHONE_REMOVE                            = 26;            // TAPI v2.0
  {$EXTERNALSYM PHONE_REMOVE}
{$ENDIF}

{$IFDEF TAPI22}
  LINE_AGENTSESSIONSTATUS                 = 27;             // TAPI v2.2
  {$EXTERNALSYM LINE_AGENTSESSIONSTATUS}
  LINE_QUEUESTATUS                        = 28;             // TAPI v2.2
  {$EXTERNALSYM LINE_QUEUESTATUS}
  LINE_AGENTSTATUSEX                      = 29;             // TAPI v2.2
  {$EXTERNALSYM LINE_AGENTSTATUSEX}
  LINE_GROUPSTATUS                        = 30;             // TAPI v2.2
  {$EXTERNALSYM LINE_GROUPSTATUS}
  LINE_PROXYSTATUS                        = 31;             // TAPI v2.2
  {$EXTERNALSYM LINE_PROXYSTATUS}
{$ENDIF}

{$IFDEF TAPI30}
  LINE_APPNEWCALLHUB                      = 32;             // TAPI v3.0
  {$EXTERNALSYM LINE_APPNEWCALLHUB}
  LINE_CALLHUBCLOSE                       = 33;             // TAPI v3.0
  {$EXTERNALSYM LINE_CALLHUBCLOSE}
  LINE_DEVSPECIFICEX                      = 34;             // TAPI v3.0
  {$EXTERNALSYM LINE_DEVSPECIFICEX}
{$ENDIF}

  INITIALIZE_NEGOTIATION                  = DWORD($FFFFFFFF);
  {$EXTERNALSYM INITIALIZE_NEGOTIATION}

  LINEADDRCAPFLAGS_FWDNUMRINGS            = $00000001;
  {$EXTERNALSYM LINEADDRCAPFLAGS_FWDNUMRINGS}
  LINEADDRCAPFLAGS_PICKUPGROUPID          = $00000002;
  {$EXTERNALSYM LINEADDRCAPFLAGS_PICKUPGROUPID}
  LINEADDRCAPFLAGS_SECURE                 = $00000004;
  {$EXTERNALSYM LINEADDRCAPFLAGS_SECURE}
  LINEADDRCAPFLAGS_BLOCKIDDEFAULT         = $00000008;
  {$EXTERNALSYM LINEADDRCAPFLAGS_BLOCKIDDEFAULT}
  LINEADDRCAPFLAGS_BLOCKIDOVERRIDE        = $00000010;
  {$EXTERNALSYM LINEADDRCAPFLAGS_BLOCKIDOVERRIDE}
  LINEADDRCAPFLAGS_DIALED                 = $00000020;
  {$EXTERNALSYM LINEADDRCAPFLAGS_DIALED}
  LINEADDRCAPFLAGS_ORIGOFFHOOK            = $00000040;
  {$EXTERNALSYM LINEADDRCAPFLAGS_ORIGOFFHOOK}
  LINEADDRCAPFLAGS_DESTOFFHOOK            = $00000080;
  {$EXTERNALSYM LINEADDRCAPFLAGS_DESTOFFHOOK}
  LINEADDRCAPFLAGS_FWDCONSULT             = $00000100;
  {$EXTERNALSYM LINEADDRCAPFLAGS_FWDCONSULT}
  LINEADDRCAPFLAGS_SETUPCONFNULL          = $00000200;
  {$EXTERNALSYM LINEADDRCAPFLAGS_SETUPCONFNULL}
  LINEADDRCAPFLAGS_AUTORECONNECT          = $00000400;
  {$EXTERNALSYM LINEADDRCAPFLAGS_AUTORECONNECT}
  LINEADDRCAPFLAGS_COMPLETIONID           = $00000800;
  {$EXTERNALSYM LINEADDRCAPFLAGS_COMPLETIONID}
  LINEADDRCAPFLAGS_TRANSFERHELD           = $00001000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_TRANSFERHELD}
  LINEADDRCAPFLAGS_TRANSFERMAKE           = $00002000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_TRANSFERMAKE}
  LINEADDRCAPFLAGS_CONFERENCEHELD         = $00004000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_CONFERENCEHELD}
  LINEADDRCAPFLAGS_CONFERENCEMAKE         = $00008000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_CONFERENCEMAKE}
  LINEADDRCAPFLAGS_PARTIALDIAL            = $00010000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_PARTIALDIAL}
  LINEADDRCAPFLAGS_FWDSTATUSVALID         = $00020000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_FWDSTATUSVALID}
  LINEADDRCAPFLAGS_FWDINTEXTADDR          = $00040000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_FWDINTEXTADDR}
  LINEADDRCAPFLAGS_FWDBUSYNAADDR          = $00080000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_FWDBUSYNAADDR}
  LINEADDRCAPFLAGS_ACCEPTTOALERT          = $00100000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_ACCEPTTOALERT}
  LINEADDRCAPFLAGS_CONFDROP               = $00200000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_CONFDROP}
  LINEADDRCAPFLAGS_PICKUPCALLWAIT         = $00400000;
  {$EXTERNALSYM LINEADDRCAPFLAGS_PICKUPCALLWAIT}
{$IFDEF TAPI20}
  LINEADDRCAPFLAGS_PREDICTIVEDIALER       = $00800000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_PREDICTIVEDIALER}
  LINEADDRCAPFLAGS_QUEUE                  = $01000000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_QUEUE}
  LINEADDRCAPFLAGS_ROUTEPOINT             = $02000000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_ROUTEPOINT}
  LINEADDRCAPFLAGS_HOLDMAKESNEW           = $04000000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_HOLDMAKESNEW}
  LINEADDRCAPFLAGS_NOINTERNALCALLS        = $08000000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_NOINTERNALCALLS}
  LINEADDRCAPFLAGS_NOEXTERNALCALLS        = $10000000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_NOEXTERNALCALLS}
  LINEADDRCAPFLAGS_SETCALLINGID           = $20000000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_SETCALLINGID}
{$ENDIF}
{$IFDEF TAPI22}
  LINEADDRCAPFLAGS_ACDGROUP               = $40000000;     // TAPI v2.2
  {$EXTERNALSYM LINEADDRCAPFLAGS_ACDGROUP}
{$ENDIF}
{$IFDEF TAPI30}
  LINEADDRCAPFLAGS_NOPSTNADDRESSTRANSLATION = DWORD($80000000); // TAPI v3.0
  {$EXTERNALSYM LINEADDRCAPFLAGS_NOPSTNADDRESSTRANSLATION}
{$ENDIF}


  LINEADDRESSMODE_ADDRESSID               = $00000001;
  {$EXTERNALSYM LINEADDRESSMODE_ADDRESSID}
  LINEADDRESSMODE_DIALABLEADDR            = $00000002;
  {$EXTERNALSYM LINEADDRESSMODE_DIALABLEADDR}

  LINEADDRESSSHARING_PRIVATE              = $00000001;
  {$EXTERNALSYM LINEADDRESSSHARING_PRIVATE}
  LINEADDRESSSHARING_BRIDGEDEXCL          = $00000002;
  {$EXTERNALSYM LINEADDRESSSHARING_BRIDGEDEXCL}
  LINEADDRESSSHARING_BRIDGEDNEW           = $00000004;
  {$EXTERNALSYM LINEADDRESSSHARING_BRIDGEDNEW}
  LINEADDRESSSHARING_BRIDGEDSHARED        = $00000008;
  {$EXTERNALSYM LINEADDRESSSHARING_BRIDGEDSHARED}
  LINEADDRESSSHARING_MONITORED            = $00000010;
  {$EXTERNALSYM LINEADDRESSSHARING_MONITORED}

  LINEADDRESSSTATE_OTHER                  = $00000001;
  {$EXTERNALSYM LINEADDRESSSTATE_OTHER}
  LINEADDRESSSTATE_DEVSPECIFIC            = $00000002;
  {$EXTERNALSYM LINEADDRESSSTATE_DEVSPECIFIC}
  LINEADDRESSSTATE_INUSEZERO              = $00000004;
  {$EXTERNALSYM LINEADDRESSSTATE_INUSEZERO}
  LINEADDRESSSTATE_INUSEONE               = $00000008;
  {$EXTERNALSYM LINEADDRESSSTATE_INUSEONE}
  LINEADDRESSSTATE_INUSEMANY              = $00000010;
  {$EXTERNALSYM LINEADDRESSSTATE_INUSEMANY}
  LINEADDRESSSTATE_NUMCALLS               = $00000020;
  {$EXTERNALSYM LINEADDRESSSTATE_NUMCALLS}
  LINEADDRESSSTATE_FORWARD                = $00000040;
  {$EXTERNALSYM LINEADDRESSSTATE_FORWARD}
  LINEADDRESSSTATE_TERMINALS              = $00000080;
  {$EXTERNALSYM LINEADDRESSSTATE_TERMINALS}
  LINEADDRESSSTATE_CAPSCHANGE             = $00000100;     // TAPI v1.4
  {$EXTERNALSYM LINEADDRESSSTATE_CAPSCHANGE}

{$IFDEF TAPI30}
  LINEADDRESSTYPE_PHONENUMBER             = $00000001;
  LINEADDRESSTYPE_SDP                     = $00000002;
  LINEADDRESSTYPE_EMAILNAME               = $00000004;
  LINEADDRESSTYPE_DOMAINNAME              = $00000008;
  LINEADDRESSTYPE_IPADDRESS               = $00000010;
{$ENDIF}

  LINEADDRFEATURE_FORWARD                 = $00000001;
  {$EXTERNALSYM LINEADDRFEATURE_FORWARD}
  LINEADDRFEATURE_MAKECALL                = $00000002;
  {$EXTERNALSYM LINEADDRFEATURE_MAKECALL}
  LINEADDRFEATURE_PICKUP                  = $00000004;
  {$EXTERNALSYM LINEADDRFEATURE_PICKUP}
  LINEADDRFEATURE_SETMEDIACONTROL         = $00000008;
  {$EXTERNALSYM LINEADDRFEATURE_SETMEDIACONTROL}
  LINEADDRFEATURE_SETTERMINAL             = $00000010;
  {$EXTERNALSYM LINEADDRFEATURE_SETTERMINAL}
  LINEADDRFEATURE_SETUPCONF               = $00000020;
  {$EXTERNALSYM LINEADDRFEATURE_SETUPCONF}
  LINEADDRFEATURE_UNCOMPLETECALL          = $00000040;
  {$EXTERNALSYM LINEADDRFEATURE_UNCOMPLETECALL}
  LINEADDRFEATURE_UNPARK                  = $00000080;
  {$EXTERNALSYM LINEADDRFEATURE_UNPARK}
{$IFDEF TAPI20}
  LINEADDRFEATURE_PICKUPHELD              = $00000100;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRFEATURE_PICKUPHELD}
  LINEADDRFEATURE_PICKUPGROUP             = $00000200;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRFEATURE_PICKUPGROUP}
  LINEADDRFEATURE_PICKUPDIRECT            = $00000400;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRFEATURE_PICKUPDIRECT}
  LINEADDRFEATURE_PICKUPWAITING           = $00000800;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRFEATURE_PICKUPWAITING}
  LINEADDRFEATURE_FORWARDFWD              = $00001000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRFEATURE_FORWARDFWD}
  LINEADDRFEATURE_FORWARDDND              = $00002000;     // TAPI v2.0
  {$EXTERNALSYM LINEADDRFEATURE_FORWARDDND}
{$ENDIF}

{$IFDEF TAPI20}
  LINEAGENTFEATURE_SETAGENTGROUP          = $00000001;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTFEATURE_SETAGENTGROUP}
  LINEAGENTFEATURE_SETAGENTSTATE          = $00000002;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTFEATURE_SETAGENTSTATE}
  LINEAGENTFEATURE_SETAGENTACTIVITY       = $00000004;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTFEATURE_SETAGENTACTIVITY}
  LINEAGENTFEATURE_AGENTSPECIFIC          = $00000008;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTFEATURE_AGENTSPECIFIC}
  LINEAGENTFEATURE_GETAGENTACTIVITYLIST   = $00000010;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTFEATURE_GETAGENTACTIVITYLIST}
  LINEAGENTFEATURE_GETAGENTGROUP          = $00000020;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTFEATURE_GETAGENTGROUP}

  LINEAGENTSTATE_LOGGEDOFF                = $00000001;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_LOGGEDOFF}
  LINEAGENTSTATE_NOTREADY                 = $00000002;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_NOTREADY}
  LINEAGENTSTATE_READY                    = $00000004;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_READY}
  LINEAGENTSTATE_BUSYACD                  = $00000008;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_BUSYACD}
  LINEAGENTSTATE_BUSYINCOMING             = $00000010;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_BUSYINCOMING}
  LINEAGENTSTATE_BUSYOUTBOUND             = $00000020;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_BUSYOUTBOUND}
  LINEAGENTSTATE_BUSYOTHER                = $00000040;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_BUSYOTHER}
  LINEAGENTSTATE_WORKINGAFTERCALL         = $00000080;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_WORKINGAFTERCALL}
  LINEAGENTSTATE_UNKNOWN                  = $00000100;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_UNKNOWN}
  LINEAGENTSTATE_UNAVAIL                  = $00000200;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATE_UNAVAIL}

  LINEAGENTSTATUS_GROUP                   = $00000001;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_GROUP}
  LINEAGENTSTATUS_STATE                   = $00000002;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_STATE}
  LINEAGENTSTATUS_NEXTSTATE               = $00000004;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_NEXTSTATE}
  LINEAGENTSTATUS_ACTIVITY                = $00000008;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_ACTIVITY}
  LINEAGENTSTATUS_ACTIVITYLIST            = $00000010;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_ACTIVITYLIST}
  LINEAGENTSTATUS_GROUPLIST               = $00000020;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_GROUPLIST}
  LINEAGENTSTATUS_CAPSCHANGE              = $00000040;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_CAPSCHANGE}
  LINEAGENTSTATUS_VALIDSTATES             = $00000080;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_VALIDSTATES}
  LINEAGENTSTATUS_VALIDNEXTSTATES         = $00000100;     // TAPI v2.0
  {$EXTERNALSYM LINEAGENTSTATUS_VALIDNEXTSTATES}
{$ENDIF}

{$IFDEF TAPI22}
  LINEAGENTSTATEEX_NOTREADY               = $00000001;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATEEX_NOTREADY}
  LINEAGENTSTATEEX_READY                  = $00000002;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATEEX_READY}
  LINEAGENTSTATEEX_BUSYACD                = $00000004;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATEEX_BUSYACD}
  LINEAGENTSTATEEX_BUSYINCOMING           = $00000008;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATEEX_BUSYINCOMING}
  LINEAGENTSTATEEX_BUSYOUTGOING           = $00000010;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATEEX_BUSYOUTGOING}
  LINEAGENTSTATEEX_UNKNOWN                = $00000020;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATEEX_UNKNOWN}
  LINEAGENTSTATEEX_RELEASED               = $00000040;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATEEX_RELEASED}

  LINEAGENTSTATUSEX_NEWAGENT              = $00000001;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATUSEX_NEWAGENT}
  LINEAGENTSTATUSEX_STATE                 = $00000002;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATUSEX_STATE}
  LINEAGENTSTATUSEX_UPDATEINFO            = $00000004;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSTATUSEX_UPDATEINFO}
//LINEAGENTSTATUSEX_DESTROYED             = $00000004;     // TAPI v2.2
//{$EXTERNALSYM LINEAGENTSTATUSEX_DESTROYED}

  LINEAGENTSESSIONSTATE_NOTREADY          = $00000001;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATE_NOTREADY}
  LINEAGENTSESSIONSTATE_READY             = $00000002;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATE_READY}
  LINEAGENTSESSIONSTATE_BUSYONCALL        = $00000004;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATE_BUSYONCALL}
  LINEAGENTSESSIONSTATE_BUSYWRAPUP        = $00000008;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATE_BUSYWRAPUP}
  LINEAGENTSESSIONSTATE_ENDED             = $00000010;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATE_ENDED}
  LINEAGENTSESSIONSTATE_RELEASED          = $00000020;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATE_RELEASED}

  LINEAGENTSESSIONSTATUS_NEWSESSION       = $00000001;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATUS_NEWSESSION}
  LINEAGENTSESSIONSTATUS_STATE            = $00000002;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATUS_STATE}
  LINEAGENTSESSIONSTATUS_UPDATEINFO       = $00000004;     // TAPI v2.2
  {$EXTERNALSYM LINEAGENTSESSIONSTATUS_UPDATEINFO}
//LINEAGENTSESSIONSTATUS_DESTROYED        = $00000008;     // TAPI v2.2
//{$EXTERNALSYM LINEAGENTSESSIONSTATUS_DESTROYED}

  LINEQUEUESTATUS_UPDATEINFO              = $00000001;     // TAPI v2.2
  {$EXTERNALSYM LINEQUEUESTATUS_UPDATEINFO}
  LINEQUEUESTATUS_NEWQUEUE                = $00000002;     // TAPI v2.2
  {$EXTERNALSYM LINEQUEUESTATUS_NEWQUEUE}
  LINEQUEUESTATUS_QUEUEREMOVED            = $00000004;     // TAPI v2.2
  {$EXTERNALSYM LINEQUEUESTATUS_QUEUEREMOVED}

  LINEGROUPSTATUS_NEWGROUP                = $00000001;     // TAPI v2.2
  LINEGROUPSTATUS_GROUPREMOVED            = $00000002;     // TAPI v2.2

  LINEPROXYSTATUS_OPEN                    = $00000001;     // TAPI v2.2
  LINEPROXYSTATUS_CLOSE                   = $00000002;     // TAPI v2.2
  LINEPROXYSTATUS_ALLOPENFORACD           = $00000004;     // TAPI v2.2
{$ENDIF}

  LINEANSWERMODE_NONE                     = $00000001;
  {$EXTERNALSYM LINEANSWERMODE_NONE}
  LINEANSWERMODE_DROP                     = $00000002;
  {$EXTERNALSYM LINEANSWERMODE_DROP}
  LINEANSWERMODE_HOLD                     = $00000004;
  {$EXTERNALSYM LINEANSWERMODE_HOLD}

  LINEBEARERMODE_VOICE                    = $00000001;
  {$EXTERNALSYM LINEBEARERMODE_VOICE}
  LINEBEARERMODE_SPEECH                   = $00000002;
  {$EXTERNALSYM LINEBEARERMODE_SPEECH}
  LINEBEARERMODE_MULTIUSE                 = $00000004;
  {$EXTERNALSYM LINEBEARERMODE_MULTIUSE}
  LINEBEARERMODE_DATA                     = $00000008;
  {$EXTERNALSYM LINEBEARERMODE_DATA}
  LINEBEARERMODE_ALTSPEECHDATA            = $00000010;
  {$EXTERNALSYM LINEBEARERMODE_ALTSPEECHDATA}
  LINEBEARERMODE_NONCALLSIGNALING         = $00000020;
  {$EXTERNALSYM LINEBEARERMODE_NONCALLSIGNALING}
  LINEBEARERMODE_PASSTHROUGH              = $00000040;     // TAPI v1.4
  {$EXTERNALSYM LINEBEARERMODE_PASSTHROUGH}
{$IFDEF TAPI20}
  LINEBEARERMODE_RESTRICTEDDATA           = $00000080;     // TAPI v2.0
  {$EXTERNALSYM LINEBEARERMODE_RESTRICTEDDATA}
{$ENDIF}

  LINEBUSYMODE_STATION                    = $00000001;
  {$EXTERNALSYM LINEBUSYMODE_STATION}
  LINEBUSYMODE_TRUNK                      = $00000002;
  {$EXTERNALSYM LINEBUSYMODE_TRUNK}
  LINEBUSYMODE_UNKNOWN                    = $00000004;
  {$EXTERNALSYM LINEBUSYMODE_UNKNOWN}
  LINEBUSYMODE_UNAVAIL                    = $00000008;
  {$EXTERNALSYM LINEBUSYMODE_UNAVAIL}

  LINECALLCOMPLCOND_BUSY                  = $00000001;
  {$EXTERNALSYM LINECALLCOMPLCOND_BUSY}
  LINECALLCOMPLCOND_NOANSWER              = $00000002;
  {$EXTERNALSYM LINECALLCOMPLCOND_NOANSWER}

  LINECALLCOMPLMODE_CAMPON                = $00000001;
  {$EXTERNALSYM LINECALLCOMPLMODE_CAMPON}
  LINECALLCOMPLMODE_CALLBACK              = $00000002;
  {$EXTERNALSYM LINECALLCOMPLMODE_CALLBACK}
  LINECALLCOMPLMODE_INTRUDE               = $00000004;
  {$EXTERNALSYM LINECALLCOMPLMODE_INTRUDE}
  LINECALLCOMPLMODE_MESSAGE               = $00000008;
  {$EXTERNALSYM LINECALLCOMPLMODE_MESSAGE}

  LINECALLFEATURE_ACCEPT                  = $00000001;
  {$EXTERNALSYM LINECALLFEATURE_ACCEPT}
  LINECALLFEATURE_ADDTOCONF               = $00000002;
  {$EXTERNALSYM LINECALLFEATURE_ADDTOCONF}
  LINECALLFEATURE_ANSWER                  = $00000004;
  {$EXTERNALSYM LINECALLFEATURE_ANSWER}
  LINECALLFEATURE_BLINDTRANSFER           = $00000008;
  {$EXTERNALSYM LINECALLFEATURE_BLINDTRANSFER}
  LINECALLFEATURE_COMPLETECALL            = $00000010;
  {$EXTERNALSYM LINECALLFEATURE_COMPLETECALL}
  LINECALLFEATURE_COMPLETETRANSF          = $00000020;
  {$EXTERNALSYM LINECALLFEATURE_COMPLETETRANSF}
  LINECALLFEATURE_DIAL                    = $00000040;
  {$EXTERNALSYM LINECALLFEATURE_DIAL}
  LINECALLFEATURE_DROP                    = $00000080;
  {$EXTERNALSYM LINECALLFEATURE_DROP}
  LINECALLFEATURE_GATHERDIGITS            = $00000100;
  {$EXTERNALSYM LINECALLFEATURE_GATHERDIGITS}
  LINECALLFEATURE_GENERATEDIGITS          = $00000200;
  {$EXTERNALSYM LINECALLFEATURE_GENERATEDIGITS}
  LINECALLFEATURE_GENERATETONE            = $00000400;
  {$EXTERNALSYM LINECALLFEATURE_GENERATETONE}
  LINECALLFEATURE_HOLD                    = $00000800;
  {$EXTERNALSYM LINECALLFEATURE_HOLD}
  LINECALLFEATURE_MONITORDIGITS           = $00001000;
  {$EXTERNALSYM LINECALLFEATURE_MONITORDIGITS}
  LINECALLFEATURE_MONITORMEDIA            = $00002000;
  {$EXTERNALSYM LINECALLFEATURE_MONITORMEDIA}
  LINECALLFEATURE_MONITORTONES            = $00004000;
  {$EXTERNALSYM LINECALLFEATURE_MONITORTONES}
  LINECALLFEATURE_PARK                    = $00008000;
  {$EXTERNALSYM LINECALLFEATURE_PARK}
  LINECALLFEATURE_PREPAREADDCONF          = $00010000;
  {$EXTERNALSYM LINECALLFEATURE_PREPAREADDCONF}
  LINECALLFEATURE_REDIRECT                = $00020000;
  {$EXTERNALSYM LINECALLFEATURE_REDIRECT}
  LINECALLFEATURE_REMOVEFROMCONF          = $00040000;
  {$EXTERNALSYM LINECALLFEATURE_REMOVEFROMCONF}
  LINECALLFEATURE_SECURECALL              = $00080000;
  {$EXTERNALSYM LINECALLFEATURE_SECURECALL}
  LINECALLFEATURE_SENDUSERUSER            = $00100000;
  {$EXTERNALSYM LINECALLFEATURE_SENDUSERUSER}
  LINECALLFEATURE_SETCALLPARAMS           = $00200000;
  {$EXTERNALSYM LINECALLFEATURE_SETCALLPARAMS}
  LINECALLFEATURE_SETMEDIACONTROL         = $00400000;
  {$EXTERNALSYM LINECALLFEATURE_SETMEDIACONTROL}
  LINECALLFEATURE_SETTERMINAL             = $00800000;
  {$EXTERNALSYM LINECALLFEATURE_SETTERMINAL}
  LINECALLFEATURE_SETUPCONF               = $01000000;
  {$EXTERNALSYM LINECALLFEATURE_SETUPCONF}
  LINECALLFEATURE_SETUPTRANSFER           = $02000000;
  {$EXTERNALSYM LINECALLFEATURE_SETUPTRANSFER}
  LINECALLFEATURE_SWAPHOLD                = $04000000;
  {$EXTERNALSYM LINECALLFEATURE_SWAPHOLD}
  LINECALLFEATURE_UNHOLD                  = $08000000;
  {$EXTERNALSYM LINECALLFEATURE_UNHOLD}
  LINECALLFEATURE_RELEASEUSERUSERINFO     = $10000000;     // TAPI v1.4
  {$EXTERNALSYM LINECALLFEATURE_RELEASEUSERUSERINFO}
{$IFDEF TAPI20}
  LINECALLFEATURE_SETTREATMENT            = $20000000;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE_SETTREATMENT}
  LINECALLFEATURE_SETQOS                  = $40000000;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE_SETQOS}
  LINECALLFEATURE_SETCALLDATA             = DWORD($80000000); // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE_SETCALLDATA}
{$ENDIF}

{$IFDEF TAPI20}
  LINECALLFEATURE2_NOHOLDCONFERENCE       = $00000001;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_NOHOLDCONFERENCE}
  LINECALLFEATURE2_ONESTEPTRANSFER        = $00000002;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_ONESTEPTRANSFER}
  LINECALLFEATURE2_COMPLCAMPON            = $00000004;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_COMPLCAMPON}
  LINECALLFEATURE2_COMPLCALLBACK          = $00000008;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_COMPLCALLBACK}
  LINECALLFEATURE2_COMPLINTRUDE           = $00000010;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_COMPLINTRUDE}
  LINECALLFEATURE2_COMPLMESSAGE           = $00000020;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_COMPLMESSAGE}
  LINECALLFEATURE2_TRANSFERNORM           = $00000040;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_TRANSFERNORM}
  LINECALLFEATURE2_TRANSFERCONF           = $00000080;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_TRANSFERCONF}
  LINECALLFEATURE2_PARKDIRECT             = $00000100;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_PARKDIRECT}
  LINECALLFEATURE2_PARKNONDIRECT          = $00000200;     // TAPI v2.0
  {$EXTERNALSYM LINECALLFEATURE2_PARKNONDIRECT}
{$ENDIF}

{$IFDEF TAPI30}
  LINECALLHUBTRACKING_NONE                = $00000000;     // TAPI v3.0
  LINECALLHUBTRACKING_PROVIDERLEVEL       = $00000001;     // TAPI v3.0
  LINECALLHUBTRACKING_ALLCALLS            = $00000002;     // TAPI v3.0
{$ENDIF}

  LINECALLINFOSTATE_OTHER                 = $00000001;
  {$EXTERNALSYM LINECALLINFOSTATE_OTHER}
  LINECALLINFOSTATE_DEVSPECIFIC           = $00000002;
  {$EXTERNALSYM LINECALLINFOSTATE_DEVSPECIFIC}
  LINECALLINFOSTATE_BEARERMODE            = $00000004;
  {$EXTERNALSYM LINECALLINFOSTATE_BEARERMODE}
  LINECALLINFOSTATE_RATE                  = $00000008;
  {$EXTERNALSYM LINECALLINFOSTATE_RATE}
  LINECALLINFOSTATE_MEDIAMODE             = $00000010;
  {$EXTERNALSYM LINECALLINFOSTATE_MEDIAMODE}
  LINECALLINFOSTATE_APPSPECIFIC           = $00000020;
  {$EXTERNALSYM LINECALLINFOSTATE_APPSPECIFIC}
  LINECALLINFOSTATE_CALLID                = $00000040;
  {$EXTERNALSYM LINECALLINFOSTATE_CALLID}
  LINECALLINFOSTATE_RELATEDCALLID         = $00000080;
  {$EXTERNALSYM LINECALLINFOSTATE_RELATEDCALLID}
  LINECALLINFOSTATE_ORIGIN                = $00000100;
  {$EXTERNALSYM LINECALLINFOSTATE_ORIGIN}
  LINECALLINFOSTATE_REASON                = $00000200;
  {$EXTERNALSYM LINECALLINFOSTATE_REASON}
  LINECALLINFOSTATE_COMPLETIONID          = $00000400;
  {$EXTERNALSYM LINECALLINFOSTATE_COMPLETIONID}
  LINECALLINFOSTATE_NUMOWNERINCR          = $00000800;
  {$EXTERNALSYM LINECALLINFOSTATE_NUMOWNERINCR}
  LINECALLINFOSTATE_NUMOWNERDECR          = $00001000;
  {$EXTERNALSYM LINECALLINFOSTATE_NUMOWNERDECR}
  LINECALLINFOSTATE_NUMMONITORS           = $00002000;
  {$EXTERNALSYM LINECALLINFOSTATE_NUMMONITORS}
  LINECALLINFOSTATE_TRUNK                 = $00004000;
  {$EXTERNALSYM LINECALLINFOSTATE_TRUNK}
  LINECALLINFOSTATE_CALLERID              = $00008000;
  {$EXTERNALSYM LINECALLINFOSTATE_CALLERID}
  LINECALLINFOSTATE_CALLEDID              = $00010000;
  {$EXTERNALSYM LINECALLINFOSTATE_CALLEDID}
  LINECALLINFOSTATE_CONNECTEDID           = $00020000;
  {$EXTERNALSYM LINECALLINFOSTATE_CONNECTEDID}
  LINECALLINFOSTATE_REDIRECTIONID         = $00040000;
  {$EXTERNALSYM LINECALLINFOSTATE_REDIRECTIONID}
  LINECALLINFOSTATE_REDIRECTINGID         = $00080000;
  {$EXTERNALSYM LINECALLINFOSTATE_REDIRECTINGID}
  LINECALLINFOSTATE_DISPLAY               = $00100000;
  {$EXTERNALSYM LINECALLINFOSTATE_DISPLAY}
  LINECALLINFOSTATE_USERUSERINFO          = $00200000;
  {$EXTERNALSYM LINECALLINFOSTATE_USERUSERINFO}
  LINECALLINFOSTATE_HIGHLEVELCOMP         = $00400000;
  {$EXTERNALSYM LINECALLINFOSTATE_HIGHLEVELCOMP}
  LINECALLINFOSTATE_LOWLEVELCOMP          = $00800000;
  {$EXTERNALSYM LINECALLINFOSTATE_LOWLEVELCOMP}
  LINECALLINFOSTATE_CHARGINGINFO          = $01000000;
  {$EXTERNALSYM LINECALLINFOSTATE_CHARGINGINFO}
  LINECALLINFOSTATE_TERMINAL              = $02000000;
  {$EXTERNALSYM LINECALLINFOSTATE_TERMINAL}
  LINECALLINFOSTATE_DIALPARAMS            = $04000000;
  {$EXTERNALSYM LINECALLINFOSTATE_DIALPARAMS}
  LINECALLINFOSTATE_MONITORMODES          = $08000000;
  {$EXTERNALSYM LINECALLINFOSTATE_MONITORMODES}
{$IFDEF TAPI20}
  LINECALLINFOSTATE_TREATMENT             = $10000000;     // TAPI v2.0
  {$EXTERNALSYM LINECALLINFOSTATE_TREATMENT}
  LINECALLINFOSTATE_QOS                   = $20000000;     // TAPI v2.0
  {$EXTERNALSYM LINECALLINFOSTATE_QOS}
  LINECALLINFOSTATE_CALLDATA              = $40000000;     // TAPI v2.0
  {$EXTERNALSYM LINECALLINFOSTATE_CALLDATA}
{$ENDIF}

  LINECALLORIGIN_OUTBOUND                 = $00000001;
  {$EXTERNALSYM LINECALLORIGIN_OUTBOUND}
  LINECALLORIGIN_INTERNAL                 = $00000002;
  {$EXTERNALSYM LINECALLORIGIN_INTERNAL}
  LINECALLORIGIN_EXTERNAL                 = $00000004;
  {$EXTERNALSYM LINECALLORIGIN_EXTERNAL}
  LINECALLORIGIN_UNKNOWN                  = $00000010;
  {$EXTERNALSYM LINECALLORIGIN_UNKNOWN}
  LINECALLORIGIN_UNAVAIL                  = $00000020;
  {$EXTERNALSYM LINECALLORIGIN_UNAVAIL}
  LINECALLORIGIN_CONFERENCE               = $00000040;
  {$EXTERNALSYM LINECALLORIGIN_CONFERENCE}
  LINECALLORIGIN_INBOUND                  = $00000080;     // TAPI v1.4
  {$EXTERNALSYM LINECALLORIGIN_INBOUND}

  LINECALLPARAMFLAGS_SECURE               = $00000001;
  {$EXTERNALSYM LINECALLPARAMFLAGS_SECURE}
  LINECALLPARAMFLAGS_IDLE                 = $00000002;
  {$EXTERNALSYM LINECALLPARAMFLAGS_IDLE}
  LINECALLPARAMFLAGS_BLOCKID              = $00000004;
  {$EXTERNALSYM LINECALLPARAMFLAGS_BLOCKID}
  LINECALLPARAMFLAGS_ORIGOFFHOOK          = $00000008;
  {$EXTERNALSYM LINECALLPARAMFLAGS_ORIGOFFHOOK}
  LINECALLPARAMFLAGS_DESTOFFHOOK          = $00000010;
  {$EXTERNALSYM LINECALLPARAMFLAGS_DESTOFFHOOK}
{$IFDEF TAPI20}
  LINECALLPARAMFLAGS_NOHOLDCONFERENCE     = $00000020;     // TAPI v2.0
  {$EXTERNALSYM LINECALLPARAMFLAGS_NOHOLDCONFERENCE}
  LINECALLPARAMFLAGS_PREDICTIVEDIAL       = $00000040;     // TAPI v2.0
  {$EXTERNALSYM LINECALLPARAMFLAGS_PREDICTIVEDIAL}
  LINECALLPARAMFLAGS_ONESTEPTRANSFER      = $00000080;     // TAPI v2.0
  {$EXTERNALSYM LINECALLPARAMFLAGS_ONESTEPTRANSFER}
{$ENDIF}

  LINECALLPARTYID_BLOCKED                 = $00000001;
  {$EXTERNALSYM LINECALLPARTYID_BLOCKED}
  LINECALLPARTYID_OUTOFAREA               = $00000002;
  {$EXTERNALSYM LINECALLPARTYID_OUTOFAREA}
  LINECALLPARTYID_NAME                    = $00000004;
  {$EXTERNALSYM LINECALLPARTYID_NAME}
  LINECALLPARTYID_ADDRESS                 = $00000008;
  {$EXTERNALSYM LINECALLPARTYID_ADDRESS}
  LINECALLPARTYID_PARTIAL                 = $00000010;
  {$EXTERNALSYM LINECALLPARTYID_PARTIAL}
  LINECALLPARTYID_UNKNOWN                 = $00000020;
  {$EXTERNALSYM LINECALLPARTYID_UNKNOWN}
  LINECALLPARTYID_UNAVAIL                 = $00000040;
  {$EXTERNALSYM LINECALLPARTYID_UNAVAIL}

  LINECALLPRIVILEGE_NONE                  = $00000001;
  {$EXTERNALSYM LINECALLPRIVILEGE_NONE}
  LINECALLPRIVILEGE_MONITOR               = $00000002;
  {$EXTERNALSYM LINECALLPRIVILEGE_MONITOR}
  LINECALLPRIVILEGE_OWNER                 = $00000004;
  {$EXTERNALSYM LINECALLPRIVILEGE_OWNER}

  LINECALLREASON_DIRECT                   = $00000001;
  {$EXTERNALSYM LINECALLREASON_DIRECT}
  LINECALLREASON_FWDBUSY                  = $00000002;
  {$EXTERNALSYM LINECALLREASON_FWDBUSY}
  LINECALLREASON_FWDNOANSWER              = $00000004;
  {$EXTERNALSYM LINECALLREASON_FWDNOANSWER}
  LINECALLREASON_FWDUNCOND                = $00000008;
  {$EXTERNALSYM LINECALLREASON_FWDUNCOND}
  LINECALLREASON_PICKUP                   = $00000010;
  {$EXTERNALSYM LINECALLREASON_PICKUP}
  LINECALLREASON_UNPARK                   = $00000020;
  {$EXTERNALSYM LINECALLREASON_UNPARK}
  LINECALLREASON_REDIRECT                 = $00000040;
  {$EXTERNALSYM LINECALLREASON_REDIRECT}
  LINECALLREASON_CALLCOMPLETION           = $00000080;
  {$EXTERNALSYM LINECALLREASON_CALLCOMPLETION}
  LINECALLREASON_TRANSFER                 = $00000100;
  {$EXTERNALSYM LINECALLREASON_TRANSFER}
  LINECALLREASON_REMINDER                 = $00000200;
  {$EXTERNALSYM LINECALLREASON_REMINDER}
  LINECALLREASON_UNKNOWN                  = $00000400;
  {$EXTERNALSYM LINECALLREASON_UNKNOWN}
  LINECALLREASON_UNAVAIL                  = $00000800;
  {$EXTERNALSYM LINECALLREASON_UNAVAIL}
  LINECALLREASON_INTRUDE                  = $00001000;     // TAPI v1.4
  {$EXTERNALSYM LINECALLREASON_INTRUDE}
{$IFDEF TAPI20}
  LINECALLREASON_PARKED                   = $00002000;     // TAPI v1.4
  {$EXTERNALSYM LINECALLREASON_PARKED}
  LINECALLREASON_CAMPEDON                 = $00004000;     // TAPI v2.0
  {$EXTERNALSYM LINECALLREASON_CAMPEDON}
  LINECALLREASON_ROUTEREQUEST             = $00008000;     // TAPI v2.0
  {$EXTERNALSYM LINECALLREASON_ROUTEREQUEST}
{$ENDIF}

  LINECALLSELECT_LINE                     = $00000001;
  {$EXTERNALSYM LINECALLSELECT_LINE}
  LINECALLSELECT_ADDRESS                  = $00000002;
  {$EXTERNALSYM LINECALLSELECT_ADDRESS}
  LINECALLSELECT_CALL                     = $00000004;
  {$EXTERNALSYM LINECALLSELECT_CALL}
{$IFDEF TAPI21}
  LINECALLSELECT_DEVICEID                 = $00000008;    // TAPI v2.1
  {$EXTERNALSYM LINECALLSELECT_DEVICEID}
{$ENDIF}
{$IFDEF TAPI30}
  LINECALLSELECT_CALLID                   = $00000010;    // TAPI v3.0
  {$EXTERNALSYM LINECALLSELECT_CALLID}
{$ENDIF}

  LINECALLSTATE_IDLE                      = $00000001;
  {$EXTERNALSYM LINECALLSTATE_IDLE}
  LINECALLSTATE_OFFERING                  = $00000002;
  {$EXTERNALSYM LINECALLSTATE_OFFERING}
  LINECALLSTATE_ACCEPTED                  = $00000004;
  {$EXTERNALSYM LINECALLSTATE_ACCEPTED}
  LINECALLSTATE_DIALTONE                  = $00000008;
  {$EXTERNALSYM LINECALLSTATE_DIALTONE}
  LINECALLSTATE_DIALING                   = $00000010;
  {$EXTERNALSYM LINECALLSTATE_DIALING}
  LINECALLSTATE_RINGBACK                  = $00000020;
  {$EXTERNALSYM LINECALLSTATE_RINGBACK}
  LINECALLSTATE_BUSY                      = $00000040;
  {$EXTERNALSYM LINECALLSTATE_BUSY}
  LINECALLSTATE_SPECIALINFO               = $00000080;
  {$EXTERNALSYM LINECALLSTATE_SPECIALINFO}
  LINECALLSTATE_CONNECTED                 = $00000100;
  {$EXTERNALSYM LINECALLSTATE_CONNECTED}
  LINECALLSTATE_PROCEEDING                = $00000200;
  {$EXTERNALSYM LINECALLSTATE_PROCEEDING}
  LINECALLSTATE_ONHOLD                    = $00000400;
  {$EXTERNALSYM LINECALLSTATE_ONHOLD}
  LINECALLSTATE_CONFERENCED               = $00000800;
  {$EXTERNALSYM LINECALLSTATE_CONFERENCED}
  LINECALLSTATE_ONHOLDPENDCONF            = $00001000;
  {$EXTERNALSYM LINECALLSTATE_ONHOLDPENDCONF}
  LINECALLSTATE_ONHOLDPENDTRANSFER        = $00002000;
  {$EXTERNALSYM LINECALLSTATE_ONHOLDPENDTRANSFER}
  LINECALLSTATE_DISCONNECTED              = $00004000;
  {$EXTERNALSYM LINECALLSTATE_DISCONNECTED}
  LINECALLSTATE_UNKNOWN                   = $00008000;
  {$EXTERNALSYM LINECALLSTATE_UNKNOWN}

{$IFDEF TAPI20}
  LINECALLTREATMENT_SILENCE               = $00000001;     // TAPI v2.0
  {$EXTERNALSYM LINECALLTREATMENT_SILENCE}
  LINECALLTREATMENT_RINGBACK              = $00000002;     // TAPI v2.0
  {$EXTERNALSYM LINECALLTREATMENT_RINGBACK}
  LINECALLTREATMENT_BUSY                  = $00000003;     // TAPI v2.0
  {$EXTERNALSYM LINECALLTREATMENT_BUSY}
  LINECALLTREATMENT_MUSIC                 = $00000004;     // TAPI v2.0
  {$EXTERNALSYM LINECALLTREATMENT_MUSIC}
{$ENDIF}

  LINECARDOPTION_PREDEFINED               = $00000001;     // TAPI v1.4
  {$EXTERNALSYM LINECARDOPTION_PREDEFINED}
  LINECARDOPTION_HIDDEN                   = $00000002;     // TAPI v1.4
  {$EXTERNALSYM LINECARDOPTION_HIDDEN}

  LINECONNECTEDMODE_ACTIVE                = $00000001;     // TAPI v1.4
  {$EXTERNALSYM LINECONNECTEDMODE_ACTIVE}
  LINECONNECTEDMODE_INACTIVE              = $00000002;     // TAPI v1.4
  {$EXTERNALSYM LINECONNECTEDMODE_INACTIVE}
{$IFDEF TAPI20}
  LINECONNECTEDMODE_ACTIVEHELD            = $00000004;     // TAPI v2.0
  {$EXTERNALSYM LINECONNECTEDMODE_ACTIVEHELD}
  LINECONNECTEDMODE_INACTIVEHELD          = $00000008;     // TAPI v2.0
  {$EXTERNALSYM LINECONNECTEDMODE_INACTIVEHELD}
  LINECONNECTEDMODE_CONFIRMED             = $00000010;     // TAPI v2.0
  {$EXTERNALSYM LINECONNECTEDMODE_CONFIRMED}
{$ENDIF}

  LINEDEVCAPFLAGS_CROSSADDRCONF           = $00000001;
  {$EXTERNALSYM LINEDEVCAPFLAGS_CROSSADDRCONF}
  LINEDEVCAPFLAGS_HIGHLEVCOMP             = $00000002;
  {$EXTERNALSYM LINEDEVCAPFLAGS_HIGHLEVCOMP}
  LINEDEVCAPFLAGS_LOWLEVCOMP              = $00000004;
  {$EXTERNALSYM LINEDEVCAPFLAGS_LOWLEVCOMP}
  LINEDEVCAPFLAGS_MEDIACONTROL            = $00000008;
  {$EXTERNALSYM LINEDEVCAPFLAGS_MEDIACONTROL}
  LINEDEVCAPFLAGS_MULTIPLEADDR            = $00000010;
  {$EXTERNALSYM LINEDEVCAPFLAGS_MULTIPLEADDR}
  LINEDEVCAPFLAGS_CLOSEDROP               = $00000020;
  {$EXTERNALSYM LINEDEVCAPFLAGS_CLOSEDROP}
  LINEDEVCAPFLAGS_DIALBILLING             = $00000040;
  {$EXTERNALSYM LINEDEVCAPFLAGS_DIALBILLING}
  LINEDEVCAPFLAGS_DIALQUIET               = $00000080;
  {$EXTERNALSYM LINEDEVCAPFLAGS_DIALQUIET}
  LINEDEVCAPFLAGS_DIALDIALTONE            = $00000100;
  {$EXTERNALSYM LINEDEVCAPFLAGS_DIALDIALTONE}

{$IFDEF TAPI30}
  LINEDEVCAPFLAGS_MSP                     = $00000200;      // TAPI v3.0
  LINEDEVCAPFLAGS_CALLHUB                 = $00000400;      // TAPI v3.0
  LINEDEVCAPFLAGS_CALLHUBTRACKING         = $00000800;      // TAPI v3.0
  LINEDEVCAPFLAGS_PRIVATEOBJECTS          = $00001000;      // TAPI v3.0
{$ENDIF}

  LINEDEVSTATE_OTHER                      = $00000001;
  {$EXTERNALSYM LINEDEVSTATE_OTHER}
  LINEDEVSTATE_RINGING                    = $00000002;
  {$EXTERNALSYM LINEDEVSTATE_RINGING}
  LINEDEVSTATE_CONNECTED                  = $00000004;
  {$EXTERNALSYM LINEDEVSTATE_CONNECTED}
  LINEDEVSTATE_DISCONNECTED               = $00000008;
  {$EXTERNALSYM LINEDEVSTATE_DISCONNECTED}
  LINEDEVSTATE_MSGWAITON                  = $00000010;
  {$EXTERNALSYM LINEDEVSTATE_MSGWAITON}
  LINEDEVSTATE_MSGWAITOFF                 = $00000020;
  {$EXTERNALSYM LINEDEVSTATE_MSGWAITOFF}
  LINEDEVSTATE_INSERVICE                  = $00000040;
  {$EXTERNALSYM LINEDEVSTATE_INSERVICE}
  LINEDEVSTATE_OUTOFSERVICE               = $00000080;
  {$EXTERNALSYM LINEDEVSTATE_OUTOFSERVICE}
  LINEDEVSTATE_MAINTENANCE                = $00000100;
  {$EXTERNALSYM LINEDEVSTATE_MAINTENANCE}
  LINEDEVSTATE_OPEN                       = $00000200;
  {$EXTERNALSYM LINEDEVSTATE_OPEN}
  LINEDEVSTATE_CLOSE                      = $00000400;
  {$EXTERNALSYM LINEDEVSTATE_CLOSE}
  LINEDEVSTATE_NUMCALLS                   = $00000800;
  {$EXTERNALSYM LINEDEVSTATE_NUMCALLS}
  LINEDEVSTATE_NUMCOMPLETIONS             = $00001000;
  {$EXTERNALSYM LINEDEVSTATE_NUMCOMPLETIONS}
  LINEDEVSTATE_TERMINALS                  = $00002000;
  {$EXTERNALSYM LINEDEVSTATE_TERMINALS}
  LINEDEVSTATE_ROAMMODE                   = $00004000;
  {$EXTERNALSYM LINEDEVSTATE_ROAMMODE}
  LINEDEVSTATE_BATTERY                    = $00008000;
  {$EXTERNALSYM LINEDEVSTATE_BATTERY}
  LINEDEVSTATE_SIGNAL                     = $00010000;
  {$EXTERNALSYM LINEDEVSTATE_SIGNAL}
  LINEDEVSTATE_DEVSPECIFIC                = $00020000;
  {$EXTERNALSYM LINEDEVSTATE_DEVSPECIFIC}
  LINEDEVSTATE_REINIT                     = $00040000;
  {$EXTERNALSYM LINEDEVSTATE_REINIT}
  LINEDEVSTATE_LOCK                       = $00080000;
  {$EXTERNALSYM LINEDEVSTATE_LOCK}
  LINEDEVSTATE_CAPSCHANGE                 = $00100000;     // TAPI v1.4
  {$EXTERNALSYM LINEDEVSTATE_CAPSCHANGE}
  LINEDEVSTATE_CONFIGCHANGE               = $00200000;     // TAPI v1.4
  {$EXTERNALSYM LINEDEVSTATE_CONFIGCHANGE}
  LINEDEVSTATE_TRANSLATECHANGE            = $00400000;     // TAPI v1.4
  {$EXTERNALSYM LINEDEVSTATE_TRANSLATECHANGE}
  LINEDEVSTATE_COMPLCANCEL                = $00800000;     // TAPI v1.4
  {$EXTERNALSYM LINEDEVSTATE_COMPLCANCEL}
  LINEDEVSTATE_REMOVED                    = $01000000;     // TAPI v1.4
  {$EXTERNALSYM LINEDEVSTATE_REMOVED}

  LINEDEVSTATUSFLAGS_CONNECTED            = $00000001;
  {$EXTERNALSYM LINEDEVSTATUSFLAGS_CONNECTED}
  LINEDEVSTATUSFLAGS_MSGWAIT              = $00000002;
  {$EXTERNALSYM LINEDEVSTATUSFLAGS_MSGWAIT}
  LINEDEVSTATUSFLAGS_INSERVICE            = $00000004;
  {$EXTERNALSYM LINEDEVSTATUSFLAGS_INSERVICE}
  LINEDEVSTATUSFLAGS_LOCKED               = $00000008;
  {$EXTERNALSYM LINEDEVSTATUSFLAGS_LOCKED}

  LINEDIALTONEMODE_NORMAL                 = $00000001;
  {$EXTERNALSYM LINEDIALTONEMODE_NORMAL}
  LINEDIALTONEMODE_SPECIAL                = $00000002;
  {$EXTERNALSYM LINEDIALTONEMODE_SPECIAL}
  LINEDIALTONEMODE_INTERNAL               = $00000004;
  {$EXTERNALSYM LINEDIALTONEMODE_INTERNAL}
  LINEDIALTONEMODE_EXTERNAL               = $00000008;
  {$EXTERNALSYM LINEDIALTONEMODE_EXTERNAL}
  LINEDIALTONEMODE_UNKNOWN                = $00000010;
  {$EXTERNALSYM LINEDIALTONEMODE_UNKNOWN}
  LINEDIALTONEMODE_UNAVAIL                = $00000020;
  {$EXTERNALSYM LINEDIALTONEMODE_UNAVAIL}

  LINEDIGITMODE_PULSE                     = $00000001;
  {$EXTERNALSYM LINEDIGITMODE_PULSE}
  LINEDIGITMODE_DTMF                      = $00000002;
  {$EXTERNALSYM LINEDIGITMODE_DTMF}
  LINEDIGITMODE_DTMFEND                   = $00000004;
  {$EXTERNALSYM LINEDIGITMODE_DTMFEND}

  LINEDISCONNECTMODE_NORMAL               = $00000001;
  {$EXTERNALSYM LINEDISCONNECTMODE_NORMAL}
  LINEDISCONNECTMODE_UNKNOWN              = $00000002;
  {$EXTERNALSYM LINEDISCONNECTMODE_UNKNOWN}
  LINEDISCONNECTMODE_REJECT               = $00000004;
  {$EXTERNALSYM LINEDISCONNECTMODE_REJECT}
  LINEDISCONNECTMODE_PICKUP               = $00000008;
  {$EXTERNALSYM LINEDISCONNECTMODE_PICKUP}
  LINEDISCONNECTMODE_FORWARDED            = $00000010;
  {$EXTERNALSYM LINEDISCONNECTMODE_FORWARDED}
  LINEDISCONNECTMODE_BUSY                 = $00000020;
  {$EXTERNALSYM LINEDISCONNECTMODE_BUSY}
  LINEDISCONNECTMODE_NOANSWER             = $00000040;
  {$EXTERNALSYM LINEDISCONNECTMODE_NOANSWER}
  LINEDISCONNECTMODE_BADADDRESS           = $00000080;
  {$EXTERNALSYM LINEDISCONNECTMODE_BADADDRESS}
  LINEDISCONNECTMODE_UNREACHABLE          = $00000100;
  {$EXTERNALSYM LINEDISCONNECTMODE_UNREACHABLE}
  LINEDISCONNECTMODE_CONGESTION           = $00000200;
  {$EXTERNALSYM LINEDISCONNECTMODE_CONGESTION}
  LINEDISCONNECTMODE_INCOMPATIBLE         = $00000400;
  {$EXTERNALSYM LINEDISCONNECTMODE_INCOMPATIBLE}
  LINEDISCONNECTMODE_UNAVAIL              = $00000800;
  {$EXTERNALSYM LINEDISCONNECTMODE_UNAVAIL}
  LINEDISCONNECTMODE_NODIALTONE           = $00001000;     // TAPI v1.4
  {$EXTERNALSYM LINEDISCONNECTMODE_NODIALTONE}
{$IFDEF TAPI20}
  LINEDISCONNECTMODE_NUMBERCHANGED        = $00002000;     // TAPI v2.0
  {$EXTERNALSYM LINEDISCONNECTMODE_NUMBERCHANGED}
  LINEDISCONNECTMODE_OUTOFORDER           = $00004000;     // TAPI v2.0
  {$EXTERNALSYM LINEDISCONNECTMODE_OUTOFORDER}
  LINEDISCONNECTMODE_TEMPFAILURE          = $00008000;     // TAPI v2.0
  {$EXTERNALSYM LINEDISCONNECTMODE_TEMPFAILURE}
  LINEDISCONNECTMODE_QOSUNAVAIL           = $00010000;     // TAPI v2.0
  {$EXTERNALSYM LINEDISCONNECTMODE_QOSUNAVAIL}
  LINEDISCONNECTMODE_BLOCKED              = $00020000;     // TAPI v2.0
  {$EXTERNALSYM LINEDISCONNECTMODE_BLOCKED}
  LINEDISCONNECTMODE_DONOTDISTURB         = $00040000;     // TAPI v2.0
  {$EXTERNALSYM LINEDISCONNECTMODE_DONOTDISTURB}
  LINEDISCONNECTMODE_CANCELLED            = $00080000;     // TAPI v2.0
  {$EXTERNALSYM LINEDISCONNECTMODE_CANCELLED}
{$ENDIF}

  LINEERR_ALLOCATED                       = DWORD($80000001);
  {$EXTERNALSYM LINEERR_ALLOCATED}
  LINEERR_BADDEVICEID                     = DWORD($80000002);
  {$EXTERNALSYM LINEERR_BADDEVICEID}
  LINEERR_BEARERMODEUNAVAIL               = DWORD($80000003);
  {$EXTERNALSYM LINEERR_BEARERMODEUNAVAIL}
  LINEERR_CALLUNAVAIL                     = DWORD($80000005);
  {$EXTERNALSYM LINEERR_CALLUNAVAIL}
  LINEERR_COMPLETIONOVERRUN               = DWORD($80000006);
  {$EXTERNALSYM LINEERR_COMPLETIONOVERRUN}
  LINEERR_CONFERENCEFULL                  = DWORD($80000007);
  {$EXTERNALSYM LINEERR_CONFERENCEFULL}
  LINEERR_DIALBILLING                     = DWORD($80000008);
  {$EXTERNALSYM LINEERR_DIALBILLING}
  LINEERR_DIALDIALTONE                    = DWORD($80000009);
  {$EXTERNALSYM LINEERR_DIALDIALTONE}
  LINEERR_DIALPROMPT                      = DWORD($8000000A);
  {$EXTERNALSYM LINEERR_DIALPROMPT}
  LINEERR_DIALQUIET                       = DWORD($8000000B);
  {$EXTERNALSYM LINEERR_DIALQUIET}
  LINEERR_INCOMPATIBLEAPIVERSION          = DWORD($8000000C);
  {$EXTERNALSYM LINEERR_INCOMPATIBLEAPIVERSION}
  LINEERR_INCOMPATIBLEEXTVERSION          = DWORD($8000000D);
  {$EXTERNALSYM LINEERR_INCOMPATIBLEEXTVERSION}
  LINEERR_INIFILECORRUPT                  = DWORD($8000000E);
  {$EXTERNALSYM LINEERR_INIFILECORRUPT}
  LINEERR_INUSE                           = DWORD($8000000F);
  {$EXTERNALSYM LINEERR_INUSE}
  LINEERR_INVALADDRESS                    = DWORD($80000010);
  {$EXTERNALSYM LINEERR_INVALADDRESS}
  LINEERR_INVALADDRESSID                  = DWORD($80000011);
  {$EXTERNALSYM LINEERR_INVALADDRESSID}
  LINEERR_INVALADDRESSMODE                = DWORD($80000012);
  {$EXTERNALSYM LINEERR_INVALADDRESSMODE}
  LINEERR_INVALADDRESSSTATE               = DWORD($80000013);
  {$EXTERNALSYM LINEERR_INVALADDRESSSTATE}
  LINEERR_INVALAPPHANDLE                  = DWORD($80000014);
  {$EXTERNALSYM LINEERR_INVALAPPHANDLE}
  LINEERR_INVALAPPNAME                    = DWORD($80000015);
  {$EXTERNALSYM LINEERR_INVALAPPNAME}
  LINEERR_INVALBEARERMODE                 = DWORD($80000016);
  {$EXTERNALSYM LINEERR_INVALBEARERMODE}
  LINEERR_INVALCALLCOMPLMODE              = DWORD($80000017);
  {$EXTERNALSYM LINEERR_INVALCALLCOMPLMODE}
  LINEERR_INVALCALLHANDLE                 = DWORD($80000018);
  {$EXTERNALSYM LINEERR_INVALCALLHANDLE}
  LINEERR_INVALCALLPARAMS                 = DWORD($80000019);
  {$EXTERNALSYM LINEERR_INVALCALLPARAMS}
  LINEERR_INVALCALLPRIVILEGE              = DWORD($8000001A);
  {$EXTERNALSYM LINEERR_INVALCALLPRIVILEGE}
  LINEERR_INVALCALLSELECT                 = DWORD($8000001B);
  {$EXTERNALSYM LINEERR_INVALCALLSELECT}
  LINEERR_INVALCALLSTATE                  = DWORD($8000001C);
  {$EXTERNALSYM LINEERR_INVALCALLSTATE}
  LINEERR_INVALCALLSTATELIST              = DWORD($8000001D);
  {$EXTERNALSYM LINEERR_INVALCALLSTATELIST}
  LINEERR_INVALCARD                       = DWORD($8000001E);
  {$EXTERNALSYM LINEERR_INVALCARD}
  LINEERR_INVALCOMPLETIONID               = DWORD($8000001F);
  {$EXTERNALSYM LINEERR_INVALCOMPLETIONID}
  LINEERR_INVALCONFCALLHANDLE             = DWORD($80000020);
  {$EXTERNALSYM LINEERR_INVALCONFCALLHANDLE}
  LINEERR_INVALCONSULTCALLHANDLE          = DWORD($80000021);
  {$EXTERNALSYM LINEERR_INVALCONSULTCALLHANDLE}
  LINEERR_INVALCOUNTRYCODE                = DWORD($80000022);
  {$EXTERNALSYM LINEERR_INVALCOUNTRYCODE}
  LINEERR_INVALDEVICECLASS                = DWORD($80000023);
  {$EXTERNALSYM LINEERR_INVALDEVICECLASS}
  LINEERR_INVALDEVICEHANDLE               = DWORD($80000024);
  {$EXTERNALSYM LINEERR_INVALDEVICEHANDLE}
  LINEERR_INVALDIALPARAMS                 = DWORD($80000025);
  {$EXTERNALSYM LINEERR_INVALDIALPARAMS}
  LINEERR_INVALDIGITLIST                  = DWORD($80000026);
  {$EXTERNALSYM LINEERR_INVALDIGITLIST}
  LINEERR_INVALDIGITMODE                  = DWORD($80000027);
  {$EXTERNALSYM LINEERR_INVALDIGITMODE}
  LINEERR_INVALDIGITS                     = DWORD($80000028);
  {$EXTERNALSYM LINEERR_INVALDIGITS}
  LINEERR_INVALEXTVERSION                 = DWORD($80000029);
  {$EXTERNALSYM LINEERR_INVALEXTVERSION}
  LINEERR_INVALGROUPID                    = DWORD($8000002A);
  {$EXTERNALSYM LINEERR_INVALGROUPID}
  LINEERR_INVALLINEHANDLE                 = DWORD($8000002B);
  {$EXTERNALSYM LINEERR_INVALLINEHANDLE}
  LINEERR_INVALLINESTATE                  = DWORD($8000002C);
  {$EXTERNALSYM LINEERR_INVALLINESTATE}
  LINEERR_INVALLOCATION                   = DWORD($8000002D);
  {$EXTERNALSYM LINEERR_INVALLOCATION}
  LINEERR_INVALMEDIALIST                  = DWORD($8000002E);
  {$EXTERNALSYM LINEERR_INVALMEDIALIST}
  LINEERR_INVALMEDIAMODE                  = DWORD($8000002F);
  {$EXTERNALSYM LINEERR_INVALMEDIAMODE}
  LINEERR_INVALMESSAGEID                  = DWORD($80000030);
  {$EXTERNALSYM LINEERR_INVALMESSAGEID}
  LINEERR_INVALPARAM                      = DWORD($80000032);
  {$EXTERNALSYM LINEERR_INVALPARAM}
  LINEERR_INVALPARKID                     = DWORD($80000033);
  {$EXTERNALSYM LINEERR_INVALPARKID}
  LINEERR_INVALPARKMODE                   = DWORD($80000034);
  {$EXTERNALSYM LINEERR_INVALPARKMODE}
  LINEERR_INVALPOINTER                    = DWORD($80000035);
  {$EXTERNALSYM LINEERR_INVALPOINTER}
  LINEERR_INVALPRIVSELECT                 = DWORD($80000036);
  {$EXTERNALSYM LINEERR_INVALPRIVSELECT}
  LINEERR_INVALRATE                       = DWORD($80000037);
  {$EXTERNALSYM LINEERR_INVALRATE}
  LINEERR_INVALREQUESTMODE                = DWORD($80000038);
  {$EXTERNALSYM LINEERR_INVALREQUESTMODE}
  LINEERR_INVALTERMINALID                 = DWORD($80000039);
  {$EXTERNALSYM LINEERR_INVALTERMINALID}
  LINEERR_INVALTERMINALMODE               = DWORD($8000003A);
  {$EXTERNALSYM LINEERR_INVALTERMINALMODE}
  LINEERR_INVALTIMEOUT                    = DWORD($8000003B);
  {$EXTERNALSYM LINEERR_INVALTIMEOUT}
  LINEERR_INVALTONE                       = DWORD($8000003C);
  {$EXTERNALSYM LINEERR_INVALTONE}
  LINEERR_INVALTONELIST                   = DWORD($8000003D);
  {$EXTERNALSYM LINEERR_INVALTONELIST}
  LINEERR_INVALTONEMODE                   = DWORD($8000003E);
  {$EXTERNALSYM LINEERR_INVALTONEMODE}
  LINEERR_INVALTRANSFERMODE               = DWORD($8000003F);
  {$EXTERNALSYM LINEERR_INVALTRANSFERMODE}
  LINEERR_LINEMAPPERFAILED                = DWORD($80000040);
  {$EXTERNALSYM LINEERR_LINEMAPPERFAILED}
  LINEERR_NOCONFERENCE                    = DWORD($80000041);
  {$EXTERNALSYM LINEERR_NOCONFERENCE}
  LINEERR_NODEVICE                        = DWORD($80000042);
  {$EXTERNALSYM LINEERR_NODEVICE}
  LINEERR_NODRIVER                        = DWORD($80000043);
  {$EXTERNALSYM LINEERR_NODRIVER}
  LINEERR_NOMEM                           = DWORD($80000044);
  {$EXTERNALSYM LINEERR_NOMEM}
  LINEERR_NOREQUEST                       = DWORD($80000045);
  {$EXTERNALSYM LINEERR_NOREQUEST}
  LINEERR_NOTOWNER                        = DWORD($80000046);
  {$EXTERNALSYM LINEERR_NOTOWNER}
  LINEERR_NOTREGISTERED                   = DWORD($80000047);
  {$EXTERNALSYM LINEERR_NOTREGISTERED}
  LINEERR_OPERATIONFAILED                 = DWORD($80000048);
  {$EXTERNALSYM LINEERR_OPERATIONFAILED}
  LINEERR_OPERATIONUNAVAIL                = DWORD($80000049);
  {$EXTERNALSYM LINEERR_OPERATIONUNAVAIL}
  LINEERR_RATEUNAVAIL                     = DWORD($8000004A);
  {$EXTERNALSYM LINEERR_RATEUNAVAIL}
  LINEERR_RESOURCEUNAVAIL                 = DWORD($8000004B);
  {$EXTERNALSYM LINEERR_RESOURCEUNAVAIL}
  LINEERR_REQUESTOVERRUN                  = DWORD($8000004C);
  {$EXTERNALSYM LINEERR_REQUESTOVERRUN}
  LINEERR_STRUCTURETOOSMALL               = DWORD($8000004D);
  {$EXTERNALSYM LINEERR_STRUCTURETOOSMALL}
  LINEERR_TARGETNOTFOUND                  = DWORD($8000004E);
  {$EXTERNALSYM LINEERR_TARGETNOTFOUND}
  LINEERR_TARGETSELF                      = DWORD($8000004F);
  {$EXTERNALSYM LINEERR_TARGETSELF}
  LINEERR_UNINITIALIZED                   = DWORD($80000050);
  {$EXTERNALSYM LINEERR_UNINITIALIZED}
  LINEERR_USERUSERINFOTOOBIG              = DWORD($80000051);
  {$EXTERNALSYM LINEERR_USERUSERINFOTOOBIG}
  LINEERR_REINIT                          = DWORD($80000052);
  {$EXTERNALSYM LINEERR_REINIT}
  LINEERR_ADDRESSBLOCKED                  = DWORD($80000053);
  {$EXTERNALSYM LINEERR_ADDRESSBLOCKED}
  LINEERR_BILLINGREJECTED                 = DWORD($80000054);
  {$EXTERNALSYM LINEERR_BILLINGREJECTED}
  LINEERR_INVALFEATURE                    = DWORD($80000055);
  {$EXTERNALSYM LINEERR_INVALFEATURE}
  LINEERR_NOMULTIPLEINSTANCE              = DWORD($80000056);
  {$EXTERNALSYM LINEERR_NOMULTIPLEINSTANCE}
{$IFDEF TAPI20}
  LINEERR_INVALAGENTID                    = DWORD($80000057);    // TAPI v2.0
  {$EXTERNALSYM LINEERR_INVALAGENTID}
  LINEERR_INVALAGENTGROUP                 = DWORD($80000058);    // TAPI v2.0
  {$EXTERNALSYM LINEERR_INVALAGENTGROUP}
  LINEERR_INVALPASSWORD                   = DWORD($80000059);    // TAPI v2.0
  {$EXTERNALSYM LINEERR_INVALPASSWORD}
  LINEERR_INVALAGENTSTATE                 = DWORD($8000005A);    // TAPI v2.0
  {$EXTERNALSYM LINEERR_INVALAGENTSTATE}
  LINEERR_INVALAGENTACTIVITY              = DWORD($8000005B);    // TAPI v2.0
  {$EXTERNALSYM LINEERR_INVALAGENTACTIVITY}
  LINEERR_DIALVOICEDETECT                 = DWORD($8000005C);    // TAPI v2.0
  {$EXTERNALSYM LINEERR_DIALVOICEDETECT}
{$ENDIF}
{$IFDEF TAPI22}
  LINEERR_USERCANCELLED                   = DWORD($8000005D);    // TAPI v2.2
  {$EXTERNALSYM LINEERR_USERCANCELLED}
{$ENDIF}
{$IFDEF TAPI30}
  LINEERR_INVALADDRESSTYPE                = DWORD($8000005E);    // TAPI v3.0
  {$EXTERNALSYM LINEERR_INVALADDRESSTYPE}
{$ENDIF}
{$IFDEF TAPI22}
  LINEERR_INVALAGENTSESSIONSTATE          = DWORD($8000005F);    // TAPI v2.2
  {$EXTERNALSYM LINEERR_INVALAGENTSESSIONSTATE}
  LINEERR_DISCONNECTED                    = DWORD($80000060);
  {$EXTERNALSYM LINEERR_DISCONNECTED}
{$ENDIF}

  LINEFEATURE_DEVSPECIFIC                 = $00000001;
  {$EXTERNALSYM LINEFEATURE_DEVSPECIFIC}
  LINEFEATURE_DEVSPECIFICFEAT             = $00000002;
  {$EXTERNALSYM LINEFEATURE_DEVSPECIFICFEAT}
  LINEFEATURE_FORWARD                     = $00000004;
  {$EXTERNALSYM LINEFEATURE_FORWARD}
  LINEFEATURE_MAKECALL                    = $00000008;
  {$EXTERNALSYM LINEFEATURE_MAKECALL}
  LINEFEATURE_SETMEDIACONTROL             = $00000010;
  {$EXTERNALSYM LINEFEATURE_SETMEDIACONTROL}
  LINEFEATURE_SETTERMINAL                 = $00000020;
  {$EXTERNALSYM LINEFEATURE_SETTERMINAL}
{$IFDEF TAPI20}
  LINEFEATURE_SETDEVSTATUS                = $00000040;     // TAPI v2.0
  {$EXTERNALSYM LINEFEATURE_SETDEVSTATUS}
  LINEFEATURE_FORWARDFWD                  = $00000080;     // TAPI v2.0
  {$EXTERNALSYM LINEFEATURE_FORWARDFWD}
  LINEFEATURE_FORWARDDND                  = $00000100;     // TAPI v2.0
  {$EXTERNALSYM LINEFEATURE_FORWARDDND}
{$ENDIF}

  LINEFORWARDMODE_UNCOND                  = $00000001;
  {$EXTERNALSYM LINEFORWARDMODE_UNCOND}
  LINEFORWARDMODE_UNCONDINTERNAL          = $00000002;
  {$EXTERNALSYM LINEFORWARDMODE_UNCONDINTERNAL}
  LINEFORWARDMODE_UNCONDEXTERNAL          = $00000004;
  {$EXTERNALSYM LINEFORWARDMODE_UNCONDEXTERNAL}
  LINEFORWARDMODE_UNCONDSPECIFIC          = $00000008;
  {$EXTERNALSYM LINEFORWARDMODE_UNCONDSPECIFIC}
  LINEFORWARDMODE_BUSY                    = $00000010;
  {$EXTERNALSYM LINEFORWARDMODE_BUSY}
  LINEFORWARDMODE_BUSYINTERNAL            = $00000020;
  {$EXTERNALSYM LINEFORWARDMODE_BUSYINTERNAL}
  LINEFORWARDMODE_BUSYEXTERNAL            = $00000040;
  {$EXTERNALSYM LINEFORWARDMODE_BUSYEXTERNAL}
  LINEFORWARDMODE_BUSYSPECIFIC            = $00000080;
  {$EXTERNALSYM LINEFORWARDMODE_BUSYSPECIFIC}
  LINEFORWARDMODE_NOANSW                  = $00000100;
  {$EXTERNALSYM LINEFORWARDMODE_NOANSW}
  LINEFORWARDMODE_NOANSWINTERNAL          = $00000200;
  {$EXTERNALSYM LINEFORWARDMODE_NOANSWINTERNAL}
  LINEFORWARDMODE_NOANSWEXTERNAL          = $00000400;
  {$EXTERNALSYM LINEFORWARDMODE_NOANSWEXTERNAL}
  LINEFORWARDMODE_NOANSWSPECIFIC          = $00000800;
  {$EXTERNALSYM LINEFORWARDMODE_NOANSWSPECIFIC}
  LINEFORWARDMODE_BUSYNA                  = $00001000;
  {$EXTERNALSYM LINEFORWARDMODE_BUSYNA}
  LINEFORWARDMODE_BUSYNAINTERNAL          = $00002000;
  {$EXTERNALSYM LINEFORWARDMODE_BUSYNAINTERNAL}
  LINEFORWARDMODE_BUSYNAEXTERNAL          = $00004000;
  {$EXTERNALSYM LINEFORWARDMODE_BUSYNAEXTERNAL}
  LINEFORWARDMODE_BUSYNASPECIFIC          = $00008000;
  {$EXTERNALSYM LINEFORWARDMODE_BUSYNASPECIFIC}
  LINEFORWARDMODE_UNKNOWN                 = $00010000;     // TAPI v1.4
  {$EXTERNALSYM LINEFORWARDMODE_UNKNOWN}
  LINEFORWARDMODE_UNAVAIL                 = $00020000;     // TAPI v1.4
  {$EXTERNALSYM LINEFORWARDMODE_UNAVAIL}

  LINEGATHERTERM_BUFFERFULL               = $00000001;
  {$EXTERNALSYM LINEGATHERTERM_BUFFERFULL}
  LINEGATHERTERM_TERMDIGIT                = $00000002;
  {$EXTERNALSYM LINEGATHERTERM_TERMDIGIT}
  LINEGATHERTERM_FIRSTTIMEOUT             = $00000004;
  {$EXTERNALSYM LINEGATHERTERM_FIRSTTIMEOUT}
  LINEGATHERTERM_INTERTIMEOUT             = $00000008;
  {$EXTERNALSYM LINEGATHERTERM_INTERTIMEOUT}
  LINEGATHERTERM_CANCEL                   = $00000010;
  {$EXTERNALSYM LINEGATHERTERM_CANCEL}

  LINEGENERATETERM_DONE                   = $00000001;
  {$EXTERNALSYM LINEGENERATETERM_DONE}
  LINEGENERATETERM_CANCEL                 = $00000002;
  {$EXTERNALSYM LINEGENERATETERM_CANCEL}

{$IFDEF TAPI20}
// These constants are mutually exclusive - there's no way to specify more
// than one at a time (and it doesn't make sense, either) so they're
// ordinal rather than bits.

  LINEINITIALIZEEXOPTION_USEHIDDENWINDOW      = $00000001; // TAPI v2.0
  {$EXTERNALSYM LINEINITIALIZEEXOPTION_USEHIDDENWINDOW}
  LINEINITIALIZEEXOPTION_USEEVENT             = $00000002; // TAPI v2.0
  {$EXTERNALSYM LINEINITIALIZEEXOPTION_USEEVENT}
  LINEINITIALIZEEXOPTION_USECOMPLETIONPORT    = $00000003; // TAPI v2.0
  {$EXTERNALSYM LINEINITIALIZEEXOPTION_USECOMPLETIONPORT}
{$ENDIF}

{$IFDEF TAPI30}
  LINEINITIALIZEEXOPTION_CALLHUBTRACKING      = DWORD($80000000); // TAPI v3.0
{$ENDIF}

  LINELOCATIONOPTION_PULSEDIAL            = $00000001;     // TAPI v1.4
  {$EXTERNALSYM LINELOCATIONOPTION_PULSEDIAL}

  LINEMAPPER                              = DWORD($FFFFFFFF);
  {$EXTERNALSYM LINEMAPPER}

  LINEMEDIACONTROL_NONE                   = $00000001;
  {$EXTERNALSYM LINEMEDIACONTROL_NONE}
  LINEMEDIACONTROL_START                  = $00000002;
  {$EXTERNALSYM LINEMEDIACONTROL_START}
  LINEMEDIACONTROL_RESET                  = $00000004;
  {$EXTERNALSYM LINEMEDIACONTROL_RESET}
  LINEMEDIACONTROL_PAUSE                  = $00000008;
  {$EXTERNALSYM LINEMEDIACONTROL_PAUSE}
  LINEMEDIACONTROL_RESUME                 = $00000010;
  {$EXTERNALSYM LINEMEDIACONTROL_RESUME}
  LINEMEDIACONTROL_RATEUP                 = $00000020;
  {$EXTERNALSYM LINEMEDIACONTROL_RATEUP}
  LINEMEDIACONTROL_RATEDOWN               = $00000040;
  {$EXTERNALSYM LINEMEDIACONTROL_RATEDOWN}
  LINEMEDIACONTROL_RATENORMAL             = $00000080;
  {$EXTERNALSYM LINEMEDIACONTROL_RATENORMAL}
  LINEMEDIACONTROL_VOLUMEUP               = $00000100;
  {$EXTERNALSYM LINEMEDIACONTROL_VOLUMEUP}
  LINEMEDIACONTROL_VOLUMEDOWN             = $00000200;
  {$EXTERNALSYM LINEMEDIACONTROL_VOLUMEDOWN}
  LINEMEDIACONTROL_VOLUMENORMAL           = $00000400;
  {$EXTERNALSYM LINEMEDIACONTROL_VOLUMENORMAL}

  LINEMEDIAMODE_UNKNOWN                   = $00000002;
  {$EXTERNALSYM LINEMEDIAMODE_UNKNOWN}
  LINEMEDIAMODE_INTERACTIVEVOICE          = $00000004;
  {$EXTERNALSYM LINEMEDIAMODE_INTERACTIVEVOICE}
  LINEMEDIAMODE_AUTOMATEDVOICE            = $00000008;
  {$EXTERNALSYM LINEMEDIAMODE_AUTOMATEDVOICE}
  LINEMEDIAMODE_DATAMODEM                 = $00000010;
  {$EXTERNALSYM LINEMEDIAMODE_DATAMODEM}
  LINEMEDIAMODE_G3FAX                     = $00000020;
  {$EXTERNALSYM LINEMEDIAMODE_G3FAX}
  LINEMEDIAMODE_TDD                       = $00000040;
  {$EXTERNALSYM LINEMEDIAMODE_TDD}
  LINEMEDIAMODE_G4FAX                     = $00000080;
  {$EXTERNALSYM LINEMEDIAMODE_G4FAX}
  LINEMEDIAMODE_DIGITALDATA               = $00000100;
  {$EXTERNALSYM LINEMEDIAMODE_DIGITALDATA}
  LINEMEDIAMODE_TELETEX                   = $00000200;
  {$EXTERNALSYM LINEMEDIAMODE_TELETEX}
  LINEMEDIAMODE_VIDEOTEX                  = $00000400;
  {$EXTERNALSYM LINEMEDIAMODE_VIDEOTEX}
  LINEMEDIAMODE_TELEX                     = $00000800;
  {$EXTERNALSYM LINEMEDIAMODE_TELEX}
  LINEMEDIAMODE_MIXED                     = $00001000;
  {$EXTERNALSYM LINEMEDIAMODE_MIXED}
  LINEMEDIAMODE_ADSI                      = $00002000;
  {$EXTERNALSYM LINEMEDIAMODE_ADSI}
  LINEMEDIAMODE_VOICEVIEW                 = $00004000;     // TAPI v1.4
  {$EXTERNALSYM LINEMEDIAMODE_VOICEVIEW}
{$IFDEF TAPI21}
  LINEMEDIAMODE_VIDEO                     = $00008000;     {// TAPI v2.1}
  {$EXTERNALSYM LINEMEDIAMODE_VIDEO}
{$ENDIF}
  LAST_LINEMEDIAMODE                      = $00008000;
  {$EXTERNALSYM LAST_LINEMEDIAMODE}

  LINEOFFERINGMODE_ACTIVE                 = $00000001;     // TAPI v1.4
  {$EXTERNALSYM LINEOFFERINGMODE_ACTIVE}
  LINEOFFERINGMODE_INACTIVE               = $00000002;     // TAPI v1.4
  {$EXTERNALSYM LINEOFFERINGMODE_INACTIVE}

{$IFDEF TAPI20}
  LINEOPENOPTION_SINGLEADDRESS            = DWORD($80000000); // TAPI v2.0
  {$EXTERNALSYM LINEOPENOPTION_SINGLEADDRESS}
  LINEOPENOPTION_PROXY                    = $40000000;     // TAPI v2.0
  {$EXTERNALSYM LINEOPENOPTION_PROXY}
{$ENDIF}

  LINEPARKMODE_DIRECTED                   = $00000001;
  {$EXTERNALSYM LINEPARKMODE_DIRECTED}
  LINEPARKMODE_NONDIRECTED                = $00000002;
  {$EXTERNALSYM LINEPARKMODE_NONDIRECTED}

{$IFDEF TAPI20}
  LINEPROXYREQUEST_SETAGENTGROUP          = $00000001;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_SETAGENTGROUP}
  LINEPROXYREQUEST_SETAGENTSTATE          = $00000002;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_SETAGENTSTATE}
  LINEPROXYREQUEST_SETAGENTACTIVITY       = $00000003;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_SETAGENTACTIVITY}
  LINEPROXYREQUEST_GETAGENTCAPS           = $00000004;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_GETAGENTCAPS}
  LINEPROXYREQUEST_GETAGENTSTATUS         = $00000005;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_GETAGENTSTATUS}
  LINEPROXYREQUEST_AGENTSPECIFIC          = $00000006;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_AGENTSPECIFIC}
  LINEPROXYREQUEST_GETAGENTACTIVITYLIST   = $00000007;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_GETAGENTACTIVITYLIST}
  LINEPROXYREQUEST_GETAGENTGROUPLIST      = $00000008;     // TAPI v2.0
  {$EXTERNALSYM LINEPROXYREQUEST_GETAGENTGROUPLIST}
{$ENDIF}

{$IFDEF TAPI22}
  LINEPROXYREQUEST_CREATEAGENT                = $00000009; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_CREATEAGENT}
  LINEPROXYREQUEST_SETAGENTMEASUREMENTPERIOD  = $0000000A; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_SETAGENTMEASUREMENTPERIOD}
  LINEPROXYREQUEST_GETAGENTINFO               = $0000000B; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_GETAGENTINFO}
  LINEPROXYREQUEST_CREATEAGENTSESSION         = $0000000C; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_CREATEAGENTSESSION}
  LINEPROXYREQUEST_GETAGENTSESSIONLIST        = $0000000D; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_GETAGENTSESSIONLIST}
  LINEPROXYREQUEST_SETAGENTSESSIONSTATE       = $0000000E; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_SETAGENTSESSIONSTATE}
  LINEPROXYREQUEST_GETAGENTSESSIONINFO        = $0000000F; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_GETAGENTSESSIONINFO}
  LINEPROXYREQUEST_GETQUEUELIST               = $00000010; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_GETQUEUELIST}
  LINEPROXYREQUEST_SETQUEUEMEASUREMENTPERIOD  = $00000011; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_SETQUEUEMEASUREMENTPERIOD}
  LINEPROXYREQUEST_GETQUEUEINFO               = $00000012; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_GETQUEUEINFO}
  LINEPROXYREQUEST_GETGROUPLIST               = $00000013; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_GETGROUPLIST}
  LINEPROXYREQUEST_SETAGENTSTATEEX            = $00000014; // TAPI v2.2
  {$EXTERNALSYM LINEPROXYREQUEST_SETAGENTSTATEEX}
{$ENDIF}

  LINEREMOVEFROMCONF_NONE                 = $00000001;
  {$EXTERNALSYM LINEREMOVEFROMCONF_NONE}
  LINEREMOVEFROMCONF_LAST                 = $00000002;
  {$EXTERNALSYM LINEREMOVEFROMCONF_LAST}
  LINEREMOVEFROMCONF_ANY                  = $00000003;
  {$EXTERNALSYM LINEREMOVEFROMCONF_ANY}

  LINEREQUESTMODE_MAKECALL                = $00000001;
  {$EXTERNALSYM LINEREQUESTMODE_MAKECALL}
  LINEREQUESTMODE_MEDIACALL               = $00000002;
  {$EXTERNALSYM LINEREQUESTMODE_MEDIACALL}
  LINEREQUESTMODE_DROP                    = $00000004;
  {$EXTERNALSYM LINEREQUESTMODE_DROP}
  LAST_LINEREQUESTMODE                    = LINEREQUESTMODE_MEDIACALL;
  {$EXTERNALSYM LAST_LINEREQUESTMODE}

  LINEROAMMODE_UNKNOWN                    = $00000001;
  {$EXTERNALSYM LINEROAMMODE_UNKNOWN}
  LINEROAMMODE_UNAVAIL                    = $00000002;
  {$EXTERNALSYM LINEROAMMODE_UNAVAIL}
  LINEROAMMODE_HOME                       = $00000004;
  {$EXTERNALSYM LINEROAMMODE_HOME}
  LINEROAMMODE_ROAMA                      = $00000008;
  {$EXTERNALSYM LINEROAMMODE_ROAMA}
  LINEROAMMODE_ROAMB                      = $00000010;
  {$EXTERNALSYM LINEROAMMODE_ROAMB}

  LINESPECIALINFO_NOCIRCUIT               = $00000001;
  {$EXTERNALSYM LINESPECIALINFO_NOCIRCUIT}
  LINESPECIALINFO_CUSTIRREG               = $00000002;
  {$EXTERNALSYM LINESPECIALINFO_CUSTIRREG}
  LINESPECIALINFO_REORDER                 = $00000004;
  {$EXTERNALSYM LINESPECIALINFO_REORDER}
  LINESPECIALINFO_UNKNOWN                 = $00000008;
  {$EXTERNALSYM LINESPECIALINFO_UNKNOWN}
  LINESPECIALINFO_UNAVAIL                 = $00000010;
  {$EXTERNALSYM LINESPECIALINFO_UNAVAIL}

  LINETERMDEV_PHONE                       = $00000001;
  {$EXTERNALSYM LINETERMDEV_PHONE}
  LINETERMDEV_HEADSET                     = $00000002;
  {$EXTERNALSYM LINETERMDEV_HEADSET}
  LINETERMDEV_SPEAKER                     = $00000004;
  {$EXTERNALSYM LINETERMDEV_SPEAKER}

  LINETERMMODE_BUTTONS                    = $00000001;
  {$EXTERNALSYM LINETERMMODE_BUTTONS}
  LINETERMMODE_LAMPS                      = $00000002;
  {$EXTERNALSYM LINETERMMODE_LAMPS}
  LINETERMMODE_DISPLAY                    = $00000004;
  {$EXTERNALSYM LINETERMMODE_DISPLAY}
  LINETERMMODE_RINGER                     = $00000008;
  {$EXTERNALSYM LINETERMMODE_RINGER}
  LINETERMMODE_HOOKSWITCH                 = $00000010;
  {$EXTERNALSYM LINETERMMODE_HOOKSWITCH}
  LINETERMMODE_MEDIATOLINE                = $00000020;
  {$EXTERNALSYM LINETERMMODE_MEDIATOLINE}
  LINETERMMODE_MEDIAFROMLINE              = $00000040;
  {$EXTERNALSYM LINETERMMODE_MEDIAFROMLINE}
  LINETERMMODE_MEDIABIDIRECT              = $00000080;
  {$EXTERNALSYM LINETERMMODE_MEDIABIDIRECT}

  LINETERMSHARING_PRIVATE                 = $00000001;
  {$EXTERNALSYM LINETERMSHARING_PRIVATE}
  LINETERMSHARING_SHAREDEXCL              = $00000002;
  {$EXTERNALSYM LINETERMSHARING_SHAREDEXCL}
  LINETERMSHARING_SHAREDCONF              = $00000004;
  {$EXTERNALSYM LINETERMSHARING_SHAREDCONF}

  LINETOLLLISTOPTION_ADD                  = $00000001;
  {$EXTERNALSYM LINETOLLLISTOPTION_ADD}
  LINETOLLLISTOPTION_REMOVE               = $00000002;
  {$EXTERNALSYM LINETOLLLISTOPTION_REMOVE}

  LINETONEMODE_CUSTOM                     = $00000001;
  {$EXTERNALSYM LINETONEMODE_CUSTOM}
  LINETONEMODE_RINGBACK                   = $00000002;
  {$EXTERNALSYM LINETONEMODE_RINGBACK}
  LINETONEMODE_BUSY                       = $00000004;
  {$EXTERNALSYM LINETONEMODE_BUSY}
  LINETONEMODE_BEEP                       = $00000008;
  {$EXTERNALSYM LINETONEMODE_BEEP}
  LINETONEMODE_BILLING                    = $00000010;
  {$EXTERNALSYM LINETONEMODE_BILLING}

  LINETRANSFERMODE_TRANSFER               = $00000001;
  {$EXTERNALSYM LINETRANSFERMODE_TRANSFER}
  LINETRANSFERMODE_CONFERENCE             = $00000002;
  {$EXTERNALSYM LINETRANSFERMODE_CONFERENCE}

  LINETRANSLATEOPTION_CARDOVERRIDE        = $00000001;
  {$EXTERNALSYM LINETRANSLATEOPTION_CARDOVERRIDE}
  LINETRANSLATEOPTION_CANCELCALLWAITING   = $00000002;     // TAPI v1.4
  {$EXTERNALSYM LINETRANSLATEOPTION_CANCELCALLWAITING}
  LINETRANSLATEOPTION_FORCELOCAL          = $00000004;     // TAPI v1.4
  {$EXTERNALSYM LINETRANSLATEOPTION_FORCELOCAL}
  LINETRANSLATEOPTION_FORCELD             = $00000008;     // TAPI v1.4
  {$EXTERNALSYM LINETRANSLATEOPTION_FORCELD}

  LINETRANSLATERESULT_CANONICAL           = $00000001;
  {$EXTERNALSYM LINETRANSLATERESULT_CANONICAL}
  LINETRANSLATERESULT_INTERNATIONAL       = $00000002;
  {$EXTERNALSYM LINETRANSLATERESULT_INTERNATIONAL}
  LINETRANSLATERESULT_LONGDISTANCE        = $00000004;
  {$EXTERNALSYM LINETRANSLATERESULT_LONGDISTANCE}
  LINETRANSLATERESULT_LOCAL               = $00000008;
  {$EXTERNALSYM LINETRANSLATERESULT_LOCAL}
  LINETRANSLATERESULT_INTOLLLIST          = $00000010;
  {$EXTERNALSYM LINETRANSLATERESULT_INTOLLLIST}
  LINETRANSLATERESULT_NOTINTOLLLIST       = $00000020;
  {$EXTERNALSYM LINETRANSLATERESULT_NOTINTOLLLIST}
  LINETRANSLATERESULT_DIALBILLING         = $00000040;
  {$EXTERNALSYM LINETRANSLATERESULT_DIALBILLING}
  LINETRANSLATERESULT_DIALQUIET           = $00000080;
  {$EXTERNALSYM LINETRANSLATERESULT_DIALQUIET}
  LINETRANSLATERESULT_DIALDIALTONE        = $00000100;
  {$EXTERNALSYM LINETRANSLATERESULT_DIALDIALTONE}
  LINETRANSLATERESULT_DIALPROMPT          = $00000200;
  {$EXTERNALSYM LINETRANSLATERESULT_DIALPROMPT}
{$IFDEF TAPI20}
  LINETRANSLATERESULT_VOICEDETECT         = $00000400;     // TAPI v2.0
  {$EXTERNALSYM LINETRANSLATERESULT_VOICEDETECT}
{$ENDIF}
{$IFDEF TAPI30}
  LINETRANSLATERESULT_NOTRANSLATION       = $00000800;     // TAPI v3.0
  {$EXTERNALSYM LINETRANSLATERESULT_NOTRANSLATION}
{$ENDIF}

  PHONEBUTTONFUNCTION_UNKNOWN             = $00000000;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_UNKNOWN}
  PHONEBUTTONFUNCTION_CONFERENCE          = $00000001;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_CONFERENCE}
  PHONEBUTTONFUNCTION_TRANSFER            = $00000002;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_TRANSFER}
  PHONEBUTTONFUNCTION_DROP                = $00000003;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_DROP}
  PHONEBUTTONFUNCTION_HOLD                = $00000004;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_HOLD}
  PHONEBUTTONFUNCTION_RECALL              = $00000005;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_RECALL}
  PHONEBUTTONFUNCTION_DISCONNECT          = $00000006;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_DISCONNECT}
  PHONEBUTTONFUNCTION_CONNECT             = $00000007;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_CONNECT}
  PHONEBUTTONFUNCTION_MSGWAITON           = $00000008;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_MSGWAITON}
  PHONEBUTTONFUNCTION_MSGWAITOFF          = $00000009;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_MSGWAITOFF}
  PHONEBUTTONFUNCTION_SELECTRING          = $0000000A;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_SELECTRING}
  PHONEBUTTONFUNCTION_ABBREVDIAL          = $0000000B;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_ABBREVDIAL}
  PHONEBUTTONFUNCTION_FORWARD             = $0000000C;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_FORWARD}
  PHONEBUTTONFUNCTION_PICKUP              = $0000000D;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_PICKUP}
  PHONEBUTTONFUNCTION_RINGAGAIN           = $0000000E;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_RINGAGAIN}
  PHONEBUTTONFUNCTION_PARK                = $0000000F;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_PARK}
  PHONEBUTTONFUNCTION_REJECT              = $00000010;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_REJECT}
  PHONEBUTTONFUNCTION_REDIRECT            = $00000011;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_REDIRECT}
  PHONEBUTTONFUNCTION_MUTE                = $00000012;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_MUTE}
  PHONEBUTTONFUNCTION_VOLUMEUP            = $00000013;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_VOLUMEUP}
  PHONEBUTTONFUNCTION_VOLUMEDOWN          = $00000014;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_VOLUMEDOWN}
  PHONEBUTTONFUNCTION_SPEAKERON           = $00000015;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_SPEAKERON}
  PHONEBUTTONFUNCTION_SPEAKEROFF          = $00000016;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_SPEAKEROFF}
  PHONEBUTTONFUNCTION_FLASH               = $00000017;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_FLASH}
  PHONEBUTTONFUNCTION_DATAON              = $00000018;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_DATAON}
  PHONEBUTTONFUNCTION_DATAOFF             = $00000019;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_DATAOFF}
  PHONEBUTTONFUNCTION_DONOTDISTURB        = $0000001A;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_DONOTDISTURB}
  PHONEBUTTONFUNCTION_INTERCOM            = $0000001B;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_INTERCOM}
  PHONEBUTTONFUNCTION_BRIDGEDAPP          = $0000001C;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_BRIDGEDAPP}
  PHONEBUTTONFUNCTION_BUSY                = $0000001D;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_BUSY}
  PHONEBUTTONFUNCTION_CALLAPP             = $0000001E;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_CALLAPP}
  PHONEBUTTONFUNCTION_DATETIME            = $0000001F;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_DATETIME}
  PHONEBUTTONFUNCTION_DIRECTORY           = $00000020;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_DIRECTORY}
  PHONEBUTTONFUNCTION_COVER               = $00000021;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_COVER}
  PHONEBUTTONFUNCTION_CALLID              = $00000022;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_CALLID}
  PHONEBUTTONFUNCTION_LASTNUM             = $00000023;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_LASTNUM}
  PHONEBUTTONFUNCTION_NIGHTSRV            = $00000024;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_NIGHTSRV}
  PHONEBUTTONFUNCTION_SENDCALLS           = $00000025;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_SENDCALLS}
  PHONEBUTTONFUNCTION_MSGINDICATOR        = $00000026;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_MSGINDICATOR}
  PHONEBUTTONFUNCTION_REPDIAL             = $00000027;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_REPDIAL}
  PHONEBUTTONFUNCTION_SETREPDIAL          = $00000028;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_SETREPDIAL}
  PHONEBUTTONFUNCTION_SYSTEMSPEED         = $00000029;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_SYSTEMSPEED}
  PHONEBUTTONFUNCTION_STATIONSPEED        = $0000002A;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_STATIONSPEED}
  PHONEBUTTONFUNCTION_CAMPON              = $0000002B;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_CAMPON}
  PHONEBUTTONFUNCTION_SAVEREPEAT          = $0000002C;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_SAVEREPEAT}
  PHONEBUTTONFUNCTION_QUEUECALL           = $0000002D;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_QUEUECALL}
  PHONEBUTTONFUNCTION_NONE                = $0000002E;
  {$EXTERNALSYM PHONEBUTTONFUNCTION_NONE}

  PHONEBUTTONMODE_DUMMY                   = $00000001;
  {$EXTERNALSYM PHONEBUTTONMODE_DUMMY}
  PHONEBUTTONMODE_CALL                    = $00000002;
  {$EXTERNALSYM PHONEBUTTONMODE_CALL}
  PHONEBUTTONMODE_FEATURE                 = $00000004;
  {$EXTERNALSYM PHONEBUTTONMODE_FEATURE}
  PHONEBUTTONMODE_KEYPAD                  = $00000008;
  {$EXTERNALSYM PHONEBUTTONMODE_KEYPAD}
  PHONEBUTTONMODE_LOCAL                   = $00000010;
  {$EXTERNALSYM PHONEBUTTONMODE_LOCAL}
  PHONEBUTTONMODE_DISPLAY                 = $00000020;
  {$EXTERNALSYM PHONEBUTTONMODE_DISPLAY}

  PHONEBUTTONSTATE_UP                     = $00000001;
  {$EXTERNALSYM PHONEBUTTONSTATE_UP}
  PHONEBUTTONSTATE_DOWN                   = $00000002;
  {$EXTERNALSYM PHONEBUTTONSTATE_DOWN}
  PHONEBUTTONSTATE_UNKNOWN                = $00000004;     // TAPI v1.4
  {$EXTERNALSYM PHONEBUTTONSTATE_UNKNOWN}
  PHONEBUTTONSTATE_UNAVAIL                = $00000008;     // TAPI v1.4
  {$EXTERNALSYM PHONEBUTTONSTATE_UNAVAIL}

  PHONEERR_ALLOCATED                      = DWORD($90000001);
  {$EXTERNALSYM PHONEERR_ALLOCATED}
  PHONEERR_BADDEVICEID                    = DWORD($90000002);
  {$EXTERNALSYM PHONEERR_BADDEVICEID}
  PHONEERR_INCOMPATIBLEAPIVERSION         = DWORD($90000003);
  {$EXTERNALSYM PHONEERR_INCOMPATIBLEAPIVERSION}
  PHONEERR_INCOMPATIBLEEXTVERSION         = DWORD($90000004);
  {$EXTERNALSYM PHONEERR_INCOMPATIBLEEXTVERSION}
  PHONEERR_INIFILECORRUPT                 = DWORD($90000005);
  {$EXTERNALSYM PHONEERR_INIFILECORRUPT}
  PHONEERR_INUSE                          = DWORD($90000006);
  {$EXTERNALSYM PHONEERR_INUSE}
  PHONEERR_INVALAPPHANDLE                 = DWORD($90000007);
  {$EXTERNALSYM PHONEERR_INVALAPPHANDLE}
  PHONEERR_INVALAPPNAME                   = DWORD($90000008);
  {$EXTERNALSYM PHONEERR_INVALAPPNAME}
  PHONEERR_INVALBUTTONLAMPID              = DWORD($90000009);
  {$EXTERNALSYM PHONEERR_INVALBUTTONLAMPID}
  PHONEERR_INVALBUTTONMODE                = DWORD($9000000A);
  {$EXTERNALSYM PHONEERR_INVALBUTTONMODE}
  PHONEERR_INVALBUTTONSTATE               = DWORD($9000000B);
  {$EXTERNALSYM PHONEERR_INVALBUTTONSTATE}
  PHONEERR_INVALDATAID                    = DWORD($9000000C);
  {$EXTERNALSYM PHONEERR_INVALDATAID}
  PHONEERR_INVALDEVICECLASS               = DWORD($9000000D);
  {$EXTERNALSYM PHONEERR_INVALDEVICECLASS}
  PHONEERR_INVALEXTVERSION                = DWORD($9000000E);
  {$EXTERNALSYM PHONEERR_INVALEXTVERSION}
  PHONEERR_INVALHOOKSWITCHDEV             = DWORD($9000000F);
  {$EXTERNALSYM PHONEERR_INVALHOOKSWITCHDEV}
  PHONEERR_INVALHOOKSWITCHMODE            = DWORD($90000010);
  {$EXTERNALSYM PHONEERR_INVALHOOKSWITCHMODE}
  PHONEERR_INVALLAMPMODE                  = DWORD($90000011);
  {$EXTERNALSYM PHONEERR_INVALLAMPMODE}
  PHONEERR_INVALPARAM                     = DWORD($90000012);
  {$EXTERNALSYM PHONEERR_INVALPARAM}
  PHONEERR_INVALPHONEHANDLE               = DWORD($90000013);
  {$EXTERNALSYM PHONEERR_INVALPHONEHANDLE}
  PHONEERR_INVALPHONESTATE                = DWORD($90000014);
  {$EXTERNALSYM PHONEERR_INVALPHONESTATE}
  PHONEERR_INVALPOINTER                   = DWORD($90000015);
  {$EXTERNALSYM PHONEERR_INVALPOINTER}
  PHONEERR_INVALPRIVILEGE                 = DWORD($90000016);
  {$EXTERNALSYM PHONEERR_INVALPRIVILEGE}
  PHONEERR_INVALRINGMODE                  = DWORD($90000017);
  {$EXTERNALSYM PHONEERR_INVALRINGMODE}
  PHONEERR_NODEVICE                       = DWORD($90000018);
  {$EXTERNALSYM PHONEERR_NODEVICE}
  PHONEERR_NODRIVER                       = DWORD($90000019);
  {$EXTERNALSYM PHONEERR_NODRIVER}
  PHONEERR_NOMEM                          = DWORD($9000001A);
  {$EXTERNALSYM PHONEERR_NOMEM}
  PHONEERR_NOTOWNER                       = DWORD($9000001B);
  {$EXTERNALSYM PHONEERR_NOTOWNER}
  PHONEERR_OPERATIONFAILED                = DWORD($9000001C);
  {$EXTERNALSYM PHONEERR_OPERATIONFAILED}
  PHONEERR_OPERATIONUNAVAIL               = DWORD($9000001D);
  {$EXTERNALSYM PHONEERR_OPERATIONUNAVAIL}
  PHONEERR_RESOURCEUNAVAIL                = DWORD($9000001F);
  {$EXTERNALSYM PHONEERR_RESOURCEUNAVAIL}
  PHONEERR_REQUESTOVERRUN                 = DWORD($90000020);
  {$EXTERNALSYM PHONEERR_REQUESTOVERRUN}
  PHONEERR_STRUCTURETOOSMALL              = DWORD($90000021);
  {$EXTERNALSYM PHONEERR_STRUCTURETOOSMALL}
  PHONEERR_UNINITIALIZED                  = DWORD($90000022);
  {$EXTERNALSYM PHONEERR_UNINITIALIZED}
  PHONEERR_REINIT                         = DWORD($90000023);
  {$EXTERNALSYM PHONEERR_REINIT}
  PHONEERR_DISCONNECTED                   = DWORD($90000024);
  {$EXTERNALSYM PHONEERR_DISCONNECTED}

{$IFDEF TAPI20}
  PHONEFEATURE_GETBUTTONINFO              = $00000001;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETBUTTONINFO}
  PHONEFEATURE_GETDATA                    = $00000002;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETDATA}
  PHONEFEATURE_GETDISPLAY                 = $00000004;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETDISPLAY}
  PHONEFEATURE_GETGAINHANDSET             = $00000008;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETGAINHANDSET}
  PHONEFEATURE_GETGAINSPEAKER             = $00000010;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETGAINSPEAKER}
  PHONEFEATURE_GETGAINHEADSET             = $00000020;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETGAINHEADSET}
  PHONEFEATURE_GETHOOKSWITCHHANDSET       = $00000040;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETHOOKSWITCHHANDSET}
  PHONEFEATURE_GETHOOKSWITCHSPEAKER       = $00000080;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETHOOKSWITCHSPEAKER}
  PHONEFEATURE_GETHOOKSWITCHHEADSET       = $00000100;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETHOOKSWITCHHEADSET}
  PHONEFEATURE_GETLAMP                    = $00000200;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETLAMP}
  PHONEFEATURE_GETRING                    = $00000400;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETRING}
  PHONEFEATURE_GETVOLUMEHANDSET           = $00000800;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETVOLUMEHANDSET}
  PHONEFEATURE_GETVOLUMESPEAKER           = $00001000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETVOLUMESPEAKER}
  PHONEFEATURE_GETVOLUMEHEADSET           = $00002000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_GETVOLUMEHEADSET}
  PHONEFEATURE_SETBUTTONINFO              = $00004000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETBUTTONINFO}
  PHONEFEATURE_SETDATA                    = $00008000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETDATA}
  PHONEFEATURE_SETDISPLAY                 = $00010000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETDISPLAY}
  PHONEFEATURE_SETGAINHANDSET             = $00020000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETGAINHANDSET}
  PHONEFEATURE_SETGAINSPEAKER             = $00040000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETGAINSPEAKER}
  PHONEFEATURE_SETGAINHEADSET             = $00080000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETGAINHEADSET}
  PHONEFEATURE_SETHOOKSWITCHHANDSET       = $00100000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETHOOKSWITCHHANDSET}
  PHONEFEATURE_SETHOOKSWITCHSPEAKER       = $00200000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETHOOKSWITCHSPEAKER}
  PHONEFEATURE_SETHOOKSWITCHHEADSET       = $00400000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETHOOKSWITCHHEADSET}
  PHONEFEATURE_SETLAMP                    = $00800000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETLAMP}
  PHONEFEATURE_SETRING                    = $01000000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETRING}
  PHONEFEATURE_SETVOLUMEHANDSET           = $02000000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETVOLUMEHANDSET}
  PHONEFEATURE_SETVOLUMESPEAKER           = $04000000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETVOLUMESPEAKER}
  PHONEFEATURE_SETVOLUMEHEADSET           = $08000000;     // TAPI v2.0
  {$EXTERNALSYM PHONEFEATURE_SETVOLUMEHEADSET}
{$ENDIF}

  PHONEHOOKSWITCHDEV_HANDSET              = $00000001;
  {$EXTERNALSYM PHONEHOOKSWITCHDEV_HANDSET}
  PHONEHOOKSWITCHDEV_SPEAKER              = $00000002;
  {$EXTERNALSYM PHONEHOOKSWITCHDEV_SPEAKER}
  PHONEHOOKSWITCHDEV_HEADSET              = $00000004;
  {$EXTERNALSYM PHONEHOOKSWITCHDEV_HEADSET}

  PHONEHOOKSWITCHMODE_ONHOOK              = $00000001;
  {$EXTERNALSYM PHONEHOOKSWITCHMODE_ONHOOK}
  PHONEHOOKSWITCHMODE_MIC                 = $00000002;
  {$EXTERNALSYM PHONEHOOKSWITCHMODE_MIC}
  PHONEHOOKSWITCHMODE_SPEAKER             = $00000004;
  {$EXTERNALSYM PHONEHOOKSWITCHMODE_SPEAKER}
  PHONEHOOKSWITCHMODE_MICSPEAKER          = $00000008;
  {$EXTERNALSYM PHONEHOOKSWITCHMODE_MICSPEAKER}
  PHONEHOOKSWITCHMODE_UNKNOWN             = $00000010;
  {$EXTERNALSYM PHONEHOOKSWITCHMODE_UNKNOWN}

{$IFDEF TAPI20}
  PHONEINITIALIZEEXOPTION_USEHIDDENWINDOW     = $00000001;  // TAPI v2.0
  {$EXTERNALSYM PHONEINITIALIZEEXOPTION_USEHIDDENWINDOW}
  PHONEINITIALIZEEXOPTION_USEEVENT            = $00000002;  // TAPI v2.0
  {$EXTERNALSYM PHONEINITIALIZEEXOPTION_USEEVENT}
  PHONEINITIALIZEEXOPTION_USECOMPLETIONPORT   = $00000003;  // TAPI v2.0
  {$EXTERNALSYM PHONEINITIALIZEEXOPTION_USECOMPLETIONPORT}
{$ENDIF}

  PHONELAMPMODE_DUMMY                     = $00000001;
  {$EXTERNALSYM PHONELAMPMODE_DUMMY}
  PHONELAMPMODE_OFF                       = $00000002;
  {$EXTERNALSYM PHONELAMPMODE_OFF}
  PHONELAMPMODE_STEADY                    = $00000004;
  {$EXTERNALSYM PHONELAMPMODE_STEADY}
  PHONELAMPMODE_WINK                      = $00000008;
  {$EXTERNALSYM PHONELAMPMODE_WINK}
  PHONELAMPMODE_FLASH                     = $00000010;
  {$EXTERNALSYM PHONELAMPMODE_FLASH}
  PHONELAMPMODE_FLUTTER                   = $00000020;
  {$EXTERNALSYM PHONELAMPMODE_FLUTTER}
  PHONELAMPMODE_BROKENFLUTTER             = $00000040;
  {$EXTERNALSYM PHONELAMPMODE_BROKENFLUTTER}
  PHONELAMPMODE_UNKNOWN                   = $00000080;
  {$EXTERNALSYM PHONELAMPMODE_UNKNOWN}

  PHONEPRIVILEGE_MONITOR                  = $00000001;
  {$EXTERNALSYM PHONEPRIVILEGE_MONITOR}
  PHONEPRIVILEGE_OWNER                    = $00000002;
  {$EXTERNALSYM PHONEPRIVILEGE_OWNER}

  PHONESTATE_OTHER                        = $00000001;
  {$EXTERNALSYM PHONESTATE_OTHER}
  PHONESTATE_CONNECTED                    = $00000002;
  {$EXTERNALSYM PHONESTATE_CONNECTED}
  PHONESTATE_DISCONNECTED                 = $00000004;
  {$EXTERNALSYM PHONESTATE_DISCONNECTED}
  PHONESTATE_OWNER                        = $00000008;
  {$EXTERNALSYM PHONESTATE_OWNER}
  PHONESTATE_MONITORS                     = $00000010;
  {$EXTERNALSYM PHONESTATE_MONITORS}
  PHONESTATE_DISPLAY                      = $00000020;
  {$EXTERNALSYM PHONESTATE_DISPLAY}
  PHONESTATE_LAMP                         = $00000040;
  {$EXTERNALSYM PHONESTATE_LAMP}
  PHONESTATE_RINGMODE                     = $00000080;
  {$EXTERNALSYM PHONESTATE_RINGMODE}
  PHONESTATE_RINGVOLUME                   = $00000100;
  {$EXTERNALSYM PHONESTATE_RINGVOLUME}
  PHONESTATE_HANDSETHOOKSWITCH            = $00000200;
  {$EXTERNALSYM PHONESTATE_HANDSETHOOKSWITCH}
  PHONESTATE_HANDSETVOLUME                = $00000400;
  {$EXTERNALSYM PHONESTATE_HANDSETVOLUME}
  PHONESTATE_HANDSETGAIN                  = $00000800;
  {$EXTERNALSYM PHONESTATE_HANDSETGAIN}
  PHONESTATE_SPEAKERHOOKSWITCH            = $00001000;
  {$EXTERNALSYM PHONESTATE_SPEAKERHOOKSWITCH}
  PHONESTATE_SPEAKERVOLUME                = $00002000;
  {$EXTERNALSYM PHONESTATE_SPEAKERVOLUME}
  PHONESTATE_SPEAKERGAIN                  = $00004000;
  {$EXTERNALSYM PHONESTATE_SPEAKERGAIN}
  PHONESTATE_HEADSETHOOKSWITCH            = $00008000;
  {$EXTERNALSYM PHONESTATE_HEADSETHOOKSWITCH}
  PHONESTATE_HEADSETVOLUME                = $00010000;
  {$EXTERNALSYM PHONESTATE_HEADSETVOLUME}
  PHONESTATE_HEADSETGAIN                  = $00020000;
  {$EXTERNALSYM PHONESTATE_HEADSETGAIN}
  PHONESTATE_SUSPEND                      = $00040000;
  {$EXTERNALSYM PHONESTATE_SUSPEND}
  PHONESTATE_RESUME                       = $00080000;
  {$EXTERNALSYM PHONESTATE_RESUME}
  PHONESTATE_DEVSPECIFIC                  = $00100000;
  {$EXTERNALSYM PHONESTATE_DEVSPECIFIC}
  PHONESTATE_REINIT                       = $00200000;
  {$EXTERNALSYM PHONESTATE_REINIT}
  PHONESTATE_CAPSCHANGE                   = $00400000;     // TAPI v1.4
  {$EXTERNALSYM PHONESTATE_CAPSCHANGE}
  PHONESTATE_REMOVED                      = $00800000;     // TAPI v1.4
  {$EXTERNALSYM PHONESTATE_REMOVED}

  PHONESTATUSFLAGS_CONNECTED              = $00000001;
  {$EXTERNALSYM PHONESTATUSFLAGS_CONNECTED}
  PHONESTATUSFLAGS_SUSPENDED              = $00000002;
  {$EXTERNALSYM PHONESTATUSFLAGS_SUSPENDED}

  STRINGFORMAT_ASCII                      = $00000001;
  {$EXTERNALSYM STRINGFORMAT_ASCII}
  STRINGFORMAT_DBCS                       = $00000002;
  {$EXTERNALSYM STRINGFORMAT_DBCS}
  STRINGFORMAT_UNICODE                    = $00000003;
  {$EXTERNALSYM STRINGFORMAT_UNICODE}
  STRINGFORMAT_BINARY                     = $00000004;
  {$EXTERNALSYM STRINGFORMAT_BINARY}

  TAPI_REPLY                              = WM_USER + 99;
  {$EXTERNALSYM TAPI_REPLY}

  TAPIERR_CONNECTED                       = 0;
  {$EXTERNALSYM TAPIERR_CONNECTED}
  TAPIERR_DROPPED                         = -1;
  {$EXTERNALSYM TAPIERR_DROPPED}
  TAPIERR_NOREQUESTRECIPIENT              = -2;
  {$EXTERNALSYM TAPIERR_NOREQUESTRECIPIENT}
  TAPIERR_REQUESTQUEUEFULL                = -3;
  {$EXTERNALSYM TAPIERR_REQUESTQUEUEFULL}
  TAPIERR_INVALDESTADDRESS                = -4;
  {$EXTERNALSYM TAPIERR_INVALDESTADDRESS}
  TAPIERR_INVALWINDOWHANDLE               = -5;
  {$EXTERNALSYM TAPIERR_INVALWINDOWHANDLE}
  TAPIERR_INVALDEVICECLASS                = -6;
  {$EXTERNALSYM TAPIERR_INVALDEVICECLASS}
  TAPIERR_INVALDEVICEID                   = -7;
  {$EXTERNALSYM TAPIERR_INVALDEVICEID}
  TAPIERR_DEVICECLASSUNAVAIL              = -8;
  {$EXTERNALSYM TAPIERR_DEVICECLASSUNAVAIL}
  TAPIERR_DEVICEIDUNAVAIL                 = -9;
  {$EXTERNALSYM TAPIERR_DEVICEIDUNAVAIL}
  TAPIERR_DEVICEINUSE                     = -10;
  {$EXTERNALSYM TAPIERR_DEVICEINUSE}
  TAPIERR_DESTBUSY                        = -11;
  {$EXTERNALSYM TAPIERR_DESTBUSY}
  TAPIERR_DESTNOANSWER                    = -12;
  {$EXTERNALSYM TAPIERR_DESTNOANSWER}
  TAPIERR_DESTUNAVAIL                     = -13;
  {$EXTERNALSYM TAPIERR_DESTUNAVAIL}
  TAPIERR_UNKNOWNWINHANDLE                = -14;
  {$EXTERNALSYM TAPIERR_UNKNOWNWINHANDLE}
  TAPIERR_UNKNOWNREQUESTID                = -15;
  {$EXTERNALSYM TAPIERR_UNKNOWNREQUESTID}
  TAPIERR_REQUESTFAILED                   = -16;
  {$EXTERNALSYM TAPIERR_REQUESTFAILED}
  TAPIERR_REQUESTCANCELLED                = -17;
  {$EXTERNALSYM TAPIERR_REQUESTCANCELLED}
  TAPIERR_INVALPOINTER                    = -18;
  {$EXTERNALSYM TAPIERR_INVALPOINTER}
  TAPIERR_NOTADMIN                        = -19;
  {$EXTERNALSYM TAPIERR_NOTADMIN}

  TAPIMAXDESTADDRESSSIZE                  = 80;
  {$EXTERNALSYM TAPIMAXDESTADDRESSSIZE}
  TAPIMAXAPPNAMESIZE                      = 40;
  {$EXTERNALSYM TAPIMAXAPPNAMESIZE}
  TAPIMAXCALLEDPARTYSIZE                  = 40;
  {$EXTERNALSYM TAPIMAXCALLEDPARTYSIZE}
  TAPIMAXCOMMENTSIZE                      = 80;
  {$EXTERNALSYM TAPIMAXCOMMENTSIZE}
  TAPIMAXDEVICECLASSSIZE                  = 40;
  {$EXTERNALSYM TAPIMAXDEVICECLASSSIZE}
  TAPIMAXDEVICEIDSIZE                     = 40;
  {$EXTERNALSYM TAPIMAXDEVICEIDSIZE}

type
  PLineAddressCaps = ^TLineAddressCaps;
  lineaddresscaps_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwLineDeviceID,
    dwAddressSize,
    dwAddressOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset,
    dwAddressSharing,
    dwAddressStates,
    dwCallInfoStates,
    dwCallerIDFlags,
    dwCalledIDFlags,
    dwConnectedIDFlags,
    dwRedirectionIDFlags,
    dwRedirectingIDFlags,
    dwCallStates,
    dwDialToneModes,
    dwBusyModes,
    dwSpecialInfo,
    dwDisconnectModes,
    dwMaxNumActiveCalls,
    dwMaxNumOnHoldCalls,
    dwMaxNumOnHoldPendingCalls,
    dwMaxNumConference,
    dwMaxNumTransConf,
    dwAddrCapFlags,
    dwCallFeatures,
    dwRemoveFromConfCaps,
    dwRemoveFromConfState,
    dwTransferModes,
    dwParkModes,
    dwForwardModes,
    dwMaxForwardEntries,
    dwMaxSpecificEntries,
    dwMinFwdNumRings,
    dwMaxFwdNumRings,
    dwMaxCallCompletions,
    dwCallCompletionConds,
    dwCallCompletionModes,
    dwNumCompletionMessages,
    dwCompletionMsgTextEntrySize,
    dwCompletionMsgTextSize,
    dwCompletionMsgTextOffset,
    dwAddressFeatures: DWORD;                            // TAPI v1.4
{$IFDEF TAPI20}
    dwPredictiveAutoTransferStates,                      // TAPI v2.0
    dwNumCallTreatments,                                 // TAPI v2.0
    dwCallTreatmentListSize,                             // TAPI v2.0
    dwCallTreatmentListOffset,                           // TAPI v2.0
    dwDeviceClassesSize,                                 // TAPI v2.0
    dwDeviceClassesOffset,                               // TAPI v2.0
    dwMaxCallDataSize,                                   // TAPI v2.0
    dwCallFeatures2,                                     // TAPI v2.0
    dwMaxNoAnswerTimeout,                                // TAPI v2.0
    dwConnectedModes,                                    // TAPI v2.0
    dwOfferingModes,                                     // TAPI v2.0
    dwAvailableMediaModes: DWORD;                        // TAPI v2.0
{$ENDIF}
  end;
  {$EXTERNALSYM lineaddresscaps_tag}
  TLineAddressCaps = lineaddresscaps_tag;
  LINEADDRESSCAPS = lineaddresscaps_tag;
  {$EXTERNALSYM LINEADDRESSCAPS}

  PLineAddressStatus = ^TLineAddressStatus;
  lineaddressstatus_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwNumInUse,
    dwNumActiveCalls,
    dwNumOnHoldCalls,
    dwNumOnHoldPendCalls,
    dwAddressFeatures,
    dwNumRingsNoAnswer,
    dwForwardNumEntries,
    dwForwardSize,
    dwForwardOffset,
    dwTerminalModesSize,
    dwTerminalModesOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: DWORD;
  end;
  {$EXTERNALSYM lineaddressstatus_tag}
  TLineAddressStatus = lineaddressstatus_tag;
  LINEADDRESSSTATUS = lineaddressstatus_tag;
  {$EXTERNALSYM LINEADDRESSSTATUS}

{$IFDEF TAPI20}
  PLineAgentActivityEntry = ^TLineAgentActivityEntry;
  lineagentactivityentry_tag = packed record
    dwID,                                                // TAPI v2.0
    dwNameSize,                                          // TAPI v2.0
    dwNameOffset: DWORD;                                 // TAPI v2.0
  end;
  {$EXTERNALSYM lineagentactivityentry_tag}
  TLineAgentActivityEntry = lineagentactivityentry_tag;
  LINEAGENTACTIVITYENTRY = lineagentactivityentry_tag;
  {$EXTERNALSYM LINEAGENTACTIVITYENTRY}

  PLineAgentActivityList = ^TLineAgentActivityList;
  lineagentactivitylist_tag = packed record
    dwTotalSize,                                         // TAPI v2.0
    dwNeededSize,                                        // TAPI v2.0
    dwUsedSize,                                          // TAPI v2.0
    dwNumEntries,                                        // TAPI v2.0
    dwListSize,                                          // TAPI v2.0
    dwListOffset: DWORD;                                 // TAPI v2.0
  end;
  {$EXTERNALSYM lineagentactivitylist_tag}
  TLineAgentActivityList = lineagentactivitylist_tag;
  LINEAGENTACTIVITYLIST = lineagentactivitylist_tag;
  {$EXTERNALSYM LINEAGENTACTIVITYLIST}

  PLineAgentCaps = ^TLineAgentCaps;
  lineagentcaps_tag = packed record
    dwTotalSize,                                         // TAPI v2.0
    dwNeededSize,                                        // TAPI v2.0
    dwUsedSize,                                          // TAPI v2.0
    dwAgentHandlerInfoSize,                              // TAPI v2.0
    dwAgentHandlerInfoOffset,                            // TAPI v2.0
    dwCapsVersion,                                       // TAPI v2.0
    dwFeatures,                                          // TAPI v2.0
    dwStates,                                            // TAPI v2.0
    dwNextStates,                                        // TAPI v2.0
    dwMaxNumGroupEntries,                                // TAPI v2.0
    dwAgentStatusMessages,                               // TAPI v2.0
    dwNumAgentExtensionIDs,                              // TAPI v2.0
    dwAgentExtensionIDListSize,                          // TAPI v2.0
    dwAgentExtensionIDListOffset: DWORD;                 // TAPI v2.0
{$IFDEF TAPI22}
    ProxyGUID: TGUID;                                    // TAPI v2.2
{$ENDIF}
  end;
  {$EXTERNALSYM lineagentcaps_tag}
  TLineAgentCaps = lineagentcaps_tag;
  LINEAGENTCAPS = lineagentcaps_tag;
  {$EXTERNALSYM LINEAGENTCAPS}

  PLineAgentGroupEntry = ^TLineAgentGroupEntry;
  lineagentgroupentry_tag = packed record
    GroupID : record
      dwGroupID1,                                      // TAPI v2.0
      dwGroupID2,                                      // TAPI v2.0
      dwGroupID3,                                      // TAPI v2.0
      dwGroupID4: DWORD;                               // TAPI v2.0
    end;
    dwNameSize,                                        // TAPI v2.0
    dwNameOffset: DWORD;                               // TAPI v2.0
  end;
  {$EXTERNALSYM lineagentgroupentry_tag}
  TLineAgentGroupEntry = lineagentgroupentry_tag;
  LINEAGENTGROUPENTRY = lineagentgroupentry_tag;
  {$EXTERNALSYM LINEAGENTGROUPENTRY}

  PLineAgentGroupList = ^TLineAgentGroupList;
  lineagentgrouplist_tag = packed record
    dwTotalSize,                                         // TAPI v2.0
    dwNeededSize,                                        // TAPI v2.0
    dwUsedSize,                                          // TAPI v2.0
    dwNumEntries,                                        // TAPI v2.0
    dwListSize,                                          // TAPI v2.0
    dwListOffset: DWORD;                                 // TAPI v2.0
  end;
  {$EXTERNALSYM lineagentgrouplist_tag}
  TLineAgentGroupList = lineagentgrouplist_tag;
  LINEAGENTGROUPLIST = lineagentgrouplist_tag;
  {$EXTERNALSYM LINEAGENTGROUPLIST}

  PLineAgentStatus = ^TLineAgentStatus;
  lineagentstatus_tag = packed record
    dwTotalSize,                                         // TAPI v2.0
    dwNeededSize,                                        // TAPI v2.0
    dwUsedSize,                                          // TAPI v2.0
    dwNumEntries,                                        // TAPI v2.0
    dwGroupListSize,                                     // TAPI v2.0
    dwGroupListOffset,                                   // TAPI v2.0
    dwState,                                             // TAPI v2.0
    dwNextState,                                         // TAPI v2.0
    dwActivityID,                                        // TAPI v2.0
    dwActivitySize,                                      // TAPI v2.0
    dwActivityOffset,                                    // TAPI v2.0
    dwAgentFeatures,                                     // TAPI v2.0
    dwValidStates,                                       // TAPI v2.0
    dwValidNextStates: DWORD;                            // TAPI v2.0
  end;
  {$EXTERNALSYM lineagentstatus_tag}
  TLineAgentStatus = lineagentstatus_tag;
  LINEAGENTSTATUS = lineagentstatus_tag;
  {$EXTERNALSYM LINEAGENTSTATUS}

  PLineAppInfo = ^TLineAppInfo;
  lineappinfo_tag = packed record
    dwMachineNameSize,                                   // TAPI v2.0
    dwMachineNameOffset,                                 // TAPI v2.0
    dwUserNameSize,                                      // TAPI v2.0
    dwUserNameOffset,                                    // TAPI v2.0
    dwModuleFilenameSize,                                // TAPI v2.0
    dwModuleFilenameOffset,                              // TAPI v2.0
    dwFriendlyNameSize,                                  // TAPI v2.0
    dwFriendlyNameOffset,                                // TAPI v2.0
    dwMediaModes,                                        // TAPI v2.0
    dwAddressID: DWORD;                                  // TAPI v2.0
  end;
  {$EXTERNALSYM lineappinfo_tag}
  TLineAppInfo = lineappinfo_tag;
  LINEAPPINFO = lineappinfo_tag;
  {$EXTERNALSYM LINEAPPINFO}
{$ENDIF}

{$IFDEF TAPI22}
  PLineAgentEntry = ^TLineAgentEntry;
  lineagententry_tag = packed record
    hAgent: HAGENT;                                      // TAPI v2.2
    dwNameSize,                                          // TAPI v2.2
    dwNameOffset,                                        // TAPI v2.2
    dwIDSize,                                            // TAPI v2.2
    dwIDOffset,                                          // TAPI v2.2
    dwPINSize,                                           // TAPI v2.2
    dwPINOffset: DWORD;                                  // TAPI v2.2
  end;
  {$EXTERNALSYM lineagententry_tag}
  TLineAgentEntry = lineagententry_tag;
  LINEAGENTENTRY = lineagententry_tag;
  {$EXTERNALSYM LINEAGENTENTRY}

  PLineAgentList = ^TLineAgentList;
  lineagentlist_tag = packed record
    dwTotalSize,                                        // TAPI v2.2
    dwNeededSize,                                       // TAPI v2.2
    dwUsedSize,                                         // TAPI v2.2
    dwNumEntries,                                       // TAPI v2.2
    dwListSize,                                         // TAPI v2.2
    dwListOffset: DWORD;                                // TAPI v2.2
  end;
  {$EXTERNALSYM lineagentlist_tag}
  TLineAgentList = lineagentlist_tag;
  LINEAGENTLIST = lineagentlist_tag;
  {$EXTERNALSYM LINEAGENTLIST}

  PLineAgentInfo = ^TLineAgentInfo;
  lineagentinfo_tag = packed record
    dwTotalSize,                                        // TAPI v2.2
    dwNeededSize,                                       // TAPI v2.2
    dwUsedSize,                                         // TAPI v2.2
    dwAgentState,                                       // TAPI v2.2
    dwNextAgentState,                                   // TAPI v2.2
    dwMeasurementPeriod: DWORD;                         // TAPI v2.2
    cyOverallCallRate: CURRENCY;                        // TAPI v2.2
    dwNumberOfACDCalls,                                 // TAPI v2.2
    dwNumberOfIncomingCalls,                            // TAPI v2.2
    dwNumberOfOutgoingCalls,                            // TAPI v2.2
    dwTotalACDTalkTime,                                 // TAPI v2.2
    dwTotalACDCallTime,                                 // TAPI v2.2
    dwTotalACDWrapUpTime: DWORD;                        // TAPI v2.2
  end;
  {$EXTERNALSYM lineagentinfo_tag}
  TLineAgentInfo = lineagentinfo_tag;
  LINEAGENTINFO = lineagentinfo_tag;
  {$EXTERNALSYM LINEAGENTINFO}

  PLineAgentSession = ^TLineAgentSession;
  lineagentsession_tag = packed record
    hAgentSession: HAGENTSESSION;                       // TAPI v2.2
    hAgent: HAGENT;                                     // TAPI v2.2
    GroupID: TGUID;                                     // TAPI v2.2
    dwWorkingAddressID: DWORD;                          // TAPI v2.2
  end;
  {$EXTERNALSYM lineagentsession_tag}
  TLineAgentSession = lineagentsession_tag;
  LINEAGENTSESSIONENTRY = lineagentsession_tag;
  {$EXTERNALSYM LINEAGENTSESSIONENTRY}

  PLineAgentSessionList = ^TLineAgentSessionList;
  lineagentsessionlist_tag = packed record
    dwTotalSize,                                        // TAPI v2.2
    dwNeededSize,                                       // TAPI v2.2
    dwUsedSize,                                         // TAPI v2.2
    dwNumEntries,                                       // TAPI v2.2
    dwListSize,                                         // TAPI v2.2
    dwListOffset: DWORD;                                // TAPI v2.2
  end;
  {$EXTERNALSYM lineagentsessionlist_tag}
  TLineAgentSessionList = lineagentsessionlist_tag;
  LINEAGENTSESSIONLIST = lineagentsessionlist_tag;
  {$EXTERNALSYM LINEAGENTSESSIONLIST}

  PLineAgentSessionInfo = ^TLineAgentSessionInfo;
  lineagentsessioninfo_tag = packed record
    dwTotalSize,                                        // TAPI v2.2
    dwNeededSize,                                       // TAPI v2.2
    dwUsedSize,                                         // TAPI v2.2
    dwAgentSessionState,                                // TAPI v2.2
    dwNextAgentSessionState: DWORD;                     // TAPI v2.2
    dateSessionStartTime: TDateTime;                    // TAPI v2.2
    dwSessionDuration,                                  // TAPI v2.2
    dwNumberOfCalls,                                    // TAPI v2.2
    dwTotalTalkTime,                                    // TAPI v2.2
    dwAverageTalkTime,                                  // TAPI v2.2
    dwTotalCallTime,                                    // TAPI v2.2
    dwAverageCallTime,                                  // TAPI v2.2
    dwTotalWrapUpTime,                                  // TAPI v2.2
    dwAverageWrapUpTime: DWORD;                         // TAPI v2.2
    cyACDCallRate: CURRENCY;                            // TAPI v2.2
    dwLongestTimeToAnswer,                              // TAPI v2.2
    dwAverageTimeToAnswer: DWORD;                       // TAPI v2.2
  end;
  {$EXTERNALSYM lineagentsessioninfo_tag}
  TLineAgentSessionInfo = lineagentsessioninfo_tag;
  LINEAGENTSESSIONINFO = lineagentsessioninfo_tag;
  {$EXTERNALSYM LINEAGENTSESSIONINFO}

  PLineQueueEntry = ^TLineQueueEntry;
  linequeueentry_tag = packed record
    dwQueueID,                                          // TAPI v2.2
    dwNameSize,                                         // TAPI v2.2
    dwNameOffset: DWORD;                                // TAPI v2.2
  end;
  {$EXTERNALSYM linequeueentry_tag}
  TLineQueueEntry = linequeueentry_tag;
  LINEQUEUEENTRY = linequeueentry_tag;
  {$EXTERNALSYM LINEQUEUEENTRY}

  PLineQueueList = ^TLineQueueList;
  linequeuelist_tag = packed record
    dwTotalSize,                                        // TAPI v2.2
    dwNeededSize,                                       // TAPI v2.2
    dwUsedSize,                                         // TAPI v2.2
    dwNumEntries,                                       // TAPI v2.2
    dwListSize,                                         // TAPI v2.2
    dwListOffset: DWORD;                                // TAPI v2.2
  end;
  {$EXTERNALSYM linequeuelist_tag}
  TLineQueueList = linequeuelist_tag;
  LINEQUEUELIST = linequeuelist_tag;
  {$EXTERNALSYM LINEQUEUELIST}

  PLineQueueInfo = ^TLineQueueInfo;
  linequeueinfo_tag = packed record
    dwTotalSize,                                        // TAPI v2.2
    dwNeededSize,                                       // TAPI v2.2
    dwUsedSize,                                         // TAPI v2.2
    dwMeasurementPeriod,                                // TAPI v2.2
    dwTotalCallsQueued,                                 // TAPI v2.2
    dwCurrentCallsQueued,                               // TAPI v2.2
    dwTotalCallsAbandoned,                              // TAPI v2.2
    dwTotalCallsFlowedIn,                               // TAPI v2.2
    dwTotalCallsFlowedOut,                              // TAPI v2.2
    dwLongestEverWaitTime,                              // TAPI v2.2
    dwCurrentLongestWaitTime,                           // TAPI v2.2
    dwAverageWaitTime,                                  // TAPI v2.2
    dwFinalDisposition: DWORD;                          // TAPI v2.2
  end;
  {$EXTERNALSYM linequeueinfo_tag}
  TLineQueueInfo = linequeueinfo_tag;
  LINEQUEUEINFO = linequeueinfo_tag;
  {$EXTERNALSYM LINEQUEUEINFO}

  PLineProxyRequestList = ^TLineProxyRequestList;
  lineproxyrequestlist_tag = packed record
    dwTotalSize,                                        // TAPI v2.2
    dwNeededSize,                                       // TAPI v2.2
    dwUsedSize,                                         // TAPI v2.2
    dwNumEntries,                                       // TAPI v2.2
    dwListSize,                                         // TAPI v2.2
    dwListOffset: DWORD;                                // TAPI v2.2
  end;
  {$EXTERNALSYM lineproxyrequestlist_tag}
  TLineProxyRequestList = lineproxyrequestlist_tag;
  LINEPROXYREQUESTLIST = lineproxyrequestlist_tag;
  {$EXTERNALSYM LINEPROXYREQUESTLIST}
{$ENDIF}

{$IFDEF TAPI30}
  PLineCallHubTrackingInfo = ^TLineCallHubTrackingInfo;
  linecallhubtrackinginfo_tag = packed record
    dwTotalSize,                                    // TAPI v3.0
    dwNeededSize,                                   // TAPI v3.0
    dwUsedSize,                                     // TAPI v3.0
    dwAvailableTracking,                            // TAPI v3.0
    dwCurrentTracking: DWORD;                       // TAPI v3.0
  end;
  {$EXTERNALSYM linecallhubtrackinginfo_tag}
  TLineCallHubTrackingInfo = linecallhubtrackinginfo_tag;
  LINECALLHUBTRACKINGINFO = linecallhubtrackinginfo_tag;
  {$EXTERNALSYM LINECALLHUBTRACKINGINFO}
{$ENDIF}

  PLineDialParams = ^TLineDialParams;
  linedialparams_tag = packed record
    dwDialPause,
    dwDialSpeed,
    dwDigitDuration,
    dwWaitForDialtone: DWORD;
  end;
  {$EXTERNALSYM linedialparams_tag}
  TLineDialParams = linedialparams_tag;
  LINEDIALPARAMS = linedialparams_tag;
  {$EXTERNALSYM LINEDIALPARAMS}

  PLineCallInfo = ^TLineCallInfo;
  linecallinfo_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize: DWORD;
    hLine: HLINE;
    dwLineDeviceID,
    dwAddressID,
    dwBearerMode,
    dwRate,
    dwMediaMode,
    dwAppSpecific,
    dwCallID,
    dwRelatedCallID,
    dwCallParamFlags,
    dwCallStates,
    dwMonitorDigitModes,
    dwMonitorMediaModes: DWORD;
    DialParams: TLineDialParams;
    dwOrigin,
    dwReason,
    dwCompletionID,
    dwNumOwners,
    dwNumMonitors,
    dwCountryCode,
    dwTrunk,
    dwCallerIDFlags,
    dwCallerIDSize,
    dwCallerIDOffset,
    dwCallerIDNameSize,
    dwCallerIDNameOffset,
    dwCalledIDFlags,
    dwCalledIDSize,
    dwCalledIDOffset,
    dwCalledIDNameSize,
    dwCalledIDNameOffset,
    dwConnectedIDFlags,
    dwConnectedIDSize,
    dwConnectedIDOffset,
    dwConnectedIDNameSize,
    dwConnectedIDNameOffset,
    dwRedirectionIDFlags,
    dwRedirectionIDSize,
    dwRedirectionIDOffset,
    dwRedirectionIDNameSize,
    dwRedirectionIDNameOffset,
    dwRedirectingIDFlags,
    dwRedirectingIDSize,
    dwRedirectingIDOffset,
    dwRedirectingIDNameSize,
    dwRedirectingIDNameOffset,
    dwAppNameSize,
    dwAppNameOffset,
    dwDisplayableAddressSize,
    dwDisplayableAddressOffset,
    dwCalledPartySize,
    dwCalledPartyOffset,
    dwCommentSize,
    dwCommentOffset,
    dwDisplaySize,
    dwDisplayOffset,
    dwUserUserInfoSize,
    dwUserUserInfoOffset,
    dwHighLevelCompSize,
    dwHighLevelCompOffset,
    dwLowLevelCompSize,
    dwLowLevelCompOffset,
    dwChargingInfoSize,
    dwChargingInfoOffset,
    dwTerminalModesSize,
    dwTerminalModesOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: DWORD;
{$IFDEF TAPI20}
    dwCallTreatment,                                     // TAPI v2.0
    dwCallDataSize,                                      // TAPI v2.0
    dwCallDataOffset,                                    // TAPI v2.0
    dwSendingFlowspecSize,                               // TAPI v2.0
    dwSendingFlowspecOffset,                             // TAPI v2.0
    dwReceivingFlowspecSize,                             // TAPI v2.0
    dwReceivingFlowspecOffset: DWORD;                    // TAPI v2.0
{$ENDIF}
{$IFDEF TAPI30}
    dwCallerIDAddressType: DWORD;                        // TAPI v3.0
    dwCalledIDAddressType: DWORD;                        // TAPI v3.0
    dwConnectedIDAddressType: DWORD;                     // TAPI v3.0
    dwRedirectionIDAddressType: DWORD;                   // TAPI v3.0
    dwRedirectingIDAddressType: DWORD;                   // TAPI v3.0
{$ENDIF}
  end;
  {$EXTERNALSYM linecallinfo_tag}
  TLineCallInfo = linecallinfo_tag;
  LINECALLINFO = linecallinfo_tag;
  {$EXTERNALSYM LINECALLINFO}

  PLineCallList = ^TLineCallList;
  linecalllist_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwCallsNumEntries,
    dwCallsSize,
    dwCallsOffset: DWORD;
  end;
  {$EXTERNALSYM linecalllist_tag}
  TLineCallList = linecalllist_tag;
  LINECALLLIST = linecalllist_tag;
  {$EXTERNALSYM LINECALLLIST}

  PLineCallParams = ^TLineCallParams;
  linecallparams_tag = packed record {// Defaults:        }
    dwTotalSize,                     {// ---------        }
    dwBearerMode,                    {// voice            }
    dwMinRate,                       {// (3.1kHz)         }
    dwMaxRate,                       {// (3.1kHz)         }
    dwMediaMode,                     {// interactiveVoice }
    dwCallParamFlags,                {// 0                }
    dwAddressMode,                   {// addressID        }
    dwAddressID: DWORD;              {// (any available)  }
    DialParams: TLineDialParams;     {// (0, 0, 0, 0)     }
    dwOrigAddressSize,               {// 0                }
    dwOrigAddressOffset,
    dwDisplayableAddressSize,
    dwDisplayableAddressOffset,
    dwCalledPartySize,               {// 0 }
    dwCalledPartyOffset,
    dwCommentSize,                   {// 0 }
    dwCommentOffset,
    dwUserUserInfoSize,              {// 0  }
    dwUserUserInfoOffset,
    dwHighLevelCompSize,             {// 0  }
    dwHighLevelCompOffset,
    dwLowLevelCompSize,              {// 0  }
    dwLowLevelCompOffset,
    dwDevSpecificSize,               {// 0  }
    dwDevSpecificOffset: DWORD;
{$IFDEF TAPI20}
    dwPredictiveAutoTransferStates,                      // TAPI v2.0
    dwTargetAddressSize,                                 // TAPI v2.0
    dwTargetAddressOffset,                               // TAPI v2.0
    dwSendingFlowspecSize,                               // TAPI v2.0
    dwSendingFlowspecOffset,                             // TAPI v2.0
    dwReceivingFlowspecSize,                             // TAPI v2.0
    dwReceivingFlowspecOffset,                           // TAPI v2.0
    dwDeviceClassSize,                                   // TAPI v2.0
    dwDeviceClassOffset,                                 // TAPI v2.0
    dwDeviceConfigSize,                                  // TAPI v2.0
    dwDeviceConfigOffset,                                // TAPI v2.0
    dwCallDataSize,                                      // TAPI v2.0
    dwCallDataOffset,                                    // TAPI v2.0
    dwNoAnswerTimeout,                                   // TAPI v2.0
    dwCallingPartyIDSize,                                // TAPI v2.0
    dwCallingPartyIDOffset: DWORD;                       // TAPI v2.0
{$ENDIF}
{$IFDEF TAPI30}
    dwAddressType: DWORD;                                // TAPI v3.0
{$ENDIF}
  end;
  {$EXTERNALSYM linecallparams_tag}
  TLineCallParams = linecallparams_tag;
  LINECALLPARAMS = linecallparams_tag;
  {$EXTERNALSYM LINECALLPARAMS}

  PLineCallStatus = ^TLineCallStatus;
  linecallstatus_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwCallState,
    dwCallStateMode,
    dwCallPrivilege,
    dwCallFeatures,
    dwDevSpecificSize,
    dwDevSpecificOffset: DWORD;
{$IFDEF TAPI20}
    dwCallFeatures2: DWORD;                              // TAPI v2.0
{$IFDEF WIN32}
    tStateEntryTime: TSystemTime;                        // TAPI v2.0
{$ELSE}
    tStateEntryTime: array[0..7] of WORD;                // TAPI v2.0
{$ENDIF}
{$ENDIF}
  end;
  {$EXTERNALSYM linecallstatus_tag}
  TLineCallStatus = linecallstatus_tag;
  LINECALLSTATUS = linecallstatus_tag;
  {$EXTERNALSYM LINECALLSTATUS}

{$IFDEF TAPI20}
  PLineCallTreatmentEntry = ^TLineCallTreatmentEntry;
  linecalltreatmententry_tag = packed record
    dwCallTreatmentID,                                   // TAPI v2.0
    dwCallTreatmentNameSize,                             // TAPI v2.0
    dwCallTreatmentNameOffset: DWORD;                    // TAPI v2.0
  end;
  {$EXTERNALSYM linecalltreatmententry_tag}
  TLineCallTreatmentEntry = linecalltreatmententry_tag;
  LINECALLTREATMENTENTRY = linecalltreatmententry_tag;
  {$EXTERNALSYM LINECALLTREATMENTENTRY}
{$ENDIF}

  PLineCardEntry = ^TLineCardEntry;
  linecardentry_tag = packed record
    dwPermanentCardID,
    dwCardNameSize,
    dwCardNameOffset,
    dwCardNumberDigits,                                  // TAPI v1.4
    dwSameAreaRuleSize,                                  // TAPI v1.4
    dwSameAreaRuleOffset,                                // TAPI v1.4
    dwLongDistanceRuleSize,                              // TAPI v1.4
    dwLongDistanceRuleOffset,                            // TAPI v1.4
    dwInternationalRuleSize,                             // TAPI v1.4
    dwInternationalRuleOffset,                           // TAPI v1.4
    dwOptions: DWORD;                                    // TAPI v1.4
  end;
  {$EXTERNALSYM linecardentry_tag}
  TLineCardEntry = linecardentry_tag;
  LINECARDENTRY = linecardentry_tag;
  {$EXTERNALSYM LINECARDENTRY}

  PLineCountryEntry = ^TLineCountryEntry;
  linecountryentry_tag = packed record
    dwCountryID,                                         // TAPI v1.4
    dwCountryCode,                                       // TAPI v1.4
    dwNextCountryID,                                     // TAPI v1.4
    dwCountryNameSize,                                   // TAPI v1.4
    dwCountryNameOffset,                                 // TAPI v1.4
    dwSameAreaRuleSize,                                  // TAPI v1.4
    dwSameAreaRuleOffset,                                // TAPI v1.4
    dwLongDistanceRuleSize,                              // TAPI v1.4
    dwLongDistanceRuleOffset,                            // TAPI v1.4
    dwInternationalRuleSize,                             // TAPI v1.4
    dwInternationalRuleOffset: DWORD;                    // TAPI v1.4
  end;
  {$EXTERNALSYM linecountryentry_tag}
  TLineCountryEntry = linecountryentry_tag;
  LINECOUNTRYENTRY = linecountryentry_tag;
  {$EXTERNALSYM LINECOUNTRYENTRY}

  PLineCountryList = ^TLineCountryList;
  linecountrylist_tag = packed record
    dwTotalSize,                                         // TAPI v1.4
    dwNeededSize,                                        // TAPI v1.4
    dwUsedSize,                                          // TAPI v1.4
    dwNumCountries,                                      // TAPI v1.4
    dwCountryListSize,                                   // TAPI v1.4
    dwCountryListOffset: DWORD;                          // TAPI v1.4
  end;
  {$EXTERNALSYM linecountrylist_tag}
  TLineCountryList = linecountrylist_tag;
  LINECOUNTRYLIST = linecountrylist_tag;
  {$EXTERNALSYM LINECOUNTRYLIST}

  PLineDevCaps = ^TLineDevCaps;
  linedevcaps_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwProviderInfoSize,
    dwProviderInfoOffset,
    dwSwitchInfoSize,
    dwSwitchInfoOffset,
    dwPermanentLineID,
    dwLineNameSize,
    dwLineNameOffset,
    dwStringFormat,
    dwAddressModes,
    dwNumAddresses,
    dwBearerModes,
    dwMaxRate,
    dwMediaModes,
    dwGenerateToneModes,
    dwGenerateToneMaxNumFreq,
    dwGenerateDigitModes,
    dwMonitorToneMaxNumFreq,
    dwMonitorToneMaxNumEntries,
    dwMonitorDigitModes,
    dwGatherDigitsMinTimeout,
    dwGatherDigitsMaxTimeout,
    dwMedCtlDigitMaxListSize,
    dwMedCtlMediaMaxListSize,
    dwMedCtlToneMaxListSize,
    dwMedCtlCallStateMaxListSize,
    dwDevCapFlags,
    dwMaxNumActiveCalls,
    dwAnswerMode,
    dwRingModes,
    dwLineStates,
    dwUUIAcceptSize,
    dwUUIAnswerSize,
    dwUUIMakeCallSize,
    dwUUIDropSize,
    dwUUISendUserUserInfoSize,
    dwUUICallInfoSize: DWORD;
    MinDialParams,
    MaxDialParams,
    DefaultDialParams: TLineDialParams;
    dwNumTerminals,
    dwTerminalCapsSize,
    dwTerminalCapsOffset,
    dwTerminalTextEntrySize,
    dwTerminalTextSize,
    dwTerminalTextOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset,
    dwLineFeatures: DWORD;                               // TAPI v1.4
{$IFDEF TAPI20}
    dwSettableDevStatus,                                 // TAPI v2.0
    dwDeviceClassesSize,                                 // TAPI v2.0
    dwDeviceClassesOffset: DWORD;                        // TAPI v2.0
{$ENDIF}
{$IFDEF TAPI22}
    PermanentLineGuid: TGUID;                            // TAPI v2.2
{$ENDIF}
{$IFDEF TAPI30}
    dwAddressTypes: DWORD;                               // TAPI v3.0
    ProtocolGuid: TGUID;                                 // TAPI v3.0
    dwAvailableTracking: DWORD;                          // TAPI v3.0
{$ENDIF}
  end;
  {$EXTERNALSYM linedevcaps_tag}
  TLineDevCaps = linedevcaps_tag;
  LINEDEVCAPS = linedevcaps_tag;
  {$EXTERNALSYM LINEDEVCAPS}

  PLineDevStatus = ^TLineDevStatus;
  linedevstatus_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwNumOpens,
    dwOpenMediaModes,
    dwNumActiveCalls,
    dwNumOnHoldCalls,
    dwNumOnHoldPendCalls,
    dwLineFeatures,
    dwNumCallCompletions,
    dwRingMode,
    dwSignalLevel,
    dwBatteryLevel,
    dwRoamMode,
    dwDevStatusFlags,
    dwTerminalModesSize,
    dwTerminalModesOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: DWORD;
{$IFDEF TAPI20}
    dwAvailableMediaModes,                               // TAPI v2.0
    dwAppInfoSize,                                       // TAPI v2.0
    dwAppInfoOffset: DWORD;                              // TAPI v2.0
{$ENDIF}
  end;
  {$EXTERNALSYM linedevstatus_tag}
  TLineDevStatus = linedevstatus_tag;
  LINEDEVSTATUS = linedevstatus_tag;
  {$EXTERNALSYM LINEDEVSTATUS}

  PLineExtensionId = ^TLineExtensionId;
  lineextensionid_tag = packed record
    dwExtensionID0,
    dwExtensionID1,
    dwExtensionID2,
    dwExtensionID3: DWORD;
  end;
  {$EXTERNALSYM lineextensionid_tag}
  TLineExtensionId = lineextensionid_tag;
  LINEEXTENSIONID = lineextensionid_tag;
  {$EXTERNALSYM LINEEXTENSIONID}

  PLineForward = ^TLineForward;
  lineforward_tag = packed record
    dwForwardMode,
    dwCallerAddressSize,
    dwCallerAddressOffset,
    dwDestCountryCode,
    dwDestAddressSize,
    dwDestAddressOffset: DWORD;
  end;
  {$EXTERNALSYM lineforward_tag}
  TLineForward = lineforward_tag;

  PLineForwardList = ^TLineForwardList;
  lineforwardlist_tag = packed record
    dwTotalSize,
    dwNumEntries: DWORD;
    ForwardList: array [0..0] of TLineForward;
  end;
  {$EXTERNALSYM lineforwardlist_tag}
  TLineForwardList = lineforwardlist_tag;
  LINEFORWARDLIST = lineforwardlist_tag;
  {$EXTERNALSYM LINEFORWARDLIST}

  PLineGenerateTone = ^TLineGenerateTone;
  linegeneratetone_tag = packed record
    dwFrequency,
    dwCadenceOn,
    dwCadenceOff,
    dwVolume: DWORD;
  end;
  {$EXTERNALSYM linegeneratetone_tag}
  TLineGenerateTone = linegeneratetone_tag;

{$IFDEF TAPI20}
  {$NODEFINE TTAPIHandleUnion}
  TTAPIHandleUnion = packed record
  case Longint of
    0: (hEvent: THandle);
    1: (hCompletionPort: THandle);
  end;

  PLineInitializeExParams = ^TLineInitializeExParams;
  lineinitializeexparams_tag = packed record
    dwTotalSize,                                         // TAPI v2.0
    dwNeededSize,                                        // TAPI v2.0
    dwUsedSize,                                          // TAPI v2.0
    dwOptions: DWORD;                                    // TAPI v2.0
    Handles: TTAPIHandleUnion;
    dwCompletionKey: DWORD;                              // TAPI v2.0
  end;
  {$EXTERNALSYM lineinitializeexparams_tag}
  TLineInitializeExParams = lineinitializeexparams_tag;
  LINEINITIALIZEEXPARAMS = lineinitializeexparams_tag;
  {$EXTERNALSYM LINEINITIALIZEEXPARAMS}
{$ENDIF}

  PLineLocationEntry = ^TLineLocationEntry;
  linelocationentry_tag = packed record
    dwPermanentLocationID,
    dwLocationNameSize,
    dwLocationNameOffset,
    dwCountryCode,
    dwCityCodeSize,
    dwCityCodeOffset,
    dwPreferredCardID,

    dwLocalAccessCodeSize,                               // TAPI v1.4
    dwLocalAccessCodeOffset,                             // TAPI v1.4
    dwLongDistanceAccessCodeSize,                        // TAPI v1.4
    dwLongDistanceAccessCodeOffset,                      // TAPI v1.4
    dwTollPrefixListSize,                                // TAPI v1.4
    dwTollPrefixListOffset,                              // TAPI v1.4
    dwCountryID,                                         // TAPI v1.4
    dwOptions,                                           // TAPI v1.4
    dwCancelCallWaitingSize,                             // TAPI v1.4
    dwCancelCallWaitingOffset: DWORD;                    // TAPI v1.4
  end;
  {$EXTERNALSYM linelocationentry_tag}
  TLineLocationEntry = linelocationentry_tag;
  LINELOCATIONENTRY = linelocationentry_tag;
  {$EXTERNALSYM LINELOCATIONENTRY}

  PLineMediaControlCallState = ^TLineMediaControlCallState;
  linemediacontrolcallstate_tag = packed record
    dwCallStates,
    dwMediaControl: DWORD;
  end;
  {$EXTERNALSYM linemediacontrolcallstate_tag}
  TLineMediaControlCallState = linemediacontrolcallstate_tag;
  LINEMEDIACONTROLCALLSTATE = linemediacontrolcallstate_tag;
  {$EXTERNALSYM LINEMEDIACONTROLCALLSTATE}

  PLineMediaControlDigit = ^TLineMediaControlDigit;
  linemediacontroldigit_tag = packed record
    dwDigit,
    dwDigitModes,
    dwMediaControl: DWORD;
  end;
  {$EXTERNALSYM linemediacontroldigit_tag}
  TLineMediaControlDigit = linemediacontroldigit_tag;
  LINEMEDIACONTROLDIGIT = linemediacontroldigit_tag;
  {$EXTERNALSYM LINEMEDIACONTROLDIGIT}

  PLineMediaControlMedia = ^TLineMediaControlMedia;
  linemediacontrolmedia_tag = packed record
    dwMediaModes,
    dwDuration,
    dwMediaControl: DWORD;
  end;
  {$EXTERNALSYM linemediacontrolmedia_tag}
  TLineMediaControlMedia = linemediacontrolmedia_tag;
  LINEMEDIACONTROLMEDIA = linemediacontrolmedia_tag;
  {$EXTERNALSYM LINEMEDIACONTROLMEDIA}

  PLineMediaControlTone = ^TLineMediaControlTone;
  linemediacontroltone_tag = packed record
    dwAppSpecific,
    dwDuration,
    dwFrequency1,
    dwFrequency2,
    dwFrequency3,
    dwMediaControl: DWORD;
  end;
  {$EXTERNALSYM linemediacontroltone_tag}
  TLineMediaControlTone = linemediacontroltone_tag;
  LINEMEDIACONTROLTONE = linemediacontroltone_tag;
  {$EXTERNALSYM LINEMEDIACONTROLTONE}

{$IFDEF TAPI20}
  PLineMessage = ^TLineMessage;
  linemessage_tag = packed record
    hDevice,                                             // TAPI v2.0
    dwMessageID,                                         // TAPI v2.0
    dwCallbackInstance,                                  // TAPI v2.0
    dwParam1,                                            // TAPI v2.0
    dwParam2,                                            // TAPI v2.0
    dwParam3: DWORD;                                     // TAPI v2.0
  end;
  {$EXTERNALSYM linemessage_tag}
  TLineMessage = linemessage_tag;
  LINEMESSAGE = linemessage_tag;
  {$EXTERNALSYM LINEMESSAGE}
{$ENDIF}

  PLineMonitorTone = ^TLineMonitorTone;
  linemonitortone_tag = packed record
    dwAppSpecific,
    dwDuration,
    dwFrequency1,
    dwFrequency2,
    dwFrequency3: DWORD;
  end;
  {$EXTERNALSYM linemonitortone_tag}
  TLineMonitorTone = linemonitortone_tag;
  LINEMONITORTONE = linemonitortone_tag;
  {$EXTERNALSYM LINEMONITORTONE}

  PLineProviderEntry = ^TLineProviderEntry;
  lineproviderentry_tag = packed record
    dwPermanentProviderID,                               // TAPI v1.4
    dwProviderFilenameSize,                              // TAPI v1.4
    dwProviderFilenameOffset: DWORD;                     // TAPI v1.4
  end;
  {$EXTERNALSYM lineproviderentry_tag}
  TLineProviderEntry = lineproviderentry_tag;
  LINEPROVIDERENTRY = lineproviderentry_tag;
  {$EXTERNALSYM LINEPROVIDERENTRY}

  PLineProviderList = ^TLineProviderList;
  lineproviderlist_tag = packed record
    dwTotalSize,                                         // TAPI v1.4
    dwNeededSize,                                        // TAPI v1.4
    dwUsedSize,                                          // TAPI v1.4
    dwNumProviders,                                      // TAPI v1.4
    dwProviderListSize,                                  // TAPI v1.4
    dwProviderListOffset: DWORD;                         // TAPI v1.4
  end;
  {$EXTERNALSYM lineproviderlist_tag}
  TLineProviderList = lineproviderlist_tag;
  LINEPROVIDERLIST = lineproviderlist_tag;
  {$EXTERNALSYM LINEPROVIDERLIST}

{$IFDEF TAPI20}
  PLineProxyRequest = ^TLineProxyRequest;
  lineproxyrequest_tag = packed record
    dwSize,                                              // TAPI v2.0
    dwClientMachineNameSize,                             // TAPI v2.0
    dwClientMachineNameOffset,                           // TAPI v2.0
    dwClientUserNameSize,                                // TAPI v2.0
    dwClientUserNameOffset,                              // TAPI v2.0
    dwClientAppAPIVersion,                               // TAPI v2.0
    dwRequestType: DWORD;                                // TAPI v2.0
    case Longint of
       0: (SetAgentGroup : record
             dwAddressID: DWORD;                         // TAPI v2.0
             GroupList: TLineAgentGroupList;             // TAPI v2.0
           end;);
       1: (SetAgentState : record
             dwAddressID,                                // TAPI v2.0
             dwAgentState,                               // TAPI v2.0
             dwNextAgentState: DWORD;                    // TAPI v2.0
           end;);
       2: (SetAgentActivity : record
             dwAddressID: DWORD;                         // TAPI v2.0
             dwActivityID: DWORD;                        // TAPI v2.0
           end;);
       3: (GetAgentCaps : record
             dwAddressID: DWORD;                         // TAPI v2.0
             AgentCaps: TLineAgentCaps;                  // TAPI v2.0
           end;);
       4: (GetAgentStatus : record
             dwAddressID: DWORD;                         // TAPI v2.0
             AgentStatus: TLineAgentStatus;              // TAPI v2.0
           end;);
       5: (AgentSpecific : record
             dwAddressID,                                // TAPI v2.0
             dwAgentExtensionIDIndex,                    // TAPI v2.0
             dwSize: DWORD;                              // TAPI v2.0
             Params: array[0..0] of Byte;                // TAPI v2.0
           end;);
       6: (GetAgentActivityList : record
             dwAddressID: DWORD;                         // TAPI v2.0
             ActivityList: TLineAgentActivityList;       // TAPI v2.0
           end;);
       7: (GetAgentGroupList : record
             dwAddressID: DWORD;                         // TAPI v2.0
             GroupList: TLineAgentGroupList;             // TAPI v2.0
           end;);
{$IFDEF TAPI22}
       8: (CreateAgent: record
             hAgent: HAGENT;                             // TAPI v2.2
             dwAgentIDSize,                              // TAPI v2.2
             dwAgentIDOffset,                            // TAPI v2.2
             dwAgentPINSize,                             // TAPI v2.2
             dwAgentPINOffset: DWORD;
           end;);
       9: (SetAgentStateEx: record
             hAgent: HAGENT;                             // TAPI v2.2
             dwAgentState,                               // TAPI v2.2
             dwNextAgentState: DWORD;                    // TAPI v2.2
           end;);
      10: (SetAgentMeasurementPeriod: record
             hAgent: HAGENT;                             // TAPI v2.2
             dwMeasurementPeriod: DWORD;                 // TAPI v2.2
          end;);
      11: (GetAgentInfo: record
             hAgent: HAGENT;                             // TAPI v2.2
             AgentInfo: TLineAgentInfo;                  // TAPI v2.2
          end;);
      12: (CreateAgentSession: record
             hAgentSession: HAGENTSESSIOn;               // TAPI v2.2
             dwAgentPINSize,
             dwAgentPINOffset: DWORD;
             hAgent: HAGENT;                             // TAPI v2.2
             GroupID: TGUID;                             // TAPI v2.2
             dwWorkingAddressID: DWORD;                  // TAPI v2.2
           end;);
      13: (GetAgentSessionList: record
             hAgent: HAGENT;                             // TAPI v2.2
             SessionList: TLineAgentSessionList;         // TAPI v2.2
          end;);
      14: (GetAgentSessionInfo: record
             hAgentSession: HAGENTSESSION;               // TAPI v2.2
             SessionInfo: TLineAgentSessionInfo;         // TAPI v2.2
          end;);
      15: (SetAgentSessionState: record
             hAgentSession: HAGENTSESSION;               // TAPI v2.2
             dwAgentSessionState,                        // TAPI v2.2
             dwNextAgentSessionState: DWORD;             // TAPI v2.2
          end;);
      16: (GetQueueList: record
             GroupID: TGUID;                             // TAPI v2.2
             QueueList: TLineQueueList;                  // TAPI v2.2
          end;);
      17: (SetQueueMeasurementPeriod: record
             dwQueueID,                                  // TAPI v2.2
             dwMeasurementPeriod: DWORD;                 // TAPI v2.2
          end;);
      18: (GetQueueInfo: record
             dwQueueID: DWORD;                           // TAPI v2.2
             QueueInfo: TLineQueueInfo;                  // TAPI v2.2
          end;);
      19: (GetGroupList: record
             GroupList: TLineAgentGroupList;             // TAPI v2.2
          end;);
{$ENDIF}
  end;
  {$EXTERNALSYM lineproxyrequest_tag}
  TLineProxyRequest = lineproxyrequest_tag;
  LINEPROXYREQUEST = lineproxyrequest_tag;
  {$EXTERNALSYM LINEPROXYREQUEST}
{$ENDIF}

  PLineReqMakeCall = ^TLineReqMakeCall;
  linereqmakecall_tag = packed record
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE - 1] of Char;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of Char;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of Char;
    szComment: array[0..TAPIMAXCOMMENTSIZE - 1] of Char;
  end;
  {$EXTERNALSYM linereqmakecall_tag}
  TLineReqMakeCall = linereqmakecall_tag;
  LINEREQMAKECALL = linereqmakecall_tag;
  {$EXTERNALSYM LINEREQMAKECALL}

{$IFDEF TAPI20}
  PLineReqMakeCallW = ^TLineReqMakeCallW;
  linereqmakecallW_tag = packed record
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE - 1] of WideChar;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of WideChar;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of WideChar;
    szComment: array[0..TAPIMAXCOMMENTSIZE - 1] of WideChar;
  end;
  {$EXTERNALSYM linereqmakecallW_tag}
  TLineReqMakeCallW = linereqmakecallW_tag;
  LINEREQMAKECALLW = linereqmakecallW_tag;
  {$EXTERNALSYM LINEREQMAKECALL}
{$ENDIF}

  PLineReqMediaCall = ^TLineReqMediaCall;
  linereqmediacall_tag = packed record
    hWnd: HWND;
    wRequestID: WPARAM;
    szDeviceClass: array[0..TAPIMAXDEVICECLASSSIZE - 1] of Char;
    ucDeviceID: array[0..TAPIMAXDEVICEIDSIZE - 1] of Byte;
    dwSize,
    dwSecure: DWORD;
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE - 1] of Char;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of Char;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of Char;
    szComment: array[0..TAPIMAXCOMMENTSIZE - 1] of Char;
  end;
  {$EXTERNALSYM linereqmediacall_tag}
  TLineReqMediaCall = linereqmediacall_tag;
  LINEREQMEDIACALL = linereqmediacall_tag;
  {$EXTERNALSYM LINEREQMEDIACALL}

{$IFDEF TAPI20}
  PLineReqMediaCallW = ^TLineReqMediaCallW;
  linereqmediacallW_tag = packed record
    hWnd: HWND;
    wRequestID: WPARAM;
    szDeviceClass: array[0..TAPIMAXDEVICECLASSSIZE - 1] of WideChar;
    ucDeviceID: array[0..TAPIMAXDEVICEIDSIZE - 1] of Byte;
    dwSize,
    dwSecure: DWORD;
    szDestAddress: array[0..TAPIMAXDESTADDRESSSIZE - 1] of WideChar;
    szAppName: array[0..TAPIMAXAPPNAMESIZE - 1] of WideChar;
    szCalledParty: array[0..TAPIMAXCALLEDPARTYSIZE - 1] of WideChar;
    szComment: array[0..TAPIMAXCOMMENTSIZE - 1] of WideChar;
  end;
  {$EXTERNALSYM linereqmediacallW_tag}
  TLineReqMediaCallW = linereqmediacallW_tag;
  LINEREQMEDIACALLW = linereqmediacallW_tag;
  {$EXTERNALSYM LINEREQMEDIACALLW}
{$ENDIF}

  PLineTermCaps = ^TLineTermCaps;
  linetermcaps_tag = packed record
    dwTermDev,
    dwTermModes,
    dwTermSharing: DWORD;
  end;
  {$EXTERNALSYM linetermcaps_tag}
  TLineTermCaps = linetermcaps_tag;
  LINETERMCAPS = linetermcaps_tag;
  {$EXTERNALSYM LINETERMCAPS}

  PLineTranslateCaps = ^TLineTranslateCaps;
  linetranslatecaps_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwNumLocations,
    dwLocationListSize,
    dwLocationListOffset,
    dwCurrentLocationID,
    dwNumCards,
    dwCardListSize,
    dwCardListOffset,
    dwCurrentPreferredCardID: DWORD;
  end;
  {$EXTERNALSYM linetranslatecaps_tag}
  TLineTranslateCaps = linetranslatecaps_tag;
  LINETRANSLATECAPS = linetranslatecaps_tag;
  {$EXTERNALSYM LINETRANSLATECAPS}

  PLineTranslateOutput = ^TLineTranslateOutput;
  linetranslateoutput_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwDialableStringSize,
    dwDialableStringOffset,
    dwDisplayableStringSize,
    dwDisplayableStringOffset,
    dwCurrentCountry,
    dwDestCountry,
    dwTranslateResults: DWORD;
  end;
  {$EXTERNALSYM linetranslateoutput_tag}
  TLineTranslateOutput = linetranslateoutput_tag;
  LINETRANSLATEOUTPUT = linetranslateoutput_tag;
  {$EXTERNALSYM LINETRANSLATEOUTPUT}

  PPhoneButtonInfo = ^TPhoneButtonInfo;
  phonebuttoninfo_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwButtonMode,
    dwButtonFunction,
    dwButtonTextSize,
    dwButtonTextOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset,

    dwButtonState: DWORD;                                // TAPI v1.4
  end;
  {$EXTERNALSYM phonebuttoninfo_tag}
  TPhoneButtonInfo = phonebuttoninfo_tag;
  PHONEBUTTONINFO = phonebuttoninfo_tag;
  {$EXTERNALSYM PHONEBUTTONINFO}

  PPhoneCaps = ^TPhoneCaps;
  phonecaps_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwProviderInfoSize,
    dwProviderInfoOffset,
    dwPhoneInfoSize,
    dwPhoneInfoOffset,
    dwPermanentPhoneID,
    dwPhoneNameSize,
    dwPhoneNameOffset,
    dwStringFormat,
    dwPhoneStates,
    dwHookSwitchDevs,
    dwHandsetHookSwitchModes,
    dwSpeakerHookSwitchModes,
    dwHeadsetHookSwitchModes,
    dwVolumeFlags,
    dwGainFlags,
    dwDisplayNumRows,
    dwDisplayNumColumns,
    dwNumRingModes,
    dwNumButtonLamps,
    dwButtonModesSize,
    dwButtonModesOffset,
    dwButtonFunctionsSize,
    dwButtonFunctionsOffset,
    dwLampModesSize,
    dwLampModesOffset,
    dwNumSetData,
    dwSetDataSize,
    dwSetDataOffset,
    dwNumGetData,
    dwGetDataSize,
    dwGetDataOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: DWORD;
{$IFDEF TAPI20}
    dwDeviceClassesSize,                                 // TAPI v2.0
    dwDeviceClassesOffset,                               // TAPI v2.0
    dwPhoneFeatures,                                     // TAPI v2.0
    dwSettableHandsetHookSwitchModes,                    // TAPI v2.0
    dwSettableSpeakerHookSwitchModes,                    // TAPI v2.0
    dwSettableHeadsetHookSwitchModes,                    // TAPI v2.0
    dwMonitoredHandsetHookSwitchModes,                   // TAPI v2.0
    dwMonitoredSpeakerHookSwitchModes,                   // TAPI v2.0
    dwMonitoredHeadsetHookSwitchModes: DWORD;            // TAPI v2.0
{$ENDIF}
{$IFDEF TAPI22}
    PermanentPhoneGuid: TGUID;                           // TAPI v2.2
{$ENDIF}
  end;
  {$EXTERNALSYM phonecaps_tag}
  TPhoneCaps = phonecaps_tag;
  PHONECAPS = phonecaps_tag;
  {$EXTERNALSYM PHONECAPS}

  PPhoneExtensionId = ^TPhoneExtensionId;
  phoneextensionid_tag = packed record
    dwExtensionID0,
    dwExtensionID1,
    dwExtensionID2,
    dwExtensionID3: DWORD;
  end;
  {$EXTERNALSYM phoneextensionid_tag}
  TPhoneExtensionId = phoneextensionid_tag;
  PHONEEXTENSIONID = phoneextensionid_tag;
  {$EXTERNALSYM PHONEEXTENSIONID}

{$IFDEF TAPI20}
  PPhoneInitializeExParams = ^TPhoneInitializeExParams;
  phoneinitializeexparams_tag = packed record
    dwTotalSize,                                         // TAPI v2.0
    dwNeededSize,                                        // TAPI v2.0
    dwUsedSize,                                          // TAPI v2.0
    dwOptions: DWORD;                                    // TAPI v2.0
    Handles: TTAPIHandleUnion;
    dwCompletionKey: DWORD;                              // TAPI v2.0
  end;
  {$EXTERNALSYM phoneinitializeexparams_tag}
  TPhoneInitializeExParams = phoneinitializeexparams_tag;
  PHONEINITIALIZEEXPARAMS = phoneinitializeexparams_tag;
  {$EXTERNALSYM PHONEINITIALIZEEXPARAMS}

  PPhoneMessage = ^TPhoneMessage;
  phonemessage_tag = packed record
    hDevice,                                             // TAPI v2.0
    dwMessageID,                                         // TAPI v2.0
    dwCallbackInstance,                                  // TAPI v2.0
    dwParam1,                                            // TAPI v2.0
    dwParam2,                                            // TAPI v2.0
    dwParam3: DWORD;                                     // TAPI v2.0
  end;
  {$EXTERNALSYM phonemessage_tag}
  TPhoneMessage = phonemessage_tag;
  PHONEMESSAGE = phonemessage_tag;
  {$EXTERNALSYM PHONEMESSAGE}
{$ENDIF}

  PPhoneStatus = ^TPhoneStatus;
  phonestatus_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwStatusFlags,
    dwNumOwners,
    dwNumMonitors,
    dwRingMode,
    dwRingVolume,
    dwHandsetHookSwitchMode,
    dwHandsetVolume,
    dwHandsetGain,
    dwSpeakerHookSwitchMode,
    dwSpeakerVolume,
    dwSpeakerGain,
    dwHeadsetHookSwitchMode,
    dwHeadsetVolume,
    dwHeadsetGain,
    dwDisplaySize,
    dwDisplayOffset,
    dwLampModesSize,
    dwLampModesOffset,
    dwOwnerNameSize,
    dwOwnerNameOffset,
    dwDevSpecificSize,
    dwDevSpecificOffset: DWORD;
{$IFDEF TAPI20}
    dwPhoneFeatures: DWORD;                              // TAPI v2.0
{$ENDIF}
  end;
  {$EXTERNALSYM phonestatus_tag}
  TPhoneStatus = phonestatus_tag;
  PHONESTATUS = phonestatus_tag;
  {$EXTERNALSYM PHONESTATUS}

  PVarString = ^TVarString;
  varstring_tag = packed record
    dwTotalSize,
    dwNeededSize,
    dwUsedSize,
    dwStringFormat,
    dwStringSize,
    dwStringOffset: DWORD;
  end;
  {$EXTERNALSYM varstring_tag}
  TVarString = varstring_tag;
  VARSTRING = varstring_tag;
  {$EXTERNALSYM VARSTRING}

function lineAccept(hCall: HCALL; lpsUserUserInfo: LPCSTR;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineAccept}

{$IFNDEF TAPI10}
function lineAddProviderA(lpszProviderFilename: PAnsiChar; hwndOwner: HWND;
  var dwPermanentProviderID: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineAddProviderA}
function lineAddProviderW(lpszProviderFilename: PWideChar; hwndOwner: HWND;
  var dwPermanentProviderID: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineAddProviderW}
function lineAddProvider(lpszProviderFilename: PChar; hwndOwner: HWND;
  var dwPermanentProviderID: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineAddProvider}
{$ELSE}
function lineAddProvider(lpszProviderFilename: LPCSTR; hwndOwner: HWND;
  var dwPermanentProviderID: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineAddProvider}
{$IFDEF WIN32}
function lineAddProviderA(lpszProviderFilename: LPCSTR; hwndOwner: HWND;
  var dwPermanentProviderID: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineAddProviderA}
function lineAddProviderW(lpszProviderFilename: LPCWSTR; hwndOwner: HWND;
  var dwPermanentProviderID: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineAddProviderW}
{$ENDIF}
{$ENDIF}

function lineAddToConference(hConfCall, hConsultCall: HCALL): Longint; stdcall;
{$EXTERNALSYM lineAddToConference}

{$IFDEF TAPI20}
function lineAgentSpecific(hLine: HLINE; dwAddressID: DWORD;
  dwAgentExtensionIDIndex: DWORD; lpParams: Pointer;
  dwSize: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineAgentSpecific}
{$ENDIF}

function lineAnswer(hCall: HCALL; lpsUserUserInfo: LPCSTR;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineAnswer}

{$IFNDEF TAPI10}
function lineBlindTransferA(hCall: HCALL; lpszDestAddress: PAnsiChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineBlindTransferA}
function lineBlindTransferW(hCall: HCALL; lpszDestAddress: PWideChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineBlindTransferW}
function lineBlindTransfer(hCall: HCALL; lpszDestAddress: PChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineBlindTransfer}
{$ELSE}
function lineBlindTransfer(hCall: HCALL; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineBlindTransfer}
{$IFDEF WIN32}
function lineBlindTransferA(hCall: HCALL; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineBlindTransferA}
function lineBlindTransferW(hCall: HCALL; lpszDestAddress: LPCWSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineBlindTransferW}
{$ENDIF}
{$ENDIF}

function lineClose(hLine: HLINE): Longint; stdcall;
{$EXTERNALSYM lineClose}

function lineCompleteCall(hCall: HCALL; var dwCompletionID: DWORD;
  dwCompletionMode, dwMessageID: DWORD): Longint; stdcall;
{$EXTERNALSYM lineCompleteCall}

function lineCompleteTransfer(hCall, hConsultCall: HCALL; lphConfCall: PHCall;
  dwTransferMode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineCompleteTransfer}

{$IFNDEF TAPI10}
function lineConfigDialogA(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogA}
function lineConfigDialogW(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogW}
function lineConfigDialog(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PChar): Longint; stdcall;
{$EXTERNALSYM lineConfigDialog}
{$ELSE}
function lineConfigDialog(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineConfigDialog}
{$IFDEF WIN32}
function lineConfigDialogA(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogA}
function lineConfigDialogW(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineConfigDialogEditA(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PAnsiChar; lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogEditA}
function lineConfigDialogEditW(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PWideChar; lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogEditW}
function lineConfigDialogEdit(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PChar; lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogEdit}
{$ELSE}
function lineConfigDialogEdit(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR; lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogEdit}
{$IFDEF WIN32}
function lineConfigDialogEditA(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR; lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogEditA}
function lineConfigDialogEditW(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCWSTR; lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall;
{$EXTERNALSYM lineConfigDialogEditW}
{$ENDIF}
{$ENDIF}

function lineConfigProvider(hwndOwner: HWND;
  dwPermanentProviderID: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineConfigProvider}

{$IFDEF TAPI22}
function lineCreateAgentA(hLine: HLINE; lpszAgentID, lpszAgentPIN: PAnsiChar;
  var lphAgent: HAGENT): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineCreateAgentA}
{#END} // TAPI22

{#BEGIN}
function lineCreateAgentSessionA(hLine: HLINE; hAgent: HAGENT;
  lpszAgentPIN: PAnsiChar; dwWorkingAddressID: DWORD; lpGroupID: PGUID;
  var lphAgentSession: HAGENTSESSION): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineCreateAgentSessionA}
function lineCreateAgentW(hLine: HLINE; lpszAgentID, lpszAgentPIN: PWideChar;
  var lphAgent: HAGENT): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineCreateAgentW}
{#END} // TAPI22

{#BEGIN}
function lineCreateAgentSessionW(hLine: HLINE; hAgent: HAGENT;
  lpszAgentPIN: PWideChar; dwWorkingAddressID: DWORD; lpGroupID: PGUID;
  var lphAgentSession: HAGENTSESSION): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineCreateAgentSessionW}
function lineCreateAgent(hLine: HLINE; lpszAgentID, lpszAgentPIN: PChar;
  var lphAgent: HAGENT): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineCreateAgent}
{#END} // TAPI22

{#BEGIN}
function lineCreateAgentSession(hLine: HLINE; hAgent: HAGENT;
  lpszAgentPIN: PChar; dwWorkingAddressID: DWORD; lpGroupID: PGUID;
  var lphAgentSession: HAGENTSESSION): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineCreateAgentSession}
{$ENDIF}

function lineDeallocateCall(hCall: HCALL): Longint; stdcall;
{$EXTERNALSYM lineDeallocateCall}

function lineDevSpecific(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  lpParams: Pointer; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDevSpecific}

function lineDevSpecificFeature(hLine: HLINE; dwFeature: DWORD;
  lpParams: Pointer; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDevSpecificFeature}

{$IFNDEF TAPI10}
function lineDialA(hCall: HCALL; lpszDestAddress: PAnsiChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDialA}
function lineDialW(hCall: HCALL; lpszDestAddress: PWideChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDialW}
function lineDial(hCall: HCALL; lpszDestAddress: PChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDial}
{$ELSE}
function lineDial(hCall: HCALL; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDial}
{$IFDEF WIN32}
function lineDialA(hCall: HCALL; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDialA}
function lineDialW(hCall: HCALL; lpszDestAddress: LPCWSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDialW}
{$ENDIF}
{$ENDIF}

function lineDrop(hCall: HCALL; lpsUserUserInfo: LPCSTR;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineDrop}

{$IFNDEF TAPI10}
function lineForwardA(hLine: HLINE; bAllAddresses, dwAddressID: DWORD;
  ForwardList: PLineForwardList; dwNumRingsNoAnswer: DWORD;
  lphConsultCall: PHCall; lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineForwardA}
function lineForwardW(hLine: HLINE; bAllAddresses, dwAddressID: DWORD;
  ForwardList: PLineForwardList; dwNumRingsNoAnswer: DWORD;
  lphConsultCall: PHCall; lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineForwardW}
function lineForward(hLine: HLINE; bAllAddresses, dwAddressID: DWORD;
  ForwardList: PLineForwardList; dwNumRingsNoAnswer: DWORD;
  lphConsultCall: PHCall; lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineForward}
{$ELSE}
function lineForward(hLine: HLINE; bAllAddresses, dwAddressID: DWORD;
  ForwardList: PLineForwardList; dwNumRingsNoAnswer: DWORD;
  lphConsultCall: PHCall; lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineForward}
{$IFDEF WIN32}
function lineForwardA(hLine: HLINE; bAllAddresses, dwAddressID: DWORD;
  ForwardList: PLineForwardList; dwNumRingsNoAnswer: DWORD;
  lphConsultCall: PHCall; lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineForwardA}
function lineForwardW(hLine: HLINE; bAllAddresses, dwAddressID: DWORD;
  ForwardList: PLineForwardList; dwNumRingsNoAnswer: DWORD;
  lphConsultCall: PHCall; lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineForwardW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGatherDigitsA(hCall: HCALL; dwDigitModes: DWORD;
  lpsDigits: PAnsiChar; dwNumDigits: DWORD; lpszTerminationDigits: PAnsiChar;
  dwFirstDigitTimeout, dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGatherDigitsA}
function lineGatherDigitsW(hCall: HCALL; dwDigitModes: DWORD;
  lpsDigits: PWideChar; dwNumDigits: DWORD; lpszTerminationDigits: PWideChar;
  dwFirstDigitTimeout, dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGatherDigitsW}
function lineGatherDigits(hCall: HCALL; dwDigitModes: DWORD;
  lpsDigits: PChar; dwNumDigits: DWORD; lpszTerminationDigits: PChar;
  dwFirstDigitTimeout, dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGatherDigits}
{$ELSE}
function lineGatherDigits(hCall: HCALL; dwDigitModes: DWORD; lpsDigits: LPCSTR;
  dwNumDigits: DWORD; lpszTerminationDigits: LPCSTR; dwFirstDigitTimeout,
  dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGatherDigits}
{$IFDEF WIN32}
function lineGatherDigitsA(hCall: HCALL; dwDigitModes: DWORD; lpsDigits: LPCSTR;
  dwNumDigits: DWORD; lpszTerminationDigits: LPCSTR; dwFirstDigitTimeout,
  dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGatherDigitsA}
function lineGatherDigitsW(hCall: HCALL; dwDigitModes: DWORD; lpsDigits: LPCWSTR;
  dwNumDigits: DWORD; lpszTerminationDigits: LPCWSTR; dwFirstDigitTimeout,
  dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGatherDigitsW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGenerateDigitsA(hCall: HCALL; dwDigitMode: DWORD;
  lpszDigits: PAnsiChar; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGenerateDigitsA}
function lineGenerateDigitsW(hCall: HCALL; dwDigitMode: DWORD;
  lpszDigits: PWideChar; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGenerateDigitsW}
function lineGenerateDigits(hCall: HCALL; dwDigitMode: DWORD;
  lpszDigits: PChar; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGenerateDigits}
{$ELSE}
function lineGenerateDigits(hCall: HCALL; dwDigitMode: DWORD;
  lpszDigits: LPCSTR; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGenerateDigits}
{$IFDEF WIN32}
function lineGenerateDigitsA(hCall: HCALL; dwDigitMode: DWORD;
  lpszDigits: LPCSTR; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGenerateDigitsA}
function lineGenerateDigitsW(hCall: HCALL; dwDigitMode: DWORD;
  lpszDigits: LPCWSTR; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGenerateDigitsW}
{$ENDIF}
{$ENDIF}

function lineGenerateTone(hCall: HCALL; dwToneMode, dwDuration,
  dwNumTones: DWORD; Tones: PLineGenerateTone): Longint; stdcall;
{$EXTERNALSYM lineGenerateTone}

{$IFNDEF TAPI10}
function lineGetAddressCapsA(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAPIVersion, dwExtVersion: DWORD;
  lpAddressCaps: PLineAddressCaps): Longint; stdcall;
{$EXTERNALSYM lineGetAddressCapsA}
function lineGetAddressCapsW(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAPIVersion, dwExtVersion: DWORD;
  lpAddressCaps: PLineAddressCaps): Longint; stdcall;
{$EXTERNALSYM lineGetAddressCapsW}
function lineGetAddressCaps(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAPIVersion, dwExtVersion: DWORD;
  lpAddressCaps: PLineAddressCaps): Longint; stdcall;
{$EXTERNALSYM lineGetAddressCaps}
{$ELSE}
function lineGetAddressCaps(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAPIVersion, dwExtVersion: DWORD;
  lpAddressCaps: PLineAddressCaps): Longint; stdcall;
{$EXTERNALSYM lineGetAddressCaps}
{$IFDEF WIN32}
function lineGetAddressCapsA(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAPIVersion, dwExtVersion: DWORD;
  lpAddressCaps: PLineAddressCaps): Longint; stdcall;
{$EXTERNALSYM lineGetAddressCapsA}
function lineGetAddressCapsW(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAPIVersion, dwExtVersion: DWORD;
  lpAddressCaps: PLineAddressCaps): Longint; stdcall;
{$EXTERNALSYM lineGetAddressCapsW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetAddressIDA(hLine: HLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: PAnsiChar; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetAddressIDA}
function lineGetAddressIDW(hLine: HLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: PWideChar; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetAddressIDW}
function lineGetAddressID(hLine: HLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: PChar; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetAddressID}
{$ELSE}
function lineGetAddressID(hLine: HLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetAddressID}
{$IFDEF WIN32}
function lineGetAddressIDA(hLine: HLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetAddressIDA}
function lineGetAddressIDW(hLine: HLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: LPCWSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetAddressIDW}
{$ENDIF}
{$ENDIF}

function lineGetAddressStatusA(hLine: HLINE; dwAddressID: DWORD;
  lpAddressStatus: PLineAddressStatus): Longint; stdcall;
{$EXTERNALSYM lineGetAddressStatusA}
function lineGetAddressStatusW(hLine: HLINE; dwAddressID: DWORD;
  lpAddressStatus: PLineAddressStatus): Longint; stdcall;
{$EXTERNALSYM lineGetAddressStatusW}
function lineGetAddressStatus(hLine: HLINE; dwAddressID: DWORD;
  lpAddressStatus: PLineAddressStatus): Longint; stdcall;
{$EXTERNALSYM lineGetAddressStatus}

{$IFDEF TAPI20}
function lineGetAgentActivityListA(hLine: HLINE; dwAddressID: DWORD;
  lpAgentActivityList: PLineAgentActivityList): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentActivityListA}
{#END} // TAPI20

{#BEGIN}
function lineGetAgentCapsA(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAppAPIVersion: DWORD; lpAgentCaps: PLineAgentCaps): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentCapsA}
function lineGetAgentActivityListW(hLine: HLINE; dwAddressID: DWORD;
  lpAgentActivityList: PLineAgentActivityList): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentActivityListW}
{#END} // TAPI20

{#BEGIN}
function lineGetAgentCapsW(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAppAPIVersion: DWORD; lpAgentCaps: PLineAgentCaps): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentCapsW}
function lineGetAgentActivityList(hLine: HLINE; dwAddressID: DWORD;
  lpAgentActivityList: PLineAgentActivityList): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentActivityList}
{#END} // TAPI20

{#BEGIN}
function lineGetAgentCaps(hLineApp: HLINEAPP; dwDeviceID, dwAddressID,
  dwAppAPIVersion: DWORD; lpAgentCaps: PLineAgentCaps): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentCaps}

function lineGetAgentGroupListA(hLine: HLINE; dwAddressID: DWORD;
  lpAgentGroupList: PLineAgentGroupList): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentGroupListA}
function lineGetAgentGroupListW(hLine: HLINE; dwAddressID: DWORD;
  lpAgentGroupList: PLineAgentGroupList): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentGroupListW}
function lineGetAgentGroupList(hLine: HLINE; dwAddressID: DWORD;
  lpAgentGroupList: PLineAgentGroupList): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentGroupList}

{$IFDEF TAPI22}
function lineGetAgentInfo(hLine: HLINE; hAgent: HAGENT;
  lpAgentInfo: PLineAgentInfo): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetAgentInfo}

function lineGetAgentSessionInfo(hLine: HLINE; hAgentSession: HAGENTSESSION;
  lpAgentSessionInfo: PLineAgentSessionInfo): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetAgentSessionInfo}

function lineGetAgentSessionList(hLine: HLINE; hAgent: HAGENT;
  lpAgentSessionList: PLineAgentSessionList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetAgentSessionList}
{$ENDIF}

function lineGetAgentStatusA(hLine: HLINE; dwAddressID: DWORD;
  lpAgentStatus: PLineAgentStatus): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentStatusA}
function lineGetAgentStatusW(hLine: HLINE; dwAddressID: DWORD;
  lpAgentStatus: PLineAgentStatus): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentStatusW}
function lineGetAgentStatus(hLine: HLINE; dwAddressID: DWORD;
  lpAgentStatus: PLineAgentStatus): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetAgentStatus}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetAppPriorityA(lpszAppFilename: PAnsiChar; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpExtensionName: PVarString; var dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetAppPriorityA}
function lineGetAppPriorityW(lpszAppFilename: PWideChar; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpExtensionName: PVarString; var dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetAppPriorityW}
function lineGetAppPriority(lpszAppFilename: PChar; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpExtensionName: PVarString; var dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetAppPriority}
{$ELSE}
function lineGetAppPriority(lpszAppFilename: LPCSTR; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpExtensionName: PVarString; var dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetAppPriority}
{$IFDEF WIN32}
function lineGetAppPriorityA(lpszAppFilename: LPCSTR; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpExtensionName: PVarString; var dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetAppPriorityA}
function lineGetAppPriorityW(lpszAppFilename: LPCWSTR; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpExtensionName: PVarString; var dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetAppPriorityW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetCallInfoA(hCall: HCALL; lpCallInfo: PLineCallInfo): Longint; stdcall;
{$EXTERNALSYM lineGetCallInfoA}
function lineGetCallInfoW(hCall: HCALL; lpCallInfo: PLineCallInfo): Longint; stdcall;
{$EXTERNALSYM lineGetCallInfoW}
function lineGetCallInfo(hCall: HCALL; lpCallInfo: PLineCallInfo): Longint; stdcall;
{$EXTERNALSYM lineGetCallInfo}
{$ELSE}
function lineGetCallInfo(hCall: HCALL; lpCallInfo: PLineCallInfo): Longint; stdcall;
{$EXTERNALSYM lineGetCallInfo}
{$IFDEF WIN32}
function lineGetCallInfoA(hCall: HCALL; lpCallInfo: PLineCallInfo): Longint; stdcall;
{$EXTERNALSYM lineGetCallInfoA}
function lineGetCallInfoW(hCall: HCALL; lpCallInfo: PLineCallInfo): Longint; stdcall;
{$EXTERNALSYM lineGetCallInfoW}
{$ENDIF}
{$ENDIF}


function lineGetCallStatus(hCall: HCALL;
  lpCallStatus: PLineCallStatus): Longint; stdcall;
{$EXTERNALSYM lineGetCallStatus}

function lineGetConfRelatedCalls(hCall: HCALL;
  lpCallList: PLineCallList): Longint; stdcall;
{$EXTERNALSYM lineGetConfRelatedCalls}

{$IFNDEF TAPI10}
function lineGetCountryA(dwCountryID, dwAPIVersion: DWORD;
  lpLineCountryList: PLineCountryList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetCountryA}
function lineGetCountryW(dwCountryID, dwAPIVersion: DWORD;
  lpLineCountryList: PLineCountryList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetCountryW}
function lineGetCountry(dwCountryID, dwAPIVersion: DWORD;
  lpLineCountryList: PLineCountryList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetCountry}
{$ELSE}
function lineGetCountry(dwCountryID, dwAPIVersion: DWORD;
  lpLineCountryList: PLineCountryList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetCountry}
{$IFDEF WIN32}
function lineGetCountryA(dwCountryID, dwAPIVersion: DWORD;
  lpLineCountryList: PLineCountryList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetCountryA}
function lineGetCountryW(dwCountryID, dwAPIVersion: DWORD;
  lpLineCountryList: PLineCountryList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetCountryW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetDevCapsA(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpLineDevCaps: PLineDevCaps): Longint; stdcall;
{$EXTERNALSYM lineGetDevCapsA}
function lineGetDevCapsW(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpLineDevCaps: PLineDevCaps): Longint; stdcall;
{$EXTERNALSYM lineGetDevCapsW}
function lineGetDevCaps(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpLineDevCaps: PLineDevCaps): Longint; stdcall;
{$EXTERNALSYM lineGetDevCaps}
{$ELSE}
function lineGetDevCaps(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpLineDevCaps: PLineDevCaps): Longint; stdcall;
{$EXTERNALSYM lineGetDevCaps}
{$IFDEF WIN32}
function lineGetDevCapsA(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpLineDevCaps: PLineDevCaps): Longint; stdcall;
{$EXTERNALSYM lineGetDevCapsA}
function lineGetDevCapsW(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpLineDevCaps: PLineDevCaps): Longint; stdcall;
{$EXTERNALSYM lineGetDevCapsW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetDevConfigA(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM lineGetDevConfigA}
function lineGetDevConfigW(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$EXTERNALSYM lineGetDevConfigW}
function lineGetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: PChar): Longint; stdcall;
{$EXTERNALSYM lineGetDevConfig}
{$ELSE}
function lineGetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineGetDevConfig}
{$IFDEF WIN32}
function lineGetDevConfigA(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineGetDevConfigW}
function lineGetDevConfigW(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM lineGetDevConfigW}
{$ENDIF}
{$ENDIF}

{$IFDEF TAPI22}
function lineGetGroupListA(hLine: HLINE;
  lpGroupList: PLineAgentGroupList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetGroupListA}
function lineGetGroupListW(hLine: HLINE;
  lpGroupList: PLineAgentGroupList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetGroupListW}
function lineGetGroupList(hLine: HLINE;
  lpGroupList: PLineAgentGroupList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetGroupList}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetIconA(dwDeviceID: DWORD;
  lpszDeviceClass: PAnsiChar; lphIcon: PHICON): Longint; stdcall;
{$EXTERNALSYM lineGetIconA}
function lineGetIconW(dwDeviceID: DWORD;
  lpszDeviceClass: PWideChar; lphIcon: PHICON): Longint; stdcall;
{$EXTERNALSYM lineGetIconW}
function lineGetIcon(dwDeviceID: DWORD;
  lpszDeviceClass: PChar; lphIcon: PHICON): Longint; stdcall;
{$EXTERNALSYM lineGetIcon}
{$ELSE}
function lineGetIcon(dwDeviceID: DWORD; lpszDeviceClass: LPCSTR;
  lphIcon: PHICON): Longint; stdcall;
{$EXTERNALSYM lineGetIcon}
{$IFDEF WIN32}
function lineGetIconA(dwDeviceID: DWORD; lpszDeviceClass: LPCSTR;
  lphIcon: PHICON): Longint; stdcall;
{$EXTERNALSYM lineGetIconA}
function lineGetIconW(dwDeviceID: DWORD; lpszDeviceClass: LPCWSTR;
  lphIcon: PHICON): Longint; stdcall;
{$EXTERNALSYM lineGetIconW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetIDA(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect: DWORD; lpDeviceID: PVarString;
  lpszDeviceClass: PAnsiChar): Longint stdcall;
{$EXTERNALSYM lineGetIDA}
function lineGetIDW(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect: DWORD; lpDeviceID: PVarString;
  lpszDeviceClass: PWideChar): Longint stdcall;
{$EXTERNALSYM lineGetIDW}
function lineGetID(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect: DWORD; lpDeviceID: PVarString;
  lpszDeviceClass: PChar): Longint stdcall;
{$EXTERNALSYM lineGetID}
{$ELSE}
function lineGetID(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect: DWORD; lpDeviceID: PVarString;
  lpszDeviceClass: LPCSTR): Longint stdcall;
{$EXTERNALSYM lineGetID}
{$IFDEF WIN32}
function lineGetIDA(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect: DWORD; lpDeviceID: PVarString;
  lpszDeviceClass: LPCSTR): Longint stdcall;
{$EXTERNALSYM lineGetIDA}
function lineGetIDW(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect: DWORD; lpDeviceID: PVarString;
  lpszDeviceClass: LPCWSTR): Longint stdcall;
{$EXTERNALSYM lineGetIDW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetLineDevStatusA(hLine: HLINE;
  lpLineDevStatus: PLineDevStatus): Longint; stdcall;
{$EXTERNALSYM lineGetLineDevStatusA}
function lineGetLineDevStatusW(hLine: HLINE;
  lpLineDevStatus: PLineDevStatus): Longint; stdcall;
{$EXTERNALSYM lineGetLineDevStatusW}
function lineGetLineDevStatus(hLine: HLINE;
  lpLineDevStatus: PLineDevStatus): Longint; stdcall;
{$EXTERNALSYM lineGetLineDevStatus}
{$ELSE}
function lineGetLineDevStatus(hLine: HLINE;
  lpLineDevStatus: PLineDevStatus): Longint; stdcall;
{$EXTERNALSYM lineGetLineDevStatus}
{$IFDEF WIN32}
function lineGetLineDevStatusA(hLine: HLINE;
  lpLineDevStatus: PLineDevStatus): Longint; stdcall;
{$EXTERNALSYM lineGetLineDevStatusA}
function lineGetLineDevStatusW(hLine: HLINE;
  lpLineDevStatus: PLineDevStatus): Longint; stdcall;
{$EXTERNALSYM lineGetLineDevStatusW}
{$ENDIF}
{$ENDIF}

{$IFDEF TAPI20}
function lineGetMessage(hLineApp: HLINEAPP; var lpMessage: TLineMessage;
  dwTimeout: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineGetMessage}
{$ENDIF}

function lineGetNewCalls(hLine: HLINE; dwAddressID, dwSelect: DWORD;
  lpCallList: PLineCallList): Longint; stdcall;
{$EXTERNALSYM lineGetNewCalls}

function lineGetNumRings(hLine: HLINE; dwAddressID: DWORD;
  var dwNumRings: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetNumRings}

{$IFNDEF TAPI10}
function lineGetProviderListA(dwAPIVersion: DWORD;
  lpProviderList: PLineProviderList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetProviderListA}
function lineGetProviderListW(dwAPIVersion: DWORD;
  lpProviderList: PLineProviderList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetProviderListW}
function lineGetProviderList(dwAPIVersion: DWORD;
  lpProviderList: PLineProviderList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetProviderList}
{$ELSE}
function lineGetProviderList(dwAPIVersion: DWORD;
  lpProviderList: PLineProviderList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetProviderList}
{$IFDEF WIN32}
function lineGetProviderListA(dwAPIVersion: DWORD;
  lpProviderList: PLineProviderList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetProviderListA}
function lineGetProviderListW(dwAPIVersion: DWORD;
  lpProviderList: PLineProviderList): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineGetProviderListW}
{$ENDIF}
{$ENDIF}

{$IFDEF TAPI22}
function lineGetProxyStatus(hLineApp: HLINEAPP;
  dwDeviceID, dwAppAPIVersion: DWORD;
  lpLineProxyReqestList: PLineProxyRequestList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetProxyStatus}

function lineGetQueueInfo(hLine: HLINE; dwQueueID: DWORD;
  lpLineQueueInfo: PLineQueueInfo): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetQueueInfo}

function lineGetQueueListA(hLine: HLINE; lpGroupID: PGUID;
  lpQueueList: PLineQueueList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetQueueListA}
function lineGetQueueListW(hLine: HLINE; lpGroupID: PGUID;
  lpQueueList: PLineQueueList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetQueueListW}
function lineGetQueueList(hLine: HLINE; lpGroupID: PGUID;
  lpQueueList: PLineQueueList): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineGetQueueList}
{$ENDIF}

{$IFNDEF TAPI10}
function lineGetRequestA(hLineApp: HLINEAPP; dwRequestMode: DWORD;
  lpRequestBuffer: Pointer): Longint; stdcall;
{$EXTERNALSYM lineGetRequestA}
function lineGetRequestW(hLineApp: HLINEAPP; dwRequestMode: DWORD;
  lpRequestBuffer: Pointer): Longint; stdcall;
{$EXTERNALSYM lineGetRequestW}
function lineGetRequest(hLineApp: HLINEAPP; dwRequestMode: DWORD;
  lpRequestBuffer: Pointer): Longint; stdcall;
{$EXTERNALSYM lineGetRequest}
{$ELSE}
function lineGetRequest(hLineApp: HLINEAPP; dwRequestMode: DWORD;
  lpRequestBuffer: Pointer): Longint; stdcall;
{$EXTERNALSYM lineGetRequest}
{$IFDEF WIN32}
function lineGetRequestA(hLineApp: HLINEAPP; dwRequestMode: DWORD;
  lpRequestBuffer: Pointer): Longint; stdcall;
{$EXTERNALSYM lineGetRequestA}
function lineGetRequestW(hLineApp: HLINEAPP; dwRequestMode: DWORD;
  lpRequestBuffer: Pointer): Longint; stdcall;
{$EXTERNALSYM lineGetRequestW}
{$ENDIF}
{$ENDIF}

function lineGetStatusMessages(hLine: HLINE; var dwLineStates,
  dwAddressStates: DWORD): Longint; stdcall;
{$EXTERNALSYM lineGetStatusMessages}

{$IFNDEF TAPI10}
function lineGetTranslateCapsA(hLineApp: HLINEAPP; dwAPIVersion: DWORD;
  lpTranslateCaps: PLineTranslateCaps): Longint; stdcall;
{$EXTERNALSYM lineGetTranslateCapsA}
function lineGetTranslateCapsW(hLineApp: HLINEAPP; dwAPIVersion: DWORD;
  lpTranslateCaps: PLineTranslateCaps): Longint; stdcall;
{$EXTERNALSYM lineGetTranslateCapsW}
function lineGetTranslateCaps(hLineApp: HLINEAPP; dwAPIVersion: DWORD;
  lpTranslateCaps: PLineTranslateCaps): Longint; stdcall;
{$EXTERNALSYM lineGetTranslateCaps}
{$ELSE}
function lineGetTranslateCaps(hLineApp: HLINEAPP; dwAPIVersion: DWORD;
  lpTranslateCaps: PLineTranslateCaps): Longint; stdcall;
{$EXTERNALSYM lineGetTranslateCaps}
{$IFDEF WIN32}
function lineGetTranslateCapsA(hLineApp: HLINEAPP; dwAPIVersion: DWORD;
  lpTranslateCaps: PLineTranslateCaps): Longint; stdcall;
{$EXTERNALSYM lineGetTranslateCapsA}
function lineGetTranslateCapsW(hLineApp: HLINEAPP; dwAPIVersion: DWORD;
  lpTranslateCaps: PLineTranslateCaps): Longint; stdcall;
{$EXTERNALSYM lineGetTranslateCapsW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineHandoffA(hCall: HCALL; lpszFileName: PAnsiChar;
  dwMediaMode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineHandoffA}
function lineHandoffW(hCall: HCALL; lpszFileName: PWideChar;
  dwMediaMode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineHandoffW}
function lineHandoff(hCall: HCALL; lpszFileName: PChar;
  dwMediaMode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineHandoff}
{$ELSE}
function lineHandoff(hCall: HCALL; lpszFileName: LPCSTR;
  dwMediaMode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineHandoff}
{$IFDEF WIN32}
function lineHandoffA(hCall: HCALL; lpszFileName: LPCSTR;
  dwMediaMode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineHandoffA}
function lineHandoffW(hCall: HCALL; lpszFileName: LPCWSTR;
  dwMediaMode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineHandoffW}
{$ENDIF}
{$ENDIF}

function lineHold(hCall: HCALL): Longint; stdcall;
{$EXTERNALSYM lineHold}

function lineInitialize(lphLineApp: PHLineApp; hInstance: HINST;
  lpfnCallback: TLineCallback; lpszAppName: LPCSTR;
  var dwNumDevs: DWORD): Longint; stdcall;
{$EXTERNALSYM lineInitialize}

{$IFDEF TAPI20}
function lineInitializeExA(lphLineApp: PHLineApp; hInstance: HINST;
  lpfnCallback: TLineCallback; lpszAppName: PAnsiChar;
  var dwNumDevs, dwAPIVersion: DWORD;
  var LineInitializeExParams: TLineInitializeExParams): Longint; stdcall;
{$EXTERNALSYM lineInitializeExA}
function lineInitializeExW(lphLineApp: PHLineApp; hInstance: HINST;
  lpfnCallback: TLineCallback; lpszAppName: PWideChar;
  var dwNumDevs, dwAPIVersion: DWORD;
  var LineInitializeExParams: TLineInitializeExParams): Longint; stdcall;
{$EXTERNALSYM lineInitializeExW}
function lineInitializeEx(lphLineApp: PHLineApp; hInstance: HINST;
  lpfnCallback: TLineCallback; lpszAppName: PChar;
  var dwNumDevs, dwAPIVersion: DWORD;
  var LineInitializeExParams: TLineInitializeExParams): Longint; stdcall;
{$EXTERNALSYM lineInitializeEx}
{$ENDIF}

{$IFNDEF TAPI10}
function lineMakeCallA(hLine: HLINE; lphCall: PHCall; lpszDestAddress: PAnsiChar;
  dwCountryCode: DWORD; CallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineMakeCallA}
function lineMakeCallW(hLine: HLINE; lphCall: PHCall; lpszDestAddress: PWideChar;
  dwCountryCode: DWORD; CallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineMakeCallW}
function lineMakeCall(hLine: HLINE; lphCall: PHCall; lpszDestAddress: PChar;
  dwCountryCode: DWORD; CallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineMakeCall}
{$ELSE}
function lineMakeCall(hLine: HLINE; lphCall: PHCall; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD; CallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineMakeCall}
{$IFDEF WIN32}
function lineMakeCallA(hLine: HLINE; lphCall: PHCall; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD; CallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineMakeCallA}
function lineMakeCallW(hLine: HLINE; lphCall: PHCall; lpszDestAddress: LPCWSTR;
  dwCountryCode: DWORD; CallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineMakeCallW}
{$ENDIF}
{$ENDIF}

function lineMonitorDigits(hCall: HCALL; dwDigitModes: DWORD): Longint; stdcall;
{$EXTERNALSYM lineMonitorDigits}

function lineMonitorMedia(hCall: HCALL; dwMediaModes: DWORD): Longint; stdcall;
{$EXTERNALSYM lineMonitorMedia}

function lineMonitorTones(hCall: HCALL; lmtToneList: PLineMonitorTone;
  dwNumEntries: DWORD): Longint;  stdcall;
{$EXTERNALSYM lineMonitorTones}

function lineNegotiateAPIVersion(hLineApp: HLINEAPP; dwDeviceID, dwAPILowVersion,
  dwAPIHighVersion: DWORD; var dwAPIVersion: DWORD;
  var lpExtensionID: TLineExtensionID): Longint; stdcall;
{$EXTERNALSYM lineNegotiateAPIVersion}

function lineNegotiateExtVersion(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion,
  dwExtLowVersion, dwExtHighVersion: DWORD;
  var dwExtVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM lineNegotiateExtVersion}

{$IFNDEF TAPI10}
function lineOpenA(hLineApp: HLINEAPP; dwDeviceID: DWORD; lphLine: PHLine;
  dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivileges,
  dwMediaModes: DWORD; lpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineOpenA}
function lineOpenW(hLineApp: HLINEAPP; dwDeviceID: DWORD; lphLine: PHLine;
  dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivileges,
  dwMediaModes: DWORD; lpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineOpenW}
function lineOpen(hLineApp: HLINEAPP; dwDeviceID: DWORD; lphLine: PHLine;
  dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivileges,
  dwMediaModes: DWORD; lpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineOpen}
{$ELSE}
function lineOpen(hLineApp: HLINEAPP; dwDeviceID: DWORD; lphLine: PHLine;
  dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivileges,
  dwMediaModes: DWORD; lpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineOpen}
{$IFDEF WIN32}
function lineOpenA(hLineApp: HLINEAPP; dwDeviceID: DWORD; lphLine: PHLine;
  dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivileges,
  dwMediaModes: DWORD; lpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineOpenA}
function lineOpenW(hLineApp: HLINEAPP; dwDeviceID: DWORD; lphLine: PHLine;
  dwAPIVersion, dwExtVersion, dwCallbackInstance, dwPrivileges,
  dwMediaModes: DWORD; lpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineOpenW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineParkA(hCall: HCALL; dwParkMode: DWORD; lpszDirAddress: PAnsiChar;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM lineParkA}
function lineParkW(hCall: HCALL; dwParkMode: DWORD; lpszDirAddress: PWideChar;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM lineParkW}
function linePark(hCall: HCALL; dwParkMode: DWORD; lpszDirAddress: PChar;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM linePark}
{$ELSE}
function linePark(hCall: HCALL; dwParkMode: DWORD; lpszDirAddress: LPCSTR;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM linePark}
{$IFDEF WIN32}
function lineParkA(hCall: HCALL; dwParkMode: DWORD; lpszDirAddress: LPCSTR;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM lineParkA}
function lineParkW(hCall: HCALL; dwParkMode: DWORD; lpszDirAddress: LPCWSTR;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM lineParkW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function linePickupA(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCall;
  lpszDestAddress: PAnsiChar; lpszGroupID: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM linePickupA}
function linePickupW(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCall;
  lpszDestAddress: PWideChar; lpszGroupID: PWideChar): Longint; stdcall;
{$EXTERNALSYM linePickupW}
function linePickup(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCall;
  lpszDestAddress: PChar; lpszGroupID: PChar): Longint; stdcall;
{$EXTERNALSYM linePickup}
{$ELSE}
function linePickup(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCall;
  lpszDestAddress: LPCSTR; lpszGroupID: LPCSTR): Longint; stdcall;
{$EXTERNALSYM linePickup}
{$IFDEF WIN32}
function linePickupA(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCall;
  lpszDestAddress: LPCSTR; lpszGroupID: LPCSTR): Longint; stdcall;
{$EXTERNALSYM linePickupA}
function linePickupW(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCall;
  lpszDestAddress: LPCWSTR; lpszGroupID: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM linePickupW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function linePrepareAddToConferenceA(hConfCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM linePrepareAddToConferenceA}
function linePrepareAddToConferenceW(hConfCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM linePrepareAddToConferenceW}
function linePrepareAddToConference(hConfCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM linePrepareAddToConference}
{$ELSE}
function linePrepareAddToConference(hConfCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM linePrepareAddToConference}
{$IFDEF WIN32}
function linePrepareAddToConferenceA(hConfCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM linePrepareAddToConferenceA}
function linePrepareAddToConferenceW(hConfCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM linePrepareAddToConferenceW}
{$ENDIF}
{$ENDIF}

{$IFDEF TAPI20}
function lineProxyMessage(hLine: HLINE; hCall: HCALL; dwMsg, dwParam1, dwParam2,
  dwParam3: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineProxyMessage}

function lineProxyResponse(hLine: HLINE; lpProxyRequest: PLineProxyRequest;
  dwResult: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineProxyResponse}
{$ENDIF}

{$IFNDEF TAPI10}
function lineRedirectA(hCall: HCALL; lpszDestAddress: PAnsiChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineRedirectA}
function lineRedirectW(hCall: HCALL; lpszDestAddress: PWideChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineRedirectW}
function lineRedirect(hCall: HCALL; lpszDestAddress: PChar;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineRedirect}
{$ELSE}
function lineRedirect(hCall: HCALL; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineRedirect}
{$IFDEF WIN32}
function lineRedirectA(hCall: HCALL; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineRedirectA}
function lineRedirectW(hCall: HCALL; lpszDestAddress: LPCWSTR;
  dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM lineRedirectW}
{$ENDIF}
{$ENDIF}

function lineRegisterRequestRecipient(hLineApp: HLINEAPP; dwRegistrationInstance,
  dwRequestMode, bEnable: DWORD): Longint; stdcall;
{$EXTERNALSYM lineRegisterRequestRecipient}

function lineReleaseUserUserInfo(hCall: HCALL): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineReleaseUserUserInfo}

function lineRemoveFromConference(hCall: HCALL): Longint; stdcall;
{$EXTERNALSYM lineRemoveFromConference}

function lineRemoveProvider(dwPermanentProviderID: DWORD;
  hwndOwner: HWND): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineRemoveProvider}

function lineSecureCall(hCall: HCALL): Longint; stdcall;
{$EXTERNALSYM lineSecureCall}

function lineSendUserUserInfo(hCall: HCALL; lpsUserUserInfo: LPCSTR;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSendUserUserInfo}

{$IFDEF TAPI20}
function lineSetAgentActivity(hLine: HLINE; dwAddressID,
  dwActivityID: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineSetAgentActivity}

function lineSetAgentGroup(hLine: HLINE; dwAddressID: DWORD;
  lpAgentGroupList: PLineAgentGroupList): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineSetAgentGroup}

{$IFDEF TAPI22}
function lineSetAgentMeasurementPeriod(hLine: HLINE; hAgent: HAGENT;
  dwMeasurementPeriod: DWORD): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineSetAgentMeasurementPeriod}

function lineSetAgentSessionState(hLine: HLINE; hAgentSession: HAGENTSESSION;
  dwAgentSessionState, dwNextAgentSessionState: DWORD): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineSetAgentSessionState}

function lineSetAgentStateEx(hLine: HLINE; hAgent: HAGENT; dwAgentState,
  dwNextAgentState: DWORD): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineSetAgentStateEx}
{$ENDIF}

function lineSetAgentState(hLine: HLINE; dwAddressID, dwAgentState: DWORD;
  dwNextAgentState: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineSetAgentState}
{$ENDIF}

{$IFNDEF TAPI10}
function lineSetAppPriorityA(lpszAppFilename: PAnsiChar; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpszExtensionName: PAnsiChar; dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineSetAppPriorityA}
function lineSetAppPriorityW(lpszAppFilename: PWideChar; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpszExtensionName: PWideChar; dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineSetAppPriorityW}
function lineSetAppPriority(lpszAppFilename: PChar; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpszExtensionName: PChar; dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineSetAppPriority}
{$ELSE}
function lineSetAppPriority(lpszAppFilename: LPCSTR; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpszExtensionName: LPCSTR; dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineSetAppPriority}
{$IFDEF WIN32}
function lineSetAppPriorityA(lpszAppFilename: LPCSTR; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpszExtensionName: LPCSTR; dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineSetAppPriorityA}
function lineSetAppPriorityW(lpszAppFilename: LPCWSTR; dwMediaMode: DWORD;
  lpExtensionID: PLineExtensionID; dwRequestMode: DWORD;
  lpszExtensionName: LPCWSTR; dwPriority: DWORD): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineSetAppPriorityW}
{$ENDIF}
{$ENDIF}

function lineSetAppSpecific(hCall: HCALL; dwAppSpecific: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetAppSpecific}

{$IFDEF TAPI20}
function lineSetCallData(hCall: HCALL; lpCallData: Pointer;
  dwSize: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineSetCallData}
{$ENDIF}

function lineSetCallParams(hCall: HCALL; dwBearerMode, dwMinRate,
  dwMaxRate: DWORD; ldpDialParams: PLineDialParams): Longint; stdcall;
{$EXTERNALSYM lineSetCallParams}

function lineSetCallPrivilege(hCall: HCALL;
  dwCallPrivilege: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetCallPrivilege}

{$IFDEF TAPI20}
function lineSetCallQualityOfService(hCall: HCALL; lpSendingFlowspec: Pointer;
  dwSendingFlowspecSize: DWORD; lpReceivingFlowspec: Pointer;
  dwReceivingFlowspecSize: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineSetCallQualityOfService}

function lineSetCallTreatment(hCall: HCALL;
  dwTreatment: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineSetCallTreatment}
{$ENDIF}

function lineSetCurrentLocation(hLineApp: HLINEAPP;
  dwLocation: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetCurrentLocation}

{$IFNDEF TAPI10}
function lineSetDevConfigA(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM lineSetDevConfigA}
function lineSetDevConfigW(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: PWideChar): Longint; stdcall;
{$EXTERNALSYM lineSetDevConfigW}
function lineSetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: PChar): Longint; stdcall;
{$EXTERNALSYM lineSetDevConfig}
{$ELSE}
function lineSetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineSetDevConfig}
{$IFDEF WIN32}
function lineSetDevConfigA(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineSetDevConfigA}
function lineSetDevConfigW(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM lineSetDevConfigW}
{$ENDIF}
{$ENDIF}

{$IFDEF TAPI20}
function lineSetLineDevStatus(hLine: HLINE; dwStatusToChange,
  fStatus: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM lineSetLineDevStatus}
{$ENDIF}

function lineSetMediaControl(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect: DWORD; lmcdDigitList: PLineMediaControlDigit;
  dwDigitNumEntries: DWORD; lmcmMediaList: PLineMediaControlMedia;
  dwMediaNumEntries: DWORD; lmctToneList: PLineMediaControlTone;
  dwToneNumEntries: DWORD; lmccsCallStateList: PLineMediaControlCallState;
  dwCallStateNumEntries: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetMediaControl}

function lineSetMediaMode(hCall: HCALL; dwMediaModes: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetMediaMode}

{$IFDEF TAPI22}
function lineSetQueueMeasurementPeriod(hLine: HLINE; dwQueueID,
  dwMeasurementPeriod: DWORD): Longint; stdcall; // TAPI v2.2
{$EXTERNALSYM lineSetQueueMeasurementPeriod}
{$ENDIF}

function lineSetNumRings(hLine: HLINE; dwAddressID,
  dwNumRings: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetNumRings}

function lineSetStatusMessages(hLine: HLINE; dwLineStates,
  dwAddressStates: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetStatusMessages}

function lineSetTerminal(hLine: HLINE; dwAddressID: DWORD; hCall: HCALL;
  dwSelect, dwTerminalModes, dwTerminalID, bEnable: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetTerminal}

{$IFNDEF TAPI10}
function lineSetTollListA(hLineApp: HLINEAPP; dwDeviceID: DWORD;
  lpszAddressIn: PAnsiChar; dwTollListOption: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetTollListA}
function lineSetTollListW(hLineApp: HLINEAPP; dwDeviceID: DWORD;
  lpszAddressIn: PWideChar; dwTollListOption: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetTollListW}
function lineSetTollList(hLineApp: HLINEAPP; dwDeviceID: DWORD;
  lpszAddressIn: PChar; dwTollListOption: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetTollList}
{$ELSE}
function lineSetTollList(hLineApp: HLINEAPP; dwDeviceID: DWORD;
  lpszAddressIn: LPCSTR; dwTollListOption: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetTollList}
{$IFDEF WIN32}
function lineSetTollListA(hLineApp: HLINEAPP; dwDeviceID: DWORD;
  lpszAddressIn: LPCSTR; dwTollListOption: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetTollListA}
function lineSetTollListW(hLineApp: HLINEAPP; dwDeviceID: DWORD;
  lpszAddressIn: LPCWSTR; dwTollListOption: DWORD): Longint; stdcall;
{$EXTERNALSYM lineSetTollListW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineSetupConferenceA(hCall: HCALL; hLine: HLINE; lphConfCall: PHCall;
  lphConsultCall: PHCall; dwNumParties: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupConferenceA}
function lineSetupConferenceW(hCall: HCALL; hLine: HLINE; lphConfCall: PHCall;
  lphConsultCall: PHCall; dwNumParties: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupConferenceW}
function lineSetupConference(hCall: HCALL; hLine: HLINE; lphConfCall: PHCall;
  lphConsultCall: PHCall; dwNumParties: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupConference}
{$ELSE}
function lineSetupConference(hCall: HCALL; hLine: HLINE; lphConfCall: PHCall;
  lphConsultCall: PHCall; dwNumParties: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupConference}
{$IFDEF WIN32}
function lineSetupConferenceA(hCall: HCALL; hLine: HLINE; lphConfCall: PHCall;
  lphConsultCall: PHCall; dwNumParties: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupConferenceA}
function lineSetupConferenceW(hCall: HCALL; hLine: HLINE; lphConfCall: PHCall;
  lphConsultCall: PHCall; dwNumParties: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupConferenceW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineSetupTransferA(hCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupTransferA}
function lineSetupTransferW(hCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupTransferW}
function lineSetupTransfer(hCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupTransfer}
{$ELSE}
function lineSetupTransfer(hCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupTransfer}
{$IFDEF WIN32}
function lineSetupTransferA(hCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupTransferA}
function lineSetupTransferW(hCall: HCALL; lphConsultCall: PHCall;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM lineSetupTransferW}
{$ENDIF}
{$ENDIF}

function lineShutdown(hLineApp: HLINEAPP): Longint; stdcall;
{$EXTERNALSYM lineShutdown}

function lineSwapHold(hActiveCall, hHeldCall: HCALL): Longint; stdcall;
{$EXTERNALSYM lineSwapHold}

{$IFNDEF TAPI10}
function lineTranslateAddressA(hLineApp: HLINEAPP; dwDeviceID,
  dwAPIVersion: DWORD; lpszAddressIn: PAnsiChar; dwCard, dwTranslateOptions: DWORD;
  lpTranslateOutput: PLineTranslateOutput): Longint; stdcall;
{$EXTERNALSYM lineTranslateAddressA}
function lineTranslateAddressW(hLineApp: HLINEAPP; dwDeviceID,
  dwAPIVersion: DWORD; lpszAddressIn: PWideChar; dwCard, dwTranslateOptions: DWORD;
  lpTranslateOutput: PLineTranslateOutput): Longint; stdcall;
{$EXTERNALSYM lineTranslateAddressW}
function lineTranslateAddress(hLineApp: HLINEAPP; dwDeviceID,
  dwAPIVersion: DWORD; lpszAddressIn: PChar; dwCard, dwTranslateOptions: DWORD;
  lpTranslateOutput: PLineTranslateOutput): Longint; stdcall;
{$EXTERNALSYM lineTranslateAddress}
{$ELSE}
function lineTranslateAddress(hLineApp: HLINEAPP; dwDeviceID,
  dwAPIVersion: DWORD; lpszAddressIn: LPCSTR; dwCard, dwTranslateOptions: DWORD;
  lpTranslateOutput: PLineTranslateOutput): Longint; stdcall;
{$EXTERNALSYM lineTranslateAddress}
{$IFDEF WIN32}
function lineTranslateAddressA(hLineApp: HLINEAPP; dwDeviceID,
  dwAPIVersion: DWORD; lpszAddressIn: LPCSTR; dwCard, dwTranslateOptions: DWORD;
  lpTranslateOutput: PLineTranslateOutput): Longint; stdcall;
{$EXTERNALSYM lineTranslateAddressA}
function lineTranslateAddressW(hLineApp: HLINEAPP; dwDeviceID,
  dwAPIVersion: DWORD; lpszAddressIn: LPCWSTR; dwCard, dwTranslateOptions: DWORD;
  lpTranslateOutput: PLineTranslateOutput): Longint; stdcall;
{$EXTERNALSYM lineTranslateAddressW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function lineTranslateDialogA(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion: DWORD;
  hwndOwner: HWND; lpszAddressIn: PAnsiChar): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineTranslateDialogA}
function lineTranslateDialogW(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion: DWORD;
  hwndOwner: HWND; lpszAddressIn: PWideChar): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineTranslateDialogW}
function lineTranslateDialog(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion: DWORD;
  hwndOwner: HWND; lpszAddressIn: PChar): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineTranslateDialog}
{$ELSE}
function lineTranslateDialog(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion: DWORD;
  hwndOwner: HWND; lpszAddressIn: LPCSTR): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineTranslateDialog}
{$IFDEF WIN32}
function lineTranslateDialogA(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion: DWORD;
  hwndOwner: HWND; lpszAddressIn: LPCSTR): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineTranslateDialogA}
function lineTranslateDialogW(hLineApp: HLINEAPP; dwDeviceID, dwAPIVersion: DWORD;
  hwndOwner: HWND; lpszAddressIn: LPCWSTR): Longint; stdcall; // TAPI v1.4
{$EXTERNALSYM lineTranslateDialogW}
{$ENDIF}
{$ENDIF}

function lineUncompleteCall(hLine: HLINE; dwCompletionID: DWORD): Longint; stdcall;
{$EXTERNALSYM lineUncompleteCall}

function lineUnhold(hCall: HCALL): Longint; stdcall;
{$EXTERNALSYM lineUnhold}

{$IFNDEF TAPI10}
function lineUnparkA(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCALL;
  lpszDestAddress: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM lineUnparkA}
function lineUnparkW(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCALL;
  lpszDestAddress: PWideChar): Longint; stdcall;
{$EXTERNALSYM lineUnparkW}
function lineUnpark(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCALL;
  lpszDestAddress: PChar): Longint; stdcall;
{$EXTERNALSYM lineUnpark}
{$ELSE}
function lineUnpark(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCALL;
  lpszDestAddress: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineUnpark}
{$IFDEF WIN32}
function lineUnparkA(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCALL;
  lpszDestAddress: LPCSTR): Longint; stdcall;
{$EXTERNALSYM lineUnparkA}
function lineUnparkW(hLine: HLINE; dwAddressID: DWORD; lphCall: PHCALL;
  lpszDestAddress: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM lineUnparkW}
{$ENDIF}
{$ENDIF}

function phoneClose(hPhone: HPHONE): Longint; stdcall;
{$EXTERNALSYM phoneClose}

{$IFNDEF TAPI10}
function phoneConfigDialogA(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM phoneConfigDialogA}
function phoneConfigDialogW(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$EXTERNALSYM phoneConfigDialogW}
function phoneConfigDialog(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: PChar): Longint; stdcall;
{$EXTERNALSYM phoneConfigDialog}
{$ELSE}
function phoneConfigDialog(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM phoneConfigDialog}
{$IFDEF WIN32}
function phoneConfigDialogA(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM phoneConfigDialogA}
function phoneConfigDialogW(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM phoneConfigDialogW}
{$ENDIF}
{$ENDIF}

function phoneDevSpecific(hPhone: HPHONE; lpParams: Pointer;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneDevSpecific}

{$IFNDEF TAPI10}
function phoneGetButtonInfoA(hPhone: HPHONE; dwButtonLampID: DWORD;
  lpButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneGetButtonInfoA}
function phoneGetButtonInfoW(hPhone: HPHONE; dwButtonLampID: DWORD;
  lpButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneGetButtonInfoW}
function phoneGetButtonInfo(hPhone: HPHONE; dwButtonLampID: DWORD;
  lpButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneGetButtonInfo}
{$ELSE}
function phoneGetButtonInfo(hPhone: HPHONE; dwButtonLampID: DWORD;
  lpButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneGetButtonInfo}
{$IFDEF WIN32}
function phoneGetButtonInfoA(hPhone: HPHONE; dwButtonLampID: DWORD;
  lpButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneGetButtonInfoA}
function phoneGetButtonInfoW(hPhone: HPHONE; dwButtonLampID: DWORD;
  lpButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneGetButtonInfoW}
{$ENDIF}
{$ENDIF}

function phoneGetData(hPhone: HPHONE; dwDataID: DWORD; lpData: Pointer;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneGetData}

{$IFNDEF TAPI10}
function phoneGetDevCapsA(hPhoneApp: HPHONEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpPhoneCaps: PPhoneCaps): Longint; stdcall;
{$EXTERNALSYM phoneGetDevCapsA}
function phoneGetDevCapsW(hPhoneApp: HPHONEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpPhoneCaps: PPhoneCaps): Longint; stdcall;
{$EXTERNALSYM phoneGetDevCapsW}
function phoneGetDevCaps(hPhoneApp: HPHONEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpPhoneCaps: PPhoneCaps): Longint; stdcall;
{$EXTERNALSYM phoneGetDevCaps}
{$ELSE}
function phoneGetDevCaps(hPhoneApp: HPHONEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpPhoneCaps: PPhoneCaps): Longint; stdcall;
{$EXTERNALSYM phoneGetDevCaps}
{$IFDEF WIN32}
function phoneGetDevCapsA(hPhoneApp: HPHONEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpPhoneCaps: PPhoneCaps): Longint; stdcall;
{$EXTERNALSYM phoneGetDevCapsA}
function phoneGetDevCapsW(hPhoneApp: HPHONEAPP; dwDeviceID, dwAPIVersion,
  dwExtVersion: DWORD; lpPhoneCaps: PPhoneCaps): Longint; stdcall;
{$EXTERNALSYM phoneGetDevCapsW}
{$ENDIF}
{$ENDIF}

function phoneGetDisplay(hPhone: HPHONE; lpDisplay: PVarString): Longint; stdcall;
{$EXTERNALSYM phoneGetDisplay}

function phoneGetGain(hPhone: HPHONE; dwHookSwitchDev: DWORD;
  var dwGain: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneGetGain}

function phoneGetHookSwitch(hPhone: HPHONE;
  var dwHookSwitchDevs: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneGetHookSwitch}

{$IFNDEF TAPI10}
function phoneGetIconA(dwDeviceID: DWORD; lpszDeviceClass: PAnsiChar;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM phoneGetIconA}
function phoneGetIconW(dwDeviceID: DWORD; lpszDeviceClass: PWideChar;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM phoneGetIconW}
function phoneGetIcon(dwDeviceID: DWORD; lpszDeviceClass: PChar;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM phoneGetIcon}
{$ELSE}
function phoneGetIcon(dwDeviceID: DWORD; lpszDeviceClass: LPCSTR;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM phoneGetIcon}
{$IFDEF WIN32}
function phoneGetIconA(dwDeviceID: DWORD; lpszDeviceClass: LPCSTR;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM phoneGetIconA}
function phoneGetIconW(dwDeviceID: DWORD; lpszDeviceClass: LPCWSTR;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM phoneGetIconW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function phoneGetIDA(hPhone: HPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM phoneGetIDA}
function phoneGetIDW(hPhone: HPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: PWideChar): Longint; stdcall;
{$EXTERNALSYM phoneGetIDW}
function phoneGetID(hPhone: HPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: PChar): Longint; stdcall;
{$EXTERNALSYM phoneGetID}
{$ELSE}
function phoneGetID(hPhone: HPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM phoneGetID}
{$IFDEF WIN32}
function phoneGetIDA(hPhone: HPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM phoneGetIDA}
function phoneGetIDW(hPhone: HPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM phoneGetIDW}
{$ENDIF}
{$ENDIF}

function phoneGetLamp(hPhone: HPHONE; dwButtonLampID: DWORD;
  var dwLampMode: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneGetLamp}

{$IFDEF TAPI20}
function phoneGetMessage(hPhoneApp: HPHONEAPP; var lpMessage: TPhoneMessage;
  dwTimeout: DWORD): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM phoneGetMessage}
{$ENDIF}

function phoneGetRing(hPhone: HPHONE; var dwRingMode,
  dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneGetRing}

{$IFNDEF TAPI10}
function phoneGetStatusA(hPhone: HPHONE;
  lpPhoneStatus: PPhoneStatus): Longint; stdcall;
{$EXTERNALSYM phoneGetStatusA}
function phoneGetStatusW(hPhone: HPHONE;
  lpPhoneStatus: PPhoneStatus): Longint; stdcall;
{$EXTERNALSYM phoneGetStatusW}
function phoneGetStatus(hPhone: HPHONE;
  lpPhoneStatus: PPhoneStatus): Longint; stdcall;
{$EXTERNALSYM phoneGetStatus}
{$ELSE}
function phoneGetStatus(hPhone: HPHONE;
  lpPhoneStatus: PPhoneStatus): Longint; stdcall;
{$EXTERNALSYM phoneGetStatus}
{$IFDEF WIN32}
function phoneGetStatusA(hPhone: HPHONE;
  lpPhoneStatus: PPhoneStatus): Longint; stdcall;
{$EXTERNALSYM phoneGetStatusA}
function phoneGetStatusW(hPhone: HPHONE;
  lpPhoneStatus: PPhoneStatus): Longint; stdcall;
{$EXTERNALSYM phoneGetStatusW}
{$ENDIF}
{$ENDIF}

function phoneGetStatusMessages(hPhone: HPHONE; var lpdwPhoneStates,
  lpdwButtonModes, lpdwButtonStates: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneGetStatusMessages}

function phoneGetVolume(hPhone: HPHONE; dwHookSwitchDev: DWORD;
  var dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneGetVolume}

function phoneInitialize(var hPhoneApp: HPHONEAPP; hInstance: HINST;
  lpfnCallback: TPhoneCallback;lpszAppName: LPCSTR;
  var dwNumDevs: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneInitialize}

{$IFDEF TAPI20}
function phoneInitializeExA(var hPhoneApp: HPHONEAPP; hInstance: HINST;
  lpfnCallback: TPhoneCallback; lpszFriendlyAppName: PAnsiChar;
  var dwNumDevs, dwAPIVersion: DWORD;
  var PhoneInitializeExParams: TPhoneInitializeExParams): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM phoneInitializeExA}
function phoneInitializeExW(var hPhoneApp: HPHONEAPP; hInstance: HINST;
  lpfnCallback: TPhoneCallback; lpszFriendlyAppName: PWideChar;
  var dwNumDevs, dwAPIVersion: DWORD;
  var PhoneInitializeExParams: TPhoneInitializeExParams): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM phoneInitializeExW}
function phoneInitializeEx(var hPhoneApp: HPHONEAPP; hInstance: HINST;
  lpfnCallback: TPhoneCallback; lpszFriendlyAppName: PChar;
  var dwNumDevs, dwAPIVersion: DWORD;
  var PhoneInitializeExParams: TPhoneInitializeExParams): Longint; stdcall; // TAPI v2.0
{$EXTERNALSYM phoneInitializeEx}
{$ENDIF}

function phoneNegotiateAPIVersion(hPhoneApp: HPHONEAPP; dwDeviceID,
  dwAPILowVersion, dwAPIHighVersion: DWORD; var dwAPIVersion: DWORD;
  var lpExtensionID: TPhoneExtensionID): Longint; stdcall;
{$EXTERNALSYM phoneNegotiateAPIVersion}

function phoneNegotiateExtVersion(hPhoneApp: HPHONEAPP; dwDeviceID,
  dwAPIVersion, dwExtLowVersion, dwExtHighVersion: DWORD;
  var dwExtVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneNegotiateExtVersion}

function phoneOpen(hPhoneApp: HPHONEAPP; dwDeviceID: DWORD; var hPhone: HPHONE;
  dwAPIVersion, dwExtVersion, dwCallbackInstance,
  dwPrivilege: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneOpen}

{$IFNDEF TAPI10}
function phoneSetButtonInfoA(hPhone: HPHONE; dwButtonLampID: DWORD;
  pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneSetButtonInfoA}
function phoneSetButtonInfoW(hPhone: HPHONE; dwButtonLampID: DWORD;
  pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneSetButtonInfoW}
function phoneSetButtonInfo(hPhone: HPHONE; dwButtonLampID: DWORD;
  pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneSetButtonInfo}
{$ELSE}
function phoneSetButtonInfo(hPhone: HPHONE; dwButtonLampID: DWORD;
  pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneSetButtonInfo}
{$IFDEF WIN32}
function phoneSetButtonInfoA(hPhone: HPHONE; dwButtonLampID: DWORD;
  pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneSetButtonInfoA}
function phoneSetButtonInfoW(hPhone: HPHONE; dwButtonLampID: DWORD;
  pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM phoneSetButtonInfoW}
{$ENDIF}
{$ENDIF}

function phoneSetData(hPhone: HPHONE; dwDataID: DWORD; lpData: Pointer;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetData}

function phoneSetDisplay(hPhone: HPHONE; dwRow, dwColumn: DWORD;
  lpsDisplay: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetDisplay}

function phoneSetGain(hPhone: HPHONE; dwHookSwitchDev: DWORD;
  dwGain: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetGain}

function phoneSetHookSwitch(hPhone: HPHONE; dwHookSwitchDevs,
  dwHookSwitchMode: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetHookSwitch}

function phoneSetLamp(hPhone: HPHONE; dwButtonLampID,
  dwLampMode: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetLamp}

function phoneSetRing(hPhone: HPHONE; dwRingMode,
  dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetRing}

function phoneSetStatusMessages(hPhone: HPHONE; dwPhoneStates, dwButtonModes,
  dwButtonStates: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetStatusMessages}

function phoneSetVolume(hPhone: HPHONE; dwHookSwitchDev,
  dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM phoneSetVolume}

function phoneShutdown(hPhoneApp: HPHONEAPP): Longint; stdcall;
{$EXTERNALSYM phoneShutdown}

{$IFNDEF TAPI10}
function tapiGetLocationInfoA(lpszCountryCode,
  lpszCityCode: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM tapiGetLocationInfoA}
function tapiGetLocationInfoW(lpszCountryCode,
  lpszCityCode: PWideChar): Longint; stdcall;
{$EXTERNALSYM tapiGetLocationInfoW}
function tapiGetLocationInfo(lpszCountryCode,
  lpszCityCode: PChar): Longint; stdcall;
{$EXTERNALSYM tapiGetLocationInfo}
{$ELSE}
function tapiGetLocationInfo(lpszCountryCode,
  lpszCityCode: LPCSTR): Longint; stdcall;
{$EXTERNALSYM tapiGetLocationInfo}
{$IFDEF WIN32}
function tapiGetLocationInfoA(lpszCountryCode,
  lpszCityCode: LPCSTR): Longint; stdcall;
{$EXTERNALSYM tapiGetLocationInfoA}
function tapiGetLocationInfoW(lpszCountryCode,
  lpszCityCode: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM tapiGetLocationInfoW}
{$ENDIF}
{$ENDIF}

function tapiRequestDrop(hwnd: HWND; wRequestID: WPARAM): Longint; stdcall;
{$EXTERNALSYM tapiRequestDrop}

{$IFNDEF TAPI10}
function tapiRequestMakeCallA(lpszDestAddress, lpszAppName, lpszCalledParty,
  lpszComment: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM tapiRequestMakeCallA}
function tapiRequestMakeCallW(lpszDestAddress, lpszAppName, lpszCalledParty,
  lpszComment: PWideChar): Longint; stdcall;
{$EXTERNALSYM tapiRequestMakeCallW}
function tapiRequestMakeCall(lpszDestAddress, lpszAppName, lpszCalledParty,
  lpszComment: PChar): Longint; stdcall;
{$EXTERNALSYM tapiRequestMakeCall}
{$ELSE}
function tapiRequestMakeCall(lpszDestAddress, lpszAppName, lpszCalledParty,
  lpszComment: LPCSTR): Longint; stdcall;
{$EXTERNALSYM tapiRequestMakeCall}
{$IFDEF WIN32}
function tapiRequestMakeCallA(lpszDestAddress, lpszAppName, lpszCalledParty,
  lpszComment: LPCSTR): Longint; stdcall;
{$EXTERNALSYM tapiRequestMakeCallA}
function tapiRequestMakeCallW(lpszDestAddress, lpszAppName, lpszCalledParty,
  lpszComment: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM tapiRequestMakeCallW}
{$ENDIF}
{$ENDIF}

{$IFNDEF TAPI10}
function tapiRequestMediaCallA(hwnd: HWND; wRequestID: WPARAM; lpszDeviceClass,
  lpDeviceID: PAnsiChar; dwSize, dwSecure: DWORD; lpszDestAddress, lpszAppName,
  lpszCalledParty, lpszComment: PAnsiChar): Longint; stdcall;
{$EXTERNALSYM tapiRequestMediaCallA}
function tapiRequestMediaCallW(hwnd: HWND; wRequestID: WPARAM; lpszDeviceClass,
  lpDeviceID: PWideChar; dwSize, dwSecure: DWORD; lpszDestAddress, lpszAppName,
  lpszCalledParty, lpszComment: PWideChar): Longint; stdcall;
{$EXTERNALSYM tapiRequestMediaCallW}
function tapiRequestMediaCall(hwnd: HWND; wRequestID: WPARAM; lpszDeviceClass,
  lpDeviceID: PChar; dwSize, dwSecure: DWORD; lpszDestAddress, lpszAppName,
  lpszCalledParty, lpszComment: PChar): Longint; stdcall;
{$EXTERNALSYM tapiRequestMediaCall}
{$ELSE}
function tapiRequestMediaCall(hwnd: HWND; wRequestID: WPARAM; lpszDeviceClass,
  lpDeviceID: LPCSTR; dwSize, dwSecure: DWORD; lpszDestAddress, lpszAppName,
  lpszCalledParty, lpszComment: LPCSTR): Longint; stdcall;
{$EXTERNALSYM tapiRequestMediaCall}
{$IFDEF WIN32}
function tapiRequestMediaCallA(hwnd: HWND; wRequestID: WPARAM; lpszDeviceClass,
  lpDeviceID: LPCSTR; dwSize, dwSecure: DWORD; lpszDestAddress, lpszAppName,
  lpszCalledParty, lpszComment: LPCSTR): Longint; stdcall;
{$EXTERNALSYM tapiRequestMediaCallA}
function tapiRequestMediaCallW(hwnd: HWND; wRequestID: WPARAM; lpszDeviceClass,
  lpDeviceID: LPCWSTR; dwSize, dwSecure: DWORD; lpszDestAddress, lpszAppName,
  lpszCalledParty, lpszComment: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM tapiRequestMediaCallW}
{$ENDIF}
{$ENDIF}

(*
 * TAPIERROR_FORMATMESSAGE - macro to convert a TAPI error constant
 *                           into a constant that FormatMessage will accept
 *
 *      TAPIERR : Negative numbers and 0
 *          Map to : strip off high WORD
 *          Example: 0xFFFFFFFF (-1) becomes 0x0000FFFF
 *      LINEERR : Start at 0x80000000
 *          Map to : strip off 0x80000000 and add 0xE000
 *          Example: 0x80000004 becomes 0x0000E004
 *      PHONEERR: Start at 0x90000000
 *          Map to : strip off 0x90000000 and add 0xF000
 *          Example: 0x9000000A becomes 0x0000F00A
 *
 *      pseudocode:
 *
 *      if (__ErrCode__ is a TAPIERR)
 *          strip off high word
 *
 *          else if (__ErrCode__ is a PHONEERR)
 *              strip off 0x90000000
 *              add 0xE000
 *
 *              else
 *                  strip off 0x80000000
 *                  add 0xF000
 *)

function TapiErrorFormatMessage(ErrCode: DWORD): Longint;

function TAPIERROR_FORMATMESSAGE(ErrCode: DWORD): Longint;
{$EXTERNALSYM TAPIERROR_FORMATMESSAGE}

implementation

const
  TapiDll = 'tapi32.dll';

function lineAccept; external TapiDll name 'lineAccept';
{$IFNDEF TAPI10}
function lineAddProviderA; external TapiDll name 'lineAddProviderA';
function lineAddProviderW; external TapiDll name 'lineAddProviderW';
function lineAddProvider; external TapiDll name 'lineAddProviderA';
{$ELSE}
function lineAddProvider; external TapiDll name 'lineAddProvider';
{$IFDEF WIN32}
function lineAddProviderA; external TapiDll name 'lineAddProviderA';
function lineAddProviderW; external TapiDll name 'lineAddProviderW';
{$ENDIF}
{$ENDIF}
function lineAddToConference; external TapiDll name 'lineAddToConference';
{$IFDEF TAPI20}
function lineAgentSpecific; external TapiDll name 'lineAgentSpecific';
{$ENDIF}
function lineAnswer; external TapiDll name 'lineAnswer';
{$IFNDEF TAPI10}
function lineBlindTransferA; external TapiDll name 'lineBlindTransferA';
function lineBlindTransferW; external TapiDll name 'lineBlindTransferW';
function lineBlindTransfer; external TapiDll name 'lineBlindTransferA';
{$ELSE}
function lineBlindTransfer; external TapiDll name 'lineBlindTransfer';
{$IFDEF WIN32}
function lineBlindTransferA; external TapiDll name 'lineBlindTransferA';
function lineBlindTransferW; external TapiDll name 'lineBlindTransferW';
{$ENDIF}
{$ENDIF}
function lineClose; external TapiDll name 'lineClose';
function lineCompleteCall; external TapiDll name 'lineCompleteCall';
function lineCompleteTransfer; external TapiDll name 'lineCompleteTransfer';
{$IFNDEF TAPI10}
function lineConfigDialogA; external TapiDll name 'lineConfigDialogA';
function lineConfigDialogW; external TapiDll name 'lineConfigDialogW';
function lineConfigDialog; external TapiDll name 'lineConfigDialogA';
{$ELSE}
function lineConfigDialog; external TapiDll name 'lineConfigDialog';
{$IFDEF WIN32}
function lineConfigDialogA; external TapiDll name 'lineConfigDialogA';
function lineConfigDialogW; external TapiDll name 'lineConfigDialogW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineConfigDialogEditA; external TapiDll name 'lineConfigDialogEditA';
function lineConfigDialogEditW; external TapiDll name 'lineConfigDialogEditW';
function lineConfigDialogEdit; external TapiDll name 'lineConfigDialogEditA';
{$ELSE}
function lineConfigDialogEdit; external TapiDll name 'lineConfigDialogEdit';
{$IFDEF WIN32}
function lineConfigDialogEditA; external TapiDll name 'lineConfigDialogEditA';
function lineConfigDialogEditW; external TapiDll name 'lineConfigDialogEditW';
{$ENDIF}
{$ENDIF}
function lineConfigProvider; external TapiDll name 'lineConfigProvider';
{$IFDEF TAPI22}
function lineCreateAgentA; external TapiDll name 'lineCreateAgentA';
function lineCreateAgentW; external TapiDll name 'lineCreateAgentW';
function lineCreateAgent; external TapiDll name 'lineCreateAgentA';
function lineCreateAgentSessionA; external TapiDll name 'lineCreateAgentSessionA';
function lineCreateAgentSessionW; external TapiDll name 'lineCreateAgentSessionW';
function lineCreateAgentSession; external TapiDll name 'lineCreateAgentSessionA';
{$ENDIF}
function lineDeallocateCall; external TapiDll name 'lineDeallocateCall';
function lineDevSpecific; external TapiDll name 'lineDevSpecific';
function lineDevSpecificFeature; external TapiDll name 'lineDevSpecificFeature';
{$IFNDEF TAPI10}
function lineDialA; external TapiDll name 'lineDialA';
function lineDialW; external TapiDll name 'lineDialW';
function lineDial; external TapiDll name 'lineDialA';
{$ELSE}
function lineDial; external TapiDll name 'lineDial';
{$IFDEF WIN32}
function lineDialA; external TapiDll name 'lineDialA';
function lineDialW; external TapiDll name 'lineDialW';
{$ENDIF}
{$ENDIF}
function lineDrop; external TapiDll name 'lineDrop';
{$IFNDEF TAPI10}
function lineForwardA; external TapiDll name 'lineForwardA';
function lineForwardW; external TapiDll name 'lineForwardW';
function lineForward; external TapiDll name 'lineForwardA';
{$ELSE}
function lineForward; external TapiDll name 'lineForward';
{$IFDEF WIN32}
function lineForwardA; external TapiDll name 'lineForwardA';
function lineForwardW; external TapiDll name 'lineForwardW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGatherDigitsA; external TapiDll name 'lineGatherDigitsA';
function lineGatherDigitsW; external TapiDll name 'lineGatherDigitsW';
function lineGatherDigits; external TapiDll name 'lineGatherDigitsA';
{$ELSE}
function lineGatherDigits; external TapiDll name 'lineGatherDigits';
{$IFDEF WIN32}
function lineGatherDigitsA; external TapiDll name 'lineGatherDigitsA';
function lineGatherDigitsW; external TapiDll name 'lineGatherDigitsW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGenerateDigitsA; external TapiDll name 'lineGenerateDigitsA';
function lineGenerateDigitsW; external TapiDll name 'lineGenerateDigitsW';
function lineGenerateDigits; external TapiDll name 'lineGenerateDigitsA';
{$ELSE}
function lineGenerateDigits; external TapiDll name 'lineGenerateDigits';
{$IFDEF WIN32}
function lineGenerateDigitsA; external TapiDll name 'lineGenerateDigitsA';
function lineGenerateDigitsW; external TapiDll name 'lineGenerateDigitsW';
{$ENDIF}
{$ENDIF}
function lineGenerateTone; external TapiDll name 'lineGenerateTone';
{$IFNDEF TAPI10}
function lineGetAddressCapsA; external TapiDll name 'lineGetAddressCapsA';
function lineGetAddressCapsW; external TapiDll name 'lineGetAddressCapsW';
function lineGetAddressCaps; external TapiDll name 'lineGetAddressCapsA';
{$ELSE}
function lineGetAddressCaps; external TapiDll name 'lineGetAddressCaps';
{$IFDEF WIN32}
function lineGetAddressCapsA; external TapiDll name 'lineGetAddressCapsA';
function lineGetAddressCapsW; external TapiDll name 'lineGetAddressCapsW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetAddressIDA; external TapiDll name 'lineGetAddressIDA';
function lineGetAddressIDW; external TapiDll name 'lineGetAddressIDW';
function lineGetAddressID; external TapiDll name 'lineGetAddressIDA';
{$ELSE}
function lineGetAddressID; external TapiDll name 'lineGetAddressID';
{$IFDEF WIN32}
function lineGetAddressIDA; external TapiDll name 'lineGetAddressIDA';
function lineGetAddressIDW; external TapiDll name 'lineGetAddressIDW';
{$ENDIF}
{$ENDIF}
function lineGetAddressStatusA; external TapiDll name 'lineGetAddressStatusA';
function lineGetAddressStatusW; external TapiDll name 'lineGetAddressStatusW';
function lineGetAddressStatus; external TapiDll name 'lineGetAddressStatusA';
{$IFDEF TAPI20}
function lineGetAgentActivityListA; external TapiDll name 'lineGetAgentActivityListA';
function lineGetAgentActivityListW; external TapiDll name 'lineGetAgentActivityListW';
function lineGetAgentActivityList; external TapiDll name 'lineGetAgentActivityListA';
function lineGetAgentCapsA; external TapiDll name 'lineGetAgentCapsA';
function lineGetAgentCapsW; external TapiDll name 'lineGetAgentCapsW';
function lineGetAgentCaps; external TapiDll name 'lineGetAgentCapsA';
function lineGetAgentGroupListA; external TapiDll name 'lineGetAgentGroupListA';
function lineGetAgentGroupListW; external TapiDll name 'lineGetAgentGroupListW';
function lineGetAgentGroupList; external TapiDll name 'lineGetAgentGroupListA';
{$IFDEF TAPI22}
function lineGetAgentInfo; external TapiDll name 'lineGetAgentInfo';
function lineGetAgentSessionInfo; external TapiDll name 'lineGetAgentSessionInfo';
function lineGetAgentSessionList; external TapiDll name 'lineGetAgentSessionList';
{$ENDIF}
function lineGetAgentStatusA; external TapiDll name 'lineGetAgentStatusA';
function lineGetAgentStatusW; external TapiDll name 'lineGetAgentStatusW';
function lineGetAgentStatus; external TapiDll name 'lineGetAgentStatusA';
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetAppPriorityA; external TapiDll name 'lineGetAppPriorityA';
function lineGetAppPriorityW; external TapiDll name 'lineGetAppPriorityW';
function lineGetAppPriority; external TapiDll name 'lineGetAppPriorityA';
{$ELSE}
function lineGetAppPriority; external TapiDll name 'lineGetAppPriority';
{$IFDEF WIN32}
function lineGetAppPriorityA; external TapiDll name 'lineGetAppPriorityA';
function lineGetAppPriorityW; external TapiDll name 'lineGetAppPriorityW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetCallInfoA; external TapiDll name 'lineGetCallInfoA';
function lineGetCallInfoW; external TapiDll name 'lineGetCallInfoW';
function lineGetCallInfo; external TapiDll name 'lineGetCallInfoA';
{$ELSE}
function lineGetCallInfo; external TapiDll name 'lineGetCallInfo';
{$IFDEF WIN32}
function lineGetCallInfoA; external TapiDll name 'lineGetCallInfoA';
function lineGetCallInfoW; external TapiDll name 'lineGetCallInfoW';
{$ENDIF}
{$ENDIF}
function lineGetCallStatus; external TapiDll name 'lineGetCallStatus';
function lineGetConfRelatedCalls; external TapiDll name 'lineGetConfRelatedCalls';
{$IFNDEF TAPI10}
function lineGetCountryA; external TapiDll name 'lineGetCountryA';
function lineGetCountryW; external TapiDll name 'lineGetCountryW';
function lineGetCountry; external TapiDll name 'lineGetCountryA';
{$ELSE}
function lineGetCountry; external TapiDll name 'lineGetCountry';
{$IFDEF WIN32}
function lineGetCountryA; external TapiDll name 'lineGetCountryA';
function lineGetCountryW; external TapiDll name 'lineGetCountryW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetDevCapsA; external TapiDll name 'lineGetDevCapsA';
function lineGetDevCapsW; external TapiDll name 'lineGetDevCapsW';
function lineGetDevCaps; external TapiDll name 'lineGetDevCapsA';
{$ELSE}
function lineGetDevCaps; external TapiDll name 'lineGetDevCaps';
{$IFDEF WIN32}
function lineGetDevCapsA; external TapiDll name 'lineGetDevCapsA';
function lineGetDevCapsW; external TapiDll name 'lineGetDevCapsW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetDevConfigA; external TapiDll name 'lineGetDevConfigA';
function lineGetDevConfigW; external TapiDll name 'lineGetDevConfigW';
function lineGetDevConfig; external TapiDll name 'lineGetDevConfigA';
{$ELSE}
function lineGetDevConfig; external TapiDll name 'lineGetDevConfig';
{$IFDEF WIN32}
function lineGetDevConfigA; external TapiDll name 'lineGetDevConfigA';
function lineGetDevConfigW; external TapiDll name 'lineGetDevConfigW';
{$ENDIF}
{$ENDIF}
{$IFDEF TAPI22}
function lineGetGroupListA; external TapiDll name 'lineGetGroupListA';
function lineGetGroupListW; external TapiDll name 'lineGetGroupListW';
function lineGetGroupList; external TapiDll name 'lineGetGroupListA';
{$ENDIF}
function lineGetNewCalls; external TapiDll name 'lineGetNewCalls';
{$IFNDEF TAPI10}
function lineGetIconA; external TapiDll name 'lineGetIconA';
function lineGetIconW; external TapiDll name 'lineGetIconW';
function lineGetIcon; external TapiDll name 'lineGetIconA';
{$ELSE}
function lineGetIcon; external TapiDll name 'lineGetIcon';
{$IFDEF WIN32}
function lineGetIconA; external TapiDll name 'lineGetIconA';
function lineGetIconW; external TapiDll name 'lineGetIconW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetIDA; external TapiDll name 'lineGetIDA';
function lineGetIDW; external TapiDll name 'lineGetIDW';
function lineGetID; external TapiDll name 'lineGetIDA';
{$ELSE}
function lineGetID; external TapiDll name 'lineGetID';
{$IFDEF WIN32}
function lineGetIDA; external TapiDll name 'lineGetIDA';
function lineGetIDW; external TapiDll name 'lineGetIDW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetLineDevStatusA; external TapiDll name 'lineGetLineDevStatusA';
function lineGetLineDevStatusW; external TapiDll name 'lineGetLineDevStatusW';
function lineGetLineDevStatus; external TapiDll name 'lineGetLineDevStatusA';
{$ELSE}
function lineGetLineDevStatus; external TapiDll name 'lineGetLineDevStatus';
{$IFDEF WIN32}
function lineGetLineDevStatusA; external TapiDll name 'lineGetLineDevStatusA';
function lineGetLineDevStatusW; external TapiDll name 'lineGetLineDevStatusW';
{$ENDIF}
{$ENDIF}
{$IFDEF TAPI20}
function lineGetMessage; external TapiDll name 'lineGetMessage';
{$ENDIF}
function lineGetNumRings; external TapiDll name 'lineGetNumRings';
{$IFNDEF TAPI10}
function lineGetProviderListA; external TapiDll name 'lineGetProviderListA';
function lineGetProviderListW; external TapiDll name 'lineGetProviderListW';
function lineGetProviderList; external TapiDll name 'lineGetProviderListA';
{$ELSE}
function lineGetProviderList; external TapiDll name 'lineGetProviderList';
{$IFDEF WIN32}
function lineGetProviderListA; external TapiDll name 'lineGetProviderListA';
function lineGetProviderListW; external TapiDll name 'lineGetProviderListW';
{$ENDIF}
{$ENDIF}
{$IFDEF TAPI22}
function lineGetProxyStatus; external TapiDll name 'lineGetProxyStatus';
function lineGetQueueInfo; external TapiDll name 'lineGetQueueInfo';
function lineGetQueueListA; external TapiDll name 'lineGetQueueListA';
function lineGetQueueListW; external TapiDll name 'lineGetQueueListW';
function lineGetQueueList; external TapiDll name 'lineGetQueueListA';
{$ENDIF}
{$IFNDEF TAPI10}
function lineGetRequestA; external TapiDll name 'lineGetRequestA';
function lineGetRequestW; external TapiDll name 'lineGetRequestW';
function lineGetRequest; external TapiDll name 'lineGetRequestA';
{$ELSE}
function lineGetRequest; external TapiDll name 'lineGetRequest';
{$IFDEF WIN32}
function lineGetRequestA; external TapiDll name 'lineGetRequestA';
function lineGetRequestW; external TapiDll name 'lineGetRequestW';
{$ENDIF}
{$ENDIF}
function lineGetStatusMessages; external TapiDll name 'lineGetStatusMessages';
{$IFNDEF TAPI10}
function lineGetTranslateCapsA; external TapiDll name 'lineGetTranslateCapsA';
function lineGetTranslateCapsW; external TapiDll name 'lineGetTranslateCapsW';
function lineGetTranslateCaps; external TapiDll name 'lineGetTranslateCapsA';
{$ELSE}
function lineGetTranslateCaps; external TapiDll name 'lineGetTranslateCaps';
{$IFDEF WIN32}
function lineGetTranslateCapsA; external TapiDll name 'lineGetTranslateCapsA';
function lineGetTranslateCapsW; external TapiDll name 'lineGetTranslateCapsW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineHandoffA; external TapiDll name 'lineHandoffA';
function lineHandoffW; external TapiDll name 'lineHandoffW';
function lineHandoff; external TapiDll name 'lineHandoffA';
{$ELSE}
function lineHandoff; external TapiDll name 'lineHandoff';
{$IFDEF WIN32}
function lineHandoffA; external TapiDll name 'lineHandoffA';
function lineHandoffW; external TapiDll name 'lineHandoffW';
{$ENDIF}
{$ENDIF}
function lineHold; external TapiDll name 'lineHold';
function lineInitialize; external TapiDll name 'lineInitialize';
{$IFDEF TAPI20}
function lineInitializeExA; external TapiDll name 'lineInitializeExA';
function lineInitializeExW; external TapiDll name 'lineInitializeExW';
function lineInitializeEx; external TapiDll name 'lineInitializeExA';
{$ENDIF}
{$IFNDEF TAPI10}
function lineMakeCallA; external TapiDll name 'lineMakeCallA';
function lineMakeCallW; external TapiDll name 'lineMakeCallW';
function lineMakeCall; external TapiDll name 'lineMakeCallA';
{$ELSE}
function lineMakeCall; external TapiDll name 'lineMakeCall';
{$IFDEF WIN32}
function lineMakeCallA; external TapiDll name 'lineMakeCallA';
function lineMakeCallW; external TapiDll name 'lineMakeCallW';
{$ENDIF}
{$ENDIF}
function lineMonitorDigits; external TapiDll name 'lineMonitorDigits';
function lineMonitorMedia; external TapiDll name 'lineMonitorMedia';
function lineMonitorTones; external TapiDll name 'lineMonitorTones';
function lineNegotiateAPIVersion; external TapiDll name 'lineNegotiateAPIVersion';
function lineNegotiateExtVersion; external TapiDll name 'lineNegotiateExtVersion';
{$IFNDEF TAPI10}
function lineOpenA; external TapiDll name 'lineOpenA';
function lineOpenW; external TapiDll name 'lineOpenW';
function lineOpen; external TapiDll name 'lineOpenA';
{$ELSE}
function lineOpen; external TapiDll name 'lineOpen';
{$IFDEF WIN32}
function lineOpenA; external TapiDll name 'lineOpenA';
function lineOpenW; external TapiDll name 'lineOpenW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineParkA; external TapiDll name 'lineParkA';
function lineParkW; external TapiDll name 'lineParkW';
function linePark; external TapiDll name 'lineParkA';
{$ELSE}
function linePark; external TapiDll name 'linePark';
{$IFDEF WIN32}
function lineParkA; external TapiDll name 'lineParkA';
function lineParkW; external TapiDll name 'lineParkW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function linePickupA; external TapiDll name 'linePickupA';
function linePickupW; external TapiDll name 'linePickupW';
function linePickup; external TapiDll name 'linePickupA';
{$ELSE}
function linePickup; external TapiDll name 'linePickup';
{$IFDEF WIN32}
function linePickupA; external TapiDll name 'linePickupA';
function linePickupW; external TapiDll name 'linePickupW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function linePrepareAddToConferenceA; external TapiDll name 'linePrepareAddToConferenceA';
function linePrepareAddToConferenceW; external TapiDll name 'linePrepareAddToConferenceW';
function linePrepareAddToConference; external TapiDll name 'linePrepareAddToConferenceA';
{$ELSE}
function linePrepareAddToConference; external TapiDll name 'linePrepareAddToConference';
{$IFDEF WIN32}
function linePrepareAddToConferenceA; external TapiDll name 'linePrepareAddToConferenceA';
function linePrepareAddToConferenceW; external TapiDll name 'linePrepareAddToConferenceW';
{$ENDIF}
{$ENDIF}
{$IFDEF TAPI20}
function lineProxyMessage; external TapiDll name 'lineProxyMessage';
function lineProxyResponse; external TapiDll name 'lineProxyResponse';
{$ENDIF}
{$IFNDEF TAPI10}
function lineRedirectA; external TapiDll name 'lineRedirectA';
function lineRedirectW; external TapiDll name 'lineRedirectW';
function lineRedirect; external TapiDll name 'lineRedirectA';
{$ELSE}
function lineRedirect; external TapiDll name 'lineRedirect';
{$IFDEF WIN32}
function lineRedirectA; external TapiDll name 'lineRedirectA';
function lineRedirectW; external TapiDll name 'lineRedirectW';
{$ENDIF}
{$ENDIF}
function lineRegisterRequestRecipient; external TapiDll name 'lineRegisterRequestRecipient';
function lineReleaseUserUserInfo; external TapiDll name 'lineReleaseUserUserInfo';
function lineRemoveFromConference; external TapiDll name 'lineRemoveFromConference';
function lineRemoveProvider; external TapiDll name 'lineRemoveProvider';
function lineSecureCall; external TapiDll name 'lineSecureCall';
function lineSendUserUserInfo; external TapiDll name 'lineSendUserUserInfo';
{$IFDEF TAPI20}
function lineSetAgentActivity; external TapiDll name 'lineSetAgentActivity';
function lineSetAgentGroup; external TapiDll name 'lineSetAgentGroup';
{$IFDEF TAPI22}
function lineSetAgentMeasurementPeriod; external TapiDll name 'lineSetAgentMeasurementPeriod';
function lineSetAgentSessionState; external TapiDll name 'lineSetAgentSessionState';
function lineSetAgentStateEx; external TapiDll name 'lineSetAgentStateEx';
{$ENDIF}
function lineSetAgentState; external TapiDll name 'lineSetAgentState';
{$ENDIF}
{$IFNDEF TAPI10}
function lineSetAppPriorityA; external TapiDll name 'lineSetAppPriorityA';
function lineSetAppPriorityW; external TapiDll name 'lineSetAppPriorityW';
function lineSetAppPriority; external TapiDll name 'lineSetAppPriorityA';
{$ELSE}
function lineSetAppPriority; external TapiDll name 'lineSetAppPriority';
{$IFDEF WIN32}
function lineSetAppPriorityA; external TapiDll name 'lineSetAppPriorityA';
function lineSetAppPriorityW; external TapiDll name 'lineSetAppPriorityW';
{$ENDIF}
{$ENDIF}
function lineSetAppSpecific; external TapiDll name 'lineSetAppSpecific';
{$IFDEF TAPI20}
function lineSetCallData; external TapiDll name 'lineSetCallData';
{$ENDIF}
function lineSetCallParams; external TapiDll name 'lineSetCallParams';
function lineSetCallPrivilege; external TapiDll name 'lineSetCallPrivilege';
{$IFDEF TAPI20}
function lineSetCallQualityOfService; external TapiDll name 'lineSetCallQualityOfService';
function lineSetCallTreatment; external TapiDll name 'lineSetCallTreatment';
{$ENDIF}
function lineSetCurrentLocation; external TapiDll name 'lineSetCurrentLocation';
{$IFNDEF TAPI10}
function lineSetDevConfigA; external TapiDll name 'lineSetDevConfigA';
function lineSetDevConfigW; external TapiDll name 'lineSetDevConfigW';
function lineSetDevConfig; external TapiDll name 'lineSetDevConfigA';
{$ELSE}
function lineSetDevConfig; external TapiDll name 'lineSetDevConfig';
{$IFDEF WIN32}
function lineSetDevConfigA; external TapiDll name 'lineSetDevConfigA';
function lineSetDevConfigW; external TapiDll name 'lineSetDevConfigW';
{$ENDIF}
{$ENDIF}
{$IFDEF TAPI20}
function lineSetLineDevStatus; external TapiDll name 'lineSetLineDevStatus';
{$ENDIF}
function lineSetMediaControl; external TapiDll name 'lineSetMediaControl';
function lineSetMediaMode; external TapiDll name 'lineSetMediaMode';
{$IFDEF TAPI22}
function lineSetQueueMeasurementPeriod; external TapiDll name 'lineSetQueueMeasurementPeriod';
{$ENDIF}
function lineSetNumRings; external TapiDll name 'lineSetNumRings';
function lineSetStatusMessages; external TapiDll name 'lineSetStatusMessages';
function lineSetTerminal; external TapiDll name 'lineSetTerminal';
{$IFNDEF TAPI10}
function lineSetTollListA; external TapiDll name 'lineSetTollListA';
function lineSetTollListW; external TapiDll name 'lineSetTollListW';
function lineSetTollList; external TapiDll name 'lineSetTollListA';
{$ELSE}
function lineSetTollList; external TapiDll name 'lineSetTollList';
{$IFDEF WIN32}
function lineSetTollListA; external TapiDll name 'lineSetTollListA';
function lineSetTollListW; external TapiDll name 'lineSetTollListW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineSetupConferenceA; external TapiDll name 'lineSetupConferenceA';
function lineSetupConferenceW; external TapiDll name 'lineSetupConferenceW';
function lineSetupConference; external TapiDll name 'lineSetupConferenceA';
{$ELSE}
function lineSetupConference; external TapiDll name 'lineSetupConference';
{$IFDEF WIN32}
function lineSetupConferenceA; external TapiDll name 'lineSetupConferenceA';
function lineSetupConferenceW; external TapiDll name 'lineSetupConferenceW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineSetupTransferA; external TapiDll name 'lineSetupTransferA';
function lineSetupTransferW; external TapiDll name 'lineSetupTransferW';
function lineSetupTransfer; external TapiDll name 'lineSetupTransferA';
{$ELSE}
function lineSetupTransfer; external TapiDll name 'lineSetupTransfer';
{$IFDEF WIN32}
function lineSetupTransferA; external TapiDll name 'lineSetupTransferA';
function lineSetupTransferW; external TapiDll name 'lineSetupTransferW';
{$ENDIF}
{$ENDIF}
function lineShutdown; external TapiDll name 'lineShutdown';
function lineSwapHold; external TapiDll name 'lineSwapHold';
{$IFNDEF TAPI10}
function lineTranslateAddressA; external TapiDll name 'lineTranslateAddressA';
function lineTranslateAddressW; external TapiDll name 'lineTranslateAddressW';
function lineTranslateAddress; external TapiDll name 'lineTranslateAddressA';
{$ELSE}
function lineTranslateAddress; external TapiDll name 'lineTranslateAddress';
{$IFDEF WIN32}
function lineTranslateAddressA; external TapiDll name 'lineTranslateAddressA';
function lineTranslateAddressW; external TapiDll name 'lineTranslateAddressW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function lineTranslateDialogA; external TapiDll name 'lineTranslateDialogA';
function lineTranslateDialogW; external TapiDll name 'lineTranslateDialogW';
function lineTranslateDialog; external TapiDll name 'lineTranslateDialogA';
{$ELSE}
function lineTranslateDialog; external TapiDll name 'lineTranslateDialog';
{$IFDEF WIN32}
function lineTranslateDialogA; external TapiDll name 'lineTranslateDialogA';
function lineTranslateDialogW; external TapiDll name 'lineTranslateDialogW';
{$ENDIF}
{$ENDIF}
function lineUncompleteCall; external TapiDll name 'lineUncompleteCall';
function lineUnhold; external TapiDll name 'lineUnhold';
{$IFNDEF TAPI10}
function lineUnparkA; external TapiDll name 'lineUnparkA';
function lineUnparkW; external TapiDll name 'lineUnparkW';
function lineUnpark; external TapiDll name 'lineUnparkA';
{$ELSE}
function lineUnpark; external TapiDll name 'lineUnpark'
{$IFDEF WIN32}
function lineUnparkA; external TapiDll name 'lineUnparkA'
function lineUnparkW; external TapiDll name 'lineUnparkW'
{$ENDIF}
{$ENDIF}

function phoneClose; external TapiDll name 'phoneClose';
{$IFNDEF TAPI10}
function phoneConfigDialogA; external TapiDll name 'phoneConfigDialogA';
function phoneConfigDialogW; external TapiDll name 'phoneConfigDialogW';
function phoneConfigDialog; external TapiDll name 'phoneConfigDialogA';
{$ELSE}
function phoneConfigDialog; external TapiDll name 'phoneConfigDialog';
{$IFDEF WIN32}
function phoneConfigDialogA; external TapiDll name 'phoneConfigDialogA';
function phoneConfigDialogW; external TapiDll name 'phoneConfigDialogW';
{$ENDIF}
{$ENDIF}
function phoneDevSpecific; external TapiDll name 'phoneDevSpecific';
{$IFNDEF TAPI10}
function phoneGetButtonInfoA; external TapiDll name 'phoneGetButtonInfoA';
function phoneGetButtonInfoW; external TapiDll name 'phoneGetButtonInfoW';
function phoneGetButtonInfo; external TapiDll name 'phoneGetButtonInfoA';
{$ELSE}
function phoneGetButtonInfo; external TapiDll name 'phoneGetButtonInfo';
{$IFDEF WIN32}
function phoneGetButtonInfoA; external TapiDll name 'phoneGetButtonInfoA';
function phoneGetButtonInfoW; external TapiDll name 'phoneGetButtonInfoW';
{$ENDIF}
{$ENDIF}
function phoneGetData; external TapiDll name 'phoneGetData';
{$IFNDEF TAPI10}
function phoneGetDevCapsA; external TapiDll name 'phoneGetDevCapsA';
function phoneGetDevCapsW; external TapiDll name 'phoneGetDevCapsW';
function phoneGetDevCaps; external TapiDll name 'phoneGetDevCapsA';
{$ELSE}
function phoneGetDevCaps; external TapiDll name 'phoneGetDevCaps';
{$IFDEF WIN32}
function phoneGetDevCapsA; external TapiDll name 'phoneGetDevCapsA';
function phoneGetDevCapsW; external TapiDll name 'phoneGetDevCapsW';
{$ENDIF}
{$ENDIF}
function phoneGetDisplay; external TapiDll name 'phoneGetDisplay';
function phoneGetGain; external TapiDll name 'phoneGetGain';
function phoneGetHookSwitch; external TapiDll name 'phoneGetHookSwitch';
{$IFNDEF TAPI10}
function phoneGetIconA; external TapiDll name 'phoneGetIconA';
function phoneGetIconW; external TapiDll name 'phoneGetIconW';
function phoneGetIcon; external TapiDll name 'phoneGetIconA';
{$ELSE}
function phoneGetIcon; external TapiDll name 'phoneGetIcon';
{$IFDEF WIN32}
function phoneGetIconA; external TapiDll name 'phoneGetIconA';
function phoneGetIconW; external TapiDll name 'phoneGetIconW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function phoneGetIDA; external TapiDll name 'phoneGetIDA';
function phoneGetIDW; external TapiDll name 'phoneGetIDW';
function phoneGetID; external TapiDll name 'phoneGetIDA';
{$ELSE}
function phoneGetID; external TapiDll name 'phoneGetID';
{$IFDEF WIN32}
function phoneGetIDA; external TapiDll name 'phoneGetIDA';
function phoneGetIDW; external TapiDll name 'phoneGetIDW';
{$ENDIF}
{$ENDIF}
function phoneGetLamp; external TapiDll name 'phoneGetLamp';
{$IFDEF TAPI20}
function phoneGetMessage; external TapiDll name 'phoneGetMessage';
{$ENDIF}
function phoneGetRing; external TapiDll name 'phoneGetRing';
{$IFNDEF TAPI10}
function phoneGetStatusA; external TapiDll name 'phoneGetStatusA';
function phoneGetStatusW; external TapiDll name 'phoneGetStatusW';
function phoneGetStatus; external TapiDll name 'phoneGetStatusA';
{$ELSE}
function phoneGetStatus; external TapiDll name 'phoneGetStatus';
{$IFDEF WIN32}
function phoneGetStatusA; external TapiDll name 'phoneGetStatusA';
function phoneGetStatusW; external TapiDll name 'phoneGetStatusW';
{$ENDIF}
{$ENDIF}
function phoneGetStatusMessages; external TapiDll name 'phoneGetStatusMessages';
function phoneGetVolume; external TapiDll name 'phoneGetVolume';
function phoneInitialize; external TapiDll name 'phoneInitialize';
{$IFDEF TAPI20}
function phoneInitializeExA; external TapiDll name 'phoneInitializeExA';
function phoneInitializeExW; external TapiDll name 'phoneInitializeExW';
function phoneInitializeEx; external TapiDll name 'phoneInitializeExA';
{$ENDIF}
function phoneNegotiateAPIVersion; external TapiDll name 'phoneNegotiateAPIVersion';
function phoneNegotiateExtVersion; external TapiDll name 'phoneNegotiateExtVersion';
function phoneOpen; external TapiDll name 'phoneOpen';
{$IFNDEF TAPI10}
function phoneSetButtonInfoA; external TapiDll name 'phoneSetButtonInfoA';
function phoneSetButtonInfoW; external TapiDll name 'phoneSetButtonInfoW';
function phoneSetButtonInfo; external TapiDll name 'phoneSetButtonInfoA';
{$ELSE}
function phoneSetButtonInfo; external TapiDll name 'phoneSetButtonInfo';
{$IFDEF WIN32}
function phoneSetButtonInfoA; external TapiDll name 'phoneSetButtonInfoA';
function phoneSetButtonInfoW; external TapiDll name 'phoneSetButtonInfoW';
{$ENDIF}
{$ENDIF}
function phoneSetData; external TapiDll name 'phoneSetData';
function phoneSetDisplay; external TapiDll name 'phoneSetDisplay';
function phoneSetGain; external TapiDll name 'phoneSetGain';
function phoneSetHookSwitch; external TapiDll name 'phoneSetHookSwitch';
function phoneSetLamp; external TapiDll name 'phoneSetLamp';
function phoneSetRing; external TapiDll name 'phoneSetRing';
function phoneSetStatusMessages; external TapiDll name 'phoneSetStatusMessages';
function phoneSetVolume; external TapiDll name 'phoneSetVolume';
function phoneShutdown; external TapiDll name 'phoneShutdown';

{$IFNDEF TAPI10}
function tapiGetLocationInfoA; external TapiDll name 'tapiGetLocationInfoA';
function tapiGetLocationInfoW; external TapiDll name 'tapiGetLocationInfoW';
function tapiGetLocationInfo; external TapiDll name 'tapiGetLocationInfoA';
{$ELSE}
function tapiGetLocationInfo; external TapiDll name 'tapiGetLocationInfo';
{$IFDEF WIN32}
function tapiGetLocationInfoA; external TapiDll name 'tapiGetLocationInfoA';
function tapiGetLocationInfoW; external TapiDll name 'tapiGetLocationInfoW';
{$ENDIF}
{$ENDIF}
function tapiRequestDrop; external TapiDll name 'tapiRequestDrop';
{$IFNDEF TAPI10}
function tapiRequestMakeCallA; external TapiDll name 'tapiRequestMakeCallA';
function tapiRequestMakeCallW; external TapiDll name 'tapiRequestMakeCallW';
function tapiRequestMakeCall; external TapiDll name 'tapiRequestMakeCallA';
{$ELSE}
function tapiRequestMakeCall; external TapiDll name 'tapiRequestMakeCall';
{$IFDEF WIN32}
function tapiRequestMakeCallA; external TapiDll name 'tapiRequestMakeCallA';
function tapiRequestMakeCallW; external TapiDll name 'tapiRequestMakeCallW';
{$ENDIF}
{$ENDIF}
{$IFNDEF TAPI10}
function tapiRequestMediaCallA; external TapiDll name 'tapiRequestMediaCallA';
function tapiRequestMediaCallW; external TapiDll name 'tapiRequestMediaCallW';
function tapiRequestMediaCall; external TapiDll name 'tapiRequestMediaCallA';
{$ELSE}
function tapiRequestMediaCall; external TapiDll name 'tapiRequestMediaCall';
{$IFDEF WIN32}
function tapiRequestMediaCallA; external TapiDll name 'tapiRequestMediaCallA';
function tapiRequestMediaCallW; external TapiDll name 'tapiRequestMediaCallW';
{$ENDIF}
{$ENDIF}

function TAPIERROR_FORMATMESSAGE(ErrCode: DWORD): Longint;
begin
  if ErrCode > $FFFF0000 then
    Result := ErrCode and $0000FFFF
  else begin
    if ErrCode and $10000000 <> 0 then
      Result := ErrCode - $90000000 + $0000F000
    else
      Result := ErrCode - $80000000 + $0000E000;
  end;
end;

function TapiErrorFormatMessage(ErrCode: DWORD): Longint;
begin
  if ErrCode > $FFFF0000 then
    Result := ErrCode and $0000FFFF
  else begin
    if ErrCode and $10000000 <> 0 then
      Result := ErrCode - $90000000 + $0000F000
    else
      Result := ErrCode - $80000000 + $0000E000;
  end;
end;

end.
