{******************************************************************}
{                                                                  }
{       Borland Delphi Runtime Library                             }
{       Telephony API interface unit - Core Error Messages         }
{                                                                  }
{ Portions created by Microsoft are                                }
{ Copyright (C) 1995-1999 Microsoft Corporation.                   }
{ All Rights Reserved.                                             }
{                                                                  }
{ The original file is: tapi3err.h, released  March 1999.          }
{ The original Pascal code is: Tapi3Err.pas, released 28 Dec 1999. }
{ The initial developer of the Pascal code is Marcel van Brakel    }
{ (brakelm@chello.nl).                                             }
{ 								   }
{ Portions created by Marcel van Brakel are			   }
{ Copyright (C) 1999-2000 Marcel van Brakel.   			   }
{                                                                  }
{ Contributor(s): Alan C. Moore (ACMDOC@aol.com)                   }
{                 Rudy Velthuis (rvelthuis@gmx.de)                 }
{                                                                  }
{ Obtained through:                                                }
{ Joint Endeavour of Delphi Innovators (Project JEDI)              }
{                                                                  }
{ You may retrieve the latest version of this file at the Project  }
{ JEDI home page, located at http://delphi-jedi.org                }
{                                                                  }
{ The contents of this file are used with permission, subject to   }
{ the Mozilla Public License Version 1.1 (the "License"); you may  }
{ not use this file except in compliance with the License. You may }
{ obtain a copy of the License at                                  }
{ http://www.mozilla.org/NPL/NPL-1_1Final.html                     }
{                                                                  }
{ Software distributed under the License is distributed on an      }
{ "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or   }
{ implied. See the License for the specific language governing     }
{ rights and limitations under the License.                        }
{                                                                  }
{******************************************************************}

unit Tapi3Err;

interface

//--------------------------------------------------------------------------
//     Core TAPI Error messages
//--------------------------------------------------------------------------

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//

const

//
// MessageId: TAPI_E_NOTENOUGHMEMORY
//
// MessageText:
//
//  The buffer passed in to this method was not big enough.
//
  TAPI_E_NOTENOUGHMEMORY           = HRESULT($80040001);

//
// MessageId: TAPI_E_NOITEMS
//
// MessageText:
//
//  No items exist that match the request.
//
  TAPI_E_NOITEMS                   = HRESULT($80040002);

//
// MessageId: TAPI_E_NOTSUPPORTED
//
// MessageText:
//
//  This method is not supported.
//
  TAPI_E_NOTSUPPORTED              = HRESULT($80040003);

//
// MessageId: TAPI_E_INVALIDMEDIATYPE
//
// MessageText:
//
//  The MEDIATYPE passed in to this method was invalid.
//
  TAPI_E_INVALIDMEDIATYPE          = HRESULT($80040004);

//
// MessageId: TAPI_E_OPERATIONFAILED
//
// MessageText:
//
//  The operation failed for an unspecified reason.
//
  TAPI_E_OPERATIONFAILED           = HRESULT($80040005);

//
// MessageId: TAPI_E_ALLOCATED
//
// MessageText:
//
//  The device is already in use.
//
  TAPI_E_ALLOCATED                 = HRESULT($80040006);

//
// MessageId: TAPI_E_CALLUNAVAIL
//
// MessageText:
//
//  No call appearance available.
//
  TAPI_E_CALLUNAVAIL               = HRESULT($80040007);

//
// MessageId: TAPI_E_COMPLETIONOVERRUN
//
// MessageText:
//
//  Too many call completions outstanding.
//
  TAPI_E_COMPLETIONOVERRUN         = HRESULT($80040008);

//
// MessageId: TAPI_E_CONFERENCEFULL
//
// MessageText:
//
//  The conference is full.
//
  TAPI_E_CONFERENCEFULL            = HRESULT($80040009);

//
// MessageId: TAPI_E_DIALMODIFIERNOTSUPPORTED
//
// MessageText:
//
//  The dial modifier is not supported.
//
  TAPI_E_DIALMODIFIERNOTSUPPORTED  = HRESULT($8004000A);

//
// MessageId: TAPI_E_INUSE
//
// MessageText:
//
//  The device is already in use.
//
  TAPI_E_INUSE                     = HRESULT($8004000B);

//
// MessageId: TAPI_E_INVALADDRESS
//
// MessageText:
//
//  The phone number is invalid or not properly formatted.
//
  TAPI_E_INVALADDRESS              = HRESULT($8004000C);

//
// MessageId: TAPI_E_INVALADDRESSSTATE
//
// MessageText:
//
//  Operation not permitted in current address state.
//
  TAPI_E_INVALADDRESSSTATE         = HRESULT($8004000D);

//
// MessageId: TAPI_E_INVALCALLPARAMS
//
// MessageText:
//
//  Invalid LINECALLPARAMS structure.
//
  TAPI_E_INVALCALLPARAMS           = HRESULT($8004000E);

//
// MessageId: TAPI_E_INVALCALLPRIVILEGE
//
// MessageText:
//
//  Invalid call privilege.
//
  TAPI_E_INVALCALLPRIVILEGE        = HRESULT($8004000F);

//
// MessageId: TAPI_E_INVALCALLSTATE
//
// MessageText:
//
//  Operation not permitted in current call state.
//
  TAPI_E_INVALCALLSTATE            = HRESULT($80040010);

//
// MessageId: TAPI_E_INVALCARD
//
// MessageText:
//
//  Invalid calling card.
//
  TAPI_E_INVALCARD                 = HRESULT($80040011);

//
// MessageId: TAPI_E_INVALCOMPLETIONID
//
// MessageText:
//
//  Invalid call completion ID.
//
  TAPI_E_INVALCOMPLETIONID         = HRESULT($80040012);

//
// MessageId: TAPI_E_INVALCOUNTRYCODE
//
// MessageText:
//
//  Invalid country code.
//
  TAPI_E_INVALCOUNTRYCODE          = HRESULT($80040013);

//
// MessageId: TAPI_E_INVALDEVICECLASS
//
// MessageText:
//
//  Invalid device class identifier
//
  TAPI_E_INVALDEVICECLASS          = HRESULT($80040014);

//
// MessageId: TAPI_E_INVALDIALPARAMS
//
// MessageText:
//
//  Invalid dialing parameters
//
  TAPI_E_INVALDIALPARAMS           = HRESULT($80040015);

//
// MessageId: TAPI_E_INVALDIGITS
//
// MessageText:
//
//  Invalid digits.
//
  TAPI_E_INVALDIGITS               = HRESULT($80040016);

//
// MessageId: TAPI_E_INVALGROUPID
//
// MessageText:
//
//  Invalid group pickup ID.
//
  TAPI_E_INVALGROUPID              = HRESULT($80040017);

//
// MessageId: TAPI_E_INVALLOCATION
//
// MessageText:
//
//  Invalid location ID.
//
  TAPI_E_INVALLOCATION             = HRESULT($80040018);

//
// MessageId: TAPI_E_INVALMESSAGEID
//
// MessageText:
//
//  Invalid message ID.
//
  TAPI_E_INVALMESSAGEID            = HRESULT($80040019);

//
// MessageId: TAPI_E_INVALPARKID
//
// MessageText:
//
//  Invalid park ID.
//
  TAPI_E_INVALPARKID               = HRESULT($8004001A);

//
// MessageId: TAPI_E_INVALRATE
//
// MessageText:
//
//  Invalid rate.
//
  TAPI_E_INVALRATE                 = HRESULT($8004001B);

//
// MessageId: TAPI_E_INVALTIMEOUT
//
// MessageText:
//
//  Invalid timeout value.
//
  TAPI_E_INVALTIMEOUT              = HRESULT($8004001C);

//
// MessageId: TAPI_E_INVALTONE
//
// MessageText:
//
//  Invalid tone.
//
  TAPI_E_INVALTONE                 = HRESULT($8004001D);

//
// MessageId: TAPI_E_INVALLIST
//
// MessageText:
//
//  Invalid list passed as a parameter
//
  TAPI_E_INVALLIST                 = HRESULT($8004001E);

//
// MessageId: TAPI_E_INVALMODE
//
// MessageText:
//
//  Invalide mode passed as a parameter
//
  TAPI_E_INVALMODE                 = HRESULT($8004001F);

//
// MessageId: TAPI_E_NOCONFERENCE
//
// MessageText:
//
//  The call is not part of a conference.
//
  TAPI_E_NOCONFERENCE              = HRESULT($80040020);

//
// MessageId: TAPI_E_NODEVICE
//
// MessageText:
//
//  The device was removed, or the device class is not recognized.
//
  TAPI_E_NODEVICE                  = HRESULT($80040021);

//
// MessageId: TAPI_E_NOREQUEST
//
// MessageText:
//
//  No Assisted Telephony requests are pending.
//
  TAPI_E_NOREQUEST                 = HRESULT($80040022);

//
// MessageId: TAPI_E_NOTOWNER
//
// MessageText:
//
//  The application is does not have OWNER privilege on the call.
//
  TAPI_E_NOTOWNER                  = HRESULT($80040023);

//
// MessageId: TAPI_E_NOTREGISTERED
//
// MessageText:
//
//  The application is not registered to handle requests.
//
  TAPI_E_NOTREGISTERED             = HRESULT($80040024);

//
// MessageId: TAPI_E_REQUESTOVERRUN
//
// MessageText:
//
//  The request queue is already full.
//
  TAPI_E_REQUESTOVERRUN            = HRESULT($80040025);

//
// MessageId: TAPI_E_TARGETNOTFOUND
//
// MessageText:
//
//  The call handoff failed because the specified target was not found.
//
  TAPI_E_TARGETNOTFOUND            = HRESULT($80040026);

//
// MessageId: TAPI_E_TARGETSELF
//
// MessageText:
//
//  No higher priority target exists for the call handoff.
//
  TAPI_E_TARGETSELF                = HRESULT($80040027);

//
// MessageId: TAPI_E_USERUSERINFOTOOBIG
//
// MessageText:
//
//  The amount of user-user info exceeds the maximum permitted.
//
  TAPI_E_USERUSERINFOTOOBIG        = HRESULT($80040028);

//
// MessageId: TAPI_E_REINIT
//
// MessageText:
//
//  The operation cannot be completed until all TAPI applications shutdown and
// reinitialize. 
//
  TAPI_E_REINIT                    = HRESULT($80040029);

//
// MessageId: TAPI_E_ADDRESSBLOCKED
//
// MessageText:
//
//  You are not permitted to call this number.
//
  TAPI_E_ADDRESSBLOCKED            = HRESULT($8004002A);

//
// MessageId: TAPI_E_BILLINGREJECTED
//
// MessageText:
//
//  The calling card number or other billing information was rejected.
//
  TAPI_E_BILLINGREJECTED           = HRESULT($8004002B);

//
// MessageId: TAPI_E_INVALFEATURE
//
// MessageText:
//
//  Invalid device-specific feature.
//
  TAPI_E_INVALFEATURE              = HRESULT($8004002C);

//
// MessageId: TAPI_E_INVALBUTTONLAMPID
//
// MessageText:
//
//  Invalid button or lamp ID.
//
  TAPI_E_INVALBUTTONLAMPID         = HRESULT($8004002D);

//
// MessageId: TAPI_E_INVALBUTTONSTATE
//
// MessageText:
//
//  Invalid button state.
//
  TAPI_E_INVALBUTTONSTATE          = HRESULT($8004002E);

//
// MessageId: TAPI_E_INVALDATAID
//
// MessageText:
//
//  Invalid data segment ID.
//
  TAPI_E_INVALDATAID               = HRESULT($8004002F);

//
// MessageId: TAPI_E_INVALHOOKSWITCHDEV
//
// MessageText:
//
//  Invalid hookswitch device ID.
//
  TAPI_E_INVALHOOKSWITCHDEV        = HRESULT($80040030);

//
// MessageId: TAPI_E_DROPPED
//
// MessageText:
//
//  The call was disconnected.
//
  TAPI_E_DROPPED                   = HRESULT($80040031);

//
// MessageId: TAPI_E_NOREQUESTRECIPIENT
//
// MessageText:
//
//  No program is available to handle the request.
//
  TAPI_E_NOREQUESTRECIPIENT        = HRESULT($80040032);

//
// MessageId: TAPI_E_REQUESTQUEUEFULL
//
// MessageText:
//
//  The queue of call requests is full.
//
  TAPI_E_REQUESTQUEUEFULL          = HRESULT($80040033);

//
// MessageId: TAPI_E_DESTBUSY
//
// MessageText:
//
//  The called number is busy.
//
  TAPI_E_DESTBUSY                  = HRESULT($80040034);

//
// MessageId: TAPI_E_DESTNOANSWER
//
// MessageText:
//
//  The called party does not answer.
//
  TAPI_E_DESTNOANSWER              = HRESULT($80040035);

//
// MessageId: TAPI_E_DESTUNAVAIL
//
// MessageText:
//
//  The called number could not be reached
//
  TAPI_E_DESTUNAVAIL               = HRESULT($80040036);

//
// MessageId: TAPI_E_REQUESTFAILED
//
// MessageText:
//
//  The request failed for unspecified reasons.
//
  TAPI_E_REQUESTFAILED             = HRESULT($80040037);

//
// MessageId: TAPI_E_REQUESTCANCELLED
//
// MessageText:
//
//  The request was cancelled.
//
  TAPI_E_REQUESTCANCELLED          = HRESULT($80040038);

//
// MessageId: TAPI_E_INVALPRIVILEGE
//
// MessageText:
//
//  Invalid privilege.
//
  TAPI_E_INVALPRIVILEGE            = HRESULT($80040039);

//
// MessageId: TAPI_E_INVALIDDIRECTION
//
// MessageText:
//
//  The TERMINAL_DIRECTION passed in was invalid.
//
  TAPI_E_INVALIDDIRECTION          = HRESULT($8004003A);

//
// MessageId: TAPI_E_INVALIDTERMINAL
//
// MessageText:
//
//  The Terminal passed in was invalid for this operation.
//
  TAPI_E_INVALIDTERMINAL           = HRESULT($8004003B);

//
// MessageId: TAPI_E_INVALIDTERMINALCLASS
//
// MessageText:
//
//  The Terminal Class is invalid.
//
  TAPI_E_INVALIDTERMINALCLASS      = HRESULT($8004003C);

//
// MessageId: TAPI_E_NODRIVER
//
// MessageText:
//
//  The service provider was removed.
//
  TAPI_E_NODRIVER                  = HRESULT($8004003D);

//
// MessageId: TAPI_E_MAXSTREAMS
//
// MessageText:
//
//  The maximum number of streams was reached.
//
  TAPI_E_MAXSTREAMS                = HRESULT($8004003E);

//
// MessageId: TAPI_E_NOTERMINALSELECTED
//
// MessageText:
//
//  The operation could not be performed because it requires terminals to be
//  selected.
//
  TAPI_E_NOTERMINALSELECTED        = HRESULT($8004003F);

//
// MessageId: TAPI_E_TERMINALINUSE
//
// MessageText:
//
//  The operation could not be performed because the terminal is in use.
//
  TAPI_E_TERMINALINUSE             = HRESULT($80040040);

//
// MessageId: TAPI_E_NOTSTOPPED
//
// MessageText:
//
//  The operation could not be performed because it requires the stream to be
//  stopped.
//
  TAPI_E_NOTSTOPPED                = HRESULT($80040041);

//
// MessageId: TAPI_E_MAXTERMINALS
//
// MessageText:
//
//  The maximum number of terminals has been reached.
//
  TAPI_E_MAXTERMINALS              = HRESULT($80040042);

//
// MessageId: TAPI_E_INVALIDSTREAM
//
// MessageText:
//
//  The Stream passed in was invalid for this operation.
//
  TAPI_E_INVALIDSTREAM             = HRESULT($80040043);

//
// MessageId: TAPI_E_TIMEOUT
//
// MessageText:
//
//  The call failed due to a timeout.
//
  TAPI_E_TIMEOUT                   = HRESULT($80040044);

//--------------------------------------------------------------------------
//     Call Center Error messages
//--------------------------------------------------------------------------

//
// MessageId: TAPI_E_CALLCENTER_GROUP_REMOVED
//
// MessageText:
//
//  The ACD Proxy has removed this Group. Operations on this object are invalid.
//
  TAPI_E_CALLCENTER_GROUP_REMOVED  = HRESULT($80040045);

//
// MessageId: TAPI_E_CALLCENTER_QUEUE_REMOVED
//
// MessageText:
//
//  The ACD Proxy has removed this Queue. Operations on this object are invalid.
//
  TAPI_E_CALLCENTER_QUEUE_REMOVED  = HRESULT($80040046);

//
// MessageId: TAPI_E_CALLCENTER_NO_AGENT_ID
//
// MessageText:
//
//  The Agent object was created with CreateAgent. It does not have an ID, use
//  CreateAgentWithID.
//
  TAPI_E_CALLCENTER_NO_AGENT_ID    = HRESULT($80040047);

//
// MessageId: TAPI_E_CALLCENTER_INVALAGENTID
//
// MessageText:
//
//  Invalid agent ID.
//
  TAPI_E_CALLCENTER_INVALAGENTID   = HRESULT($80040048);

//
// MessageId: TAPI_E_CALLCENTER_INVALAGENTGROUP
//
// MessageText:
//
//  Invalid agent group.
//
  TAPI_E_CALLCENTER_INVALAGENTGROUP = HRESULT($80040049);

//
// MessageId: TAPI_E_CALLCENTER_INVALPASSWORD
//
// MessageText:
//
//  Invalid agent password.
//
  TAPI_E_CALLCENTER_INVALPASSWORD  = HRESULT($8004004A);

//
// MessageId: TAPI_E_CALLCENTER_INVALAGENTSTATE
//
// MessageText:
//
//  Invalid agent state
//
  TAPI_E_CALLCENTER_INVALAGENTSTATE = HRESULT($8004004B);

//
// MessageId: TAPI_E_CALLCENTER_INVALAGENTACTIVITY
//
// MessageText:
//
//  Invalid agent activity.
//
  TAPI_E_CALLCENTER_INVALAGENTACTIVITY = HRESULT($8004004C);

//
// MessageId: TAPI_E_REGISTRY_SETTING_CORRUPT
//
// MessageText:
//
//  Registry Setting is Corrupt.
//
  TAPI_E_REGISTRY_SETTING_CORRUPT = HRESULT($8004004D);

//--------------------------------------------------------------------------
//     Terminal Specific Error messages
//--------------------------------------------------------------------------

//
// MessageId: TAPI_E_TERMINAL_PEER
//
// MessageText:
//
//  The peer for one of these bridge terminals has already been assigned.
//
  TAPI_E_TERMINAL_PEER             = HRESULT($8004004E);

//
// MessageId: TAPI_E_PEER_NOT_SET
//
// MessageText:
//
//  The peer for this bridge terminal must be set to complete this operation.
//
  TAPI_E_PEER_NOT_SET              = HRESULT($8004004F);


//--------------------------------------------------------------------------
//     Media Service Provider Error messages
//--------------------------------------------------------------------------
//
// MessageId: TAPI_E_NOEVENT
//
// MessageText:
//
//  There is no event in the MSP's event queue.
//
  TAPI_E_NOEVENT                   = HRESULT($80040050);

//--------------------------------------------------------------------------
//     Core TAPI Error messages
//--------------------------------------------------------------------------

//
// MessageId: TAPI_E_INVALADDRESSTYPE
//
// MessageText:
//
//  The specified address type is not supported by this address.
//
  TAPI_E_INVALADDRESSTYPE = HRESULT($80040051);

//
// MessageId: TAPI_E_RESOURCEUNAVAIL
//
// MessageText:
//
//  A resource needed to fulfill the request is not available.
//
  TAPI_E_RESOURCEUNAVAIL = HRESULT($80040052);

implementation

end.
