{******************************************************************}
{                                                                  }
{       Borland Delphi Runtime Library                             }
{       Telephony SPI interface unit                               }
{                                                                  }
{ Portions created by Microsoft are                                }
{ Copyright (C) 1995-1999 Microsoft Corporation.                   }
{ All Rights Reserved.                                             }
{                                                                  }
{ The original file is: tspi.h, released  March 1999.              }
{ The original Pascal code is: TSPI.pas, released 28 Dec 1999.     }
{ The initial developer of the Pascal code is Marcel van Brakel    }
{ (brakelm@chello.nl).                                             }
{ 								   }
{ Portions created by Marcel van Brakel are			   }
{ Copyright (C) 1999-2000 Marcel van Brakel.   			   }
{                                                                  }
{ Contributor(s): Alan C. Moore (ACMDOC@aol.com)                   }
{                 Rudy Velthuis (rvelthuis@gmx.de)                 }
{                                                                  }
{ Obtained through:                                                }
{ Joint Endeavour of Delphi Innovators (Project JEDI)              }
{                                                                  }
{ You may retrieve the latest version of this file at the Project  }
{ JEDI home page, located at http://delphi-jedi.org                }
{                                                                  }
{ The contents of this file are used with permission, subject to   }
{ the Mozilla Public License Version 1.1 (the "License"); you may  }
{ not use this file except in compliance with the License. You may }
{ obtain a copy of the License at                                  }
{ http://www.mozilla.org/NPL/NPL-1_1Final.html                     }
{                                                                  }
{ Software distributed under the License is distributed on an      }
{ "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or   }
{ implied. See the License for the specific language governing     }
{ rights and limitations under the License.                        }
{                                                                  }
{******************************************************************}

unit TSPI;

{$WEAKPACKAGEUNIT}

interface

{$HPPEMIT '#include <windows.h>'}

{$HPPEMIT '#include "tapi.h"'}

{$HPPEMIT '#if WIN32'}
{$HPPEMIT '#if TAPI_CURRENT_VERSION < 0x00020000'}
{$HPPEMIT '#error Building a 32bit 1.3 or 1.4 service provider isn't supported'}
{$HPPEMIT '#endif'}
{$HPPEMIT '#endif'}

uses
  Windows, Tapi;

// The  Telephony  API  is jointly copyrighted by Intel and Microsoft.  You are
// granted  a royalty free worldwide, unlimited license to make copies, and use
// the API/SPI for making applications/drivers  that  interface  with  the
// specification provided that this paragraph and the Intel/Microsoft copyright
// statement is maintained as is in the text and source code files.

// Copyright (c) 1992-1998  Microsoft Corporation
// Portions copyright 1992, 1993 Intel/Microsoft, all rights reserved.

{$INCLUDE TAPI.INC}

{$IFDEF WIN32}
{$IFNDEF TAPI20}
#error Building a 32bit 1.3 or 1.4 service provider is not supported.
{$ENDIF}
{$ENDIF}

// tspi.h  is  only  of  use  in  conjunction  with tapi.h.  Very few types are
// defined  in  tspi.h.   Most  types of procedure formal parameters are simply
// passed through from corresponding procedures in tapi.h.  A working knowledge
// of the TAPI interface is required for an understanding of this interface.

type
  PHDRVCALL = ^HDRVCALL;
  HDRVCALL__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HDRVCALL__}
  HDRVCALL = HDRVCALL__;
  {$EXTERNALSYM HDRVCALL}

  PHDRVLLINE= ^HDRVLINE;
  HDRVLINE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HDRVLINE__}
  HDRVLINE = HDRVLINE__;
  {$EXTERNALSYM HDRVLINE}

  PHDRVPHONE = ^HDRVPHONE;
  HDRVPHONE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HDRVPHONE__}
  HDRVPHONE = HDRVPHONE__;
  {$EXTERNALSYM HDRVPHONE}

  PHDRVDIALOGINSTANCE = ^HDRVDIALOGINSTANCE;
  HDRVDIALOGINSTANCE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HDRVDIALOGINSTANCE__}
  HDRVDIALOGINSTANCE = HDRVDIALOGINSTANCE__;
  {$EXTERNALSYM HDRVDIALOGINSTANCE}

  PHDRVMSPLINE = ^HDRVMSPLINE;
  HDRVMSPLINE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HDRVMSPLINE__}
  HDRVMSPLINE = HDRVMSPLINE__;
  {$EXTERNALSYM HDRVMSPLINE}

  PHTAPICALL = ^HTAPICALL;
  HTAPICALL__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HTAPICALL__}
  HTAPICALL = HTAPICALL__;
  {$EXTERNALSYM HTAPICALL}

  PHTAPILINE = ^HTAPILINE;
  HTAPILINE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HTAPILINE__}
  HTAPILINE = HTAPILINE__;
  {$EXTERNALSYM HTAPILINE}

  PHTAPIPHONE = ^HTAPIPHONE;
  HTAPIPHONE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HTAPIPHONE__}
  HTAPIPHONE = HTAPIPHONE__;
  {$EXTERNALSYM HTAPIPHONE}

  PHTAPIDIALOGINSTANCE = ^HTAPIDIALOGINSTANCE;
  HTAPIDIALOGINSTANCE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HTAPIDIALOGINSTANCE__}
  HTAPIDIALOGINSTANCE = HTAPIDIALOGINSTANCE__;
  {$EXTERNALSYM HTAPIDIALOGINSTANCE}

  PHTAPIMSPLINE = ^HTAPIMSPLINE;
  HTAPIMSPLINE__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HTAPIMSPLINE__}
  HTAPIMSPLINE = HTAPIMSPLINE__;
  {$EXTERNALSYM HTAPIMSPLINE}

  PHPROVIDER = ^HPROVIDER;
  HPROVIDER__ = packed record
    unused: Longint;
  end;
  {$EXTERNALSYM HPROVIDER__}
  HPROVIDER = HPROVIDER__;
  {$EXTERNALSYM HPROVIDER}

  TDrvRequestID = DWORD;
  DRV_REQUESTID = DWORD;
  {$EXTERNALSYM DRV_REQUESTID}

  ASYNC_COMPLETION = procedure(dwRequestID: TDrvRequestID;
    lResult: Longint); stdcall;
  {$EXTERNALSYM ASYNC_COMPLETION}
  TASyncCompletion = ASYNC_COMPLETION;

  LINEEVENT = procedure(htLine: HTAPILINE; htCall: HTAPICALL; dwMsg, dwParam1,
    dwParam2, dwParam3: DWORD_PTR) stdcall;
  {$EXTERNALSYM LINEEVENT}
  TLineEvent = LINEEVENT;

  PHONEEVENT = procedure(htPhone: HTAPIPHONE; dwMsg: DWORD; dwParam1, dwParam2,
    dwParam3: DWORD_PTR) stdcall;
  {$EXTERNALSYM PHONEEVENT}
  TPhoneEvent = PHONEEVENT;

  TUISPIDLLCALLBACK = function(dwObjectID, dwObjectType: DWORD;
    lpParams: Pointer; dwSize: DWORD): Longint stdcall;
  {$EXTERNALSYM TUISPIDLLCALLBACK}
  TTUISpiDllCallback = TUISPIDLLCALLBACK;

{$IFDEF TAPI20}
  PTUISpiCreateDialogInstanceParams = ^TTUISpiCreateDialogInstanceParams;
  tuispicreatedialoginstanceparams_tag = packed record
    dwRequestID: TDrvRequestID;
    hdDlgInst: HDRVDIALOGINSTANCE;
    htDlgInst: HTAPIDIALOGINSTANCE;
    lpszUIDLLName: LPCWSTR;
    lpParams: Pointer;
    dwSize: DWORD;
  end;
  {$EXTERNALSYM tuispicreatedialoginstanceparams_tag}
  TTUISpiCreateDialogInstanceParams = tuispicreatedialoginstanceparams_tag;
  TUISPICREATEDIALOGINSTANCEPARAMS = tuispicreatedialoginstanceparams_tag;
  {$EXTERNALSYM TUISPICREATEDIALOGINSTANCEPARAMS}
{$ENDIF}

{$IFDEF TAPI30}
const
  LINEQOSSTRUCT_KEY = DWORD(1280398155); // DWORD('LQSK')
  {$EXTERNALSYM LINEQOSSTRUCT_KEY}

type
  PLineQosServiceLevel = ^TLineQosServiceLevel;
  LINEQOSSERVICELEVEL_tag = packed record
    dwMediaMode: DWORD;
    dwQOSServiceLevel: DWORD;
  end;
  {$EXTERNALSYM LINEQOSSERVICELEVEL_tag}
  TLineQosServiceLevel = LINEQOSSERVICELEVEL_tag;

  PLineCallQosInfo = ^TLineCallQosInfo;
  LINECALLQOSINFO_tag = packed record
    dwKey: DWORD;
    dwTotalSize: DWORD;
    dwQOSRequestType: DWORD;
    case Longint of
    0: (SetQosServiceLevel: packed record
          dwNumServiceLevelEntries: DWORD;
          LineQOSServiceLevel: array[0..0] of TLineQosServiceLevel;
        end;);
  end;
  {$EXTERNALSYM LINECALLQOSINFO_tag}
  TLineCallQosInfo = LINECALLQOSINFO_tag;

// {831CE2D6-83B5-11d1-BB5C-00C04FB6809F}
// EXTERN_C const CLSID TAPIPROTOCOL_PSTN;

// {831CE2D7-83B5-11d1-BB5C-00C04FB6809F}
// EXTERN_C const CLSID TAPIPROTOCOL_H323;

// {831CE2D8-83B5-11d1-BB5C-00C04FB6809F}
// EXTERN_C const CLSID TAPIPROTOCOL_Multicast;
{$ENDIF}

const
  TSPI_MESSAGE_BASE = 500; // Lowest-numbered TSPI-specific message ID number
  {$EXTERNALSYM TSPI_MESSAGE_BASE}

  LINE_NEWCALL                = TSPI_MESSAGE_BASE + 0;
  {$EXTERNALSYM LINE_NEWCALL}
  LINE_CALLDEVSPECIFIC        = TSPI_MESSAGE_BASE + 1;
  {$EXTERNALSYM LINE_CALLDEVSPECIFIC}
  LINE_CALLDEVSPECIFICFEATURE = TSPI_MESSAGE_BASE + 2;
  {$EXTERNALSYM LINE_CALLDEVSPECIFICFEATURE}
{$IFDEF TAPI20}
  LINE_CREATEDIALOGINSTANCE   = TSPI_MESSAGE_BASE + 3;          // TSPI v2.0
  {$EXTERNALSYM LINE_CREATEDIALOGINSTANCE}
  LINE_SENDDIALOGINSTANCEDATA = TSPI_MESSAGE_BASE + 4;          // TSPI v2.0
  {$EXTERNALSYM LINE_SENDDIALOGINSTANCEDATA}
{$ENDIF}
{$IFDEF TAPI30}
  LINE_SENDMSPDATA            = TSPI_MESSAGE_BASE + 5;          // TSPI v3.0
  {$EXTERNALSYM LINE_SENDMSPDATA}
  LINE_QOSINFO                = TSPI_MESSAGE_BASE + 6;          // TSPI v3.0
  {$EXTERNALSYM LINE_QOSINFO}
{$ENDIF}

{$IFDEF TAPI20}
  LINETSPIOPTION_NONREENTRANT = $00000001;                      // TSPI v2.0
  {$EXTERNALSYM LINETSPIOPTION_NONREENTRANT}
{$ENDIF}

{$IFDEF TAPI20}
  TUISPIDLL_OBJECT_LINEID         = 1;                          // TSPI v2.0
  {$EXTERNALSYM TUISPIDLL_OBJECT_LINEID}
  TUISPIDLL_OBJECT_PHONEID        = 2;                          // TSPI v2.0
  {$EXTERNALSYM TUISPIDLL_OBJECT_PHONEID}
  TUISPIDLL_OBJECT_PROVIDERID     = 3;                          // TSPI v2.0
  {$EXTERNALSYM TUISPIDLL_OBJECT_PROVIDERID}
  TUISPIDLL_OBJECT_DIALOGINSTANCE = 4;                          // TSPI v2.0
  {$EXTERNALSYM TUISPIDLL_OBJECT_DIALOGINSTANCE}
{$ENDIF}

{$IFDEF TAPI30}
  PRIVATEOBJECT_NONE              = $00000001;                  // TSPI v3.0
  {$EXTERNALSYM PRIVATEOBJECT_NONE}
  PRIVATEOBJECT_CALLID            = $00000002;                  // TSPI v3.0
  {$EXTERNALSYM PRIVATEOBJECT_CALLID}
  PRIVATEOBJECT_LINE              = $00000003;                  // TSPI v3.0
  {$EXTERNALSYM PRIVATEOBJECT_LINE}
  PRIVATEOBJECT_CALL              = $00000004;                  // TSPI v3.0
  {$EXTERNALSYM PRIVATEOBJECT_CALL}
  PRIVATEOBJECT_PHONE             = $00000005;                  // TSPI v3.0
  {$EXTERNALSYM PRIVATEOBJECT_PHONE}
  PRIVATEOBJECT_ADDRESS           = $00000006;                  // TSPI v3.0
  {$EXTERNALSYM PRIVATEOBJECT_ADDRESS}

  LINEQOSREQUESTTYPE_SERVICELEVEL = $00000001;                  // TSPI v3.0
  {$EXTERNALSYM LINEQOSREQUESTTYPE_SERVICELEVEL}

  LINEQOSSERVICELEVEL_NEEDED      = $00000001;                  // TSPI v3.0
  {$EXTERNALSYM LINEQOSSERVICELEVEL_NEEDED}
  LINEQOSSERVICELEVEL_IFAVAILABLE = $00000002;                  // TSPI v3.0
  {$EXTERNALSYM LINEQOSSERVICELEVEL_IFAVAILABLE}
  LINEQOSSERVICELEVEL_BESTEFFORT  = $00000003;                  // TSPI v3.0
  {$EXTERNALSYM LINEQOSSERVICELEVEL_BESTEFFORT}

  LINEEQOSINFO_NOQOS              = $00000001;                  // TSPI v3.0
  {$EXTERNALSYM LINEEQOSINFO_NOQOS}
  LINEEQOSINFO_ADMISSIONFAILURE   = $00000002;                  // TSPI v3.0
  {$EXTERNALSYM LINEEQOSINFO_ADMISSIONFAILURE}
  LINEEQOSINFO_POLICYFAILURE      = $00000003;                  // TSPI v3.0
  {$EXTERNALSYM LINEEQOSINFO_POLICYFAILURE}
  LINEEQOSINFO_GENERICERROR       = $00000004;                  // TSPI v3.0
  {$EXTERNALSYM LINEEQOSINFO_GENERICERROR}
{$ENDIF}

//
// The following function prototypes pertain
// to a service provider's core module
//

function TSPI_lineAccept(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpsUserUserInfo: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineAccept}

function TSPI_lineAddToConference(dwRequestID: TDrvRequestID;
    hdConfCall, hdConsultCall: HDRVCALL): Longint; stdcall;
{$EXTERNALSYM TSPI_lineAddToConference}

function TSPI_lineAnswer(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
    lpsUserUserInfo: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineAnswer}

{$IFDEF TAPI20}
function TSPI_lineBlindTransfer(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpszDestAddress: LPCWSTR; dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineBlindTransfer}
{$ELSE}
function TSPI_lineBlindTransfer(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpszDestAddress: LPCSTR; dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineBlindTransfer}
{$ENDIF}

function TSPI_lineClose(hdLine: HDRVLINE): Longint; stdcall;
{$EXTERNALSYM TSPI_lineClose}

function TSPI_lineCloseCall(hdCall: HDRVCALL): Longint; stdcall;
{$EXTERNALSYM TSPI_lineCloseCall}

function TSPI_lineCompleteCall(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  var dwCompletionID: DWORD;
  dwCompletionMode, dwMessageID: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineCompleteCall}

function TSPI_lineCompleteTransfer(dwRequestID: TDrvRequestID; hdCall,
  hdConsultCall: HDRVCALL; htConfCall: HTAPICALL; lphdConfCall: PHDRVCALL;
  dwTransferMode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineCompleteTransfer}

function TSPI_lineConditionalMediaDetection(hdLine: HDRVLINE; dwMediaModes: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM TSPI_lineConditionalMediaDetection}

function TSPI_lineDevSpecific(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwAddressID: DWORD; hdCall: HDRVCALL; lpParams: Pointer;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineDevSpecific}

function TSPI_lineDevSpecificFeature(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwFeature: DWORD; lpParams: Pointer; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineDevSpecificFeature}

{$IFDEF TAPI20}
function TSPI_lineDial(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpszDestAddress: LPCWSTR; dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineDial}
{$ELSE}
function TSPI_lineDial(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpszDestAddress: LPCSTR; dwCountryCode: DWORD): Longint; stdcall;
{$ENDIF}

function TSPI_lineDrop(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpsUserUserInfo: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineDrop}

function TSPI_lineDropOnClose(hdCall: HDRVCALL): Longint; stdcall; // TSPI v1.4
{$EXTERNALSYM TSPI_lineDropOnClose}

function TSPI_lineDropNoOwner(hdCall: HDRVCALL): LongInt; stdcall; //TSPI v1.4
{$EXTERNALSYM TSPI_lineDropNoOwner}

function TSPI_lineForward(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  bAllAddresses, dwAddressID: DWORD; lflForwardList: PLineForwardList;
  dwNumRingsNoAnswer: DWORD; htConsultCall: HTAPICALL; var hdConsultCall: HDRVCALL;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM TSPI_lineForward}

{$IFDEF TAPI20}
function TSPI_lineGatherDigits(hdCall: HDRVCALL; dwEndToEndID, dwDigitModes: DWORD;
  lpsDigits: LPWSTR; dwNumDigits: DWORD; lpszTerminationDigits: LPCWSTR;
  dwFirstDigitTimeout, dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGatherDigits}
{$ELSE}
function TSPI_lineGatherDigits(hdCall: HDRVCALL; dwEndToEndID, dwDigitModes: DWORD;
  lpsDigits: LPSTR; dwNumDigits: DWORD; lpszTerminationDigits: LPCSTR;
  dwFirstDigitTimeout, dwInterDigitTimeout: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGatherDigits}
{$ENDIF}

{$IFDEF TAPI20}
function TSPI_lineGenerateDigits(hdCall: HDRVCALL; dwEndToEndID, dwDigitMode: DWORD;
  lpszDigits: LPCWSTR; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGenerateDigits}
{$ELSE}
function TSPI_lineGenerateDigits(hdCall: HDRVCALL; dwEndToEndID, dwDigitMode: DWORD;
  lpszDigits: LPCSTR; dwDuration: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGenerateDigits}
{$ENDIF}

function TSPI_lineGenerateTone(hdCall: HDRVCALL; dwEndToEndID, dwToneMode,
  dwDuration, dwNumTones: DWORD; lgtTones: PLineGenerateTone): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGenerateTone}

function TSPI_lineGetAddressCaps(dwDeviceID, dwAddressID, dwTSPIVersion,
  dwExtVersion: DWORD; lpAddressCaps: PLineAddressCaps): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetAddressCaps}

{$IFDEF TAPI20}
function TSPI_lineGetAddressID(hdLine: HDRVLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: LPCWSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetAddressID}
{$ELSE}
function TSPI_lineGetAddressID(hdLine: HDRVLINE; var dwAddressID: DWORD;
  dwAddressMode: DWORD; lpsAddress: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetAddressID}
{$ENDIF}

function TSPI_lineGetAddressStatus(hdLine: HDRVLINE; dwAddressID: DWORD;
  lasAddressStatus: PLineAddressStatus): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetAddressStatus}

function TSPI_lineGetCallAddressID(hdCall: HDRVCALL;
  var dwAddressID: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetCallAddressID}

{$IFDEF TAPI30}
function TSPI_lineGetCallHubTracking(hdLine: HDRVLINE;
  pTrackingInfo: PLineCallHubTrackingInfo): Longint; stdcall; // TSPI v3.0
{$EXTERNALSYM TSPI_lineGetCallHubTracking}
{$ENDIF}

{$IFDEF TAPI30}
function TSPI_lineGetCallIDs(hdCall: HDRVCALL; lpdwAddressID, lpdwCallID,
  lpdwRelatedCallID: LPDWORD): Longint; stdcall; // TSPI v3.0
{$EXTERNALSYM TSPI_lineGetCallIDs}
{$ENDIF}

function TSPI_lineGetCallInfo(hdCall: HDRVCALL;
  lciCallInfo: PLineCallInfo): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetCallInfo}

function TSPI_lineGetCallStatus(hdCall: HDRVCALL;
  lcsCallStatus: PLineCallStatus): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetCallStatus}

function TSPI_lineGetDevCaps(dwDeviceID, dwTSPIVersion, dwExtVersion: DWORD;
  lpLineDevCaps: PLineDevCaps): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetDevCaps}

{$IFDEF TAPI20}
function TSPI_lineGetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetDevConfig}
{$ELSE}
function TSPI_lineGetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: PVarString;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetDevConfig}
{$ENDIF}

function TSPI_lineGetExtensionID(dwDeviceID, dwTSPIVersion: DWORD;
  var lpExtensionID: TLineExtensionID): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetExtensionID}

{$IFDEF TAPI20}
function TSPI_lineGetIcon(dwDeviceID: DWORD; lpszDeviceClass: LPCWSTR;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetIcon}
{$ELSE}
function TSPI_lineGetIcon(dwDeviceID: DWORD; lpszDeviceClass: LPCSTR;
  var hIcon: HIcon): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetIcon}
{$ENDIF}

{$IFDEF TAPI20}
function TSPI_lineGetID(hdLine: HDRVLINE; dwAddressID: DWORD; hdCall: HDRVCALL;
  dwSelect: DWORD; lpDeviceID: PVarString; lpszDeviceClass: LPCWSTR;
  hTargetProcess: THandle): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetID}
{$ELSE}
function TSPI_lineGetID(hdLine: HDRVLINE; dwAddressID: DWORD; hdCall: HDRVCALL;
  dwSelect: DWORD; lpDeviceID: PVarString; lpszDeviceClass: LPCSTR;
  hTargetProcess: THandle): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetID}
{$ENDIF}

function TSPI_lineGetLineDevStatus(hdLine: HDRVLINE;
  ldsLineDevStatus: PLineDevStatus): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetLineDevStatus}

function TSPI_lineGetNumAddressIDs(hdLine: HDRVLINE;
  var dwNumAddressIDs: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineGetNumAddressIDs}

function TSPI_lineHold(dwRequestID: TDrvRequestID;
  hdCall: HDRVCALL): Longint; stdcall;
{$EXTERNALSYM TSPI_lineHold}

{$IFDEF TAPI20}
function TSPI_lineMakeCall(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  htCall: HTAPICALL; lphdCall: PHDRVCALL; lpszDestAddress: LPCWSTR;
  dwCountryCode: DWORD; lpcCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM TSPI_lineMakeCall}
{$ELSE}
function TSPI_lineMakeCall(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  htCall: HTAPICALL; lphdCall: PHDRVCALL; lpszDestAddress: LPCSTR;
  dwCountryCode: DWORD; lpcCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM TSPI_lineMakeCall}
{$ENDIF}

function TSPI_lineMonitorDigits(hdCall: HDRVCALL;
  dwDigitModes: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineMonitorDigits}

function TSPI_lineMonitorMedia(hdCall: HDRVCALL;
  dwMediaModes: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineMonitorMedia}

function TSPI_lineMonitorTones(hdCall: HDRVCALL; dwToneListID: DWORD;
  lmtToneList: PLineMonitorTone; dwNumEntries: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineMonitorTones}

function TSPI_lineNegotiateExtVersion(dwDeviceID, dwTSPIVersion, dwLowVersion,
  dwHighVersion: DWORD; var dwExtVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineNegotiateExtVersion}

function TSPI_lineNegotiateTSPIVersion(dwDeviceID, dwLowVersion,
  dwHighVersion: DWORD; var dwTSPIVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineNegotiateTSPIVersion}

function TSPI_lineOpen(dwDeviceID: DWORD; htLine: HTAPILINE; var hdLine: HDRVLINE;
  dwTSPIVersion: DWORD; lpfnEventProc: TLineEvent): Longint; stdcall;
{$EXTERNALSYM TSPI_lineOpen}

{$IFDEF TAPI20}
function TSPI_linePark(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  dwParkMode: DWORD; lpszDirAddress: LPCWSTR;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM TSPI_linePark}
{$ELSE}
function TSPI_linePark(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  dwParkMode: DWORD; lpszDirAddress: LPCSTR;
  lpNonDirAddress: PVarString): Longint; stdcall;
{$EXTERNALSYM TSPI_linePark}
{$ENDIF}

{$IFDEF TAPI20}
function TSPI_linePickup(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwAddressID: DWORD; htCall: HTAPICALL; var hdCall: HDRVCALL;
  lpszDestAddress, lpszGroupID: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_linePickup}
{$ELSE}
function TSPI_linePickup(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwAddressID: DWORD; htCall: HTAPICALL; var hdCall: HDRVCALL;
  lpszDestAddress, lpszGroupID: LPCSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_linePickup}
{$ENDIF}

function TSPI_linePrepareAddToConference(dwRequestID: TDrvRequestID;
  hdConfCall: HDRVCALL; htConsultCall: HTAPICALL; lphdConsultCall: PHDRVCALL;
  lpcCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM TSPI_linePrepareAddToConference}

{$IFDEF TAPI20}
function TSPI_lineRedirect(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpszDestAddress: LPCWSTR; dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineRedirect}
{$ELSE}
function TSPI_lineRedirect(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpszDestAddress: LPCSTR; dwCountryCode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineRedirect}
{$ENDIF}

function TSPI_lineReleaseUserUserInfo(dwRequestID: TDrvRequestID;
  hdCall: HDRVCALL): Longint; stdcall; //TSPI v1.4
{$EXTERNALSYM TSPI_lineReleaseUserUserInfo}

function TSPI_lineRemoveFromConference(dwRequestID: TDrvRequestID;
  hdCall: HDRVCALL): Longint; stdcall;
{$EXTERNALSYM TSPI_lineRemoveFromConference}

function TSPI_lineSecureCall(dwRequestID: TDrvRequestID;
  hdCall: HDRVCALL): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSecureCall}

function TSPI_lineSelectExtVersion(hdLine: HDRVLINE;
  dwExtVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSelectExtVersion}

function TSPI_lineSendUserUserInfo(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpsUserUserInfo: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSendUserUserInfo}

function TSPI_lineSetAppSpecific(hdCall: HDRVCALL;
  dwAppSpecific: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetAppSpecific}

{$IFDEF TAPI20}
function TSPI_lineSetCallData(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  lpCallData: Pointer; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetCallData}
{$ENDIF}

{$IFDEF TAPI30}
function TSPI_lineSetCallHubTracking(hdLine: HDRVLINE;
  lpTrackingInfo: PLineCallHubTrackingInfo): Longint; stdcall; // TSPI v3.0
{$EXTERNALSYM TSPI_lineSetCallHubTracking}
{$ENDIF}

function TSPI_lineSetCallParams(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  dwBearerMode, dwMinRate, dwMaxRate: DWORD;
  ldpDialParams: PLineDialParams): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetCallParams}

{$IFDEF TAPI20}
function TSPI_lineSetCallQualityOfService(dwRequestID: TDrvRequestID;
  hdCall: HDRVCALL; lpSendingFlowspec: Pointer; dwSendingFlowspecSize: DWORD;
  lpReceivingFlowspec: Pointer; dwReceivingFlowspecSize: DWORD): Longint; stdcall;
  // TSPI v2.0
{$EXTERNALSYM TSPI_lineSetCallQualityOfService}

function TSPI_lineSetCallTreatment(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  dwTreatment: DWORD): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TSPI_lineSetCallTreatment}
{$ENDIF}

function TSPI_lineSetCurrentLocation(dwLocation: DWORD): Longint; stdcall; // TSPI v1.4
{$EXTERNALSYM TSPI_lineSetCurrentLocation}

function TSPI_lineSetDefaultMediaDetection(hdLine: HDRVLINE;
  wMediaModes: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetDefaultMediaDetection}

{$IFDEF TAPI20}
function TSPI_lineSetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetDevConfig}
{$ELSE}
function TSPI_lineSetDevConfig(dwDeviceID: DWORD; lpDeviceConfig: Pointer;
  dwSize: DWORD; lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetDevConfig}
{$ENDIF}

{$IFDEF TAPI20}
function TSPI_lineSetLineDevStatus(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwStatusToChange, fStatus: DWORD): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TSPI_lineSetLineDevStatus}
{$ENDIF}

function TSPI_lineSetMediaControl(hdLine: HDRVLINE; dwAddressID: DWORD;
  hdCall: HDRVCALL; dwSelect: DWORD; lmcdDigitList: PLineMediaControlDigit;
  dwDigitNumEntries: DWORD; lmcmMediaList: PLineMediaControlMedia;
  dwMediaNumEntries: DWORD; lmctToneList: PLineMediaControlTone;
  dwToneNumEntries: DWORD; lmccsCallStateList: PLineMediaControlCallState;
  dwCallStateNumEntries: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetMediaControl}

function TSPI_lineSetMediaMode(hdCall: HDRVCALL;
  dwMediaMode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetMediaMode}

function TSPI_lineSetStatusMessages(hdLine: HDRVLINE; dwLineStates,
  dwAddressStates: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetStatusMessages}

function TSPI_lineSetTerminal(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwAddressID: DWORD; hdCall: HDRVCALL; dwSelect, dwTerminalModes, dwTerminalID,
  bEnable: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetTerminal}

function TSPI_lineSetupConference(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  hdLine: HDRVLINE; htConfCall: HTAPICALL; lphdConfCall: PHDRVCALL;
  htConsultCall: HTAPICALL; lphdConsultCall: PHDRVCALL; dwNumParties: DWORD;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetupConference}

function TSPI_lineSetupTransfer(dwRequestID: TDrvRequestID; hdCall: HDRVCALL;
  htConsultCall: HTAPICALL; lphdConsultCall: PHDRVCALL;
  lcpCallParams: PLineCallParams): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSetupTransfer}

function TSPI_lineSwapHold(dwRequestID: TDrvRequestID; hdActiveCall,
  hdHeldCall: HDRVCALL): Longint; stdcall;
{$EXTERNALSYM TSPI_lineSwapHold}

function TSPI_lineUncompleteCall(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwCompletionID: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineUncompleteCall}

function TSPI_lineUnhold(dwRequestID: TDrvRequestID;
  hdCall: HDRVCALL): Longint; stdcall;
{$EXTERNALSYM TSPI_lineUnhold}

{$IFDEF TAPI20}
function TSPI_lineUnpark(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwAddressID: DWORD; htCall: HTAPICALL; lphdCall: PHDRVCALL;
  lpszDestAddress: LPCWSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_lineUnpark}
{$ELSE}
function TSPI_lineUnpark(dwRequestID: TDrvRequestID; hdLine: HDRVLINE;
  dwAddressID: DWORD; htCall: HTAPICALL; lphdCall: PHDRVCALL;
  lpszDestAddress: LPCSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_lineUnpark}
{$ENDIF}

function TSPI_phoneClose(hdPhone: HDRVPHONE): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneClose}

function TSPI_phoneDevSpecific(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  lpParams: Pointer; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneDevSpecific}

function TSPI_phoneGetButtonInfo(hdPhone: HDRVPHONE; dwButtonLampID: DWORD;
  pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetButtonInfo}

function TSPI_phoneGetData(hdPhone: HDRVPHONE; dwDataID: DWORD; lpData: Pointer;
  dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetData}

function TSPI_phoneGetDevCaps(dwDeviceID, dwTSPIVersion, dwExtVersion: DWORD;
  pcPhoneCaps: PPhoneCaps): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetDevCaps}

function TSPI_phoneGetDisplay(hdPhone: HDRVPHONE;
  lpDisplay: PVarString): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetDisplay}

function TSPI_phoneGetExtensionID(dwDeviceID, dwTSPIVersion: DWORD;
  var lpExtensionID: TPhoneExtensionID): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetExtensionID}

function TSPI_phoneGetGain(hdPhone: HDRVPHONE; dwHookSwitchDev: DWORD;
  var dwGain: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetGain}

function TSPI_phoneGetHookSwitch(hdPhone: HDRVPHONE;
  var dwHookSwitchDevs: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetHookSwitch}

{$IFDEF TAPI20}
function TSPI_phoneGetIcon(dwDeviceID: DWORD; lpszDeviceClass: LPCWSTR;
  var hIcon: HICON): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetIcon}
{$ELSE}
function TSPI_phoneGetIcon(dwDeviceID: DWORD; lpszDeviceClass: LPCSTR;
  var hIcon: HICON): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetIcon}
{$ENDIF}

{$IFDEF TAPI20}
function TSPI_phoneGetID(hdPhone: HDRVPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: LPCWSTR; hTargetProcess: THandle): Longint; stdcall; {// TSPI v2.0}
{$EXTERNALSYM TSPI_phoneGetID}
{$ELSE}
function TSPI_phoneGetID(hdPhone: HDRVPHONE; lpDeviceID: PVarString;
  lpszDeviceClass: LPCSTR; hTargetProcess: THandle): Longint; stdcall; {// TSPI v2.0}
{$EXTERNALSYM TSPI_phoneGetID}
{$ENDIF}

function TSPI_phoneGetLamp(hdPhone: HDRVPHONE; dwButtonLampID: DWORD;
  var dwLampMode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetLamp}

function TSPI_phoneGetRing(hdPhone: HDRVPHONE; var dwRingMode,
  dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetRing}

function TSPI_phoneGetStatus(hdPhone: HDRVPHONE;
  psPhoneStatus: PPhoneStatus): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetStatus}

function TSPI_phoneGetVolume(hdPhone: HDRVPHONE; dwHookSwitchDev: DWORD;
  var dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneGetVolume}

function TSPI_phoneNegotiateExtVersion(dwDeviceID, dwTSPIVersion, dwLowVersion,
  dwHighVersion: DWORD; var dwExtVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneNegotiateExtVersion}

function TSPI_phoneNegotiateTSPIVersion(dwDeviceID, dwLowVersion,
  dwHighVersion: DWORD; var dwTSPIVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneNegotiateTSPIVersion}

function TSPI_phoneOpen(dwDeviceID: DWORD; htPhone: HTAPIPHONE;
  var hdPhone: HDRVPHONE; dwTSPIVersion: DWORD;
  lpfnEventProc: TPhoneEvent): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneOpen}

function TSPI_phoneSelectExtVersion(hdPhone: HDRVPHONE;
  dwExtVersion: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSelectExtVersion}

function TSPI_phoneSetButtonInfo(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwButtonLampID: DWORD; pbiButtonInfo: PPhoneButtonInfo): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetButtonInfo}

function TSPI_phoneSetData(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwDataID: DWORD; lpData: Pointer; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetData}

{$IFDEF TAPI20}
function TSPI_phoneSetDisplay(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwRow, dwColumn: DWORD; lpsDisplay: LPCWSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetDisplay}
{$ELSE}
function TSPI_phoneSetDisplay(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwRow, dwColumn: DWORD; lpsDisplay: LPCSTR; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetDisplay}
{$ENDIF}

function TSPI_phoneSetGain(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwHookSwitchDev, dwGain: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetGain}

function TSPI_phoneSetHookSwitch(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwHookSwitchDevs, dwHookSwitchMode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetHookSwitch}

function TSPI_phoneSetLamp(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwButtonLampID, dwLampMode: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetLamp}

function TSPI_phoneSetRing(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwRingMode, dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetRing}

function TSPI_phoneSetStatusMessages(hdPhone: HDRVPHONE; dwPhoneStates,
  dwButtonModes, dwButtonStates: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetStatusMessages}

function TSPI_phoneSetVolume(dwRequestID: TDrvRequestID; hdPhone: HDRVPHONE;
  dwHookSwitchDev, dwVolume: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneSetVolume}

function TSPI_providerConfig(hwndOwner: HWND;
  dwPermanentProviderID: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_providerConfig}

function TSPI_providerCreateLineDevice(dwTempID,
  dwDeviceID: DWORD): Longint; stdcall; // TSPI v1.4
{$EXTERNALSYM TSPI_providerCreateLineDevice}

function TSPI_providerCreatePhoneDevice(dwTempID,
  dwDeviceID: DWORD): Longint; stdcall; // TSPI v1.4
{$EXTERNALSYM TSPI_providerCreatePhoneDevice}

function TSPI_providerEnumDevices(dwPermanentProviderID: DWORD; lpdwNumLines,
  lpdwNumPhones: LPDWORD; hProvider: HPROVIDER; lpfnLineCreateProc: TLineEvent;
  lpfnPhoneCreateProc: TPhoneEvent): Longint; stdcall; // TSPI v1.4
{$EXTERNALSYM TSPI_providerEnumDevices}

{$IFDEF TAPI20}
function TSPI_providerFreeDialogInstance(hdDlgInst: HDRVDIALOGINSTANCE): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TSPI_providerFreeDialogInstance}

function TSPI_providerGenericDialogData(dwObjectID, dwObjectType: DWORD;
  lpParams: Pointer; dwSize: DWORD): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TSPI_providerGenericDialogData}
{$ENDIF}

function TSPI_providerInit(dwTSPIVersion, dwPermanentProviderID,
  dwLineDeviceIDBase, dwPhoneDeviceIDBase, dwNumLines, dwNumPhones: DWORD;
{$IFDEF TAPI20}
  lpfnCompletionProc: TASyncCompletion; var lpdwTSPIOptions: DWORD): Longint; stdcall;
{$ELSE}
  lpfnCompletionProc: TASyncCompletion): Longint;  stdcall;
{$ENDIF}
{$EXTERNALSYM TSPI_providerInit}

function TSPI_providerInstall(hwndOwner: HWND;
  dwPermanentProviderID: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_providerInstall}

function TSPI_providerRemove(hwndOwner: HWND;
  dwPermanentProviderID: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_providerRemove}

{$IFDEF TAPI20}
function TSPI_providerShutdown(dwTSPIVersion,
  dwPermanentProviderID: DWORD): Longint; stdcall; // TSPI v2.0
{$ELSE}
function TSPI_providerShutdown(dwTSPIVersion: DWORD): Longint; stdcall; // TSPI v2.0
{$ENDIF}
{$EXTERNALSYM TSPI_providerShutdown}

{$IFDEF TAPI20}
function TSPI_providerUIIdentify(lpszUIDLLName: LPWSTR): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TSPI_providerUIIdentify}
{$ENDIF}

{$IFDEF TAPI30}
function TSPI_lineMSPIdentify(dwDeviceID: DWORD; pCLSID: PGUID): Longint; stdcall;
{$EXTERNALSYM TSPI_lineMSPIdentify}

function TSPI_lineCloseMSPInstance(hdMSPLine: HDRVMSPLINE): Longint; stdcall;
{$EXTERNALSYM TSPI_lineCloseMSPInstance}

function TSPI_lineReceiveMSPData(hdLine: HDRVLINE; hdCall: HDRVCALL;
  hdMSPLine: HDRVMSPLINE; pBuffer: Pointer; dwSize: DWORD): Longint; stdcall;
{$EXTERNALSYM TSPI_lineReceiveMSPData}
{$ENDIF}

{$IFDEF TAPI20}
//
// The following function prototypes pertain
// to a service provider's UI module
//

function TUISPI_lineConfigDialog(lpfnUIDLLCallback: TTUISpiDllCallback;
  dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCWSTR): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_lineConfigDialog}

function TUISPI_lineConfigDialogEdit(lpfnUIDLLCallback: TTUISpiDllCallback;
  dwDeviceID: DWORD; hwndOwner: HWND; lpszDeviceClass: LPCWSTR;
  lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_lineConfigDialogEdit}

function TUISPI_phoneConfigDialog(lpfnUIDLLCallback: TUISpiDllCallback;
  dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCWSTR): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_phoneConfigDialog}

function TUISPI_providerConfig(lpfnUIDLLCallback:  TUISpiDllCallback;
  hwndOwner: HWND; dwPermanentProviderID: DWORD): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_providerConfig}

function TUISPI_providerGenericDialog(lpfnUIDLLCallback: TUISpiDllCallback;
  htDlgInst: HTapiDialogInstance; lpParams: Pointer; dwSize: DWORD;
  hEvent: THandle): Longint;  stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_providerGenericDialog}

function TUISPI_providerGenericDialogData(htDlgInst: HTapiDialogInstance;
  lpParams: Pointer; dwSize: DWORD): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_providerGenericDialogData}

function TUISPI_providerInstall(lpfnUIDLLCallback: TUISpiDllCallback;
  hwndOwner: HWND;
  dwPermanentProviderID: DWORD): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_providerInstall}

function TUISPI_providerRemove(lpfnUIDLLCallback: TUISpiDllCallback;
  hwndOwner: HWND; dwPermanentProviderID: DWORD): Longint; stdcall; // TSPI v2.0
{$EXTERNALSYM TUISPI_providerRemove}
{$ELSE}
//
// The following were obsoleted by the above (but are needed to build 1.4 SPs)
//

function TSPI_lineConfigDialog(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_lineConfigDialog}

function TSPI_lineConfigDialogEdit(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR; const lpDeviceConfigIn: Pointer; dwSize: DWORD;
  lpDeviceConfigOut: PVarString): Longint; stdcall;
{$EXTERNALSYM TSPI_lineConfigDialogEdit}

function TSPI_phoneConfigDialog(dwDeviceID: DWORD; hwndOwner: HWND;
  lpszDeviceClass: LPCSTR): Longint; stdcall;
{$EXTERNALSYM TSPI_phoneConfigDialog}
{$ENDIF}

{$IFNDEF TAPI20}
//
// The following macros are the ordinal numbers of the exported tspi functions
//

const
  TSPI_PROC_BASE = 500;
  {$EXTERNALSYM TSPI_PROC_BASE}

  TSPI_LINEACCEPT                    = (TSPI_PROC_BASE + 0);
  {$EXTERNALSYM TSPI_LINEACCEPT}
  TSPI_LINEADDTOCONFERENCE           = (TSPI_PROC_BASE + 1);
  {$EXTERNALSYM TSPI_LINEADDTOCONFERENCE}
  TSPI_LINEANSWER                    = (TSPI_PROC_BASE + 2);
  {$EXTERNALSYM TSPI_LINEANSWER}
  TSPI_LINEBLINDTRANSFER             = (TSPI_PROC_BASE + 3);
  {$EXTERNALSYM TSPI_LINEBLINDTRANSFER}
  TSPI_LINECLOSE                     = (TSPI_PROC_BASE + 4);
  {$EXTERNALSYM TSPI_LINECLOSE}
  TSPI_LINECLOSECALL                 = (TSPI_PROC_BASE + 5);
  {$EXTERNALSYM TSPI_LINECLOSECALL}
  TSPI_LINECOMPLETECALL              = (TSPI_PROC_BASE + 6);
  {$EXTERNALSYM TSPI_LINECOMPLETECALL}
  TSPI_LINECOMPLETETRANSFER          = (TSPI_PROC_BASE + 7);
  {$EXTERNALSYM TSPI_LINECOMPLETETRANSFER}
  TSPI_LINECONDITIONALMEDIADETECTION = (TSPI_PROC_BASE + 8);
  {$EXTERNALSYM TSPI_LINECONDITIONALMEDIADETECTION}
  TSPI_LINECONFIGDIALOG              = (TSPI_PROC_BASE + 9);
  {$EXTERNALSYM TSPI_LINECONFIGDIALOG}
  TSPI_LINEDEVSPECIFIC               = (TSPI_PROC_BASE + 10);
  {$EXTERNALSYM TSPI_LINEDEVSPECIFIC}
  TSPI_LINEDEVSPECIFICFEATURE        = (TSPI_PROC_BASE + 11);
  {$EXTERNALSYM TSPI_LINEDEVSPECIFICFEATURE}
  TSPI_LINEDIAL                      = (TSPI_PROC_BASE + 12);
  {$EXTERNALSYM TSPI_LINEDIAL}
  TSPI_LINEDROP                      = (TSPI_PROC_BASE + 13);
  {$EXTERNALSYM TSPI_LINEDROP}
  TSPI_LINEFORWARD                   = (TSPI_PROC_BASE + 14);
  {$EXTERNALSYM TSPI_LINEFORWARD}
  TSPI_LINEGATHERDIGITS              = (TSPI_PROC_BASE + 15);
  {$EXTERNALSYM TSPI_LINEGATHERDIGITS}
  TSPI_LINEGENERATEDIGITS            = (TSPI_PROC_BASE + 16);
  {$EXTERNALSYM TSPI_LINEGENERATEDIGITS}
  TSPI_LINEGENERATETONE              = (TSPI_PROC_BASE + 17);
  {$EXTERNALSYM TSPI_LINEGENERATETONE}
  TSPI_LINEGETADDRESSCAPS            = (TSPI_PROC_BASE + 18);
  {$EXTERNALSYM TSPI_LINEGETADDRESSCAPS}
  TSPI_LINEGETADDRESSID              = (TSPI_PROC_BASE + 19);
  {$EXTERNALSYM TSPI_LINEGETADDRESSID}
  TSPI_LINEGETADDRESSSTATUS          = (TSPI_PROC_BASE + 20);
  {$EXTERNALSYM TSPI_LINEGETADDRESSSTATUS}
  TSPI_LINEGETCALLADDRESSID          = (TSPI_PROC_BASE + 21);
  {$EXTERNALSYM TSPI_LINEGETCALLADDRESSID}
  TSPI_LINEGETCALLINFO               = (TSPI_PROC_BASE + 22);
  {$EXTERNALSYM TSPI_LINEGETCALLINFO}
  TSPI_LINEGETCALLSTATUS             = (TSPI_PROC_BASE + 23);
  {$EXTERNALSYM TSPI_LINEGETCALLSTATUS}
  TSPI_LINEGETDEVCAPS                = (TSPI_PROC_BASE + 24);
  {$EXTERNALSYM TSPI_LINEGETDEVCAPS}
  TSPI_LINEGETDEVCONFIG              = (TSPI_PROC_BASE + 25);
  {$EXTERNALSYM TSPI_LINEGETDEVCONFIG}
  TSPI_LINEGETEXTENSIONID            = (TSPI_PROC_BASE + 26);
  {$EXTERNALSYM TSPI_LINEGETEXTENSIONID}
  TSPI_LINEGETICON                   = (TSPI_PROC_BASE + 27);
  {$EXTERNALSYM TSPI_LINEGETICON}
  TSPI_LINEGETID                     = (TSPI_PROC_BASE + 28);
  {$EXTERNALSYM TSPI_LINEGETID}
  TSPI_LINEGETLINEDEVSTATUS          = (TSPI_PROC_BASE + 29);
  {$EXTERNALSYM TSPI_LINEGETLINEDEVSTATUS}
  TSPI_LINEGETNUMADDRESSIDS          = (TSPI_PROC_BASE + 30);
  {$EXTERNALSYM TSPI_LINEGETNUMADDRESSIDS}
  TSPI_LINEHOLD                      = (TSPI_PROC_BASE + 31);
  {$EXTERNALSYM TSPI_LINEHOLD}
  TSPI_LINEMAKECALL                  = (TSPI_PROC_BASE + 32);
  {$EXTERNALSYM TSPI_LINEMAKECALL}
  TSPI_LINEMONITORDIGITS             = (TSPI_PROC_BASE + 33);
  {$EXTERNALSYM TSPI_LINEMONITORDIGITS}
  TSPI_LINEMONITORMEDIA              = (TSPI_PROC_BASE + 34);
  {$EXTERNALSYM TSPI_LINEMONITORMEDIA}
  TSPI_LINEMONITORTONES              = (TSPI_PROC_BASE + 35);
  {$EXTERNALSYM TSPI_LINEMONITORTONES}
  TSPI_LINENEGOTIATEEXTVERSION       = (TSPI_PROC_BASE + 36);
  {$EXTERNALSYM TSPI_LINENEGOTIATEEXTVERSION}
  TSPI_LINENEGOTIATETSPIVERSION      = (TSPI_PROC_BASE + 37);
  {$EXTERNALSYM TSPI_LINENEGOTIATETSPIVERSION}
  TSPI_LINEOPEN                      = (TSPI_PROC_BASE + 38);
  {$EXTERNALSYM TSPI_LINEOPEN}
  TSPI_LINEPARK                      = (TSPI_PROC_BASE + 39);
  {$EXTERNALSYM TSPI_LINEPARK}
  TSPI_LINEPICKUP                    = (TSPI_PROC_BASE + 40);
  {$EXTERNALSYM TSPI_LINEPICKUP}
  TSPI_LINEPREPAREADDTOCONFERENCE    = (TSPI_PROC_BASE + 41);
  {$EXTERNALSYM TSPI_LINEPREPAREADDTOCONFERENCE}
  TSPI_LINEREDIRECT                  = (TSPI_PROC_BASE + 42);
  {$EXTERNALSYM TSPI_LINEREDIRECT}
  TSPI_LINEREMOVEFROMCONFERENCE      = (TSPI_PROC_BASE + 43);
  {$EXTERNALSYM TSPI_LINEREMOVEFROMCONFERENCE}
  TSPI_LINESECURECALL                = (TSPI_PROC_BASE + 44);
  {$EXTERNALSYM TSPI_LINESECURECALL}
  TSPI_LINESELECTEXTVERSION          = (TSPI_PROC_BASE + 45);
  {$EXTERNALSYM TSPI_LINESELECTEXTVERSION}
  TSPI_LINESENDUSERUSERINFO          = (TSPI_PROC_BASE + 46);
  {$EXTERNALSYM TSPI_LINESENDUSERUSERINFO}
  TSPI_LINESETAPPSPECIFIC            = (TSPI_PROC_BASE + 47);
  {$EXTERNALSYM TSPI_LINESETAPPSPECIFIC}
  TSPI_LINESETCALLPARAMS             = (TSPI_PROC_BASE + 48);
  {$EXTERNALSYM TSPI_LINESETCALLPARAMS}
  TSPI_LINESETDEFAULTMEDIADETECTION  = (TSPI_PROC_BASE + 49);
  {$EXTERNALSYM TSPI_LINESETDEFAULTMEDIADETECTION}
  TSPI_LINESETDEVCONFIG              = (TSPI_PROC_BASE + 50);
  {$EXTERNALSYM TSPI_LINESETDEVCONFIG}
  TSPI_LINESETMEDIACONTROL           = (TSPI_PROC_BASE + 51);
  {$EXTERNALSYM TSPI_LINESETMEDIACONTROL}
  TSPI_LINESETMEDIAMODE              = (TSPI_PROC_BASE + 52);
  {$EXTERNALSYM TSPI_LINESETMEDIAMODE}
  TSPI_LINESETSTATUSMESSAGES         = (TSPI_PROC_BASE + 53);
  {$EXTERNALSYM TSPI_LINESETSTATUSMESSAGES}
  TSPI_LINESETTERMINAL               = (TSPI_PROC_BASE + 54);
  {$EXTERNALSYM TSPI_LINESETTERMINAL}
  TSPI_LINESETUPCONFERENCE           = (TSPI_PROC_BASE + 55);
  {$EXTERNALSYM TSPI_LINESETUPCONFERENCE}
  TSPI_LINESETUPTRANSFER             = (TSPI_PROC_BASE + 56);
  {$EXTERNALSYM TSPI_LINESETUPTRANSFER}
  TSPI_LINESWAPHOLD                  = (TSPI_PROC_BASE + 57);
  {$EXTERNALSYM TSPI_LINESWAPHOLD}
  TSPI_LINEUNCOMPLETECALL            = (TSPI_PROC_BASE + 58);
  {$EXTERNALSYM TSPI_LINEUNCOMPLETECALL}
  TSPI_LINEUNHOLD                    = (TSPI_PROC_BASE + 59);
  {$EXTERNALSYM TSPI_LINEUNHOLD}
  TSPI_LINEUNPARK                    = (TSPI_PROC_BASE + 60);
  {$EXTERNALSYM TSPI_LINEUNPARK}
  TSPI_PHONECLOSE                    = (TSPI_PROC_BASE + 61);
  {$EXTERNALSYM TSPI_PHONECLOSE}
  TSPI_PHONECONFIGDIALOG             = (TSPI_PROC_BASE + 62);
  {$EXTERNALSYM TSPI_PHONECONFIGDIALOG}
  TSPI_PHONEDEVSPECIFIC              = (TSPI_PROC_BASE + 63);
  {$EXTERNALSYM TSPI_PHONEDEVSPECIFIC}
  TSPI_PHONEGETBUTTONINFO            = (TSPI_PROC_BASE + 64);
  {$EXTERNALSYM TSPI_PHONEGETBUTTONINFO}
  TSPI_PHONEGETDATA                  = (TSPI_PROC_BASE + 65);
  {$EXTERNALSYM TSPI_PHONEGETDATA}
  TSPI_PHONEGETDEVCAPS               = (TSPI_PROC_BASE + 66);
  {$EXTERNALSYM TSPI_PHONEGETDEVCAPS}
  TSPI_PHONEGETDISPLAY               = (TSPI_PROC_BASE + 67);
  {$EXTERNALSYM TSPI_PHONEGETDISPLAY}
  TSPI_PHONEGETEXTENSIONID           = (TSPI_PROC_BASE + 68);
  {$EXTERNALSYM TSPI_PHONEGETEXTENSIONID}
  TSPI_PHONEGETGAIN                  = (TSPI_PROC_BASE + 69);
  {$EXTERNALSYM TSPI_PHONEGETGAIN}
  TSPI_PHONEGETHOOKSWITCH            = (TSPI_PROC_BASE + 70);
  {$EXTERNALSYM TSPI_PHONEGETHOOKSWITCH}
  TSPI_PHONEGETICON                  = (TSPI_PROC_BASE + 71);
  {$EXTERNALSYM TSPI_PHONEGETICON}
  TSPI_PHONEGETID                    = (TSPI_PROC_BASE + 72);
  {$EXTERNALSYM TSPI_PHONEGETID}
  TSPI_PHONEGETLAMP                  = (TSPI_PROC_BASE + 73);
  {$EXTERNALSYM TSPI_PHONEGETLAMP}
  TSPI_PHONEGETRING                  = (TSPI_PROC_BASE + 74);
  {$EXTERNALSYM TSPI_PHONEGETRING}
  TSPI_PHONEGETSTATUS                = (TSPI_PROC_BASE + 75);
  {$EXTERNALSYM TSPI_PHONEGETSTATUS}
  TSPI_PHONEGETVOLUME                = (TSPI_PROC_BASE + 76);
  {$EXTERNALSYM TSPI_PHONEGETVOLUME}
  TSPI_PHONENEGOTIATEEXTVERSION      = (TSPI_PROC_BASE + 77);
  {$EXTERNALSYM TSPI_PHONENEGOTIATEEXTVERSION}
  TSPI_PHONENEGOTIATETSPIVERSION     = (TSPI_PROC_BASE + 78);
  {$EXTERNALSYM TSPI_PHONENEGOTIATETSPIVERSION}
  TSPI_PHONEOPEN                     = (TSPI_PROC_BASE + 79);
  {$EXTERNALSYM TSPI_PHONEOPEN}
  TSPI_PHONESELECTEXTVERSION         = (TSPI_PROC_BASE + 80);
  {$EXTERNALSYM TSPI_PHONESELECTEXTVERSION}
  TSPI_PHONESETBUTTONINFO            = (TSPI_PROC_BASE + 81);
  {$EXTERNALSYM TSPI_PHONESETBUTTONINFO}
  TSPI_PHONESETDATA                  = (TSPI_PROC_BASE + 82);
  {$EXTERNALSYM TSPI_PHONESETDATA}
  TSPI_PHONESETDISPLAY               = (TSPI_PROC_BASE + 83);
  {$EXTERNALSYM TSPI_PHONESETDISPLAY}
  TSPI_PHONESETGAIN                  = (TSPI_PROC_BASE + 84);
  {$EXTERNALSYM TSPI_PHONESETGAIN}
  TSPI_PHONESETHOOKSWITCH            = (TSPI_PROC_BASE + 85);
  {$EXTERNALSYM TSPI_PHONESETHOOKSWITCH}
  TSPI_PHONESETLAMP                  = (TSPI_PROC_BASE + 86);
  {$EXTERNALSYM TSPI_PHONESETLAMP}
  TSPI_PHONESETRING                  = (TSPI_PROC_BASE + 87);
  {$EXTERNALSYM TSPI_PHONESETRING}
  TSPI_PHONESETSTATUSMESSAGES        = (TSPI_PROC_BASE + 88);
  {$EXTERNALSYM TSPI_PHONESETSTATUSMESSAGES}
  TSPI_PHONESETVOLUME                = (TSPI_PROC_BASE + 89);
  {$EXTERNALSYM TSPI_PHONESETVOLUME}
  TSPI_PROVIDERCONFIG                = (TSPI_PROC_BASE + 90);
  {$EXTERNALSYM TSPI_PROVIDERCONFIG}
  TSPI_PROVIDERINIT                  = (TSPI_PROC_BASE + 91);
  {$EXTERNALSYM TSPI_PROVIDERINIT}
  TSPI_PROVIDERINSTALL               = (TSPI_PROC_BASE + 92);
  {$EXTERNALSYM TSPI_PROVIDERINSTALL}
  TSPI_PROVIDERREMOVE                = (TSPI_PROC_BASE + 93);
  {$EXTERNALSYM TSPI_PROVIDERREMOVE}
  TSPI_PROVIDERSHUTDOWN              = (TSPI_PROC_BASE + 94);
  {$EXTERNALSYM TSPI_PROVIDERSHUTDOWN}

  TSPI_PROVIDERENUMDEVICES           = (TSPI_PROC_BASE + 95); // TSPI v1.4
  {$EXTERNALSYM TSPI_PROVIDERENUMDEVICES}
  TSPI_LINEDROPONCLOSE               = (TSPI_PROC_BASE + 96); // TSPI v1.4
  {$EXTERNALSYM TSPI_LINEDROPONCLOSE}
  TSPI_LINEDROPNOOWNER               = (TSPI_PROC_BASE + 97); // TSPI v1.4
  {$EXTERNALSYM TSPI_LINEDROPNOOWNER}
  TSPI_PROVIDERCREATELINEDEVICE      = (TSPI_PROC_BASE + 98); // TSPI v1.4
  {$EXTERNALSYM TSPI_PROVIDERCREATELINEDEVICE}
  TSPI_PROVIDERCREATEPHONEDEVICE     = (TSPI_PROC_BASE + 99); // TSPI v1.4
  {$EXTERNALSYM TSPI_PROVIDERCREATEPHONEDEVICE}
  TSPI_LINESETCURRENTLOCATION        = (TSPI_PROC_BASE + 100); // TSPI v1.4
  {$EXTERNALSYM TSPI_LINESETCURRENTLOCATION}
  TSPI_LINECONFIGDIALOGEDIT          = (TSPI_PROC_BASE + 101); // TSPI v1.4
  {$EXTERNALSYM TSPI_LINECONFIGDIALOGEDIT}
  TSPI_LINERELEASEUSERUSERINFO       = (TSPI_PROC_BASE + 102); // TSPI v1.4
  {$EXTERNALSYM TSPI_LINERELEASEUSERUSERINFO}

  TSPI_LINEGETCALLID                 = (TSPI_PROC_BASE + 103); // TSPI v3.0
  {$EXTERNALSYM TSPI_LINEGETCALLID}
  TSPI_LINEGETCALLHUBTRACKING        = (TSPI_PROC_BASE + 104); // TSPI v3.0
  {$EXTERNALSYM TSPI_LINEGETCALLHUBTRACKING}
  TSPI_LINESETCALLHUBTRACKING        = (TSPI_PROC_BASE + 105); // TSPI v3.0
  {$EXTERNALSYM TSPI_LINESETCALLHUBTRACKING}
  TSPI_LINERECEIVEMSPDATA            = (TSPI_PROC_BASE + 106); // TSPI v3.0
  {$EXTERNALSYM TSPI_LINERECEIVEMSPDATA}
  TSPI_LINEMSPIDENTIFY               = (TSPI_PROC_BASE + 107); // TSPI v3.0
  {$EXTERNALSYM TSPI_LINEMSPIDENTIFY}
  TSPI_LINECREATEMSPINSTANCE         = (TSPI_PROC_BASE + 108); // TSPI v3.0
  {$EXTERNALSYM TSPI_LINECREATEMSPINSTANCE}
  TSPI_LINECLOSEMSPINSTANCE          = (TSPI_PROC_BASE + 109); // TSPI v3.0
  {$EXTERNALSYM TSPI_LINECLOSEMSPINSTANCE}
{$ENDIF}

implementation


const
  TSpiDll = 'tspi.dll';

function TSPI_lineAccept; external TSpiDll name 'TSPI_lineAccept';
function TSPI_lineAddToConference; external TSpiDll name 'TSPI_lineAddToConference';
function TSPI_lineAnswer; external TSpiDll name 'TSPI_lineAnswer';
function TSPI_lineBlindTransfer; external TSpiDll name 'TSPI_lineBlindTransfer';
function TSPI_lineClose; external TSpiDll name 'TSPI_lineClose';
function TSPI_lineCloseCall; external TSpiDll name 'TSPI_lineCloseCall';
function TSPI_lineCompleteCall; external TSpiDll name 'TSPI_lineCompleteCall';
function TSPI_lineCompleteTransfer; external TSpiDll name 'TSPI_lineCompleteTransfer';
function TSPI_lineConditionalMediaDetection; external TSpiDll name 'TSPI_lineConditionalMediaDetection';
function TSPI_lineDevSpecific; external TSpiDll name 'TSPI_lineDevSpecific';
function TSPI_lineDevSpecificFeature; external TSpiDll name 'TSPI_lineDevSpecificFeature';
function TSPI_lineDial; external TSpiDll name 'TSPI_lineDial';
function TSPI_lineDrop; external TSpiDll name 'TSPI_lineDrop';
function TSPI_lineDropOnClose; external TSpiDll name 'TSPI_lineDropOnClose';
function TSPI_lineDropNoOwner; external TSpiDll name 'TSPI_lineDropNoOwner';
function TSPI_lineForward; external TSpiDll name 'TSPI_lineForward';
function TSPI_lineGatherDigits; external TSpiDll name 'TSPI_lineGatherDigits';
function TSPI_lineGenerateDigits; external TSpiDll name 'TSPI_lineGenerateDigits';
function TSPI_lineGenerateTone; external TSpiDll name 'TSPI_lineGenerateTone';
function TSPI_lineGetAddressCaps; external TSpiDll name 'TSPI_lineGetAddressCaps';
function TSPI_lineGetAddressID; external TSpiDll name 'TSPI_lineGetAddressID';
function TSPI_lineGetAddressStatus; external TSpiDll name 'TSPI_lineGetAddressStatus';
function TSPI_lineGetCallAddressID; external TSpiDll name 'TSPI_lineGetCallAddressID';
{$IFDEF TAPI30}
function TSPI_lineGetCallHubTracking; external TspiDll name 'TSPI_lineGetCallHubTracking';
function TSPI_lineGetCallIDs; external TspiDll name 'TSPI_lineGetCallIDs';
{$ENDIF}
function TSPI_lineGetCallInfo; external TSpiDll name 'TSPI_lineGetCallInfo';
function TSPI_lineGetCallStatus; external TSpiDll name 'TSPI_lineGetCallStatus';
function TSPI_lineGetDevCaps; external TSpiDll name 'TSPI_lineGetDevCaps';
function TSPI_lineGetDevConfig; external TSpiDll name 'TSPI_lineGetDevConfig';
function TSPI_lineGetExtensionID; external TSpiDll name 'TSPI_lineGetExtensionID';
function TSPI_lineGetIcon; external TSpiDll name 'TSPI_lineGetIcon';
function TSPI_lineGetID; external TSpiDll name 'TSPI_lineGetID';
function TSPI_lineGetLineDevStatus; external TSpiDll name 'TSPI_lineGetLineDevStatus';
function TSPI_lineGetNumAddressIDs; external TSpiDll name 'TSPI_lineGetNumAddressIDs';
function TSPI_lineHold; external TSpiDll name 'TSPI_lineHold';
function TSPI_lineMakeCall; external TSpiDll name 'TSPI_lineMakeCall';
function TSPI_lineMonitorDigits; external TSpiDll name 'TSPI_lineMonitorDigits';
function TSPI_lineMonitorMedia; external TSpiDll name 'TSPI_lineMonitorMedia';
function TSPI_lineMonitorTones; external TSpiDll name 'TSPI_lineMonitorTones';
function TSPI_lineNegotiateExtVersion; external TSpiDll name 'TSPI_lineNegotiateExtVersion';
function TSPI_lineNegotiateTSPIVersion; external TSpiDll name 'TSPI_lineNegotiateTSPIVersion';
function TSPI_lineOpen; external TSpiDll name 'TSPI_lineOpen';
function TSPI_linePark; external TSpiDll name 'TSPI_linePark';
function TSPI_linePickup; external TSpiDll name 'TSPI_linePickup';
function TSPI_linePrepareAddToConference; external TSpiDll name 'TSPI_linePrepareAddToConference';
function TSPI_lineRedirect; external TSpiDll name 'TSPI_lineRedirect';
function TSPI_lineReleaseUserUserInfo; external TSpiDll name 'TSPI_lineReleaseUserUserInfo';
function TSPI_lineRemoveFromConference; external TSpiDll name 'TSPI_lineRemoveFromConference';
function TSPI_lineSecureCall; external TSpiDll name 'TSPI_lineSecureCall';
function TSPI_lineSelectExtVersion; external TSpiDll name 'TSPI_lineSelectExtVersion';
function TSPI_lineSendUserUserInfo; external TSpiDll name 'TSPI_lineSendUserUserInfo';
function TSPI_lineSetAppSpecific; external TSpiDll name 'TSPI_lineSetAppSpecific';
function TSPI_lineSetCallParams; external TSpiDll name 'TSPI_lineSetCallParams';
function TSPI_lineSetCurrentLocation; external TSpiDll name 'TSPI_lineSetCurrentLocation';
function TSPI_lineSetDefaultMediaDetection; external TSpiDll name 'TSPI_lineSetDefaultMediaDetection';
function TSPI_lineSetDevConfig; external TSpiDll name 'TSPI_lineSetDevConfig';
function TSPI_lineSetMediaControl; external TSpiDll name 'TSPI_lineSetMediaControl';
function TSPI_lineSetMediaMode; external TSpiDll name 'TSPI_lineSetMediaMode';
function TSPI_lineSetStatusMessages; external TSpiDll name 'TSPI_lineSetStatusMessages';
function TSPI_lineSetTerminal; external TSpiDll name 'TSPI_lineSetTerminal';
function TSPI_lineSetupConference; external TSpiDll name 'TSPI_lineSetupConference';
function TSPI_lineSetupTransfer; external TSpiDll name 'TSPI_lineSetupTransfer';
function TSPI_lineSwapHold; external TSpiDll name 'TSPI_lineSwapHold';
function TSPI_lineUncompleteCall; external TSpiDll name 'TSPI_lineUncompleteCall';
function TSPI_lineUnhold; external TSpiDll name 'TSPI_lineUnhold';
function TSPI_lineUnpark; external TSpiDll name 'TSPI_lineUnpark';

function TSPI_phoneClose; external TSpiDll name 'TSPI_phoneClose';
function TSPI_phoneDevSpecific; external TSpiDll name 'TSPI_phoneDevSpecific';
function TSPI_phoneGetButtonInfo; external TSpiDll name 'TSPI_phoneGetButtonInfo';
function TSPI_phoneGetData; external TSpiDll name 'TSPI_phoneGetData';
function TSPI_phoneGetDevCaps; external TSpiDll name 'TSPI_phoneGetDevCaps';
function TSPI_phoneGetDisplay; external TSpiDll name 'TSPI_phoneGetDisplay';
function TSPI_phoneGetExtensionID; external TSpiDll name 'TSPI_phoneGetExtensionID';
function TSPI_phoneGetGain; external TSpiDll name 'TSPI_phoneGetGain';
function TSPI_phoneGetHookSwitch; external TSpiDll name 'TSPI_phoneGetHookSwitch';
function TSPI_phoneGetIcon; external TSpiDll name 'TSPI_phoneGetIcon';
function TSPI_phoneGetID; external TSpiDll name 'TSPI_phoneGetID';
function TSPI_phoneGetLamp; external TSpiDll name 'TSPI_phoneGetLamp';
function TSPI_phoneGetRing; external TSpiDll name 'TSPI_phoneGetRing';
function TSPI_phoneGetStatus; external TSpiDll name 'TSPI_phoneGetStatus';
function TSPI_phoneGetVolume; external TSpiDll name 'TSPI_phoneGetVolume';
function TSPI_phoneNegotiateExtVersion; external TSpiDll name 'TSPI_phoneNegotiateExtVersion';
function TSPI_phoneNegotiateTSPIVersion; external TSpiDll name 'TSPI_phoneNegotiateTSPIVersion';
function TSPI_phoneOpen; external TSpiDll name 'TSPI_phoneOpen';
function TSPI_phoneSelectExtVersion; external TSpiDll name 'TSPI_phoneSelectExtVersion';
function TSPI_phoneSetButtonInfo; external TSpiDll name 'TSPI_phoneSetButtonInfo';
function TSPI_phoneSetData; external TSpiDll name 'TSPI_phoneSetData';
function TSPI_phoneSetDisplay; external TSpiDll name 'TSPI_phoneSetDisplay';
function TSPI_phoneSetGain; external TSpiDll name 'TSPI_phoneSetGain';
function TSPI_phoneSetHookSwitch; external TSpiDll name 'TSPI_phoneSetHookSwitch';
function TSPI_phoneSetLamp; external TSpiDll name 'TSPI_phoneSetLamp';
function TSPI_phoneSetRing; external TSpiDll name 'TSPI_phoneSetRing';
function TSPI_phoneSetStatusMessages; external TSpiDll name 'TSPI_phoneSetStatusMessages';
function TSPI_phoneSetVolume; external TSpiDll name 'TSPI_phoneSetVolume';
function TSPI_providerConfig; external TSpiDll name 'TSPI_providerConfig';

function TSPI_providerCreateLineDevice; external TSpiDll name 'TSPI_providerCreateLineDevice';
function TSPI_providerCreatePhoneDevice; external TSpiDll name 'TSPI_providerCreatePhoneDevice';
function TSPI_providerEnumDevices; external TSpiDll name 'TSPI_providerEnumDevices';
function TSPI_providerInit; external TSpiDll name 'TSPI_providerInit';
function TSPI_providerInstall; external TSpiDll name 'TSPI_providerInstall';
function TSPI_providerRemove; external TSpiDll name 'TSPI_providerRemove';
function TSPI_providerShutdown; external TSpiDll name 'TSPI_providerShutdown';

{$IFDEF TAPI20}
function TSPI_lineSetCallData; external TSpiDll name 'TSPI_lineSetCallData';
{$ENDIF}
{$IFDEF TAPI30}
function TSPI_lineSetCallHubTracking; external TspiDll name 'TSPI_lineSetCallHubTracking';
{$ENDIF}
{$IFDEF TAPI20}
function TSPI_lineSetCallQualityOfService; external TSpiDll name 'TSPI_lineSetCallQualityOfService';
function TSPI_lineSetCallTreatment; external TSpiDll name 'TSPI_lineSetCallTreatment';
function TSPI_lineSetLineDevStatus; external TSpiDll name 'TSPI_lineSetLineDevStatus';
{$ENDIF}

{$IFDEF TAPI20}
function TSPI_providerFreeDialogInstance; external TSpiDll name 'TSPI_providerFreeDialogInstance';
function TSPI_providerGenericDialogData; external TSpiDll name 'TSPI_providerGenericDialogData';
function TSPI_providerUIIdentify; external TSpiDll name 'TSPI_providerUIIdentify';
{$ENDIF}
{$IFDEF TAPI30}
function TSPI_lineMSPIdentify; external TspiDll name 'TSPI_lineMSPIdentify';
function TSPI_lineCloseMSPInstance; external TspiDll name 'TSPI_lineCloseMSPInstance';
function TSPI_lineReceiveMSPData; external TspiDll name 'TSPI_lineReceiveMSPData';
{$ENDIF}

{$IFDEF TAPI20}
function TUISPI_lineConfigDialog; external TSpiDll name 'TUISPI_lineConfigDialog';
function TUISPI_lineConfigDialogEdit; external TSpiDll name 'TUISPI_lineConfigDialogEdit';
function TUISPI_phoneConfigDialog; external TSpiDll name 'TUISPI_phoneConfigDialog';
function TUISPI_providerConfig; external TSpiDll name 'TUISPI_providerConfig';
function TUISPI_providerGenericDialog; external TSpiDll name 'TUISPI_providerGenericDialog';
function TUISPI_providerGenericDialogData; external TSpiDll name 'TUISPI_providerGenericDialogData';
function TUISPI_providerInstall; external TSpiDll name 'TUISPI_providerInstall';
function TUISPI_providerRemove; external TSpiDll name 'TUISPI_providerRemove';
{$ELSE}
function TUISPI_lineConfigDialog; external TSpiDll name 'TUISPI_lineConfigDialog';
function TUISPI_lineConfigDialogEdit; external TSpiDll name 'TUISPI_lineConfigDialogEdit';
function TUISPI_phoneConfigDialog; external TSpiDll name 'TUISPI_phoneConfigDialog';
{$ENDIF}

end.
