{*******************************************}
{ GTDBForm Component By GenoTechs, Inc.     }
{ Copyright(c) GenoTechs, Inc. 1996-1997    }
{ All rights reserved                       }
{*******************************************}

unit GTDBSizr;

interface
uses
  GTSize32, {wwDBGrid,} DBGrids, Classes;

type

  GTDBForm = class(GTForm)
  private
   Procedure IsParentFont(Obj: TComponent; NHPcnt:Double); Override;
  end;

procedure Register;

implementation

  { If a 3rd party control's font property fails to resize when using GTSizer
    it is probably because the name of that font property is not any of the
    following:  (Font, TitleFont, TabFont).  Or it could be that the name of the
    control itself  is not recognized by the GTSizer.  If this happens, follow
    the example below to make the GTSizer recognize the control or font property.
    The font property must have been declared as type TFont.
    The TControl class must be on the inheritance hierrachy of the control}

procedure Register;
begin
  RegisterComponents('Data Controls', [GTDBForm]);
end;

Procedure GTDBForm.IsParentFont(Obj: TComponent; NHPcnt:Double);
begin
  Inherited IsParentFont(Obj,NHPcnt);

  {This handles the TitleFont property of a TDBGrid}
  If Obj is TDBGrid then
  begin
    If NHPcnt = 450.0 then
       FControls.TFontHeight := TDBGrid(Obj).TitleFont.Height else
    If (NHPcnt = -450.0) then
      TDBGrid(Obj).TitleFont.Height := FControls.TFontHeight else
    TDBGrid(Obj).TitleFont.Height :=
                      Round(TDBGrid(Obj).TitleFont.Height * NHPcnt);
  end
  {To use a Woll2Woll grid, remove comments from the uses clause above.
   Uncomment the following line of code, and compile this unit. Then
   add the resulting GTDBSizr.DCU to the component library and compile}

{else  If Obj is TwwDBGrid then
  begin
    If NHPcnt = 450.0 then
       FControls.TFontHeight := TwwDBGrid(Obj).TitleFont.Height else
    If (NHPcnt = -450.0) then
      TwwDBGrid(Obj).TitleFont.Height := FControls.TFontHeight else
    TwwDBGrid(Obj).TitleFont.Height :=
                      Round(TwwDBGrid(Obj).TitleFont.Height * NHPcnt);
  end  {}

{else If Obj is YourControl's-class then
 begin
    If NHPcnt = 450.0 then
       FControls.TFontHeight := YourControl's-class(Obj).YourControl's-font-property.Height else
    If (NHPcnt = -450.0) then
       YourControl's-class (Obj).YourControl's-font-property.Height := FControls.TFontHeight else
    YourControl's-class (Obj).YourControl's font property.Height :=
                Round(YourControl's-class(Obj).YourControl's-font-property.Height * NHPcnt);
 end {};

end;

end.
