unit Rtmctrls;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Menus, GTSize32;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    AddControls1: TMenuItem;
    FormReset1: TMenuItem;
    DeleteControls1: TMenuItem;
    Exit1: TMenuItem;
    Label2: TLabel;
    Edit2: TEdit;
    GTForm1: GTForm;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure GTForm1GTOnCreate(Sender: TObject);
    procedure DeleteControls1Click(Sender: TObject);
    Procedure MakeControls;
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  EditList: array[0..8] of TEdit;
  LabelList: array[0..8] of TLabel;
  Memo1: TMemo;

Const     {Used only to avoid duplicating control names}
  MadeControls : Boolean = False;

implementation
    var OldHeight, OldWidth: Integer;
{$R *.DFM}

Procedure TForm1.MakeControls;
var I: Integer;
NameStr: String[63];
begin
    {Record Existing label and edit controls}
    EditList[0] := Edit1;
    EditList[1] := Edit2;
    {Set the Label's FocusControl property so
    GTForm can place them close to each other}
    Label1.FocusControl := Edit1;
    LabelList[0] := Label1;
    Label2.FocusControl := Edit2;
    LabelList[1] := Label2;
    I := 2;
    While I < 8 do
    begin
       EditList[I] := TEdit.Create(Self);
       EditList[I].Parent := Self; {Assign the parent property}
       EditList[I].Font := EditList[I-1].Font; {Use existing font}
       EditList[I].Top := EditList[I-1].Top + EditList[I-1].Height + 15;
       EditList[I].Width := EditList[I-1].Width;
       EditList[I].Height := EditList[I-1].Height;
       EditList[I].Left := EditList[I-1].Left;
       EditList[I].Text := 'Edit'+ IntToStr(I+1);
       NameStr := 'Edit'+ IntToStr(I+1);  {Give new controls unique names}
       EditList[I].Name := TComponentName(NameStr);

       LabelList[I] := TLabel.Create(Self);
       LabelList[I].Parent := Self; {Assign the parent property}
       LabelList[I].Font := LabelList[I-1].Font;
       LabelList[I].Top := LabelList[I-1].Top + LabelList[I-1].Height + 23;
       LabelList[I].Height := LabelList[I-1].Height;
       LabelList[I].Left := LabelList[I-1].Left;
       {Always set the FocusControl property for Labels if using GTForm}
       LabelList[I].FocusControl := EditList[I];
       LabelList[I].Caption := 'Label'+ IntToStr(I+1)+':';
       NameStr := 'Label'+ IntToStr(I+1); {Give new controls unique names}
       LabelList[I].Name := TComponentName(NameStr);

       LabelList[I].Visible := True;
       EditList[I].Visible := True;
       Inc(I);
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var  I : Integer;
NameStr: String[63];
Done: Boolean;
begin
 Try
  If not MadeControls then
  begin
    {Reset form to original design proportions before adding new controls}
    GTForm1.FormReset;
    {Disable the Resizing feature if the form alone will grow.}
    {This ensures that you can add new controls in the space created by}
    {increasing the form size.  }
    GTForm1.Enabled := False;
    OldHeight := ClientHeight;
    ClientHeight := 360;  {Increase the ClientHeight if necessary}
    MakeControls;{Add controls to the form as desired}
    {Increase the form's width, if necessary, to add more controls.}
    OldWidth := ClientWidth;
    ClientWidth := 473;
    Memo1 := TMemo.Create(Self); {Create a memo control}
    Memo1.Parent := Self;
    Memo1.Top := Edit1.Top;
    Memo1.Left := 220;
    Memo1.Height := EditList[7].Top;
    Memo1.Width := 243;
    Try
    Done := True;
    Repeat
      Try
        NameStr := 'RTMCTRLS.PAS'; {Display the source code for this program in the memo}
        NameStr := InputBox('Find file','Enter full pathname of text file to display:',
                            NameStr);
        Memo1.Lines.LoadFromFile(NameStr);
    except
      On EInOutError do Done := False;{}
    end;
    until Done;
    Finally
    Memo1.ScrollBars := ssBoth;
    NameStr := 'Memo1';
    Memo1.Name := TComponentName(NameStr);
    MadeControls := True; {Used only to avoid duplicating control names}
    end;
  end else ShowMessage('Delete the control first');
  Finally
  {Inform GTform that controls have been dynamically added or deleted}
  GTForm1.DynamicControls;
  {Re-enable resizing feature}
  GTForm1.SizeBalancing := True;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  GTForm1.FormReset;
end;

procedure TForm1.GTForm1GTOnCreate(Sender: TObject);
begin
  GTForm1.SizeBalancing := True;
end;

procedure TForm1.DeleteControls1Click(Sender: TObject);
var I:Integer;
begin
  If MadeControls then
  begin
    {Always start by resetting the GTForm to original design size}
    GTForm1.FormReset;
    RemoveControl(Memo1); {Remove from form's control list}
    Memo1.Destroy; {Free memory}
    GTForm1.Enabled := False; {Disable Resizing before changing form's size}
    ClientWidth := OldWidth; {Reduce the form's width if necessary}

    EditList[0] := Nil; {Edit1 and Label1 not actualy destroyed}
    EditList[1] := Nil;
    LabelList[0] := Nil;
    LabelList[1] := Nil;
    Label1.FocusControl := Edit1;
    Label2.FocusControl := Edit2;
    I := 2;
    While I < 8 do
     begin  {Destroy the rest of the Edit and Label controls}
       RemoveControl(EditList[I]);
       EditList[I].destroy;
       EditList[I] := Nil;
       RemoveControl(LabelList[I]);
       LabelList[I].destroy;
       LabelList[I] := Nil;
       Inc(I);
     end;
    ClientHeight := OldHeight; {Reduce the form's ClientHeight if necessary}
    {Inform GTform that controls have been dynamically added or deleted}
    GTForm1.DynamicControls;
    {Re-enable resizing feature}
    GTForm1.SizeBalancing := True;
    MadeControls := False;
    end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

end.
 