unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, Gtsize32;

type
  TMDIMain = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    StatusBar: TStatusBar;
    AboutGTSizer1: TMenuItem;
    OrderForm1: TMenuItem;
    Introduction1: TMenuItem;
    PopupMenu1: TPopupMenu;
    Introduction2: TMenuItem;
    OrderForm2: TMenuItem;
    Resolutions1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure True2Click(Sender: TObject);
    procedure False2Click(Sender: TObject);
    procedure FormReset2Click(Sender: TObject);
    procedure On2Click(Sender: TObject);
    procedure Off2Click(Sender: TObject);
    procedure Resolutions2Click(Sender: TObject);
    procedure OrderForm1Click(Sender: TObject);
    procedure AboutGTSizer1Click(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure Introduction2Click(Sender: TObject);
    procedure Resolutions1Click(Sender: TObject);
  private
    { Private declarations }
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MDIMain: TMDIMain;

implementation

{$R *.DFM}

Uses Maindemo, OrdrInfo, ResCover;

procedure TMDIMain.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
end;

procedure TMDIMain.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TMDIMain.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
    ActiveMDIChild.Close;
end;

procedure TMDIMain.FileSaveItemClick(Sender: TObject);
begin
  { save current file (ActiveMDIChild points to the window) }
end;

procedure TMDIMain.FileSaveAsItemClick(Sender: TObject);
begin
  { save current file under new name }
end;

procedure TMDIMain.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMDIMain.CutItemClick(Sender: TObject);
begin
  {cut selection to clipboard}
end;

procedure TMDIMain.CopyItemClick(Sender: TObject);
begin
  {copy selection to clipboard}
end;

procedure TMDIMain.PasteItemClick(Sender: TObject);
begin
  {paste from clipboard}
end;

procedure TMDIMain.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMDIMain.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMDIMain.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMDIMain.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMDIMain.UpdateMenuItems(Sender: TObject);
begin
  FileCloseItem.Enabled := MDIChildCount > 0;
  FileSaveItem.Enabled := MDIChildCount > 0;
  FileSaveAsItem.Enabled := MDIChildCount > 0;
  CutItem.Enabled := MDIChildCount > 0;
  CopyItem.Enabled := MDIChildCount > 0;
  PasteItem.Enabled := MDIChildCount > 0;
  SaveBtn.Enabled := MDIChildCount > 0;
  CutBtn.Enabled := MDIChildCount > 0;
  CopyBtn.Enabled := MDIChildCount > 0;
  PasteBtn.Enabled := MDIChildCount > 0;
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMDIMain.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TMDIMain.True2Click(Sender: TObject);
begin
  {GTForm1.Enabled := True;{}
end;

procedure TMDIMain.False2Click(Sender: TObject);
begin
  {GTForm1.Enabled := False;{}
end;

procedure TMDIMain.FormReset2Click(Sender: TObject);
begin
  {GTForm1.FormReset;  {}
end;

procedure TMDIMain.On2Click(Sender: TObject);
begin
  {GTForm1.SizeBalancing := True;{}
end;

procedure TMDIMain.Off2Click(Sender: TObject);
begin
  {GTForm1.SizeBalancing := False;  {}
end;

procedure TMDIMain.Resolutions2Click(Sender: TObject);
begin
   ResForm := TResForm.Create(Application);
   ResForm.ShowModal;{}
end;

procedure TMDIMain.OrderForm1Click(Sender: TObject);
begin
   OrderForm.Show;{}
end;

procedure TMDIMain.AboutGTSizer1Click(Sender: TObject);
begin
  ShowMessage('This is a demo of the GTSizer VCL');
end;

procedure TMDIMain.OpenBtnClick(Sender: TObject);
begin
PopupMenu1.Popup(Left + 15,Top + 25);
end;

procedure TMDIMain.Introduction2Click(Sender: TObject);
begin
   AboutGTSizer.Show;{}
end;

procedure TMDIMain.Resolutions1Click(Sender: TObject);
begin
   ResForm := TResForm.Create(Application);
   ResForm.ShowModal;{}
end;

end.
