{ *********************************************** }
{                                                 }
{   Formula Compiler ver 4.0                      }
{   Copyright 1996, 1998 by Dimak and Vlad S.     }
{   Example of using FC to plot graphs            }
{                                                 }
{ *********************************************** }
{ This is an example of plotting graphs using FC. }
{ You can view 10 surfaces z = f(x, y)            }
{ -2 <= x,y <= 2 . Most of f(x, y) are based on   }
{ trigonometric functions. Also you can view some }
{ simple 2D graphs. All you need is click an      }
{ element in the RadioGroup.                      }
{ *********************************************** }

unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, FC;

type
  TMainForm = class(TForm)
    PaintBox3D: TImage;
    FC: TFormulaCompilerE;
    Radio3D: TRadioGroup;
    FormulaLib1: TFormulaLib;
    Radio2D: TRadioGroup;
    PaintBox2D: TImage;
    procedure FormCreate(Sender: TObject);
    procedure Radio3DClick(Sender: TObject);
    procedure Radio2DClick(Sender: TObject);
  private
    { Private declarations }
    XCen, YCen: Integer;
    function  Get2DPoint(X, Y, Z: Extended): TPoint;
    procedure Do3DGraph;
    procedure Do2DGraph;
  public
    { Public declarations }
  end;

const
  Ratio = 30;
  Sections = 80;
  Bounds = 2;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

{ X, Y, Z determines 3D point, Result is projection of this point to screen }
function  TMainForm.Get2DPoint(X, Y, Z: Extended): TPoint;
begin
  Result := Point(Round(XCen + Ratio * (X - Y * 1/sqrt(2))),
                  Round(YCen + Ratio * (-Z + y *1/sqrt(2))));
end;

{ Very simple. but not very fast algorithm for drawing 3D surfaces }
procedure TMainForm.Do3DGraph;
var
  I: Integer;
  P: TPoint;
  X, Y, H: Extended;
  Max, Min: Array [0..1024] of Integer;
begin

  with PaintBox3D.Canvas do begin
    Brush.Color := clBlack;
    FillRect(Rect(0, 0, Width, Height));

    if Radio3D.ItemIndex = -1 then Exit;

    for i := 0 to 1024 do
    begin
      Max[i] := 0;
      Min[i] := Height;
    end;

    X := Bounds;
    H := 2 * Bounds / Sections;
    while X >= -Bounds do begin
      Y := -Bounds;
      while Y <= Bounds do begin
        P := Get2DPoint(X, Y, FC.F([X, Y]));

        if P.Y > Max[P.X] then begin
          Pixels[P.X, P.Y] := clYellow;
          Max[P.X] := P.Y;
        end;
        if P.Y < Min[P.X] then begin
          Pixels[P.X, P.Y] := clYellow;
          Min[P.X] := P.Y;
        end;

        Y := Y + H;
      end;
      X := X - H;
    end;
  end;
end;

{ Drawing 2D graph  }
procedure TMainForm.Do2DGraph;
var
  X, Y, H: Extended;
  tW, tH: Integer;
begin
  tW := PaintBox2D.Width;
  tH := PaintBox2D.Height;

  with PaintBox2D.Canvas do begin
    Brush.Color := clBlack;
    FillRect(Rect(0, 0, Width, Height));
    Pen.Color := clWhite;
    MoveTo(0, tH div 2); LineTo(tW, tH div 2);
    MoveTo(tW div 2, 0); LineTo(tW div 2, tH);

    if Radio2D.ItemIndex = -1 then Exit;

    Pen.Color := clYellow;
    X := -Pi; Y := FC.F([X]);
    H := 2 * Pi / tW;

    MoveTo(Round(tW div 2 + tW * X / (2 * Pi)),
           Round(tH div 2 - tH * Y / 3));
    while X <= Pi do
    begin
      Y := FC.F([x]);
      LineTo(Round(tW div 2 + tW * X / (2 * Pi)),
             Round(tH div 2 - tH * Y / 3));
      X := X + H;
    end;
  end;
end;


procedure TMainForm.FormCreate(Sender: TObject);
begin
  XCen := PaintBox3D.Width div 2;
  YCen := PaintBox3D.Height div 2;
  Do3DGraph;
  Do2DGraph;
end;

procedure TMainForm.Radio3DClick(Sender: TObject);
begin
  FC.Source := Radio3D.Items[Radio3D.ItemIndex];
  Do3DGraph;
end;

procedure TMainForm.Radio2DClick(Sender: TObject);
begin
  FC.Source := Radio2D.Items[Radio2D.ItemIndex];
  Do2DGraph;
end;

end.
