{ *********************************************** }
{                                                 }
{   Formula Compiler ver 4.0                      }
{   Copyright 1996, 1998 by Dimak and Vlad S.     }
{   Database example                              }
{                                                 }
{ *********************************************** }
{ This is an example of using FC with databases.  }
{ Using FC you can isolate calculations from      }
{ program code.                                   }
{ *********************************************** }

unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DBTables, DB, Grids, DBGrids, FC, StdCtrls, ExtCtrls,
  Buttons;

type
  TMainForm = class(TForm)
    FormulaLib1: TFormulaLib;
    Table1: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Table1OnOrder: TFloatField;
    Table1Cost: TCurrencyField;
    Table1Description: TStringField;
    Table1ListPrice: TCurrencyField;
    Table1Result: TFloatField;
    FCComboBox: TComboBox;
    Label1: TLabel;
    FC1: TFormulaCompilerD;
    Button1: TBitBtn;
    procedure Table1CalcFields(DataSet: TDataset);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.Table1CalcFields(DataSet: TDataset);
begin
  { Recalc Value using currently assigned formula }
  { Parameters:  %0 = Table1OnOrder.Value         }
  {              %1 = Table1COst.Value            }
  {              %2 = Table1ListPrice.Value       }
  Table1Result.Value := FC1.F([
    Table1OnOrder.Value,
    Table1Cost.Value,
    Table1ListPrice.Value]);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Table1.Open;
  FCComboBox.Text := FC1.Source;
  CurrencyDecimals := 2;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Table1.Close;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  FC1.Source := FCComboBox.Text;
  Table1.Refresh;
end;

end.
