{ *********************************************** }
{                                                 }
{   Formula Compiler ver 4.0                      }
{   Copyright 1996-1999 by Dimak and Vlad S.      }
{   General example of using FC                   }
{                                                 }
{ *********************************************** }
{ You can set your formulas and calculate them    }
{ with given parameters, define user functions    }
{ aliases, use FC events, run small time test     }
{ to compare perfomance of FC and Delphi.         }
{ *********************************************** }

unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, FC, StdCtrls, Grids, ExtCtrls, Buttons,
  ComCtrls;

type
  TMainForm = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    FC1: TFormulaCompilerE;
    FC2: TFormulaCompilerE;
    Lib: TFormulaLib;
    GroupBox1: TGroupBox;
    FunctionLabel: TLabel;
    DelphiLabel: TLabel;
    TimesLabel: TLabel;
    FCLabel: TLabel;
    RatioLabel: TLabel;
    FunctionCombo: TComboBox;
    Label1: TLabel;
    ArgsGrid: TStringGrid;
    Label2: TLabel;
    GroupBox2: TGroupBox;
    ResultLabel: TLabel;
    FC3: TFormulaCompilerE;
    Label3: TLabel;
    Edit1: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    EditBtn: TBitBtn;
    BitBtn1: TBitBtn;
    Button2: TBitBtn;
    Button3: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    function FC3Function(const FuncName: string;
      const X: array of Extended): Extended;
    function FC3Variable(const VarName: String): Extended;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  { Change it if you want }
  TimesToEvaluate = 100000;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

function TestTimeFunc(A: Array of Extended): Extended;
begin
  Result := sin(A[0])*cos(A[0]);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FunctionLabel.Caption := 'Function :    ' + FC2.Source;
  TimesLabel.Caption := 'Evaluate it ' + IntToStr(TimesToEvaluate) + ' times';
  ResultLabel.Caption := 'Was not calculated yet';
  with ArgsGrid do
  begin
    Cells[0, 0] := 'Names';
    Cells[0, 1] := 'X';
    Cells[0, 2] := 'Y';
    Cells[0, 3] := 'Z';
    Cells[1, 0] := 'Values (Please input only numbers)';
    Cells[1, 1] := '1';
    Cells[1, 2] := '2';
    Cells[1, 3] := '3';
  end;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  L: Array [0..2] of Longint;
  E: Extended;
  i: Longint;
begin
  L[0] := GetTickCount;
  for i := 1 to TimesToEvaluate do
    E := TestTimeFunc([1, 2, 3]);
  L[1] := GetTickCount;
  for i := 1 to TimesToEvaluate do
    E := FC2.F([1, 2, 3]);
  L[2] := GetTickCount;
  DelphiLabel.Caption := Format('Delphi time:%10d msec', [L[1] - L[0]]);
  FCLabel.Caption :=     Format('FC     time:%10d msec', [L[2] - L[1]]);
  RatioLabel.Caption :=  Format('Ratio      :%10f', [(L[1] -L[0])/(L[2] - L[1])]);
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  with ArgsGrid do
    try
      { First set formula, pass it to FC }
      FC1.Source := FunctionCombo.Text;
      ResultLabel.Caption := FloatToStr(FC1.F([
        StrToFloat(Cells[1,1]),
        StrToFloat(Cells[1,2]),
        StrToFloat(Cells[1,3])]));
    except
      on EConvertError do begin
        MessageBox(0, 'Checks your arguments, please !',
         'Error', mb_Ok + mb_IconStop);
        ResultLabel.Caption := 'Error in arguments';
      end;
    end;
end;

procedure TMainForm.EditBtnClick(Sender: TObject);
begin
  Lib.Edit(0);
end;

procedure TMainForm.Button3Click(Sender: TObject);
const
  AE: array[0..5] of Extended = (0, 1, 2, 3, 4, 5);
begin
  FC3.Source := Edit1.Text;
  Label5.Caption := FloatToStr(FC3.F(AE));
end;

function TMainForm.FC3Function(const FuncName: string;
  const X: array of Extended): Extended;
var
  i: Integer;
  h: Extended;
begin
  Result := 0;
  if CompareText(FuncName, 'average') = 0 then
  begin
    for i := 0 to High(X) do
      Result := Result + X[i];
    Result := Result / (High(X) + 1);
  end
  else if CompareText(FuncName, 'mid') = 0 then
       begin
          for i := 0 to High(X) do
            Result := Result + X[i]/2;
       end;
end;

function TMainForm.FC3Variable(const VarName: String): Extended;
begin
  Result := 0;
  if CompareText(VarName, 'RandomVar') = 0
    then Result := Random(100);
end;

end.
