unit FramesPropertyWindow;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,RGNexternal,
  StdCtrls, ExtCtrls,dsgnintf;

type
  
  TFramesPropertyEditorForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Panel3: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Label13: TLabel;
    Label14: TLabel;
    PaintBox1: TPaintBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    FLastAction : integer;

    { Private declarations }

  public
    RGNSframes : TIAexternalRGNarray;
    procedure refreshdata;

  end;

var
  FramesPropertyEditorForm: TFramesPropertyEditorForm;

implementation
 uses
 FramesPropertyEditor;
{$R *.DFM}

procedure TFramesPropertyEditorForm.FormCreate(Sender: TObject);
begin
  FLastAction:=0;
  RGNSframes:=TIAexternalRGNarray.Create;
end;

procedure TFramesPropertyEditorForm.FormDestroy(Sender: TObject);
begin
  RGNSframes.Free;
end;
procedure TFramesPropertyEditorForm.refreshdata;
var
  r : Trect;
  DC : HDC;
  Brush : TBrush;
  RGN : HRGN;
begin
  DC:=getdc(panel1.handle);
  Brush:=TBrush.Create;
  Brush.Color:=clRed;
  Brush.Style:=bsSolid;
  RGN:=createRECTRGN(0,0,panel1.width,panel1.height);
  fillrgn(DC,RGN,Brush.handle);
  deleteobject(RGN);

  if RGNSframes.Count<=0 then
    begin
      Label3.Caption:='-';
      Label6.Caption:='-';
      Label8.Caption:='-';
      Label10.Caption:='-';
      Label12.Caption:='-';
      Label14.Caption:='-';
    end else
    begin
      case FLastAction of
        0 : Label3.Caption:='-';
        1 : Label3.Caption:=OpenDialog1.FileName;
        2 : Label3.Caption:=SaveDialog1.FileName;
      end;
      r:=RGNSframes.GetHRGNinfo(0);
      Label6.Caption:=inttostr(r.left);
      Label8.Caption:=inttostr(r.Top);
      Label10.Caption:=inttostr(r.right-r.left);
      Label12.Caption:=inttostr(r.bottom-r.top);
      Label14.Caption:=inttostr(RGNSframes.Count);

      Brush.Color:=clBlack;
      RGN:=RGNSframes.GetHRGNinRect(0,rect(0,0,panel1.width,panel1.height));
      fillrgn(DC,RGN,Brush.handle);
      deleteobject(RGN);
    end;

  Brush.Free;
  releaseDC(panel1.handle,DC);  
end;
procedure TFramesPropertyEditorForm.Button5Click(Sender: TObject);
begin
  RGNSframes.Clear;
  refreshdata;
end;

procedure TFramesPropertyEditorForm.PaintBox1Paint(Sender: TObject);
begin
  refreshdata;
end;

procedure TFramesPropertyEditorForm.Button3Click(Sender: TObject);
begin
  try
    if OpenDialog1.Execute then
      begin
        RGNSframes.ReadFromFile(OpenDialog1.FileName);
        FLastAction:=1;
        refreshdata;
      end;
  except
  end;
end;

procedure TFramesPropertyEditorForm.Button4Click(Sender: TObject);
begin
  if RGNSframes.Count>0 then
    begin
      try
        if Savedialog1.Execute then
          begin
            RGNSframes.WriteToFile(Savedialog1.Filename);
            FLastAction:=2;
            refreshdata;
          end;
      except
      end;
    end;
end;

procedure TFramesPropertyEditorForm.Button1Click(Sender: TObject);
begin
  self.ModalResult:=mrOk;
  self.Hide;
end;

procedure TFramesPropertyEditorForm.Button2Click(Sender: TObject);
begin
  self.Close;
end;

procedure TFramesPropertyEditorForm.FormActivate(Sender: TObject);
begin
  refreshdata;
end;

end.
