unit RGNexternal;

interface
uses
  Windows,classes,SysUtils;
type
TIARGNArray = array of pRGNData;
TIALengthArray = array of integer;

TIAexternalRGNarray = class(Tpersistent)
private
  Items : TIARGNArray;
  ItemsLength : TIALengthArray;
  Filestream : TFileStream;
  FCount : integer;

  procedure deletedata;
  procedure  ReadItems(Reader : TReader);
  procedure WriteItems(Writer : Twriter);
protected
  procedure defineproperties(Filer : TFiler);override;
public



  procedure AddItem(P :pRGNData;L : integer);
  procedure DeleteItem(i : Integer);
  function  Count: integer;
  procedure InsertItem(P :pRGNData;L : integer;i : Integer);
  procedure Clear;
  procedure WriteToFile(FileName : String);
  procedure ReadFromFile(FileName : String);
  procedure AddHRGN(RGN : HRGN);
  procedure InsertHRGN(RGN : HRGN;i : integer);
  function  GetHRGN(i : integer): HRGN;
  function  GetHRGNinRect(i : integer;Rect : TRECT): HRGN;
  function  GetHRGNbyScale(i : integer;kx,ky : single): HRGN;
  function  GetHRGNinfo(i : integer): TRECT;
  procedure AssignArray(Rarray : TIAexternalRGNarray);

  constructor Create; virtual;
  destructor destroy; override;

end;

implementation

constructor TIAexternalRGNarray.Create;
begin
  FCount:=0;
  setlength(items,0);
  setlength(itemslength,0);
end;
destructor TIAexternalRGNarray.destroy;
begin
  deletedata;
  inherited destroy;
end;
procedure TIAexternalRGNarray.deletedata;
  var
    i : integer;
begin
  for i:=0 to length(Items)-1 do
    begin
      freemem(items[i],
      itemslength[i]+
      sizeof(items[i]^));
    end;
  setlength(items,0);
  setlength(itemslength,0);
  FCount:=0;  
end;
function  TIAexternalRGNarray.Count: integer;
begin
  result:=FCount;
end;
procedure TIAexternalRGNarray.AddItem(P :pRGNData;L : integer);
  var
    TempRGN  : TIARGNArray;
    TempL    : TIALengthArray;
    i : integer;
begin
  setlength(TempRgn,length(Items));
  setlength(TempL  ,length(items));
  for i:=0 to length(Items)-1 do
    begin
      TempRgn[i]:=Items[i];
      TempL[i]  :=ItemsLength[i];
    end;
  setlength(ItemsLength,length(items)+1);
  setlength(Items      ,length(items)+1);
  for i:=0 to length(Items)-2 do
    begin
      Items[i]:=TempRgn[i];
      ItemsLength[i]:=TempL[i];
    end;
  Getmem(Items[length(Items)-1],L+sizeof(items[0]^));
  ItemsLength[length(Items)-1]:=L;
  CopyMemory(Items[length(Items)-1],p,L+sizeof(items[0]^));
  inc(FCount);
end;
procedure TIAexternalRGNarray.DeleteItem(i : Integer);
  var
    TempRGN  : TIARGNArray;
    TempL    : TIALengthArray;
    j : integer;
begin
  if i<=(length(items)-1) then
    begin
      setlength(TempRgn,length(items)-1);
      setlength(TempL  ,length(items)-1);
      for j:=0 to i-1 do
        begin
          TempRgn[j]:=Items[j];
          TempL[j]  :=ItemsLength[j];
        end;
      for j:=i+1 to  length(items)-1 do
        begin
          TempRgn[j-1]:=Items[j];
          TempL[j-1]  :=ItemsLength[j];
        end;
      freemem(items[i],itemslength[i]+sizeof(items[i]^));
      setlength(ItemsLength,length(items)-1);
      setlength(Items      ,length(items)-1);
      for j:=0 to length(Items)-1 do
        begin
          Items[j]:=TempRgn[j];
          ItemsLength[j]:=TempL[j];
        end;
      dec(FCount);
    end;
end;
procedure TIAexternalRGNarray.InsertItem(P :pRGNData;L : integer;i : Integer);
var
    TempRGN  : TIARGNArray;
    TempL    : TIALengthArray;
    j : integer;
begin
  if i<=(length(items)-1) then
    begin
      setlength(TempRgn,length(items)+1);
      setlength(TempL  ,length(items)+1);
      for j:=0 to i-1 do
        begin
          TempRgn[j]:=Items[j];
          TempL[j]  :=ItemsLength[j];
        end;
      for j:=i to length(items)-1 do
        begin
          TempRgn[j+1]:=Items[j];
          TempL[j+1]  :=ItemsLength[j];
        end;
      Getmem(TempRgn[i],L+sizeof(TempRgn[i]^));
      TempL[i]:=L;
      CopyMemory(TempRgn[i],p,L+sizeof(TempRgn[i]^));
      setlength(ItemsLength,length(items)+1);
      setlength(Items      ,length(items)+1);
      for j:=0 to length(Items)-1 do
        begin
          Items[j]:=TempRgn[j];
          ItemsLength[j]:=TempL[j];
        end;
      inc(FCount);
    end;
end;
procedure TIAexternalRGNarray.Clear;
begin
  deletedata;
end;
procedure TIAexternalRGNarray.AddHRGN(RGN : HRGN);
  var
    Bufsize : integer;
    RD1 : pRGNDATA;
begin
  BufSize:=getregionData(rgn,0,Nil);
  Getmem(pointer(RD1),BufSize+sizeof(Rd1^));
  getregionData(RGN,BufSize,RD1);
  self.AddItem(RD1,BufSize);
  freemem(pointer(RD1),BufSize+sizeof(Rd1^));
end;
procedure TIAexternalRGNarray.InsertHRGN(RGN : HRGN;i : integer);
  var
    Bufsize : integer;
    RD1 : pRGNDATA;
begin
  BufSize:=getregionData(rgn,0,Nil);
  Getmem(pointer(RD1),BufSize+sizeof(Rd1^));
  getregionData(RGN,BufSize,RD1);
  self.InsertItem(RD1,BufSize,i);
  freemem(pointer(RD1),BufSize+sizeof(Rd1^));
end;
function  TIAexternalRGNarray.GetHRGN(i : integer): HRGN;
var
  myForm : XFORM;

begin
  if (i<=(FCount-1)) and (i>=0) then
    begin
      myFORM.eDx:=0;
      myFORM.eDy:=0;
      myFORM.eM11:=1;
      myform.eM22:=1;
      myform.eM12:=0;
      myform.eM21:=0;
      result:=ExtCreateRegion(@myform,itemslength[i],items[i]^);
    end else
    begin
      result:=NULL;
    end;
end;
function  TIAexternalRGNarray.GetHRGNinRect(i : integer;Rect : TRECT): HRGN;
var
  myRect : pRect;
  myForm : XFORM;
  kx,ky,dx,dy : single;
begin
  if (i<=(FCount-1)) and (i>=0) then
    begin
      myRect:=pRect(integer(items[i])+16);
      if (myrect^.Right-myrect^.Left)<=0 then kx:=1 else kx:=(Rect.Right-Rect.Left)/(myrect^.Right-myrect^.Left);
      if (myrect^.Bottom-myrect^.top)<=0 then ky:=1 else ky:=(Rect.Bottom-Rect.top)/(myrect^.Bottom-myrect^.top);
      dx:=rect.Left-kx*myrect^.Left;
      dy:=rect.Top-ky*myrect^.Top;
      myFORM.eDx:=dx;
      myFORM.eDy:=dy;
      myFORM.eM11:=kx;
      myform.eM22:=ky;
      myform.eM12:=0;
      myform.eM21:=0;
      result:=ExtCreateRegion(@myform,itemslength[i],items[i]^);
    end else
    begin
      result:=NULL;
    end;
end;
function  TIAexternalRGNarray.GetHRGNbyScale(i : integer;kx,ky : single): HRGN;
var
  myForm : XFORM;
begin
  if (i<=(FCount-1)) and (i>=0) then
    begin
      myFORM.eDx:=0;
      myFORM.eDy:=0;
      myFORM.eM11:=kx;
      myform.eM22:=ky;
      myform.eM12:=0;
      myform.eM21:=0;
      result:=ExtCreateRegion(@myform,itemslength[i],items[i]^);
    end else
    begin
      result:=NULL;
    end;
end;
function  TIAexternalRGNarray.GetHRGNinfo(i : integer): TRECT;
var
  myRect : pRect;
begin
  if (i<=(FCount-1)) and (i>=0) then
    begin
      myRect:=pRect(integer(items[i])+16);
      result:=rect(myrect^.Left,myrect^.Top,myrect^.Right,myrect^.Bottom);
    end;
end;
procedure TIAexternalRGNarray.AssignArray(Rarray : TIAexternalRGNarray);
var
  i : integer;
begin
  deletedata;
  for i:=0 to RArray.Count-1 do
    begin
      self.AddItem(RArray.items[i],RArray.itemslength[i]);
    end;
end;
procedure TIAexternalRGNarray.defineproperties(Filer : TFiler);
begin
  Filer.DefineProperty('Items',ReadItems,WriteItems,TRUE);
end;
procedure TIAexternalRGNarray.ReadItems(Reader : TReader);
var
  i,L,C : integer;
  P : pRGNDATA;
begin
  deletedata;
  Reader.ReadListBegin;
    Reader.Read(C,4);
    for i:=0 to C-1 do
      begin
        Reader.Read(L,4);
        getmem(p,sizeof(p^)+L);
        Reader.Read(p^,sizeof(p^)+L);
        AddItem(P,L);
        freemem(p,sizeof(p^)+L);
      end;
  Reader.ReadListEnd;
end;
procedure TIAexternalRGNarray.WriteItems(Writer : TWriter);
var
  i : integer;
begin
  Writer.WriteListBegin;
  Writer.Write(FCount,4);
    for i:=0 to FCount-1 do
      begin
        writer.Write(Itemslength[i],4);
        writer.Write(Items[i]^,Itemslength[i]+sizeof(Items[i]^));
      end;
  writer.WriteListEnd;
end;
procedure TIAexternalRGNarray.WriteToFile(FileName : String);
var
  i : integer;
begin
  try
    Filestream:=TFilestream.Create(FileName,fmCreate);
    //write the count of items
    Filestream.WriteBuffer(FCount,4);
    for i:=0 to FCount-1 do
      begin
        Filestream.WriteBuffer(Itemslength[i],4);
        Filestream.WriteBuffer(Items[i]^,Itemslength[i]+sizeof(Items[i]^));
      end;
    Filestream.Free;
  except

  end;
end;
procedure TIAexternalRGNarray.ReadFromFile(FileName : String);
var
  i,L,C : integer;
  P : pRGNDATA;
begin
  try
    Filestream:=TFilestream.Create(FileName,fmOpenRead);
    deletedata;
    Filestream.ReadBuffer(C,4);
    for i:=0 to C-1 do
      begin
        Filestream.ReadBuffer(L,4);
        getmem(p,sizeof(p^)+L);
        Filestream.ReadBuffer(p^,sizeof(p^)+L);
        AddItem(P,L);
        freemem(p,sizeof(p^)+L);
      end;
    Filestream.Free;
  except

  end;

end;
end.
