unit IAeverRGNAnimate;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,DsgnIntf,extctrls,BackTimer,
  RGNexternal,Math;

type
  TIAFramesMode = (fmNormal,fmFitWindow,fmScale,fmFitbyFirst);
  TIAFramesProcedure = procedure(Frame,BitmapFrame,RGNFrame : integer) of object;

  TIAeverRGNAnimate = class(TComponent)
  private
    { Private declarations }
    FWindowName : String;
    FWindow : TWinControl;

    FImageListName : String;
    FImageListAnimate : TImageList;

    FFrameTime : integer;
    FUseTimer : Boolean;
    FContinuously : Boolean;
    FDesignTest : Boolean;
    FRGNArray : TIAexternalRGNarray;
    FFramesmode : TIAFramesMode;
    FScaleX : single;
    FScaleY : single;
    FRestoreAfterStop : Boolean;

    FTimer : TTimer;
    FBackTimer : TIABackTimer;
    FAnimated : Boolean;
    FramesNumber : integer;
    CurrentFrame : integer;
    FOldRGN : HRGN;
    


    FFramesProcedure : TIAFramesProcedure;

    OldParentWndProc : TFarProc;//Hook variables...
    NewparentWndProc : Pointer;
    FWindowHooked : Boolean;
    FHookedWindow : TWinControl;

    procedure TimerProcedure(Sender: TObject);
    procedure NextFrame;
    procedure PaintFrame;

    procedure HookWndProc(var Message : Tmessage);
    procedure Calldefault(var Message : Tmessage);
    procedure HookWindow;
    procedure UnhookWindow;
  protected
    { Protected declarations }
    procedure SETWindowName(Value : String); virtual;
    procedure SETImageListName(Value : String); virtual;
    procedure SETFrameTime(Value : integer);virtual;
    procedure SETUseTimer(Value : Boolean);virtual;
    procedure SETContinuously(Value : Boolean); virtual;
    procedure SETDesignTest(Value : Boolean);virtual;
    procedure SETRGNArray(Value : TIAexternalRGNarray);virtual;
    procedure SETFramesMode(Value : TIAFramesMode);virtual;
    procedure SETScaleX(Value : single);virtual;
    procedure SETScaleY(Value : single);virtual;
    procedure SETRestoreAfterStop(Value : Boolean);virtual;

  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure StartAnimation;
    procedure BreakAnimation;
    property Window : TWinControl  read FWindow write FWindow;
    property ImageListAnimate : TImageList read FImageListAnimate write FImageListAnimate; 
  published
    { Published declarations }
    property WindowName : string read FWindowName write SETWindowName;
    property ImageListName : String read FImageListName write SETImageListName;
    property FrameTime : integer read FFrameTime write SETFrameTime default 40;
    property UseTimer : Boolean read FUseTimer write SETUseTimer default TRUE;
    property Continuously : Boolean read FContinuously write SETContinuously default False;
    property DesignTest : Boolean read FDesignTest write SETDesignTest default False;
    property RGNArray : TIAexternalRGNarray read FRGNArray write SETRGNArray;
    property FramesMode : TIAFramesMode read FFramesMode write SETFramesMode default fmNormal;
    property ScaleX : single read FScaleX write SETScaleX;
    property ScaleY : single read FScaleY write SETScaleY;
    property RestoreAfterStop : Boolean read FRestoreAfterStop write SETRestoreAfterStop default false; 

    property onFrames : TIAFramesProcedure read FFramesProcedure write FFramesProcedure;
  end;
//-------------------------------------------------------------
  TIAWindowNameEditor = Class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;
  TIAImageListNameEditor = Class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;
//-------------------------------------------------------------
procedure Register;

implementation
uses
FramesPropertyEditor;
constructor TIAeverRGNAnimate.Create(AOwner: TComponent);
begin
  inherited Create(Aowner);
  if AOwner is TWinControl then
    begin
      FWindowName:=(AOwner as TWinControl).name;
      FWindow:=(AOwner as TWinControl);

    end else
    begin
      FWindowname:='';
      FWindow:=nil;
    end;
  FOldRGN:=CreateRectRGN(0,0,0,0);  
  FImageListName:='';
  FImageListAnimate:=nil;
  FAnimated:=False;
  FFrameTime:=40;
  FUseTimer:=TRUE;
  FContinuously:=False;
  FDesignTest:=False;
  FScaleX:=1.0;
  FScaleY:=1.0;

  FRgnArray:=TIAexternalRGNarray.Create;
end;
destructor TIAeverRGNAnimate.Destroy;
begin
  try
    if FAnimated then BreakAnimation;
  except
  end;
  Deleteobject(FOldRGN);
  FRgnArray.Free;
  FWindow:=nil;
  FHookedWindow:=nil;
  FImageListAnimate:=nil;
  inherited Destroy;
end;
procedure TIAeverRGNAnimate.SETWindowName(Value : String);
var
  i : integer;

begin
  if Value <>FWindowName then
    begin
      FWindowName:=Value;
      FWindow:=nil;
      for i:=0 to self.Owner.ComponentCount-1 do
        begin
          if (self.Owner.Components[i].name=value) and (self.Owner.Components[i] is TWinControl)
          then FWindow:=self.Owner.Components[i] as TWinControl;
        end;
      if (self.Owner.Name=Value) and (self.Owner is TWinControl) then FWindow:=(self.Owner as TWinControl);
      //

      //
    end;
end;
procedure TIAeverRGNAnimate.SETImageListName(Value : String);
var
  i : integer;
begin
  if Value<>FImageListName then
    begin
      FImageListName:=Value;
      FImageListAnimate:=nil;
      for i:=0 to self.Owner.ComponentCount-1 do
        begin
          if (self.Owner.Components[i].name=value) and (self.Owner.Components[i] is TImageList)
          then FImageListAnimate:=self.Owner.Components[i] as TImageList;
        end;
    end;
end;
procedure TIAeverRGNAnimate.PaintFrame;
var
  B : TBitmap;
  DC : HDC;
  Fr1,Fr2,Cfr1,Cfr2,PaintFrame : integer;
  FramesNumber1 : integer;
  R1 : TRect;
begin
  try
      if assigned(FImageListAnimate) then Fr1:=FImageListAnimate.Count else Fr1:=0;
      if (FRGNArray.count>0)         then Fr2:=FRGNArray.count else Fr2:=0;
      FramesNumber1:=max(fr1,fr2);
      if FramesNumber1=0 then
        begin
          BreakAnimation;Exit;
        end;
      paintFrame:=CurrentFrame-1;if paintFrame<0 then paintFrame:=FramesNumber1-1;  
      if paintFrame>FramesNumber1-1 then
        begin
          if FContinuously or ((csDesigning in Componentstate) and DesignTest) then
            begin
              paintFrame:=0;
              if Fr1=FramesNumber1 then Cfr1:=paintFrame else if fr1>0
              then Cfr1:=paintFrame mod Fr1 else cfr1:=-1;
              if Fr2=FramesNumber1 then Cfr2:=paintFrame else if fr2>0
              then Cfr2:=paintFrame mod Fr2 else cfr2:=-1;
              if CFR1>=0 then
              begin
                B:=TBitmap.Create;
                FImageListAnimate.GetBitmap(CFR1,B);
                DC:=GetWindowDC(FWindow.handle);
                    case FFramesmode of
                      fmNormal:
                        begin
                          bitblt(DC,0,0,B.Width,B.Height,b.canvas.Handle,0,0,SRCCOPY);
                        end;
                      fmFitWindow:
                        begin
                          StretchBlt(DC,0,0,FWindow.Width,FWindow.Height,b.canvas.Handle,0,0,B.Width,B.Height,SRCCOPY);

                        end;
                      fmScale:
                        begin
                          StretchBlt(DC,0,0,round(B.Width*FScaleX),round(B.Height*FScaleY),
                                    b.canvas.Handle,0,0,B.Width,B.Height,SRCCOPY);

                        end;
                      fmFitbyFirst:
                        begin
                          if CFR2>=0 then
                            begin
                              R1:=FRGNArray.GetHRGNinfo(0);
                              StretchBlt(DC,R1.left,R1.top,R1.right-R1.left,R1.bottom-R1.top,
                                         b.canvas.Handle,0,0,B.Width,B.Height,SRCCOPY);
                            end else
                            begin
                              bitblt(DC,0,0,B.Width,B.Height,b.canvas.Handle,0,0,SRCCOPY);
                            end;
                        end;
                    end;
                releaseDC(FWindow.handle,DC);
                b.free;
              end;
            end else
            begin
              BreakAnimation;
            end;
        end else
        begin
           if Fr1=FramesNumber1 then Cfr1:=paintFrame else if fr1>0
              then Cfr1:=paintFrame mod Fr1 else cfr1:=-1;
              if Fr2=FramesNumber1 then Cfr2:=paintFrame else if fr2>0
              then Cfr2:=paintFrame mod Fr2 else cfr2:=-1;
              if CFR1>=0 then
              begin
                B:=TBitmap.Create;
                FImageListAnimate.GetBitmap(CFR1,B);
                DC:=GetWindowDC(FWindow.handle);

                    case FFramesmode of
                      fmNormal:
                        begin
                          bitblt(DC,0,0,B.Width,B.Height,b.canvas.Handle,0,0,SRCCOPY);
                        end;
                      fmFitWindow:
                        begin
                          StretchBlt(DC,0,0,FWindow.Width,FWindow.Height,b.canvas.Handle,0,0,B.Width,B.Height,SRCCOPY);

                        end;
                      fmScale:
                        begin
                          StretchBlt(DC,0,0,round(B.Width*FScaleX),round(B.Height*FScaleY),
                                    b.canvas.Handle,0,0,B.Width,B.Height,SRCCOPY);

                        end;
                      fmFitbyFirst:
                        begin
                          if CFR2>=0 then
                            begin
                              R1:=FRGNArray.GetHRGNinfo(0);
                              StretchBlt(DC,R1.left,R1.top,R1.right-R1.left,R1.bottom-R1.top,
                                         b.canvas.Handle,0,0,B.Width,B.Height,SRCCOPY);
                            end else
                            begin
                              bitblt(DC,0,0,B.Width,B.Height,b.canvas.Handle,0,0,SRCCOPY);
                            end;
                        end;
                    end;
                releaseDC(FWindow.handle,DC);
                b.free;
              end;
        end;
  except
    BreakAnimation;
  end;        
end;

procedure TIAeverRGNAnimate.NextFrame;
var
  Fr1,Fr2,Cfr1,Cfr2 : integer;
  RGN : HRGN;
  R1 : TRect;
begin
  if assigned(FImageListAnimate) or (FRGNArray.count>0) then
    begin
      if assigned(FImageListAnimate) then Fr1:=FImageListAnimate.Count else Fr1:=0;
      if (FRGNArray.count>0) then Fr2:=FRGNArray.count else Fr2:=0;
      FramesNumber:=max(fr1,fr2);
      if FramesNumber=0 then
        begin
          BreakAnimation;Exit;
        end;
      if CurrentFrame>FramesNumber-1 then
        begin
          if FContinuously or ((csDesigning in Componentstate) and DesignTest) then
            begin
              CurrentFrame:=0;
              if Fr1=FramesNumber then Cfr1:=CurrentFrame else if fr1>0 then Cfr1:=CurrentFrame mod Fr1 else cfr1:=-1;
              if Fr2=FramesNumber then Cfr2:=CurrentFrame else if fr2>0 then Cfr2:=CurrentFrame mod Fr2 else cfr2:=-1;


              if CFR2>=0 then
                begin
                  case FFramesmode of
                    fmNormal:
                      begin
                        RGN:=FRGNArray.getHRGN(CFR2);
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                    fmFitWindow:
                      begin
                        RGN:=FRGNArray.GetHRGNinRect(CFR2,Rect(0,0,FWindow.width,Fwindow.height));
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                    fmScale:
                      begin
                        RGN:=FRGNArray.GetHRGNbyScale(CFR2,FScaleX,FScaleY);
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                    fmFitbyFirst:
                      begin
                        R1:=FRGNArray.GetHRGNinfo(0);
                        RGN:=FRGNArray.GetHRGNinRect(CFR2,R1);
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                  end;
                end;

              inc(CurrentFrame);
              paintframe;
              if assigned(FFramesProcedure) then FFramesProcedure(CurrentFrame,CFR1,CFR2);

            end else
            begin
              BreakAnimation;
            end;
        end else
        begin
          if Fr1=FramesNumber then Cfr1:=CurrentFrame else if fr1>0 then Cfr1:=CurrentFrame mod Fr1 else cfr1:=-1;
          if Fr2=FramesNumber then Cfr2:=CurrentFrame else if fr2>0 then Cfr2:=CurrentFrame mod Fr2 else cfr2:=-1;
          if CFR2>=0 then
                begin
                  case FFramesmode of
                    fmNormal:
                      begin
                        RGN:=FRGNArray.getHRGN(CFR2);
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                    fmFitWindow:
                      begin
                        RGN:=FRGNArray.GetHRGNinRect(CFR2,Rect(0,0,FWindow.width,Fwindow.height));
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                    fmScale:
                      begin
                        RGN:=FRGNArray.GetHRGNbyScale(CFR2,FScaleX,FScaleY);
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                    fmFitbyFirst:
                      begin
                        R1:=FRGNArray.GetHRGNinfo(0);
                        RGN:=FRGNArray.GetHRGNinRect(CFR2,R1);
                        setwindowRGN(FWindow.handle,RGN,True);
                      end;
                  end;    
                end;

          inc(CurrentFrame);     
          paintframe;       
          if assigned(FFramesProcedure) then FFramesProcedure(CurrentFrame,CFR1,CFR2);

        end;
    end else
    begin
      BreakAnimation;
    end;
end;
procedure TIAeverRGNAnimate.TimerProcedure(Sender: TObject);
begin
  NextFrame;
end;
procedure TIAeverRGNAnimate.StartAnimation;
begin
  if assigned(FWindow) and (not FAnimated) then
  begin
  if FWindowHooked then UnhookWindow;
  HookWindow;
  deleteobject(FOldRGN);
  FOLDRGN:=CreateREctRGN(0,0,FWindow.width,FWindow.height);
  GETWindowRGN(FWindow.handle,FOldRGN);
  if UseTimer then
    begin
      CurrentFrame:=0;
      FTimer:=TTimer.Create(self);
      FTimer.Interval:=FrameTime;
      FTimer.OnTimer:=TimerProcedure;
      FAnimated:=true;
      FTimer.Enabled:=True;
    end else
    begin
      CurrentFrame:=0;
      FbackTimer:=TIABackTimer.Create(TRUE);
      FBackTimer.BackProcedure:=NextFrame;
      FBackTimer.backtime:=FrameTime;
      FBackTimer.Resume;
      FAnimated:=true;
    end;

  end;
end;
procedure TIAeverRGNAnimate.BreakAnimation;
begin
  try
  if assigned(Ftimer) then
    begin
      FTimer.Enabled:=False;
      FTimer.free;
      FTimer:=nil;
    end;
  if assigned(FBackTimer) then
    begin
      FBackTimer.Terminate;
      FBackTimer:=nil;
    end;

  FAnimated:=False;  
  if FWindowHooked then UnhookWindow;
  if RestoreafterStop then
    begin
      try
        setWindowrgn(FHookedWindow.handle,FOldRGN,TRUE);
        FHookedWindow.Repaint;
        FOldRGn:=createrectRGN(0,0,0,0);
      except
      end;
    end;
  except
  end;  
end;
procedure TIAeverRGNAnimate.SETFrameTime(Value : integer);
begin
  if (value>0) and (Value<>FFrameTime) then
    begin
      FFrameTime:=Value;
      if FAnimated then
        begin
          BreakAnimation;
          StartAnimation;
        end;
    end;
end;
procedure TIAeverRGNAnimate.SETUseTimer(Value : Boolean);
begin
  if Value<>FUseTimer then
    begin
      FUseTimer:=Value;
      if FAnimated then
        begin
          BreakAnimation;
          StartAnimation;
        end;
    end;
end;
procedure TIAeverRGNAnimate.SETContinuously(Value : Boolean);
begin
  if Value<>FContinuously then
    begin
      FContinuously:=Value;
    end;
end;
procedure TIAeverRGNAnimate.SETDesignTest(Value : Boolean);
var
  R1 : HRGN;
begin
  if (Value<>FDesignTest) and (csDesigning in ComponentState) then
    begin
      FDesignTest:=Value;
      if Value then
        begin
          StartAnimation;
        end else
        begin
          BreakAnimation;
          if assigned(FWindow) then
            begin
              R1:=CreateRectRGN(0,0,FWindow.width,FWindow.height);
              setwindowRGN(FWindow.handle,R1,TRUE);
            end;
        end;
    end;
end;
procedure TIAeverRGNAnimate.SETRGNArray(Value : TIAexternalRGNarray);
begin
  FRGNArray.AssignArray(Value);
end;
procedure TIAeverRGNAnimate.SETFramesMode(Value : TIAFramesMode);
begin
  if Value<>FFramesMode then
    begin
      FFramesMode:=Value;
    end;
end;
procedure TIAeverRGNAnimate.SETScaleX(Value : single);
begin
  if (Value>0) then
    begin
      FScaleX:=Value;
    end;
end;
procedure TIAeverRGNAnimate.SETScaleY(Value : single);
begin
  if (Value>0) then
    begin
      FScaleY:=Value;
    end;
end;
procedure TIAeverRGNAnimate.SETRestoreAfterStop(Value : Boolean);
begin
  if (Value<>FRestoreAfterStop) then
    begin
      FRestoreAfterStop:=Value;
    end;
end;
//+++++++++++++++++++++
procedure TIAeverRGNAnimate.HookWindow;
begin
  if Not Assigned(Fwindow) then exit;
  OldParentWndProc:=TFarProc(GetWindowLong(Fwindow.handle,GWL_WNdProc));
  NewParentWndProc:=MakeObjectInstance(HookWndProc);
  SetWindowLong(Fwindow.handle,GWL_WNdProc,LongInt(NewParentWndProc));
  FWindowHooked:=true;
  FHookedWindow:=Fwindow;
end;
procedure TIAeverRGNAnimate.UnhookWindow;
begin
  try
  if assigned(FHookedWindow) and (((FHookedWindow is TForm) and
     (not(csDestroying in FHookedwindow.ComponentState))) or (FHookedwindow.parent<>nil))
      and assigned(OldParentWndProc) and  (FHookedWindow.handle<>NULL)
  then
    
    SetWindowLong(FHookedWindow.handle,GWL_WNdProc,LongInt(OldParentWndProc));
  if assigned(NewParentWndProc) then FreeObjectInstance(NewParentWndProc);
  NewParentWndProc:=nil;
  OldParentWndProc:=nil;
  except
  end;
  FWindowHooked:=false;
end;
procedure TIAeverRGNAnimate.HookWndProc(var Message : Tmessage);
begin
  if (Message.msg=WM_Paint) then
    begin
          CallDefault(Message);
          PaintFrame;
        Exit;
    end;
   CallDefault(Message);
end;
procedure TIAeverRGNAnimate.CallDefault(var Message : Tmessage);
begin
  if assigned(Fwindow) then
  Message.Result:=
  CallWindowProc(OldParentWndProc,Fwindow.Handle,Message.Msg,Message.wParam,Message.lParam);
end;
//+++++++++++++++++++++
//-----------------------
function TIAWindowNameEditor.GetAttributes: TPropertyAttributes;
begin
  result:=[paValueList,paMultiSelect,paAutoUpdate];
end;
procedure TIAWindowNameEditor.GetValues(Proc: TGetStrProc);
var
  i : integer;
begin
  if ((GetComponent(0) as TIAeverRGNAnimate).owner is TWinControl) then
    proc((GetComponent(0) as TIAeverRGNAnimate).owner.name);
  if ((GetComponent(0) as TIAeverRGNAnimate).owner is TComponent) then
    begin
      for i:=0 to ((GetComponent(0) as TIAeverRGNAnimate).owner as TComponent).ComponentCount-1 do
        begin
          if ((GetComponent(0) as TIAeverRGNAnimate).owner as TComponent).Components[i] is TWinControl then
            begin
              proc((((GetComponent(0) as TIAeverRGNAnimate).owner as TComponent).Components[i] as TWinControl).name);
            end;
        end;
    end;
end;
function TIAImageListNameEditor.GetAttributes: TPropertyAttributes;
begin
  result:=[paValueList,paMultiSelect,paAutoUpdate];
end;
procedure TIAImageListNameEditor.GetValues(Proc: TGetStrProc);
var
  i : integer;
begin
  if ((GetComponent(0) as TIAeverRGNAnimate).owner is TComponent) then
    begin
      for i:=0 to ((GetComponent(0) as TIAeverRGNAnimate).owner as TComponent).ComponentCount-1 do
        begin
          if ((GetComponent(0) as TIAeverRGNAnimate).owner as TComponent).Components[i] is TImageList then
            begin
              proc((((GetComponent(0) as TIAeverRGNAnimate).owner as TComponent).Components[i] as TImageList).name);
            end;
        end;
    end;
end;
//-----------------------
procedure Register;
begin
  RegisterComponents('TIA', [TIAeverRGNAnimate]);
  RegisterPropertyEditor(Typeinfo(string),TIAeverRGNAnimate,'WindowName',TIAWindowNameEditor);
  RegisterPropertyEditor(Typeinfo(string),TIAeverRGNAnimate,'ImageListName',TIAImageListNameEditor);
  RegisterPropertyEditor(Typeinfo(TIAexternalRGNarray),TIAeverRGNAnimate,'RGNArray',TIAFramesEditor);
end;

end.
