unit BackTimer;

interface

uses
  Classes,Windows,Forms;

type
  TBackProcedure = procedure of object;

  TIABackTimer = class(TThread)
  private
    { Private declarations }
    procedure Doit;
  protected
    procedure Execute; override;
  public
    BackProcedure : TBackProcedure;
    BackTime : integer;
  end;

implementation

{ Important: Methods and properties of objects in VCL can only be used in a
  method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TIABackTimer.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TIABackTimer }
procedure TIABackTimer.Doit;
begin
  try
  if assigned(BackProcedure) then BackProcedure;
  except
    self.Terminate;
  end;
end;
procedure TIABackTimer.Execute;
var
 t1 : integer;
begin
  { Place thread code here }
  self.FreeOnTerminate:=true;
  repeat
    t1:=GetTickCount;
    while (((t1+BackTime)>GetTickCount) and (not Terminated)) do begin end;
    if not Terminated then Synchronize(Doit);
  until Terminated;
end;

end.
