
unit EasyReg;

interface
{
--------------------------------------------------------------------------------
            This Component Was Written By Philip Bairstow.
--------------------------------------------------------------------------------

Component Name: TEasyReg
        Author: Philip Bairstow.
            On: 02-September-2000
       Version: 2.0
   Description: Use for Reading Writing to the System Registry
        E-mail: Philip@pbairstow.com
           Url: www.pbairstow.com
           ICQ: 47850165

         Usage: This component is provided 'as is', without any express or
                implied warranty. In no event will the Author be held liable
                for any damages arising from using this component.

                Permission is granted to anyone to use this component for any
                purpose, includeing commercial applications.

                This component may be editted or changed by any developer but
                this header must stay, unchanged.

                You may give a copy of this component to others aslong as all
                origional files are included within the distribution.

                By using this Component you aggree to the following:

                  1) That you have read, and agreed to all the above.

                  2) That you can not sell or exchange any monies for this
                     component, either as it is or any Addaptated component
                     containing this code.

                  3) That all Bugs must be reported to Philip@pbairstow.com


QuickReference:

 Enabled        - Master Enable of Component (True or False);
 CanCreate      - Specifies weather to create the key if it does not exsist;
 CompanyName    - Specifies Your Company Name;
 ProgramName    - Specifies the Name of your Application / Program;
 ProgramVersion - Specifies the Program Versionr;
 Encrypted      - Specifies weather or not strings are encrypted / decrypted (True or False);
 EncryptionKey  - Specifies the Number to xor each Byte of the String With;
 RootKey        - Specifies the Registry Root Key (TRootKey);
 Name           - The Component Name;

 OnCreate       - Is an Event that Occurs when the Component is Created;
 OnActivate     - Is an Event that Occurs when the Component is Activated;
 OnDestroy      - Is an Event that Occurs when the Component is Destroyed;


Procedures and Functions:

 WriteString    - Writes a string to the specified subkey;       (Subkey, Value: String)
 WriteInteger   - Writes a number to the specified subkey;       (Subkey: String; Value: Integer)
 WriteBoolean   - Writes a boolean value to the specified subkey;(Subkey: String; Value: Boolean)
 ReadString     - Reads a string from the specified subkey;      (Subkey: String) Returns String;
 ReadInteger    - Reads a integer from the specified subkey;     (Subkey: String) Returns Integer;
 ReadBoolean    - Reads a boolean value to the specified subkey; (Subkey: String) Returns Boolean;
 CurrentKey     - Gets the currently selected subkey;  Returns a String;
 KeyExsist      - Checks if a Subkey Exsists;   Returns Boolean;
 RunOnce        - Runs a Application Once at Windows Start Up; (ApplicationPath: String;);
 WriteCurrency  - Writes a CurrencyValue to the specified Subkey;(Subkey: String; Value: Currency)
 ReadCurrency   - Reads a Currency Value from the specified Subkey;(Subkey: String) Returns Currency;
 DeleteSubkey   - Deletes the Specified Subkey;(Subkey: String) Returns Boolean;

This Version of Easy Registry was written esspecialy for DouWe who was the only person
to inform me of a Strange Bug.

--------------------------------------------------------------------------------
}

uses
  Messages, SysUtils, Windows,
  Controls, Classes, Registry,
  Graphics;

type
  TRootKey = (bkHKEY_LOCAL_MACHINE, bkHKEY_CLASSES_ROOT, bkHKEY_CURRENT_USER,
              bkHKEY_USERS, bkHKEY_CURRENT_CONFIG);

  TEasyRegException = class(ERegistryException);

  TEasyReg = class(TComponent)
  private
    FReg: TRegistry;
  protected
    FCompany: String;
    FVersion: String;
    FProgName: String;
    FBaseKey: String;
    FOnCreate: TNotifyEvent;
    FOnActivate: TNotifyEvent;
    FOnDestroy: TNotifyEvent;
    FEncryption: Boolean;
    FRootKey: HKEY;
    FRegKey: TRootKey;
    Temp: String;
    FCanCreate: Boolean;
    FEnabled: Boolean;
    FEncryptionKey: Integer;
    function Crypt(s: string; EncryptKey:Integer): string;
    function SetBaseKey(Key: TRootKey): HKEY;
    procedure SetRegKey;
    procedure WMCreate(var Message: TMessage); message WM_CREATE;
    procedure WMActivate(var Message: TMessage); message WM_ACTIVATE;
    procedure WMDestroy(var Message: TMessage); message WM_DESTROY;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure WriteString(Subkey,Value: String);
    function ReadString(Subkey: String): String;
    procedure WriteInteger(Subkey: String; Value: integer);
    function ReadInteger(Subkey: String):Integer;
    procedure WriteBoolean(Subkey: String; Value: Boolean);
    function ReadBoolean(Subkey: String): Boolean;
    procedure WriteCurrency(Subkey: String; Value: Currency);
    function ReadCurrency(Subkey: String): Currency;
    function CurrentKey: String;
    function KeyExist(Subkey: String): Boolean;
    procedure RunOnce(ApplicationPath: String);
    function DeleteSubkey(Subkey: String): Boolean;
  published
    property Enabled:        Boolean        read FEnabled       write FEnabled    default false;
    property RootKey:        TRootKey       read FRegKey        write FRegKey;
    property CompanyName:    String         read FCompany       write FCompany;
    property ProgramVersion: String         read FVersion       write FVersion;
    property ProgramName:    String         read FProgName      write FProgName;
    property Encryption:     Boolean        read FEncryption    write FEncryption default false;
    property EncryptionKey:  Integer        read FEncryptionKey write FEncryptionKey;
    property CanCreate:      Boolean        read FCanCreate     write FCanCreate  default false;
    property OnCreate:       TNotifyEvent   read FOnCreate      write FOnCreate;
    property OnActivate:     TNotifyEvent   read FOnActivate    write FOnActivate;
    property OnDestroy:      TNotifyEvent   read FOnDestroy     write FOnDestroy;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PBSoftware', [TEasyReg]);
end;

constructor TEasyReg.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

destructor TEasyReg.Destroy;
begin
  inherited;
end;

procedure TEasyReg.WMCreate;
begin
  if Assigned(FOnCreate) then FOnCreate(Self);
end;

procedure TEasyReg.WMActivate;
begin
  if Assigned(FOnActivate) then FOnActivate(Self);
end;

procedure TEasyReg.WMDestroy;
begin
  if Assigned(FOnDestroy) then FOnDestroy(Self);
end;

procedure TEasyReg.SetRegKey;
begin
  if Trim(Companyname) = '' then
    raise TEasyRegException.Create('No Company Name') else
  if Trim(ProgramName) = '' then
    raise TEasyRegException.Create('No Program Name') else
  if Trim(ProgramVersion) = '' then
    raise TEasyRegException.Create('No Program Version') else
  FBaseKey := ConCat('Software','\',CompanyName,'\',ProgramName,'\',ProgramVersion,'\');
end;

function TEasyReg.SetBaseKey(Key: TRootKey):HKEY;
begin
  Result := HKEY_CLASSES_ROOT;
  Case Key of

    bkHKEY_CLASSES_ROOT:
        Result := HKEY_CLASSES_ROOT;
    bkHKEY_CURRENT_USER:
        Result := HKEY_CURRENT_USER;
    bkHKEY_LOCAL_MACHINE:
        Result := HKEY_LOCAL_MACHINE;
    bkHKEY_USERS:
        Result := HKEY_USERS;
    bkHKEY_CURRENT_CONFIG:
        Result := HKEY_CURRENT_CONFIG;
   end;
end;

function TEasyReg.Crypt(s: string; EncryptKey:Integer): string;
var
  tmpstr: string;
  x: integer;
  b: byte;
begin
  tmpstr:= '';
  for x:= 1 to length(S) do
  begin
    b:= not (byte(S[x]) xor EncryptKey);
    tmpstr:= tmpstr + char(b);
  end;
  result:= tmpstr;
end;

procedure TEasyReg.RunOnce(ApplicationPath: String);
begin
  if Enabled then
  begin
    FReg := TRegistry.Create;
    try
      FReg.RootKey := HKEY_CURRENT_USER;
      if FReg.OpenKey('\Software\Microsoft\Windows\CurrentVersion\RunOnce', True)
        then FReg.WriteString(ApplicationPath,'"' + ParamStr(0) + '"');
    finally
      FReg.CloseKey;
      FReg.Free;
    end;
  end;
end;

function TEasyReg.CurrentKey:String;
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.RootKey := FRootKey;
        FReg.CreateKey(FBaseKey);
        Result := FReg.CurrentPath;
      finally
        FReg.CloseKey;
        FReg.Free;
        end
    except
       On E:ERegistryException do Raise;
     end;
  end
     else
       raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

function TEasyReg.DeleteSubkey(Subkey: String): Boolean;
begin
  if KeyExist(Subkey) and Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.RootKey := FRootKey;
        FReg.CreateKey(FBaseKey);
        Result := FReg.CreateKey(Subkey);
      finally
        FReg.CloseKey;
        FReg.Free;
        end
    except
       On E:ERegistryException do Raise;
     end;
  end
     else
       raise TEasyRegException.Create('Either Component is not Enabled or Key Does not Exsist');
end;


function TEasyReg.KeyExist(Subkey: String): Boolean;
begin
  if Enabled then
  begin
    Result := True;  //initalise the Result
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.RootKey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, False) then  // we don't want to create the key if it doesn't exsist
          Temp := FReg.ReadString(Subkey);
        if Length(Temp) = 0 then Result := False; // if var is empty then the key does not exsist
      finally
        FReg.CloseKey;
        FReg.Free;
       end
    except
       On E:ERegistryException do Raise;
     end;
  end
     else
        raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

procedure TEasyReg.WriteString(Subkey, Value: String);
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    if FEncryption then Temp := Crypt(Value, FEncryptionKey) else
      Temp := Value;
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.RootKey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate)then
          FReg.WriteString(Subkey, Temp);
      finally
        FReg.CloseKey;
        FReg.Free;
       end

    except
      On E:ERegistryException do Raise;
     end;
  end
     else
         raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

function TEasyReg.ReadString(Subkey: String): String;
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.Rootkey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate) then
          Temp := FReg.ReadString(Subkey);
        if FEncryption then
          Result := Crypt(Temp, EncryptionKey)else
            Result := Temp;
      finally
        FReg.CloseKey;
        FReg.Free;
       end;

    except
      On E:ERegistryException do Raise;
     end;
  end
    else
        raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

procedure TEasyReg.WriteInteger(Subkey: String; Value: Integer);
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.Rootkey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate) then
          FReg.WriteInteger(Subkey, Value);
      finally
        FReg.CloseKey;
        FReg.Free;
       end;
    except
      On E:ERegistryException do Raise;
     end;
  end
     else
         raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

function TEasyReg.ReadInteger(SubKey: String): Integer;
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.Rootkey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate) then
          Result := FReg.ReadInteger(Subkey);
      finally
        FReg.CloseKey;
        FReg.Free;
      end;

    except
      On E:ERegistryException do Raise;
     end;
  end
    else
       raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

procedure TEasyReg.WriteBoolean(SubKey: String; Value: Boolean);
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.Rootkey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate) then
          FReg.WriteBool(Subkey, Value);
      finally
        FReg.CloseKey;
        FReg.Free;
       end;
    except
      On E:ERegistryException do Raise;
     end;
  end
     else
        raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

function TEasyReg.ReadBoolean(Subkey: String): Boolean;
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.Rootkey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate) then
          Result := FReg.ReadBool(Subkey);
      finally
        FReg.CloseKey;
        FReg.Free;
       end;
    except
      On E:ERegistryException do Raise;
     end;
  end
    else
        raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

procedure TEasyReg.WriteCurrency(Subkey: String; Value: Currency);
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.Rootkey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate) then
          FReg.WriteCurrency(Subkey, Value);
      finally
        FReg.CloseKey;
        FReg.Free;
       end;
    except
      On E:ERegistryException do Raise;
     end;
  end
     else
         raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;

function TEasyReg.ReadCurrency(SubKey: String): Currency;
begin
  if Enabled then
  begin
    FRootKey := SetBaseKey(FRegKey);
    SetRegKey;
    try
      FReg := TRegistry.Create;
      try
        FReg.Rootkey := FRootKey;
        FReg.CreateKey(FBaseKey);
        if FReg.OpenKey(FBaseKey, FCanCreate) then
          Result := FReg.ReadCurrency(Subkey);
      finally
        FReg.CloseKey;
        FReg.Free;
      end;

    except
      On E:ERegistryException do Raise;
     end;
  end
    else
       raise TEasyRegException.Create('Component must be Enabled to use this feature');
end;




end.
