unit Unit1;

interface

uses
  SysUtils, Graphics, Buttons, Forms, Spin, ExtCtrls, StdCtrls, Classes, Controls, uRotSprt;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    ScrollBox1: TScrollBox;
    Image: TImage;
    Panel2: TPanel;
    FPURadioButton: TRadioButton;
    MMXRadioButton: TRadioButton;
    RadioGroup1: TRadioGroup;
    Label1: TLabel;
    Panel3: TPanel;
    OpenSpeedButton: TSpeedButton;
    Label2: TLabel;
    AngleEdit: TSpinEdit;
    RotateXSpinEdit: TSpinEdit;
    RotateYSpinEdit: TSpinEdit;
    SpriteSpeedButton: TSpeedButton;
    Label3: TLabel;
    StartXSpinEdit: TSpinEdit;
    StartYSpinEdit: TSpinEdit;
    TranspColorSpinEdit: TSpinEdit;
    Label4: TLabel;
    Label5: TLabel;
    RotateTicksLabel: TLabel;
    SpriteTicksLabel: TLabel;
    procedure OpenSpeedButtonClick(Sender: TObject);
    procedure AngleEditChange(Sender: TObject);
    procedure SpriteSpeedButtonClick(Sender: TObject);
    procedure ImageMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  public
    SrcBitmap: array of Byte;
    SpriteBitmap: array of Byte;
    SpriteWidth: Integer;
    SpriteHeight: Integer;
    procedure RotateMMX(Angle: Integer; SrcBitmap, DestBitmap: Pointer;
                        Width, Height, RotX, RotY: Integer);
    procedure RotateFPU(Angle: Integer; var SrcBitmap, DestBitmap: array of Byte;
                        Width, Height, RotX, RotY: Integer);
    procedure PlaceSpriteMMX(Picture, Sprite: Pointer; BackgroundColor: Integer;
      PictureWidth, PictureHeight, SpriteWidth, SpriteHeight,
      StartX, StartY: Integer);
    procedure PlaceSpriteFPU(var PictureBitmap, SpriteBitmap: array of Byte; BackgroundColor: Integer;
      PictureWidth, PictureHeight, SpriteWidth, SpriteHeight, StartX, StartY: Integer);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

function GetCounter: Longint; assembler;
asm
  DB    0Fh, 031h  // RDTSC     EDX:EAX <- ticks counter
end;

procedure TMainForm.RotateMMX(Angle: Integer; SrcBitmap, DestBitmap: Pointer;
                    Width, Height, RotX, RotY: Integer);
var
  Matrix: array [1..2, 1..2] of SmallInt;
  TicksCount: Extended;
begin
  Matrix[1, 1] := Round(Cos(Angle * PI / 180) * 16384);
  Matrix[2, 1] := Round(Sin(Angle * PI / 180) * 16384);
  Matrix[1, 2] := - Matrix[2, 1];
  Matrix[2, 2] := Matrix[1, 1];
  TicksCount := GetCounter;
  Rotate(@Matrix, SrcBitmap, DestBitmap, Width, Height, RotX, RotY);
  TicksCount := GetCounter - TicksCount;
  RotateTicksLabel.Caption := Format('%.0n', [TicksCount]);
end;

procedure TMainForm.RotateFPU(Angle: Integer; var SrcBitmap, DestBitmap: array of Byte;
                    Width, Height, RotX, RotY: Integer);
var
  Matr: array [1..2, 1..2] of Double;
  W, H, X, Y: Integer;
  TicksCount: Extended;
begin
  Matr[2, 2] := Cos(Angle * PI / 180);
  Matr[1, 2] := Sin(Angle * PI / 180);
  Matr[2, 1] := - Matr[1, 2];
  Matr[1, 1] := Matr[2, 2];
  TicksCount := GetCounter;
  for H := 0 to Height - 1 do
    for W := 0 to Width - 1 do
    begin
      X := Round(Matr[1, 1] * (W-RotX) + Matr[1, 2] * (H-RotY)) + RotX;
      Y := Round(Matr[2, 1] * (W-RotX) + Matr[2, 2] * (H-RotY)) + RotY;
      if (X < 0) or (X >= Width) then Continue;
      if (Y < 0) or (Y >= Height) then Continue;
      DestBitmap[Y * Width + X] :=
        SrcBitmap[H * Width + W];
      // To the beautiful rotate (no blank spaces)
      if (W = Width - 1) or
         (X = Width - 1) then Continue;
      if Matr[1, 1] < 0 then
        DestBitmap[Y * Width + X-1] :=
          SrcBitmap[H * Width + W+1]
      else
        DestBitmap[Y * Width + X+1] :=
          SrcBitmap[H * Width + W+1];
    end;
  TicksCount := GetCounter - TicksCount;
  RotateTicksLabel.Caption := Format('%.0n', [TicksCount]);
end;

procedure TMainForm.PlaceSpriteMMX(Picture, Sprite: Pointer; BackgroundColor: Integer;
  PictureWidth, PictureHeight, SpriteWidth, SpriteHeight,
  StartX, StartY: Integer);
var
  TicksCount: Extended;
begin
  TicksCount := GetCounter;
  PlaceSprite(Picture, Sprite, BackgroundColor,
    PictureWidth, PictureHeight, SpriteWidth, SpriteHeight,
    StartX, StartY);
  TicksCount := GetCounter - TicksCount;
  SpriteTicksLabel.Caption := Format('%.0n', [TicksCount]);
end;

procedure TMainForm.PlaceSpriteFPU(var PictureBitmap, SpriteBitmap: array of Byte; BackgroundColor: Integer;
  PictureWidth, PictureHeight, SpriteWidth, SpriteHeight, StartX, StartY: Integer);
var
  LastX, LastY: Integer;
  PictIndex, SprtIndex: Integer; // Count of bytes to current line
  PInd, SInd: Integer; // Count of bytes in current line to current column
  TicksCount: Extended;
begin
  TicksCount := GetCounter;
  PictIndex := 0;
  SprtIndex := 0;
  // Make equally first lines of image and sprite
  if StartY >= 0 then
  begin
    PictureHeight := PictureHeight - StartY;
    PictIndex := PictureWidth * StartY;
  end
  else
  begin
    SpriteHeight := SpriteHeight - StartY;
    SprtIndex := SpriteWidth * StartY;
  end;
  // Set LastY - the last line of draw sprite
  if SpriteHeight < PictureHeight then
    LastY := SpriteHeight
  else
    LastY := PictureHeight;
  // Set LastX - the last column of draw sprite
  if SpriteWidth < PictureWidth then
    LastX := SpriteWidth
  else
    LastX := PictureWidth;
  // if StartX < 0 then correct LastX coordinate
  if StartX < 0 then
    LastX := LastX + StartX;
  repeat
    // Set start pointers [ESI+EBP] and [EDI+EBX]
    if StartX >= 0 then
    begin
      PInd := StartX;
      SInd := 0;
    end
    else
    begin
      SInd := - StartX;
      PInd := 0;
    end;
    repeat
      if SpriteBitmap[SprtIndex + SInd] <> BackgroundColor then
        PictureBitmap[PictIndex + PInd] := SpriteBitmap[SprtIndex + SInd];
      Inc(PInd);
      Inc(SInd);
    until PInd = LastX;
    PictIndex := PictIndex + PictureWidth;
    SprtIndex := SprtIndex + SpriteWidth;
    Dec(LastY);
  until LastY = 0;
  TicksCount := GetCounter - TicksCount;
  SpriteTicksLabel.Caption := Format('%.0n', [TicksCount]);
end;

procedure TMainForm.OpenSpeedButtonClick(Sender: TObject);
var
  I: Integer;
begin
  Image.Picture.Bitmap.LoadFromFile('Pic.BMP');
  Image.Picture.Bitmap.PixelFormat := pf8bit;
  with Image.Picture.Bitmap do
  begin
    SetLength(SrcBitmap, Width * Height);
    for I := 0 to Height - 1 do
      Move(ScanLine[I]^, SrcBitmap[I * Width], Width);
    RotateXSpinEdit.Value := Width div 2;
    RotateYSpinEdit.Value := Height div 2;
  end;
  AngleEditChange(nil);
end;

procedure TMainForm.SpriteSpeedButtonClick(Sender: TObject);
var
  I: Integer;
begin
  with TBitmap.Create do
  try
    LoadFromFile('Spr.BMP');
    PixelFormat := pf8bit;
    SetLength(SpriteBitmap, Width * Height);
    for I := 0 to Height - 1 do
      Move(ScanLine[I]^, SpriteBitmap[I * Width], Width);
    SpriteWidth := Width;
    SpriteHeight := Height;
  finally
    Free;
  end;
  AngleEditChange(nil);
end;

procedure TMainForm.AngleEditChange(Sender: TObject);
var
  I: Integer;
  DestBitmap: array of Byte;
  SprBitmap: array of Byte;
begin
  SetLength(DestBitmap, Length(SrcBitmap));
  Move(SrcBitmap[0], DestBitmap[0], Length(SrcBitmap));
  if Length(SpriteBitmap) <> 0 then
  begin
    SetLength(SprBitmap, Length(SpriteBitmap));
    FillChar(SprBitmap[0], Length(SprBitmap), 0);
    if MMXRadioButton.Checked then
      RotateMMX(AngleEdit.Value, @SpriteBitmap[0], @SprBitmap[0],
        SpriteWidth, SpriteHeight,
        RotateXSpinEdit.Value, RotateYSpinEdit.Value)
    else
      RotateFPU(AngleEdit.Value, SpriteBitmap, SprBitmap,
        SpriteWidth, SpriteHeight,
        RotateXSpinEdit.Value, RotateYSpinEdit.Value);
    // Place sprite on image
    if MMXRadioButton.Checked then
      PlaceSpriteMMX(@DestBitmap[0], @SprBitmap[0], TranspColorSpinEdit.Value,
        Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height, SpriteWidth, SpriteHeight,
        StartXSpinEdit.Value, StartYSpinEdit.Value)
    else
      PlaceSpriteFPU(DestBitmap, SprBitmap, TranspColorSpinEdit.Value,
        Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height, SpriteWidth, SpriteHeight,
        StartXSpinEdit.Value, StartYSpinEdit.Value);
  end;
  // Set result to Image.Picture.Bitmap
  with Image.Picture.Bitmap do
    for I := 0 to Height - 1 do
      Move(DestBitmap[I * Width], ScanLine[I]^, Width);
  Image.Invalidate;
end;

(*
procedure TForm1.AngleEditChange(Sender: TObject);
var
  I: Integer;
  DestBitmap: array of Byte;
begin
  with Image.Picture.Bitmap do
  begin
    SetLength(DestBitmap, Width * Height);
    FillChar(DestBitmap[0], Width * Height, 0);
  end;
  if MMXRadioButton.Checked then
    RotateMMX(AngleEdit.Value, @SrcBitmap[0], @DestBitmap[0],
      Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height,
      RotateXSpinEdit.Value, RotateYSpinEdit.Value)
  else
    RotateFPU(AngleEdit.Value, SrcBitmap, DestBitmap,
      Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height,
      RotateXSpinEdit.Value, RotateYSpinEdit.Value);
  // Place sprite on image
  if Length(SpriteBitmap) <> 0 then
    if MMXRadioButton.Checked then
      PlaceSprite(@DestBitmap[0], @SpriteBitmap[0], 0{SpriteBitmap[33*SpriteWidth + 150]},
        Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height, SpriteWidth, SpriteHeight,
        0, 0)
    else
      PlaceSpriteFPU(DestBitmap, SpriteBitmap, 0,
        Image.Picture.Bitmap.Width, Image.Picture.Bitmap.Height, SpriteWidth, SpriteHeight,
        0, 0);
  // Set result to Image.Picture.Bitmap
  with Image.Picture.Bitmap do
    for I := 0 to Height - 1 do
      Move(DestBitmap[I * Width], ScanLine[I]^, Width);
  Image.Invalidate;
end;
*)
procedure TMainForm.ImageMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Line: array of Byte;
begin
  SetLength(Line, Image.Picture.Bitmap.Width);
  Move(Image.Picture.Bitmap.ScanLine[Y]^, Line[0], Image.Picture.Bitmap.Width);
  TranspColorSpinEdit.Value := Line[X];
end;

end.
