unit testneu;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, TbrNeura;

type
  Ttestforn = class(TForm)
    tneural1: tneural;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Edit2: TEdit;
    Button6: TButton;
    Edit3: TEdit;
    Button4: TButton;
    Button5: TButton;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit6: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);

    procedure tneural1Expected(Sender: TObject; index: Integer;
      var value: Integer);
    procedure tneural1Input(Sender: TObject; index: Integer;
      var value: Integer);
    procedure Button3Click(Sender: TObject);
    procedure tneural1Result(Sender: TObject; index: Integer;
      var value: Integer);
    procedure Button6Click(Sender: TObject);
    procedure tneural1Status1(Sender: TObject; correct: Integer);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  end;

var
  testforn: Ttestforn;
implementation



var
gem : array [1..2] of boolean;
g : array [1..2] of boolean;
max_pct : integer;
tal : array [1..40,1..4] of integer;
rk : integer;

{$R *.DFM}


procedure Ttestforn.FormCreate(Sender: TObject);
var
  i,i2 : integer;
begin

 randomize;
 with tneural1 do
 begin;
   hiddenlayers :=3;    // in this demo there vill be 4 layers hiddenlayer + 2
                        // layer 1 is always input layer
                        // layer number hiddenlayers + 2 is output layer
   nodes [1] := 4;      // input layer nodes
   nodes [2] := 9;      // hidden nodes
   nodes [3] := 7;      // hidden nodes
   nodes [4] := 7;      // hidden nodes
   nodes [5] := 4;      // output layer nodes

   for i := 1 to nodes [1] do     // number of input neuroner
   begin;
      // you have to specify what the value of
      // the input nodes can have
      inputnodeMinMax(i,1,5);  // nodeidx, min, max
   end;
   for i := 1 to nodes [hiddenlayers+2] do     // number of output neuroner
   begin;
      // you have to specify what the value of
      // the output nodes should become
      outputnodeMinMax(i,1,5);  // nodeidx, min, max
   end;

   // Faktor1 and faktor2 is used in the training and is a way off
   // telling the net how much it should change the nodes when backtracing
   // shiftfaktorAt says after how many trainingruns the faktor2 is to be used
   // Stopprocent is at what percent the trainng should stop
   // there is a read only procent which tells the current percent

   makenet;  // this is constructing the net

 end;

 for i := 1 to 20 do   // this is just for creating some random test data
 begin;
    for i2 := 1 to 4
    do
      tal[i,i2] := random(5) +1;
 end;

end;

procedure Ttestforn.Button1Click(Sender: TObject);
begin
    // show the net

    tneural1.visnet(self.canvas,bounds(24,10,300,100));
end;

procedure Ttestforn.Button2Click(Sender: TObject);
begin
    // start the training of the net
    // and here i just change at what succes pct the
    // training should stop

    edit1.text := '';
    edit2.text := '';
    edit3.text := '';

    max_pct := 0;
    tneural1.stopprocent := 92 ;
    tneural1.train_net;


end;


procedure Ttestforn.tneural1Expected(Sender: TObject; index: Integer;
  var value: Integer);
begin
  // theis event has to return what the value should be for each output node
  // the event is called for each output node each time the input is changed

  // give what would be the correct result for this node
  value := tal[rk + 1,index];

end;

procedure Ttestforn.tneural1Input(Sender: TObject; index: Integer;
  var value: Integer);
begin
  // this event has to return what the value is for each input node

  // in this demo i will return a new row
  // everytime i am asked to return the first node

  if index = 1 then rk := rk +1;
  if rk > 19 then rk := 1;   // round robin

  // give the input value for each node
  value := tal[rk,index];
end;

procedure Ttestforn.Button3Click(Sender: TObject);
begin
    // manual stop the trainning of the net

    tneural1.stop_net;

end;

procedure Ttestforn.tneural1Result(Sender: TObject; index: Integer;
  var value: Integer);
var
  s : shortstring;
begin

    // this event is executed when the neural net has been run

    with sender as tNeural do
    begin;
        Button1Click(Sender); // show the net

        str(value,s); // what is the result value of this node
        edit4.text := edit4.text+ ' '+ s;

        tneural1Expected(self,index,value); // what was expected
        str(value,s);

            // what was expected could also have been calculated
            // from tal[rk + 1,index]; as rk was the input

        edit5.text := edit5.text+ ' '+ s;

    end;
end;

procedure Ttestforn.Button6Click(Sender: TObject);
begin
    edit4.text := '';
    edit5.text := '';

    rk := random(10);
    tneural1.Run_net;
end;

procedure Ttestforn.tneural1Status1(Sender: TObject; correct: Integer);

var
   s : shortstring;
begin
   // this event is called for each training run

   with sender as tneural do
   begin;
      if procent > max_pct   // percent of correct runs
      then
        begin;
         max_pct := procent;
         str(max_pct,s);
         edit2.text := s;
        end;

      str(procent,s);  // how good is the net
      edit1.text := s;
      str(correct,s);  // how many output nodes were correct
      edit3.text := s;
      if s > edit6.text
      then
         begin;
            edit6.text := s;
            Button1Click(Sender); // show the net
         end;

   end;

end;

procedure Ttestforn.Button4Click(Sender: TObject);
begin
    // save the net with then name of the property netname

    tneural1.savenet;
end;

procedure Ttestforn.Button5Click(Sender: TObject);
begin
    tneural1.getnet;
end;

end.
