unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, shellapi, mp3reader,
  StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    TrackBar1: TTrackBar;
    OpenDialog1: TOpenDialog;
    PaintBox1: TPaintBox;
    id3memo: TMemo;
    infomemo: TMemo;
    durationlabel: TLabel;
    poslabel: TLabel;
    wavesb: TSpeedButton;
    specsb: TSpeedButton;
    Timer1: TTimer;
    function FormatToMMMSS(seconds:integer):string;
    procedure FormCreate(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure MP3Progress(sec, msec: Integer);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  mp3:TMP3reader;

implementation

{$R *.DFM}

function TForm1.FormatToMMMSS(seconds:integer):string;
var b:byte;
begin
   result:=inttostr(seconds div 60)+':';
   b:=seconds mod 60;
   if b > 9 then result:=result+inttostr(b)
   else result:=result+'0'+inttostr(b);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
   mp3:=Tmp3reader.create(self);
   mp3.OnProgress:=mp3progress;
   mp3.OnProgressInterval:=100;
   mp3.WaveFmtBufBytesPerChannel:=300;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin

   if not opendialog1.Execute then exit;

   mp3.stop;
   if not mp3.OpenMP3File(opendialog1.filename) then exit;

   trackbar1.Max:=mp3.headerinfo.duration;
   trackbar1.position:=0;

   durationlabel.caption:=FormattoMMMSS(mp3.headerinfo.duration);

   with infomemo.Lines do
      begin
         Clear;
         add(mp3.HeaderInfo.MPEGVersionString);
         add(mp3.HeaderInfo.LayerVersionString);
         add('Bitrate: '+mp3.HeaderInfo.BitrateString);
         add('Samplerate: '+mp3.HeaderInfo.SampleRateString);
         add(mp3.HeaderInfo.ChannelModeString);
      end;

   if not mp3.HasValidID3 then exit;
   with id3memo.Lines,mp3.ID3Info do
      begin
         Clear;
         add('Title: '+title);
         add('Artist: '+artist);
         add('Album: '+album);
         add('Year: '+year);
         add('Genre: '+id3genre[genre]);
      end;

end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   mp3.play;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   mp3.pause;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   mp3.stop;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
   mp3.position:=trackbar1.position;
end;

procedure TForm1.MP3Progress(sec, msec: Integer);
begin
   poslabel.Caption:=FormattoMMMSS(sec);
   trackbar1.position:=sec;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var lv,i:integer;
   a:byte;
   size:integer;
   m:string;

begin


if specsb.down then
   begin
      mp3.getfftbuf;
      with paintbox1.canvas do
         begin
            brush.color:=form1.canvas.brush.color;
            brush.style:=bssolid;
            FillRect(paintbox1.ClientRect);
            brush.style:=bsclear;
            moveto(10,300);
            for lv:= 1 to 512 do
               begin
                  moveto(10+lv*3,300);
                  lineto(10+lv*3,300-mp3.fftbuf[lv]);
                  if (lv mod 20 = 0) or (lv = 1) then
                     begin
                        m:=inttostr(mp3.HeaderInfo.Samplerate*lv div NumFFTSamples)+' Hz';
                        textout(10+lv*3-canvas.textwidth(m) div 2,320,m);
                        moveto(10+lv*3,310);
                        lineto(10+lv*3,320);
                     end;
               end;
         end;
   end
else
   begin
      size:=mp3.WaveFmtBufBytesPerChannel;
      mp3.GetWaveBuf;
      with paintbox1.canvas do
         begin
            brush.color:=form1.canvas.brush.color;
            brush.style:=bssolid;
            FillRect(paintbox1.ClientRect);
            brush.style:=bsclear;
            a:=mp3.wavebuf[0];
            moveto(0,a);
            for lv:= 0 to size-1 do
               begin
                  a:=mp3.wavebuf[lv];
                  lineto(lv,a);
               end;
            a:=mp3.wavebuf[size];
            moveto(0,a+256);
            for lv:= 0 to size-1 do
               begin
                  a:=mp3.wavebuf[size+lv];
                  lineto(lv,a+256);
               end;
         end;
   end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 timer1.enabled:=false;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
   mp3.WaveFmtBufBytesPerChannel:=form1.width;

end;

end.
