{
	TESTDDE
  Vincent LESAUVAGE
  vincentl@club-internet.fr
  http://www.lesauvage.com
  Cration : 15 juillet 1997
  Mise  jour : 14 juin 1998
}

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, DDE;

type
  TForm1 = class(TForm)
    butPasteConv: TButton;
    butOpenConv: TButton;
    butCloseConv: TButton;
    butPasteItem: TButton;
    butRequest: TButton;
    butAdvise: TButton;
    butUnadvise: TButton;
    butExecute: TButton;

    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;

    ediService: TEdit;
    ediTopic: TEdit;
    ediItem: TEdit;
    ediCommand: TEdit;
    rdbConv1: TRadioButton;
    rdbConv2: TRadioButton;
    lsbAction: TListBox;
    
    DDEManager: TDDEManager;
    DDEClient1: TDDEClient;
    DDEClient2: TDDEClient;
    butPoke: TButton;

    procedure butPasteConvClick(Sender: TObject);
    procedure butPasteItemClick(Sender: TObject);
    procedure butOpenConvClick(Sender: TObject);
    procedure butCloseConvClick(Sender: TObject);
    procedure butRequestClick(Sender: TObject);
    procedure butAdviseClick(Sender: TObject);
    procedure butUnadviseClick(Sender: TObject);
    procedure butExecuteClick(Sender: TObject);

    procedure DDEClient2DataChange(DDEClient: TDDEClient; Item: String; const Value: PChar;
    	ValueSize: Integer);
    procedure DDEClient1DataChange(DDEClient: TDDEClient; Item: String; const Value: PChar;
    	ValueSize: Integer);
    procedure butPokeClick(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.butPasteConvClick(Sender: TObject);
var
	S, T, I: string;
begin
	DDEManager.PasteLink(S, T, I);
  ediService.Text := S;
  ediTopic.Text := T;
end;

procedure TForm1.butPasteItemClick(Sender: TObject);
var
	S, T, I: string;
begin
	DDEManager.PasteLink(S, T, I);
  ediItem.Text := I;
end;

procedure TForm1.butOpenConvClick(Sender: TObject);
begin
	try
    if rdbConv1.Checked then
    begin
      DDEClient1.Service := ediService.Text;
      DDEClient1.Topic := ediTopic.Text;
      if DDEClient1.OpenConversation then
        lsbAction.ItemIndex := lsbAction.Items.Add('OPEN #1');
    end
    else
    begin
      DDEClient2.Service := ediService.Text;
      DDEClient2.Topic := ediTopic.Text;
      if DDEClient2.OpenConversation then
        lsbAction.ItemIndex := lsbAction.Items.Add('OPEN #2');
    end;
  except
  	lsbAction.ItemIndex := lsbAction.Items.Add('ERROR : OPEN');
  end;
end;

procedure TForm1.butCloseConvClick(Sender: TObject);
begin
	try
    if rdbConv1.Checked then
    begin
      if DDEClient1.CloseConversation then
        lsbAction.ItemIndex := lsbAction.Items.Add('CLOSE #1');
    end
    else
    begin
      if DDEClient2.CloseConversation then
        lsbAction.ItemIndex := lsbAction.Items.Add('CLOSE #2');
    end;
  except
  	lsbAction.ItemIndex := lsbAction.Items.Add('ERROR : CLOSE');
  end;
end;

procedure TForm1.butRequestClick(Sender: TObject);
var
	DataSize: Integer;
  Buffer: PChar;
begin
	try
    if rdbConv1.Checked then
    begin
      Buffer := DDEClient1.RequestData(ediItem.Text, DataSize);
      lsbAction.ItemIndex := lsbAction.Items.Add('#1 : REQUEST ' + ediItem.Text + ' : ' + Buffer);
      StrDispose(Buffer);
    end
    else
    begin
      Buffer := DDEClient2.RequestData(ediItem.Text, DataSize);
      lsbAction.ItemIndex := lsbAction.Items.Add('#2 : REQUEST ' + ediItem.Text + ' : ' + Buffer);
      StrDispose(Buffer);
    end
  except
  	lsbAction.ItemIndex := lsbAction.Items.Add('ERROR : REQUEST');
  end;
end;

procedure TForm1.butAdviseClick(Sender: TObject);
begin
	try
    if rdbConv1.Checked then
    begin
      if DDEClient1.AdviseData(ediItem.Text) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#1 : ADVISE ' + ediItem.Text);
    end
    else
    begin
      if DDEClient2.AdviseData(ediItem.Text) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#2 : ADVISE ' + ediItem.Text);
    end
  except
  	lsbAction.ItemIndex := lsbAction.Items.Add('ERROR : ADVISE');
  end;
end;

procedure TForm1.butUnadviseClick(Sender: TObject);
begin
	try
    if rdbConv1.Checked then
    begin
      if DDEClient1.UnadviseData(ediItem.Text) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#1 : UNADVISE ' + ediItem.Text);
    end
    else
    begin
      if DDEClient2.UnadviseData(ediItem.Text) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#2 : UNADVISE ' + ediItem.Text);
    end
  except
  	lsbAction.ItemIndex := lsbAction.Items.Add('ERROR : UNADVISE');
  end;
end;

procedure TForm1.butExecuteClick(Sender: TObject);
begin
	try
    if rdbConv1.Checked then
    begin
      if DDEClient1.Execute(ediItem.Text, ediCommand.Text) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#1 : EXECUTE ' + ediItem.Text);
    end
    else
    begin
      if DDEClient2.Execute(ediItem.Text, ediCommand.Text) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#2 : EXECUTE ' + ediItem.Text);
    end
  except
  	lsbAction.ItemIndex := lsbAction.Items.Add('ERROR : EXECUTE');
  end;
end;

procedure TForm1.DDEClient2DataChange(DDEClient: TDDEClient; Item: String; const Value: PChar;
	ValueSize: Integer);
begin
	lsbAction.ItemIndex := lsbAction.Items.Add('#2 : ' + Item + ' : ' + Value);
end;

procedure TForm1.DDEClient1DataChange(DDEClient: TDDEClient; Item: String; const Value: PChar;
	ValueSize: Integer);
begin
	lsbAction.ItemIndex := lsbAction.Items.Add('#1 : ' + Item + ' : ' + Value);
end;


procedure TForm1.butPokeClick(Sender: TObject);
begin
	try
    if rdbConv1.Checked then
    begin
      if DDEClient1.Poke(ediItem.Text, PChar(ediCommand.Text), Length(ediCommand.Text) + 1) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#1 : POKE ' + ediItem.Text);
    end
    else
    begin
      if DDEClient2.Poke(ediItem.Text, PChar(ediCommand.Text), Length(ediCommand.Text) + 1) then
        lsbAction.ItemIndex := lsbAction.Items.Add('#2 : POKE ' + ediItem.Text);
    end
  except
  	lsbAction.ItemIndex := lsbAction.Items.Add('ERROR : POKE');
  end;
end;

end.
