// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'DBPropBox.pas' rev: 3.00

#ifndef DBPropBoxHPP
#define DBPropBoxHPP
#include <Db.hpp>
#include <Graphics.hpp>
#include <SysUtils.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <StdCtrls.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Dbpropbox
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TPropDataLink;
class DELPHICLASS TDBPropBox;
class DELPHICLASS TProp;
typedef void __fastcall (__closure *TOnPropChange)(System::TObject* aSender, const System::AnsiString 
	aPropName, TProp* aProp, int aPropIndex);

class DELPHICLASS TPropSelection;
class DELPHICLASS TPropEdit;
class PASCALIMPLEMENTATION TPropEdit : public Stdctrls::TCustomEdit 
{
	typedef Stdctrls::TCustomEdit inherited;
	
private:
	TPropSelection* FPropSelection;
	bool FChanged;
	
protected:
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton aButton, Classes::TShiftState aShift, int 
		aX, int aY);
	HIDESBASE MESSAGE void __fastcall WMKeyDown(Messages::TWMKey &aMsg);
	HIDESBASE MESSAGE void __fastcall WMSysKeyDown(Messages::TWMKey &aMsg);
	HIDESBASE MESSAGE void __fastcall WMChar(Messages::TWMKey &aMsg);
	DYNAMIC void __fastcall Change(void);
public:
	/* TCustomEdit.Create */ __fastcall virtual TPropEdit(Classes::TComponent* AOwner) : Stdctrls::TCustomEdit(
		AOwner) { }
	
public:
	/* TWinControl.CreateParented */ __fastcall TPropEdit(HWND ParentWindow) : Stdctrls::TCustomEdit(ParentWindow
		) { }
	/* TWinControl.Destroy */ __fastcall virtual ~TPropEdit(void) { }
	
};

class DELPHICLASS TPropButton;
enum TPropButtonState { pbsNormal, pbsHighlight, pbsPressed };

enum TPropButtonType { pbtLookup, pbtEdit };

class PASCALIMPLEMENTATION TPropButton : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	Extctrls::TTimer* FTimer;
	TPropButtonState FState;
	TPropButtonType FButtonType;
	bool FPreventClick;
	void __fastcall SetState(TPropButtonState aValue);
	void __fastcall SetButtonType(TPropButtonType aValue);
	
protected:
	__property TPropButtonState State = {read=FState, write=SetState, nodefault};
	virtual void __fastcall Paint(void);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState aShift, int aX, int aY);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton aButton, Classes::TShiftState aShift, int 
		aX, int aY);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton aButton, Classes::TShiftState aShift, int aX
		, int aY);
	void __fastcall OnTimer(System::TObject* aSender);
	
public:
	__fastcall virtual TPropButton(Classes::TComponent* anOwner);
	int __fastcall CalcWidth(void);
	
__published:
	__property OnClick ;
public:
	/* TCustomControl.Destroy */ __fastcall virtual ~TPropButton(void) { }
	
public:
	/* TWinControl.CreateParented */ __fastcall TPropButton(HWND ParentWindow) : Controls::TCustomControl(
		ParentWindow) { }
	
};

class DELPHICLASS TPropEditInfo;
class DELPHICLASS TPropList;
class PASCALIMPLEMENTATION TPropList : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TList* FList;
	int __fastcall GetCount(void);
	TProp* __fastcall GetProp(int anIndex);
	
public:
	__property int Count = {read=GetCount, nodefault};
	__property TProp* Props[int anIndex] = {read=GetProp/*, default*/};
	__fastcall TPropList(void);
	__fastcall virtual ~TPropList(void);
	bool __fastcall AllEquals(void);
	void __fastcall Add(TProp* aProp);
	int __fastcall IndexOf(TProp* aProp);
	void __fastcall Clear(void);
};

class DELPHICLASS TPropEditor;
class DELPHICLASS TPropInfoList;
class DELPHICLASS TSubPropList;
enum TPropEditorAttribute { peaLookupValues, peaDialog, peaMultiSelect, peaAutoUpdate, peaReadOnly, 
	peaPaint };

typedef Set<TPropEditorAttribute, peaLookupValues, peaPaint>  TPropEditorAttributes;

class PASCALIMPLEMENTATION TPropEditor : public System::TObject 
{
	typedef System::TObject inherited;
	
protected:
	System::TObject* __fastcall FindObject(const System::AnsiString aName);
	System::TObject* __fastcall GetObject(const System::AnsiString aName);
	
public:
	System::TObject* PropListBox;
	Classes::TStringList* NameSpace;
	__fastcall virtual TPropEditor(void);
	virtual void __fastcall GetSubPropsInfo(TPropInfoList* aPropInfoList);
	virtual void __fastcall SetSubProps(TProp* aProp, TSubPropList* aSubProps);
	virtual void __fastcall GetSubProps(TProp* aProp, TSubPropList* aSubProps);
	virtual void __fastcall Edit(TProp* aProp);
	virtual TPropEditorAttributes __fastcall GetAttributes(void);
	virtual int __fastcall GetEditLimit(void);
	virtual void __fastcall GetLookupValues(Classes::TStringList* aValues);
	virtual void __fastcall GetPropLookupValues(TPropList* aPropList, Classes::TStringList* aValues);
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall SetValue(TProp* aProp, const System::AnsiString aValue);
	virtual void __fastcall PaintValue(System::AnsiString aValue, Graphics::TCanvas* aCanvas, const Windows::TRect 
		&aRect, Stdctrls::TOwnerDrawState aState);
public:
	/* TObject.Destroy */ __fastcall virtual ~TPropEditor(void) { }
	
};

typedef System::TMetaClass*TPropClass;

class PASCALIMPLEMENTATION TPropEditInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TDBPropBox* FPropListBox;
	int FUpdateCount;
	bool FPropChanged;
	TPropList* FPropList;
	bool FAllEquals;
	TPropEditor* FPropEditor;
	void __fastcall PropChange(System::TObject* aSender);
	void __fastcall SetNameSpace(Classes::TStringList* aValue);
	Classes::TStringList* __fastcall GetNameSpace(void);
	
public:
	int FListIndex;
	Classes::TList* FSubProps;
	bool FExpanded;
	TPropEditInfo* FParent;
	System::AnsiString FPropName;
	TOnPropChange OnPropChange;
	__property Classes::TStringList* NameSpace = {read=GetNameSpace, write=SetNameSpace};
	__fastcall TPropEditInfo(TDBPropBox* aPropListBox, TPropEditInfo* aParent, const System::AnsiString 
		aPropName, System::TMetaClass* aPropClass, int aCount);
	__fastcall virtual ~TPropEditInfo(void);
	void __fastcall SetSubProps(void);
	void __fastcall GetSubProps(void);
	void __fastcall ClearListIndex(void);
	void __fastcall SetProps(TPropList* aPropList);
	void __fastcall GetProps(TPropList* aPropList);
	System::AnsiString __fastcall GetValue(void);
	void __fastcall SetValue(const System::AnsiString aValue);
	void __fastcall Edit(void);
	bool __fastcall IsReadOnly(void);
	bool __fastcall IsLookupable(void);
	bool __fastcall IsEditable(void);
	bool __fastcall IsExpandable(void);
	void __fastcall BeginUpdate(void);
	void __fastcall EndUpdate(void);
	int __fastcall GetLevel(void);
};

class PASCALIMPLEMENTATION TPropSelection : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	Graphics::TBitmap* FCacheBitmap;
	TDBPropBox* FPropListBox;
	TPropEdit* FPropEdit;
	TPropButton* FPropButton;
	TPropEditInfo* FEditInfo;
	Windows::TRect FLevelRect;
	Windows::TRect FNameRect;
	Windows::TRect FEditRect;
	Windows::TRect FButtonRect;
	
protected:
	HIDESBASE MESSAGE void __fastcall WMEraseBkGnd(Messages::TWMEraseBkgnd &aMsg);
	virtual void __fastcall Paint(void);
	virtual void __fastcall AlignControls(Controls::TControl* aControl, Windows::TRect &aRect);
	HIDESBASE void __fastcall Realign(void);
	void __fastcall UpdatePropName(void);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &aMsg);
	void __fastcall PropButtonClick(System::TObject* aSender);
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState aShift, int aX, int aY);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton aButton, Classes::TShiftState aShift, int 
		aX, int aY);
	void __fastcall Lookup(void);
	void __fastcall Edit(void);
	void __fastcall GetValueFromProp(void);
	void __fastcall SetValueToProp(void);
	
public:
	__fastcall virtual TPropSelection(Classes::TComponent* anOwner);
	__fastcall virtual ~TPropSelection(void);
	void __fastcall SetEditInfo(TPropEditInfo* aValue);
public:
	/* TWinControl.CreateParented */ __fastcall TPropSelection(HWND ParentWindow) : Controls::TCustomControl(
		ParentWindow) { }
	
};

class DELPHICLASS TMultiPropList;
class PASCALIMPLEMENTATION TDBPropBox : public Stdctrls::TCustomListBox 
{
	typedef Stdctrls::TCustomListBox inherited;
	
private:
	bool FPreventSetFocus;
	bool FReadOnly;
	bool FPreventNotify;
	int FMouseDownTime;
	TOnPropChange FOnPropChange;
	bool FDraggingDivider;
	int FDraggingDividerPos;
	Graphics::TBitmap* FCacheBitmap;
	TPropDataLink* FDataLink;
	bool FPropChanging;
	void __fastcall DataChange(System::TObject* aSender);
	Db::TDataSource* __fastcall GetDataSource(void);
	void __fastcall SetDataSource(Db::TDataSource* aDataSource);
	bool __fastcall IsDividerPos(int aX);
	int __fastcall GetDividerPos(void);
	void __fastcall SetReadOnly(bool aValue);
	HIDESBASE MESSAGE void __fastcall WMSetFocus(Messages::TWMSetFocus &aMsg);
	
protected:
	int FDividerPos;
	Classes::TList* FEditInfoList;
	TPropSelection* FPropSelection;
	virtual void __fastcall SetDividerPos(int aValue);
	void __fastcall RebuildListIndexes(void);
	HIDESBASE MESSAGE void __fastcall CNDrawItem(Messages::TWMDrawItem &Message);
	DYNAMIC void __fastcall Click(void);
	DYNAMIC void __fastcall DoEnter(void);
	void __fastcall ClearList(void);
	void __fastcall UpdatePropSelection(void);
	void __fastcall RepaintDraggingDivider(void);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton aButton, Classes::TShiftState aShift, int 
		aX, int aY);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState aShift, int aX, int aY);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton aButton, Classes::TShiftState aShift, int aX
		, int aY);
	DYNAMIC void __fastcall DblClick(void);
	virtual void __fastcall AlignControls(Controls::TControl* aControl, Windows::TRect &aRect);
	virtual void __fastcall PropChange(System::TObject* aSender, const System::AnsiString aPropName, TProp* 
		aProp, int aPropIndex);
	TPropEditInfo* __fastcall GetEditInfo(int anIndex);
	void __fastcall ExpandItem(int anIndex);
	void __fastcall CollapseItem(int anIndex);
	void __fastcall PaintItem(int anIndex, Graphics::TCanvas* aCanvas, const Windows::TRect &aR, Stdctrls::TOwnerDrawState 
		aState);
	void __fastcall PaintItemToDC(int anIndex, HDC aDC, const Windows::TRect &aR, Stdctrls::TOwnerDrawState 
		aState);
	void __fastcall RepaintItem(int anIndex);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &aMsg);
	HIDESBASE MESSAGE void __fastcall WMPaint(Messages::TWMPaint &aMsg);
	HIDESBASE MESSAGE void __fastcall WMEraseBkGnd(Messages::TWMEraseBkgnd &aMsg);
	
public:
	Classes::TStringList* NameSpace;
	__fastcall virtual TDBPropBox(Classes::TComponent* anOwner);
	__fastcall virtual ~TDBPropBox(void);
	virtual void __fastcall CreateParams(Controls::TCreateParams &aParams);
	void __fastcall ApplyChanges(void);
	void __fastcall DiscardChanges(void);
	virtual void __fastcall NewProps(TMultiPropList* aMultiPropList);
	void __fastcall UpdateProps(TMultiPropList* aProps);
	void __fastcall SetProps(const System::AnsiString aPropName, TPropList* aPropList);
	void __fastcall GetProps(const System::AnsiString aPropName, TPropList* aPropList);
	__property TOnPropChange OnPropChange = {read=FOnPropChange, write=FOnPropChange};
	
__published:
	__property Db::TDataSource* DataSource = {read=GetDataSource, write=SetDataSource};
	__property bool ReadOnly = {read=FReadOnly, write=SetReadOnly, nodefault};
	__property int DividerPos = {read=GetDividerPos, write=SetDividerPos, nodefault};
	__property Align ;
	__property Color ;
	__property Font ;
public:
	/* TWinControl.CreateParented */ __fastcall TDBPropBox(HWND ParentWindow) : Stdctrls::TCustomListBox(
		ParentWindow) { }
	
};

class PASCALIMPLEMENTATION TPropDataLink : public Db::TDataLink 
{
	typedef Db::TDataLink inherited;
	
private:
	TDBPropBox* FPropBox;
	
protected:
	virtual void __fastcall ActiveChanged(void);
	virtual void __fastcall RecordChanged(Db::TField* aField);
	
public:
	Classes::TNotifyEvent OnDataChange;
public:
	/* TDataLink.Create */ __fastcall TPropDataLink(void) : Db::TDataLink() { }
	/* TDataLink.Destroy */ __fastcall virtual ~TPropDataLink(void) { }
	
};

class PASCALIMPLEMENTATION TProp : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	bool FAssigned;
	int FValueSize;
	void *FValue;
	
protected:
	virtual int __fastcall GetValueSize(void);
	virtual void * __fastcall AllocValue(int &aSize);
	virtual void __fastcall FreeValue(void * aValue);
	virtual void __fastcall AssignValue(void * aValue);
	virtual void __fastcall AssignValueTo(void * aValue);
	virtual int __fastcall CompareValue(void * aValue);
	virtual System::Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsVariant(const System::Variant &v);
	
public:
	System::TObject* FPropEditInfo;
	Classes::TNotifyEvent OnChange;
	__property bool Assigned = {read=FAssigned, write=FAssigned, nodefault};
	__property void * Value = {read=FValue};
	__property System::Variant AsVariant = {read=GetAsVariant, write=SetAsVariant};
	__fastcall virtual TProp(void);
	__fastcall virtual ~TProp(void);
	bool __fastcall SetValue(const void *aValue);
	bool __fastcall GetValue(void *aValue);
	int __fastcall GetOrdValue(void);
	void __fastcall SetOrdValue(int aValue);
	double __fastcall GetFloatValue(void);
	void __fastcall SetFloatValue(double aValue);
	void __fastcall Assign(TProp* aSrc);
	int __fastcall Compare(TProp* aTest);
};

class PASCALIMPLEMENTATION TPropInfoList : public Classes::TStringList 
{
	typedef Classes::TStringList inherited;
	
private:
	System::TMetaClass* __fastcall GetPropClass(int anIndex);
	
public:
	__property System::TMetaClass* Classes[int anIndex] = {read=GetPropClass};
	void __fastcall AddInfo(const System::AnsiString aPropName, System::TMetaClass* aPropClass);
public:
		
	/* TStringList.Destroy */ __fastcall virtual ~TPropInfoList(void) { }
	
public:
	/* TObject.Create */ __fastcall TPropInfoList(void) : Classes::TStringList() { }
	
};

class PASCALIMPLEMENTATION TMultiPropList : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int __fastcall GetCount(void);
	bool __fastcall GetSorted(void);
	void __fastcall SetSorted(bool aValue);
	System::AnsiString __fastcall GetName(int anIndex);
	TPropList* __fastcall GetList(int anIndex);
	TPropList* __fastcall GetListByName(const System::AnsiString aPropName);
	
public:
	Classes::TStringList* FList;
	__property int Count = {read=GetCount, nodefault};
	__property bool Sorted = {read=GetSorted, write=SetSorted, nodefault};
	__property System::AnsiString Names[int anIndex] = {read=GetName};
	__property TPropList* Lists[int anIndex] = {read=GetList/*, default*/};
	__property TPropList* ListsByName[System::AnsiString aPropName] = {read=GetListByName};
	__fastcall TMultiPropList(void);
	__fastcall virtual ~TMultiPropList(void);
	TPropList* __fastcall AddList(const System::AnsiString aPropName, System::TMetaClass* aPropClass, int 
		aCount);
	TPropList* __fastcall FindListByName(const System::AnsiString aPropName);
	void __fastcall ClearLists(void);
	void __fastcall Clear(void);
};

class PASCALIMPLEMENTATION TSubPropList : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TStringList* FList;
	int __fastcall GetCount(void);
	TProp* __fastcall GetPropByName(const System::AnsiString aName);
	System::AnsiString __fastcall GetName(int anIndex);
	TProp* __fastcall GetProp(int anIndex);
	
public:
	__property int Count = {read=GetCount, nodefault};
	__property TProp* Items[System::AnsiString aPropName] = {read=GetPropByName/*, default*/};
	__property System::AnsiString Names[int anIndex] = {read=GetName};
	__property TProp* Props[int anIndex] = {read=GetProp};
	__fastcall TSubPropList(void);
	__fastcall virtual ~TSubPropList(void);
	void __fastcall Add(const System::AnsiString aPropName, TProp* aProp);
	void __fastcall Clear(void);
};

class DELPHICLASS EPropEditor;
class PASCALIMPLEMENTATION EPropEditor : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall EPropEditor(const System::AnsiString Msg) : Sysutils::Exception(Msg
		) { }
	/* Exception.CreateFmt */ __fastcall EPropEditor(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall EPropEditor(int Ident, Extended Dummy) : Sysutils::Exception(Ident
		, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall EPropEditor(int Ident, const System::TVarRec * Args, const 
		int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall EPropEditor(const System::AnsiString Msg, int AHelpContext) : 
		Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall EPropEditor(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall EPropEditor(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall EPropEditor(int Ident, const System::TVarRec * Args, const 
		int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~EPropEditor(void) { }
	
};

typedef System::TMetaClass*TPropEditorClass;

typedef void __fastcall (__closure *TSimpleEvent)(void);

class DELPHICLASS TDoubleProp;
class PASCALIMPLEMENTATION TDoubleProp : public Dbpropbox::TProp 
{
	typedef Dbpropbox::TProp inherited;
	
protected:
	virtual System::Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsVariant(const System::Variant &v);
	
public:
	virtual int __fastcall GetValueSize(void);
	virtual int __fastcall CompareValue(void * aValue);
public:
	/* TProp.Create */ __fastcall virtual TDoubleProp(void) : Dbpropbox::TProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TDoubleProp(void) { }
	
};

class DELPHICLASS TDoublePropEditor;
class PASCALIMPLEMENTATION TDoublePropEditor : public Dbpropbox::TPropEditor 
{
	typedef Dbpropbox::TPropEditor inherited;
	
public:
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall SetValue(TProp* aProp, const System::AnsiString aValue);
public:
	/* TPropEditor.Create */ __fastcall virtual TDoublePropEditor(void) : Dbpropbox::TPropEditor() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TDoublePropEditor(void) { }
	
};

class DELPHICLASS TSmallintProp;
class PASCALIMPLEMENTATION TSmallintProp : public Dbpropbox::TProp 
{
	typedef Dbpropbox::TProp inherited;
	
protected:
	virtual System::Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsVariant(const System::Variant &v);
	
public:
	virtual int __fastcall GetValueSize(void);
	virtual int __fastcall CompareValue(void * aValue);
public:
	/* TProp.Create */ __fastcall virtual TSmallintProp(void) : Dbpropbox::TProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TSmallintProp(void) { }
	
};

class DELPHICLASS TSmallintPropEditor;
class PASCALIMPLEMENTATION TSmallintPropEditor : public Dbpropbox::TPropEditor 
{
	typedef Dbpropbox::TPropEditor inherited;
	
public:
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall SetValue(TProp* aProp, const System::AnsiString aValue);
public:
	/* TPropEditor.Create */ __fastcall virtual TSmallintPropEditor(void) : Dbpropbox::TPropEditor() { }
		
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TSmallintPropEditor(void) { }
	
};

class DELPHICLASS TLongintProp;
class PASCALIMPLEMENTATION TLongintProp : public Dbpropbox::TProp 
{
	typedef Dbpropbox::TProp inherited;
	
protected:
	virtual System::Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsVariant(const System::Variant &v);
	
public:
	virtual int __fastcall GetValueSize(void);
	virtual int __fastcall CompareValue(void * aValue);
public:
	/* TProp.Create */ __fastcall virtual TLongintProp(void) : Dbpropbox::TProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TLongintProp(void) { }
	
};

class DELPHICLASS TLongintPropEditor;
class PASCALIMPLEMENTATION TLongintPropEditor : public Dbpropbox::TPropEditor 
{
	typedef Dbpropbox::TPropEditor inherited;
	
public:
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall SetValue(TProp* aProp, const System::AnsiString aValue);
public:
	/* TPropEditor.Create */ __fastcall virtual TLongintPropEditor(void) : Dbpropbox::TPropEditor() { }
		
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TLongintPropEditor(void) { }
	
};

typedef SmallString<250>  TStringPropValue;

class DELPHICLASS TStringProp;
class PASCALIMPLEMENTATION TStringProp : public Dbpropbox::TProp 
{
	typedef Dbpropbox::TProp inherited;
	
protected:
	virtual System::Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsVariant(const System::Variant &v);
	
public:
	virtual int __fastcall GetValueSize(void);
	virtual int __fastcall CompareValue(void * aValue);
public:
	/* TProp.Create */ __fastcall virtual TStringProp(void) : Dbpropbox::TProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TStringProp(void) { }
	
};

class DELPHICLASS TStringPropEditor;
class PASCALIMPLEMENTATION TStringPropEditor : public Dbpropbox::TPropEditor 
{
	typedef Dbpropbox::TPropEditor inherited;
	
public:
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall SetValue(TProp* aProp, const System::AnsiString aValue);
public:
	/* TPropEditor.Create */ __fastcall virtual TStringPropEditor(void) : Dbpropbox::TPropEditor() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TStringPropEditor(void) { }
	
};

enum DBPropBox__22 { eooSorted, eooIgnoreCase, eooReadOnly };

typedef Set<DBPropBox__22, eooSorted, eooReadOnly>  TEnumOrdOptions;

typedef void __fastcall (__closure *TAddEnumValueProc)(System::AnsiString aName, int aValue);

class DELPHICLASS TEnumOrdPropEditor;
class PASCALIMPLEMENTATION TEnumOrdPropEditor : public Dbpropbox::TPropEditor 
{
	typedef Dbpropbox::TPropEditor inherited;
	
private:
	TEnumOrdOptions FOptions;
	Classes::TStringList* FValues;
	void __fastcall AddEnumValue(System::AnsiString aName, int aValue);
	
protected:
	int __fastcall GetValueFromName(System::AnsiString aName);
	virtual void __fastcall GetEnumValues(TAddEnumValueProc aProc, TEnumOrdOptions &anOptions);
	
public:
	__fastcall virtual TEnumOrdPropEditor(void);
	__fastcall virtual ~TEnumOrdPropEditor(void);
	virtual TPropEditorAttributes __fastcall GetAttributes(void);
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall SetValue(TProp* aProp, const System::AnsiString aValue);
	virtual void __fastcall GetLookupValues(Classes::TStringList* aValues);
};

class DELPHICLASS TBooleanProp;
class PASCALIMPLEMENTATION TBooleanProp : public Dbpropbox::TProp 
{
	typedef Dbpropbox::TProp inherited;
	
protected:
	virtual System::Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsVariant(const System::Variant &v);
	
public:
	virtual int __fastcall GetValueSize(void);
public:
	/* TProp.Create */ __fastcall virtual TBooleanProp(void) : Dbpropbox::TProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TBooleanProp(void) { }
	
};

class DELPHICLASS TBooleanPropEditor;
class PASCALIMPLEMENTATION TBooleanPropEditor : public Dbpropbox::TEnumOrdPropEditor 
{
	typedef Dbpropbox::TEnumOrdPropEditor inherited;
	
public:
	virtual void __fastcall GetEnumValues(TAddEnumValueProc aProc, TEnumOrdOptions &anOptions);
public:
	/* TEnumOrdPropEditor.Create */ __fastcall virtual TBooleanPropEditor(void) : Dbpropbox::TEnumOrdPropEditor(
		) { }
	/* TEnumOrdPropEditor.Destroy */ __fastcall virtual ~TBooleanPropEditor(void) { }
	
};

class DELPHICLASS TTextProp;
class PASCALIMPLEMENTATION TTextProp : public Dbpropbox::TProp 
{
	typedef Dbpropbox::TProp inherited;
	
protected:
	virtual void * __fastcall AllocValue(int &aSize);
	virtual void __fastcall FreeValue(void * aValue);
	virtual void __fastcall AssignValue(void * aValue);
	virtual void __fastcall AssignValueTo(void * aValue);
	virtual int __fastcall CompareValue(void * aValue);
public:
	/* TProp.Create */ __fastcall virtual TTextProp(void) : Dbpropbox::TProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TTextProp(void) { }
	
};

class DELPHICLASS TTextPropEditor;
class PASCALIMPLEMENTATION TTextPropEditor : public Dbpropbox::TPropEditor 
{
	typedef Dbpropbox::TPropEditor inherited;
	
public:
	virtual TPropEditorAttributes __fastcall GetAttributes(void);
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall Edit(TProp* aProp);
public:
	/* TPropEditor.Create */ __fastcall virtual TTextPropEditor(void) : Dbpropbox::TPropEditor() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TTextPropEditor(void) { }
	
};

class DELPHICLASS TDateTimeProp;
class PASCALIMPLEMENTATION TDateTimeProp : public Dbpropbox::TProp 
{
	typedef Dbpropbox::TProp inherited;
	
protected:
	virtual System::Variant __fastcall GetAsVariant(void);
	virtual void __fastcall SetAsVariant(const System::Variant &v);
	
public:
	virtual int __fastcall GetValueSize(void);
	virtual int __fastcall CompareValue(void * aValue);
public:
	/* TProp.Create */ __fastcall virtual TDateTimeProp(void) : Dbpropbox::TProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TDateTimeProp(void) { }
	
};

class DELPHICLASS TDateProp;
class PASCALIMPLEMENTATION TDateProp : public Dbpropbox::TDateTimeProp 
{
	typedef Dbpropbox::TDateTimeProp inherited;
	
public:
	/* TProp.Create */ __fastcall virtual TDateProp(void) : Dbpropbox::TDateTimeProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TDateProp(void) { }
	
};

class DELPHICLASS TTimeProp;
class PASCALIMPLEMENTATION TTimeProp : public Dbpropbox::TDateTimeProp 
{
	typedef Dbpropbox::TDateTimeProp inherited;
	
public:
	/* TProp.Create */ __fastcall virtual TTimeProp(void) : Dbpropbox::TDateTimeProp() { }
	/* TProp.Destroy */ __fastcall virtual ~TTimeProp(void) { }
	
};

class DELPHICLASS TDateTimePropEditor;
class PASCALIMPLEMENTATION TDateTimePropEditor : public Dbpropbox::TPropEditor 
{
	typedef Dbpropbox::TPropEditor inherited;
	
public:
	virtual TPropEditorAttributes __fastcall GetAttributes(void);
	virtual void __fastcall GetSubPropsInfo(TPropInfoList* aPropInfoList);
	virtual void __fastcall SetSubProps(TProp* aProp, TSubPropList* aSubProps);
	virtual void __fastcall GetSubProps(TProp* aProp, TSubPropList* aSubProps);
	virtual System::AnsiString __fastcall GetValue(TProp* aProp);
	virtual void __fastcall SetValue(TProp* aProp, const System::AnsiString aValue);
public:
	/* TPropEditor.Create */ __fastcall virtual TDateTimePropEditor(void) : Dbpropbox::TPropEditor() { }
		
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TDateTimePropEditor(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void * __fastcall FindPropValue(System::AnsiString aName, const System::AnsiString * 
	aNames, const int aNames_Size, const void * * aValues, const int aValues_Size);
extern PACKAGE void __fastcall RegisterPropEditor(System::AnsiString aPropName, System::TMetaClass* 
	aPropClass, System::TMetaClass* anEditorClass);
extern PACKAGE System::TMetaClass* __fastcall GetPropEditorClass(System::TMetaClass* aPropClass);
extern PACKAGE void __fastcall RegisterStdProps(void);
extern PACKAGE void __fastcall Register(void);

}	/* namespace Dbpropbox */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Dbpropbox;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// DBPropBox
