unit BlobEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ComCtrls, ToolWin, StdCtrls, DBCtrls, Clipbrd;

type
  TfmBlobEdit = class(TForm)
    ToolBar1: TToolBar;
    tbtnOk: TToolButton;
    tbtnCancel: TToolButton;
    ToolButton3: TToolButton;
    tbtnOpen: TToolButton;
    tbtnSave: TToolButton;
    ToolButton6: TToolButton;
    tbtnCut: TToolButton;
    tbtnPaste: TToolButton;
    tbtnCopy: TToolButton;
    ImageList1: TImageList;
    dbmMemo: TDBMemo;
    dbiGraphic: TDBImage;
    ToolButton10: TToolButton;
    ToolButton1: TToolButton;
    procedure tbtnOkClick(Sender: TObject);
    procedure tbtnCancelClick(Sender: TObject);
    procedure tbtnOpenClick(Sender: TObject);
    procedure tbtnSaveClick(Sender: TObject);
    procedure tbtnCutClick(Sender: TObject);
    procedure tbtnCopyClick(Sender: TObject);
    procedure tbtnPasteClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure CheckClipboard;
  public
  end;

var
  fmBlobEdit: TfmBlobEdit;

implementation
uses DataMod;
{$R *.DFM}
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.CheckClipboard;
var
  lFormat: Word;
begin
  if dbmMemo.Showing then
    lFormat := CF_TEXT
  else lFormat := CF_BITMAP;
  if Clipboard.HasFormat(lFormat) then
    tbtnPaste.Enabled := True
  else tbtnPaste.Enabled := False;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.tbtnOkClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.tbtnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.tbtnOpenClick(Sender: TObject);
begin
with dmDataModule.OpenDialog do begin
    FileName := ExtractFilePath(Application.ExeName);
    if dbmMemo.Showing then begin
      Filter := 'Text files (*.txt)|*.txt|All files (*.*)|*.*';
      FileName := FileName + '*.txt';
      if Execute then dbmMemo.Lines.LoadFromFile(FileName);
    end
    else begin
      Filter := 'Bitmaps (*.bmp)|*.txt|All files (*.*)|*.*';
      FileName := FileName + '*.bmp';
      if Execute then dbiGraphic.Picture.LoadFromFile(FileName);
    end;
  end;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.tbtnSaveClick(Sender: TObject);
begin
 with dmDataModule.SaveDialog do begin
    FileName := ExtractFilePath(Application.ExeName);
    if dbmMemo.Showing then begin
      Filter := 'Text files (*.txt)|*.txt|All files (*.*)|*.*';
      FileName := FileName + 'Demo.txt';
      if Execute then dbmMemo.Lines.SaveToFile(FileName);
    end
    else begin
      Filter := 'Bitmaps (*.bmp)|*.txt|All files (*.*)|*.*';
      FileName := FileName + 'Demo.bmp';
      if Execute then dbiGraphic.Picture.SaveToFile(FileName);
    end;
  end;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.tbtnCutClick(Sender: TObject);
begin
  if dbmMemo.Showing then
    dbmMemo.CutToClipboard
  else dbiGraphic.CutToClipboard;
  CheckClipboard;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.tbtnCopyClick(Sender: TObject);
begin
  if dbmMemo.Showing then
    dbmMemo.CopyToClipboard
  else dbiGraphic.CopyToClipboard;
  CheckClipboard;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.tbtnPasteClick(Sender: TObject);
begin
  if dbmMemo.Showing then
    dbmMemo.PasteFromClipboard
  else dbiGraphic.PasteFromClipboard;
end;
{--------------------------------------------------------------------------}
procedure TfmBlobEdit.FormShow(Sender: TObject);
begin
  CheckClipboard;
end;
{--------------------------------------------------------------------------}
end.
