unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, Buttons, Grids, DBGrids, Db,
  DBTables, ImgList, dagTmplt, DbAGrids, Spin;

type
  TfmMain = class(TForm)
    ColorDialog: TColorDialog;
    FontDialog: TFontDialog;
    ilHeader: TImageList;
    pgcSettings: TPageControl;
    tbshOptions: TTabSheet;
    cbEditing: TCheckBox;
    cbAlwaysShowEditor: TCheckBox;
    cbTitles: TCheckBox;
    cbIndicator: TCheckBox;
    cbColumnResize: TCheckBox;
    cbColLines: TCheckBox;
    cbRowLines: TCheckBox;
    cbTabs: TCheckBox;
    cbRowSelect: TCheckBox;
    cbAlwaysShowSelection: TCheckBox;
    cbConfirmDelete: TCheckBox;
    cbCancelOnExit: TCheckBox;
    cbMultiSelect: TCheckBox;
    tbshAltOptions: TTabSheet;
    cbAppendCtrlIns: TCheckBox;
    cbBandLines: TCheckBox;
    cbBandResize: TCheckBox;
    cbCellHint: TCheckBox;
    cbDiscreteBandHeight: TCheckBox;
    cbEnterLikeTab: TCheckBox;
    cbExpandedBottomBar: TCheckBox;
    cbExpandIcon: TCheckBox;
    cbStripedRows: TCheckBox;
    cbHeaderFocusRect: TCheckBox;
    cbHeaderPush: TCheckBox;
    tbshColors: TTabSheet;
    sbColor: TSpeedButton;
    lbColor: TListBox;
    tbshText: TTabSheet;
    gbFont: TGroupBox;
    sbFont: TSpeedButton;
    lbFont: TListBox;
    gbAlignment: TGroupBox;
    lbAlignment: TListBox;
    rbLeft: TRadioButton;
    rbCenter: TRadioButton;
    rbRight: TRadioButton;
    tbshTitle: TTabSheet;
    rgSortMark: TRadioGroup;
    gbIcon: TGroupBox;
    lblIconMain: TLabel;
    lblIconExpanded: TLabel;
    speIconMain: TSpinEdit;
    speIconExpanded: TSpinEdit;
    Splitter1: TSplitter;
    tbshLook: TTabSheet;
    rgStyle: TRadioGroup;
    cbColumnAltResize: TCheckBox;
    cbCtrl3D: TCheckBox;
    rgTable: TRadioGroup;
    ilBoolean: TImageList;
    gbStore: TGroupBox;
    sbSave: TSpeedButton;
    sbLoad: TSpeedButton;
    dagGrid: TDbAltGrid;
    dagCalendar1: TdagCalendar;
    dagNumPad1: TdagNumPad;
    dagCalculator1: TdagCalculator;
    dagBoolean1: TdagBoolean;
    dagGraphic1: TdagGraphic;
    dagMemo1: TdagMemo;
    dagParent1: TdagParent;
    cbEnabled: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure cbCtrl3DClick(Sender: TObject);
    procedure sbColorClick(Sender: TObject);
    procedure sbFontClick(Sender: TObject);
    procedure sbSaveClick(Sender: TObject);
    procedure sbLoadClick(Sender: TObject);
    procedure rgSortMarkClick(Sender: TObject);
    procedure speIconMainChange(Sender: TObject);
    procedure speIconExpandedChange(Sender: TObject);
    procedure dagGridEditButtonClick(Sender: TObject);
    procedure dagGridTitleClick(Column: TColumn);
    procedure cbEnabledClick(Sender: TObject);
  private
    FLock: Integer;
    function AcquireLock: Boolean;
    procedure CheckSortMark;
    procedure EndLock;
  public
    function GetColor(const AIndex: Integer): TColor;
    function GetFont(const AIndex: Integer): TFont;
    procedure GetOptions;
    procedure GetRichOptions;
    procedure SetColor(const AIndex: Integer; const AColor: TColor);
    procedure SetFont(const AIndex: Integer; const AFont: TFont);
  published
    procedure ChangeLook(Sender: TObject);
    procedure SetAlignment(Sender: TObject);
    procedure SetOptions(Sender: TObject);
    procedure SetAltOptions(Sender: TObject);
  end;

var
  fmMain: TfmMain;

implementation
uses DataMod, BlobEdit;
{$R *.DFM}
{--------------------------------------------------------------------------}

function TfmMain.AcquireLock: Boolean;
begin
  Result := False;
  if FLock = 0 then begin
    Inc(FLock);
    Result := True;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.CheckSortMark;
var
  I, lIndex: Integer;
  lIndexFieldNames: string;
  lFieldNames: TStringList;
begin
  with dagGrid do begin
    for I := 0 to Columns.Count - 1 do TdagColumn(Columns[I]).SortMark := smNone;
    if (dmDataModule.dsDataSource.DataSet = dmDataModule.tblCastoly)
      and (rgStyle.ItemIndex > 0) then begin
      lFieldNames := TStringList.Create;
      try
        lFieldNames.Clear;
        lIndexFieldNames := TTable(dmDataModule.dsDataSource.DataSet).IndexFieldNames;
        if AnsiCompareText(lIndexFieldNames, 'CustNo') = 0 then
          lFieldNames.Add('CustNo')
        else
          if AnsiCompareText(lIndexFieldNames, 'Last_Name;First_Name') = 0 then begin
            lFieldNames.Add('Name');
            lFieldNames.Add('Last_Name');
            lFieldNames.Add('First_Name');
          end;

        while lFieldNames.Count > 0 do begin
          for I := 0 to Columns.Count - 1 do
            with TdagColumn(Columns[I]) do begin
              lIndex := lFieldNames.IndexOf(FieldName);
              if lIndex >= 0 then begin
                SortMark := smMarkAscending;
                lFieldNames.Delete(lIndex);
                Break;
              end;
            end;
        end;

      finally
        lFieldNames.Free;
      end;
    end;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.EndLock;
begin
  if FLock > 0 then Dec(FLock);
end;
{--------------------------------------------------------------------------}

function TfmMain.GetColor(const AIndex: Integer): TColor;
begin
  Result := $FFFFFF;
  with dagGrid do
    case AIndex of
      0: Result := Color;
      1: Result := FixedColor;
      2: Result := AltColors.ColLine;
      3: Result := AltColors.RowLine;
      4: Result := AltColors.BandLine;
      5: Result := AltColors.FixedLine;
      6: Result := AltColors.FlatBorder;
      7: Result := AltColors.HeaderBlank;
      8: Result := AltColors.RowBlank;
      9: Result := AltColors.Stripe0;
      10: Result := AltColors.Stripe1;
      11: Result := Columns[SelectedIndex].Color;
      12: Result := Columns[SelectedIndex].Title.Color;
      13: Result := TdagColumn(Columns[SelectedIndex]).TitleExpanded.Color;
    end;
end;
{--------------------------------------------------------------------------}

function TfmMain.GetFont(const AIndex: Integer): TFont;
begin
  Result := Font;
  with dagGrid do
    case AIndex of
      0: Result := Font;
      1: Result := TitleFont;
      2: Result := Columns[SelectedIndex].Font;
      3: Result := Columns[SelectedIndex].Title.Font;
      4: Result := TdagColumn(Columns[SelectedIndex]).TitleExpanded.Font;
    end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.GetOptions;
begin
  if AcquireLock then
  try
    with dagGrid do begin
      cbEditing.Checked := dgEditing in Options;
      cbAlwaysShowEditor.Checked := dgAlwaysShowEditor in Options;
      cbTitles.Checked := dgTitles in Options;
      cbIndicator.Checked := dgIndicator in Options;
      cbColumnResize.Checked := dgColumnResize in Options;
      cbColLines.Checked := dgColLines in Options;
      cbRowLines.Checked := dgRowLines in Options;
      cbTabs.Checked := dgTabs in Options;
      cbRowSelect.Checked := dgRowSelect in Options;
      cbAlwaysShowSelection.Checked := dgAlwaysShowSelection in Options;
      cbConfirmDelete.Checked := dgConfirmDelete in Options;
      cbCancelOnExit.Checked := dgCancelOnExit in Options;
      cbMultiSelect.Checked := dgMultiSelect in Options;
      cbCtrl3D.Checked := Ctl3D;
      cbEnabled.Checked := Enabled;
    end;
  finally
    EndLock;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.GetRichOptions;
begin
  if AcquireLock then
  try
    with dagGrid do begin
      cbAppendCtrlIns.Checked := dagAppendCtrlIns in AltOptions;
      cbBandLines.Checked := dagBandLines in AltOptions;
      cbBandResize.Checked := dagBandResize in AltOptions;
      cbCellHint.Checked := dagCellHint in AltOptions;
      cbColumnAltResize.Checked := dagColumnAltResize in AltOptions;
      cbDiscreteBandHeight.Checked := dagDiscreteBandHeight in AltOptions;
      cbEnterLikeTab.Checked := dagEnterLikeTab in AltOptions;
      cbExpandedBottomBar.Checked := dagExpandedBottomBar in AltOptions;
      cbExpandIcon.Checked := dagExpandIcon in AltOptions;
      cbStripedRows.Checked := dagStripedRows in AltOptions;
      cbHeaderFocusRect.Checked := dagTitleFocusRect in AltOptions;
      cbHeaderPush.Checked := dagTitlePush in AltOptions;
    end;
  finally
    EndLock;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.SetColor(const AIndex: Integer; const AColor: TColor);
begin
  with dagGrid do
    case AIndex of
      0: Color := AColor;
      1: FixedColor := AColor;
      2: AltColors.ColLine := AColor;
      3: AltColors.RowLine := AColor;
      4: AltColors.BandLine := AColor;
      5: AltColors.FixedLine := AColor;
      6: AltColors.FlatBorder := AColor;
      7: AltColors.HeaderBlank := AColor;
      8: AltColors.RowBlank := AColor;
      9: AltColors.Stripe0 := AColor;
      10: AltColors.Stripe1 := AColor;
      11: Columns[SelectedIndex].Color := AColor;
      12: Columns[SelectedIndex].Title.Color := AColor;
      13: TdagColumn(Columns[SelectedIndex]).TitleExpanded.Color := AColor;
    end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.SetFont(const AIndex: Integer; const AFont: TFont);
begin
  with dagGrid do
    case AIndex of
      0: Font := AFont;
      1: TitleFont := AFont;
      2: Columns[SelectedIndex].Font := AFont;
      3: Columns[SelectedIndex].Title.Font := AFont;
      4: TdagColumn(Columns[SelectedIndex]).TitleExpanded.Font := AFont;
    end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.ChangeLook(Sender: TObject);
const
  ColumnsFileNameArr: array[0..2, 0..2] of string = (
    ('CusClas.col', 'CusCool.col', 'CusLight.col'),
    ('EvClas.col', 'EvCool.col', 'EvLight.col'),
    ('ResClas.col', 'ResCool.col', 'ResCool.col'));

  lClassicOptions = [dgEditing, dgTitles, dgIndicator, dgColumnResize,
    dgColLines, dgRowLines, dgTabs, dgConfirmDelete, dgCancelOnExit];

  lAltOptionsArr: array[0..2] of TdagOptions = (
    [{dagAppendCtrlIns, dagBandLines, dagBandResize, dagCellHint,
    dagColumnAltResize, dagDiscreteBandHeight, dagEnterLikeTab,
    dagExpandedBottomBar, dagExpandIcon, dagStripedRows, dagTitleFocusRect,
    dagTitlePush}],
    [dagAppendCtrlIns, dagBandLines, dagBandResize, dagCellHint,
    dagColumnAltResize, dagDiscreteBandHeight, dagEnterLikeTab,
      dagExpandedBottomBar, dagExpandIcon, dagStripedRows, dagTitleFocusRect,
      dagTitlePush],
      [dagAppendCtrlIns, dagBandLines, dagBandResize, dagCellHint,
    dagColumnAltResize, {dagDiscreteBandHeight,} dagEnterLikeTab,
    {dagExpandedBottomBar, dagExpandIcon,} dagStripedRows, dagTitleFocusRect {,
    dagTitlePush}]);

  {TdagColorName = (rgcBandLine, rgcColLine, rgcFixedLine, rgcFlatBorder,
    rgcHeaderBlank, rgcRowBlank, rgcRowLine, rgcStripe0, rgcStripe1);
   Declared in DbAGrids unit.}
  lAltColorsArr: array[0..2, TdagColorName] of TColor = (
    (0, clSilver, clBlack, clBtnFace, 0, 0, clSilver, 0, 0),
    (clSilver, clSilver, clWindowFrame, clBtnFace,
    clBtnShadow, clWindow, clBlack, clWindow, clDagSkyBlue),
    (clSilver, clSilver, clBtnShadow, clWindow,
    clBtnShadow, clWindow, clBlack, clWindow, clDagSkyBlue));

var
  I: TdagColorName;

begin
  if (rgTable.ItemIndex >= 0) and (rgStyle.ItemIndex >= 0) then
    with dmDataModule.dsDataSource, dagGrid do begin
      if DataSet <> nil then DataSet.Close;
      DataSet := nil;

      Columns.LoadFromFile(ExtractFilePath(Application.ExeName)
        + ColumnsFileNameArr[rgTable.ItemIndex, rgStyle.ItemIndex]);

      Options := lClassicOptions;
      AltOptions := lAltOptionsArr[rgStyle.ItemIndex];
      for I := dagcBandLine to dagcStripe1 do
        AltColors[I] := lAltColorsArr[rgStyle.ItemIndex, I];
      if rgStyle.ItemIndex = 2 then
        Ctl3D := False
      else Ctl3D := True;

      case rgTable.ItemIndex of
        0: begin
            if rgStyle.ItemIndex = 1 then
              dmDataModule.tblCastoly.IndexFieldNames := 'Last_Name;First_Name'
            else dmDataModule.tblCastoly.IndexFieldNames := '';
            DataSet := dmDataModule.tblCastoly;
            CheckSortMark;
            if rgStyle.ItemIndex < 2 then
              dagMemo1.DisplayStyle := bdsAll
            else dagMemo1.DisplayStyle := bdsSelected;
          end;
        1: begin
            DataSet := dmDataModule.tblEvents;
            case rgStyle.ItemIndex of
              0: ;
              1: begin
                  dagMemo1.DisplayStyle := bdsAll;
                  dagGraphic1.DisplayStyle := bdsAll;
                  if BandCount > 1 then BandHeights[1] := 4 * DefaultBandHeight;
                end;
              2: begin
                  dagMemo1.DisplayStyle := bdsSelected;
                  dagGraphic1.DisplayStyle := bdsSelected;
                  if BandCount > 1 then BandHeights[1] := 4 * DefaultBandHeight div 3;
                end;
            end;
          end;
        2: begin
            DataSet := dmDataModule.tblReservat;
            with dagBoolean1 do
              if rgStyle.ItemIndex = 1 then begin
                AllowNull := True;
                ImageIndexFalse := 0;
                ImageIndexNull := 1;
                ImageIndexTrue := 2;
              end
              else begin
                AllowNull := False;
                ImageIndexFalse := -1;
                ImageIndexNull := -1;
                ImageIndexTrue := -1;
              end;
            if rgStyle.ItemIndex = 2 then AltColors[dagcFlatBorder] := clBtnFace;
            AltOptions := AltOptions - [dagStripedRows];
          end;
      end;

      try
        DataSet.Open;
      finally
      end;

      GetOptions;
      GetRichOptions;
    end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.SetAlignment(Sender: TObject);
var
  lAlignment: TAlignment;
begin
  if lbAlignment.ItemIndex >= 0 then begin
    lAlignment := taLeftJustify;
    if rbCenter.Checked then
      lAlignment := taCenter
    else
      if rbRight.Checked then
        lAlignment := taRightJustify;
    with dagGrid do
      case lbAlignment.ItemIndex of
        0: Columns[SelectedIndex].Alignment := lAlignment;
        1: Columns[SelectedIndex].Title.Alignment := lAlignment;
        2: TdagColumn(Columns[SelectedIndex]).TitleExpanded.Alignment := lAlignment;
      end;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.SetOptions(Sender: TObject);
var
  lOptions: TDBGridOptions;
begin
  if FLock = 0 then begin
    lOptions := [];
    if cbAlwaysShowEditor.Checked then Include(lOptions, dgAlwaysShowEditor);
    if cbTitles.Checked then Include(lOptions, dgTitles);
    if cbIndicator.Checked then Include(lOptions, dgIndicator);
    if cbColumnResize.Checked then Include(lOptions, dgColumnResize);
    if cbColLines.Checked then Include(lOptions, dgColLines);
    if cbRowLines.Checked then Include(lOptions, dgRowLines);
    if cbTabs.Checked then Include(lOptions, dgTabs);
    if cbRowSelect.Checked then Include(lOptions, dgRowSelect);
    if cbAlwaysShowSelection.Checked then Include(lOptions, dgAlwaysShowSelection);
    if cbConfirmDelete.Checked then Include(lOptions, dgConfirmDelete);
    if cbCancelOnExit.Checked then Include(lOptions, dgCancelOnExit);
    if cbMultiSelect.Checked then Include(lOptions, dgMultiSelect);
    dagGrid.Options := lOptions;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.SetAltOptions(Sender: TObject);
var
  lAltOptions: TdagOptions;
begin
  if FLock = 0 then begin
    lAltOptions := [];
    if cbAppendCtrlIns.Checked then Include(lAltOptions, dagAppendCtrlIns);
    if cbBandLines.Checked then Include(lAltOptions, dagBandLines);
    if cbBandResize.Checked then Include(lAltOptions, dagBandResize);
    if cbCellHint.Checked then Include(lAltOptions, dagCellHint);
    if cbColumnAltResize.Checked then Include(lAltOptions, dagColumnAltResize);
    if cbDiscreteBandHeight.Checked then Include(lAltOptions, dagDiscreteBandHeight);
    if cbEnterLikeTab.Checked then Include(lAltOptions, dagEnterLikeTab);
    if cbExpandedBottomBar.Checked then Include(lAltOptions, dagExpandedBottomBar);
    if cbExpandIcon.Checked then Include(lAltOptions, dagExpandIcon);
    if cbStripedRows.Checked then Include(lAltOptions, dagStripedRows);
    if cbHeaderFocusRect.Checked then Include(lAltOptions, dagTitleFocusRect);
    if cbHeaderPush.Checked then Include(lAltOptions, dagTitlePush);
    dagGrid.AltOptions := lAltOptions;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.FormShow(Sender: TObject);
{------------------------------------}
  function TableAbsent(const ATable: TTable; const ATableName: string): Boolean;
  begin
    Result := True;
    with ATable do
    try
      try
        Open;
        Result := False;
      except
        on Exception do begin
          DatabaseName := '';
          TableName := ExtractFilePath(Application.ExeName) + ATableName;
          try
            Open;
            Result := False;
          except
            on Exception do ;
          end;
        end;
      end;
    finally
      Close;
    end;
  end;
{------------------------------------}
begin
  if TableAbsent(dmDataModule.tblCastoly, 'custoly.db')
    or TableAbsent(dmDataModule.tblEvents, 'events.db')
    or TableAbsent(dmDataModule.tblReservat, 'reservat.db') then
    ShowMessage('  DbAltGrid demo program assumes that an alias DBDEMOS exists' + #13
      + 'and that CUSTOLY.DB, EVENTS.DB, RESERVAT.DB, and related files' + #13
      + 'are contained within this alias.' + #13
      + '  If this is not the case, this alias and/or tables will have to be reinstalled.' + #13
      + 'You can downlod demo tables from http://www.dbaltgrid.com/download.htm' + #13
      + 'and place them into demo directory, alternatively.');
  ChangeLook(Sender);
end;
{--------------------------------------------------------------------------}

procedure TfmMain.cbCtrl3DClick(Sender: TObject);
begin
  if FLock = 0 then dagGrid.Ctl3D := not dagGrid.Ctl3D;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.cbEnabledClick(Sender: TObject);
begin
  if FLock = 0 then dagGrid.Enabled := not dagGrid.Enabled;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.sbColorClick(Sender: TObject);
begin
  if lbColor.ItemIndex >= 0 then begin
    ColorDialog.Color := GetColor(lbColor.ItemIndex);
    if ColorDialog.Execute then SetColor(lbColor.ItemIndex, ColorDialog.Color);
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.sbFontClick(Sender: TObject);
begin
  if lbFont.ItemIndex >= 0 then begin
    FontDialog.Font := GetFont(lbFont.ItemIndex);
    if FontDialog.Execute then SetFont(lbFont.ItemIndex, FontDialog.Font);
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.sbSaveClick(Sender: TObject);
begin
  with dmDataModule.SaveDialog do begin
    Filter := 'Columns files (*.col)|*.col|All files (*.*)|*.*';
    FileName := ExtractFilePath(Application.ExeName) + 'Demo.col';
    if Execute then dagGrid.Columns.SaveToFile(FileName);
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.sbLoadClick(Sender: TObject);
begin
  with dmDataModule.OpenDialog do begin
    Filter := 'Columns files (*.col)|*.col|All files (*.*)|*.*';
    FileName := ExtractFilePath(Application.ExeName) + '*.col';
    if Execute then dagGrid.Columns.LoadFromFile(FileName);
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.rgSortMarkClick(Sender: TObject);
begin
  with dagGrid, TdagColumn(Columns[SelectedIndex]) do
    case rgSortMark.ItemIndex of
      0: SortMark := smNone;
      1: SortMark := smMarkAscending;
      2: SortMark := smMarkDescending;
    end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.speIconMainChange(Sender: TObject);
begin
  with dagGrid do
    TdagColumn(Columns[SelectedIndex]).ImageIndex := speIconMain.Value;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.speIconExpandedChange(Sender: TObject);
begin
  with dagGrid do
    TdagColumn(Columns[SelectedIndex]).ImageIndexExpanded := speIconExpanded.Value;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.dagGridEditButtonClick(Sender: TObject);
var
  lField: TField;
begin
  with fmBlobEdit, dagGrid, dmDataModule.dsDataSource.DataSet do begin
    lField := SelectedField;
    if (lField <> nil) and (lField.DataType in [ftMemo, ftGraphic]) then begin
      if lField.DataType = ftMemo then begin
        dbmMemo.Show;
        dbiGraphic.Hide;
        dbmMemo.DataField := lField.FullName;
      end
      else begin
        dbiGraphic.Show;
        dbmMemo.Hide;
        dbiGraphic.DataField := lField.FullName;
      end;
      Caption := Columns[SelectedIndex].Title.Caption;
      Edit;
      try
        ShowModal;
        case ModalResult of
          mrOk: Post;
          mrCancel: Cancel;
        end;
      finally
        CheckBrowseMode;
      end;
      dbmMemo.DataField := '';
      dbiGraphic.DataField := '';
    end;
  end;
end;
{--------------------------------------------------------------------------}

procedure TfmMain.dagGridTitleClick(Column: TColumn);
var
  lFieldName, lIndexFieldNames: string;
begin
  if (dmDataModule.dsDataSource.DataSet = dmDataModule.tblCastoly)
    and (rgStyle.ItemIndex > 0) then begin
    lFieldName := Column.FieldName;
    lIndexFieldNames := '';
    if AnsiCompareText(lFieldName, 'CustNo') = 0 then
      lIndexFieldNames := 'CustNo'
    else
      if (AnsiCompareText(lFieldName, 'Name') = 0)
        or (AnsiCompareText(lFieldName, 'Last_Name') = 0)
        or (AnsiCompareText(lFieldName, 'First_Name') = 0) then
        lIndexFieldNames := 'Last_Name;First_Name';
    if lIndexFieldNames <> '' then begin
      TTable(dmDataModule.dsDataSource.DataSet).IndexFieldNames := lIndexFieldNames;
      CheckSortMark;
    end;
  end;
end;
{--------------------------------------------------------------------------}


end.

