CREATE DATABASE '.\Demo.GDB' USER 'SYSDBA' PASSWORD 'masterkey'PAGE_SIZE 4096;

CREATE TABLE CUSTOMER (
    CUSTNO DOUBLE PRECISION NOT NULL,
    COMPANY VARCHAR(30),
    ADDR1 VARCHAR(30),
    ADDR2 VARCHAR(30),
    CITY VARCHAR(15),
    STATE VARCHAR(20),
    ZIP VARCHAR(10),
    COUNTRY VARCHAR(20),
    PHONE VARCHAR(15),
    FAX VARCHAR(15),
    TAXRATE DOUBLE PRECISION,
    CONTACT VARCHAR(20),
    LASTINVOICEDATE DATE);

COMMIT WORK;

CREATE TABLE ITEMS (
    ORDERNO DOUBLE PRECISION,
    ITEMNO DOUBLE PRECISION,
    PARTNO DOUBLE PRECISION,
    QTY INTEGER,
    DISCOUNT DOUBLE PRECISION);

COMMIT WORK;

CREATE TABLE ORDERS (
    ORDERNO DOUBLE PRECISION NOT NULL,
    CUSTNO DOUBLE PRECISION NOT NULL,
    SALEDATE DATE,
    SHIPDATE DATE,
    EMPNO INTEGER NOT NULL,
    SHIPTOCONTACT VARCHAR(20),
    SHIPTOADDR1 VARCHAR(30),
    SHIPTOADDR2 VARCHAR(30),
    SHIPTOCITY VARCHAR(15),
    SHIPTOSTATE VARCHAR(20),
    SHIPTOZIP VARCHAR(10),
    SHIPTOCOUNTRY VARCHAR(20),
    SHIPTOPHONE VARCHAR(15),
    SHIPVIA VARCHAR(7),
    PO VARCHAR(15),
    TERMS VARCHAR(6),
    PAYMENTMETHOD VARCHAR(7),
    ITEMSTOTAL DOUBLE PRECISION,
    TAXRATE DOUBLE PRECISION,
    FREIGHT DOUBLE PRECISION,
    AMOUNTPAID DOUBLE PRECISION);

COMMIT WORK;

CREATE TABLE PARTS (
    PARTNO DOUBLE PRECISION,
    VENDORNO DOUBLE PRECISION,
    DESCRIPTION VARCHAR(30),
    ONHAND DOUBLE PRECISION,
    ONORDER DOUBLE PRECISION,
    COST DOUBLE PRECISION,
    LISTPRICE DOUBLE PRECISION);

COMMIT WORK;

INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1221, 'Kauai Dive Shoppe', '4-976 Sugarloaf Hwy', 'Suite 103', 'Kapaa Kauai', 'HI', '94766-1234', 'US', '808-555-0269', '808-555-0278', 8.5, 'Erica Norman', '02/02/1995 01:05:03');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1231, 'Unisco', 'PO Box Z-547', NULL, 'Freeport', NULL, NULL, 'Bahamas', '809-555-3915', '809-555-4958', 0, 'George Weathers', '11/17/1994 14:10:33');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1351, 'Sight Diver', '1 Neptune Lane', NULL, 'Kato Paphos', NULL, NULL, 'Cyprus', '357-6-876708', '357-6-870943', 0, 'Phyllis Spooner', '10/18/1994 19:20:30');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1354, 'Cayman Divers World Unlimited', 'PO Box 541', NULL, 'Grand Cayman', NULL, NULL, 'British West Indies', '011-5-697044', '011-5-697064', 0, 'Joe Bailey', '01/30/1992 02:00:56');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1356, 'Tom Sawyer Diving Centre', '632-1 Third Frydenhoj', NULL, 'Christiansted', 'St. Croix', '00820', 'US Virgin Islands', '504-798-3022', '504-798-7772', 0, 'Chris Thomas', '03/20/1992 09:35:40');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1380, 'Blue Jack Aqua Center', '23-738 Paddington Lane', 'Suite 310', 'Waipahu', 'HI', '99776', 'US', '401-609-7623', '401-609-9403', 0, 'Ernest Barratt', '11/08/1994 23:22:08');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1384, 'VIP Divers Club', '32 Main St.', NULL, 'Christiansted', 'St. Croix', '02800', 'US Virgin Islands', '809-453-5976', '809-453-5932', 0, 'Russell Christopher', '02/01/1995 18:45:23');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1510, 'Ocean Paradise', 'PO Box 8745', NULL, 'Kailua-Kona', 'HI', '94756', 'US', '808-555-8231', '808-555-8450', 0, 'Paul Gardner', '11/09/1994 01:22:22');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1513, 'Fantastique Aquatica', 'Z32 999 #12A-77 A.A.', NULL, 'Bogota', NULL, NULL, 'Columbia', '057-1-773434', '057-1-773421', 0, 'Susan Wong', '07/18/1994 17:17:01');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1551, 'Marmot Divers Club', '872 Queen St.', NULL, 'Kitchener', 'Ontario', 'G3N 2E1', 'Canada', '416-698-0399', '426-698-0399', 0, 'Joyce Marsh', '07/07/1990 04:20:58');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1560, 'The Depth Charge', '15243 Underwater Fwy.', NULL, 'Marathon', 'FL', '35003', 'US', '800-555-3798', '800-555-0353', 0, 'Sam Witherspoon', '04/09/1994 08:14:52');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1563, 'Blue Sports', '203 12th Ave. Box 746', NULL, 'Giribaldi', 'OR', '91187', 'US', '610-772-6704', '610-772-6898', 0, 'Theresa Kunec', '05/09/1991 12:05:42');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1624, 'Makai SCUBA Club', 'PO Box 8534', NULL, 'Kailua-Kona', 'HI', '94756', 'US', '317-649-9098', '317-649-6787', 0, 'Donna Siaus', '01/07/1995 13:55:30');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1645, 'Action Club', 'PO Box 5451-F', NULL, 'Sarasota', 'FL', '32274', 'US', '813-870-0239', '813-870-0282', 0, 'Michael Spurling', '10/18/1993 14:18:06');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1651, 'Jamaica SCUBA Centre', 'PO Box 68', NULL, 'Negril', 'Jamaica', NULL, 'West Indies', '011-3-697043', '011-3-697043', 0, 'Barbara Harvey', '08/25/1992 00:19:50');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1680, 'Island Finders', '6133 1/3 Stone Avenue', NULL, 'St Simons Isle', 'GA', '32521', 'US', '713-423-5675', '713-423-5676', 0, 'Desmond Ortega', '01/02/1995 09:33:40');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (1984, 'Adventure Undersea', 'PO Box 744', NULL, 'Belize City', NULL, NULL, 'Belize', '011-34-09054', '011-34-09064', 0, 'Gloria Gonzales', '11/06/1994 16:35:42');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2118, 'Blue Sports Club', '63365 Nez Perce Street', NULL, 'Largo', 'FL', '34684', 'US', '612-897-0342', '612-897-0348', 0, 'Harry Bathbone', '06/08/1990 11:21:06');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2135, 'Frank''s Divers Supply', '1455 North 44th St.', NULL, 'Eugene', 'OR', '90427', 'US', '503-555-2778', '503-555-2769', 0, 'Lloyd Fellows', '06/24/1989 10:29:46');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2156, 'Davy Jones'' Locker', '246 South 16th Place', NULL, 'Vancouver', 'BC', 'K8V 9P1', 'Canada', '803-509-0112', '803-509-0553', 0, 'Tanya Wagner', '11/05/1991 00:20:30');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2163, 'SCUBA Heaven', 'PO Box Q-8874', NULL, 'Nassau', NULL, NULL, 'Bahamas', '011-32-09485', '011-32-09485', 0, 'Robert Michelind', '12/24/1990 19:18:52');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2165, 'Shangri-La Sports Center', 'PO Box D-5495', NULL, 'Freeport', NULL, NULL, 'Bahamas', '011-32-08574', '011-32-44938', 0, 'Frank Paniagua', '07/03/1989 15:32:49');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2315, 'Divers of Corfu, Inc.', 'Marmoset Place 54', NULL, 'Ayios Matthaios', 'Corfu', NULL, 'Greece', '30-661-88364', '30-661-05943', 0, 'Charles Lopez', '06/13/1994 08:20:32');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2354, 'Kirk Enterprises', '42 Aqua Lane', NULL, 'Houston', 'TX', '77079', 'US', '713-556-6437', '713-556-1073', 0, 'Rudolph Claus', '02/08/1994 14:37:45');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2975, 'George Bean & Co.', '#73 King Salmon Way', NULL, 'Lugoff', 'NC', '29078', 'US', '803-438-2771', '803-438-3003', 0, 'Bill Wyers', '04/06/1994 00:20:54');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (2984, 'Professional Divers, Ltd.', '4734 Melinda St.', NULL, 'Hoover', 'AL', '32145', 'US', '205-555-8333', '205-555-4054', 0, 'Shirley Mathers', '05/05/1994 17:18:11');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3041, 'Divers of Blue-green', '634 Complex Ave.', NULL, 'Pelham', 'AL', '32145', 'US', '205-555-7184', '205-555-6059', 0, 'Nancy Bean', '02/28/1994 19:29:34');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3042, 'Gold Coast Supply', '223-B Houston Place', NULL, 'Mobile', 'AL', '30696', 'US', '205-555-2640', '205-555-4094', 0, 'Elaine Falls', '07/12/1994 02:01:44');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3051, 'San Pablo Dive Center', '1701-D N Broadway', NULL, 'Santa Maria', 'CA', '95443', 'US', '823-044-2910', '823-044-2990', 0, 'Patricia O''Brien', '07/21/1994 08:40:05');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3052, 'Underwater Sports Co.', '351-A Sarasota St.', NULL, 'San Jose', 'CA', '92195', 'US', '408-867-0594', '408-867-0094', 0, 'Dave Walling', '09/24/1994 15:07:24');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3053, 'American SCUBA Supply', '1739 Atlantic Avenue', NULL, 'Lomita', 'CA', '91770', 'US', '213-654-0092', '213-654-0095', 0, 'Lynn Cinciripini', '01/04/1995 13:38:47');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3054, 'Catamaran Dive Club', 'Box 264 Pleasure Point', NULL, 'Catalina Island', 'CA', '90740', 'US', '213-223-0941', '213-223-2324', 0, 'Nicole Dupont', '10/20/1994 00:00:28');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3055, 'Diver''s Grotto', '24601 Universal Lane', NULL, 'Downey', 'CA', '94220', 'US', '213-432-0093', '213-432-4821', 0, 'Peter Owen', '11/26/1994 17:38:49');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3151, 'Fisherman''s Eye', 'PO Box 7542', NULL, 'Grand Cayman', NULL, NULL, 'British West Indies', '809-555-4680', '809-555-4689', 0, 'Bethan Lewis', '08/01/1994 04:39:24');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3158, 'Action Diver Supply', 'Blue Spar Box #3', NULL, 'St. Thomas', NULL, '00820', 'US Virgin Islands', '22-44-500211', '22-44-500596', 0, 'Marianne Miles', '08/29/1993 02:50:55');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3615, 'Marina SCUBA Center', 'PO Box 82438 Zulu 7831', NULL, 'Caracas', NULL, NULL, 'Venezuela', '58-33-66222', '58-33-66049', 0, 'Stephen Bryant', '05/11/1993 20:24:30');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (3984, 'Blue Glass Happiness', '6345 W. Shore Lane', NULL, 'Santa Monica', 'CA', '90410', 'US', '213-555-1984', '213-555-1995', 0, 'Christine Taylor', '12/02/1994 00:00:07');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (4312, 'Divers of Venice', '220 Elm Street', NULL, 'Venice', 'FL', '39224', 'US', '813-443-2356', '813-443-9842', 0, 'Simone Green', '10/25/1993 20:22:30');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (4531, 'On-Target SCUBA', '7-73763 Nanakawa Road', NULL, 'Winnipeg', 'Manitoba', 'J2R 5T3', 'Canada', '416-445-0988', '416-445-0223', 0, 'Bram Phillips', '01/09/1994 04:32:48');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (4652, 'Jamaica Sun, Inc.', 'PO Box 643', NULL, 'Runaway Bay', 'Jamaica', NULL, 'West Indies', '809-555-2746', '809-555-0929', 0, 'Jonathan West', '12/16/1994 05:30:33');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (4684, 'Underwater Fantasy', 'PO Box 842', NULL, 'Ocho Rios', 'Jamaica', NULL, 'West Indies', '809-555-2214', '809-555-2234', 0, 'Grant Ainsworth', '08/25/1994 18:50:42');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5132, 'Princess Island SCUBA', 'PO Box 32 Waiyevo', NULL, 'Taveuni', NULL, NULL, 'Fiji', '679-311923', '679-311203', 0, 'Anne Mariachi', '12/30/1989 09:20:17');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5151, 'Central Underwater Supplies', 'PO Box 737', NULL, 'Johannesburg', NULL, '2042', 'Republic So. Africa', '27-11-4432458', '27-11-4433259', 0, 'Maria Eventosh', '11/13/1994 01:40:23');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5163, 'Safari Under the Sea', 'PO Box 7456', NULL, 'Grand Cayman', NULL, NULL, 'British West Indies', '809-409-4233', '809-409-3002', 0, 'Anna Rack', '09/15/1993 18:35:30');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5165, 'Larry''s Diving School', '3562 NW Bruce Street', NULL, 'Milwaukie', 'OR', '96277', 'US', '503-403-7777', '503-403-0059', 0, 'Isabelle Neece', '05/21/1994 23:02:57');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5384, 'Tora Tora Tora', 'PO Box H-4573', NULL, 'Nassau', NULL, NULL, 'Bahamas', '809-898-0043', '809-898-9864', 0, 'Kevin Rider', '02/05/1995 05:40:46');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5412, 'Vashon Ventures', '743 Keyhole Court', NULL, 'Honolulu', 'HI', '92856', 'US', '532-099-0423', '532-099-6654', 0, 'Susan Smith', '01/18/1994 01:45:50');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5432, 'Divers-for-Hire', 'G.O. P Box 91', NULL, 'Suva', NULL, NULL, 'Fiji', '679-804576', '679-059345', 0, 'Joe Hatter', '01/28/1994 20:02:48');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (5515, 'Ocean Adventures', 'PO Box 466 Kihei', NULL, 'Maui', 'HI', '95736', 'US', '776-868-9334', '776-868-9553', 0, 'Paul Still', '01/08/1995 16:35:40');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (6215, 'Underwater SCUBA Company', 'PO Box Sn 91', NULL, 'Somerset', NULL, 'SXBN', 'Bermuda', '809-555-1225', '809-555-2445', 0, 'Michael Grossman', '04/07/1994 23:32:50');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (6312, 'Aquatic Drama', '921 Everglades Way', NULL, 'Tampa', 'FL', '30643', 'US', '613-442-7654', '613-442-7678', 0, 'Gillian Owen', '03/25/1989 04:42:52');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (6516, 'The Diving Company', 'PO Box 8535', NULL, 'St. Thomas', NULL, '00820', 'US Virgin Islands', '22-44-50098', '22-44-09878', 0, 'Brian Miles', '01/15/1994 12:40:50');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (6582, 'Norwest''er SCUBA Limited', 'PO Box 6834', NULL, 'Paget', NULL, 'PSBZ', 'Bermuda', '778-123-0745', '778-123-9705', 0, 'Angela Jones', '02/03/1995 06:47:30');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (6812, 'Waterspout SCUBA Center', '7865 NE Barber Ct.', NULL, 'Portland', 'OR', '99271', 'US', '503-654-2434', '503-654-9986', 0, 'Richard Houser', '10/11/1994 10:11:33');
INSERT INTO CUSTOMER (CUSTNO, COMPANY, ADDR1, ADDR2, CITY, STATE, ZIP, COUNTRY, PHONE, FAX, TAXRATE, CONTACT, LASTINVOICEDATE) VALUES (9841, 'Neptune''s Trident Supply', 'PO Box 129', NULL, 'Negril', 'Jamaica', NULL, 'West Indies', '778-897-3546', '778-897-6643', 0, 'Louise Franks', '11/01/1995 06:32:05');

COMMIT WORK;

INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1003, 1, 1313, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1004, 1, 1313, 10, 50);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1004, 2, 12310, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1004, 3, 3316, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1004, 4, 5324, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1005, 1, 1320, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1005, 2, 2367, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1005, 3, 11564, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1005, 4, 7612, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1005, 5, 1946, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1006, 1, 900, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1006, 2, 1313, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1006, 3, 1390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1006, 4, 11564, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1006, 5, 12301, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1007, 1, 1316, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1007, 2, 1946, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1008, 1, 1313, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1008, 2, 11635, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1009, 1, 1320, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1009, 2, 1328, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1009, 3, 1364, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1009, 4, 12306, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1010, 1, 11238, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1011, 1, 5386, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1011, 2, 11652, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1012, 1, 2350, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1012, 2, 2367, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1012, 3, 12306, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1013, 1, 2341, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1013, 2, 5378, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1014, 1, 7612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1015, 1, 912, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1015, 2, 1330, 45, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1015, 3, 2367, 45, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1015, 4, 7612, 65, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1016, 1, 1313, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1016, 2, 2341, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1017, 1, 1986, 45, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1017, 2, 2314, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1017, 3, 2341, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1017, 4, 2350, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1018, 1, 1946, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1018, 2, 2367, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1019, 1, 2367, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1019, 2, 7619, 120, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1020, 1, 900, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1020, 2, 9354, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1021, 1, 5313, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1021, 2, 12303, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1021, 3, 12317, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1022, 1, 5318, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1022, 2, 9312, 54, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1023, 1, 1313, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1023, 2, 2383, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1023, 3, 1330, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1024, 1, 900, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1024, 2, 2367, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1025, 1, 1320, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1025, 2, 5313, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1026, 1, 1390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1026, 2, 3316, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1027, 1, 900, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1027, 2, 1390, 45, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1028, 1, 2350, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1028, 2, 5318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1029, 1, 1328, 46, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1029, 2, 5313, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1030, 1, 2619, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1030, 2, 11635, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1031, 1, 3326, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1031, 2, 11221, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1032, 1, 5349, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1032, 2, 5386, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1033, 1, 2613, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1033, 2, 5313, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1034, 1, 900, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1034, 2, 2630, 54, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1035, 1, 5386, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1036, 1, 2341, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1036, 2, 2954, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1037, 1, 3316, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1037, 2, 9312, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1038, 1, 1986, 54, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1039, 1, 1946, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1039, 2, 5318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1040, 1, 2632, 23, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1040, 2, 5324, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1041, 1, 2343, 32, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1041, 2, 5313, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1042, 1, 2657, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1042, 2, 11635, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1043, 1, 900, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1043, 2, 2341, 35, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1044, 1, 5313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1044, 2, 11518, 32, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1045, 1, 3386, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1045, 2, 5318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1046, 1, 5313, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1046, 2, 11635, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1047, 1, 900, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1048, 1, 3316, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1048, 2, 12316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1049, 1, 2954, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1049, 2, 7619, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1050, 1, 3340, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1050, 2, 5318, 35, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1050, 3, 5378, 42, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1050, 4, 11635, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1051, 1, 5349, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1052, 1, 5313, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1052, 2, 11221, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1053, 1, 5356, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1053, 2, 5324, 56, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1053, 3, 11238, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1054, 1, 11518, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1054, 2, 12301, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1055, 1, 2367, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1055, 2, 2954, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1055, 3, 12386, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1055, 4, 13545, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1056, 1, 5318, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1056, 2, 11221, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1057, 1, 3340, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1058, 1, 5313, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1058, 2, 11238, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1059, 1, 3316, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1060, 1, 5324, 45, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1060, 2, 5349, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1060, 3, 11518, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1060, 4, 12301, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1061, 1, 2954, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1061, 2, 3386, 45, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1061, 3, 11635, 54, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1062, 1, 2954, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1062, 2, 13545, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1063, 1, 5313, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1063, 2, 5318, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1063, 3, 11221, 23, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1063, 4, 12386, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1064, 1, 3340, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1065, 1, 5324, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1065, 2, 11238, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1066, 1, 2367, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1066, 2, 3386, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1066, 3, 12301, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1066, 4, 13545, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1067, 1, 12317, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1068, 1, 2954, 43, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1068, 2, 12316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1069, 1, 3316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1069, 2, 5318, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1069, 3, 5324, 34, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1069, 4, 5349, 87, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1069, 5, 11518, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1069, 6, 11635, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1069, 7, 12316, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1070, 1, 3340, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1070, 2, 11238, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1071, 1, 3386, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1071, 2, 12301, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1071, 3, 13545, 43, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1072, 1, 12317, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1073, 1, 2954, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1073, 2, 11221, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1074, 1, 12310, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1075, 1, 5324, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1075, 2, 5349, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1075, 3, 12316, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1076, 1, 11221, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1076, 2, 11518, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1076, 3, 1946, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1077, 1, 2367, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1078, 1, 2954, 34, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1078, 2, 3340, 54, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1078, 3, 3386, 65, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1078, 4, 11238, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1079, 1, 11635, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1079, 2, 1316, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1080, 1, 3316, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1080, 2, 12301, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1080, 3, 13545, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1081, 1, 12317, 34, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1082, 1, 2619, 71, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1083, 1, 2619, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1083, 2, 2954, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1083, 3, 3386, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1083, 4, 5349, 89, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1084, 1, 3340, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1086, 1, 2367, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1086, 2, 11518, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1087, 1, 2619, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1087, 2, 5324, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1089, 1, 2367, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1089, 2, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1090, 1, 3386, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1090, 2, 11221, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1091, 1, 2954, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1092, 1, 3316, 55, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1092, 2, 3340, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1092, 3, 5318, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1092, 4, 12306, 26, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1093, 1, 11635, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1094, 1, 2619, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1094, 2, 5324, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1094, 3, 5349, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1094, 4, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1094, 5, 12301, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1095, 1, 2954, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1095, 2, 5318, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1095, 3, 12317, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1096, 1, 3340, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1096, 2, 3386, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1096, 3, 11238, 45, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1096, 4, 13545, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1097, 1, 11518, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1097, 2, 11635, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1098, 1, 5318, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1098, 2, 5324, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1098, 3, 5349, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1099, 1, 2619, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1099, 2, 3386, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1100, 1, 2619, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1100, 2, 2954, 5, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1100, 3, 3340, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 1, 1316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 2, 1390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 3, 2632, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 4, 2954, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 5, 5349, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 6, 7612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 7, 11221, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1101, 8, 12301, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1102, 1, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1102, 2, 2350, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1102, 3, 9312, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1102, 4, 9318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 1, 1313, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 2, 1316, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 3, 1364, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 4, 1390, 21, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 5, 2341, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 6, 2383, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 7, 2390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 8, 2613, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 9, 3340, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 10, 3386, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 11, 5313, 11, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 12, 5324, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 13, 5349, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 14, 5356, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 15, 5386, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 264, 7619, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 265, 7654, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 266, 9316, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 267, 11221, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 268, 11518, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1103, 269, 11635, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 1, 1313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 2, 1314, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 3, 1316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 4, 1320, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 5, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 6, 1390, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 7, 1946, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 8, 1986, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 9, 2314, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 10, 2343, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 11, 2350, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 12, 2367, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 13, 2383, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 14, 2390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 15, 2612, 19, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 285, 2619, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 286, 2630, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 287, 2632, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 288, 2648, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 289, 2954, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 290, 3316, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 291, 3326, 23, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 292, 3386, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 293, 5318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 294, 5324, 17, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 295, 5349, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 296, 5386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 297, 7612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 298, 7619, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 299, 7654, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 300, 9316, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 301, 9318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 302, 11238, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 303, 11564, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1104, 304, 12303, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1105, 1, 1313, 18, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1105, 2, 1320, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1105, 3, 2612, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1105, 4, 3340, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1105, 5, 3386, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1105, 6, 11518, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1106, 1, 1314, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1106, 2, 1986, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1106, 3, 2314, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1106, 4, 2632, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1106, 5, 2648, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1106, 6, 7654, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 1, 1328, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 2, 1364, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 3, 1946, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 4, 2343, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 5, 2630, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 6, 5349, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 7, 11238, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 8, 11518, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1107, 9, 12301, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1109, 1, 5324, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1109, 2, 5386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1111, 1, 1364, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1111, 2, 2343, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1111, 3, 3326, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1111, 4, 5313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1111, 5, 5356, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1111, 6, 7654, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1111, 7, 11518, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1112, 1, 1330, 18, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1112, 2, 2341, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1112, 3, 3340, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1112, 4, 5356, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1113, 1, 2632, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1113, 2, 2648, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1113, 3, 5313, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1113, 4, 5356, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1113, 5, 11635, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1113, 6, 11652, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1115, 1, 2350, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1115, 2, 3386, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1115, 3, 5318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 1, 900, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 2, 1313, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 3, 1320, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 4, 2343, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 5, 2632, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 6, 11221, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 7, 11238, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1116, 8, 12303, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1117, 1, 912, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1117, 2, 2341, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1117, 3, 5349, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1117, 4, 7619, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1118, 1, 1316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1118, 2, 2390, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1118, 3, 3340, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1118, 4, 5313, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1118, 5, 5378, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1118, 6, 9354, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1118, 7, 12303, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1119, 1, 2367, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1119, 2, 2619, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1119, 3, 2954, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1119, 4, 5313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1120, 1, 2341, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1120, 2, 3326, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1120, 3, 7654, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1121, 1, 1330, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1121, 2, 3326, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1122, 1, 1330, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1122, 2, 2390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1122, 3, 3326, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1122, 4, 11221, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1122, 5, 11238, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1123, 1, 1314, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1123, 2, 1314, 24, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1123, 3, 1986, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1123, 4, 2630, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1123, 5, 5324, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1123, 6, 5349, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 1, 900, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 2, 1364, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 3, 2390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 4, 2632, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 5, 3386, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 6, 9312, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 7, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1124, 8, 11518, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1125, 1, 900, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1125, 2, 1986, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1125, 3, 2341, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1125, 4, 5313, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1125, 5, 5318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1125, 6, 5356, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1125, 7, 12301, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1126, 1, 5378, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1126, 2, 11564, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1127, 1, 1330, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1127, 2, 3340, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1127, 3, 5313, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1127, 4, 11221, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1127, 5, 12301, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1128, 1, 1328, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1128, 2, 2343, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1128, 3, 3326, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1128, 4, 5356, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1128, 5, 5386, 13, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1128, 6, 9312, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1128, 7, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1129, 1, 7619, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1129, 2, 9316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1130, 1, 2390, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 1, 900, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 2, 1986, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 3, 2350, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 4, 2632, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 5, 3386, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 6, 5356, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 7, 5378, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1131, 8, 7654, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1132, 1, 2648, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1132, 2, 3316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1133, 1, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1133, 2, 1390, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1133, 3, 2314, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1133, 4, 5324, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1133, 5, 5349, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1134, 1, 1320, 23, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1134, 2, 2648, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1134, 3, 2657, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1134, 4, 5386, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1134, 5, 7612, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1134, 6, 12303, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 1, 1320, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 2, 1986, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 3, 2314, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 4, 2657, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 5, 3316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 6, 5356, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 7, 5378, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1136, 8, 5386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1137, 1, 1330, 17, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1137, 2, 2954, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1137, 3, 3386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1137, 4, 7654, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1137, 5, 9312, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 1, 1328, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 2, 2367, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 3, 5313, 21, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 4, 5318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 5, 7654, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 6, 9312, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 7, 11518, 19, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1139, 8, 11652, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1140, 1, 1946, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1140, 2, 2632, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1140, 3, 5324, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1141, 1, 2350, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1141, 2, 2632, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1141, 3, 2954, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1141, 4, 3326, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1142, 1, 1313, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1142, 2, 1986, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1142, 3, 2954, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1142, 4, 5386, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1143, 1, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1143, 2, 12301, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1144, 1, 1986, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1144, 2, 2630, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1144, 3, 3316, 18, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1144, 4, 3326, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1144, 5, 5324, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1144, 6, 5356, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1144, 7, 9312, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1145, 1, 1328, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1145, 2, 1390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1145, 3, 7612, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1145, 4, 12303, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1146, 1, 900, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1146, 2, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1146, 3, 1986, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1146, 4, 2367, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1146, 5, 2613, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1146, 6, 5386, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1148, 1, 1364, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1148, 2, 3326, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1148, 3, 5356, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1148, 4, 5378, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1148, 5, 9312, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1148, 6, 12303, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1149, 1, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1149, 2, 3316, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1149, 3, 5313, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1149, 4, 5378, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1149, 5, 7612, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1149, 6, 9312, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1149, 7, 11652, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 1, 1313, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 2, 1320, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 3, 1330, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 4, 3326, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 5, 3340, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 6, 5378, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 7, 7619, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1150, 8, 9312, 1, 0);

COMMIT WORK;

INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 1, 900, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 2, 912, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 3, 1313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 4, 1314, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 5, 1316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 6, 1320, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 7, 1328, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 8, 1330, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 9, 1364, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 10, 2314, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 11, 2341, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 12, 2343, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 13, 2350, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 14, 2612, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 15, 2648, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 527, 2954, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 528, 3326, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 529, 3340, 21, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 530, 5313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 531, 5356, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 532, 5378, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 533, 5386, 21, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 534, 7612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 535, 7619, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 536, 9312, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 537, 9316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 538, 9354, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 539, 11221, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 540, 11652, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 541, 12301, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1152, 542, 12303, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1153, 1, 2383, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1153, 2, 3316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1153, 3, 7612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1154, 1, 1330, 11, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1154, 2, 1364, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1154, 3, 2390, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1154, 4, 2612, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1154, 5, 5318, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1154, 6, 5324, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1154, 7, 5356, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 1, 912, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 2, 2341, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 3, 2343, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 4, 2383, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 5, 2619, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 6, 3326, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 7, 9354, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1155, 8, 12301, 11, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1156, 1, 1320, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1156, 2, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1156, 3, 5313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1156, 4, 9312, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1156, 5, 9354, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1156, 6, 11564, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 1, 1390, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 2, 1946, 19, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 3, 2383, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 4, 3326, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 5, 3340, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 6, 9312, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 7, 9318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1158, 8, 11635, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1160, 1, 1364, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1160, 2, 1390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1160, 3, 2613, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1160, 4, 5324, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1160, 5, 7612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1160, 6, 9354, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 1, 912, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 2, 1314, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 3, 1316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 4, 1320, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 5, 1364, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 6, 1390, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 7, 2343, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 8, 2350, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 9, 2367, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 10, 2390, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 11, 2612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 12, 2619, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 13, 2648, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 14, 3316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 15, 3340, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 596, 3386, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 597, 5324, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 598, 5349, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 599, 5356, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 600, 5386, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 601, 7654, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 602, 9312, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 603, 9354, 19, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 604, 11221, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 605, 11238, 23, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 606, 11518, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 607, 11564, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1161, 608, 11652, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1162, 1, 2383, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1162, 2, 2632, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1162, 3, 2648, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1162, 4, 5356, 18, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1162, 5, 9316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1163, 1, 1320, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1165, 1, 2314, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1165, 2, 2390, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1165, 3, 2612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1165, 4, 2613, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1165, 5, 9316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1165, 6, 9354, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 1, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 2, 1364, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 3, 1390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 4, 1946, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 5, 2630, 13, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 6, 2954, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 7, 5324, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 8, 9316, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1166, 9, 11238, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1168, 1, 2367, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 1, 912, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 2, 1330, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 3, 2657, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 4, 2954, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 5, 5356, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 6, 7654, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 7, 9318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1169, 8, 9354, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1170, 1, 1946, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1170, 2, 2314, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1170, 3, 2954, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1170, 4, 5318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1170, 5, 5356, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1171, 1, 1313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1171, 2, 1330, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1171, 3, 1946, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1171, 4, 7654, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1171, 5, 12301, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1173, 1, 2630, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1175, 1, 1320, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1175, 2, 7619, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1175, 3, 7654, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1175, 4, 9316, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1175, 5, 11221, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1175, 6, 11652, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1176, 1, 2619, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1176, 2, 2648, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1176, 3, 9316, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1176, 4, 11635, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1178, 1, 900, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1178, 2, 1390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1178, 3, 5324, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1178, 4, 7612, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1178, 5, 11652, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1178, 6, 12301, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1180, 1, 1390, 19, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1180, 2, 5324, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1183, 1, 912, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1183, 2, 2350, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1183, 3, 5313, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1183, 4, 7612, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1183, 5, 11518, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1195, 1, 900, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1195, 2, 1316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1195, 3, 1364, 11, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1195, 4, 2390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1196, 1, 1314, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1196, 2, 1320, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1196, 3, 3386, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1196, 4, 9316, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1197, 1, 1320, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1197, 2, 1986, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1197, 3, 2390, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1197, 4, 5313, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1197, 5, 9318, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 1, 1314, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 2, 1316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 3, 1328, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 4, 1390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 5, 1946, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 6, 2314, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 7, 2341, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 8, 2343, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 9, 2367, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 10, 2390, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 11, 2612, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 12, 2619, 17, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 13, 2657, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 14, 3316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 15, 3340, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 718, 5349, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 719, 5356, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 720, 5378, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 721, 9312, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 722, 9318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 723, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 724, 11518, 24, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1198, 725, 11652, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1199, 1, 2613, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1200, 1, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1200, 2, 9312, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1201, 1, 1364, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1201, 2, 1390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1201, 3, 9316, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1202, 1, 3326, 12, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1202, 2, 9316, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1202, 3, 9318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1204, 1, 912, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1204, 2, 1364, 11, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1204, 3, 2612, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1204, 4, 5318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1204, 5, 5324, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1204, 6, 9316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1204, 7, 12301, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 1, 912, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 2, 2343, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 3, 2383, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 4, 2619, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 5, 5386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 6, 7612, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 7, 7619, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1205, 8, 9312, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1207, 1, 900, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1207, 2, 1986, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1207, 3, 7619, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1207, 4, 7654, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1207, 5, 11238, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1209, 1, 2390, 21, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1209, 2, 3316, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1209, 3, 5349, 18, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1209, 4, 7654, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1209, 5, 11221, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1209, 6, 12303, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1212, 1, 2619, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1212, 2, 2630, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1212, 3, 2648, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1212, 4, 5386, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1212, 5, 9312, 17, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1215, 1, 2619, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1215, 2, 2632, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1215, 3, 2648, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1215, 4, 7612, 11, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1215, 5, 7619, 24, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1215, 6, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1215, 7, 11635, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1217, 1, 900, 18, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1217, 2, 1390, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1217, 3, 2390, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1217, 4, 2648, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1217, 5, 11221, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1217, 6, 11652, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1221, 1, 1316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1221, 2, 12303, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 1, 900, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 2, 912, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 3, 1314, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 4, 1316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 5, 1320, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 6, 1330, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 7, 1364, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 8, 1390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 9, 1946, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 10, 2314, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 11, 2341, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 12, 2343, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 13, 2350, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 14, 2383, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 15, 2613, 11, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 796, 2619, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 797, 2630, 9, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 798, 2657, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 799, 3326, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 800, 3340, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 801, 3386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 802, 5318, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 803, 5324, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 804, 7612, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 805, 9312, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 806, 9318, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 807, 9354, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 808, 11221, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 809, 11635, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 810, 11652, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 811, 12301, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1250, 812, 12303, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1253, 1, 1390, 19, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1253, 2, 2341, 13, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1253, 3, 7654, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 1, 900, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 2, 1320, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 3, 1390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 4, 2383, 21, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 5, 2390, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 6, 2630, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 7, 5318, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1255, 8, 12303, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1260, 1, 2657, 21, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1260, 2, 2954, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1260, 3, 3340, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1260, 4, 5313, 24, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1260, 5, 5318, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1261, 1, 11518, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 1, 912, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 2, 1313, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 3, 1314, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 4, 1316, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 5, 1320, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 6, 1328, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 7, 1330, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 8, 1364, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 9, 1390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 10, 1986, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 11, 2314, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 12, 2341, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 13, 2350, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 14, 2383, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 15, 2390, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 845, 2613, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 846, 2632, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 847, 2954, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 848, 3316, 24, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 849, 3326, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 850, 3386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 851, 5313, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 852, 5318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 853, 5324, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 854, 5349, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 855, 5356, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 856, 5378, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 857, 7612, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 858, 7619, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 859, 9316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 860, 9318, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 861, 11238, 13, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 862, 11518, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 863, 11564, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 864, 11635, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1263, 865, 12301, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1266, 1, 1314, 19, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1269, 1, 5378, 20, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1271, 1, 2367, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1271, 2, 2657, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 1, 1320, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 2, 1330, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 3, 2367, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 4, 2390, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 5, 2619, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 6, 2630, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 7, 2632, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 8, 2648, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 9, 2657, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 10, 3340, 23, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 11, 5378, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 12, 9312, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 13, 11652, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1275, 14, 12301, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1278, 1, 3316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1278, 2, 5356, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1278, 3, 9312, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1278, 4, 9318, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1278, 5, 11518, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1280, 1, 2954, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1280, 2, 7619, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1280, 3, 7654, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1280, 4, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1283, 1, 1316, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1283, 2, 1328, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1283, 3, 3340, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1283, 4, 5356, 8, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1283, 5, 9318, 13, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1283, 6, 9354, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 1, 1330, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 2, 1364, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 3, 2612, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 4, 2630, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 5, 5349, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 6, 5378, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 7, 5386, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 8, 9318, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1292, 9, 12303, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1294, 1, 1313, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1294, 2, 1328, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1294, 3, 2657, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1294, 4, 5318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1294, 5, 5356, 25, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1294, 6, 7654, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1295, 1, 1330, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1295, 2, 2343, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1295, 3, 2954, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1295, 4, 3316, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1295, 5, 11238, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1295, 6, 12303, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 1, 1328, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 2, 1330, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 3, 2619, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 4, 5386, 24, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 5, 7619, 10, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 6, 9312, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 7, 9316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1296, 8, 9318, 6, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1298, 1, 11564, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1300, 1, 2632, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1300, 2, 5318, 14, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1300, 3, 7654, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1300, 4, 9318, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1300, 5, 9354, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1300, 6, 11518, 24, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1300, 7, 12303, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1302, 1, 912, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1302, 2, 1314, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1302, 3, 1330, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1302, 4, 2341, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1302, 5, 2630, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1302, 6, 11238, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1302, 7, 11564, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1305, 1, 1314, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1305, 2, 2341, 22, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1305, 3, 9318, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1309, 1, 2630, 15, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1309, 2, 9318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1315, 1, 2341, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1315, 2, 2343, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1315, 3, 2350, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1315, 4, 2367, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1315, 5, 5318, 18, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1315, 6, 5324, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1315, 7, 11238, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1317, 1, 2314, 16, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1317, 2, 2343, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1317, 3, 2630, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1317, 4, 5386, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 1, 1316, 17, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 2, 1328, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 3, 1364, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 4, 2343, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 5, 5313, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 6, 5318, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 7, 5349, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1350, 8, 11635, 7, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1355, 1, 1328, 2, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1355, 2, 2954, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1355, 3, 3316, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1355, 4, 9312, 1, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1355, 5, 11238, 4, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1355, 6, 12301, 3, 0);
INSERT INTO ITEMS (ORDERNO, ITEMNO, PARTNO, QTY, DISCOUNT) VALUES (1860, 1, 5349, 1, 0);

COMMIT WORK;

INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1003, 1351, '04/12/1988', '05/03/1988 12:00:00', 114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 1250, 4.5, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1004, 2156, '04/17/1988', '04/18/1988', 145, 'Maria Eventosh', 'PO Box 737', NULL, 'Johannesburg', NULL, '2042', 'Republic So. Africa', '27-11-4432458', 'DHL', NULL, 'FOB', 'Check', 7885, 0, 0, 7885);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1005, 1356, '04/20/1988', '01/21/1988 12:00:00', 110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 4807, 0, 0, 4807);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1006, 1380, '11/06/1994', '11/07/1988 12:00:00', 46, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', 'P101324', 'FOB', 'Visa', 31987, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1007, 1384, '05/01/1988', '05/02/1988', 45, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Visa', 6500, 0, 0, 6500);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1008, 1510, '05/03/1988', '05/04/1988', 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Visa', 1449.5, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1009, 1513, '05/11/1988', '05/12/1988', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'COD', 5587, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1010, 1551, '05/11/1988', '05/12/1988', 46, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'COD', 4996, 0, 0, 4996);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1011, 1560, '05/18/1988', '05/19/1988', 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'COD', 2679.85009765625, 0, 0, 2679.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1012, 1563, '05/19/1988', '05/20/1988', 118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 5201, 0, 0, 5201);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1013, 1624, '05/25/1988', '05/26/1988', 134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'Net 30', 'Credit', 3115, 0, 0, 3115);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1014, 1645, '05/25/1988', '05/26/1988', 144, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'Net 30', 'Credit', 134.850006103516, 0, 0, 134.850006103516);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1015, 1651, '05/25/1988', '05/26/1988', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'FOB', 'MC', 20321.75, 0, 0, 20321.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1016, 1680, '06/02/1988', '06/03/1988', 65, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'AmEx', 2605, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1017, 1984, '06/12/1988', '06/13/1988', 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 10195, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1018, 2118, '06/18/1988', '06/19/1988', 118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 5256, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1019, 2135, '06/24/1988', '06/25/1988', 114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 20602, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1020, 2156, '06/24/1988', '06/25/1988', 61, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 9955, 0, 0, 9955);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1021, 2163, '06/24/1988', '06/25/1988', 52, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 3719, 0, 0, 3719);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1022, 2163, '06/30/1988', '07/01/1988', 46, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 10064.650390625, 0, 0, 10064.650390625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1023, 1221, '07/01/1988', '07/02/1988', 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Check', 4674, 0, 0, 4674);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1024, 3151, '07/02/1988', '07/03/1988', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Check', 6897, 0, 0, 6897);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1025, 1510, '07/03/1988', '07/04/1988', 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'AmEx', 930, 0, 0, 930);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1026, 1624, '07/07/1988', '07/08/1988', 44, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'AmEx', 2920, 0, 0, 2920);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1027, 1384, '07/07/1988', '07/08/1988', 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Visa', 25210, 0, 0, 25210);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1028, 1651, '07/07/1988', '07/08/1988', 11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'FOB', 'Visa', 343.799987792969, 0, 0, 343.799987792969);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1029, 1645, '07/18/1988', '07/19/1988', 110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 20108, 0, 0, 20108);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1030, 3615, '07/25/1988', '07/26/1988', 107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 559.599975585938, 0, 0, 559.599975585938);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1031, 2118, '07/28/1988', '08/01/1988', 127, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Credit', 12685, 0, 0, 12685);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1032, 2163, '07/28/1988', '08/01/1988', 144, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Credit', 775, 0, 0, 775);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1033, 1384, '08/01/1988', '08/02/1988', 138, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Cash', 1238, 0, 0, 1238);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1034, 1680, '08/13/1988', '08/14/1988', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Check', 18532, 0, 0, 18532);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1035, 1560, '08/16/1988', '08/17/1988', 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 560, 0, 0, 560);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1036, 5384, '08/25/1988', '08/26/1988', 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 4110, 0, 0, 4110);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1037, 1984, '08/26/1988', '08/27/1988', 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 3117, 0, 0, 3117);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1038, 1645, '08/26/1988', '08/27/1988', 72, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Visa', 10152, 0, 0, 10152);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1039, 3158, '08/29/1988', '09/01/1988', 61, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Visa', 536.799987792969, 0, 0, 536.799987792969);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1040, 6812, '09/04/1988', '09/05/1988', 52, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Visa', 3632, 0, 0, 3632);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1041, 4652, '09/16/1988', '09/17/1988', 109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'AmEx', 7807, 0, 0, 7807);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1042, 3984, '09/24/1988', '09/25/1988', 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'AmEx', 971.700012207031, 0, 0, 971.700012207031);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1043, 5132, '09/30/1988', '10/01/1988', 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 12455, 0, 0, 12455);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1044, 5515, '10/08/1988', '10/09/1988', 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 64050, 0, 0, 64050);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1045, 9841, '10/16/1988', '10/17/1988', 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Credit', 787.799987792969, 0, 0, 787.799987792969);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1046, 2315, '11/12/1988', '11/13/1988', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Check', 766.799987792969, 0, 0, 766.799987792969);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1047, 5515, '11/27/1988', '11/28/1988', 44, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Cash', 15365, 0, 0, 15365);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1048, 5432, '12/02/1988', '12/03/1988', 118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Visa', 7346, 0, 0, 7346);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1049, 9841, '12/13/1988', '12/14/1988', 107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'MC', 1809.84997558594, 0, 0, 1809.84997558594);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1050, 3052, '12/24/1988', '12/25/1988', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'AmEx', 6287.85009765625, 0, 0, 6287.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1051, 2165, '01/04/1989', '01/05/1989', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Credit', 325, 0, 0, 325);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1052, 1351, '01/06/1989', '01/07/1989', 144, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Credit', 16788, 0, 0, 16788);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1053, 6516, '01/15/1989', '01/16/1989', 145, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Credit', 24650, 0, 0, 24650);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1054, 5432, '01/28/1989', '02/01/1989', 83, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Visa', 14188, 0, 0, 14188);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1055, 1351, '02/04/1989', '02/05/1989', 29, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 23406, 0, 0, 23406);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1056, 1513, '02/08/1989', '02/09/1989', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'MC', 19293.69921875, 0, 0, 19293.69921875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1057, 1563, '02/18/1989', '02/19/1989', 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 1975, 0, 0, 1975);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1058, 2118, '02/21/1989', '02/22/1989', 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Credit', 12736, 0, 0, 12736);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1059, 1356, '02/24/1989', '02/25/1989', 109, NULL, '4-976 Sugarloaf Hwy', 'Suite 103', 'Kapaa Kauai', 'HI', '94766-1234', 'America', '808-555-0269', 'US Mail', NULL, 'FOB', 'Cash', 2150, 8.5, 0, 2150);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1060, 1231, '02/28/1989', '03/01/1989', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Check', 15355, 0, 0, 15355);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1061, 1563, '03/03/1989', '03/04/1989', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 24277.30078125, 0, 0, 24277.30078125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1062, 2118, '03/08/1989', '03/09/1989', 11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 18320, 0, 0, 18320);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1063, 3042, '03/13/1989', '03/14/1989', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 61869.30078125, 0, 0, 61869.30078125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1064, 2118, '03/24/1989', '03/25/1989', 83, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 395, 0, 0, 395);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1065, 6312, '03/25/1989', '03/26/1989', 72, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 17814, 0, 0, 17814);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1066, 3054, '03/26/1989', '03/27/1989', 65, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Visa', 19812, 0, 0, 19812);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1067, 1351, '04/01/1989', '04/02/1989', 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Visa', 4495, 0, 0, 4495);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1068, 4531, '04/03/1989', '04/04/1989', 105, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 31847, 0, 0, 31847);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1069, 2975, '04/05/1989', '04/06/1989', 136, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 33829.44921875, 0, 0, 33829.44921875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1070, 6215, '04/07/1989', '04/08/1989', 144, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 22354, 0, 0, 22354);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1071, 1560, '04/09/1989', '04/10/1989', 114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Cash', 103041, 0, 0, 103041);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1072, 1356, '04/11/1989', '04/12/1989', 29, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Cash', 3596, 0, 0, 3596);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1073, 1231, '04/15/1989', '04/16/1989', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'MC', 19414, 0, 0, 19414);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1074, 1984, '04/19/1989', '04/20/1989', 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'MC', 2195, 0, 0, 2195);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1075, 1351, '04/21/1989', '04/22/1989', 11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'MC', 8560, 0, 0, 8560);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1076, 1221, '12/16/1994', '04/26/1989', 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 17781, 0, 0, 17781);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1077, 1551, '04/29/1989', '05/01/1989', 110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 156, 0, 0, 156);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1078, 3041, '05/01/1989', '05/02/1989', 39, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 79116, 0, 0, 79116);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1079, 1380, '05/03/1989', '05/04/1989', 44, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 4445, 0, 0, 4445);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1080, 1356, '05/05/1989', '05/06/1989', 45, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 9634, 0, 0, 9634);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1081, 3042, '05/07/1989', '05/08/1989', 109, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'AmEx', 30566, 0, 0, 30566);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1082, 1551, '05/09/1989', '05/10/1989', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'AmEx', 1416.44995117188, 0, 0, 1416.44995117188);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1083, 1563, '05/09/1989', '05/10/1989', 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Cash', 11164.7998046875, 0, 0, 11164.7998046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1084, 1680, '05/11/1989', '05/12/1989', 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Cash', 1185, 0, 0, 1185);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1086, 1513, '05/18/1989', '05/19/1989', 29, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Cash', 14049.9501953125, 0, 0, 14049.9501953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1087, 1351, '05/20/1989', '05/21/1989', 127, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 14045, 0, 0, 14045);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1089, 3151, '05/22/1989', '05/23/1989', 113, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 2706, 0, 0, 2706);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1090, 1513, '05/25/1989', '05/26/1989', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 8507, 0, 0, 8507);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1091, 1563, '05/28/1989', '06/01/1989', 83, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 1950, 0, 0, 1950);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1092, 6582, '05/30/1989', '06/01/1989', 61, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Visa', 76698.75, 0, 0, 76698.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1093, 1680, '06/01/1989', '06/02/1989', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Visa', 479.799987792969, 0, 0, 479.799987792969);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1094, 5163, '06/03/1989', '06/04/1989', 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 4113.75, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1095, 2156, '06/05/1989', '06/06/1989', 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'MC', 7531.75, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1096, 2354, '06/09/1989', '06/09/1989', 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'MC', 123740, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1097, 3615, '06/12/1989', '06/12/1989', 107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'MC', 12953.599609375, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1098, 2315, '06/14/1989', '06/14/1989', 118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 472.899993896484, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1099, 1984, '06/16/1989', '06/16/1989', 138, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 859.950012207031, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1100, 1384, '06/20/1989', '06/20/1989', 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 6094.7998046875, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1101, 2165, '07/04/1989', '07/04/1989', 37, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 11629.849609375, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1102, 1231, '06/06/1992', '06/06/1992', 105, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 2844, 0, 0, 2844);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1103, 3042, '07/13/1992', '07/13/1992', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 39797.69921875, 0, 0, 39797.69921875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1104, 1354, '07/18/1992', '07/18/1992', 83, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 51673.1484375, 0, 0, 51673.1484375);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1105, 1356, '07/21/1992', '07/21/1992', 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 31219.94921875, 0, 0, 31219.94921875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1106, 1380, '09/23/1992', '09/23/1992', 15, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'FOB', 'Visa', 3531.80004882813, 0, 0, 3531.80004882813);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1107, 1384, '10/24/1992', '10/24/1992', 134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Visa', 28389, 0, 0, 28389);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1109, 1513, '11/13/1992', '11/13/1992', 145, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'COD', 203, 0, 0, 203);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1111, 1560, '12/14/1992', '12/14/1992', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'COD', 4720.7998046875, 0, 0, 4720.7998046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1112, 4531, '01/02/1993', '01/02/1993', 61, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 5565, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1113, 1624, '02/12/1993', '02/12/1993', 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'Net 30', 'Credit', 2514.64990234375, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1115, 4684, '03/13/1993', '03/13/1993', 29, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'FOB', 'MC', 4894.9501953125, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1116, 1680, '03/21/1993', '03/21/1993', 113, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'AmEx', 23104, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1117, 1984, '04/13/1993', '04/13/1993', 44, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 6734.85009765625, 0, 0, 0);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1118, 2118, '04/23/1993', '04/23/1993', 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 21614, 0, 0, 21614);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1119, 5384, '05/15/1993', '05/15/1993', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 14557.9501953125, 0, 0, 14557.9501953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1120, 2156, '05/25/1993', '05/25/1993', 46, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 784.900024414063, 0, 0, 784.900024414063);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1121, 2163, '06/02/1993', '06/02/1993', 85, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 820, 0, 0, 820);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1122, 2163, '07/23/1993', '07/23/1993', 141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 44854, 0, 0, 44854);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1123, 1221, '08/24/1993', '08/24/1993', 121, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Check', 13945, 0, 0, 13945);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1124, 1384, '09/01/1993', '09/01/1993', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Check', 33071, 0, 0, 33071);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1125, 1510, '09/04/1993', '09/04/1993', 44, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'AmEx', 6583.7998046875, 0, 0, 6583.7998046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1126, 1624, '10/01/1993', '10/01/1993', 45, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'AmEx', 10107, 0, 0, 10107);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1127, 1384, '10/02/1993', '10/02/1993', 65, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Visa', 25071, 0, 0, 25071);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1128, 1651, '10/08/1993', '10/08/1993', 37, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'FOB', 'Visa', 8294, 0, 0, 8294);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1129, 1645, '10/19/1993', '10/19/1993', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 1004.79998779297, 0, 0, 1004.79998779297);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1130, 4312, '10/26/1993', '10/26/1993', 114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 6300, 0, 0, 6300);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1131, 2118, '11/01/1993', '11/01/1993', 134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Credit', 11989.2001953125, 0, 0, 11989.2001953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1132, 2163, '11/01/1993', '11/01/1993', 121, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Credit', 906, 0, 0, 906);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1133, 3151, '11/02/1993', '11/02/1993', 138, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Cash', 2419, 0, 0, 2419);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1134, 5151, '11/14/1993', '11/14/1993', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Check', 6675.9501953125, 0, 0, 6675.9501953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1136, 2163, '11/27/1993', '11/27/1993', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 2971, 0, 0, 2971);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1137, 1984, '11/27/1993', '11/27/1993', 11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 6785.39990234375, 0, 0, 6785.39990234375);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1139, 1510, '12/01/1993', '12/01/1993', 29, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Visa', 47710.75, 0, 0, 47710.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1140, 6812, '12/12/1993', '12/12/1993', 52, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Visa', 1240, 0, 0, 1240);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1141, 4652, '12/17/1993', '12/17/1993', 83, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'AmEx', 1846, 0, 0, 1846);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1142, 3984, '12/25/1993', '12/25/1993', 105, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'AmEx', 3546, 0, 0, 3546);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1143, 5132, '01/01/1994', '01/01/1994', 113, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 3087, 0, 0, 3087);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1144, 5515, '01/09/1994', '01/09/1994', 134, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 10054, 0, 0, 10054);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1145, 9841, '01/17/1994', '01/17/1994', 144, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Credit', 4229.7998046875, 0, 0, 4229.7998046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1146, 2315, '02/13/1994', '02/13/1994', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Check', 15052, 0, 0, 15052);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1148, 1563, '03/03/1994', '03/03/1994', 83, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'Visa', 5011, 0, 0, 5011);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1149, 9841, '03/14/1994', '03/14/1994', 52, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'MC', 12900.75, 0, 0, 12900.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1150, 3052, '03/25/1994', '03/25/1994', 44, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'AmEx', 7671.89990234375, 0, 0, 7671.89990234375);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1152, 1351, '04/07/1994', '04/07/1994', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Credit', 97698.6015625, 0, 0, 97698.6015625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1153, 1380, '04/16/1994', '04/16/1994', 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Credit', 3860.85009765625, 0, 0, 3860.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1154, 1560, '05/01/1994', '05/01/1994', 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Visa', 13226.7998046875, 0, 0, 13226.7998046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1155, 1351, '05/05/1994', '05/05/1994', 37, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 13935.9501953125, 0, 0, 13935.9501953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1156, 1513, '05/09/1994', '05/09/1994', 46, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'MC', 12367, 0, 0, 12367);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1158, 5165, '05/22/1994', '05/22/1994', 141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'Credit', 9793.5498046875, 0, 0, 9793.5498046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1160, 1231, '06/01/1994', '06/01/1994', 110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Check', 2206.85009765625, 0, 0, 2206.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1161, 1563, '06/04/1994', '06/04/1994', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 102453.6015625, 0, 0, 102453.6015625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1162, 2118, '06/09/1994', '06/09/1994', 114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 3153, 0, 0, 3153);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1163, 1351, '06/14/1994', '06/14/1994', 83, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 342, 0, 0, 342);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1165, 1513, '06/26/1994', '06/26/1994', 72, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 2692.85009765625, 0, 0, 2692.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1166, 3054, '07/01/1994', '07/01/1994', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Visa', 28862, 0, 0, 28862);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1168, 1563, '07/04/1994', '07/04/1994', 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 104, 0, 0, 104);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1169, 1221, '07/06/1994', '07/06/1994', 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 9471.9501953125, 0, 0, 9471.9501953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1170, 1551, '07/08/1994', '07/08/1994', 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Credit', 5654.7998046875, 0, 0, 5654.7998046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1171, 1560, '07/10/1994', '07/10/1994', 136, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Cash', 2356.89990234375, 0, 0, 2356.89990234375);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1173, 1231, '07/16/1994', '07/16/1994', 127, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'MC', 54, 0, 0, 54);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1175, 3051, '07/22/1994', '07/22/1994', 110, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'MC', 13814.0498046875, 0, 0, 13814.0498046875);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1176, 1221, '07/26/1994', '07/26/1994', 52, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 4178.85009765625, 0, 0, 4178.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1178, 1231, '08/02/1994', '08/02/1994', 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 5511.75, 0, 0, 5511.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1180, 1356, '08/06/1994', '08/06/1994', 144, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 3640, 0, 0, 3640);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1183, 4531, '08/10/1994', '08/10/1994', 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Cash', 3650, 0, 0, 3650);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1195, 5384, '09/06/1994', '09/06/1994', 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'MC', 7868, 0, 0, 7868);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1196, 2354, '09/08/1994', '09/08/1994', 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'MC', 5983, 0, 0, 5983);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1197, 1513, '09/12/1994', '09/12/1994', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'MC', 6731, 0, 0, 6731);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1198, 2315, '09/14/1994', '09/14/1994', 65, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 72089.8984375, 0, 0, 72089.8984375);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1199, 5163, '09/16/1994', '09/16/1994', 85, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 716, 0, 0, 716);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1200, 1384, '09/20/1994', '09/20/1994', 107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 1827, 0, 0, 1827);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1201, 2984, '10/04/1994', '10/04/1994', 114, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 7990, 0, 0, 7990);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1202, 1231, '10/06/1994', '10/06/1994', 145, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 4205, 0, 0, 4205);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1204, 3053, '10/18/1994', '10/18/1994', 141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 10263.75, 0, 0, 10263.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1205, 3054, '10/21/1994', '10/21/1994', 8, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 4029.55004882813, 0, 0, 4029.55004882813);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1207, 1384, '11/11/1994', '11/11/1994', 52, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Visa', 12949.7001953125, 0, 0, 12949.7001953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1209, 1513, '11/12/1994', '11/12/1994', 61, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'COD', 20711.900390625, 0, 0, 20711.900390625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1212, 1563, '11/14/1994', '11/14/1994', 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 3975.75, 0, 0, 3975.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1215, 1651, '11/16/1994', '11/16/1994', 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'FOB', 'MC', 8305.9501953125, 0, 0, 8305.9501953125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1217, 1984, '11/22/1994', '11/22/1994', 14, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 51730.80078125, 0, 0, 51730.80078125);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1221, 2163, '11/23/1994', '11/23/1994', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 2099, 0, 0, 2099);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1250, 3052, '11/24/1994', '11/24/1994', 61, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'AmEx', 45160.1015625, 0, 0, 45160.1015625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1253, 1380, '11/26/1994', '11/26/1994', 46, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Credit', 4774.85009765625, 0, 0, 4774.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1255, 1351, '12/09/1994', '12/09/1994', 127, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 64115.75, 0, 0, 64115.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1260, 3041, '12/10/1994', '12/10/1994', 107, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Check', 2577.85009765625, 0, 0, 2577.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1261, 1563, '12/11/1994', '12/11/1994', 45, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 1999, 0, 0, 1999);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1263, 3053, '12/14/1994', '12/14/1994', 44, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'FOB', 'Credit', 158922.65625, 0, 0, 158922.65625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1266, 1356, '12/15/1994', '12/15/1994', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'Visa', 6935, 0, 0, 6935);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1269, 1221, '12/16/1994', '12/16/1994', 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 1400, 0, 0, 1400);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1271, 1560, '12/20/1994', '12/20/1994', 145, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Cash', 304, 0, 0, 304);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1275, 1351, '12/22/1994', '12/22/1994', 20, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'MC', 16939.5, 0, 0, 16939.5);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1278, 1231, '12/23/1994', '12/23/1994', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Credit', 11568, 0, 0, 11568);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1280, 1356, '12/26/1994', '12/26/1994', 118, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 4317.75, 0, 0, 4317.75);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1283, 1563, '12/30/1994', '12/30/1994', 113, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Cash', 7134, 0, 0, 7134);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1292, 1354, '01/01/1995', '01/01/1995', 136, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'Net 30', 'Visa', 7986.89990234375, 0, 0, 7986.89990234375);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1294, 1984, '01/04/1995', '01/04/1995', 85, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FedEx', NULL, 'FOB', 'MC', 3304.85009765625, 0, 0, 3304.85009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1295, 2156, '01/06/1995', '01/06/1995', 45, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'MC', 17917, 0, 0, 17917);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1296, 5412, '01/08/1995', '01/08/1995', 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'Net 30', 'MC', 7423.35009765625, 0, 0, 7423.35009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1298, 2315, '01/09/1995', '01/09/1995', 11, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 9897, 0, 0, 9897);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1300, 1384, '01/10/1995', '01/10/1995', 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 52729.25, 0, 0, 52729.25);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1302, 1231, '01/16/1995', '01/16/1995', 52, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Credit', 24485, 0, 0, 24485);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1305, 1356, '01/20/1995', '01/20/1995', 65, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'Visa', 3065, 0, 0, 3065);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1309, 3615, '01/22/1995', '01/22/1995', 94, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'US Mail', NULL, 'Net 30', 'COD', 465, 0, 0, 465);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1315, 1651, '01/26/1995', '01/26/1995', 121, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Emery', NULL, 'FOB', 'MC', 5037.10009765625, 0, 0, 5037.10009765625);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1317, 1984, '02/01/1995', '02/01/1995', 138, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DHL', NULL, 'FOB', 'Check', 7572, 0, 0, 7572);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1350, 3052, '02/02/1995', '02/02/1995', 71, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'FOB', 'AmEx', 8939.599609375, 0, 0, 8939.599609375);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1355, 3053, '02/05/1995', '02/05/1995', 141, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'Net 30', 'Credit', 13908, 0, 0, 13908);
INSERT INTO ORDERS (ORDERNO, CUSTNO, SALEDATE, SHIPDATE, EMPNO, SHIPTOCONTACT, SHIPTOADDR1, SHIPTOADDR2, SHIPTOCITY, SHIPTOSTATE, SHIPTOZIP, SHIPTOCOUNTRY, SHIPTOPHONE, SHIPVIA, PO, TERMS, PAYMENTMETHOD, ITEMSTOTAL, TAXRATE, FREIGHT, AMOUNTPAID) VALUES (1860, 3615, '02/04/1996', NULL, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'UPS', NULL, 'net 30', 'Check', 65, 0, 0, 0);

COMMIT WORK;

INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (900, 3820, 'Dive kayak', 24, 16, 1356.75, 3999.94995117188);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (912, 3820, 'Underwater Diver Vehicle', 5, 3, 504, 1680);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1313, 3511, 'Regulator System', 165, 216, 117.5, 250);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1314, 5641, 'Second Stage Regulator', 98, 88, 124.099998474121, 365);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1316, 3511, 'Regulator System', 75, 70, 119.349998474121, 341);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1320, 3511, 'Second Stage Regulator', 37, 35, 73.5299987792969, 171);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1328, 3511, 'Regulator System', 166, 100, 154.800003051758, 430);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1330, 3511, 'Alternate Inflation Regulator', 47, 43, 85.8000030517578, 260);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1364, 3511, 'Second Stage Regulator', 128, 135, 99.9000015258789, 270);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1390, 3511, 'First Stage Regulator', 146, 140, 64.5999984741211, 170);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1946, 6588, 'Second Stage Regulator', 13, 10, 95.7900009155273, 309);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (1986, 6588, 'Depth/Pressure Gauge Console', 25, 24, 73.3199996948242, 188);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2314, 3511, 'Electronic Console', 13, 12, 120.900001525879, 390);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2341, 3511, 'Depth/Pressure Gauge', 226, 225, 48.2999992370605, 105);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2343, 3511, 'Personal Dive Sonar', 46, 45, 72.8499984741211, 235);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2350, 3511, 'Compass Console Mount', 211, 300, 10.1499996185303, 29);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2367, 3511, 'Compass (meter only)', 168, 183, 24.9599990844727, 52);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2383, 3511, 'Depth/Pressure Gauge', 128, 120, 76.2200012207031, 206);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2390, 3511, 'Electronic Console w/ options', 24, 23, 189, 420);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2612, 2014, 'Direct Sighting Compass', 15, 12, 12.5819997787476, 34.9500007629395);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2613, 2014, 'Dive Computer', 5, 2, 76.9700012207031, 179);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2619, 2014, 'Navigation Compass', 8, 20, 9.17700004577637, 19.9500007629395);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2630, 2014, 'Wrist Band Thermometer (F)', 6, 3, 7.92000007629395, 18);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2632, 2014, 'Depth/Pressure Gauge (Digital)', 12, 10, 53.6399993896484, 149);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2648, 2014, 'Depth/Pressure Gauge (Analog)', 16, 15, 39.2700004577637, 119);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2657, 2014, 'Wrist Band Thermometer (C)', 12, 10, 6.48000001907349, 18);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (2954, 6588, 'Dive Computer', 45, 43, 253.5, 650);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (3316, 3511, 'Stabilizing Vest', 56, 67, 146.199996948242, 430);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (3326, 3511, 'Front Clip Stabilizing Vest', 45, 56, 128.800003051758, 280);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (3340, 3511, 'Trim Fit Stabilizing Vest', 63, 61, 138.25, 395);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (3386, 3511, 'Welded Seam Stabilizing Vest', 62, 60, 109.199996948242, 280);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (5313, 3511, 'Safety Knife', 16, 30, 13.1199998855591, 41);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (5318, 5641, 'Medium Titanium Knife', 4, 3, 26.7665004730225, 56.9500007629395);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (5324, 3511, 'Chisel Point Knife', 14, 35, 14.3500003814697, 41);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (5349, 3511, 'Flashlight', 28, 27, 29.25, 65);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (5356, 3511, 'Medium Stainless Steel Knife', 30, 23, 34.2999992370605, 70);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (5378, 3511, 'Divers Knife and Sheath', 24, 23, 27.2999992370605, 70);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (5386, 3511, 'Large Stainless Steel Knife', 16, 15, 37.5999984741211, 80);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (7612, 7382, 'Krypton Flashlight', 46, 76, 20.6770000457764, 44.9500007629395);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (7619, 7382, 'Flashlight (Rechargeable)', 16, 36, 50.9850006103516, 169.949996948242);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (7654, 7382, 'Halogen Flashlight', 19, 18, 19.1840000152588, 59.9500007629395);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (9312, 3511, '60.6 cu ft Tank', 8, 4, 57.2799987792969, 179);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (9316, 3511, '95.1 cu ft Tank', 16, 14, 130, 325);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (9318, 3511, '71.4 cu ft Tank', 102, 100, 58.5, 195);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (9354, 3511, '75.8 cu ft Tank', 38, 31, 96.3499984741211, 235);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (11221, 2674, 'Remotely Operated Video System', 13, 12, 710.700012207031, 2369);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (11238, 7382, 'Marine Super VHS Video Package', 3, 1, 1124.09997558594, 2498);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (11518, 4652, 'Towable Video Camera (B&W)', 12, 21, 859.570007324219, 1999);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (11564, 4652, 'Towable Video Camera (Color)', 16, 39, 1484.55004882813, 3299);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (11635, 7382, 'Camera and Case', 14, 12, 52.7779998779297, 119.949996948242);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (11652, 7382, 'Video Light', 5, 1, 147.579498291016, 359.950012207031);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (12301, 2674, 'Boat Towable Metal Detector', 13, 12, 203.660003662109, 599);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (12303, 2674, 'Boat Towable Metal Detector', 14, 11, 316.049987792969, 735);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (12306, 2674, 'Underwater Altimeter', 38, 34, 143.5, 350);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (12310, 2674, 'Sonar System', 3, 120, 215.110000610352, 439);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (12316, 2674, 'Marine Magnetometer', 56, 55, 545.580017089844, 1299);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (12317, 2674, 'Underwater Metal Detector', 29, 24, 440.510009765625, 899);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (12386, 2674, 'Underwater Metal Detector', 45, 41, 338.299987792969, 995);
INSERT INTO PARTS (PARTNO, VENDORNO, DESCRIPTION, ONHAND, ONORDER, COST, LISTPRICE) VALUES (13545, 4682, 'Air Compressor', 5, 2, 986.849975585938, 2295);

COMMIT WORK;

ALTER TABLE CUSTOMER ADD  PRIMARY KEY (CUSTNO);
ALTER TABLE ORDERS ADD  PRIMARY KEY (ORDERNO);
ALTER TABLE ORDERS ADD  FOREIGN KEY (CUSTNO) REFERENCES CUSTOMER (CUSTNO);
CREATE INDEX BYCOMPANY ON CUSTOMER (COMPANY);
CREATE INDEX BYDESCRIPTION ON PARTS (DESCRIPTION);
CREATE INDEX BYORDERNO ON ITEMS (ORDERNO);
CREATE INDEX CUSTNO ON ORDERS (CUSTNO);
CREATE UNIQUE INDEX CUSTOMER0 ON CUSTOMER (CUSTNO);
CREATE UNIQUE INDEX ITEMS0 ON ITEMS (ORDERNO, ITEMNO);
CREATE UNIQUE INDEX ORDERS0 ON ORDERS (ORDERNO);
CREATE INDEX PARTNO ON ITEMS (PARTNO);
CREATE UNIQUE INDEX PARTS0 ON PARTS (PARTNO);
CREATE INDEX VENDORNO ON PARTS (VENDORNO);

COMMIT WORK;
