unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  chcBDEFilter, StdCtrls, ExtCtrls, Db, Grids, DBGrids, DBTables, Buttons,
  ComCtrls, chcSQLFilterStruc;

type
  TForm1 = class(TForm)
    Query1: TQuery;
    DBGrid1: TDBGrid;
    DS: TDataSource;
    Filter1: TchcBDEFilter;
    Filter2: TchcBDEFilter;
    Panel1: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Memo1: TMemo;
    TabSheet2: TTabSheet;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    Memo2: TMemo;
    TabSheet3: TTabSheet;
    Memo3: TMemo;
    Filter3: TchcBDEFilter;
    TabSheet4: TTabSheet;
    Memo4: TMemo;
    Filter4: TchcBDEFilter;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure Filter4InitValues(Sender: TObject; var Items: TStringList;
      Table, Field: string);
    procedure Filter3ApplySQL(Sender: TObject; var NewSQL: string);
    procedure Filter3InitFilterData(Sender: TObject;
      var FilterData: FilterArray);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  OrigSQL: string;

implementation

{$R *.DFM}

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if PageControl1.activePage = TabSheet1 then Filter1.Execute else
    if PageControl1.activePage = TabSheet2 then Filter2.Execute else
      if PageControl1.activePage = TabSheet3 then Filter3.Execute else
        if PageControl1.activePage = TabSheet4 then Filter4.Execute;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  origSQL := Query1.SQL.Text;
end;

procedure TForm1.PageControl1Change(Sender: TObject);
begin
  with Query1 do
  begin
    DisableControls;
    Close;
    SQL.Text := OrigSQL;
    Open;
    EnableControls;
  end;
end;

procedure TForm1.Filter4InitValues(Sender: TObject; var Items: TStringList;
  Table, Field: string);
begin
  if (Table = 'CUSTOMER') and (Field = 'Country') then
  begin
    Items.Add('Bahamas');
    Items.Add('United States'#1'US'); // #1 separates what is show from what is used in the comparision.
    Items.Add('Canada');
    Items.Add('Bermuda');
    Items.Add('Greece');
    Items.Add('Venezuela');
  end;
end;

procedure TForm1.Filter3ApplySQL(Sender: TObject; var NewSQL: string);
begin
  ShowMessage('NEW SQL is : '#13#10 + NewSQL);
end;

procedure TForm1.Filter3InitFilterData(Sender: TObject;
  var FilterData: FilterArray);
begin
  if High(FilterData) > -1 then Exit;
  {Set the Open array size to 1 element = 1 filter line}
  setLength(FilterData, 1);
  {Initialize the filter with custom data}
  with FilterData[0] do
  begin
    BGroup := '';
    ColName := 'STATE';
    Table := 'CUSTOMER.';
    Comparision := '=';
    Value := 'CA';
    EGroup := '';
    Operation := -1;
  end;
end;

end.

