(* LogTerm - log terminal library
 * Copyright (C) 1999-2003  Tomas Mandys-MandySoft
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *)

{ URL: http://www.2p.cz }

unit {$IFDEF CLR}MandySoft.Vcl.{$ENDIF}LogTerm;

{ LogTerm.htx }

interface
uses
  Classes, SysUtils {$IFDEF LINUX}, Types{$ELSE}, Windows{$ENDIF}, Terminal, Connect;

type
  TFileTermLogger = class(TFileLogger)
  private
    FTerminal: TTerminal;
    FTermChar: Boolean;
  protected
    procedure DoLog(aText: string); override;
  published
    property Terminal: TTerminal read FTerminal write FTerminal;
    property TermChar: Boolean read FTermChar write FTermChar;
  end;

procedure Register;

implementation

procedure TFileTermLogger.DoLog;
begin
  if FTerminal <> nil then
  begin
    if FTermChar or (lfAutoCR in LogFlags) then
      FTerminal.LogTerm(aText)
    else
      FTerminal.Log(aText);
  end;
  inherited;
end;

procedure Register;
begin
  RegisterComponents('Communication', [TFileTermLogger]);
end;

end.

