unit TAPIFr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Connect, ComCtrls, StdCtrls, ExtCtrls, Terminal, ToolWin, TAPICom;

type
  TForm1 = class(TForm)
    Terminal1: TTerminal;
    Splitter1: TSplitter;
    Terminal2: TTerminal;
    Label1: TLabel;
    Label2: TLabel;
    StatusBar1: TStatusBar;
    ToolBar1: TToolBar;
    ConnectButton: TToolButton;
    DisconnectButton: TToolButton;
    SetupButton: TToolButton;
    LineCom: TLineCom;
    Timer1: TTimer;
    procedure Terminal1KeyPress(Sender: TObject; var Key: Char);
    procedure Comm1RxChar(Sender: TObject; Count: Integer);
    procedure SetupButtonClick(Sender: TObject);
    procedure DisconnectButtonClick(Sender: TObject);
    procedure LineComConnect(Sender: TObject);
    procedure LineComDisconnect(Sender: TObject);
    procedure LineComStateChange(Sender: TObject; aParam1,
      aParam2: Cardinal);
    procedure Timer1Timer(Sender: TObject);
    procedure ConnectButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    FLine: string;
    ConnectDT: TDateTime;
    procedure AdjustVisible;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

resourcestring
  stDay = '%d d ';
  stHour = '%d h ';
  stMin = '%d min ';
  stSec = '%d s';
implementation
uses
  TapiSetDg;
  
{$R *.DFM}

procedure TForm1.Terminal1KeyPress(Sender: TObject; var Key: Char);
begin
  Terminal1.LogTerm(Key);
  LineCom.Comm.Send(Key);
  Key:= #0;
end;

procedure TForm1.Comm1RxChar(Sender: TObject; Count: Integer);
var
  I: Integer;
  S: string;
begin
  S:= LineCom.Comm.Retrieve(Count);
  for I:= 1 to Length(S) do
    Terminal2.LogTerm(S[I]);
end;

procedure TForm1.AdjustVisible;
begin
  ConnectButton.Enabled:= (FLine <> '') and not LineCom.Active;
  SetupButton.Enabled:= not LineCom.Active;
  DisconnectButton.Enabled:= LineCom.Active or LineCom.IsMakingCall;
end;

procedure TForm1.SetupButtonClick(Sender: TObject);
begin
  with TTapiSetupDlg.Create(nil) do
  try
    Lines.ItemIndex:= TapiLine.FindDeviceId(FLine);
    PhoneNumber.Text:= LineCom.PhoneNumber;
    DirectAccess.Checked:= LineCom.DirectAccess;
// load from INI TapiLine.DevConfig[Lines.ItemIndex]:=
    if ShowModal = mrOk then
    begin
      FLine:= Lines.Items[Lines.ItemIndex];
      LineCom.PhoneNumber:= PhoneNumber.Text;
      LineCom.DirectAccess:= DirectAccess.Checked;
      StatusBar1.Panels[0].Text:= FLine;
// save config to INI:= TapiLine.DevConfig[Lines.ItemIndex];
    end;
    AdjustVisible;
  finally
    Free;
  end;
end;

procedure TForm1.DisconnectButtonClick(Sender: TObject);
begin
  LineCom.Drop;
end;

procedure TForm1.LineComConnect(Sender: TObject);
begin
  ConnectDT:= Now;
  Timer1.Enabled:= True;
  Terminal2.Enabled:= True;
  LineCom.Comm.OnRxChar:= Comm1RxChar;
end;

procedure TForm1.LineComDisconnect(Sender: TObject);
begin
  LineCom.Comm.OnRxChar:= nil;
  LineCom.Close;
  Timer1.Enabled:= False;
  Terminal2.Enabled:= False;
  AdjustVisible;
end;

procedure TForm1.LineComStateChange(Sender: TObject; aParam1,
  aParam2: Cardinal);
begin
  StatusBar1.Panels[1].Text:= LineCallStateToStr(aParam1);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  H, M, Sec, S100: Word;
  S: string;
begin
  DecodeTime(Now-ConnectDT, H, M, Sec, S100);
  S:= '';
  if Now-ConnectDT >= 1 then
    S:= IntToStr(Trunc(Now-ConnectDT));
  if Now-ConnectDT >= 1 then
    S:= Format(stDay, [Trunc(Now-ConnectDT)]);
  if H > 0 then
    S:= S+Format(stHour, [H]);
  if M > 0 then
    S:= S+Format(stMin, [M]);
  if Sec > 0 then
    S:= S+Format(stSec, [Sec]);

  StatusBar1.Panels[2].Text:= S;
end;

procedure TForm1.ConnectButtonClick(Sender: TObject);
begin
  LineCom.DeviceId:= TapiLine.FindDeviceId(FLine);
  LineCom.Open;
//  LineCom.DevConfig:= TapiLine.DevConfig[LineCom.DeviceId];  load config from INI

  LineCom.MakeCall;
  AdjustVisible;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  AdjustVisible;
end;

end.
