unit LogFrm;

interface

uses
  SysUtils, QControls, QExtCtrls, QComCtrls, QForms,
  QStdCtrls, Terminal, Classes, {$IFDEF LINUX}Libc, Types, GSM, QDialogs,
  QImgList, QButtons{$ELSE}Windows, Messages{$ENDIF};

type
  TLogForm = class(TForm)
    LogMemo: TMemo;
    procedure FormCreate(Sender: TObject);
  private
    TermXPos: Integer;
  protected
  public
    MaxLines: Integer;
    procedure Log(const S: string);
    procedure LogErr(const S1, S2: string);
    procedure LogTermChar(C: Char);
    procedure LogTerm(const S: string);
  end;

var
  LogForm: TLogForm;

implementation
uses
  AuxGSM, AuxStr;

{$R *.dfm}

const
  LF = #10;
  CR = #13;

procedure TLogForm.FormCreate(Sender: TObject);
begin
  MaxLines:= 100;
  LogMemo.Lines.Clear;
end;

procedure TLogForm.Log;
begin
  while LogMemo.Lines.Count >= MaxLines do
    LogMemo.Lines.Delete(0);
  LogMemo.Lines.Add(S);
  TermXPos:= 0;
end;

procedure TLogForm.LogErr;
begin
  Log(Format('%s: %s', [S1, S2]));
end;

procedure TLogForm.LogTerm;
var
  I: Integer;
begin
  for I:= 1 to Length(S) do
    LogTermChar(S[I]);
end;

procedure TLogForm.LogTermChar;
var
  S: string;
  I, N: Integer;
begin
  while LogMemo.Lines.Count > MaxLines do
    LogMemo.Lines.Delete(0);
  if LogMemo.Lines.Count = 0 then
    LogMemo.Lines.Add('');
  case C of
    LF: begin
          LogMemo.Lines.Add(ReplSpace(TermXPos));
        end;
    CR: TermXPos:= 0;
    #8{BS}: if TermXPos > 0 then
            begin
              Dec(TermXPos);
            end;
    else
      S:= LogMemo.Lines[LogMemo.Lines.Count-1];

      I:= TermXPos+1-Length(S);
      if I > 0 then
        S:= S+ReplSpace(I);
      S[TermXPos+1]:= C;
      LogMemo.Lines[LogMemo.Lines.Count-1]:= S;
      Inc(TermXPos);
  end;
  N:= TermXPos;
  for I:= 0 to LogMemo.Lines.Count-2 do
    Inc(N, Length(LogMemo.Lines[I])+2);
  LogMemo.SelStart:= N;
  LogMemo.SelLength:= 0;
end;

end.
