unit AuxGsm;

interface
uses
  IniFiles, SysUtils, QForms;

type
  TCMNotifyMessage = record
    Msg: Cardinal;
    WParam, LParam: Longint;
  end;

function GetGSMIni: TIniFile;
function GetProgramPath: string;
procedure AdjustPath(var S: string);

function ShowForm(FormClass: TFormClass; const aName: string): TForm;
procedure NotifyForms(Msg: Word; WParam, LParam: Longint);


resourcestring
  sLastError = 'Error "%s": %.4x';
implementation
uses
  CmdLine, {$IFNDEF LINUX}WinProcs, WinTypes, {$ENDIF}GSM;

function GetGSMIni;
var
  S: string;
begin
  S:= GetProgramPath+'gsm.ini';
  GetCmdString('I:', clUpcase, S);
  Result:= TIniFile.Create(S);
end;

procedure AdjustPath;
begin
  if (S <> '') and not (S[Length(S)] in ['\',':','/']) then
    S:= S+PathDelim;
end;

function GetProgramPath;
begin
  Result:= ExtractFilePath(ExpandFileName(ParamStr(0)));
  AdjustPath(Result);
end;

function ShowForm;
var
  I: Integer;
begin
  Result:= nil;
  for I:= 0 to Application.ComponentCount-1 do
    if (Application.Components[I] is FormClass) and ((aName = '') or (Application.Components[I].Name = aName)) then
    begin
      Result:= Application.Components[I] as TForm;
      Result.BringToFront;
      if Result.WindowState = wsMinimized then
        Result.WindowState:= wsNormal;
      Break;
    end;
  if Result = nil then
  begin
    Result:= FormClass.Create(Application);
    if aName <> '' then
      Result.Name:= aName;
  end;
  Result.Show;
end;

procedure NotifyForms;
var
  I: Integer;
  M: TCMNotifyMessage;
begin
  for I:= 0 to Screen.FormCount-1 do
  begin
    M.Msg:= Msg;
    M.WParam:= WParam;
    M.LParam:= LParam;
    Screen.Forms[I].Dispatch(M);
  end;
end;

end.
