unit GSMCtrFr;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, GSM, ExtCtrls, Gauges, dm_GSM, Buttons, ComCtrls,
  ToolWin, ImgList, Terminal, ActnList, XSMS, ExtDlgs, Grids, MPlayer, Connect;

const
  glRed = 1;
  glGreen = 3;
  glYellow = 5;
  glNone = 0;

type
  TGSMCentralForm = class(TForm)
    ImageList: TImageList;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel2: TPanel;
    GroupBox2: TGroupBox;
    IndNetRegStatus: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Panel1: TPanel;
    Panel6: TPanel;
    StatusBar: TStatusBar;
    Semafor: TSpeedButton;
    SpeedButton1: TSpeedButton;
    TabSheet5: TTabSheet;
    Panel7: TPanel;
    TabSheet6: TTabSheet;
    TabSheet7: TTabSheet;
    Panel8: TPanel;
    Panel9: TPanel;
    ModemLog: TTerminal;
    SMSLog: TTerminal;
    Label1: TLabel;
    DA: TEdit;
    Label2: TLabel;
    Message: TEdit;
    BitBtn1: TBitBtn;
    AutoShowModemLog: TCheckBox;
    ConfigureGroupbox: TGroupBox;
    SCAEdit: TEdit;
    PinEdit: TEdit;
    PINLabel: TLabel;
    SCALabel: TLabel;
    CommRadioGroup: TRadioGroup;
    ModemComboBox: TComboBox;
    ModemLabel: TLabel;
    SMSLOGCheckBox: TCheckBox;
    GSMLOGCheckBox: TCheckBox;
    SMSLogButton: TButton;
    GSMLogButton: TButton;
    SMSLogSaveDialog: TSaveDialog;
    GSMLogSaveDialog: TSaveDialog;
    Label3: TLabel;
    SMSFormat: TComboBox;
    GroupBox1: TGroupBox;
    CatchSMSMT: TCheckBox;
    CatchSMSCB: TCheckBox;
    CatchSMSDS: TCheckBox;
    OnlyIndication: TCheckBox;
    ManufacturerId: TMemo;
    DeliveryNotification: TCheckBox;
    DCS: TComboBox;
    SMSKind: TComboBox;
    Label4: TLabel;
    Label5: TLabel;
    SMSKind2: TComboBox;
    PictureGB: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    PictureWidth: TEdit;
    PictureHeight: TEdit;
    PictureNumAnimations: TEdit;
    ScrollBox1: TScrollBox;
    Picture: TPaintBox;
    Label9: TLabel;
    PictureOperator: TComboBox;
    vCardGB: TGroupBox;
    Label10: TLabel;
    Label11: TLabel;
    vCardName: TEdit;
    vCardPhone: TEdit;
    Blink: TButton;
    Button2: TButton;
    Button3: TButton;
    SavePictureDialog: TSavePictureDialog;
    OpenPictureDialog: TOpenPictureDialog;
    MelodyGB: TGroupBox;
    Label12: TLabel;
    MelodyName: TEdit;
    MelodyKeyboard: TPaintBox;
    Button1: TButton;
    Button4: TButton;
    MelodyGrid: TStringGrid;
    MelodyNote: TComboBox;
    MelodyDuration: TComboBox;
    MelodyDuration2: TComboBox;
    MelodyScale: TComboBox;
    MelodyStyle: TComboBox;
    MelodyTempo: TComboBox;
    MelodyVolume: TComboBox;
    MelodyInsert: TCheckBox;
    Button5: TButton;
    Button6: TButton;
    SaveMelodyDialog: TSaveDialog;
    OpenMelodyDialog: TOpenDialog;
    SEOGB: TGroupBox;
    SEOFileName: TEdit;
    Label13: TLabel;
    Button7: TButton;
    Label14: TLabel;
    SEOName: TEdit;
    SEOPicture: TImage;
    SEOMidi: TMediaPlayer;
    OpenSEOMidiDialog: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure IndNetRegStatusClick(Sender: TObject);
    procedure StatusBarClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ModemLogKeyPress(Sender: TObject; var Key: Char);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SMSLOGCheckBoxClick(Sender: TObject);
    procedure SMSLogButtonClick(Sender: TObject);
    procedure GSMLogButtonClick(Sender: TObject);
    procedure GSMLOGCheckBoxClick(Sender: TObject);
    procedure SMSKindChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure PicturePaint(Sender: TObject);
    procedure PictureWidthExit(Sender: TObject);
    procedure PictureWidthKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PictureMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BlinkClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure MelodyKeyboardPaint(Sender: TObject);
    procedure MelodyKeyboardMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MelodyKeyboardMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure MelodyGridDblClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
  private
    FSaveActivePage: TTabSheet;
    FLastSMSKind, FLastSMSKind2: Integer;
    FSMSKindLock: Byte;
    FSmartMessage: TSmartMessageClass;
    FEMS: TEMSObjectClass;
    fPictureBitmap: TBitmap;
    fReference: Integer;
    fMelodyKeyPressTick: Longint;
    fMelodyKeyPressed: Integer;
    fMelodyArray: array[0..6] of TComboBox;
    fSEOPictureFileName: string;
    procedure CheckGSMActive;
    procedure cmNetRegistrationChanged(var Msg: TMessage); message cm_NetRegistrationChanged;
    procedure cmModemStatusChanged(var Msg: TMessage); message cm_ModemStatusChanged;
    procedure SendSMSPhn(aDA, S: string; aDeliveryNotification: Boolean; aDCS: Byte; aUDH, aNoConv, aUnicode: Boolean);
    function GetGlyphNum(aGlyph: Byte; aOnOff: Boolean): Integer;
    procedure StatusLineOnHint(Sender: TObject);
    procedure ShowModemLog;
    procedure HideModemLog;
    procedure GetConfiguration;
    procedure SetConfiguration;
    procedure AdjustSMSKind;
    procedure AdjustPicture;
    procedure GetKeyRect(aScale: Byte; aNote: Byte; var R: TRect; var Keyis: Boolean);
    procedure MelodySetFromGrid;
    procedure SMRingingToneFromGrid(SM: TSMRingingTone);
    procedure AdjustSEO;
  public
    { Public declarations }
  end;

var
  GSMCentralForm: TGSMCentralForm;

implementation
uses
  AuxGSM, AuxStr, IniFiles, CmdLine, Math;

resourcestring
  sModemNotActive = 'Device is not active';

{$R *.DFM}

const
  SendPrefix = '+:';
  MaxSMSLength = 160;

  CaptionStr = 'GSM Central [%s]';

procedure TGSMCentralForm.FormCreate(Sender: TObject);
var
  i: TGSMEquipment;
  J: Integer;
  S: string;
resourcestring
  sMelodyTitles = 'Scale;Note;Dur;Dur2;Tempo;Style;Vol.;';
const
  MelodyDef: array[0..6] of Integer = (smrtiScaleDefault, 0, 0, 0, smrtiTempoDefault, smrtiStyleDefault, smrtiVolumeDefault);
begin
  GSMDataModule.ModemLog:= ModemLog;
  GSMDataModule.SMSLog:= SMSLog;
  PageControl1.ActivePage:= TabSheet1;
  Semafor.Align:= alClient;
  Caption:= Format(CaptionStr, [GSMEquipmentLongName[GSMDataModule.GSM.Equipment]]);
  ImageList.GetBitmap(GetGlyphNum(glNone, False), IndNetRegStatus.Glyph);
  ImageList.GetBitmap(GetGlyphNum(glNone, False), Semafor.Glyph);
  for i:=Low(TGSMEquipment) to High(TGSMEquipment) do
    ModemComboBox.Items.Add(GSMEquipmentLongName[i]);
  //  GSMDataModule.Comm1.Open;
  Application.OnHint:= StatusLineOnHint;
  DCS.ItemIndex:= 2;
  fPictureBitmap:= TBitmap.Create;
  fPictureBitmap.Monochrome:= True;

  MelodyGrid.ColCount:= High(fMelodyArray)-Low(fMelodyArray)+1;
  fMelodyArray[0]:= MelodyScale;
  fMelodyArray[1]:= MelodyNote;
  fMelodyArray[2]:= MelodyDuration;
  fMelodyArray[3]:= MelodyDuration2;
  fMelodyArray[4]:= MelodyTempo;
  fMelodyArray[5]:= MelodyStyle;
  fMelodyArray[6]:= MelodyVolume;
  S:= sMelodyTitles;
  for J:= Low(fMelodyArray) to High(fMelodyArray) do
  begin
    MelodyGrid.ColWidths[J]:= fMelodyArray[J].Width;
    MelodyGrid.Cells[J, 0]:= Copy(S, 1, Pos(';', S)-1);
    Delete(S, 1, Pos(';', S));
    MelodyGrid.Objects[J, 0]:= Pointer(MelodyDef[J]);
  end;
  MelodySetFromGrid;
end;

function TGSMCentralForm.GetGlyphNum;
begin
  Result:= aGlyph;
  Inc(Result, Byte((aGlyph > 0) and aOnOff));
end;

procedure TGSMCentralForm.CheckGSMActive;
begin
  if not GSMDataModule.Active then
    GSMError(sModemNotActive);
end;

procedure TGSMCentralForm.SendSMSPhn;
var
  aSMS: TSMSSubmit;
resourcestring
  sDeviceNotActive = 'Device not active. Connect?';
begin
  if not GSMDataModule.Active then
  begin
    if MessageDlg(sDeviceNotActive, mtConfirmation, [mbYes, mbNo], 0) <> mrYes then
      Abort;
    SetConfiguration;
    GSMDataModule.GSM.Open;
  end;
  CheckGSMActive;
  aSMS:= TSMSSubmit.Create;
  try
    aSMS.GSM:= GSMDataModule.GSM;
    aSMS.DA:= aDA;
    if not aNoConv then
      S:= ISOtoSMS(S);
    if aUnicode then
      aSMS.WideUD:= Copy(S,1,70)
    else
      aSMS.UD:= Copy(S,1,MaxSMSLength);
    aSMS.DCS:= aDCS;
    aSMS.SRR:= aDeliveryNotification;
    aSMS.UDHI:= aUDH;
    GSMDataModule.SendSMS(aSMS);
    GSMDataModule.LogSMS(aSMS);
  finally
    aSMS.Free;
  end;
end;

procedure TGSMCentralForm.cmNetRegistrationChanged;
var
  Col: Byte;
begin
  case Msg.wParam of
    1: Col:= glGreen;
    2: Col:= glYellow;
  else
    Col:= glRed;
  end;
  IndNetRegStatus.Glyph:= nil;
  ImageList.GetBitmap(GetGlyphNum(Col, True), IndNetRegStatus.Glyph);
end;

procedure TGSMCentralForm.cmModemStatusChanged;
var
  Col: Byte;
  i: Integer;
begin
  for i:=0 to ConfigureGroupBox.ControlCount-1 do
    ConfigureGroupBox.Controls[i].Enabled := not GSMDataModule.GSM.Active;

  with SMSLogCheckBox do
    SMSLogButton.Enabled := Enabled and Checked;
  with GSMLogCheckBox do
    GSMLogButton.Enabled := Enabled and Checked;

  case Msg.wParam and $7F of
    0: Col:= glRed;
    1:
      begin
        Col:= glGreen;
        with GSMDataModule do
          if (Msg.wParam and $80 <> 0) and GSM.Active then
          begin
            ManufacturerId.Lines.Text:= Format('%s/%s'#13#10'%s'#13#10'S/N: %s', [GSM.ManufacturerId, GSM.ModelId, GSM.RevisionId, GSM.SerialNumberId]);
          end;
      end;
  else
    Col:= glNone;
  end;
  Semafor.Glyph:= nil;
  ImageList.GetBitmap(GetGlyphNum(Col, True), Semafor.Glyph);
  Application.ProcessMessages;
end;

procedure TGSMCentralForm.SpeedButton3Click(Sender: TObject);
var MakeActive: Boolean;
begin
  ShowModemLog;
  try
    MakeActive:=Boolean((Sender as TControl).Tag);
    if MakeActive then
    begin
      GSMDataModule.GSM.COMDevice.Close;
      SetConfiguration;
    end;
    GSMDataModule.Active:=MakeActive;
  finally
    HideModemLog;
  end;
end;

procedure TGSMCentralForm.IndNetRegStatusClick(Sender: TObject);
var
  Sg: TStrings;
  I: Integer;
begin
  CheckGSMActive;
  with GSMDataModule do
  begin
    Sg:= TStringList.Create;
    try
      if GSM.SendATCommand('AT+CSQ', atrCode+atrParams+atrATResponse, Sg) = 0 then
      begin
        I:= 1;
        I:= StrToNum(ExtractParam(Sg[0], I));
        if I = 99 then begin
                         IndNetRegStatus.Caption:= '?';
                         I:= 0;
                       end
                  else IndNetRegStatus.Caption:= Format('%d dBm', [2*I + (-113)]);
      end;
    finally
      Sg.Free;
    end;
  end;
end;

procedure TGSMCentralForm.StatusLineOnHint;
begin
  StatusBar.SimpleText:= GetLongHint(Application.Hint);
end;

procedure TGSMCentralForm.StatusBarClick(Sender: TObject);
begin
  with StatusBar do
    SimpleText:= GetShortHint(Hint);
end;

procedure TGSMCentralForm.SpeedButton1Click(Sender: TObject);
begin
  ShowModemLog;
  try
    GSMDataModule.GSM.SwitchOff;
  finally
    HideModemLog;
  end;
end;

procedure TGSMCentralForm.FormShow(Sender: TObject);
begin
  GetConfiguration;
  fLastSMSKind:= -MaxInt;
  SMSKind.ItemIndex:= 0;
  AdjustSMSKind;
  if IsThereCmd('START', clUpcase) then
    SpeedButton3Click(SpeedButton3);
  StatusBarClick(nil);
end;

procedure TGSMCentralForm.ModemLogKeyPress(Sender: TObject; var Key: Char);
begin
  GSMDataModule.GSM.COMDevice.Open;
  GSMDataModule.GSM.COMDevice.Send(Key);
  Key:= #0;
end;

procedure TGSMCentralForm.ShowModemLog;
begin
  if AutoShowModemLog.Checked then
  begin
    FSaveActivePage:= PageControl1.ActivePage;
    PageControl1.ActivePage:= TabSheet7;
    Application.ProcessMessages;
  end;
end;

procedure TGSMCentralForm.HideModemLog;
begin
  if AutoShowModemLog.Checked then
  begin
    PageControl1.ActivePage:= FSaveActivePage;
  end;
end;

procedure TGSMCentralForm.GetConfiguration;
var i: Integer;
begin
  with GSMDataModule,GSM do
  begin
    ModemComboBox.ItemIndex := Ord(Equipment);
    SCAEdit.Text := SCA;
    PINEdit.Text := PIN;
    Self.SMSFormat.ItemIndex := SMSFormat;
    CatchSMSMT.Checked := uindSMSDeliver in UnsolicitedIndication;
    CatchSMSCB.Checked := uindCellBroadcast in UnsolicitedIndication;
    CatchSMSDS.Checked := uindSMSStatusReport in UnsolicitedIndication;
    OnlyIndication.Checked := uindOnlyIndication in UnsolicitedIndication;
    with CommRadioGroup do
      for i:=0 to Items.Count-1 do
        if ComDevice.DeviceName=Items[i] then
        begin
          ItemIndex := i;
          break;
        end;

    SMSLogCheckBox.Checked := SMSLogFile <> NO_LOG_FILE;
    GSMLogCheckBox.Checked := GSMLogFile <> NO_LOG_FILE;
    SMSLogSaveDialog.FileName := SMSLogFile;
    GSMLogSaveDialog.FileName := GSMLogFile;
  end;
end;

procedure TGSMCentralForm.SetConfiguration;
begin
  with GSMDataModule,GSM do
  begin
    Equipment := TGSMEquipment(ModemComboBox.ItemIndex);
    SCA := SCAEdit.Text;
    PIN := PINEdit.Text;
    SMSFormat:= Self.SMSFormat.ItemIndex;
    UnsolicitedIndication:= [];
    if CatchSMSMT.Checked then
      UnsolicitedIndication:= UnsolicitedIndication+[uindSMSDeliver];
    if CatchSMSCB.Checked then
      UnsolicitedIndication:= UnsolicitedIndication+[uindCellBroadcast];
    if CatchSMSDS.Checked then
      UnsolicitedIndication:= UnsolicitedIndication+[uindSMSStatusReport];
    if OnlyIndication.Checked then
      UnsolicitedIndication:= UnsolicitedIndication+[uindOnlyIndication];

    ComDevice.DeviceName := CommRadioGroup.Items[CommRadioGroup.ItemIndex];

    if SMSLogCheckBox.Checked then
      SMSLogFile := SMSLogSaveDialog.FileName
    else
      SMSLogFile := NO_LOG_FILE;

    if GSMLogCheckBox.Checked then
      GSMLogFile := GSMLogSaveDialog.FileName
    else
      GSMLogFile := NO_LOG_FILE;

    self.Caption:= Format(CaptionStr, [GSMEquipmentLongName[Equipment]]);
  end;

end;

procedure TGSMCentralForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
//  SetConfiguration;
end;

procedure TGSMCentralForm.SMSLOGCheckBoxClick(Sender: TObject);
begin
  SMSLogButton.Enabled := SMSLogCheckBox.Checked
end;

procedure TGSMCentralForm.GSMLOGCheckBoxClick(Sender: TObject);
begin
  GSMLogButton.Enabled := GSMLogCheckBox.Checked
end;

procedure TGSMCentralForm.SMSLogButtonClick(Sender: TObject);
begin
  if SMSLogCheckBox.Checked then
   SMSLogSaveDialog.Execute;
end;

procedure TGSMCentralForm.GSMLogButtonClick(Sender: TObject);
begin
  if GSMLogCheckBox.Checked then
    GSMLogSaveDialog.Execute;
end;

procedure TGSMCentralForm.SMSKindChange(Sender: TObject);
begin
  AdjustSMSKind;
end;

procedure TGSMCentralForm.AdjustSMSKind;
begin
  if fSMSKindLock <> 0 then
    Exit;
  Inc(fSMSKindLock);
  try
    if SMSKind.ItemIndex <> FLastSMSKind then
    begin
      SMSKind2.Enabled:= SMSKind.ItemIndex > 0;
      if SMSKind.ItemIndex = 1 then
        SMSKind2.Items.Text:= 'Picture'#13#10'vCard'#13#10'Logo'#13#10'CLI'#13#10'Melody'
      else if SMSKind.ItemIndex = 2 then
        SMSKind2.Items.Text:= 'Picture (small)'#13#10'Picture (large)'#13#10'Picture (variable)'#13#10'Animation (small)'#13#10'Animation (large)'#13#10'Melody'
      else if SMSKind.ItemIndex = 3 then
        SMSKind2.Items.Text:= 'Bitmap'#13#10'MIDI sound'
      else
        SMSKind2.Items.Text:= #13#10;
      FLastSMSKind:= SMSKind.ItemIndex;
      SMSKind2.ItemIndex:= 0;
      DCS.Enabled:= SMSKind.ItemIndex <= 2;
      DeliveryNotification.Enabled:= DCS.Enabled;
      FLastSMSKind2:= -MaxInt;
    end;
    if SMSKind2.ItemIndex <> FLastSMSKind2 then
    begin
      case SMSKind.ItemIndex of
        0:
          begin
            FSmartMessage:= nil;
            FEMS:= nil;
            PictureGB.Visible:= False;
            vCardGB.Visible:= False;
            MelodyGB.Visible:= False;
            SEOGB.Visible:= False;
            Message.Enabled:= True;
          end;
        1:
          begin
            FEMS:= nil;
            case SMSKind2.ItemIndex of
              0: FSmartMessage:= TSMOTABitmap;
              1: FSmartMessage:= TSMvCard;
              2: FSmartMessage:= TSMOperatorLogo;
              3: FSmartMessage:= TSMCLIIcon;
              4: FSmartMessage:= TSMRingingTone;
            end;
            PictureGB.Visible:= (FSmartMessage = TSMMultipartMessage) or (FSmartMessage.InheritsFrom(TSMOTABitmap));
            PictureOperator.Enabled:= FSmartMessage = TSMOperatorLogo;
            vCardGB.Visible:= FSmartMessage = TSMvCard;
            SEOGB.Visible:= False;
            PictureNumAnimations.Enabled:= False;
            PictureNumAnimations.Text:= '0';
            PictureHeight.Enabled:= True;
            PictureWidth.Enabled:= PictureHeight.Enabled;
            MelodyGB.Visible:= FSmartMessage.InheritsFrom(TSMRingingTone);
            Message.Enabled:= fSmartMessage = TSMOTABitmap;
          end;
        2:
          begin
            FSmartMessage:= nil;
            case SMSKind2.ItemIndex of
              0: FEMS:= TEMSPictureSmall;
              1: FEMS:= TEMSPictureLarge;
              2: FEMS:= TEMSPictureVariable;
              3: FEMS:= TEMSAnimationSmall;
              4: FEMS:= TEMSAnimationLarge;
              5: FEMS:= TEMSSoundUserDef;
            end;
            PictureGB.Visible:= FEMS.InheritsFrom(TEMSPicture) or FEMS.InheritsFrom(TEMSAnimation);
            vCardGB.Visible:= False;
            SEOGB.Visible:= False;
            PictureNumAnimations.Enabled:= False;
            PictureHeight.Enabled:= FEMS = TEMSPictureVariable;
            PictureWidth.Enabled:= PictureHeight.Enabled;
            PictureOperator.Enabled:= False;
            MelodyGB.Visible:= FEMS.InheritsFrom(TEMSSoundUserDef);
            Message.Enabled:= True;
            if FEMS.InheritsFrom(TEMSPicture) then
              begin
                with FEMS.Create as TEMSPicture do
                try
                  PictureHeight.Text:= IntToStr(Height);
                  PictureWidth.Text:= IntToStr(Width);
                  PictureNumAnimations.Text:= '1';
                finally
                  Free;
                end;
              end
            else if FEMS.InheritsFrom(TEMSAnimation) then
              begin
                with FEMS.Create as TEMSAnimation do
                try
                  PictureHeight.Text:= IntToStr(Height);
                  PictureWidth.Text:= IntToStr(Width);
                  PictureNumAnimations.Text:= '4';
                finally
                  Free;
                end;
              end
          end;
        3:
          begin
            FSmartMessage:= nil;
            FEMS:= nil;
            PictureGB.Visible:= False;
            vCardGB.Visible:= False;
            MelodyGB.Visible:= False;
            SEOGB.Visible:= True;
            Message.Enabled:= False;
            SEOPicture.Visible:= SMSKind2.ItemIndex = 0;
            SEOMidi.Visible:= SMSKind2.ItemIndex = 1;
            case SMSKind2.ItemIndex of
              0:
                begin
                  SEOFileName.Text:= fSEOPictureFileName;
                end;
              1:
                begin
                  SEOFileName.Text:= SEOMidi.FileName;
                end;
            end;
            AdjustSEO;
          end;
        end;
      AdjustPicture;
    end;
    Blink.Enabled:= Message.Enabled;
  finally
    Dec(fSMSKindLock);
  end;
end;

const
  CellSize = 5;

procedure TGSMCentralForm.AdjustPicture;
begin
  Picture.Width:= CellSize*(StrToIntDef(PictureNumAnimations.Text, 0)+Byte(SMSKind.ItemIndex=1))*StrToIntDef(PictureWidth.Text, 0);
  Picture.Height:= CellSize*StrToIntDef(PictureHeight.Text, 0);
  Picture.Repaint;
  fPictureBitmap.Width:= Max(Picture.Width, fPictureBitmap.Width);
  fPictureBitmap.Height:= Max(Picture.Height, fPictureBitmap.Height);
end;

procedure TGSMCentralForm.FormDestroy(Sender: TObject);
begin
  fPictureBitmap.Free;
end;

procedure TGSMCentralForm.PicturePaint(Sender: TObject);
var
  A, X, Y, X1: Integer;
const
  BackColor: array[Boolean] of TColor = ($00FFFF80, $0080FF00);
begin
  with Picture.Canvas do
  begin
    X1:= 0;
    for A:= 1 to StrToIntDef(PictureNumAnimations.Text, 0)+Byte(SMSKind.ItemIndex=1) do
    begin
      Pen.Mode:= pmCopy;
      Brush.Color:= BackColor[A and 1 <> 0];
      Brush.Style:= bsSolid;
      Pen.Style:= psClear;
      Rectangle(X1*CellSize, 0, (X1+StrToIntDef(PictureWidth.Text, 0))*CellSize, Picture.Height);
      Brush.Color:= clBlack;
      for X:= 0 to StrToIntDef(PictureWidth.Text, 0)-1 do
      begin
        for Y:= 0 to StrToIntDef(PictureHeight.Text, 0)-1 do
        begin
          if not fPictureBitmap.Empty and (fPictureBitmap.Canvas.Pixels[X1, Y] <> clWhite) then
           Rectangle(X1*CellSize, Y*CellSize, (X1+1)*CellSize, (Y+1)*CellSize);
        end;
        Inc(X1);
      end;
    end;
    Pen.Style:= psSolid;
    Pen.Color:= clWhite;
    Pen.Width:= 1;
    Y:= 0;
    while Y <= Picture.Height do
    begin
      MoveTo(0, Y);
      LineTo(Picture.Width, Y);
      Inc(Y, CellSize);
    end;
    X:= 0;
    while X <= Picture.Width do
    begin
      MoveTo(X, 0);
      LineTo(X, Picture.Height);
      Inc(X, CellSize);
    end;
  end;
end;

procedure TGSMCentralForm.PictureWidthExit(Sender: TObject);
begin
  AdjustPicture;
end;

procedure TGSMCentralForm.PictureWidthKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (Key = VK_RETURN) and (Shift = []) then
  begin
    AdjustPicture;
    Key:= 0;
  end;
end;

procedure TGSMCentralForm.PictureMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  X:= X div CellSize;
  Y:= Y div CellSize;
  with fPictureBitmap.Canvas do
    if Pixels[X, Y] = clWhite then
      Pixels[X, Y]:= clBlack
    else
      Pixels[X, Y]:= clWhite;
  Picture.Repaint;
end;

procedure TGSMCentralForm.BlinkClick(Sender: TObject);
begin
  with Message do
    Text:= Copy(Text, 1, SelStart)+smBlinkOn+Copy(Text, SelStart+1, SelLength)+smBlinkOff+Copy(Text, SelStart+SelLength+1, Length(Text));
end;

procedure TGSMCentralForm.Button2Click(Sender: TObject);
begin
  if OpenPictureDialog.Execute then
  begin
    fPictureBitmap.LoadFromFile(OpenPictureDialog.FileName);
    SavePictureDialog.FileName:= OpenPictureDialog.FileName;
    AdjustPicture;
  end;
end;

procedure TGSMCentralForm.Button3Click(Sender: TObject);
begin
  if SavePictureDialog.Execute then
  begin
    fPictureBitmap.SaveToFile(SavePictureDialog.FileName);
  end;
end;

procedure TGSMCentralForm.BitBtn1Click(Sender: TObject);
var
  I: Integer;
  B: Byte;
  F: Boolean;
  NBS: TSMSProtocol;
  SM, SM2: TSmartMessage;
  EMS: TEMS;
  EMSObj: TEMSObject;
  S: string;
  St: TStream;
begin
  ShowModemLog;
  try
    NBS:= nil;
    try
      if FSmartMessage <> nil then
        begin
          if FSmartMessage.InheritsFrom(TSMMIMEDirectory) then
            NBS:= TNBS.Create
          else
            NBS:= TUDHProtocol.Create;
          TSMSProtocol2(NBS).Options:= [smspoAddressing, smspoReference];
          SM:= FSmartMessage.Create;
          try
            if SM is TSMvCard then
              begin
                TSMSProtocol2(NBS).DestinationAddress:= smPortMIMEvCard;
                SM:= TSMvCard.Create;
                with TSMvCard(SM) do
                begin
                  Records.Values['N']:= vCardName.Text;
                  Records.Values['TEL']:= vCardPhone.Text;
                end;
              end
            else if SM is TSMOTABitmap then
              begin
                with TSMOTABitmap(SM) do  
                begin
                  AnimatedImageCount:= StrToIntDef(PictureNumAnimations.Text, 0);
                  Width:= StrToIntDef(PictureWidth.Text, 0);
                  Height:= StrToIntDef(PictureHeight.Text, 0);
                  for I:= 0 to AnimatedImageCount do
                  begin
                    Images[I].Width:= Width;
                    Images[I].Height:= Height;
                  end;
                  ImportFromImage(fPictureBitmap);
                end;
                if SM is TSMCLIIcon then
                  TSMSProtocol2(NBS).DestinationAddress:= smPortCLILogo
                else if SM is TSMOperatorLogo then
                  begin
                    TSMSProtocol2(NBS).DestinationAddress:= smPortOperatorLogo;
                    with TSMOperatorLogo(SM) do
                    begin
                      I:= StrToIntDef(Copy(PictureOperator.Text, 1, Pos(',', PictureOperator.Text+',')-1), 0);
                      MCC:= I div 100;
                      MNC:= I mod 100;
                    end;
                  end;
              end
            else if SM is TSMRingingTone then
              begin
                TSMSProtocol2(NBS).DestinationAddress:= smPortRingingTone;
                SMRingingToneFromGrid(TSMRingingTone(SM));
              end;

            if (FSmartMessage = TSMOTABitmap) or (FSmartMessage = TSMScreenSaver) then
              begin
                TSMSProtocol2(NBS).DestinationAddress:= smPortMultiPart;
                SM2:= SM;
                SM:= TSMMultipartMessage.Create;
                with TSMMultipartMessage(SM) do
                begin
                  Multiparts.Add(SM2);
                  if Message.Text <> '' then
                  begin
                    SM2:= TSMTextISO.Create;
                    TSMTextISO(SM2).Text:= Message.Text;
                    Multiparts.Insert(0, SM2);
                  end;
                end;
              end;

            NBS.Data:= SM.Data;
          finally
            SM.Free;
          end;
        end
      else if fEMS <> nil then
        begin
          NBS:= TUDHProtocol.Create;
          TSMSProtocol2(NBS).Options:= [smspoReference];
          EMS:= TEMS.Create;
          EMS.Text:= Message.Text;
          EMSObj:= fEMS.Create;
          if EMSObj is TEMSPicture then
            begin
              with TEMSPicture(EMSObj) do
              begin
                Width:= StrToIntDef(PictureWidth.Text, 0);
                Height:= StrToIntDef(PictureHeight.Text, 0);
                ImportFromImage(fPictureBitmap);
              end;
            end
          else if EMSObj is TEMSAnimation then
            begin
              with TEMSAnimation(EMSObj) do
              begin
                Width:= StrToIntDef(PictureWidth.Text, 0);
                Height:= StrToIntDef(PictureHeight.Text, 0);
                ImportFromImage(fPictureBitmap);
              end
            end
          else if EMSObj is TEMSSoundUserDef then
            begin
              with TEMSSoundUserDef(EMSObj) do
              begin
                Records.Values['NAME']:= MelodyName.Text;
                if MelodyGrid.RowCount > 2 then
                begin
                  Records.Values['STYLE']:= 'S'+IntToStr(Integer(MelodyGrid.Objects[5, 1]));
                  Records.Values['BEAT']:= IntToStr(TSMRTTempo.DecodeBeatsPerMin(Integer(MelodyGrid.Objects[4, 1])));
                end;
                S:= '';
                for I:= 1 to MelodyGrid.RowCount-2 do
                begin
                  B:= Integer(MelodyGrid.Objects[6, I]);  // note: in row 0 are defaults
                  if B <> Integer(MelodyGrid.Objects[6, I-1]) then
                    S:= S+'V'+IntToStr(B);
                  if Integer(MelodyGrid.Objects[1, I]) = 0 then
                    S:= S+'r'
                  else
                    begin
                      B:= Integer(MelodyGrid.Objects[0, I]);  // note: in row 0 are defaults
                        if B <> Integer(MelodyGrid.Objects[0, I-1]) then
                          S:= S+'*'+IntToStr(B+3);
                      case Integer(MelodyGrid.Objects[1, I]) of
                        smrtiNoteC: S:= S+'c';
                        smrtiNoteCis: S:= S+'#c';
                        smrtiNoteD: S:= S+'d';
                        smrtiNoteDis: S:= S+'#d';
                        smrtiNoteE: S:= S+'e';
                        smrtiNoteF: S:= S+'f';
                        smrtiNoteFis: S:= S+'#f';
                        smrtiNoteG: S:= S+'g';
                        smrtiNoteGis: S:= S+'#g';
                        smrtiNoteA: S:= S+'a';
                        smrtiNoteAis: S:= S+'#a';
                        smrtiNoteH: S:= S+'b';
                      end;
                    end;
                  S:= S+IntToStr(Integer(MelodyGrid.Objects[2, I]));
                  B:= Integer(MelodyGrid.Objects[3, I]);  // note: in row 0 are defaults
                  case B of
                    1: S:= S+'.';
                    2: S:= S+':';
                    3: S:= S+';';
                  end;
                end;
                Records.Values['MELODY']:= S;
              end;
            end;
          EMS.Objects.Add(EMSObj);
          EMS.WriteTo(NBS as TUDHProtocol);
        end
      else if SMSKind.ItemIndex = 3 then // SEO
        begin
          NBS:= TSiemensOTA.Create;
          with TSiemensOTA(NBS) do
          begin
            ObjectName:= SEOName.Text;
            if SMSKind2.ItemIndex = 0 then
              begin
                ObjectType:= 'bmp';
                St:= TMemoryStream.Create;
                try
                  SEOPicture.Picture.Bitmap.SaveToStream(St);
                  St.Position:= 0;
                  NBS.Data:= StreamToString(St);
                finally
                  St.Free;
                end;
              end
            else
              begin
                ObjectType:= 'mid';
                SEOMidi.Close;  // file sharing lock
                St:= TFileStream.Create(SEOMidi.FileName, fmOpenRead);
                try
                  NBS.Data:= StreamToString(St);
                finally
                  St.Free;
                end;
                try
                  SEOMidi.Open;
                except
                end;
              end;
          end;
        end
      else
        begin
        // text msg.
        end;
      if NBS <> nil then
        begin
          if NBS is TSMSProtocol2 then
          begin
            TSMSProtocol2(NBS).SourceAddress:= TSMSProtocol2(NBS).DestinationAddress;
          end;
          TSMSProtocol2(NBS).Reference:= fReference mod 256;
          Inc(fReference);
          if NBS is TNBS then
            B:= 0
          else
            B:= $F4+DCS.ItemIndex;
          for I:= 1 to NBS.FragmentCount do
          begin
            SendSmsPhn(DA.Text, NBS.Fragments[I], DeliveryNotification.Checked, B, NBS is TUDHProtocol, True, False);
          end;
        end
      else
        begin
          B:= $F0+DCS.ItemIndex;
          S:= Message.Text;
          F:= Pos(smBlinkOn, S) <> 0;
          if F then
          begin
            S:= #1+S;
            B:= $18;  // ??? does not work, no idea how display blinking messages, other ME?
          end;
          SendSmsPhn(DA.Text, S, DeliveryNotification.Checked, B, False, F, F);
        end;
    finally
      NBS.Free;
    end;
  finally
    HideModemLog;
  end;
end;

procedure TGSMCentralForm.MelodyKeyboardPaint(Sender: TObject);
var
  I, J: Integer;
  R: TRect;
  Keyis: Boolean;
begin
  with (Sender as TPaintBox).Canvas do
  begin
    Brush.Style:= bsSolid;
    Brush.Color:= clWhite;
    Pen.Width:= 1;
    Pen.Style:= psClear;
    for I:= 0 to MelodyScale.Items.Count-1 do
      for J:= 1 to MelodyNote.Items.Count-1 do
      begin
        if fMelodyKeyPressed = I*256 + J then
          Pen.Mode:= pmXor
        else
          Pen.Mode:= pmCopy;
        GetKeyRect(I, J, R, Keyis);
        if not Keyis then
          Rectangle(R.Left, R.Top, R.Right, R.Bottom);
      end;
    Pen.Style:= psClear;
    for I:= 0 to MelodyScale.Items.Count-1 do
      for J:= 1 to MelodyNote.Items.Count-1 do
      begin
        if fMelodyKeyPressed = I*256 + J then
          begin
            Pen.Mode:= pmXor;
            Brush.Color:= clSilver;
          end
        else
          begin
            Brush.Color:= clBlack;
            Pen.Mode:= pmCopy;
          end;
        GetKeyRect(I, J, R, Keyis);
        if Keyis then
          Rectangle(R.Left, R.Top, R.Right, R.Bottom);
      end;
  end;
end;

procedure TGSMCentralForm.GetKeyRect;
var
  I, N, Sc, Kpos: Integer;
begin
  N:= 0;
  Keyis:= False;
  Kpos:= 0;
  for I:= 1 to MelodyNote.Items.Count-1 do
  begin
    if Pos('is', MelodyNote.Items[I]) = 0 then
      begin
        Inc(N);
        if I < aNote then
          Inc(Kpos);
      end
    else
      begin
        if aNote = I then
          Keyis:= True;
      end;
  end;
  Sc:= MelodyScale.Items.Count;

  R.Top:= 0;
  R.Bottom:= MelodyKeyboard.Height;
  R.Left:= 0;
  R.Right:= MelodyKeyboard.Width div (N * Sc);
  if Keyis then
  begin
    R.Bottom:= R.Bottom div 2;
    Dec(R.Left, R.Right div 3);
  end;

  Inc(R.Left, Kpos * R.Right);
  Inc(R.Left, N * aScale * R.Right);

  if Keyis then
    R.Right:= 2*R.Right div 3 + R.Left
  else
    R.Right:= R.Right + R.Left;
end;

procedure TGSMCentralForm.MelodyKeyboardMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  I, J: Integer;
  fMelodyKeyRect: TRect;
  F, Keyis: Boolean;
begin
  for F:= True downto False do
    for I:= 0 to MelodyScale.Items.Count-1 do
      for J:= 1 to MelodyNote.Items.Count-1 do
      begin
        GetKeyRect(I, J, fMelodyKeyRect, Keyis);
        if (Keyis = F) and (fMelodyKeyRect.Left<= X) and (fMelodyKeyRect.Right >X) and (fMelodyKeyRect.Top <= Y) and (fMelodyKeyRect.Bottom >Y) then
        begin
          fMelodyKeyPressed:= I * 256 + J;
          fMelodyKeyPressTick:= GetTickCount;
          MelodyScale.ItemIndex:= I;
          MelodyNote.ItemIndex:= J;
          MelodyKeyboard.Repaint;
          Exit;
        end;
      end;
end;

procedure TGSMCentralForm.MelodyKeyboardMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  T: Integer;
  I: Byte;
begin
  fMelodyKeyPressed:= 0;
  MelodyKeyboard.Repaint;
  T:= Integer(GetTickCount) - fMelodyKeyPressTick;
  if T < 50 then I:= 5
  else if T < 100 then I:= 4
  else if T < 200 then I:= 3
  else if T < 300 then I:= 2
  else if T < 500 then I:= 1
  else I:= 0;
  MelodyDuration.ItemIndex:= I;
  Button5.Click;
end;

procedure TGSMCentralForm.MelodySetFromGrid;
var
  I, J: Integer;
begin
  if MelodyGrid.RowCount <= 2 then
    J:= 0
  else
    J:= MelodyGrid.Row;
  for I:= 0 to MelodyGrid.ColCount-1 do
  begin
    fMelodyArray[I].ItemIndex:= Integer(MelodyGrid.Objects[I, J]);
  end;
end;

procedure TGSMCentralForm.Button5Click(Sender: TObject);
var
  I, J: Integer;
begin
  if MelodyInsert.Checked or (MelodyGrid.Row = MelodyGrid.RowCount-1) then
  begin
    MelodyGrid.RowCount:= MelodyGrid.RowCount+1;
    for I:= MelodyGrid.RowCount-2 downto MelodyGrid.Row do
      for J:= 0 to MelodyGrid.ColCount-1 do
      begin
        MelodyGrid.Cells[J, I+1]:= MelodyGrid.Cells[J, I];
        MelodyGrid.Objects[J, I+1]:= MelodyGrid.Objects[J, I];
      end;
  end;
  for I:= 0 to MelodyGrid.ColCount-1 do
  begin
    MelodyGrid.Objects[I, MelodyGrid.Row]:= Pointer(fMelodyArray[I].ItemIndex);
    MelodyGrid.Cells[I, MelodyGrid.Row]:= fMelodyArray[I].Items[fMelodyArray[I].ItemIndex];
  end;
  MelodyGrid.Row:= MelodyGrid.Row+1;
  if SMSKind.ItemIndex = 2 then
    for I:= 1 to MelodyGrid.RowCount-2 do            // there is global settings of tempo and style in EME melody
    begin
      MelodyGrid.Objects[4, I]:= Pointer(MelodyTempo.ItemIndex);
      MelodyGrid.Cells[4, I]:= MelodyTempo.Items[MelodyTempo.ItemIndex];
      MelodyGrid.Objects[5, I]:= Pointer(MelodyStyle.ItemIndex);
      MelodyGrid.Cells[5, I]:= MelodyStyle.Items[MelodyStyle.ItemIndex];
    end;
end;

procedure TGSMCentralForm.Button6Click(Sender: TObject);
var
  I, J: Integer;
begin
  if (MelodyGrid.RowCount > 2) and (MelodyGrid.Row < MelodyGrid.RowCount-1) then
  begin
    for I:= MelodyGrid.Row to MelodyGrid.RowCount-1 do
      for J:= 0 to MelodyGrid.ColCount-1 do
      begin
        MelodyGrid.Cells[J, I]:= MelodyGrid.Cells[J, I+1];
        MelodyGrid.Objects[J, I]:= MelodyGrid.Objects[J, I+1];
      end;
    MelodyGrid.RowCount:= MelodyGrid.RowCount-1;
    if (MelodyGrid.Row = MelodyGrid.RowCount-1) and (MelodyGrid.RowCount > 2) then
      MelodyGrid.Row:= MelodyGrid.Row-1;
  end;
end;

procedure TGSMCentralForm.MelodyGridDblClick(Sender: TObject);
begin
  MelodySetFromGrid;
end;

procedure TGSMCentralForm.Button1Click(Sender: TObject);
var
  Sg: TStrings;
  I, J, N: Integer;
  SM: TSMRingingTone;
begin
  if OpenMelodyDialog.Execute then
  begin
    Sg:= TStringList.Create;
    try
      Sg.LoadFromFile(OpenMelodyDialog.FileName);
      N:= StrToIntDef(Sg.Values['Count'], 0);
      if (N = 0) and (Sg.Count = 1) then
        begin   // try as RTTTL
          SM:= TSMRingingTone.Create;
          try
            SM.RTTTL:= Sg[0];
            MelodyGrid.RowCount:= 2;
            for J:= 0 to MelodyGrid.ColCount-1 do
              MelodyGrid.Objects[J, MelodyGrid.RowCount-1]:= MelodyGrid.Objects[J, MelodyGrid.RowCount-2];
            if SM.Commands.Count > 0 then
              with TSMRTCommand(SM.Commands[0]) do
              begin
                if Parts.Count > 1 then
                  if Parts[0] is TSMRTRingingTone then
                  begin
                    if Parts[1] is TSMRTBasicSong then
                      MelodyName.Text:= TSMRTBasicSong(Parts[1]).Title
                    else if Parts[1] is TSMRTTemporarySong then
                      MelodyName.Text:= ''
                    else
                      Exit;
                    with TSMRTTemporarySong(Parts[1]) do
                      if Patterns.Count > 0 then
                      begin
                        with TSMRTPattern(TSMRTTemporarySong(Parts[1]).Patterns[0]) do
                        begin
                          for I:= 0 to Instructions.Count-1 do
                          begin
                            if Instructions[I] is TSMRTScale then
                              begin
                                with TSMRTScale(Instructions[I]) do
                                  MelodyGrid.Objects[0, MelodyGrid.RowCount-1]:= Pointer(NoteScale);
                              end
                            else if Instructions[I] is TSMRTTempo then
                              begin
                                with TSMRTTempo(Instructions[I]) do
                                  MelodyGrid.Objects[4, MelodyGrid.RowCount-1]:= Pointer(BeatsPerMin);
                              end
                            else if Instructions[I] is TSMRTStyle then
                              begin
                                with TSMRTStyle(Instructions[I]) do
                                  MelodyGrid.Objects[5, MelodyGrid.RowCount-1]:= Pointer(Value);
                              end
                            else if Instructions[I] is TSMRTNote then
                              begin
                                with TSMRTNote(Instructions[I]) do
                                begin
                                  MelodyGrid.Objects[1, MelodyGrid.RowCount-1]:= Pointer(Value);
                                  MelodyGrid.Objects[2, MelodyGrid.RowCount-1]:= Pointer(Duration);
                                  MelodyGrid.Objects[3, MelodyGrid.RowCount-1]:= Pointer(DurationSpecifier);
                                end;
                                for J:= 0 to MelodyGrid.ColCount-1 do
                                  MelodyGrid.Cells[J, MelodyGrid.RowCount-1]:= fMelodyArray[J].Items[Integer(MelodyGrid.Objects[J, MelodyGrid.RowCount-1])];
                                MelodyGrid.RowCount:= MelodyGrid.RowCount+1;
                                for J:= 0 to MelodyGrid.ColCount-1 do
                                  MelodyGrid.Objects[J, MelodyGrid.RowCount-1]:= MelodyGrid.Objects[J, MelodyGrid.RowCount-2];
                              end;
                          end;
                        end;
                      end;
                  end;
              end;

          finally
            SM.Free;
          end;
        end
      else
        begin   // plain text
          MelodyName.Text:= Sg.Values['Name'];
          MelodyGrid.RowCount:= N+2;
          for I:= 0 to N-1 do
          begin
            for J:= 0 to MelodyGrid.ColCount-1 do
            begin
              MelodyGrid.Objects[J, I+1]:= Pointer(StrToIntDef(Sg.Values[Format('%d.%d', [I, J])], 0));
              MelodyGrid.Cells[J, I+1]:= fMelodyArray[J].Items[Integer(MelodyGrid.Objects[J, I+1])];
            end;
          end;
        end;
      for J:= 0 to MelodyGrid.ColCount-1 do
      begin
        MelodyGrid.Objects[J, MelodyGrid.RowCount-1]:= nil;
        MelodyGrid.Cells[J, MelodyGrid.RowCount-1]:= '';
      end;
      MelodyGrid.Row:= 1;
    finally
      Sg.Free;
    end;
    SaveMelodyDialog.FileName:= OpenMelodyDialog.FileName;
  end;
end;

procedure TGSMCentralForm.Button4Click(Sender: TObject);
var
  Sg: TStrings;
  I, J: Integer;
  St: TFileStream;
  S: string;
  SM: TSMRingingTone;
begin
  if SaveMelodyDialog.Execute then
  begin
    if Pos('RTT', UpperCase(ExtractFileExt(SaveMelodyDialog.FileName))) <> 0 then
      begin
        SM:= TSMRingingTone.Create;
        try
          SMRingingToneFromGrid(SM);
          S:= SM.RTTTL;
          if S <> '' then
          begin
            St:= TFileStream.Create(SaveMelodyDialog.FileName, fmCreate);
            try
              St.WriteBuffer(S[1], Length(S));
            finally
              St.Free;
            end;
          end;
        finally
          SM.Free;
        end;
      end
    else
      begin
        Sg:= TStringList.Create;
        try
          Sg.Values['Name']:= MelodyName.Text;
          Sg.Values['Count']:= IntToStr(MelodyGrid.RowCount-2);
          for I:= 1 to MelodyGrid.RowCount-2 do
          begin
            for J:= 0 to MelodyGrid.ColCount-1 do
            begin
              Sg.Values[Format('%d.%d', [I-1, J])]:= IntToStr(Integer(MelodyGrid.Objects[J, I+1]));
            end;
          end;
          Sg.SaveToFile(SaveMelodyDialog.FileName);
        finally
          Sg.Free;
        end;
      end;
  end;

end;

procedure TGSMCentralForm.SMRingingToneFromGrid(SM: TSMRingingTone);
var
  I, B: Integer;
begin
  SM.Commands.Add(TSMRTCommand.Create);
  with TSMRTCommand(SM.Commands[0]) do
  begin
    Parts.Add(TSMRTRingingTone.Create);
    if Trim(MelodyName.Text) = '' then
      Parts.Add(TSMRTTemporarySong.Create)
    else
      begin
        Parts.Add(TSMRTBasicSong.Create);
        TSMRTBasicSong(Parts[1]).Title:= MelodyName.Text;
      end;
    TSMRTTemporarySong(Parts[1]).Patterns.Add(TSMRTPattern.Create);
    with TSMRTPattern(TSMRTTemporarySong(Parts[1]).Patterns[0]) do
    begin
      for I:= 1 to MelodyGrid.RowCount-2 do
      begin
        B:= Integer(MelodyGrid.Objects[0, I]);  // note: in row 0 are defaults
        if B <> Integer(MelodyGrid.Objects[0, I-1]) then
        begin
          Instructions.Add(TSMRTScale.Create);
          TSMRTScale(Instructions[Instructions.Count-1]).NoteScale:= B;
        end;
        B:= Integer(MelodyGrid.Objects[4, I]);  // note: in row 0 are defaults
        if B <> Integer(MelodyGrid.Objects[4, I-1]) then
        begin
          Instructions.Add(TSMRTTempo.Create);
          TSMRTTempo(Instructions[Instructions.Count-1]).BeatsPerMin:= B;
        end;
        B:= Integer(MelodyGrid.Objects[6, I]);  // note: in row 0 are defaults
        if B <> Integer(MelodyGrid.Objects[6, I-1]) then
        begin
          Instructions.Add(TSMRTVolume.Create);
          TSMRTVolume(Instructions[Instructions.Count-1]).Value:= B;
        end;
        B:= Integer(MelodyGrid.Objects[5, I]);  // note: in row 0 are defaults
        if B <> Integer(MelodyGrid.Objects[5, I-1]) then
        begin
          Instructions.Add(TSMRTStyle.Create);
          TSMRTStyle(Instructions[Instructions.Count-1]).Value:= B;
        end;
        Instructions.Add(TSMRTNote.Create);
        with TSMRTNote(Instructions[Instructions.Count-1]) do
        begin
          Value:= Integer(MelodyGrid.Objects[1, I]);
          Duration:= Integer(MelodyGrid.Objects[2, I]);
          DurationSpecifier:= Integer(MelodyGrid.Objects[3, I]);
        end;
      end;
    end;
  end;
end;

procedure TGSMCentralForm.Button7Click(Sender: TObject);
var
  D: TOpenDialog;
begin
  case SMSKind2.ItemIndex of
    0:
      begin
        D:= OpenPictureDialog;
      end;
    1:
      begin
        D:= OpenSEOMidiDialog;
      end;
    else
      D:= nil;
  end;
  D.FileName:= SEOFileName.Text;
  if D.Execute then
    SEOFileName.Text:= D.FileName;
  AdjustSEO;
end;

procedure TGSMCentralForm.AdjustSEO;
begin
  SEOName.Text:= ExtractFileName(SEOFileName.Text);
  case SMSKind2.ItemIndex of
    0:
      begin
        SEOMidi.Close;
        fSEOPictureFileName:= SEOFileName.Text;
        try
          SEOPicture.Picture.Assign(nil);
          if SEOFileName.Text <> '' then
            SEOPicture.Picture.LoadFromFile(SEOFileName.Text);
        except
        end;
      end;
    1:
      begin
        SEOMidi.Close;
        SEOMidi.FileName:= SEOFileName.Text;
        try
          if SEOMidi.FileName <> '' then
            SEOMidi.Open;
        except
        end;
      end;
  end;
end;

end.

