(* CmdLine - command line library
 * Copyright (C) 1993,2003  Tomas Mandys-MandySoft
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 *)

{ URL: http://www.2p.cz }

unit CmdLine;
{$A-,F+,O+,B-,V-,X+}

{ CmdLine.htx }

interface

const
{$J+}
  WhereCmd:Integer=0;

const
  { Options parameter }
  clCaseSensitive=$1;
  clUpCase=$2;
  clLoCase=$4;
  clNext=$8;  { allows more same name parameters }
  clValueCase = $10;

  PrefixChars=['/','-'];

{ if parameter is on command line returns True (in S is parameter value) otherwise returns False
  and S is left unchanged }
function GetCmdString(Cmd:string; Option:Word; var S:string):Boolean;
{ returns True if Cmd on command line }
function IsThereCmd(Cmd:string; Option:Word):Boolean;
{
  Ex:
    PROGRAM -X:DELETE -I /DEL /ins -X:Insert -X:update FILE.TXT FILE2.TXT

  GetCmdString('X:', clUpcase, S); returns True and S contains 'DELETE'
  GetCmdString('X:', clUpcase or clNext or clValueCase, S); returns True and S contains 'Insert'
  GetCmdString('X:', clUpcase or clNext, S); returns True and S contains 'UPDATE'
  GetCmdString('X:', clUpcase or clNext, S); returns False and S unchanged
  GetCmdString('', 0, S); returns True and S contains 'FILE.TXT'
  GetCmdString('', clNext, S); returns True and S contains 'FILE2.TXT'
  IsThereCmd('INS', clUpcase); returns True
  IsThereCmd('X:', clUpcase); returns True
}

implementation
uses
  SysUtils;
  
function IsThereCmd;
var
  Flag:Boolean;
  S:string;
begin
  if (Option and clNext)=0 then
    WhereCmd:=1;
  Flag:=True;
  if (Option and clCaseSensitive)=0 then
    Cmd:=UpperCase(Cmd);
  while Flag and (WhereCmd<=ParamCount) do
  begin
    S:=ParamStr(WhereCmd);
    if S[1] in PrefixChars then
      begin
        if Cmd<>'' then
        begin
          if (Option and clCaseSensitive)=0 then Flag:=Cmd<>UpperCase(Copy(S,2,Length(Cmd)))
                                            else Flag:=Cmd<>Copy(S,2,Length(Cmd));
        end;
      end
    else
      Flag:=Cmd<>'';
    if Flag then
      Inc(WhereCmd);
  end;
  IsThereCmd:=not Flag;
end;

function GetCmdString;
var
  Flag:Boolean;
begin
  Flag:=IsThereCmd(Cmd,Option);
  if Flag then
  begin
    S:=ParamStr(WhereCmd);
    if Cmd<>'' then Delete(S,1,1+Length(Cmd));
    if Option and clValueCase = 0 then
      if (Option and clUpCase) <> 0 then S:=UpperCase(S)
      else if (Option and clLoCase) <> 0 then S:=LowerCase(S);
  end;
  GetCmdString:=Flag;
end;

end.
