// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'MathItem.pas' rev: 3.00

#ifndef MathItemHPP
#define MathItemHPP
#include <Classes.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Mathitem
{
//-- type declarations -------------------------------------------------------
enum TDumpFormatFlag { dfDetailed, dfQualified };

typedef Set<TDumpFormatFlag, dfDetailed, dfQualified>  TDumpFormat;

class DELPHICLASS TMItem;
class DELPHICLASS TMItems;
class PASCALIMPLEMENTATION TMItem : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FParsePosition;
	
protected:
	/*         class method */ static System::AnsiString __fastcall DumpList(System::TMetaClass* vmt, const 
		TMItems* Items, const TDumpFormat DumpFormat);
	/*         class method */ static System::AnsiString __fastcall QuotedVar(System::TMetaClass* vmt, 
		const System::Variant &V);
	
public:
	__fastcall virtual TMItem(void);
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	
__published:
	__property int ParsePosition = {read=FParsePosition, write=FParsePosition, nodefault};
public:
	/* TObject.Destroy */ __fastcall virtual ~TMItem(void) { }
	
};

class DELPHICLASS TMValue;
class PASCALIMPLEMENTATION TMValue : public Mathitem::TMItem 
{
	typedef Mathitem::TMItem inherited;
	
protected:
	virtual void __fastcall SetValue(const System::Variant &Value);
	virtual System::Variant __fastcall GetValue(void) = 0;
	
__published:
	__property System::Variant Value = {read=GetValue, write=SetValue};
public:
	/* TMItem.Create */ __fastcall virtual TMValue(void) : Mathitem::TMItem() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMValue(void) { }
	
};

class DELPHICLASS TMSymbol;
class DELPHICLASS TMSymbols;
class DELPHICLASS TMValues;
class PASCALIMPLEMENTATION TMItems : public Classes::TList 
{
	typedef Classes::TList inherited;
	
public:
	System::AnsiString __fastcall Dump(const System::AnsiString Delimiter, const TDumpFormat DumpFormat
		);
	void __fastcall FreeAndClear(void);
	TMItem* __fastcall Pop(void);
	void __fastcall PullFromStack1(TMItems* Stack1, TMSymbols* Symbols);
	void __fastcall Reverse(void);
public:
	/* TList.Destroy */ __fastcall virtual ~TMItems(void) { }
	
public:
	/* TObject.Create */ __fastcall TMItems(void) : Classes::TList() { }
	
};

class PASCALIMPLEMENTATION TMValues : public Mathitem::TMItems 
{
	typedef Mathitem::TMItems inherited;
	
public:
	/* TList.Destroy */ __fastcall virtual ~TMValues(void) { }
	
public:
	/* TObject.Create */ __fastcall TMValues(void) : Mathitem::TMItems() { }
	
};

class PASCALIMPLEMENTATION TMSymbols : public Mathitem::TMValues 
{
	typedef Mathitem::TMValues inherited;
	
public:
	Classes::TComponent* MathInterpreter;
	TMSymbol* __fastcall FindSymbol(const System::AnsiString SymbolName, const bool BinarySearch);
	int __fastcall FindSymbolIndex(const System::AnsiString SymbolName, const bool BinarySearch);
	bool __fastcall SymbolExists(const System::AnsiString SymbolName, const bool BinarySearch);
public:
	/* TList.Destroy */ __fastcall virtual ~TMSymbols(void) { }
	
public:
	/* TObject.Create */ __fastcall TMSymbols(void) : Mathitem::TMValues() { }
	
};

class PASCALIMPLEMENTATION TMSymbol : public Mathitem::TMValue 
{
	typedef Mathitem::TMValue inherited;
	
private:
	System::AnsiString FIdentifier;
	TMSymbols* FList;
	bool FUpdateReferences;
	
protected:
	virtual void __fastcall SetIdentifier(const System::AnsiString Value);
	
public:
	__fastcall virtual ~TMSymbol(void);
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	bool __fastcall IsEqualIdentifier(const System::AnsiString S);
	
__published:
	__property System::AnsiString Identifier = {read=FIdentifier, write=SetIdentifier};
	__property TMSymbols* List = {read=FList, write=FList};
	__property bool UpdateReferences = {read=FUpdateReferences, write=FUpdateReferences, nodefault};
public:
		
	/* TMItem.Create */ __fastcall virtual TMSymbol(void) : Mathitem::TMValue() { }
	
};

class DELPHICLASS TMCustomVar;
class PASCALIMPLEMENTATION TMCustomVar : public Mathitem::TMSymbol 
{
	typedef Mathitem::TMSymbol inherited;
	
private:
	System::Variant FValue;
	
protected:
	virtual void __fastcall SetValue(const System::Variant &Value);
	virtual System::Variant __fastcall GetValue();
public:
	/* TMSymbol.Destroy */ __fastcall virtual ~TMCustomVar(void) { }
	
public:
	/* TMItem.Create */ __fastcall virtual TMCustomVar(void) : Mathitem::TMSymbol() { }
	
};

class DELPHICLASS TMVar;
class PASCALIMPLEMENTATION TMVar : public Mathitem::TMCustomVar 
{
	typedef Mathitem::TMCustomVar inherited;
	
public:
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
public:
	/* TMSymbol.Destroy */ __fastcall virtual ~TMVar(void) { }
	
public:
	/* TMItem.Create */ __fastcall virtual TMVar(void) : Mathitem::TMCustomVar() { }
	
};

class DELPHICLASS TMParam;
class PASCALIMPLEMENTATION TMParam : public Mathitem::TMCustomVar 
{
	typedef Mathitem::TMCustomVar inherited;
	
public:
	/* TMSymbol.Destroy */ __fastcall virtual ~TMParam(void) { }
	
public:
	/* TMItem.Create */ __fastcall virtual TMParam(void) : Mathitem::TMCustomVar() { }
	
};

class DELPHICLASS TMCustomFunction;
class DELPHICLASS TMParams;
class DELPHICLASS TMFunction;
class PASCALIMPLEMENTATION TMCustomFunction : public Mathitem::TMSymbol 
{
	typedef Mathitem::TMSymbol inherited;
	
private:
	TMParams* FParameters;
	
__published:
	__property TMParams* Parameters = {read=FParameters};
public:
	/* TMSymbol.Destroy */ __fastcall virtual ~TMCustomFunction(void) { }
	
public:
	/* TMItem.Create */ __fastcall virtual TMCustomFunction(void) : Mathitem::TMSymbol() { }
	
};

class DELPHICLASS TMExpression;
class PASCALIMPLEMENTATION TMExpression : public Mathitem::TMValue 
{
	typedef Mathitem::TMValue inherited;
	
public:
	virtual void __fastcall Rewire(const TMSymbol* Symbol) = 0;
	virtual void __fastcall Unwire(const TMSymbol* Symbol) = 0;
	virtual void __fastcall RewireSymbols(const TMSymbols* Symbols);
	virtual void __fastcall SetMathInterpreter(System::TObject* MI);
public:
	/* TMItem.Create */ __fastcall virtual TMExpression(void) : Mathitem::TMValue() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMExpression(void) { }
	
};

class PASCALIMPLEMENTATION TMFunction : public Mathitem::TMCustomFunction 
{
	typedef Mathitem::TMCustomFunction inherited;
	
private:
	TMExpression* FExpression;
	void __fastcall SetExpression(const TMExpression* Value);
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	__fastcall virtual TMFunction(void);
	__fastcall virtual ~TMFunction(void);
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	
__published:
	__property TMExpression* Expression = {read=FExpression, write=SetExpression};
};

class PASCALIMPLEMENTATION TMParams : public Mathitem::TMSymbols 
{
	typedef Mathitem::TMSymbols inherited;
	
private:
	TMFunction* FFunc;
	
public:
	bool __fastcall ParamExists(const System::AnsiString ParamName);
	
__published:
	__property TMFunction* Func = {read=FFunc, write=FFunc};
public:
	/* TList.Destroy */ __fastcall virtual ~TMParams(void) { }
	
public:
	/* TObject.Create */ __fastcall TMParams(void) : Mathitem::TMSymbols() { }
	
};


class DELPHICLASS TMLiteral;
class PASCALIMPLEMENTATION TMLiteral : public Mathitem::TMExpression 
{
	typedef Mathitem::TMExpression inherited;
	
private:
	System::Variant FValue;
	
protected:
	virtual void __fastcall SetValue(const System::Variant &Value);
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	virtual void __fastcall Rewire(const TMSymbol* Symbol);
	virtual void __fastcall Unwire(const TMSymbol* Symbol);
public:
	/* TMItem.Create */ __fastcall virtual TMLiteral(void) : Mathitem::TMExpression() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMLiteral(void) { }
	
};

class DELPHICLASS TMReference;
class PASCALIMPLEMENTATION TMReference : public Mathitem::TMExpression 
{
	typedef Mathitem::TMExpression inherited;
	
private:
	TMSymbol* FSymbolReference;
	System::AnsiString FReferencedSymbolName;
	
protected:
	System::TObject* FMathInterpreter;
	virtual void __fastcall SetValue(const System::Variant &Value);
	
public:
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	virtual void __fastcall Rewire(const TMSymbol* Symbol);
	virtual void __fastcall Unwire(const TMSymbol* Symbol);
	virtual void __fastcall SetMathInterpreter(System::TObject* MI);
	
__published:
	__property TMSymbol* SymbolReference = {read=FSymbolReference, write=FSymbolReference, stored=false
		};
	__property System::AnsiString ReferencedSymbolName = {read=FReferencedSymbolName, write=FReferencedSymbolName
		};
public:
	/* TMItem.Create */ __fastcall virtual TMReference(void) : Mathitem::TMExpression() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMReference(void) { }
	
};

class DELPHICLASS TMSymbolRef;
class PASCALIMPLEMENTATION TMSymbolRef : public Mathitem::TMReference 
{
	typedef Mathitem::TMReference inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMSymbolRef(void) : Mathitem::TMReference() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMSymbolRef(void) { }
	
};

class DELPHICLASS TMVarRef;
class PASCALIMPLEMENTATION TMVarRef : public Mathitem::TMSymbolRef 
{
	typedef Mathitem::TMSymbolRef inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual void __fastcall Rewire(const TMSymbol* Symbol);
public:
	/* TMItem.Create */ __fastcall virtual TMVarRef(void) : Mathitem::TMSymbolRef() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMVarRef(void) { }
	
};

class DELPHICLASS TMFunctionCall;
class DELPHICLASS TMParamExpressions;
class PASCALIMPLEMENTATION TMParamExpressions : public Mathitem::TMValues 
{
	typedef Mathitem::TMValues inherited;
	
public:
	/* TList.Destroy */ __fastcall virtual ~TMParamExpressions(void) { }
	
public:
	/* TObject.Create */ __fastcall TMParamExpressions(void) : Mathitem::TMValues() { }
	
};

class PASCALIMPLEMENTATION TMFunctionCall : public Mathitem::TMSymbolRef 
{
	typedef Mathitem::TMSymbolRef inherited;
	
private:
	TMParamExpressions* FParamExpressions;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	__fastcall virtual TMFunctionCall(void);
	__fastcall virtual ~TMFunctionCall(void);
	void __fastcall PullParamExpressions(TMItems* Stack, TMSymbols* Symbols);
	virtual void __fastcall Rewire(const TMSymbol* Symbol);
	virtual void __fastcall Unwire(const TMSymbol* Symbol);
	virtual void __fastcall SetMathInterpreter(System::TObject* MI);
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	
__published:
	__property TMParamExpressions* ParamExpressions = {read=FParamExpressions};
};

class DELPHICLASS TMParamExpression;
class PASCALIMPLEMENTATION TMParamExpression : public Mathitem::TMExpression 
{
	typedef Mathitem::TMExpression inherited;
	
private:
	TMExpression* FExpression;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	__fastcall virtual ~TMParamExpression(void);
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	virtual void __fastcall Rewire(const TMSymbol* Symbol);
	virtual void __fastcall Unwire(const TMSymbol* Symbol);
	virtual void __fastcall SetMathInterpreter(System::TObject* MI);
	
__published:
	__property TMExpression* Expression = {read=FExpression, write=FExpression};
public:
	/* TMItem.Create */ __fastcall virtual TMParamExpression(void) : Mathitem::TMExpression() { }
	
};

enum TOperatorPriority { opSuper, opUnaryOperator, opPower, opMultiply, opPlus, opRelation, opBoolean, 
	opAssign };

enum TOperatorAssociativity { oaLeftToRight, oaRightToLeft };

class DELPHICLASS TMOperator;
class DELPHICLASS TMExpressions;
class PASCALIMPLEMENTATION TMExpressions : public Mathitem::TMValues 
{
	typedef Mathitem::TMValues inherited;
	
public:
	/* TList.Destroy */ __fastcall virtual ~TMExpressions(void) { }
	
public:
	/* TObject.Create */ __fastcall TMExpressions(void) : Mathitem::TMValues() { }
	
};

class PASCALIMPLEMENTATION TMOperator : public Mathitem::TMExpression 
{
	typedef Mathitem::TMExpression inherited;
	
private:
	TMExpressions* FOperands;
	TMExpression* __fastcall GetOperandExpressions(int OperandIndex);
	System::Variant __fastcall GetOperandValues(int OperandIndex);
	
protected:
	System::AnsiString __fastcall DumpOperand(const int OperandIndex, const TDumpFormat DumpFormat);
	virtual System::AnsiString __fastcall DumpOperator(void) = 0;
	virtual int __fastcall NumberOfOperands(void) = 0;
	virtual void __fastcall CheckOperatorCount(void);
	virtual void __fastcall SetOperands(const TMExpressions* Value);
	
public:
	__fastcall virtual TMOperator(void);
	__fastcall virtual ~TMOperator(void);
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	virtual TOperatorAssociativity __fastcall Associativity(void) = 0;
	virtual TOperatorPriority __fastcall Priority(void) = 0;
	virtual void __fastcall Rewire(const TMSymbol* Symbol);
	virtual void __fastcall Unwire(const TMSymbol* Symbol);
	virtual void __fastcall SetMathInterpreter(System::TObject* MI);
	virtual void __fastcall PullOperands(TMItems* Stack, TMSymbols* Symbols);
	__property TMExpression* OperandExpressions[int OperandIndex] = {read=GetOperandExpressions};
	__property System::Variant OperandValues[int OperandIndex] = {read=GetOperandValues};
	
__published:
	__property TMExpressions* Operands = {read=FOperands, write=SetOperands};
};

class DELPHICLASS TMUnaryOperator;
class PASCALIMPLEMENTATION TMUnaryOperator : public Mathitem::TMOperator 
{
	typedef Mathitem::TMOperator inherited;
	
protected:
	virtual int __fastcall NumberOfOperands(void);
	
public:
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	virtual TOperatorPriority __fastcall Priority(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMUnaryOperator(void) : Mathitem::TMOperator() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMUnaryOperator(void) { }
	
};

class DELPHICLASS TMUnaryPrefixOperator;
class PASCALIMPLEMENTATION TMUnaryPrefixOperator : public Mathitem::TMUnaryOperator 
{
	typedef Mathitem::TMUnaryOperator inherited;
	
public:
	virtual TOperatorAssociativity __fastcall Associativity(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMUnaryPrefixOperator(void) : Mathitem::TMUnaryOperator(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMUnaryPrefixOperator(void) { }
	
};

class DELPHICLASS TMUnaryMinus;
class PASCALIMPLEMENTATION TMUnaryMinus : public Mathitem::TMUnaryPrefixOperator 
{
	typedef Mathitem::TMUnaryPrefixOperator inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMUnaryMinus(void) : Mathitem::TMUnaryPrefixOperator() { }
		
	/* TMOperator.Destroy */ __fastcall virtual ~TMUnaryMinus(void) { }
	
};

class DELPHICLASS TMNot;
class PASCALIMPLEMENTATION TMNot : public Mathitem::TMUnaryPrefixOperator 
{
	typedef Mathitem::TMUnaryPrefixOperator inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMNot(void) : Mathitem::TMUnaryPrefixOperator() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMNot(void) { }
	
};

class DELPHICLASS TMBinaryOperator;
class PASCALIMPLEMENTATION TMBinaryOperator : public Mathitem::TMOperator 
{
	typedef Mathitem::TMOperator inherited;
	
protected:
	virtual int __fastcall NumberOfOperands(void);
	
public:
	virtual System::AnsiString __fastcall Dump(const TDumpFormat DumpFormat);
	TMExpression* __fastcall LeftOperand(void);
	TMExpression* __fastcall RightOperand(void);
	System::Variant __fastcall LeftOperandValue();
	System::Variant __fastcall RightOperandValue();
public:
	/* TMOperator.Create */ __fastcall virtual TMBinaryOperator(void) : Mathitem::TMOperator() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMBinaryOperator(void) { }
	
};

class DELPHICLASS TMLeftToRightAssociative;
class PASCALIMPLEMENTATION TMLeftToRightAssociative : public Mathitem::TMBinaryOperator 
{
	typedef Mathitem::TMBinaryOperator inherited;
	
public:
	virtual TOperatorAssociativity __fastcall Associativity(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMLeftToRightAssociative(void) : Mathitem::TMBinaryOperator(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMLeftToRightAssociative(void) { }
	
};

class DELPHICLASS TMBinaryOperatorBoolean;
class PASCALIMPLEMENTATION TMBinaryOperatorBoolean : public Mathitem::TMLeftToRightAssociative 
{
	typedef Mathitem::TMLeftToRightAssociative inherited;
	
public:
	HIDESBASE System::Variant __fastcall LeftOperandValue();
	HIDESBASE System::Variant __fastcall RightOperandValue();
	virtual TOperatorPriority __fastcall Priority(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMBinaryOperatorBoolean(void) : Mathitem::TMLeftToRightAssociative(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMBinaryOperatorBoolean(void) { }
	
};

class DELPHICLASS TMAnd;
class PASCALIMPLEMENTATION TMAnd : public Mathitem::TMBinaryOperatorBoolean 
{
	typedef Mathitem::TMBinaryOperatorBoolean inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMAnd(void) : Mathitem::TMBinaryOperatorBoolean() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMAnd(void) { }
	
};

class DELPHICLASS TMOr;
class PASCALIMPLEMENTATION TMOr : public Mathitem::TMBinaryOperatorBoolean 
{
	typedef Mathitem::TMBinaryOperatorBoolean inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMOr(void) : Mathitem::TMBinaryOperatorBoolean() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMOr(void) { }
	
};

class DELPHICLASS TMXor;
class PASCALIMPLEMENTATION TMXor : public Mathitem::TMBinaryOperatorBoolean 
{
	typedef Mathitem::TMBinaryOperatorBoolean inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMXor(void) : Mathitem::TMBinaryOperatorBoolean() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMXor(void) { }
	
};

class DELPHICLASS TMShl;
class PASCALIMPLEMENTATION TMShl : public Mathitem::TMBinaryOperatorBoolean 
{
	typedef Mathitem::TMBinaryOperatorBoolean inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMShl(void) : Mathitem::TMBinaryOperatorBoolean() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMShl(void) { }
	
};

class DELPHICLASS TMShr;
class PASCALIMPLEMENTATION TMShr : public Mathitem::TMBinaryOperatorBoolean 
{
	typedef Mathitem::TMBinaryOperatorBoolean inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMShr(void) : Mathitem::TMBinaryOperatorBoolean() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMShr(void) { }
	
};

class DELPHICLASS TMBinaryOperatorRelation;
class PASCALIMPLEMENTATION TMBinaryOperatorRelation : public Mathitem::TMLeftToRightAssociative 
{
	typedef Mathitem::TMLeftToRightAssociative inherited;
	
public:
	virtual TOperatorPriority __fastcall Priority(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMBinaryOperatorRelation(void) : Mathitem::TMLeftToRightAssociative(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMBinaryOperatorRelation(void) { }
	
};

class DELPHICLASS TMLess;
class PASCALIMPLEMENTATION TMLess : public Mathitem::TMBinaryOperatorRelation 
{
	typedef Mathitem::TMBinaryOperatorRelation inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMLess(void) : Mathitem::TMBinaryOperatorRelation() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMLess(void) { }
	
};

class DELPHICLASS TMLessOrEqual;
class PASCALIMPLEMENTATION TMLessOrEqual : public Mathitem::TMBinaryOperatorRelation 
{
	typedef Mathitem::TMBinaryOperatorRelation inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMLessOrEqual(void) : Mathitem::TMBinaryOperatorRelation(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMLessOrEqual(void) { }
	
};

class DELPHICLASS TMEqual;
class PASCALIMPLEMENTATION TMEqual : public Mathitem::TMBinaryOperatorRelation 
{
	typedef Mathitem::TMBinaryOperatorRelation inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMEqual(void) : Mathitem::TMBinaryOperatorRelation() { }
		
	/* TMOperator.Destroy */ __fastcall virtual ~TMEqual(void) { }
	
};

class DELPHICLASS TMLargerOrEqual;
class PASCALIMPLEMENTATION TMLargerOrEqual : public Mathitem::TMBinaryOperatorRelation 
{
	typedef Mathitem::TMBinaryOperatorRelation inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMLargerOrEqual(void) : Mathitem::TMBinaryOperatorRelation(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMLargerOrEqual(void) { }
	
};

class DELPHICLASS TMLarger;
class PASCALIMPLEMENTATION TMLarger : public Mathitem::TMBinaryOperatorRelation 
{
	typedef Mathitem::TMBinaryOperatorRelation inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMLarger(void) : Mathitem::TMBinaryOperatorRelation() { }
		
	/* TMOperator.Destroy */ __fastcall virtual ~TMLarger(void) { }
	
};

class DELPHICLASS TMNotEqual;
class PASCALIMPLEMENTATION TMNotEqual : public Mathitem::TMBinaryOperatorRelation 
{
	typedef Mathitem::TMBinaryOperatorRelation inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMNotEqual(void) : Mathitem::TMBinaryOperatorRelation() { }
		
	/* TMOperator.Destroy */ __fastcall virtual ~TMNotEqual(void) { }
	
};

class DELPHICLASS TMBinaryOperatorAddition;
class PASCALIMPLEMENTATION TMBinaryOperatorAddition : public Mathitem::TMLeftToRightAssociative 
{
	typedef Mathitem::TMLeftToRightAssociative inherited;
	
public:
	virtual TOperatorPriority __fastcall Priority(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMBinaryOperatorAddition(void) : Mathitem::TMLeftToRightAssociative(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMBinaryOperatorAddition(void) { }
	
};

class DELPHICLASS TMPlus;
class PASCALIMPLEMENTATION TMPlus : public Mathitem::TMBinaryOperatorAddition 
{
	typedef Mathitem::TMBinaryOperatorAddition inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMPlus(void) : Mathitem::TMBinaryOperatorAddition() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMPlus(void) { }
	
};

class DELPHICLASS TMMinus;
class PASCALIMPLEMENTATION TMMinus : public Mathitem::TMBinaryOperatorAddition 
{
	typedef Mathitem::TMBinaryOperatorAddition inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMMinus(void) : Mathitem::TMBinaryOperatorAddition() { }
		
	/* TMOperator.Destroy */ __fastcall virtual ~TMMinus(void) { }
	
};

class DELPHICLASS TMBinaryOperatorMultiplication;
class PASCALIMPLEMENTATION TMBinaryOperatorMultiplication : public Mathitem::TMLeftToRightAssociative 
	
{
	typedef Mathitem::TMLeftToRightAssociative inherited;
	
public:
	virtual TOperatorPriority __fastcall Priority(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMBinaryOperatorMultiplication(void) : Mathitem::TMLeftToRightAssociative(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMBinaryOperatorMultiplication(void) { }
	
};

class DELPHICLASS TMMultiply;
class PASCALIMPLEMENTATION TMMultiply : public Mathitem::TMBinaryOperatorMultiplication 
{
	typedef Mathitem::TMBinaryOperatorMultiplication inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMMultiply(void) : Mathitem::TMBinaryOperatorMultiplication(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMMultiply(void) { }
	
};

class DELPHICLASS TMDivide;
class PASCALIMPLEMENTATION TMDivide : public Mathitem::TMBinaryOperatorMultiplication 
{
	typedef Mathitem::TMBinaryOperatorMultiplication inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMDivide(void) : Mathitem::TMBinaryOperatorMultiplication(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMDivide(void) { }
	
};

class DELPHICLASS TMIntDiv;
class PASCALIMPLEMENTATION TMIntDiv : public Mathitem::TMBinaryOperatorMultiplication 
{
	typedef Mathitem::TMBinaryOperatorMultiplication inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMIntDiv(void) : Mathitem::TMBinaryOperatorMultiplication(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMIntDiv(void) { }
	
};

class DELPHICLASS TMMod;
class PASCALIMPLEMENTATION TMMod : public Mathitem::TMBinaryOperatorMultiplication 
{
	typedef Mathitem::TMBinaryOperatorMultiplication inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMMod(void) : Mathitem::TMBinaryOperatorMultiplication()
		 { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMMod(void) { }
	
};

class DELPHICLASS TMPower;
class PASCALIMPLEMENTATION TMPower : public Mathitem::TMLeftToRightAssociative 
{
	typedef Mathitem::TMLeftToRightAssociative inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual System::AnsiString __fastcall DumpOperator();
	virtual TOperatorPriority __fastcall Priority(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMPower(void) : Mathitem::TMLeftToRightAssociative() { }
		
	/* TMOperator.Destroy */ __fastcall virtual ~TMPower(void) { }
	
};

class DELPHICLASS TMRightToLeftAssociative;
class PASCALIMPLEMENTATION TMRightToLeftAssociative : public Mathitem::TMBinaryOperator 
{
	typedef Mathitem::TMBinaryOperator inherited;
	
public:
	virtual TOperatorAssociativity __fastcall Associativity(void);
public:
	/* TMOperator.Create */ __fastcall virtual TMRightToLeftAssociative(void) : Mathitem::TMBinaryOperator(
		) { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMRightToLeftAssociative(void) { }
	
};

class DELPHICLASS TMAssign;
class PASCALIMPLEMENTATION TMAssign : public Mathitem::TMRightToLeftAssociative 
{
	typedef Mathitem::TMRightToLeftAssociative inherited;
	
public:
	virtual TOperatorPriority __fastcall Priority(void);
	virtual System::AnsiString __fastcall DumpOperator();
public:
	/* TMOperator.Create */ __fastcall virtual TMAssign(void) : Mathitem::TMRightToLeftAssociative() { }
		
	/* TMOperator.Destroy */ __fastcall virtual ~TMAssign(void) { }
	
};

class DELPHICLASS TMAssignValue;
class PASCALIMPLEMENTATION TMAssignValue : public Mathitem::TMAssign 
{
	typedef Mathitem::TMAssign inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual void __fastcall PullOperands(TMItems* Stack, TMSymbols* Symbols);
public:
	/* TMOperator.Create */ __fastcall virtual TMAssignValue(void) : Mathitem::TMAssign() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMAssignValue(void) { }
	
};

class DELPHICLASS TMAssignSymbolic;
class PASCALIMPLEMENTATION TMAssignSymbolic : public Mathitem::TMAssign 
{
	typedef Mathitem::TMAssign inherited;
	
protected:
	virtual System::Variant __fastcall GetValue();
	
public:
	virtual void __fastcall PullOperands(TMItems* Stack, TMSymbols* Symbols);
public:
	/* TMOperator.Create */ __fastcall virtual TMAssignSymbolic(void) : Mathitem::TMAssign() { }
	/* TMOperator.Destroy */ __fastcall virtual ~TMAssignSymbolic(void) { }
	
};

class DELPHICLASS TMParseItem;
class PASCALIMPLEMENTATION TMParseItem : public Mathitem::TMItem 
{
	typedef Mathitem::TMItem inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMParseItem(void) : Mathitem::TMItem() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMParseItem(void) { }
	
};

class DELPHICLASS TMComma;
class PASCALIMPLEMENTATION TMComma : public Mathitem::TMParseItem 
{
	typedef Mathitem::TMParseItem inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMComma(void) : Mathitem::TMParseItem() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMComma(void) { }
	
};

class DELPHICLASS TMLeftBracket;
class PASCALIMPLEMENTATION TMLeftBracket : public Mathitem::TMParseItem 
{
	typedef Mathitem::TMParseItem inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMLeftBracket(void) : Mathitem::TMParseItem() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMLeftBracket(void) { }
	
};

class DELPHICLASS TMRightBracket;
class PASCALIMPLEMENTATION TMRightBracket : public Mathitem::TMParseItem 
{
	typedef Mathitem::TMParseItem inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMRightBracket(void) : Mathitem::TMParseItem() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMRightBracket(void) { }
	
};

class DELPHICLASS TMKeyword;
class PASCALIMPLEMENTATION TMKeyword : public Mathitem::TMParseItem 
{
	typedef Mathitem::TMParseItem inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMKeyword(void) : Mathitem::TMParseItem() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMKeyword(void) { }
	
};

class DELPHICLASS TMDelete;
class PASCALIMPLEMENTATION TMDelete : public Mathitem::TMKeyword 
{
	typedef Mathitem::TMKeyword inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMDelete(void) : Mathitem::TMKeyword() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMDelete(void) { }
	
};

class DELPHICLASS TMRename;
class PASCALIMPLEMENTATION TMRename : public Mathitem::TMKeyword 
{
	typedef Mathitem::TMKeyword inherited;
	
public:
	/* TMItem.Create */ __fastcall virtual TMRename(void) : Mathitem::TMKeyword() { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~TMRename(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Mathitem */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Mathitem;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// MathItem
